/*	
 *	clipfpk.h
 *
 *	t@CpbN`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Tue Jan 06 21:26:41 JST 2015 Naoyuki Sawa
 *	- VK쐬B
 *	- t@CpbN`֘A̐錾Aclipmisc.hclipfpk.h֕܂B
 *	  t@CpbN`֘A̎͊ɁAclipmisc.cclipfpk.c֕Ă̂ŁA񕪗̂͐錾݂̂łB
 *	  錾邱ƂɂŔA錾Ǝ̃t@C̑ΉtAՂ邽߂łB
 */
#ifndef __CLIP_FPK_H__
#define __CLIP_FPK_H__

/*****************************************************************************
 *	[eBeBFt@CpbN`
 *****************************************************************************/

/*                           0 +-----------------------------+
 *                             | FILE_PAC_INFO               |
 *                             +-----------------------------+
 *                             | FILE_INFO[0]                |
 *                             +-----------------------------+
 *                             | FILE_INFO[1]                |
 *                             +-----------------------------+
 *                             =                             =
 *                             +-----------------------------+
 *                             | FILE_INFO[famount-1]        |
 *         FILE_INFO[0].offset +-----------------------------+|
 *                             |                             |
 *                             | t@C[0]̃f[^         |bFILE_INFO[0].size + 3 & ~3
 *                             |                             |
 *         FILE_INFO[1].offset +-----------------------------+|
 *                             |                             |
 *                             | t@C[1]̃f[^         |bFILE_INFO[1].size + 3 & ~3
 *                             |                             |
 *                             +-----------------------------+|
 *                             =                             =
 * FILE_INFO[famount-1].offset +-----------------------------+|
 *                             |                             |
 *                             | t@C[famount-1]̃f[^ |bFILE_INFO[famount-1].size
 *                             |                             |
 *                             +-----------------------------+|
 */
#define FILE_PAC_INFO_HEAD	 ('F' << 24 | 'P' << 16 | 'A' << 8 | 'K')
typedef struct _FILE_PAC_INFO {	/* t@CpbN                   */
	unsigned long head;	/* VOl`('FPAK'ŒBт"KAPF") */
	long famount;		/* t@C                           */
} FILE_PAC_INFO;
typedef struct _FILE_INFO {	/* t@C                         */
	char fname[16];		/* t@C                           */
	unsigned long offset;	/* ItZbg(fpkt@C擪0Ƃ) */
	unsigned long size;	/* t@CTCY                       */
} FILE_INFO;

/* fpkt@C̃t@CTCY擾܂B
 * [in]
 *	fname		fpkt@CB
 *	name		t@CGgB
 * [out]
 *	߂l		t@CTCY[oCg]B
 * [note]
 *	* t@CGǵA啶ʂɔr܂B
 *	* t@CGgȂꍇ́AAT[g܂B
 */
int fpk_size(const char* fname, const char* name);

/* fpkt@C̃t@Cǂݍ݂܂B
 * [in]
 *	fname		fpkt@CB
 *	name		t@CGgB
 *	buffer		obt@AhXB
 *	buflen		obt@TCYB
 * [out]
 *	߂l		ۂɓǂݍ񂾃t@CTCY[oCg]B
 * [note]
 *	* t@CGǵA啶ʂɔr܂B
 *	* t@CGgȂꍇ́AAT[g܂B
 *	* obt@TCYt@CTCY̏ꍇ́AAT[g܂B
 */
int fpk_load(const char* fname, const char* name, void* buffer, int buflen);

/*****************************************************************************
 *	[eBeBFIt@CpbN`
 *****************************************************************************/

/* Ifpk̃t@C擪AhX擾܂B
 * [in]
 *	fpk		Ifpk̐擪AhXB
 *	name		t@CGgB
 *	size		t@CTCYi[ϐւ̃|C^B
 *			NULLw肷ƃt@CTCY͊i[܂B
 * [out]
 *	߂l		ۂɓǂݍ񂾃t@CTCY[oCg]B
 * [note]
 *	* t@CGǵA啶ʂɔr܂B
 *	* t@CGgȂꍇ́AAT[g܂B
 */
const void* fpk_address(const void* fpk, const char* name, int* size);

#endif//__CLIP_FPK_H__
