/*	
 *	clipfpk.c
 *
 *	t@CpbN`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2008 Naoyuki Sawa
 *
 *	* Wed Nov 30 22:35:00 JST 2005 Naoyuki Sawa
 *	- t@CpbN`AIt@CpbN`́AppxႢ̂ŁA
 *	  R[hTCYߖ̂߂ɁAclipmisc.cclipfpk.c֕܂B
 *	* Wed Aug 06 23:14:45 JST 2008 Naoyuki Sawa
 *	- FilePack[eBeB[(tool/dfpck)t@CɑΉƂɒǏ]A
 *	  t@C悤ɑΉ܂B
 *	- R[hTCY팸̂߁At@C\Ăꍇ̑΍͍sĂ܂B
 *	  Ƃ΁AFILE_PAC_INFO.fname[]̃t@CnulI[ĂȂA
 *	  ɒ[ɒ߂t@Cstrcat()I[o[t[΍͍sĂ܂B
 */
#include "clip.h"

/*****************************************************************************
 *	[eBeBFt@CpbN`
 *****************************************************************************/

static int
fpk_find(FILE* fp, const char* name, FILE_INFO* fi)
{
	int retval, i;
	FILE_PAC_INFO pi;
//{{2008/08/06:t@CΉ:ǉ
	char fname[256/*_MAX_FNAME*/]; /* t@C */
//}}2008/08/06:t@CΉ:ǉ

	/* fpkǂ݂܂B */
	/* ĂяoɃt@Cʒu擪ł邱ƁB̊֐rewind()܂B */
	retval = fread(&pi, 1, sizeof pi, fp);
	if(retval != sizeof pi) DIE();
	if(pi.head != FILE_PAC_INFO_HEAD) DIE(); /* VOl` */

	/* t@C𑖍āc */
//{{2008/08/06:t@CΉ:ǉ
	fname[0] = '\0'; /* t@CZbg */
//}}2008/08/06:t@CΉ:ǉ
	for(i = 0; i < pi.famount; i++) {
		/* t@Cǂ݂܂B */
		retval = fread(fi, 1, sizeof *fi, fp);
		if(retval != sizeof *fi) DIE();

		/* H */
//{{2008/08/06:t@CΉ:ύX
//		if(strncasecmp(fi->fname, name, sizeof fi->fname) == 0) break;
//2008/08/06:t@CΉ:ύX
		strcat(fname, fi->fname); /* t@CA */
		if(fi->size) { /* Gg (size>0) */
			if(strcasecmp(fname, name) == 0) break;
			fname[0] = '\0'; /* t@CZbg */
		}
//}}2008/08/06:t@CΉ:ύX
	}

	return i < pi.famount; /* 1:/0:Ȃ */
}

int
fpk_size(const char* fname, const char* name)
{
	int retval;
	FILE* fp;
	FILE_INFO fi;

	/* fpkt@CJ܂B */
	fp = fopen(fname, "rb");
	if(fp == NULL) DIE();

	/* t@CT܂B */
	retval = fpk_find(fp, name, &fi);
	if(!retval) DIE();

	/* fpkt@C܂B */
	fclose(fp);

	return fi.size;
}

int
fpk_load(const char* fname, const char* name, void* buffer, int buflen)
{
	int retval;
	FILE* fp;
	FILE_INFO fi;

	/* fpkt@CJ܂B */
	fp = fopen(fname, "rb");
	if(fp == NULL) DIE();

	/* t@CT܂B */
	retval = fpk_find(fp, name, &fi);
	if(!retval) DIE();
	if((int)fi.size > buflen) DIE(); /* obt@s */

	/* t@Cǂݍ݂܂B */
	retval = fseek(fp, fi.offset, SEEK_SET);
	if(retval != 0) DIE();
	retval = fread(buffer, 1, fi.size, fp);
	if(retval != (int)fi.size) DIE();

	/* fpkt@C܂B */
	fclose(fp);

	return fi.size; /* ǂݍ񂾃TCYԂ܂ */
}

/*****************************************************************************
 *	[eBeBFIt@CpbN`
 *****************************************************************************/

const void*
fpk_address(const void* fpk, const char* name, int* size)
{
	int i;
	unsigned char* base;
	FILE_PAC_INFO* pi;
	FILE_INFO* fi;
//{{2008/08/06:t@CΉ:ǉ
	char fname[256/*_MAX_FNAME*/]; /* t@C */
//}}2008/08/06:t@CΉ:ǉ

	base = (unsigned char*)fpk;

	/* VOl`܂B */
	pi = (FILE_PAC_INFO*)(base + 0);
	if(pi->head != FILE_PAC_INFO_HEAD) DIE();

	/* t@CGgT܂B */
//{{2008/08/06:t@CΉ:ǉ
	fname[0] = '\0'; /* t@CZbg */
//}}2008/08/06:t@CΉ:ǉ
	fi = (FILE_INFO*)(base + sizeof(FILE_PAC_INFO));
	for(i = 0; i < pi->famount; i++) {
//{{2008/08/06:t@CΉ:ύX
//		if(strncasecmp(fi->fname, name, sizeof fi->fname) == 0) break;
//2008/08/06:t@CΉ:ύX
		strcat(fname, fi->fname); /* t@CA */
		if(fi->size) { /* Gg (size>0) */
			if(strcasecmp(fname, name) == 0) break;
			fname[0] = '\0'; /* t@CZbg */
		}
//}}2008/08/06:t@CΉ:ύX
		fi++;
	}
	if(i == pi->famount) DIE();

	/* t@CTCYi[܂B */
	if(size) *size = fi->size;

	/* t@C̐擪AhXԂ܂B */
	return base + fi->offset;
}

