/*	
 *	clipfntx.c
 *
 *	FONTX`惋[`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2009 Naoyuki Sawa
 *
 *	* Sun Jun 28 15:08:23 JST 2009 Naoyuki Sawa
 *	- 1st [XB
 *	* Wed Jul 15 14:51:50 JST 2009 Naoyuki Sawa
 *	- frame_table̖OArender_font_framed_paramɕύXAclippce.cֈڂ܂B
 *	  clippce.cclipfnt8.cg߂łB
 */
#include "clip.h"

/*****************************************************************************
 *	
 *****************************************************************************/

//{{2009/07/15:clippce.cclipfnt8.cg߁AOrender_font_framed_paramɕύXAclippce.cֈڂ܂B
//static const struct {
//	unsigned char x : 2; /* ItZbg */
//	unsigned char y : 2; /* ItZbg */
//	unsigned char c : 4; /* J[Vtg */
//} frame_table[] = {
//	{ 0, 0, 8 }, { 2, 0, 8 }, { 0, 2, 8 }, { 2, 2, 8 }, /* (p̕) */
//	{ 1, 0, 4 }, { 0, 1, 4 }, { 2, 1, 4 }, { 1, 2, 4 }, /* () */
//	{ 1, 1, 0 },                                        /*  */
//};
//}}2009/07/15:clippce.cclipfnt8.cg߁AOrender_font_framed_paramɕύXAclippce.cֈڂ܂B

/*---------------------------------------------------------------------------*/

unsigned short
render_fontx(RENDER* render, int x, int y, unsigned short code, const FONTX* fontx, int color)
{
	TEXTURE texture;
	TEXTURE* texture_save;
	int XSize;
	int YSize;
	int CodeType;
	int Tnum;
	int BlockStart;
	int BlockEnd;
	int i;
	const unsigned char* p;

	/* ASCIItHgA܂́AtHgI܂B */
	p = (code <= 0xFF) ? fontx->ascii : fontx->kanji;
	if(!p) {
		return 0; /* tHg */
	}

	/* tHgwb_𒲂ׂ܂B */
	if(memcmp(p, "FONTX2", 6/*Identifier*/)) {
		DIE(); /* tHgs */
	}
	p += 6/*Identifier*/ + 8/*FontName*/;
	XSize = *p++;
	YSize = *p++;
	CodeType = *p++;

	/* ASCIItHg̏ꍇc */
	if(code <= 0xFF) {
		if(CodeType != 0) {
			DIE(); /* ASCIItHgłȂ */
		}
		i = code;

	/* tHg̏ꍇc */
	} else {
		if(CodeType != 1) {
			DIE(); /* tHgłȂ */
		}
		/* R[he[u𒲂ׂ܂B */
		Tnum = *p++;
		i = 0;
		for(;;) {
			if(!Tnum--) {
				return 0; /* tHgp^[ */
			}
			BlockStart = p[0] | p[1] << 8;
			BlockEnd   = p[2] | p[3] << 8;
			p += (2/*BlockStart*/ + 2/*BlockEnd*/);
			if((code >= BlockStart) && (code <= BlockEnd)) {
				i += (code - BlockStart);
				break;
			}
			i += (BlockEnd - BlockStart + 1);
		}
		p += (2/*BlockStart*/ + 2/*BlockEnd*/) * Tnum/*c*/;
	}

	/* tHgp^[eNX`Ƃď܂B
	 * FONTX̃tHgp^[́A:MSBLSB:EA8rbgPʂ0pfBOA
	 * R(?)ɂrbg[x1PIECE_BMPɃpCi݊Ȃ̂ŁÂ܂܎g܂B
	 */
	memset(&texture, 0, sizeof texture);
	texture.header.bpp = 1;
	texture.header.w = (XSize + 7) & ~7;
	texture.header.h =  YSize;
	texture.buf = (unsigned char*)p + ((texture.header.w >> 3) * YSize) * i;

	/* tHgp^[`܂B */
	texture_save = render->context->texture;
	render->context->texture = &texture;
	render_object(render, x, y, 0, 0, XSize, YSize, DRW_CLR(color, COLOR_MASK));
	render->context->texture = texture_save;

	return YSize << 8 | XSize;
}

/*---------------------------------------------------------------------------*/

unsigned int
render_stringx(RENDER* render, int x, int y, const char* str, const FONTX* fontx, int color)
{
	int h, ha, hk, wh;
	int xmin, ymin, xmax, ymax;
	unsigned char c1, c2;
	unsigned short code;
	unsigned char crlf_sel = 0; /* s̏ꍇACR܂LF̐Ɍꂽi[ */

	/* ASCIItHgƊtHĝAAs̍Ƃ܂B */
	ha = fontx->ascii ? ((const unsigned char*)fontx->ascii)[15/*YSize*/] : 0;
	hk = fontx->kanji ? ((const unsigned char*)fontx->kanji)[15/*YSize*/] : 0;
	h = (ha >= hk) ? ha : hk;

	/* `͈͂߂邽߂ɁA܂`ɐݒ肵܂B */
	xmin = xmax = x;
	ymin = ymax = y;

	/* e`悵܂B */
	while((c1 = *str++) != '\0') {
		/* Sp */
		if(ismbblead(c1)) {
			if((c2 = *str++) == '\0') {
				break; /* SprŐ؂Ă */
			}
			code = c1 << 8 | c2;
		/* p */
		} else {
			if((c1 == '\r') || (c1 == '\n')) {	/* CR܂LFȂc */
				if(!crlf_sel) {			/* Ɍꂽc */
					crlf_sel = c1;		/* sR[hƂđI */
				}
				if(c1 == crlf_sel) {		/* IR[hȂc */
					x = xmin;		/* s\͂Ȃ */
					y += h;
				} else {			/* ÎƋtȂc */
					/** no job */		/* s\Ȃ */
				}
				continue;
			}
			code = c1;
		}

		/* `܂B */
		wh = render_fontx(render, x, y, code, fontx, color);
		x += (unsigned char)wh; /* `ʒuE֐i߂ */

		/* `͈͂XV܂B
		 * ۂɕ`ĂXV܂B񖖔̉s͕`͈͂ɉe܂B
		 */
		if(x             > xmax) xmax = x            ;
		if(y + (wh >> 8) > ymax) ymax = y + (wh >> 8);
	}

	return (ymax - ymin) << 16 | (xmax - xmin);
}

/*---------------------------------------------------------------------------*/

/* WJobt@Ƃ_def_vbuff[]𗘗pĂ܂B */
unsigned int
render_printfx(RENDER* render, int x, int y, const FONTX* fontx, int color, const char* fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vsprintf(_def_vbuff, fmt, ap);
	va_end(ap);

	return render_stringx(render, x, y, _def_vbuff, fontx, color);
}

/*---------------------------------------------------------------------------*/

unsigned short
render_fontx_framed(RENDER* render, int x, int y, unsigned short code, const FONTX* fontx, int color)
{
	int wh;
	int i;

//{{2009/07/15:frame_tablerender_font_framed_paramւ̖OύXɒǏ]
//	for(i = 0; i < ARRAY_SIZE(frame_table); i++) {
//		wh = render_fontx(render,
//			x + frame_table[i].x,
//			y + frame_table[i].y,
//			code,
//			fontx,
//			(color >> frame_table[i].c) & 15);
//		if(!wh) {
//			return 0;
//		}
//	}
//2009/07/15:frame_tablerender_font_framed_paramւ̖OύXɒǏ]
	for(i = 0; i < ARRAY_SIZE(render_font_framed_param); i++) {
		wh = render_fontx(render,
			x + render_font_framed_param[i].x,
			y + render_font_framed_param[i].y,
			code,
			fontx,
			(color >> render_font_framed_param[i].c) & 15);
		if(!wh) {
			return 0;
		}
	}
//}}2009/07/15:frame_tablerender_font_framed_paramւ̖OύXɒǏ]

	return wh + 0x0202; /* c2sNZÂ */
}

/*---------------------------------------------------------------------------*/

unsigned int
render_stringx_framed(RENDER* render, int x, int y, const char* str, const FONTX* fontx, int color)
{
	int wh;
	int i;

//{{2009/07/15:frame_tablerender_font_framed_paramւ̖OύXɒǏ]
//	for(i = 0; i < ARRAY_SIZE(frame_table); i++) {
//		wh = render_stringx(render,
//			x + frame_table[i].x,
//			y + frame_table[i].y,
//			str,
//			fontx,
//			(color >> frame_table[i].c) & 15);
//		if(!wh) {
//			return 0;
//		}
//	}
//2009/07/15:frame_tablerender_font_framed_paramւ̖OύXɒǏ]
	for(i = 0; i < ARRAY_SIZE(render_font_framed_param); i++) {
		wh = render_stringx(render,
			x + render_font_framed_param[i].x,
			y + render_font_framed_param[i].y,
			str,
			fontx,
			(color >> render_font_framed_param[i].c) & 15);
		if(!wh) {
			return 0;
		}
	}
//}}2009/07/15:frame_tablerender_font_framed_paramւ̖OύXɒǏ]

	return wh + 0x00020002; /* c2sNZÂ */
}

/*---------------------------------------------------------------------------*/

/* WJobt@Ƃ_def_vbuff[]𗘗pĂ܂B */
unsigned int
render_printfx_framed(RENDER* render, int x, int y, const FONTX* fontx, int color, const char* fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vsprintf(_def_vbuff, fmt, ap);
	va_end(ap);

	return render_stringx_framed(render, x, y, _def_vbuff, fontx, color);
}

