/*	
 *	clipemu.h
 *
 *	G~[^pTu[`WB
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Thu Dec 25 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_EMU_H__
#define __CLIP_EMU_H__

/****************************************************************************
 *	ėp萔
 ****************************************************************************/

#define	NTSC_COLOR_SUBCARRIER	3579545	/* NTSCJ[TuLAg[Hz] */
#define PAL_COLOR_SUBCARRIER	4433619	/* PAL J[TuLAg[Hz] (́A4433618.75[Hz]) */
					/* PAL͂̕܂gƂ͂ȂƎv܂Aꉞ`܂B */

/****************************************************************************
 *	LN^`
 ****************************************************************************/

/* * `̃sNZ`͎̒ʂłB
 *
 *	planes=1̏ꍇ:
 *			pppppppb
 *			|||||||+-v[#0|J[ԍ
 *			+++++++-------------pbgԍ
 *	planes=2̏ꍇ:
 *			ppppppgb
 *			|||||||+-v[#0|J[ԍ
 *			||||||+--v[#1|
 *			++++++--------------pbgԍ
 *	planes=3̏ꍇ:
 *			ppppprgb
 *			|||||||+-v[#0|J[ԍ
 *			||||||+--v[#1|
 *			|||||+---v[#2|
 *			+++++---------------pbgԍ
 *	planes=4̏ꍇ:
 *			ppppargb
 *			|||||||+-v[#0|J[ԍ
 *			||||||+--v[#1|
 *			|||||+---v[#2|
 *			||||+----v[#3|
 *			++++----------------pbgԍ
 */
#define GFX_MAX_PLANES		4		/* őv[() */

/* LN^ROM\\ */
typedef struct _GFX {
	unsigned char bits;				/* + 0, 1: 1v[1sNZ̃rbg */
	unsigned char planes;				/* + 1, 1: v[ */
	unsigned char width;				/* + 2, 1: LN^  [sNZ] */
	unsigned char height;				/* + 3, 1: LN^[sNZ] */
	int count;					/* + 4, 4: LN^ */
	const void* plane_address[GFX_MAX_PLANES];	/* + 8,16: v[AhX */
} GFX;							/* =24 */

/* LN^`܂B
 * [in]
 *	render		`RENDER\́B
 *	gfx		`悷LN^GFX\́B
 *	dx		`̊_XWB
 *	dy		`̊_YWB
 *	code		LN^ԍB
 *	palette		pbgԍB
 *	param		߂є]tOB
 */
void render_gfx(RENDER* render, const GFX* gfx, int dx, int dy, int code, int palette, int param);

/* render_gfx()paramptOB0ȏ̑gݍ킹Ŏw肵ĂB */
#define GFX_TRANSPARENT		(1 << 0)	/* J[#0ߐF */
#define GFX_REVX		(1 << 1)	/* E] */
#define GFX_REVY		(1 << 2)	/* ㉺] */

/* ȉ̃tO͓gpłBAvP[V͎w肵ȂłB */
#define GFX_CLIPX		(1 << 3)	/* NbsO */
#define GFX_CLIPY		(1 << 4)	/* NbsO */

/****************************************************************************
 *	J[bNAbv
 ****************************************************************************/

/* * J[bNAbve[û͎悤ɒ`ĂB
 *
 *	unsigned ϐ[pbg~pbg̃J[];
 *
 * <> 16pbg4J[Ług_clutvƂÕJ[bNAbve[u`F
 *
 *	unsigned g_clut[16 * 4];
 */

/* J[bNAbve[u܂B
 * [in]
 *	clut		J[bNAbve[uB
 *	count		GgB
 */
void clut_init(unsigned clut[/*count*/], int count);

/* J[bNAbve[uGg{RorGorB}xύX܂B
 * [in]
 *	clut		J[bNAbve[uB
 *	i		J[ԍB(SpbgʎZ)
 *	v		{RorGorb}xB(:0x00`0xff:)
 */
void clut_set_b(unsigned clut[], int i, unsigned char v);
void clut_set_g(unsigned clut[], int i, unsigned char v);
void clut_set_r(unsigned clut[], int i, unsigned char v);

/* J[bNAbve[uGgRGBxύX܂B
 * [in]
 *	clut		J[bNAbve[uB
 *	i		J[ԍB(SpbgʎZ)
 *	v		RGBxB(00000000_rrrrrrrr_gggggggg_bbbbbbbb)
 */
void clut_set_rgb(unsigned clut[], int i, int v);

/* J[bNAbve[uXV܂B
 * [in]
 *	clut		J[bNAbve[uB
 *	count		GgB
 * [out]
 *	߂l		XVGgB
 */
int clut_update(unsigned clut[/*count*/], int count);

/* ẅ̃J[bNAbvs܂B
 * [in]
 *	render		`RENDER\́B
 *	clut		J[bNAbve[uB
 *	x		̈̊_XWB
 *	y		̈̊_YWB
 *	w		̈̕B
 *	h		̈̍B
 */
void render_clut(RENDER* render, const unsigned clut[], int x, int y, int w, int h);

/****************************************************************************
 *	ROMZbgt@C
 ****************************************************************************/

typedef struct _ROM {
	const char* name;	/* ROM(ZIP̃t@C) */
	unsigned base;		/* x[XAhX */
	unsigned size;		/* TCY */
	unsigned crc;		/* CRC */
} ROM;

/* ROMZbgt@Cǂݍ݂܂B
 * [in]
 *	fname		ZIPt@CB
 *	rom		ROMzB
 *	count		ROM̐B
 *	mem		ǂݍݐ惁̐擪AhXB
 * [out]
 *	߂l		SĐǂݍ߂0Ԃ܂B
 *			sȂ0ȊO̒lԂ܂B
 */
int rom_load(const char* fname, const ROM* rom, int count, unsigned char* mem);

#endif /*__CLIP_EMU_H__*/
