/*	
 *	clipdns.c
 *
 *	DNSNCAg
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Thu Sep 22 05:58:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 *	* Sun Sep 25 17:23:00 JST 2005 Naoyuki Sawa
 *	- dns_query()ɂāAے艞̉񓚃bZ[W󂯎ƂɁAɏI悤C܂B
 *	  ܂ł́Aے艞󂯎ƂɁAIA^CAEg܂ő҂Ă܂Ă܂B
 *	- dns_query()̃^CAEgԂ̊lA1000[ms]2000[ms]֕ύX܂B
 *	  1000[ms]ł́A₢킹ւ̐/ssɂȂ邱ƂXłB
 *	  DNST[oݒ肳Ă΁AԈ₢킹΂ĂAɎs񓚂ԂĂ͂łB
 *	  ^CAEgԂ𑝂₵ƂɂāAAvP[V̎sxȂ悤ȉe͏Ȃ͂łB
 *	  AsDNST[oݒ肳Ăꍇ́A^CAEg҂ɂ~ԂȂĂ܂܂B
 *	* Sun Sep 25 19:34:00 JST 2005 Naoyuki Sawa
 *	- dns_query()̃^CAEgԂ̊lAςA1000[ms]ɖ߂܂B
 *	  ₢킹ւ̐/ss肾ŔADNS̉xƂł͂܂łB
 *	  P/ECE EthernethCoNAWindowsP/ECE EthernetfoCXFAx_NGXgɂ
 *	  MACAhXݒ肷܂łɏԂ܂ÅԂDNS⃁bZ[W𑗐M悤ƂāA
 *	  ołĂȂ݂̂łB܂AMACAhXݒ肳ꂽA
 *	  ΂炭Windowslbg[NݒsĂ邽߁AɂTCP/UDPʐMłȂ݂łB
 *	  P/ECE TCP/IPAvP[V쐬ہANɎIɃlbg[NʐMs悤ȃvO
 *	  ̓_ƂȂ\̂ŁAāA[U[{^Ƀlbg[NʐMsȂǂ
 *	  @̂悤AӂĂB
 */
#include "clip.h"

/*****************************************************************************
 *	\́A萔
 *****************************************************************************/

/* DNSwb_ */
typedef struct _DNSHEADER {
	unsigned short id;				/* + 0,2: ʎq */
	unsigned short rcode :4;			/* + 2,2: [ 3: 0] 񓚃R[h */
	unsigned short z     :3;			/*        [ 6: 4] \ */
	unsigned short ra    :1;			/*        [    7] ċA\ */
	unsigned short rd    :1;			/*        [    8] ċAv */
	unsigned short tc    :1;			/*        [    9] ؂l */
	unsigned short aa    :1;			/*        [   10] Ђ */
	unsigned short opcode:4;			/*        [14:11] ̎ */
	unsigned short qr    :1;			/*        [   15] or */
	unsigned short qdcount;				/* + 4,2: ⃌R[h̐ */
	unsigned short ancount;				/* + 6,2: 񓚃R[h̐ */
	unsigned short nscount;				/* + 8,2: ЃR[h̐ */
	unsigned short arcount;				/* +10,2: ǉR[h̐ */
} DNSHEADER;						/* =12 */

/* ⃌R[h */
typedef struct _DNSQD {
	/* char qname[?]; */				/*   +0,?: ▼ */
	unsigned short qtype;				/*  ?+0,2: ₢킹 */
	unsigned short qclass;				/*  ?+2,2: ₢킹NX */
} DNSQD;						/* =?+4 */

/* R[h */
typedef struct _DNSRR {
	/* char name[?]; */				/*   + 0,?: O */
	unsigned short type;				/*  ?+ 0,2:  */
	unsigned short class;				/*  ?+ 2,2: NX */
	unsigned long  ttl;				/*  ?+ 4,4:  */
	unsigned short rdlength;			/*  ?+ 8,2: f[^ */
	const unsigned char* rdata/*[rdlength]*/;	/*  ?+10,?: f[^ */
} DNSRR;						/* =?+10+? */

/* DNSHEADER.qr */
#define DNS_QR_QUERY			  0		/*  */
#define DNS_QR_RESPONSE			  1		/*  */

/* DNSHEADER.opcode */
#define DNS_OPCODE_QUERY		  0		/* WIȎ () */
#define DNS_OPCODE_IQUERY		  1		/* t⍇ (t) */
#define DNS_OPCODE_STATUS		  2		/* T[oԗv () */

/* DNSHEADER.rcode */
#define DNS_RCODE_NO_ERROR		  0		/* G[͂肠܂ */
#define DNS_RCODE_FORMAT_ERROR		  1		/* tH[}bgG[ */
#define DNS_RCODE_SERVER_FAILURE	  2		/* T[o[s */
#define DNS_RCODE_NAME_ERROR		  3		/* OG[ */
#define DNS_RCODE_NOT_IMPLEMENTED	  4		/* ĂȂ */
#define DNS_RCODE_REFUSED		  5		/*  */

/* DNSQD.qtypeADNSRR.type */
#define DNS_TYPE_A			  1		/* zXgAhX */
#define DNS_TYPE_NS			  2		/* ȃl[T[o */
#define DNS_TYPE_MD			  3		/* [ (xAMXg) */
#define DNS_TYPE_MF			  4		/* [] (xAMXg) */
#define DNS_TYPE_CNAME			  5		/* ʖɑ΂W */
#define DNS_TYPE_SOA			  6		/* ][̊Jn\ */
#define DNS_TYPE_MB			  7		/* [{bNXhC (I) */
#define DNS_TYPE_MG			  8		/* [O[vo[ (I) */
#define DNS_TYPE_MR			  9		/* [hC (I) */
#define DNS_TYPE_NULL			 10		/* kR[h (I) */
#define DNS_TYPE_WKS			 11		/* m̃T[rXLq */
#define DNS_TYPE_PTR			 12		/* hC|C^ */
#define DNS_TYPE_HINFO			 13		/* zXg */
#define DNS_TYPE_MINFO			 14		/* [{bNX邢̓[Xg */
#define DNS_TYPE_MX			 15		/* [ */
#define DNS_TYPE_TXT			 16		/* eLXg */

/* DNSQD.qclassADNSRR.class */
#define DNS_CLASS_IN			  1		/* C^[lbg */
#define DNS_CLASS_CS			  2		/* CSNETNX (x|鎞xRFCŗɂgꂽ) */
#define DNS_CLASS_CH			  3		/* JIXNX */
#define DNS_CLASS_HS			  4		/* wVIh [Dyer 87] */

#define DNS_UDP_MAX			512		/* DNSbZ[WUDPf[^ő咷 (UDPwb_܂܂) */

/*****************************************************************************
 *	[J֐
 *****************************************************************************/

/* DNSbZ[WksAOi[܂B
 * [in]
 *	buffer		DNSbZ[W\zpobt@̐擪AhXB(ȉA\zobt@ƌĂ)
 *			\zobt@Ɋi[ς݂́ADNSwb_̐擪AhXw肵ĂB
 *	buffer_capacity	\zobt@̋eʁB
 *	offset		Oi[ʒúA\zobt@擪̃ItZbgB
 *			\zobt@擪`ItZbg܂ł̗̈́AɏĂ邱ƁB
 *			(2005/09/21݂̎ł́Aks킸Aȏ㌻ꂽÔ܂܊i[܂B
 *			 ]Č݂́gobt@擪`ItZbg̈悪ĂhKv͂܂B
 *			 Aks悤ύXꍇ̂߂ɁAq̐ۂƂɂ܂B)
 *	name		i[閼OB
 * [out]
 *	߂l		Ȃ΁Ai[I[(+1)̈ʒuA\zobt@擪̃ItZbgŕԂ܂B
 *			sȂ΁AԂ܂B
 */
static int /* next offset */
dns_put_name(void* _buffer/*[buffer_capacity]*/, int buffer_capacity, int offset, const char* name)
{
	unsigned char* buffer = _buffer;
	//
	int label_length;

	do {
		/* '.'̘AXLbv܂B */
		label_length = strspn(name, ".");
		name += label_length;

		/* x擾܂B(ȌI[Ȃ0) */
		label_length = strcspn(name, ".");

		/* x̍ő咷́A63łB(DNSdl) */
		if(label_length > 63) {
			return -1; /* Os */
		}

		/* \zobt@ɁAxƃxi[ł邩Aׂ܂B */
		if((offset + 1 + label_length) > buffer_capacity) {
			return -1; /* \zobt@s */
		}

		/* \zobt@ɁAxƃxi[܂B */
		buffer[offset++] = label_length;
		memcpy(&buffer[offset], name, label_length);
		offset += label_length;
		name   += label_length;

	} while(label_length); /* ȌI[ȂΔ܂B(I[0i[ς) */

	return offset;
}

/* DNSbZ[WWJsAO擾܂B
 * [in]
 *	buffer		DNSbZ[WMobt@̐擪AhXB(ȉAMobt@ƌĂ)
 *			Mobt@ɎMADNSwb_̐擪AhXw肵ĂB
 *	buffer_length	DNSbZ[WB
 *	offset		O擾ʒúAMobt@擪̃ItZbgB
 *	name		Oi[obt@̐擪AhXB(ȉAOobt@ƌĂ)
 *			NULLw肷ƁAOi[ɁÂĂ܂B
 *	name_capacity	Oobt@̋eʁB
 *			name=NULLw肵ꍇAname_capacity͗LłB
 *			CӒ̖O󂯓ɂ́Â悤ɌĂяoĂB
 *			retval = dns_get_name(buffer, buffer_length, offset, NULL, INT_MAX);
 * [out]
 *	߂l		Ȃ΁AOI[(+1)̈ʒuAMobt@擪̃ItZbgŕԂ܂B
 *			sȂ΁AԂ܂B
 */
static int /* next offset */
dns_get_name(const void* _buffer, int buffer_length, int offset, char* name/*[name_capacity]*/, int name_capacity)
{
	const unsigned char* buffer = _buffer;
	//
	int next_offset = offset;
	int name_length = 0;
	//
	int label_length;

	for(;;) {
		/* xA܂́Ak|C^1oCgڂ擾܂B */
		if((offset < 0) || (offset > buffer_length - 1)) {
			return -1; /* DNSbZ[Ws */
		}
		label_length = buffer[offset++];
		if(offset > next_offset) {
			next_offset = offset;
		}

		/* 2bitɂāAxA܂́Ak|C^𔻒肵܂B */
		switch(label_length & 0xc0) {

		case 0x00: /* 00xxxxxx = x (0-63) */

			/* x0Ȃ΁AȌI[Ȃ̂ŁA܂B */
			if(!label_length) {
				goto L_EXIT;
			}

			/* xMobt@̖𒴂ĂȂAׂ܂B */
			if((offset + label_length) > buffer_length) {
				return -1; /* DNSbZ[Ws */
			}

			/* Oobt@ɁAx'.'i[ł邩Aׂ܂B */
			if((name_length + label_length + 1) > name_capacity) {
				return -1; /* Oobt@s */
			}

			/* Oobt@ɁAx'.'i[܂B */
			if(name) {
				memcpy(&name[name_length], &buffer[offset], label_length);
				name[name_length + label_length] = '.';
			}
			name_length += (label_length + 1);

			/* x̕AItZbgi߂܂B */
			offset += label_length;
			if(offset > next_offset) {
				next_offset = offset;
			}

			break;

		case 0xc0: /* 11xxxxxx xxxxxxxx = k|C^ */

			/* k|C^擾܂B */
			if((offset < 0) || (offset > buffer_length - 1)) {
				return -1; /* DNSbZ[Ws */
			}
			label_length = (label_length & ~0xc0) << 8 | buffer[offset++];
			if(offset > next_offset) {
				next_offset = offset;
			}

			/* k|C^́Aʒu֐i߂邱Ƃ͂ł܂B */
			if(label_length >= offset) {
				return -1; /* DNSbZ[Ws */
			}

			/* ʒuO֖߂܂B */
			offset = label_length;

			break;

		default: /* 01xxxxxx or 10xxxxxx */

			return -1; /* DNSbZ[Ws */
		}
	}

L_EXIT:

	/* ŌɊi['.'AI['\0'ɒu܂B */
	if(name && name_length) {
		name[name_length - 1] = '\0';
	}

	return next_offset;
}

/*---------------------------------------------------------------------------*/

/* DNSwb_i[܂B
 * [in]
 *	buffer		DNSbZ[W\zpobt@̐擪AhXB(ȉA\zobt@ƌĂ)
 *	buffer_capacity	\zobt@̋eʁB
 *	header		i[DNSwb_B
 *	߂l		Ȃ΁Ai[I[(+1)̈ʒuA\zobt@擪̃ItZbgŕԂ܂B
 *			sȂ΁AԂ܂B
 */
static int /* next offset */
dns_put_header(void* _buffer/*[buffer_capacity]*/, int buffer_capacity, const DNSHEADER* header)
{
	const unsigned char* src = (const unsigned char*)header;
	      unsigned char* dst =                      _buffer;
	//
	int offset;
	int hw;

	if(sizeof(DNSHEADER) != 12) {
		DIE(); /* DNSHEADER̒` */
	}
	if(buffer_capacity < 12) {
		return -1; /* \zobt@s */
	}

	for(offset = 0; offset < 12; offset += 2) {
		hw = GET_BEHALF(&src[offset]);
		     PUT_LEHALF(&dst[offset], hw);
	}

	return offset;
}

/* DNSwb_擾܂B
 * [in]
 *	buffer		DNSbZ[WMobt@̐擪AhXB(ȉAMobt@ƌĂ)
 *	buffer_length	DNSbZ[WB
 *	header		DNSwb_i[ϐ̃AhXB
 * [out]
 *	߂l		Ȃ΁ADNSwb_I[(+1)̈ʒuAMobt@擪̃ItZbgŕԂ܂B
 *			sȂ΁AԂ܂B
 */
static int /* next offset */
dns_get_header(const void* _buffer, int buffer_length, DNSHEADER* header)
{
	const unsigned char* src =                _buffer;
	      unsigned char* dst = (unsigned char*)header;
	//
	int offset;
	int hw;

	if(sizeof(DNSHEADER) != 12) {
		DIE(); /* DNSHEADER̒` */
	}
	if(buffer_length < 12) {
		return -1; /* DNSbZ[Ws */
	}

	for(offset = 0; offset < 12; offset += 2) {
		hw = GET_BEHALF(&src[offset]);
		     PUT_LEHALF(&dst[offset], hw);
	}

	return offset;
}

/*---------------------------------------------------------------------------*/

/* ⃌R[hi[܂B
 * [in]
 *	buffer		DNSbZ[W\zpobt@̐擪AhXB(ȉA\zobt@ƌĂ)
 *			\zobt@Ɋi[ς݂́ADNSwb_̐擪AhXw肵ĂB
 *	buffer_capacity	\zobt@̋eʁB
 *	offset		⃌R[hi[ʒúA\zobt@擪̃ItZbgB
 *	qname		i[鎿▼B
 *	qd		i[鎿⃌R[hB
 * [out]
 *	߂l		Ȃ΁Ai[I[(+1)̈ʒuA\zobt@擪̃ItZbgŕԂ܂B
 *			sȂ΁AԂ܂B
 */
static int /* next offset */
dns_put_qd(void* _buffer/*[buffer_capacity]*/, int buffer_capacity, int offset, const char* qname, const DNSQD* qd)
{
	unsigned char* buffer = _buffer;

	/* ▼i[܂B */
	offset = dns_put_name(buffer, buffer_capacity, offset, qname);
	if(offset < 0) {
		return -1; /* \zobt@s */
	}

	/* ₢킹(2)A₢킹NX(2)i[܂B */
	if((offset + 2 + 2) > buffer_capacity) {
		return -1; /* \zobt@s */
	}
	PUT_BEHALF(&buffer[offset + 0], qd->qtype );
	PUT_BEHALF(&buffer[offset + 2], qd->qclass);
	offset += (2 + 2);

	return offset;
}

/* ⃌R[h擾܂B
 * [in]
 *	buffer		DNSbZ[WMobt@̐擪AhXB(ȉAMobt@ƌĂ)
 *			Mobt@ɎMADNSwb_̐擪AhXw肵ĂB
 *	buffer_length	DNSbZ[WB
 *	offset		⃌R[h擾ʒúAMobt@擪̃ItZbgB
 *	qname		▼i[obt@̐擪AhXB(ȉA▼obt@ƌĂ)
 *			NULLw肷ƁA▼i[ɁÂĂ܂B
 *	qname_capacity	▼obt@̋eʁB
 *			qname=NULLw肵ꍇAaname_capacity͗LłB
 *			CӒ̎▼󂯓ɂ́Â悤ɌĂяoĂB
 *			retval = dns_get_qd(buffer, buffer_length, offset, NULL, INT_MAX, qd);
 *	qd		⃌R[hi[ϐ̃AhXB
 * [out]
 *	߂l		Ȃ΁A⃌R[hI[(+1)̈ʒuAMobt@擪̃ItZbgŕԂ܂B
 *			sȂ΁AԂ܂B
 */
static int /* next offset */
dns_get_qd(const void* _buffer, int buffer_length, int offset, char* qname/*[qname_capacity]*/, int qname_capacity, DNSQD* qd)
{
	const unsigned char* buffer = _buffer;

	/* ▼擾܂B */
	offset = dns_get_name(buffer, buffer_length, offset, qname, qname_capacity);
	if(offset < 0) {
		return -1; /* DNSbZ[Ws */
	}

	/* ₢킹(2)A₢킹NX(2)擾܂B */
	if((offset + 2 + 2) > buffer_length) {
		return -1; /* DNSbZ[Ws */
	}
	qd->qtype  = BEHALF(&buffer[offset + 0]);
	qd->qclass = BEHALF(&buffer[offset + 2]);
	offset += (2 + 2);

	return offset;
}

/*---------------------------------------------------------------------------*/

/* R[h擾܂B
 * [in]
 *	buffer		DNSbZ[WMobt@̐擪AhXB(ȉAMobt@ƌĂ)
 *			Mobt@ɎMADNSwb_̐擪AhXw肵ĂB
 *	buffer_length	DNSbZ[WB
 *	offset		R[h擾ʒúAMobt@擪̃ItZbgB
 *	name		Oi[obt@̐擪AhXB(ȉAOobt@ƌĂ)
 *			NULLw肷ƁAOi[ɁÂĂ܂B
 *	name_capacity	Oobt@̋eʁB
 *			name=NULLw肵ꍇAname_capacity͗LłB
 *			CӒ̖O󂯓ɂ́Â悤ɌĂяoĂB
 *			retval = dns_get_rr(buffer, buffer_length, offset, NULL, INT_MAX, rr);
 *	rr		R[hi[ϐ̃AhXB
 * [out]
 *	߂l		Ȃ΁AR[hI[(+1)̈ʒuAMobt@擪̃ItZbgŕԂ܂B
 *			sȂ΁AԂ܂B
 * [note]
 *	* DNSRR.rdatatB[h́AMobt@̎f[^𒼐ڃ|CgĂ܂B
 *	  DNSRR.rdataQƂԁAMobt@̓eێĂB
 */
static int /* next offset */
dns_get_rr(const void* _buffer, int buffer_length, int offset, char* name/*[name_capacity]*/, int name_capacity, DNSRR* rr)
{
	const unsigned char* buffer = _buffer;

	/* O擾܂B */
	offset = dns_get_name(buffer, buffer_length, offset, name, name_capacity);
	if(offset < 0) {
		return -1; /* DNSbZ[Ws */
	}

	/* ^Cv(2)ANX(2)A(4)Af[^(2)擾܂B */
	if((offset + 2 + 2 + 4 + 2) > buffer_length) {
		return -1; /* DNSbZ[Ws */
	}
	rr->type     = BEHALF(&buffer[offset +  0]);
	rr->class    = BEHALF(&buffer[offset +  2]);
	rr->ttl      = BEWORD(&buffer[offset +  4]);
	rr->rdlength = BEHALF(&buffer[offset +  8]);
	offset += (2 + 2 + 4 + 2);

	/* f[^擾܂B */
	if((offset + rr->rdlength) > buffer_length) {
		return -1; /* DNSbZ[Ws */
	}
	rr->rdata = &buffer[offset];
	offset += rr->rdlength;

	return offset;
}

/*****************************************************************************
 *	O[o֐
 *****************************************************************************/

static int dns_server;	/* DNST[oIPAhX */

void
dns_set_server(int ip_address)
{
	dns_server = ip_address;
}

int
dns_get_server()
{
	return dns_server;
}

int
dns_query(const char* qname, int timeout)
{
	int packet_length;
	unsigned char* packet = NULL; /* v */
	//
	UDPSOCKET* socket = NULL; /* v */
	//
	int result = 0;
	int T0 = pceTimerGetCount();
	int id = (unsigned short)T0;
	//
	DNSHEADER header;
	DNSQD qd;
	DNSRR rr;
	int offset;
	int remote_ip_address;
	int remote_port;
	int a_record;
	int i;

	/* ^CAEgɕw肳ĂAlƂ܂B */
	if(timeout < 0) {
		timeout = 1000; /*  */
	}

	/* \zobt@AAMobt@mۂ܂B */
	packet = malloc(DNS_UDP_MAX);
	if(!packet) {
		DIE(); /* s */
	}

	/* ⃁bZ[W\z܂B */
	memset(&header, 0, sizeof(DNSHEADER));
	header.id	= id;	/* ʎq */
	header.rd	= 1;	/* ċAv */
	header.qdcount	= 1;	/* ⃌R[h̐ */
	offset = dns_put_header(packet, DNS_UDP_MAX, &header);
	if(offset < 0) {
		goto L_EXIT; /* L蓾Ȃ */
	}
	memset(&qd, 0, sizeof(DNSQD));
	qd.qtype	= DNS_TYPE_A;	/* ₢킹 */
	qd.qclass	= DNS_CLASS_IN;	/* ₢킹NX */
	offset = dns_put_qd(packet, DNS_UDP_MAX, offset, qname, &qd);
	if(offset < 0) {
		goto L_EXIT; /* hCُɒ? */
	}

	/* UDP\PbgJ܂B */
	socket = udp_socket_open(0/*GtF|[g*/, DNS_UDP_MAX);

	/* ⃁bZ[W𑗐Mł邩A܂́A^CAEg܂... */
	while(pceTimerGetCount() - T0 < timeout) {

		/* ⃁bZ[W𑗐M܂B */
		packet_length = udp_socket_send(socket, dns_server, 53/*DNS*/, packet, offset);
		if(packet_length >= 0) {
			break; /* M */
		}

		/* ⃁bZ[W𑗐MOɓ͂pPbǵAj܂B */
		udp_socket_recv(socket, NULL, NULL, packet, DNS_UDP_MAX);
	}

	/* 񓚃bZ[W(ے艞܂)Mł邩A܂́A^CAEg܂... */
	while(pceTimerGetCount() - T0 < timeout) {

		/* ̃[vŎMpPbgAAR[h𔭌AɂIPAhXi[܂B */
		a_record = 0;

		/* 񓚃bZ[WM܂B */
		packet_length = udp_socket_recv(socket, &remote_ip_address, &remote_port, packet, DNS_UDP_MAX);
		if(packet_length < 0) {
			continue; /* 񓚃bZ[WBMp܂ */
		}
		if((remote_ip_address != dns_server) || (remote_port != 53/*DNS*/)) {
			continue; /* MsBpPbgjAMp܂ */
		}

		/* wb_擾܂B
		 * wb_sȂ΁AR̃|[gɓS~pPbgƍl̂ŁAjAMp܂B
		 */
		offset = dns_get_header(packet, packet_length, &header);
		if(offset < 0) {
			continue; /* wb_sBpPbgjAMp܂ */
		}
	
		/* ʎqƁAor񓚂܂BʎqsvA܂́A񓚃bZ[WłȂ΁A
		 * ȑO̎ɑ΂񓚂dēAS~pPbgƍl̂ŁAjAMp܂B
		 */
		if((header.id != id) ||	/* ʎqsv */
		   (header.qr !=  1)) {	/* 񓚃bZ[WłȂ */
			continue;	/* pPbgjAMp܂ */
		}

		/* ܂ł̌ŁẢ񓚃bZ[ẂA̎ɑΉ̂ł邱Ƃm肵܂B
		 * ȍ~ŃG[oApPbgjĎMp̂łȂAے艞ƂĎ󂯓܂B
		 * R[h̎擾Ɏsꍇ(jH)Aȏ҂ĂVbZ[W\͖̂ŁA
		 * ̃T[oƂ̂Ƃł͐񓚂Ȃ̂ƍlāAے艞ƓƂ܂B
		 */

		/* ؂l߂ƁA񓚃R[h܂B */
		if((header.tc    !=  0) ||		   /* 񓚂Đ؂l߂ꂽ */
		   (header.rcode != DNS_RCODE_NO_ERROR)) { /* G[L(ے艞) */
			goto L_EXIT; /* ے艞ƌȂAsƂ܂ */
		}

		/* ⃌R[h擾܂B(ĵ) */
		for(i = 0; i < header.qdcount; i++) {
			offset = dns_get_qd(packet, packet_length, offset, NULL, INT_MAX, &qd);
			if(offset < 0) {
				goto L_EXIT; /* ⃌R[hsBے艞ƌȂAsƂ܂ */
			}
		}

		/* 񓚃R[hAŏAR[h擾܂B */
		for(i = 0; i < header.ancount; i++) {
			offset = dns_get_rr(packet, packet_length, offset, NULL, INT_MAX, &rr);
			if(offset < 0) {
				goto L_EXIT; /* 񓚃R[hjBے艞ƌȂAsƂ܂ */
			}
			if(!a_record) { /* AR[hŁAAR[h𔭌... */
				if((rr.type == DNS_TYPE_A) && (rr.class == DNS_CLASS_IN) && (rr.rdlength == 4)) {
					a_record = BEWORD(rr.rdata); /* IPAhX擾܂ */
				}
			}
		}

		/* ЃR[h擾܂B(ĵ) */
		for(i = 0; i < header.nscount; i++) {
			offset = dns_get_rr(packet, packet_length, offset, NULL, INT_MAX, &rr);
			if(offset < 0) {
				goto L_EXIT; /* ЃR[hjBے艞ƌȂAsƂ܂ */
			}
		}

		/* ǉR[h擾܂B(ĵ) */
		for(i = 0; i < header.arcount; i++) {
			offset = dns_get_rr(packet, packet_length, offset, NULL, INT_MAX, &rr);
			if(offset < 0) {
				goto L_EXIT; /* ǉR[hjBے艞ƌȂAsƂ܂ */
			}
		}

		/* AR[h𔭌łĂ(a_record!=0)A̒lʂƂāAԂ܂B()
		 * AR[h𔭌łȂ(a_record==0)A̒lʂƂāAԂ܂B(s)
		 * ɂẢ񓚃bZ[W󂯓邱ƂɂȂ̂ŁAŃ[v𔲂܂B
		 */
		result = a_record;
		break; /* ܂ */
	}

L_EXIT:	/*-------------------------------------------------------------------*/

	/* UDP\Pbg܂B */
	if(socket) {
		udp_socket_close(socket);
	}

	/* \zobt@AAMobt@J܂B */
	free(packet);

	return result;
}

/*****************************************************************************
 *	WindowsTvvO
 *****************************************************************************/
#if 0

/* DNSNCAgW[̓[`́At@\ɋ߂xŎĂ܂A
 * 2005/09/22݂̎ł́A̋@\܂藘pĂ܂B
 * A@\𗘗pƂ̂߂̎QlƂāADNS񓚃bZ[W̓eꗗ\A
 * WindowsvOcĂƂɂ܂BvȌo͂́Â悤ɖ܂B
 *
 *	=== ⃌R[h ===
 *	www.yahoo.co.jp     A  IN 
 *	=== 񓚃R[h ===
 *	www.yahoo.co.jp     A  IN 202.93.91.215 
 *	www.yahoo.co.jp     A  IN 202.93.91.216 
 *	www.yahoo.co.jp     A  IN 202.93.91.217 
 *	www.yahoo.co.jp     A  IN 202.93.91.218 
 *	www.yahoo.co.jp     A  IN 202.93.91.219 
 *	www.yahoo.co.jp     A  IN 202.229.198.216 
 *	www.yahoo.co.jp     A  IN 202.229.199.136 
 *	www.yahoo.co.jp     A  IN 202.229.199.147 
 *	www.yahoo.co.jp     A  IN 203.141.35.113 
 *	www.yahoo.co.jp     A  IN 210.80.242.236 
 *	www.yahoo.co.jp     A  IN 210.80.243.14 
 *	www.yahoo.co.jp     A  IN 210.81.3.241 
 *	www.yahoo.co.jp     A  IN 210.81.150.5 
 *	www.yahoo.co.jp     A  IN 202.93.91.214 
 *	=== ЃR[h ===
 *	yahoo.co.jp         NS IN dnsn201.yahoo.co.jp
 *	yahoo.co.jp         NS IN dnsg01.yahoo.co.jp
 *	=== ǉR[h ===
 *	dnsg01.yahoo.co.jp  A  IN 211.14.12.10 
 *	dnsn201.yahoo.co.jp A  IN 202.229.198.120 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#define DebugBreak abort
#include "C:/Home/Share/Piece/clip/clipmisc.h"

/*  ɁADNSNCAgW[̃\[XR[h܂߂Ă  */

/* "nslookup www.yahoo.co.jp."́A񓚃bZ[WLv`܂B(UDPf[^{) */
unsigned char sample_data[] = {
	0x00,0x05,0x81,0x80,0x00,0x01,0x00,0x0e,0x00,0x02,0x00,0x02,0x03,0x77,0x77,0x77,
	0x05,0x79,0x61,0x68,0x6f,0x6f,0x02,0x63,0x6f,0x02,0x6a,0x70,0x00,0x00,0x01,0x00,
	0x01,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xca,0x5d,0x5b,
	0xd7,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xca,0x5d,0x5b,
	0xd8,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xca,0x5d,0x5b,
	0xd9,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xca,0x5d,0x5b,
	0xda,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xca,0x5d,0x5b,
	0xdb,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xca,0xe5,0xc6,
	0xd8,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xca,0xe5,0xc7,
	0x88,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xca,0xe5,0xc7,
	0x93,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xcb,0x8d,0x23,
	0x71,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xd2,0x50,0xf2,
	0xec,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xd2,0x50,0xf3,
	0x0e,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xd2,0x51,0x03,
	0xf1,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xd2,0x51,0x96,
	0x05,0xc0,0x0c,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x20,0x00,0x04,0xca,0x5d,0x5b,
	0xd6,0xc0,0x10,0x00,0x02,0x00,0x01,0x00,0x00,0x03,0x83,0x00,0x0a,0x07,0x64,0x6e,
	0x73,0x6e,0x32,0x30,0x31,0xc0,0x10,0xc0,0x10,0x00,0x02,0x00,0x01,0x00,0x00,0x03,
	0x83,0x00,0x09,0x06,0x64,0x6e,0x73,0x67,0x30,0x31,0xc0,0x10,0xc1,0x23,0x00,0x01,
	0x00,0x01,0x00,0x00,0x03,0x83,0x00,0x04,0xd3,0x0e,0x0c,0x0a,0xc1,0x0d,0x00,0x01,
	0x00,0x01,0x00,0x00,0x02,0x9f,0x00,0x04,0xca,0xe5,0xc6,0x78,
};

void
print_type(int type)
{
	switch(type) {
	case DNS_TYPE_A:     printf("%-3s", "A"    ); break;
	case DNS_TYPE_NS:    printf("%-3s", "NS"   ); break;
	case DNS_TYPE_MD:    printf("%-3s", "MD"   ); break;
	case DNS_TYPE_MF:    printf("%-3s", "MF"   ); break;
	case DNS_TYPE_CNAME: printf("%-3s", "CNAME"); break;
	case DNS_TYPE_SOA:   printf("%-3s", "SOA"  ); break;
	case DNS_TYPE_MB:    printf("%-3s", "MB"   ); break;
	case DNS_TYPE_MG:    printf("%-3s", "MG"   ); break;
	case DNS_TYPE_MR:    printf("%-3s", "MR"   ); break;
	case DNS_TYPE_NULL:  printf("%-3s", "NULL" ); break;
	case DNS_TYPE_WKS:   printf("%-3s", "WKS"  ); break;
	case DNS_TYPE_PTR:   printf("%-3s", "PTR"  ); break;
	case DNS_TYPE_HINFO: printf("%-3s", "HINFO"); break;
	case DNS_TYPE_MINFO: printf("%-3s", "MINFO"); break;
	case DNS_TYPE_MX:    printf("%-3s", "MX"   ); break;
	case DNS_TYPE_TXT:   printf("%-3s", "TXT"  ); break;
	default:             printf("%3d" , type   ); break;
	}
}

void
print_class(int class)
{
	switch(class) {
	case DNS_CLASS_IN:   printf("%-3s", "IN" ); break;
	case DNS_CLASS_CS:   printf("%-3s", "CS" ); break;
	case DNS_CLASS_CH:   printf("%-3s", "CH" ); break;
	case DNS_CLASS_HS:   printf("%-3s", "HS" ); break;
	default:             printf("%3d" , class); break;
	}
}

int
main()
{
	char name[256];
	DNSHEADER header;
	DNSQD qd;
	DNSRR rr;
	int offset;
	int i;
	int n;

	/* wb_ǂ݂܂B */
	offset = dns_get_header(sample_data, sizeof sample_data, &header);
	if(offset < 0) {
		DIE();
	}

	/* ⃌R[h\܂B */
	printf("=== ⃌R[h ===\n");
	for(i = 0; i < header.qdcount; i++) {
		offset = dns_get_qd(sample_data, sizeof sample_data, offset, name, sizeof name, &qd);
		if(offset < 0) {
			DIE();
		}
		printf("%-20s", name);
		print_type(qd.qtype);
		print_class(qd.qclass);
		printf("\n");
	}

	/* 񓚃R[hAЃR[hAǉR[h\܂B */
	for(i = 0; i < 3; i++) {
		switch(i) {
		case 0:  printf("=== 񓚃R[h ===\n"); n = header.ancount; break;
		case 1:  printf("=== ЃR[h ===\n"); n = header.nscount; break;
		default: printf("=== ǉR[h ===\n"); n = header.arcount; break;
		}
		while(n--) {
			offset = dns_get_rr(sample_data, sizeof sample_data, offset, name, sizeof name, &rr);
			if(offset < 0) {
				DIE();
			}
			printf("%-20s", name);
			print_type(rr.type);
			print_class(rr.class);
			switch(rr.type) {
			case DNS_TYPE_A:
				if(rr.rdlength != 4) {
					DIE();
				}
				printf("%d.%d.%d.%d ", rr.rdata[0], rr.rdata[1], rr.rdata[2], rr.rdata[3]);
				break;
			case DNS_TYPE_NS:
				if(dns_get_name(sample_data, sizeof sample_data, rr.rdata - sample_data, name, sizeof name) < 0) {
					DIE();
				}
				printf("%s", name);
				break;
			}
			printf("\n");
		}
	}

	return 0;
}

#endif
/*****************************************************************************
 *	
 *****************************************************************************/
