/*	
 *	clipdmvi.h
 *
 *	P/ECE DMG-Video Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Fri Feb 18 20:18:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */

/****************************************************************************
 *
 ****************************************************************************/

#ifdef DMGVIDEO_DRAW_CHR_IMPLEMENT
{
	DMGVIDEO* video      = &dmgvideo;
	unsigned char* mem   = video->mem;
	unsigned char* vbuff = video->vbuff;
	unsigned char* clut  = video->clut;
	int scan_start       = video->scan_start;
	int scan_end         = video->scan_end;
	//
	int x;
	int y;
	int v;
	int v0;
	int v1;
	unsigned char* pattern;

	/* Sɕ`̈OȂ΁AA܂B */
	if(ypos <= scan_start - 8 || ypos >= scan_end ||
	   xpos <=          0 - 8 || xpos >=      160) {
		return;
	}

	vbuff += ypos * 160 + xpos;
	clut += palno << 2;
#if(DMGVIDEO_REVY == 0)
	pattern = &mem[0x8000 | code << 4];
#else /*DMGVIDEO_REVY*/
	pattern = &mem[0x800e | code << 4];
#endif /*DMGVIDEO_REVY*/

	/* Sɕ`̈Ȃ΁ANbsOsvB */
	if(ypos >= scan_start && ypos <= scan_end - 8 &&
	   xpos >=          0 && xpos <=      160 - 8) {
		y = 8;
		do {
#if(DMGVIDEO_REVX == 0)
			v0 = MIRROR(pattern[0]);
			v1 = MIRROR(pattern[1]) << 1;
#else /*DMGVIDEO_REVX*/
			v0 = pattern[0];
			v1 = pattern[1] << 1;
#endif /*DMGVIDEO_REVX*/
			x = 8;
			do {
				v = (v0 & 1) | (v1 & 2);
#if(DMGVIDEO_OPAQUE == 0)
				if(v) {
					*vbuff = clut[v];
				}
#else /*DMGVIDEO_OPAQUE*/
				*vbuff = clut[v];
#endif /*DMGVIDEO_OPAQUE*/
				v0 >>= 1;
				v1 >>= 1;
				vbuff++;
			} while(--x);
			vbuff += 160 - 8;
#if(DMGVIDEO_REVY == 0)
			pattern += 2;
#else /*DMGVIDEO_REVY*/
			pattern -= 2;
#endif /*DMGVIDEO_REVY*/
		} while(--y);

	/* `̈͂ݏoꍇANbsOKvB */
	} else {
		y = 8;
		do {
			if(ypos >= scan_start && ypos < scan_end) {
#if(DMGVIDEO_REVX == 0)
				v0 = MIRROR(pattern[0]);
				v1 = MIRROR(pattern[1]) << 1;
#else /*DMGVIDEO_REVX*/
				v0 = pattern[0];
				v1 = pattern[1] << 1;
#endif /*DMGVIDEO_REVX*/
				x = 8;
				do {
					v = (v0 & 1) | (v1 & 2);
#if(DMGVIDEO_OPAQUE == 0)
					if(v) {
						if(xpos >= 0 && xpos < 160) {
							*vbuff = clut[v];
						}
					}
#else /*DMGVIDEO_OPAQUE*/
					if(xpos >= 0 && xpos < 160) {
						*vbuff = clut[v];
					}
#endif /*DMGVIDEO_OPAQUE*/
					v0 >>= 1;
					v1 >>= 1;
					xpos++;
					vbuff++;
				} while(--x);
				xpos  -= 8;
				vbuff -= 8;
			}
			ypos++;
			vbuff += 160;
#if(DMGVIDEO_REVY == 0)
			pattern += 2;
#else /*DMGVIDEO_REVY*/
			pattern -= 2;
#endif /*DMGVIDEO_REVY*/
		} while(--y);
	}
}
#endif DMGVIDEO_DRAW_CHR_IMPLEMENT

/****************************************************************************
 *
 ****************************************************************************/
