/*	
 *	clipdms.c
 *
 *	P/ECE DMG-Sound Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Jan 15 20:09:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Mon Feb 14 20:30:00 JST 2005 Naoyuki Sawa
 *	- ȃWX^݂ɑ΂DIE()Ă܂Ă̂폜B
 *	* Fri Feb 25 20:40:00 JST 2005 Naoyuki Sawa
 *	- JnȊOɂ`lp[^ύXł悤ɏC܂B
 *	  ܂ŁANRx4ւ݂̏ɂ锭Jn̂݃`lp[^ݒ肵A
 *	  I܂Ńp[^ύXȂ悤ɎĂ܂AłB
 *	  NRx0-NRx3D7=0NRx4֏ނƂŁAłp[^ύX\łB
 *	- dmgsound_read()֐ǉ܂B
 *	  ܂ŁAAvP[VvOTEhWX^̓ǂݏóA
 *	  𒼐ړǂݏoĂ܂Admgsound_read()֐ĂłB
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

#if 0

========
XC[v
========

SweepTimeݒl0`7łB
SweepTime=0̏ꍇAXC[vȂłB
SweepTime=1̏ꍇA128/1[Hz]ŏo͎gXV܂B
SweepTime=2̏ꍇA128/2[Hz]ŏo͎gXV܂B
...
SweepTime=7̏ꍇA128/7[Hz]ŏo͎gXV܂B

128[Hz]͊{̓NbN4194304[Hz]1/32768łB
XC[vH̓̓NbŃA{̓NbN1/32768ƍl܂B

--------
@
--------

o߃TCN~ςASweepTime*32768𒴂o͎gXV܂B
SweepTime*32768Ɣr̂ŁAsweep_timeɂ͂炩SweepTime32768{(15rbgVtg)li[Ă܂B
Ă΁Ao߃TCN~ϒlsweep_timê܂ܔr邾ōς݂܂B

XC[visJE^̓_EJE^Ƃ܂B

============
Gx[v
============

EnvelopeTime̐ݒĺA0`7łB
EnvelopeTime=0̏ꍇAXC[vȂłB
EnvelopeTime=1̏ꍇA64/1[Hz]ŃGG[vlXV܂B
EnvelopeTime=2̏ꍇA64/2[Hz]ŃGG[vlXV܂B
...
EnvelopeTime=7̏ꍇA64/7[Hz]ŏo͎gXV܂B

64[Hz]͊{̓NbN4194304[Hz]1/65536łB
Gx[vH̓̓NbŃA{̓NbN1/65536ƍl܂B

--------
@
--------

o߃TCN~ςAEnvelopeTime*65536𒴂o͎gXV܂B
EnvelopeTime*65536Ɣr̂ŁAenvelope_timeɂ͂炩EnvelopeTime65536{(16rbgVtg)li[Ă܂B
Ă΁Ao߃TCN~ϒlenvelope_timê܂ܔr邾ōς݂܂B

Gx[visJE^̓_EJE^Ƃ܂B

==================
o͎g(g[)
==================

o͎gFoutA{̓NbNFinAo͎gݒlf̊֌W͎̒ʂłB

	Fout = Fin / 32 / (2048 - f)

g[̃f[eBݒ{1/8,2/8,4/8,6/8}Ȃ̂ŁA1g`8Xebvƍl܂B
g[̍Đ8TvPCM̍ĐƌȂƁAĐxFstep͎̒ʂłB

	Fstep = Fin / (32 / 8) / (2048 - f)
	      = Fin / 4 / (2048 - f)
	      = Fin / (2048*4 - f*4)
	      = Fin / (8192 - f*4)

--------
@
--------

frequencyɂ͂炩f*4(2rbgVtg)̒lݒ肵Ă܂B
(8192-f*4)ݒ肵ĂƂłAXC[vɂfXV̂Ń_łB
@XC[v͗ŕω̂ŁA炩4{Ă̂͑vłB

f*4frequencyɒuƁA

	Fstep = Fin / (8192 - frequency)

o߃TCN~ςA(8192-frequency)𒴂g`Xebvi߂܂B

	o߃TCN~: l=0
	...
	o߃TCN~ += o߃TCN;
	while(o߃TCN~ >= 8192 - frequency) {
		o߃TCN~ -= 8192 - frequency;
		g`Xebv++;
	}

͎̂悤ɒu܂B

	o߃TCN~: l=0
	...
	o߃TCN~ += o߃TCN;
	while(o߃TCN~ - 8192 >= -frequency) {
		o߃TCN~ -= 8192 - frequency;
		g`Xebv++;
	}

ɁA

	o߃TCN~: l=0
	...
	o߃TCN~ += o߃TCN;
	while(8192 - o߃TCN~ <= frequency) {
		o߃TCN~ -= 8192 - frequency;
		g`Xebv++;
	}

܂ł̏}܂B

	           8192-frequency
	 |                | frequency |
	0|----------------|-----------|8192
	 *====*====*====*====>
	    *====*====*====>
	  *====*====*====*====>

āA(8192-o߃TCN~)Al8192̃_EJE^ƌȂƁA

	_EJE^: l=8192
	...
	_EJE^ -= o߃TCN;
	while(_EJE^ <= frequency) {
		_EJE^ += 8192 - frequency;
		g`Xebv++;
	}

	         frequency
	 |           | 8192-frequency |
	0|-----------|----------------|8192
	          <====*====*====*====*
	            <====*====*====*
	         <====*====*====*====*

_EJE^̏l(8192-frequency)ƂƁA

	_EJE^: l=8192-frequency
	...
	_EJE^ -= o߃TCN;
	while(_EJE^ <= 0) {
		_EJE^ += 8192 - frequency;
		g`Xebv++;
	}

	             0         8192-frequency
	             |                |
	-------------|----------------|
	          <====*====*====*====*
	            <====*====*====*
	         <====*====*====*====*

`g̈ʑ͖ł̂ŁA_EJE^̏l(8192-frequency)ƂKv͂܂B
PɁA_EJE^̏l0ƂƁA

	_EJE^: l=0
	...
	_EJE^ -= o߃TCN;
	while(_EJE^ <= 0) {
		_EJE^ += 8192 - frequency;
		g`Xebv++;
	}

	             0         8192-frequency
	             |                |
	-------------|----------------|
	        <====*
	          <====*====*====*
	            <====*====*====*
	         <====*====*====*====*

===============
o͎g(PCM)
===============

o͎gFoutA{̓NbNFinAo͎gݒlf̊֌W͎̒ʂłB

	Fout = Fin / 64 / (2048 - f)

g`1Tv4rbgőS16oCgȂ̂ŁA1g`32Xebvƍl܂B
g[̍Đ32TvPCM̍ĐƌȂƁAĐxFstep͎̒ʂłB

	Fstep = Fin / (64 / 32) / (2048 - f)
	      = Fin / 2 / (2048 - f)
	      = Fin / (2048*2 - f*2)
	      = Fin / (4096 - f*2)

--------
@
--------

l̓g[ƓȂ̂ŏȗ܂B
g[Ƃ̑_Ă܂B

			g[		PCM
frequencyݒl		f*4		f*2
_EJE^l	8192		4096

==================
o͎g(mCY)
==================

vXP[o͎gFdivƊ{͎gFinAѕݒlƂ̊֌ẂA̒ʂłB

	ݒ(NR43[2:0])
	0	Fdiv = Fin / 8 * 2 = Fin / 4 /  1
	1	Fdiv = Fin / 8 * 1 = Fin / 4 /  2
	2	Fdiv = Fin / 8 / 2 = Fin / 4 /  4
	3	Fdiv = Fin / 8 / 3 = Fin / 4 /  6
	4	Fdiv = Fin / 8 / 4 = Fin / 4 /  8
	5	Fdiv = Fin / 8 / 5 = Fin / 4 / 10
	6	Fdiv = Fin / 8 / 6 = Fin / 4 / 12
	7	Fdiv = Fin / 8 / 7 = Fin / 4 / 14

̎

	Fdiv = Fin / 4 / A

	A = ݒl * 2	/* ݒl!=0̏ꍇ */
	A = 1			/* ݒl==0̏ꍇ */

ƕ\Ƃɂ܂B

VtgJE^͎gFshiftFdivAуVtgNbNgݒlƂ̊֌ẂA̒ʂłB

	VtgNbNgݒ(NR43[7:4])
	 0	Fshift = Fdiv / (2^ 1) = Fdiv / 2 / 2^ 0
	 1	Fshift = Fdiv / (2^ 2) = Fdiv / 2 / 2^ 1
	 2	Fshift = Fdiv / (2^ 3) = Fdiv / 2 / 2^ 2
	...
	13	Fshift = Fdiv / (2^13) = Fdiv / 2 / 2^13
	14	**
	15	**

̎

	Fshift = Fdiv / 2 / 2^B

	B = VtgNbNgݒl

ƕ\Ƃɂ܂B

قǂ̎Ƃ܂Ƃ߂ƁA

	Fshift = (Fin / 4 / A) / 2 / 2^B
	       = Fin / A / 2^B / 8
	       = Fin / A / 2^(B+3)
	       = Fin / (A * 2^(B+3))

܂A(A * 2^(B+3))[TCN]o߂閈ɁAVtgJE^1Xebvis܂B

--------
@
--------

炩߁A(A * 2^(B+3))vZADMGSOUNDNOISE.periodɊi[Ă܂B

	frequency = A * 2^(B+3)

	A = ݒl * 2	/* ݒl!=0̏ꍇ */
	A = 1			/* ݒl==0̏ꍇ */

	B = VtgNbNgݒl

o߃TCN~ςAfrequency𒴂xɃVtgJE^1Xebvi߂܂B

	AbvJE^: l=0

	AbvJE^ += o߃TCN;
	while(AbvJE^ >= frequency) {
		AbvJE^ -= frequency;
		VtgJE^is;
	}

rȒPɂ邽߁AJE^istɂ܂B

	_EJE^: l=frequency

	_EJE^ -= o߃TCN;
	while(_EJE^ <= 0) {
		_EJE^ += frequency;
		VtgJE^is;
	}

mCYg`̈ʑ͖ł̂ŁA_EJE^̏l(2^(B+3))ƂKv͂܂B

	_EJE^: l=0

	_EJE^ -= o߃TCN;
	while(_EJE^ <= 0) {
		_EJE^ += frequency;
		VtgJE^is;
	}

#endif

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
dmgsound_reset(DMGSOUND* ds, unsigned char* reg, int clock)
{
	/* ܂NAB */
	memset(ds, 0, sizeof(DMGSOUND));

	/* WX^i[B */
	ds->reg = reg;

	/* NbNisDDAZbgAbvB */
	ds->progress.u = clock / SPEAKER_FREQUENCY;	/* ̕ω */
	ds->progress.n = clock % SPEAKER_FREQUENCY;	/* [̑ */
	ds->progress.d =        -SPEAKER_FREQUENCY;	/* [ */
}

//void
//dmgsound_write(DMGSOUND* ds, unsigned char addr, unsigned char data)
//{
//	unsigned char* p;
//
//	/* ܂i[܂B */
//	ASSERT(addr >= 0x10 && addr <= 0x3f);
//	ds->reg[addr] = data;
//
//	/* WX^ݒl̃fR[hB */
//	switch(addr) {
//	/*========== Ch#1 ==========*/
//#define ch	(ds->ch1)
//#define reg(i)	(ds->reg[0x10 + (i)])
//	//case 0x10: /* NR10 */
//	//case 0x11: /* NR11 */
//	//case 0x12: /* NR12 */
//	//case 0x13: /* NR13 */
//	case 0x14: /* NR14 */
//		if(data & 0x80) {
//			/* Sound Length */
//			ch.sound_length = reg(4) & 0x40 ? (0x40 - (reg(1) & 0x3f)) << 14
//							: -1; /* INFINITE */
//			/* Sweep */
//			ch.sweep_time = (reg(0) & 0x70) << 11;
//			ch.sweep_up_down = (reg(0) >> 3) & 1;
//			ch.sweep_shift = reg(0) & 7;
//			ch.sweep_progress = ch.sweep_time;
//			/* Envelope */
//			ch.envelope = (reg(2) >> 4) & 0xf;
//			ch.envelope_time = (reg(2) & 7) << 16;
//			ch.envelope_up_down = (reg(2) >> 3) & 1;
//			ch.envelope_progress = ch.envelope_time;
//			/* Wave Pattern */
//			ch.wave_pattern = 0;
//			ch.wave_pattern_duty = (reg(1) >> 5) & 6;           /* 1=>2/8,2=>4/8,3=>6/8 */
//			if(!ch.wave_pattern_duty) ch.wave_pattern_duty = 1; /* 0=>1/8 */
//			/* Frequency */
//			ch.frequency = (reg(3) | ((reg(4) & 0x7) << 8)) << 2;
//			ch.frequency_progress = 0;
//		}
//		return;
//#undef ch
//#undef reg
//	/*========== Ch#2 ==========*/
//#define ch	(ds->ch2)
//#define reg(i)	(ds->reg[0x15 + (i)])
//	//0x15:NR20͂܂
//	//case 0x16: /* NR21 */
//	//case 0x17: /* NR22 */
//	//case 0x18: /* NR23 */
//	case 0x19: /* NR24 */
//		if(data & 0x80) {
//			/* Sound Length */
//			ch.sound_length = reg(4) & 0x40 ? (0x40 - (reg(1) & 0x3f)) << 14
//							: -1; /* INFINITE */
//			/* Envelope */
//			ch.envelope = (reg(2) >> 4) & 0xf;
//			ch.envelope_time = (reg(2) & 7) << 16;
//			ch.envelope_up_down = (reg(2) >> 3) & 1;
//			ch.envelope_progress = ch.envelope_time;
//			/* Wave Pattern */
//			ch.wave_pattern = 0;
//			ch.wave_pattern_duty = (reg(1) >> 5) & 6;           /* 1=>2/8,2=>4/8,3=>6/8 */
//			if(!ch.wave_pattern_duty) ch.wave_pattern_duty = 1; /* 0=>1/8 */
//			/* Frequency */
//			ch.frequency = (reg(3) | ((reg(4) & 0x7) << 8)) << 2;
//			ch.frequency_progress = 0;
//		}
//		return;
//#undef ch
//#undef reg
//	/*========== Ch#3 ==========*/
//#define ch	(ds->ch3)
//#define reg(i)	(ds->reg[0x1a + (i)])
//	case 0x1a: /* NR30 */
//		ch.sound_on_off = (data >> 7) & 1; /* KeyOnƔ񓯊ON/OFF\(?) */
//		return;
//	//case 0x1b: /* NR31 */
//	//case 0x1c: /* NR32 */
//	//case 0x1d: /* NR33 */
//	case 0x1e: /* NR34 */
//		if(data & 0x80) {
//			/* Sound Length */
//			ch.sound_length = reg(4) & 0x40 ? (0x100 - reg(1)) << 21
//							: -1; /* INFINITE */
//			/* Output Level */
//			ch.output_level = (reg(2) >> 5) & 3;
//			/* Wave Pattern */
//			ch.wave_pattern = 0;
//			/* Frequency */
//			ch.frequency = (reg(3) | ((reg(4) & 0x7) << 8)) << 1;
//			ch.frequency_progress = 0;
//		}
//		return;
//	case 0x30: /* AUD3W[0] */
//	case 0x31: /* AUD3W[1] */
//	case 0x32: /* AUD3W[2] */
//	case 0x33: /* AUD3W[3] */
//	case 0x34: /* AUD3W[4] */
//	case 0x35: /* AUD3W[5] */
//	case 0x36: /* AUD3W[6] */
//	case 0x37: /* AUD3W[7] */
//	case 0x38: /* AUD3W[8] */
//	case 0x39: /* AUD3W[9] */
//	case 0x3a: /* AUD3W[a] */
//	case 0x3b: /* AUD3W[b] */
//	case 0x3c: /* AUD3W[c] */
//	case 0x3d: /* AUD3W[d] */
//	case 0x3e: /* AUD3W[e] */
//	case 0x3f: /* AUD3W[f] */
//		p = &ch.wave_pattern_ram[(addr - 0x30) << 1];
//		p[0] = ((data >> 3) & 0x1e) - 15; /* ʃju */
//		p[1] = ((data << 1) & 0x1e) - 15; /* ʃju */
//		return;
//#undef ch
//#undef reg
//	/*========== Ch#4 ==========*/
//#define ch	(ds->ch4)
//#define reg(i)	(ds->reg[0x1f + (i)])
//	//0x1f:NR40͂܂
//	//case 0x20: /* NR41 */
//	//case 0x21: /* NR42 */
//	//case 0x22: /* NR43 */
//	case 0x23: /* NR44 */
//		if(data & 0x80) {
//			/* Sound Length */
//			ch.sound_length = reg(4) & 0x40 ? (0x40 - (reg(1) & 0x3f)) << 14
//							: -1; /* INFINITE */
//			/* Envelope */
//			ch.envelope = (reg(2) >> 4) & 0xf;
//			ch.envelope_time = (reg(2) & 7) << 16;
//			ch.envelope_up_down = (reg(2) >> 3) & 1;
//			ch.envelope_progress = ch.envelope_time;
//			/* LFSR */
//			ch.lfsr = 1;
//			ch.lfsr_bits = (reg(3) >> 3) & 1;
//			/* Frequency */
//			ch.frequency = (reg(3) & 7) << 1;
//			if(!ch.frequency) ch.frequency = 1;
//			ch.frequency <<= (((reg(3) >> 4) & 0xf) + 3);
//			ch.frequency_progress = 0;
//		}
//		return;
//#undef ch
//#undef reg
//	/*========== Misc ==========*/
//	case 0x24: /* NR50 */
//		ds->volume[0] =  data       & 7;
//		ds->volume[1] = (data >> 4) & 7;
//		return;
//	case 0x25: /* NR51 */
//		ds->sound_output = data;
//		return;
//	case 0x26: /* NR52 */
//		ds->all_sound_on_off = (data >> 7) & 1;
//		/* bit3-0́uSound # ON flagv́Aǂݏop̃Xe[^XtOłB
//		 * 񂾒lɂĊe`lON/OFF𐧌䂷̂ł͂܂B
//		 */
//		return;
//	}
//
////#ifndef PIECE
////	/* ݂ȂWX^ւ̏? */
////	DIE();
////#endif /*PIECE*/
////2005/02/14 폜
//// * Mon Feb 14 20:30:00 JST 2005 Naoyuki Sawa
//// - NR10-13NR21-23Ȃǂ́Ali[邾ŁAswitch()ŏĂȂ̂ŁA
////   ݂郌WX^ւ݂̏łA֗邱Ƃ̂łB
////   P/ECEł́ÃubN̓RpCȂ̂ŁACt܂łB
////   Win32ƁAsシɏ̃ubNDIE()Ɉ܂B
////   NoĂ܂Ct̂(^^;A폜܂B
//}
// * Fri Feb 25 20:40:00 JST 2005 Naoyuki Sawa
// - JnȊOɂ`lp[^ύXł悤ɏC܂B
// ܂ŁANRx4ւ݂̏ɂ锭Jn̂݃`lp[^ݒ肵A
// I܂Ńp[^ύXȂ悤ɎĂ܂AłB
// NRx0-NRx3D7=0NRx4֏ނƂŁAłp[^ύX\łB
void
dmgsound_write(DMGSOUND* ds, unsigned char addr, unsigned char data)
{
	unsigned char* p;

	/* ܂i[܂B */
	ASSERT(addr >= 0x10 && addr <= 0x3f);
	ds->reg[addr] = data;

	/* WX^ݒl̃fR[hB */
	switch(addr) {
	/*========== Ch#1 ==========*/
#define ch	(ds->ch1)
#define reg(i)	(ds->reg[0x10 + (i)])
	case 0x10: /* NR10 */
		/* Sweep */
		ch.sweep_time = (reg(0) & 0x70) << 11;
		ch.sweep_up_down = (reg(0) >> 3) & 1;
		ch.sweep_shift = reg(0) & 7;
		ch.sweep_progress = ch.sweep_time;
		return;
	case 0x11: /* NR11 */
		/* Wave Pattern */
		ch.wave_pattern_duty = (reg(1) >> 5) & 6;           /* 1=>2/8,2=>4/8,3=>6/8 */
		if(!ch.wave_pattern_duty) ch.wave_pattern_duty = 1; /* 0=>1/8 */
		ch.wave_pattern = 0;
		return;
	case 0x12: /* NR12 */
		/* Envelope */
		ch.envelope = (reg(2) >> 4) & 0xf;
		ch.envelope_time = (reg(2) & 7) << 16;
		ch.envelope_up_down = (reg(2) >> 3) & 1;
		ch.envelope_progress = ch.envelope_time;
		return;
	case 0x13: /* NR13 */
		/* Frequency */
		ch.frequency = (reg(3) | ((reg(4) & 0x7) << 8)) << 2;
		ch.frequency_progress = 0;
		return;
	case 0x14: /* NR14 */
		/* Frequency */
		ch.frequency = (reg(3) | ((reg(4) & 0x7) << 8)) << 2;
		ch.frequency_progress = 0;
		if(data & 0x80) {
			/* Sound Length */
			ch.sound_length = reg(4) & 0x40 ? (0x40 - (reg(1) & 0x3f)) << 14
							: -1; /* INFINITE */
		}
		return;
#undef ch
#undef reg
	/*========== Ch#2 ==========*/
#define ch	(ds->ch2)
#define reg(i)	(ds->reg[0x15 + (i)])
	//0x15:NR20͂܂
	case 0x16: /* NR21 */
		/* Wave Pattern */
		ch.wave_pattern_duty = (reg(1) >> 5) & 6;           /* 1=>2/8,2=>4/8,3=>6/8 */
		if(!ch.wave_pattern_duty) ch.wave_pattern_duty = 1; /* 0=>1/8 */
		ch.wave_pattern = 0;
		return;
	case 0x17: /* NR22 */
		/* Envelope */
		ch.envelope = (reg(2) >> 4) & 0xf;
		ch.envelope_time = (reg(2) & 7) << 16;
		ch.envelope_up_down = (reg(2) >> 3) & 1;
		ch.envelope_progress = ch.envelope_time;
		return;
	case 0x18: /* NR23 */
		/* Frequency */
		ch.frequency = (reg(3) | ((reg(4) & 0x7) << 8)) << 2;
		ch.frequency_progress = 0;
		return;
	case 0x19: /* NR24 */
		/* Frequency */
		ch.frequency = (reg(3) | ((reg(4) & 0x7) << 8)) << 2;
		ch.frequency_progress = 0;
		if(data & 0x80) {
			/* Sound Length */
			ch.sound_length = reg(4) & 0x40 ? (0x40 - (reg(1) & 0x3f)) << 14
							: -1; /* INFINITE */
		}
		return;
#undef ch
#undef reg
	/*========== Ch#3 ==========*/
#define ch	(ds->ch3)
#define reg(i)	(ds->reg[0x1a + (i)])
	case 0x1a: /* NR30 */
		ch.sound_on_off = (data >> 7) & 1; /* KeyOnƔ񓯊ON/OFF\(?) */
		return;
	//case 0x1b: /* NR31 */
	case 0x1c: /* NR32 */
		/* Output Level */
		ch.output_level = (reg(2) >> 5) & 3;
		return;
	case 0x1d: /* NR33 */
		/* Frequency */
		ch.frequency = (reg(3) | ((reg(4) & 0x7) << 8)) << 1;
		ch.frequency_progress = 0;
		return;
	case 0x1e: /* NR34 */
		/* Frequency */
		ch.frequency = (reg(3) | ((reg(4) & 0x7) << 8)) << 1;
		ch.frequency_progress = 0;
		if(data & 0x80) {
			/* Sound Length */
			ch.sound_length = reg(4) & 0x40 ? (0x100 - reg(1)) << 21
							: -1; /* INFINITE */
			/* Wave Pattern */
			ch.wave_pattern = 0;
		}
		return;
	case 0x30: /* AUD3W[0] */
	case 0x31: /* AUD3W[1] */
	case 0x32: /* AUD3W[2] */
	case 0x33: /* AUD3W[3] */
	case 0x34: /* AUD3W[4] */
	case 0x35: /* AUD3W[5] */
	case 0x36: /* AUD3W[6] */
	case 0x37: /* AUD3W[7] */
	case 0x38: /* AUD3W[8] */
	case 0x39: /* AUD3W[9] */
	case 0x3a: /* AUD3W[a] */
	case 0x3b: /* AUD3W[b] */
	case 0x3c: /* AUD3W[c] */
	case 0x3d: /* AUD3W[d] */
	case 0x3e: /* AUD3W[e] */
	case 0x3f: /* AUD3W[f] */
		p = &ch.wave_pattern_ram[(addr - 0x30) << 1];
		p[0] = ((data >> 3) & 0x1e) - 15; /* ʃju */
		p[1] = ((data << 1) & 0x1e) - 15; /* ʃju */
		return;
#undef ch
#undef reg
	/*========== Ch#4 ==========*/
#define ch	(ds->ch4)
#define reg(i)	(ds->reg[0x1f + (i)])
	//0x1f:NR40͂܂
	//case 0x20: /* NR41 */
	case 0x21: /* NR42 */
		/* Envelope */
		ch.envelope = (reg(2) >> 4) & 0xf;
		ch.envelope_time = (reg(2) & 7) << 16;
		ch.envelope_up_down = (reg(2) >> 3) & 1;
		ch.envelope_progress = ch.envelope_time;
		return;
	case 0x22: /* NR43 */
		/* LFSR */
		ch.lfsr_bits = (reg(3) >> 3) & 1;
		ch.lfsr = 1;
		/* Frequency */
		ch.frequency = (reg(3) & 7) << 1;
		if(!ch.frequency) ch.frequency = 1;
		ch.frequency <<= (((reg(3) >> 4) & 0xf) + 3);
		ch.frequency_progress = 0;
		return;
	case 0x23: /* NR44 */
		if(data & 0x80) {
			/* Sound Length */
			ch.sound_length = reg(4) & 0x40 ? (0x40 - (reg(1) & 0x3f)) << 14
							: -1; /* INFINITE */
		}
		return;
#undef ch
#undef reg
	/*========== Misc ==========*/
	case 0x24: /* NR50 */
		ds->volume[0] =  data       & 7;
		ds->volume[1] = (data >> 4) & 7;
		return;
	case 0x25: /* NR51 */
		ds->sound_output = data;
		return;
	case 0x26: /* NR52 */
		ds->all_sound_on_off = (data >> 7) & 1;
		/* bit3-0́uSound # ON flagv́Aǂݏop̃Xe[^XtOłB
		 * 񂾒lɂĊe`lON/OFF𐧌䂷̂ł͂܂B
		 */
		return;
	}

//#ifndef PIECE
//	/* ݂ȂWX^ւ̏? */
//	DIE();
//#endif /*PIECE*/
//2005/02/14 폜
// * Mon Feb 14 20:30:00 JST 2005 Naoyuki Sawa
// - NR10-13NR21-23Ȃǂ́Ali[邾ŁAswitch()ŏĂȂ̂ŁA
//   ݂郌WX^ւ݂̏łA֗邱Ƃ̂łB
//   P/ECEł́ÃubN̓RpCȂ̂ŁACt܂łB
//   Win32ƁAsシɏ̃ubNDIE()Ɉ܂B
//   NoĂ܂Ct̂(^^;A폜܂B
}

unsigned char
dmgsound_read(DMGSOUND* ds, unsigned char addr)
{
	int data;

	ASSERT(addr >= 0x10 && addr <= 0x3f);

	switch(addr) {
	case 0x26: /* NR52 */
		data = 0;
		if(ds->all_sound_on_off) data |= (1<<7);
		if(ds->ch1.sound_length) data |= (1<<0);
		if(ds->ch2.sound_length) data |= (1<<1);
		if(ds->ch3.sound_length) data |= (1<<2);
		if(ds->ch4.sound_length) data |= (1<<3);
		return data;
	}

	return ds->reg[addr];
}
