/*	
 *	clipdmg.c
 *
 *	P/ECE DMG-CPU Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Jan 15 20:09:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"
#include "clipdmgi.h"	/*DMGG~[^p}N*/

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	IyR[h}bv
 */
const DMGOP dmg_op_table[256/*XX*/] = {
#include "dmg/xx.h" /* [dmg.xls]XX */
};
const DMGOP dmg_op_table_CB[256/*XX*/] = {
#include "dmg/cb.h" /* [dmg.xls]CB */
};

/*
 *	j[jbNe[u
 */
#undef DMGFN_
#define DMGFN_(OP, FN)	OP "\0"
const char dmg_op_name_table[] = {
	"\0" /* ItZbg0̓k */
#include "dmg/list.h" /* [dmg.xls]List!C5 */
};
#undef DMGFN_

/****************************************************************************
 *
 ****************************************************************************/

/* GameBoy̋[IPLvO */
static const unsigned char gb_ipl_code[] = {
	0x3E,0x00,0xE0,0x05,	/* ld a,$00; ld (TIMA),a */
	0x3E,0x00,0xE0,0x06,	/* ld a,$00; ld (TMA ),a */
	0x3E,0x00,0xE0,0x07,	/* ld a,$00; ld (TAC ),a */
	0x3E,0x80,0xE0,0x10,	/* ld a,$80; ld (NR10),a */
	0x3E,0xBF,0xE0,0x11,	/* ld a,$BF; ld (NR11),a */
	0x3E,0xF3,0xE0,0x12,	/* ld a,$F3; ld (NR12),a */
	0x3E,0xBF,0xE0,0x14,	/* ld a,$BF; ld (NR14),a */
	0x3E,0x3F,0xE0,0x16,	/* ld a,$3F; ld (NR21),a */
	0x3E,0x00,0xE0,0x17,	/* ld a,$00; ld (NR22),a */
	0x3E,0xBF,0xE0,0x19,	/* ld a,$BF; ld (NR24),a */
	0x3E,0x7F,0xE0,0x1A,	/* ld a,$7F; ld (NR30),a */
	0x3E,0xFF,0xE0,0x1B,	/* ld a,$FF; ld (NR31),a */
	0x3E,0x9F,0xE0,0x1C,	/* ld a,$9F; ld (NR32),a */
	0x3E,0xBF,0xE0,0x1E,	/* ld a,$BF; ld (NR33),a */
	0x3E,0xFF,0xE0,0x20,	/* ld a,$FF; ld (NR41),a */
	0x3E,0x00,0xE0,0x21,	/* ld a,$00; ld (NR42),a */
	0x3E,0x00,0xE0,0x22,	/* ld a,$00; ld (NR43),a */
	0x3E,0xBF,0xE0,0x23,	/* ld a,$BF; ld (NR30),a */
	0x3E,0x77,0xE0,0x24,	/* ld a,$77; ld (NR50),a */
	0x3E,0xF3,0xE0,0x25,	/* ld a,$F3; ld (NR51),a */
	0x3E,0xF1,0xE0,0x26,	/* ld a,$F1; ld (NR52),a */
	0x3E,0x91,0xE0,0x40,	/* ld a,$91; ld (LCDC),a */
	0x3E,0x00,0xE0,0x42,	/* ld a,$00; ld (SCY ),a */
	0x3E,0x00,0xE0,0x43,	/* ld a,$00; ld (SCX ),a */
	0x3E,0x00,0xE0,0x45,	/* ld a,$00; ld (LYC ),a */
	0x3E,0xFC,0xE0,0x47,	/* ld a,$FC; ld (BGP ),a */
	0x3E,0xFF,0xE0,0x48,	/* ld a,$FF; ld (OBP0),a */
	0x3E,0xFF,0xE0,0x49,	/* ld a,$FF; ld (OBP1),a */
	0x3E,0x00,0xE0,0x4A,	/* ld a,$00; ld (WY  ),a */
	0x3E,0x00,0xE0,0x4B,	/* ld a,$00; ld (WX  ),a */
	0x3E,0x00,0xE0,0xFF,	/* ld a,$00; ld (IE  ),a */
	0x31,0xFE,0xFF,		/* ld sp,$FFFE */
	0x01,0xB0,0x01,		/* ld bc,$01B0 */
	0xC5,			/* push bc     */
	0xF1,			/* pop  af     */
	0x01,0x13,0x00,		/* ld bc,$0013 */
	0x11,0xD8,0x00,		/* ld de,$00D8 */
	0x21,0x4D,0x01,		/* ld hl,$014D */
	0xC3,0x00,0x01,		/* jp    $0100 */
};
/* [IPL]AhX(ύX) */
#define GB_IPL_ADDR	0xc000	/* 8kB Internal RAM */

void
dmg_reset(DMG* dmg, DMGREADPROC* read, DMGWRITEPROC* write, int gb_ipl)
{
	int i;

	memset(dmg, 0, sizeof(DMG));
	dmg->read  = read  ? read  : dmg_internal_read ;
	dmg->write = write ? write : dmg_internal_write;

	if(gb_ipl) { /* GameBoy[IPL */
		PC = GB_IPL_ADDR;
		for(i = 0; i < sizeof gb_ipl_code; i++) {
			dmg->write(dmg, (unsigned short)(PC + i), gb_ipl_code[i]);
		}
	}
}

void
dmg_check_pending(DMG* dmg)
{
	int IF; /* $FF0F (IF) */
	int IE; /* $FFFF (IE) */
	int factor;
	int mask;
	int new_pc;

	/* SĂ̊荞݂֎~ĂA܂B */
	if(!IME) return;

	/* 荞݋AAvĂv𒊏o܂B */
	IF = READ(0xff0f); /* $FF0F (IF) */
	IE = READ(0xffff); /* $FFFF (IE) */
	factor = IE & IF;

	/* Ô߁Agp̊荞ݗvrbg}XN܂B
	 * (IEAIF̖gprbgm0Ȃ΁Ȁ͕svłB)
	 */
	factor &= (DMG_V_BLANK |
		   DMG_LCDC_STATUS |
		   DMG_TIMER_OVERFLOW |
		   DMG_SERIAL_TRANSFER_COMPLETION |
		   DMG_HIGH_TO_LOW_OF_P10_P13);

	/* D揇Ɋ荞ݗv𒲂ׂāA荞݂s܂B */
	mask = 1 << 0;
	new_pc = 0x40;
	while(factor >= mask) {
		if(factor & mask) {
			IME = 0;
			HALT = 0;
			PUSH(PC);
			PC = new_pc;

			/* 󂯕tvɑΉIF́AIɃNA܂B(n[hEFAdl)
			 * $FF0F (IF)ւ݂̏ɂACWrite֐炽Ԃ
			 * dmg_check_pending()Ă΂邱ƂɂȂƎv܂AIME=0Ȃ̂ŁA
			 * dmg_check_pending()̐擪łɏԂAċA̘Aɂ͂Ȃ܂B
			 */
			IF &= ~mask;
			WRITE(0xff0f, IF); /* $FF0F (IF) */

			/* ǂɎ󂯕t銄荞ݗv͈łB
			 * ܎󂯕t荞ݗvDx̒Ⴂ荞ݗv́A
			 * ̊荞ݏIRETI܂EIĂ΂ꂽƂɎ󂯕t܂B
			 */
			return; /* YȂ!! */
		}
		mask <<= 1;
		new_pc += 0x08;
	}
}

void
dmg_dump(DMG* dmg)
{
#define INDENT	40
	TRACE("%*s", INDENT, "");
	TRACE("F:%c%c%c%c%c%c%c%c A:%02x BC:%04x DE:%04x HL:%04x SP:%04x PC:%04x\n",
		LO(AF) & (1 << 7) ? 'Z' : '-',
		LO(AF) & (1 << 6) ? 'N' : '-',
		LO(AF) & (1 << 5) ? 'H' : '-',
		LO(AF) & (1 << 4) ? 'C' : '-',
		LO(AF) & (1 << 3) ? '1' : '0', /* 0ŒB1ɂȂoOł */
		LO(AF) & (1 << 2) ? '1' : '0', /* 0ŒB1ɂȂoOł */
		LO(AF) & (1 << 1) ? '1' : '0', /* 0ŒB1ɂȂoOł */
		LO(AF) & (1 << 0) ? '1' : '0', /* 0ŒB1ɂȂoOł */
		HI(AF), BC, DE, HL, SP, PC);
#undef INDENT
}

/****************************************************************************
 *
 ****************************************************************************/

#ifdef PIECE

asm("
	.code
	.global dmg_run2
dmg_run2:
	pushn %r0
	ld.w %r0, %sp		; X^bNޔ
	xld.w %r10, 0x1000	; 0x0e00`0x1000ɃX^bNؑ
	ld.w %sp, %r10
	xcall dmg_run
	ld.w %sp, %r0		; X^bN
	popn %r0
	ret
");

#endif /*PIECE*/

/****************************************************************************
 *
 ****************************************************************************/

