;
;	clipdmca.s
;
;	P/ECE DMG-CPU (Sharp LR35902) Emulator ()
;	
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;	
;	* Sun Feb 13 03:10:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;	* Sat Mar 05 04:41:00 JST 2005 Naoyuki Sawa
;	- EI߂̊荞݋A1ߒx点܂B
;	  ܂ł́AEIߎsɊ荞݋Ă܂B
;	  1ߒxĊ荞݋̂AłB
;
#include "clipdmca.h"


;----------------------------------------------------------------------------
;
; * Wed Feb 23 21:55:00 JST 2005 Naoyuki Sawa
;
; - "jp.d %rb"́A΁ɎgĂ͂܂!!
;   ȉɁA̗RL܂B
;
; - ȑOAMOS6502G~[VvOƂɁA(framm65a.s)
;   u"jp.d %rb"̒OɃANZX߂DelaySlotsȂv
;   Ə܂A듮̏͂ꂾł͂܂łB
;   "jp.d %rb"𑽗pĂvOATEh炵ȂsƁA
;   Ƃǂ"jp.d %rb"̌DelaySlotɒu߂sȂȂ̂łB
;   ɁA"jp.d %rb"̒OŃTEhDMAɂ郁]ꍇɂA
;   "jp.d %rb"̌DelaySlotsȂ̂ł͂Ȃł傤H
;
; - {W[̍ŏ̎ł́AŌɃCgobN閽(LD (HL),AȂ)ŁA
;   sTCN炷"jp.d %rb"DelaySlotɓčĂ̂łA
;
;	#macro	LD_IHLI_A	$1
;		xld.uh	%addr, [%CPU+HL]	; %addr = HL
;		ld.w	%data, %A		; %data = A
;		jp.d	%WRITE			; WRITE(addr, data)
;		sub	%CYCLE, $1		; *delay*
;	#endm
;
;   ŏ͖Ȃ̂́ATEh炷ƁA"sub %CYCLE, $1"sȂ
;   ۂ悤ɂȂ܂B
;   As邽тɂǂ̈ʒuŔ邩słB
;   ̏Ǐ󂩂AOq̂悤ɐ܂B
;
; - _͎̒ʂłB
;
;	w"jp.d %rb"́A΁ɎgĂ͂܂!!x
;
;   {W[ɂāAقǎ́Â悤ɏ܂B
;   1TCNxȂ܂Aނ܂B
;
;	#macro	LD_IHLI_A	$1
;		xld.uh	%addr, [%CPU+HL]	; %addr = HL
;		ld.w	%data, %A		; %data = A
;		sub	%CYCLE, $1
;		jp	%WRITE			; WRITE(addr, data)
;	#endm
;
;   ȂAKɂAߋ"jp.d %rb"gĂW[͈܂łB
;   ("xjp.d rel"͂gĂ܂A͑vłB)
;
;----------------------------------------------------------------------------

;****************************************************************************
;	
;****************************************************************************

	.code
	.align	1

;****************************************************************************
;	
;****************************************************************************

dmgcpu_ERR:
	xcall	dmgcpu_leave			; sReLXg߂܂B
	xjp	dmgcpu_err			; Cł̃G[[`ցB

dmgcpu_CHECK_PENDING:
	xcall dmgcpu_leave			; sReLXg߂܂B
	xcall dmgcpu_check_pending		; ۗĂ荞݂΁As܂B
	xjp   dmgcpu_enter			; sReLXgo܂B

;****************************************************************************
;	8-Bit Loads
;****************************************************************************

#macro	LD_A_n		$1
	call.d	%READ				; %data = n
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	ld.w	%A, %data			; %A    = n
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LD_A_r		$1, $2
	xld.ub	%A, [%CPU+$2]			; %A = r
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LD_r_A		$1, $2
	xld.b	[%CPU+$2], %A			; r = A
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LD_A_IrrI	$1, $2
	xld.uh	%addr, [%CPU+$2]		; %addr = rr
	call	%READ				; %data = READ(addr)
	ld.w	%A, %data			; %A    = data
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LD_IrrI_A	$1, $2
	xld.uh	%addr, [%CPU+$2]		; %addr = rr
	ld.w	%data, %A			; %data = A
	sub	%CYCLE, $1
	jp	%WRITE				; WRITE(addr, data)
#endm

#macro	LD_InnI_A	$1
	call.d	%READ				; %data = LO(nn)
	ld.w	%addr, %PC			; %addr = PC   *delay*
	ld.w	%s0, %data			; %s0   = LO(nn)
	call.d	%READ				; %data = HI(nn)
	add	%addr, 1			; %addr = PC+1 *delay*
	xadd	%PC, %PC, 2			; %PC   = PC+2
	xsll	%data, 8			; %data = HI(nn)<<8
	or	%s0, %data			; %s0   = HI(nn)<<8|LO(nn)
	ld.w	%addr, %s0			; %addr = nn
	ld.w	%data, %A			; %data = A
	sub	%CYCLE, $1
	jp	%WRITE				; WRITE(addr, data)
#endm

#macro	LD_A_InnI	$1
	call.d	%READ				; %data = LO(nn)
	ld.w	%addr, %PC			; %addr = PC   *delay*
	ld.w	%s0, %data			; %s0   = LO(nn)
	call.d	%READ				; %data = HI(nn)
	add	%addr, 1			; %addr = PC+1 *delay*
	xadd	%PC, %PC, 2			; %PC   = PC+2
	xsll	%data, 8			; %data = HI(nn)<<8
	or	%s0, %data			; %s0   = HI(nn)<<8|LO(nn)
	call.d	%READ				; %data = READ(addr)
	ld.w	%addr, %s0			; %addr = nn   *delay*
	ld.w	%A, %data			; %A    = data
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LD_r_n		$1, $2
	call.d	%READ				; %data = n
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	xld.b	[%CPU+$2], %data		; r     = n
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LD_r_s		$1, $2, $3
	xld.ub	%data, [%CPU+$3]		; %data = s
	xld.b	[%CPU+$2], %data		; r     = s
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LD_r_IHLI	$1, $2
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = READ(HL)
	xld.b	[%CPU+$2], %data		; r     = data
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LD_IHLI_n	$1
	call.d	%READ				; %data = n
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	sub	%CYCLE, $1
	jp	%WRITE				; WRITE(addr, data)
#endm

#macro	LD_IHLI_A	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	ld.w	%data, %A			; %data = A
	sub	%CYCLE, $1
	jp	%WRITE				; WRITE(addr, data)
#endm

#macro	LD_IHLI_r	$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	sub	%CYCLE, $1
	jp	%WRITE				; WRITE(addr, data)
#endm

#macro	LD_A_ICI	$1
	xld.ub	%addr, [%CPU+C]			; %addr = C
	xoor	%addr, %addr, 0xff00		; %addr = C|0xff00
	call	%READ				; %data = READ(addr)
	ld.w	%A, %data			; %A    = data
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LD_ICI_A	$1
	xld.ub	%addr, [%CPU+C]			; %addr = C
	xoor	%addr, %addr, 0xff00		; %addr = C|0xff00
	ld.w	%data, %A			; %data = A
	sub	%CYCLE, $1
	jp	%WRITE				; WRITE(addr, data)
#endm

#macro	LDH_A_InI	$1
	call.d	%READ				; %data = n
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	xoor	%addr, %data, 0xff00		; %addr = n|0xff00
	call	%READ				; %data = READ(addr)
	ld.w	%A, %data			; %A    = data
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LDH_InI_A	$1
	call.d	%READ				; %data = n
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	xoor	%addr, %data, 0xff00		; %addr = n|0xff00
	ld.w	%data, %A			; %data = A
	sub	%CYCLE, $1
	jp	%WRITE				; WRITE(addr, data)
#endm

#macro	LDI_A_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = READ(addr)
	ld.w	%A, %data			; %A    = data
	xadd	%addr, %addr, 1			; %addr = HL+1
	xld.h	[%CPU+HL], %addr		; HL    = HL+1
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LDI_IHLI_A	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call.d	%WRITE				; WRITE(addr, data)
	ld.w	%data, %A			; %data = A *delay*
	xadd	%addr, %addr, 1			; %addr = HL+1
	xld.h	[%CPU+HL], %addr		; HL    = HL+1
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LDD_A_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = READ(addr)
	ld.w	%A, %data			; %A    = data
	xsub	%addr, %addr, 1			; %addr = HL-1
	xld.h	[%CPU+HL], %addr		; HL    = HL-1
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LDD_IHLI_A	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call.d	%WRITE				; WRITE(addr, data)
	ld.w	%data, %A			; %data = A *delay*
	xsub	%addr, %addr, 1			; %addr = HL-1
	xld.h	[%CPU+HL], %addr		; HL    = HL-1
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

;----------------------------------------------------------------------------

dmgcpu_LD_A_n:
	LD_A_n		CYCLE_LD_A_n
dmgcpu_LD_A_A:
	ret.d	; ** no job **
	sub	%CYCLE, CYCLE_LD_A_A		; *delay*
dmgcpu_LD_A_B:
	LD_A_r		CYCLE_LD_A_B, B
dmgcpu_LD_A_C:
	LD_A_r		CYCLE_LD_A_C, C
dmgcpu_LD_A_D:
	LD_A_r		CYCLE_LD_A_D, D
dmgcpu_LD_A_E:
	LD_A_r		CYCLE_LD_A_E, E
dmgcpu_LD_A_H:
	LD_A_r		CYCLE_LD_A_H, H
dmgcpu_LD_A_L:
	LD_A_r		CYCLE_LD_A_L, L
dmgcpu_LD_A_IHLI:
	LD_A_IrrI	CYCLE_LD_A_IHLI, HL

dmgcpu_LD_B_n:
	LD_r_n		CYCLE_LD_B_n, B
dmgcpu_LD_B_A:
	LD_r_A		CYCLE_LD_B_A, B
dmgcpu_LD_B_B:
	ret.d	; ** no job **
	sub	%CYCLE, CYCLE_LD_B_B		; *delay*
dmgcpu_LD_B_C:
	LD_r_s		CYCLE_LD_B_C, B, C
dmgcpu_LD_B_D:
	LD_r_s		CYCLE_LD_B_D, B, D
dmgcpu_LD_B_E:
	LD_r_s		CYCLE_LD_B_E, B, E
dmgcpu_LD_B_H:
	LD_r_s		CYCLE_LD_B_H, B, H
dmgcpu_LD_B_L:
	LD_r_s		CYCLE_LD_B_L, B, L
dmgcpu_LD_B_IHLI:
	LD_r_IHLI	CYCLE_LD_B_IHLI, B

dmgcpu_LD_C_n:
	LD_r_n		CYCLE_LD_C_n, C
dmgcpu_LD_C_A:
	LD_r_A		CYCLE_LD_C_A, C
dmgcpu_LD_C_B:
	LD_r_s		CYCLE_LD_C_B, C, B
dmgcpu_LD_C_C:
	ret.d	; ** no job **
	sub	%CYCLE, CYCLE_LD_C_C		; *delay*
dmgcpu_LD_C_D:
	LD_r_s		CYCLE_LD_C_D, C, D
dmgcpu_LD_C_E:
	LD_r_s		CYCLE_LD_C_E, C, E
dmgcpu_LD_C_H:
	LD_r_s		CYCLE_LD_C_H, C, H
dmgcpu_LD_C_L:
	LD_r_s		CYCLE_LD_C_L, C, L
dmgcpu_LD_C_IHLI:
	LD_r_IHLI	CYCLE_LD_C_IHLI, C

dmgcpu_LD_D_n:
	LD_r_n		CYCLE_LD_D_n, D
dmgcpu_LD_D_A:
	LD_r_A		CYCLE_LD_D_A, D
dmgcpu_LD_D_B:
	LD_r_s		CYCLE_LD_D_B, D, B
dmgcpu_LD_D_C:
	LD_r_s		CYCLE_LD_D_C, D, C
dmgcpu_LD_D_D:
	ret.d	; ** no job **
	sub	%CYCLE, CYCLE_LD_D_D		; *delay*
dmgcpu_LD_D_E:
	LD_r_s		CYCLE_LD_D_E, D, E
dmgcpu_LD_D_H:
	LD_r_s		CYCLE_LD_D_H, D, H
dmgcpu_LD_D_L:
	LD_r_s		CYCLE_LD_D_L, D, L
dmgcpu_LD_D_IHLI:
	LD_r_IHLI	CYCLE_LD_D_IHLI, D

dmgcpu_LD_E_n:
	LD_r_n		CYCLE_LD_E_n, E
dmgcpu_LD_E_A:
	LD_r_A		CYCLE_LD_E_A, E
dmgcpu_LD_E_B:
	LD_r_s		CYCLE_LD_E_B, E, B
dmgcpu_LD_E_C:
	LD_r_s		CYCLE_LD_E_C, E, C
dmgcpu_LD_E_D:
	LD_r_s		CYCLE_LD_E_D, E, D
dmgcpu_LD_E_E:
	ret.d	; ** no job **
	sub	%CYCLE, CYCLE_LD_E_E		; *delay*
dmgcpu_LD_E_H:
	LD_r_s		CYCLE_LD_E_H, E, H
dmgcpu_LD_E_L:
	LD_r_s		CYCLE_LD_E_L, E, L
dmgcpu_LD_E_IHLI:
	LD_r_IHLI	CYCLE_LD_E_IHLI, E

dmgcpu_LD_H_n:
	LD_r_n		CYCLE_LD_H_n, H
dmgcpu_LD_H_A:
	LD_r_A		CYCLE_LD_H_A, H
dmgcpu_LD_H_B:
	LD_r_s		CYCLE_LD_H_B, H, B
dmgcpu_LD_H_C:
	LD_r_s		CYCLE_LD_H_C, H, C
dmgcpu_LD_H_D:
	LD_r_s		CYCLE_LD_H_D, H, D
dmgcpu_LD_H_E:
	LD_r_s		CYCLE_LD_H_E, H, E
dmgcpu_LD_H_H:
	ret.d	; ** no job **
	sub	%CYCLE, CYCLE_LD_H_H		; *delay*
dmgcpu_LD_H_L:
	LD_r_s		CYCLE_LD_H_L, H, L
dmgcpu_LD_H_IHLI:
	LD_r_IHLI	CYCLE_LD_H_IHLI, H

dmgcpu_LD_L_n:
	LD_r_n		CYCLE_LD_L_n, L
dmgcpu_LD_L_A:
	LD_r_A		CYCLE_LD_L_A, L
dmgcpu_LD_L_B:
	LD_r_s		CYCLE_LD_L_B, L, B
dmgcpu_LD_L_C:
	LD_r_s		CYCLE_LD_L_C, L, C
dmgcpu_LD_L_D:
	LD_r_s		CYCLE_LD_L_D, L, D
dmgcpu_LD_L_E:
	LD_r_s		CYCLE_LD_L_E, L, E
dmgcpu_LD_L_H:
	LD_r_s		CYCLE_LD_L_H, L, H
dmgcpu_LD_L_L:
	ret.d	; ** no job **
	sub	%CYCLE, CYCLE_LD_L_L		; *delay*
dmgcpu_LD_L_IHLI:
	LD_r_IHLI	CYCLE_LD_L_IHLI, L

dmgcpu_LD_IHLI_n:
	LD_IHLI_n	CYCLE_LD_IHLI_n
dmgcpu_LD_IHLI_A:
	LD_IHLI_A	CYCLE_LD_IHLI_A
dmgcpu_LD_IHLI_B:
	LD_IHLI_r	CYCLE_LD_IHLI_B, B
dmgcpu_LD_IHLI_C:
	LD_IHLI_r	CYCLE_LD_IHLI_C, C
dmgcpu_LD_IHLI_D:
	LD_IHLI_r	CYCLE_LD_IHLI_D, D
dmgcpu_LD_IHLI_E:
	LD_IHLI_r	CYCLE_LD_IHLI_E, E
dmgcpu_LD_IHLI_H:
	LD_IHLI_r	CYCLE_LD_IHLI_H, H
dmgcpu_LD_IHLI_L:
	LD_IHLI_r	CYCLE_LD_IHLI_L, L

dmgcpu_LD_A_InnI:
	LD_A_InnI	CYCLE_LD_A_InnI
dmgcpu_LD_InnI_A:
	LD_InnI_A	CYCLE_LD_InnI_A
dmgcpu_LD_A_IBCI:
	LD_A_IrrI	CYCLE_LD_A_IBCI, BC
dmgcpu_LD_IBCI_A:
	LD_IrrI_A	CYCLE_LD_IBCI_A, BC
dmgcpu_LD_A_IDEI:
	LD_A_IrrI	CYCLE_LD_A_IDEI, DE
dmgcpu_LD_IDEI_A:
	LD_IrrI_A	CYCLE_LD_IDEI_A, DE

dmgcpu_LD_A_ICI:
	LD_A_ICI	CYCLE_LD_A_ICI
dmgcpu_LD_ICI_A:
	LD_ICI_A	CYCLE_LD_ICI_A
dmgcpu_LDH_A_InI:
	LDH_A_InI	CYCLE_LDH_A_InI
dmgcpu_LDH_InI_A:
	LDH_InI_A	CYCLE_LDH_InI_A

dmgcpu_LDI_A_IHLI:
	LDI_A_IHLI	CYCLE_LDI_A_IHLI
dmgcpu_LDI_IHLI_A:
	LDI_IHLI_A	CYCLE_LDI_IHLI_A
dmgcpu_LDD_A_IHLI:
	LDD_A_IHLI	CYCLE_LDD_A_IHLI
dmgcpu_LDD_IHLI_A:
	LDD_IHLI_A	CYCLE_LDD_IHLI_A

;****************************************************************************
;	16-Bit Loads
;****************************************************************************

#macro	LD_rr_nn	$1, $2
	call.d	%READ				; %data = LO(nn)
	ld.w	%addr, %PC			; %addr = PC   *delay*
	xld.b	[%CPU+$2+0], %data		; LO(rr) = LO(nn)
	call.d	%READ				; %data = HI(nn)
	add	%addr, 1			; %addr = PC+1 *delay*
	xld.b	[%CPU+$2+1], %data		; HI(rr) = HI(nn)
	xadd	%PC, %PC, 2			; %PC   = PC+2
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LD_SP_HL	$1
	xld.uh	%data, [%CPU+HL]		; %data = HL
	xld.h	[%CPU+SP], %data		; SP    = HL
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

;
; Flags affected:
;	Z - Reset.
;	N - Reset.
;	H - Set or reset according to operation.
;	C - Set or reset according to operation.
;
; [note]
;	dmgcpu_LDHL_SP_edmgcpu_ADD_SP_e邽߂Ɏg܂B
;
#macro	LD_rr_SP_e	$1, $2
	call.d	%READ				; %data = e (   0.. 255)
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	ld.b	%data, %data			; %data = e (-128..+127)
	xld.uh	%t0, [%CPU+SP]			; %t0   = SP
	xand	%t1, %t0, 0x0fff		; %t1   = 0000spsp spspspsp
	add	%t0, %data			; %t0   = SP+e
	xld.h	[%CPU+$2], %t0			; rr    = SP+e
	xsrl	%t0, 8				; %t0   = -------C --------
	xoor	%t0, %t0, 1			; %t0   = -------C -------1
	xld.h	[%CPU+CZ], %t0			; CF    = -------C zzzzzzzz (z!=0 -> Z-Reset)
	xand	%data, %data, 0x0fff		; %data = 0000eeee eeeeeeee
	add	%t1, %data			; %t1   = 000H---- --------
	xsrl	%t1, 8				; %t1   = 000H----
	xld.b	[%CPU+NH], %t1			; NH    = --NH---- (N=0)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	LD_InnI_SP	$1
	call.d	%READ				; %data = LO(nn)
	ld.w	%addr, %PC			; %addr = PC   *delay*
	ld.w	%s0, %data			; %s0   = LO(nn)
	call.d	%READ				; %data = HI(nn)
	add	%addr, 1			; %addr = PC+1 *delay*
	xadd	%PC, %PC, 2			; %PC   = PC+2
	xsll	%data, 8			; %data = HI(nn)<<8
	or	%s0, %data			; %s0   = HI(nn)<<8|LO(nn)
	xld.ub	%data, [%CPU+SP+0]		; %data = LO(SP)
	call.d	%WRITE				; WRITE(nn+0, LO(SP))
	ld.w	%addr, %s0			; %addr = nn+0 *delay*
	xld.ub	%data, [%CPU+SP+1]		; %data = HI(SP)
	xadd	%addr, %addr, 1			; %addr = nn+1 *delay*
	sub	%CYCLE, $1
	jp	%WRITE				; WRITE(nn+1, HI(SP))
#endm

#macro	PUSH_AF		$1
	xcall	dmgcpu_pack			; %data = pack(CZ,NH)
	ld.w	%t0, %A				; %t0   = A
	xsll	%t0, 8				; %t0   = A<<8
	xcall.d	dmgcpu_push			; PUSH(data)
	or	%data, %t0			; %data = AF *delay*
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	POP_AF		$1
	xcall	dmgcpu_pop			; %data = POP()
	ld.w	%A, %data			; %A    = AF
	xsrl	%A, 8				; %A    = A
	xjp.d	dmgcpu_unpack			; CZ,NH = unpack(F)
	sub	%CYCLE, $1			; *delay*
#endm

#macro	PUSH_rr		$1, $2
	xld.uh	%data, [%CPU+$2]		; %data = rr
	xjp.d	dmgcpu_push			; PUSH(data)
	sub	%CYCLE, $1			; *delay*
#endm

#macro	POP_rr		$1, $2
	xcall	dmgcpu_pop			; %data = POP()
	xld.h	[%CPU+$2], %data		; rr    = data
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

;----------------------------------------------------------------------------

dmgcpu_LD_BC_nn:
	LD_rr_nn	CYCLE_LD_BC_nn, BC
dmgcpu_LD_DE_nn:
	LD_rr_nn	CYCLE_LD_DE_nn, DE
dmgcpu_LD_HL_nn:
	LD_rr_nn	CYCLE_LD_HL_nn, HL
dmgcpu_LD_SP_nn:
	LD_rr_nn	CYCLE_LD_SP_nn, SP

dmgcpu_LD_SP_HL:
	LD_SP_HL	CYCLE_LD_SP_HL
dmgcpu_LDHL_SP_e:
	LD_rr_SP_e	CYCLE_LDHL_SP_e, HL
dmgcpu_LD_InnI_SP:
	LD_InnI_SP	CYCLE_LD_InnI_SP

dmgcpu_PUSH_AF:
	PUSH_AF		CYCLE_PUSH_AF
dmgcpu_PUSH_BC:
	PUSH_rr		CYCLE_PUSH_BC, BC
dmgcpu_PUSH_DE:
	PUSH_rr		CYCLE_PUSH_DE, DE
dmgcpu_PUSH_HL:
	PUSH_rr		CYCLE_PUSH_HL, HL

dmgcpu_POP_AF:
	POP_AF		CYCLE_POP_AF
dmgcpu_POP_BC:
	POP_rr		CYCLE_POP_BC, BC
dmgcpu_POP_DE:
	POP_rr		CYCLE_POP_DE, DE
dmgcpu_POP_HL:
	POP_rr		CYCLE_POP_HL, HL

;****************************************************************************
;	8-Bit ALU
;****************************************************************************

#macro	ADD_A_n		$1
	call.d	%READ				; %data = n
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	xjp.d	dmgcpu_add			; %A    = A+n
	sub	%CYCLE, $1			; *delay*
#endm

#macro	ADD_A_A		$1
	ld.w	%data, %A			; %data = A
	xjp.d	dmgcpu_add			; %A    = A+A
	sub	%CYCLE, $1			; *delay*
#endm

#macro	ADD_A_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xjp.d	dmgcpu_add			; %A    = A+r
	sub	%CYCLE, $1			; *delay*
#endm

#macro	ADD_A_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = READ(addr)
	xjp.d	dmgcpu_add			; %A    = A+[HL]
	sub	%CYCLE, $1			; *delay*
#endm

#macro	ADC_A_n		$1
	call.d	%READ				; %data = n
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	xjp.d	dmgcpu_adc			; %A    = A+n+C
	sub	%CYCLE, $1			; *delay*
#endm

#macro	ADC_A_A		$1
	ld.w	%data, %A			; %data = A
	xjp.d	dmgcpu_adc			; %A    = A+A+C
	sub	%CYCLE, $1			; *delay*
#endm

#macro	ADC_A_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xjp.d	dmgcpu_adc			; %A    = A+r+C
	sub	%CYCLE, $1			; *delay*
#endm

#macro	ADC_A_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = READ(addr)
	xjp.d	dmgcpu_adc			; %A    = A+[HL]+C
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SUB_n		$1
	call.d	%READ				; %data = n
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	xjp.d	dmgcpu_sub			; %A    = A-n
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SUB_A		$1
	ld.w	%data, %A			; %data = A
	xjp.d	dmgcpu_sub			; %A    = A-A
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SUB_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xjp.d	dmgcpu_sub			; %A    = A-r
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SUB_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = READ(addr)
	xjp.d	dmgcpu_sub			; %A    = A-[HL]
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SBC_A_n		$1
	call.d	%READ				; %data = n
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	xjp.d	dmgcpu_sbc			; %A    = A-n-C
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SBC_A_A		$1
	ld.w	%data, %A			; %data = A
	xjp.d	dmgcpu_sbc			; %A    = A-A-C
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SBC_A_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xjp.d	dmgcpu_sbc			; %A    = A-r-C
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SBC_A_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = READ(addr)
	xjp.d	dmgcpu_sbc			; %A    = A-[HL]-C
	sub	%CYCLE, $1			; *delay*
#endm

#macro	CP_n		$1
	call.d	%READ				; %data = n
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	xjp.d	dmgcpu_cp			; test    A-n
	sub	%CYCLE, $1			; *delay*
#endm

#macro	CP_A		$1
	ld.w	%data, %A			; %data = A
	xjp.d	dmgcpu_cp			; test    A-A
	sub	%CYCLE, $1			; *delay*
#endm

#macro	CP_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xjp.d	dmgcpu_cp			; test    A-r
	sub	%CYCLE, $1			; *delay*
#endm

#macro	CP_IHLI		$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = READ(addr)
	xjp.d	dmgcpu_cp			; test    A-[HL]
	sub	%CYCLE, $1			; *delay*
#endm

#macro	AND_n		$1
	call.d	%READ				; %data = n
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	xjp.d	dmgcpu_and			; %A    = A&n
	sub	%CYCLE, $1			; *delay*
#endm

#macro	AND_A		$1
	ld.w	%data, %A			; %data = A
	xjp.d	dmgcpu_and			; %A    = A&A
	sub	%CYCLE, $1			; *delay*
#endm

#macro	AND_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xjp.d	dmgcpu_and			; %A    = A&r
	sub	%CYCLE, $1			; *delay*
#endm

#macro	AND_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = READ(addr)
	xjp.d	dmgcpu_and			; %A    = A&[HL]
	sub	%CYCLE, $1			; *delay*
#endm

#macro	OR_n		$1
	call.d	%READ				; %data = n
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	xjp.d	dmgcpu_or			; %A    = A|n
	sub	%CYCLE, $1			; *delay*
#endm

#macro	OR_A		$1
	ld.w	%data, %A			; %data = A
	xjp.d	dmgcpu_or			; %A    = A|A
	sub	%CYCLE, $1			; *delay*
#endm

#macro	OR_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xjp.d	dmgcpu_or			; %A    = A|r
	sub	%CYCLE, $1			; *delay*
#endm

#macro	OR_IHLI		$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = READ(addr)
	xjp.d	dmgcpu_or			; %A    = A|[HL]
	sub	%CYCLE, $1			; *delay*
#endm

#macro	XOR_n		$1
	call.d	%READ				; %data = n
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	xjp.d	dmgcpu_xor			; %A    = A^n
	sub	%CYCLE, $1			; *delay*
#endm

#macro	XOR_A		$1
	ld.w	%data, %A			; %data = A
	xjp.d	dmgcpu_xor			; %A    = A^A
	sub	%CYCLE, $1			; *delay*
#endm

#macro	XOR_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xjp.d	dmgcpu_xor			; %A    = A^r
	sub	%CYCLE, $1			; *delay*
#endm

#macro	XOR_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = READ(addr)
	xjp.d	dmgcpu_xor			; %A    = A^[HL]
	sub	%CYCLE, $1			; *delay*
#endm

#macro	INC_A		$1
	xcall.d	dmgcpu_inc			; %data = A+1
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = A+1
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	INC_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xcall	dmgcpu_inc			; %data = r+1
	xld.b	[%CPU+$2], %data		; r     = r+1
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	INC_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = [HL]
	xcall.d	dmgcpu_inc			; %data = [HL]+1
	sub	%CYCLE, $1			; *delay*
	jp	%WRITE				; [HL]  = [HL]+1
#endm

#macro	DEC_A		$1
	xcall.d	dmgcpu_dec			; %data = A-1
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = A-1
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	DEC_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xcall	dmgcpu_dec			; %data = r-1
	xld.b	[%CPU+$2], %data		; r     = r-1
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	DEC_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = [HL]
	xcall.d	dmgcpu_dec			; %data = [HL]-1
	sub	%CYCLE, $1			; *delay*
	jp	%WRITE				; [HL]  = [HL]-1
#endm

;----------------------------------------------------------------------------

dmgcpu_ADD_A_n:
	ADD_A_n		CYCLE_ADD_A_n
dmgcpu_ADD_A_A:
	ADD_A_A		CYCLE_ADD_A_A
dmgcpu_ADD_A_B:
	ADD_A_r		CYCLE_ADD_A_B, B
dmgcpu_ADD_A_C:
	ADD_A_r		CYCLE_ADD_A_C, C
dmgcpu_ADD_A_D:
	ADD_A_r		CYCLE_ADD_A_D, D
dmgcpu_ADD_A_E:
	ADD_A_r		CYCLE_ADD_A_E, E
dmgcpu_ADD_A_H:
	ADD_A_r		CYCLE_ADD_A_H, H
dmgcpu_ADD_A_L:
	ADD_A_r		CYCLE_ADD_A_L, L
dmgcpu_ADD_A_IHLI:
	ADD_A_IHLI	CYCLE_ADD_A_IHLI

dmgcpu_ADC_A_n:
	ADC_A_n		CYCLE_ADC_A_n
dmgcpu_ADC_A_A:
	ADC_A_A		CYCLE_ADC_A_A
dmgcpu_ADC_A_B:
	ADC_A_r		CYCLE_ADC_A_B, B
dmgcpu_ADC_A_C:
	ADC_A_r		CYCLE_ADC_A_C, C
dmgcpu_ADC_A_D:
	ADC_A_r		CYCLE_ADC_A_D, D
dmgcpu_ADC_A_E:
	ADC_A_r		CYCLE_ADC_A_E, E
dmgcpu_ADC_A_H:
	ADC_A_r		CYCLE_ADC_A_H, H
dmgcpu_ADC_A_L:
	ADC_A_r		CYCLE_ADC_A_L, L
dmgcpu_ADC_A_IHLI:
	ADC_A_IHLI	CYCLE_ADC_A_IHLI

dmgcpu_SUB_n:
	SUB_n		CYCLE_SUB_n
dmgcpu_SUB_A:
	SUB_A		CYCLE_SUB_A
dmgcpu_SUB_B:
	SUB_r		CYCLE_SUB_B, B
dmgcpu_SUB_C:
	SUB_r		CYCLE_SUB_C, C
dmgcpu_SUB_D:
	SUB_r		CYCLE_SUB_D, D
dmgcpu_SUB_E:
	SUB_r		CYCLE_SUB_E, E
dmgcpu_SUB_H:
	SUB_r		CYCLE_SUB_H, H
dmgcpu_SUB_L:
	SUB_r		CYCLE_SUB_L, L
dmgcpu_SUB_IHLI:
	SUB_IHLI	CYCLE_SUB_IHLI

dmgcpu_SBC_A_n:
	SBC_A_n		CYCLE_SBC_A_n
dmgcpu_SBC_A_A:
	SBC_A_A		CYCLE_SBC_A_A
dmgcpu_SBC_A_B:
	SBC_A_r		CYCLE_SBC_A_B, B
dmgcpu_SBC_A_C:
	SBC_A_r		CYCLE_SBC_A_C, C
dmgcpu_SBC_A_D:
	SBC_A_r		CYCLE_SBC_A_D, D
dmgcpu_SBC_A_E:
	SBC_A_r		CYCLE_SBC_A_E, E
dmgcpu_SBC_A_H:
	SBC_A_r		CYCLE_SBC_A_H, H
dmgcpu_SBC_A_L:
	SBC_A_r		CYCLE_SBC_A_L, L
dmgcpu_SBC_A_IHLI:
	SBC_A_IHLI	CYCLE_SBC_A_IHLI

dmgcpu_CP_n:
	CP_n		CYCLE_CP_n
dmgcpu_CP_A:
	CP_A		CYCLE_CP_A
dmgcpu_CP_B:
	CP_r		CYCLE_CP_B, B
dmgcpu_CP_C:
	CP_r		CYCLE_CP_C, C
dmgcpu_CP_D:
	CP_r		CYCLE_CP_D, D
dmgcpu_CP_E:
	CP_r		CYCLE_CP_E, E
dmgcpu_CP_H:
	CP_r		CYCLE_CP_H, H
dmgcpu_CP_L:
	CP_r		CYCLE_CP_L, L
dmgcpu_CP_IHLI:
	CP_IHLI		CYCLE_CP_IHLI

dmgcpu_AND_n:
	AND_n		CYCLE_AND_n
dmgcpu_AND_A:
	AND_A		CYCLE_AND_A
dmgcpu_AND_B:
	AND_r		CYCLE_AND_B, B
dmgcpu_AND_C:
	AND_r		CYCLE_AND_C, C
dmgcpu_AND_D:
	AND_r		CYCLE_AND_D, D
dmgcpu_AND_E:
	AND_r		CYCLE_AND_E, E
dmgcpu_AND_H:
	AND_r		CYCLE_AND_H, H
dmgcpu_AND_L:
	AND_r		CYCLE_AND_L, L
dmgcpu_AND_IHLI:
	AND_IHLI	CYCLE_AND_IHLI

dmgcpu_OR_n:
	OR_n		CYCLE_OR_n
dmgcpu_OR_A:
	OR_A		CYCLE_OR_A
dmgcpu_OR_B:
	OR_r		CYCLE_OR_B, B
dmgcpu_OR_C:
	OR_r		CYCLE_OR_C, C
dmgcpu_OR_D:
	OR_r		CYCLE_OR_D, D
dmgcpu_OR_E:
	OR_r		CYCLE_OR_E, E
dmgcpu_OR_H:
	OR_r		CYCLE_OR_H, H
dmgcpu_OR_L:
	OR_r		CYCLE_OR_L, L
dmgcpu_OR_IHLI:
	OR_IHLI		CYCLE_OR_IHLI

dmgcpu_XOR_n:
	XOR_n		CYCLE_XOR_n
dmgcpu_XOR_A:
	XOR_A		CYCLE_XOR_A
dmgcpu_XOR_B:
	XOR_r		CYCLE_XOR_B, B
dmgcpu_XOR_C:
	XOR_r		CYCLE_XOR_C, C
dmgcpu_XOR_D:
	XOR_r		CYCLE_XOR_D, D
dmgcpu_XOR_E:
	XOR_r		CYCLE_XOR_E, E
dmgcpu_XOR_H:
	XOR_r		CYCLE_XOR_H, H
dmgcpu_XOR_L:
	XOR_r		CYCLE_XOR_L, L
dmgcpu_XOR_IHLI:
	XOR_IHLI	CYCLE_XOR_IHLI

dmgcpu_INC_A:
	INC_A		CYCLE_INC_A
dmgcpu_INC_B:
	INC_r		CYCLE_INC_B, B
dmgcpu_INC_C:
	INC_r		CYCLE_INC_C, C
dmgcpu_INC_D:
	INC_r		CYCLE_INC_D, D
dmgcpu_INC_E:
	INC_r		CYCLE_INC_E, E
dmgcpu_INC_H:
	INC_r		CYCLE_INC_H, H
dmgcpu_INC_L:
	INC_r		CYCLE_INC_L, L
dmgcpu_INC_IHLI:
	INC_IHLI	CYCLE_INC_IHLI

dmgcpu_DEC_A:
	DEC_A		CYCLE_DEC_A
dmgcpu_DEC_B:
	DEC_r		CYCLE_DEC_B, B
dmgcpu_DEC_C:
	DEC_r		CYCLE_DEC_C, C
dmgcpu_DEC_D:
	DEC_r		CYCLE_DEC_D, D
dmgcpu_DEC_E:
	DEC_r		CYCLE_DEC_E, E
dmgcpu_DEC_H:
	DEC_r		CYCLE_DEC_H, H
dmgcpu_DEC_L:
	DEC_r		CYCLE_DEC_L, L
dmgcpu_DEC_IHLI:
	DEC_IHLI	CYCLE_DEC_IHLI

;****************************************************************************
;	16-Bit Arithmetic
;****************************************************************************

#macro	ADD_HL_rr	$1, $2
	xld.uh	%data, [%CPU+$2]		; %data = rr
	xjp.d	dmgcpu_addw			; HL    = HL+rr
	sub	%CYCLE, $1			; *delay*
#endm

;
; Flags affected:
;	None.
;
#macro	INC_rr		$1, $2
	xld.uh	%t0, [%CPU+$2]
	xadd	%t0, %t0, 1
	xld.h	[%CPU+$2], %t0
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

;
; Flags affected:
;	None.
;
#macro	DEC_rr		$1, $2
	xld.uh	%t0, [%CPU+$2]
	xsub	%t0, %t0, 1
	xld.h	[%CPU+$2], %t0
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

;----------------------------------------------------------------------------

dmgcpu_ADD_HL_BC:
	ADD_HL_rr	CYCLE_ADD_HL_BC, BC
dmgcpu_ADD_HL_DE:
	ADD_HL_rr	CYCLE_ADD_HL_DE, DE
dmgcpu_ADD_HL_HL:
	ADD_HL_rr	CYCLE_ADD_HL_HL, HL
dmgcpu_ADD_HL_SP:
	ADD_HL_rr	CYCLE_ADD_HL_SP, SP
dmgcpu_ADD_SP_e:
	LD_rr_SP_e	CYCLE_ADD_SP_e, SP

dmgcpu_INC_BC:
	INC_rr		CYCLE_INC_BC, BC
dmgcpu_INC_DE:
	INC_rr		CYCLE_INC_DE, DE
dmgcpu_INC_HL:
	INC_rr		CYCLE_INC_HL, HL
dmgcpu_INC_SP:
	INC_rr		CYCLE_INC_SP, SP

dmgcpu_DEC_BC:
	DEC_rr		CYCLE_DEC_BC, BC
dmgcpu_DEC_DE:
	DEC_rr		CYCLE_DEC_DE, DE
dmgcpu_DEC_HL:
	DEC_rr		CYCLE_DEC_HL, HL
dmgcpu_DEC_SP:
	DEC_rr		CYCLE_DEC_SP, SP

;****************************************************************************
;	Miscellaneous
;****************************************************************************

#macro	SWAP_A		$1
	xcall.d	dmgcpu_swap			; %data = SWAP(A)
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = SWAP(A)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SWAP_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xcall	dmgcpu_swap			; %data = SWAP(r)
	xld.b	[%CPU+$2], %data		; r     = SWAP(r)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SWAP_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = [HL]
	xcall.d	dmgcpu_swap			; %data = SWAP([HL])
	sub	%CYCLE, $1			; *delay*
	jp	%WRITE				; [HL]  = SWAP([HL])
#endm

;----------------------------------------------------------------------------

dmgcpu_SWAP_A:
	SWAP_A		CYCLE_SWAP_A
dmgcpu_SWAP_B:
	SWAP_r		CYCLE_SWAP_B, B
dmgcpu_SWAP_C:
	SWAP_r		CYCLE_SWAP_C, C
dmgcpu_SWAP_D:
	SWAP_r		CYCLE_SWAP_D, D
dmgcpu_SWAP_E:
	SWAP_r		CYCLE_SWAP_E, E
dmgcpu_SWAP_H:
	SWAP_r		CYCLE_SWAP_H, H
dmgcpu_SWAP_L:
	SWAP_r		CYCLE_SWAP_L, L
dmgcpu_SWAP_IHLI:
	SWAP_IHLI	CYCLE_SWAP_IHLI

;
; Flags affected:
;	Z - Set if register A is zero.
;	N - Not affected.
;	H - Reset.
;	C - Set or reset according to operation.
;
dmgcpu_DAA:
	xcall	dmgcpu_leave
	xcall	dmgcpu_daa
	xjp	dmgcpu_enter

;
; Flags affected:
;	Z - Not affected.
;	N - Set.
;	H - Set.
;	C - Not affected.
;
dmgcpu_CPL:
	not	%A, %A				; %A  = ~A
	ld.ub	%A, %A				; (Kv!!)
	xld.w	%t0, -1				; %t0 = 11111111
	xld.b	[%CPU+NH], %t0			; NH  = --NH---- (N=1,H=1)
	ret.d
	sub	%CYCLE, CYCLE_CPL		; *delay*

;
; Flags affected:
;	Z - Not affected.
;	N - Reset.
;	H - Reset.
;	C - Set.
;
dmgcpu_SCF:
	xbset	[%CPU+CZ+1], 0			; CF = 1
	xld.b	[%CPU+NH], %r8			; NH = --NH---- (N=0,H=0)
	ret.d
	sub	%CYCLE, CYCLE_SCF		; *delay*

;
; Flags affected:
;	Z - Not affected.
;	N - Reset.
;	H - Reset.
;	C - Complemented.
;
dmgcpu_CCF:
	xbnot	[%CPU+CZ+1], 0			; CF = !CF
	xld.b	[%CPU+NH], %r8			; NH = --NH---- (N=0,H=0)
	ret.d
	sub	%CYCLE, CYCLE_CCF		; *delay*

dmgcpu_NOP:
	ret.d	; ** no job **
	sub	%CYCLE, CYCLE_NOP		; *delay*

dmgcpu_HALT:
	xbset	[%CPU+FLAGS], HALT_BIT		; HALT = 1
	ret.d
	;sub	%CYCLE, CYCLE_HALT		; *delay*
	;csTCNjAdmgcpu_run𔲂܂B
	ld.w	%CYCLE, 0			; *delay*

dmgcpu_STOP:
	xbset	[%CPU+FLAGS], STOP_BIT		; STOP = 1
	ret.d
	;sub	%CYCLE, CYCLE_STOP		; *delay*
	;csTCNjAdmgcpu_run𔲂܂B
	ld.w	%CYCLE, 0			; *delay*

dmgcpu_DI:
	xbclr	[%CPU+FLAGS], IME_BIT		; IME = 0
	ret.d
	sub	%CYCLE, CYCLE_DI		; *delay*

dmgcpu_EI:
	; EI̖̒߂sŁA荞݂܂B
	; Ɋ荞݂Ă܂ƁA"Bubble_Bobble_(J).zip"삵܂B
	;/*{{dmgcpu_runRs[*/
#ifdef DMGCPU_RUN_TRACE
	xcall dmgcpu_leave
	xcall dmgcpu_trace
	xcall dmgcpu_enter
#endif /*DMGCPU_RUN_TRACE*/
	call.d	%READ				; OpCode擾APCi߂܂B
	ld.w	%addr, %PC
	xadd	%PC, %PC, 1
	xsll	%data, 2			; OpCodeɑΉ閽߃[`Ăяo܂B
	ext	dmgcpu_XXops@ah
	ext	dmgcpu_XXops@al
	ld.w	%data, [%data]
	call	%data
	;/*}}dmgcpu_runRs[*/
	xbset	[%CPU+FLAGS], IME_BIT		; IME = 1
	xjp.d	dmgcpu_CHECK_PENDING		; ۗĂ荞݂΁As܂B
	sub	%CYCLE, CYCLE_EI		; *delay*

;****************************************************************************
;	Rotates & Shifts
;****************************************************************************

#macro	RL_A		$1
	xcall.d	dmgcpu_rl			; %data = RL(A)
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = RL(A)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	RL_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xcall	dmgcpu_rl			; %data = RL(r)
	xld.b	[%CPU+$2], %data		; r     = RL(r)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	RL_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = [HL]
	xcall.d	dmgcpu_rl			; %data = RL([HL])
	sub	%CYCLE, $1			; *delay*
	jp	%WRITE				; [HL]  = RL([HL])
#endm

#macro	RLC_A		$1
	xcall.d	dmgcpu_rlc			; %data = RLC(A)
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = RLC(A)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	RLC_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xcall	dmgcpu_rlc			; %data = RLC(r)
	xld.b	[%CPU+$2], %data		; r     = RLC(r)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	RLC_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = [HL]
	xcall.d	dmgcpu_rlc			; %data = RLC([HL])
	sub	%CYCLE, $1			; *delay*
	jp	%WRITE				; [HL]  = RLC([HL])
#endm

#macro	RR_A		$1
	xcall.d	dmgcpu_rr			; %data = RR(A)
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = RR(A)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	RR_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xcall	dmgcpu_rr			; %data = RR(r)
	xld.b	[%CPU+$2], %data		; r     = RR(r)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	RR_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = [HL]
	xcall.d	dmgcpu_rr			; %data = RR([HL])
	sub	%CYCLE, $1			; *delay*
	jp	%WRITE				; [HL]  = RR([HL])
#endm

#macro	RRC_A		$1
	xcall.d	dmgcpu_rrc			; %data = RRC(A)
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = RRC(A)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	RRC_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xcall	dmgcpu_rrc			; %data = RRC(r)
	xld.b	[%CPU+$2], %data		; r     = RRC(r)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	RRC_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = [HL]
	xcall.d	dmgcpu_rrc			; %data = RRC([HL])
	sub	%CYCLE, $1			; *delay*
	jp	%WRITE				; [HL]  = RRC([HL])
#endm

#macro	SLA_A		$1
	xcall.d	dmgcpu_sla			; %data = SLA(A)
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = SLA(A)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SLA_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xcall	dmgcpu_sla			; %data = SLA(r)
	xld.b	[%CPU+$2], %data		; r     = SLA(r)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SLA_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = [HL]
	xcall.d	dmgcpu_sla			; %data = SLA([HL])
	sub	%CYCLE, $1			; *delay*
	jp	%WRITE				; [HL]  = SLA([HL])
#endm

#macro	SRA_A		$1
	xcall.d	dmgcpu_sra			; %data = SRA(A)
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = SRA(A)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SRA_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xcall	dmgcpu_sra			; %data = SRA(r)
	xld.b	[%CPU+$2], %data		; r     = SRA(r)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SRA_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = [HL]
	xcall.d	dmgcpu_sra			; %data = SRA([HL])
	sub	%CYCLE, $1			; *delay*
	jp	%WRITE				; [HL]  = SRA([HL])
#endm

#macro	SRL_A		$1
	xcall.d	dmgcpu_srl			; %data = SRL(A)
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = SRL(A)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SRL_r		$1, $2
	xld.ub	%data, [%CPU+$2]		; %data = r
	xcall	dmgcpu_srl			; %data = SRL(r)
	xld.b	[%CPU+$2], %data		; r     = SRL(r)
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SRL_IHLI	$1
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call	%READ				; %data = [HL]
	xcall.d	dmgcpu_srl			; %data = SRL([HL])
	sub	%CYCLE, $1			; *delay*
	jp	%WRITE				; [HL]  = SRL([HL])
#endm

;----------------------------------------------------------------------------

;
; Flags affected:
;	Z - Reset.
;	N - Reset.
;	H - Reset.
;	C - Contains old bit 7 data.
;
dmgcpu_RLA:
	xcall.d	dmgcpu_rl			; %data = RL(A)
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = RL(A)
	xbset	[%CPU+CZ+0], 0			; ZF    = -------1 (z!=0 -> Z-Reset)
	ret.d
	sub	%CYCLE, CYCLE_RLA		; *delay*

;
; Flags affected:
;	Z - Reset.
;	N - Reset.
;	H - Reset.
;	C - Contains old bit 7 data.
;
dmgcpu_RLCA:
	xcall.d	dmgcpu_rlc			; %data = RLC(A)
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = RLC(A)
	xbset	[%CPU+CZ+0], 0			; ZF    = -------1 (z!=0 -> Z-Reset)
	ret.d
	sub	%CYCLE, CYCLE_RLCA		; *delay*

;
; Flags affected:
;	Z - Reset.
;	N - Reset.
;	H - Reset.
;	C - Contains old bit 0 data.
;
dmgcpu_RRA:
	xcall.d	dmgcpu_rr			; %data = RR(A)
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = RR(A)
	xbset	[%CPU+CZ+0], 0			; ZF    = -------1 (z!=0 -> Z-Reset)
	ret.d
	sub	%CYCLE, CYCLE_RRA		; *delay*

;
; Flags affected:
;	Z - Reset.
;	N - Reset.
;	H - Reset.
;	C - Contains old bit 0 data.
;
dmgcpu_RRCA:
	xcall.d	dmgcpu_rrc			; %data = RRC(A)
	ld.w	%data, %A			; %data = A *delay*
	ld.w	%A, %data			; %A    = RRC(A)
	xbset	[%CPU+CZ+0], 0			; ZF    = -------1 (z!=0 -> Z-Reset)
	ret.d
	sub	%CYCLE, CYCLE_RRCA		; *delay*

dmgcpu_RL_A:
	RL_A		CYCLE_RL_A
dmgcpu_RL_B:
	RL_r		CYCLE_RL_B, B
dmgcpu_RL_C:
	RL_r		CYCLE_RL_C, C
dmgcpu_RL_D:
	RL_r		CYCLE_RL_D, D
dmgcpu_RL_E:
	RL_r		CYCLE_RL_E, E
dmgcpu_RL_H:
	RL_r		CYCLE_RL_H, H
dmgcpu_RL_L:
	RL_r		CYCLE_RL_L, L
dmgcpu_RL_IHLI:
	RL_IHLI		CYCLE_RL_IHLI

dmgcpu_RLC_A:
	RLC_A		CYCLE_RLC_A
dmgcpu_RLC_B:
	RLC_r		CYCLE_RLC_B, B
dmgcpu_RLC_C:
	RLC_r		CYCLE_RLC_C, C
dmgcpu_RLC_D:
	RLC_r		CYCLE_RLC_D, D
dmgcpu_RLC_E:
	RLC_r		CYCLE_RLC_E, E
dmgcpu_RLC_H:
	RLC_r		CYCLE_RLC_H, H
dmgcpu_RLC_L:
	RLC_r		CYCLE_RLC_L, L
dmgcpu_RLC_IHLI:
	RLC_IHLI	CYCLE_RLC_IHLI

dmgcpu_RR_A:
	RR_A		CYCLE_RR_A
dmgcpu_RR_B:
	RR_r		CYCLE_RR_B, B
dmgcpu_RR_C:
	RR_r		CYCLE_RR_C, C
dmgcpu_RR_D:
	RR_r		CYCLE_RR_D, D
dmgcpu_RR_E:
	RR_r		CYCLE_RR_E, E
dmgcpu_RR_H:
	RR_r		CYCLE_RR_H, H
dmgcpu_RR_L:
	RR_r		CYCLE_RR_L, L
dmgcpu_RR_IHLI:
	RR_IHLI		CYCLE_RR_IHLI

dmgcpu_RRC_A:
	RRC_A		CYCLE_RRC_A
dmgcpu_RRC_B:
	RRC_r		CYCLE_RRC_B, B
dmgcpu_RRC_C:
	RRC_r		CYCLE_RRC_C, C
dmgcpu_RRC_D:
	RRC_r		CYCLE_RRC_D, D
dmgcpu_RRC_E:
	RRC_r		CYCLE_RRC_E, E
dmgcpu_RRC_H:
	RRC_r		CYCLE_RRC_H, H
dmgcpu_RRC_L:
	RRC_r		CYCLE_RRC_L, L
dmgcpu_RRC_IHLI:
	RRC_IHLI	CYCLE_RRC_IHLI

dmgcpu_SLA_A:
	SLA_A		CYCLE_SLA_A
dmgcpu_SLA_B:
	SLA_r		CYCLE_SLA_B, B
dmgcpu_SLA_C:
	SLA_r		CYCLE_SLA_C, C
dmgcpu_SLA_D:
	SLA_r		CYCLE_SLA_D, D
dmgcpu_SLA_E:
	SLA_r		CYCLE_SLA_E, E
dmgcpu_SLA_H:
	SLA_r		CYCLE_SLA_H, H
dmgcpu_SLA_L:
	SLA_r		CYCLE_SLA_L, L
dmgcpu_SLA_IHLI:
	SLA_IHLI	CYCLE_SLA_IHLI

dmgcpu_SRA_A:
	SRA_A		CYCLE_SRA_A
dmgcpu_SRA_B:
	SRA_r		CYCLE_SRA_B, B
dmgcpu_SRA_C:
	SRA_r		CYCLE_SRA_C, C
dmgcpu_SRA_D:
	SRA_r		CYCLE_SRA_D, D
dmgcpu_SRA_E:
	SRA_r		CYCLE_SRA_E, E
dmgcpu_SRA_H:
	SRA_r		CYCLE_SRA_H, H
dmgcpu_SRA_L:
	SRA_r		CYCLE_SRA_L, L
dmgcpu_SRA_IHLI:
	SRA_IHLI	CYCLE_SRA_IHLI

dmgcpu_SRL_A:
	SRL_A		CYCLE_SRL_A
dmgcpu_SRL_B:
	SRL_r		CYCLE_SRL_B, B
dmgcpu_SRL_C:
	SRL_r		CYCLE_SRL_C, C
dmgcpu_SRL_D:
	SRL_r		CYCLE_SRL_D, D
dmgcpu_SRL_E:
	SRL_r		CYCLE_SRL_E, E
dmgcpu_SRL_H:
	SRL_r		CYCLE_SRL_H, H
dmgcpu_SRL_L:
	SRL_r		CYCLE_SRL_L, L
dmgcpu_SRL_IHLI:
	SRL_IHLI	CYCLE_SRL_IHLI

;****************************************************************************
;	Bit Opcodes
;****************************************************************************

#macro	BIT_b_A		$1, $2
	ld.w	%data, %A			; %data = A
	xld.w	%s0, $2				; %s0   = b
	xjp.d	dmgcpu_bit			; BIT(A,b)
	sub	%CYCLE, $1			; *delay*
#endm

#macro	BIT_b_r		$1, $2, $3
	xld.ub	%data, [%CPU+$3]		; %data = r
	xld.w	%s0, $2				; %s0   = b
	xjp.d	dmgcpu_bit			; BIT(r,b)
	sub	%CYCLE, $1			; *delay*
#endm

#macro	BIT_b_IHLI	$1, $2
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call.d	%READ				; %data = [HL]
	xld.w	%s0, $2				; %s0   = b *delay*
	xjp.d	dmgcpu_bit			; BIT([HL],b)
	sub	%CYCLE, $1			; *delay*
#endm

;
; Flags affected:
;	None.
;
#macro	SET_b_A		$1, $2
	xoor	%A, %A, (1<<$2)			; A[b] = 1
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SET_b_r		$1, $2, $3
	xbset	[%CPU+$3], $2			; r[b] = 1
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	SET_b_IHLI	$1, $2
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call.d	%READ				; %data = [HL]
	sub	%CYCLE, $1			; *delay*
	xoor	%data, %data, (1<<$2)		; %data = [HL]|(1<<b)
	jp	%WRITE				; [HL]  = [HL]|(1<<b)
#endm

;
; Flags affected:
;	None.
;
#macro	RES_b_A		$1, $2
	xand	%A, %A, ~(1<<$2)		; A[b] = 0
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	RES_b_r		$1, $2, $3
	xbclr	[%CPU+$3], $2			; r[b] = 0
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

#macro	RES_b_IHLI	$1, $2
	xld.uh	%addr, [%CPU+HL]		; %addr = HL
	call.d	%READ				; %data = [HL]
	sub	%CYCLE, $1			; *delay*
	xand	%data, %data, ~(1<<$2)		; %data = [HL]&~(1<<b)
	jp	%WRITE				; [HL]  = [HL]&~(1<<b)
#endm

;----------------------------------------------------------------------------

dmgcpu_BIT_0_A:
	BIT_b_A		CYCLE_BIT_0_A, 0
dmgcpu_BIT_0_B:
	BIT_b_r		CYCLE_BIT_0_B, 0, B
dmgcpu_BIT_0_C:
	BIT_b_r		CYCLE_BIT_0_C, 0, C
dmgcpu_BIT_0_D:
	BIT_b_r		CYCLE_BIT_0_D, 0, D
dmgcpu_BIT_0_E:
	BIT_b_r		CYCLE_BIT_0_E, 0, E
dmgcpu_BIT_0_H:
	BIT_b_r		CYCLE_BIT_0_H, 0, H
dmgcpu_BIT_0_L:
	BIT_b_r		CYCLE_BIT_0_L, 0, L
dmgcpu_BIT_0_IHLI:
	BIT_b_IHLI	CYCLE_BIT_0_IHLI, 0

dmgcpu_BIT_1_A:
	BIT_b_A		CYCLE_BIT_1_A, 1
dmgcpu_BIT_1_B:
	BIT_b_r		CYCLE_BIT_1_B, 1, B
dmgcpu_BIT_1_C:
	BIT_b_r		CYCLE_BIT_1_C, 1, C
dmgcpu_BIT_1_D:
	BIT_b_r		CYCLE_BIT_1_D, 1, D
dmgcpu_BIT_1_E:
	BIT_b_r		CYCLE_BIT_1_E, 1, E
dmgcpu_BIT_1_H:
	BIT_b_r		CYCLE_BIT_1_H, 1, H
dmgcpu_BIT_1_L:
	BIT_b_r		CYCLE_BIT_1_L, 1, L
dmgcpu_BIT_1_IHLI:
	BIT_b_IHLI	CYCLE_BIT_1_IHLI, 1

dmgcpu_BIT_2_A:
	BIT_b_A		CYCLE_BIT_2_A, 2
dmgcpu_BIT_2_B:
	BIT_b_r		CYCLE_BIT_2_B, 2, B
dmgcpu_BIT_2_C:
	BIT_b_r		CYCLE_BIT_2_C, 2, C
dmgcpu_BIT_2_D:
	BIT_b_r		CYCLE_BIT_2_D, 2, D
dmgcpu_BIT_2_E:
	BIT_b_r		CYCLE_BIT_2_E, 2, E
dmgcpu_BIT_2_H:
	BIT_b_r		CYCLE_BIT_2_H, 2, H
dmgcpu_BIT_2_L:
	BIT_b_r		CYCLE_BIT_2_L, 2, L
dmgcpu_BIT_2_IHLI:
	BIT_b_IHLI	CYCLE_BIT_2_IHLI, 2

dmgcpu_BIT_3_A:
	BIT_b_A		CYCLE_BIT_3_A, 3
dmgcpu_BIT_3_B:
	BIT_b_r		CYCLE_BIT_3_B, 3, B
dmgcpu_BIT_3_C:
	BIT_b_r		CYCLE_BIT_3_C, 3, C
dmgcpu_BIT_3_D:
	BIT_b_r		CYCLE_BIT_3_D, 3, D
dmgcpu_BIT_3_E:
	BIT_b_r		CYCLE_BIT_3_E, 3, E
dmgcpu_BIT_3_H:
	BIT_b_r		CYCLE_BIT_3_H, 3, H
dmgcpu_BIT_3_L:
	BIT_b_r		CYCLE_BIT_3_L, 3, L
dmgcpu_BIT_3_IHLI:
	BIT_b_IHLI	CYCLE_BIT_3_IHLI, 3

dmgcpu_BIT_4_A:
	BIT_b_A		CYCLE_BIT_4_A, 4
dmgcpu_BIT_4_B:
	BIT_b_r		CYCLE_BIT_4_B, 4, B
dmgcpu_BIT_4_C:
	BIT_b_r		CYCLE_BIT_4_C, 4, C
dmgcpu_BIT_4_D:
	BIT_b_r		CYCLE_BIT_4_D, 4, D
dmgcpu_BIT_4_E:
	BIT_b_r		CYCLE_BIT_4_E, 4, E
dmgcpu_BIT_4_H:
	BIT_b_r		CYCLE_BIT_4_H, 4, H
dmgcpu_BIT_4_L:
	BIT_b_r		CYCLE_BIT_4_L, 4, L
dmgcpu_BIT_4_IHLI:
	BIT_b_IHLI	CYCLE_BIT_4_IHLI, 4

dmgcpu_BIT_5_A:
	BIT_b_A		CYCLE_BIT_5_A, 5
dmgcpu_BIT_5_B:
	BIT_b_r		CYCLE_BIT_5_B, 5, B
dmgcpu_BIT_5_C:
	BIT_b_r		CYCLE_BIT_5_C, 5, C
dmgcpu_BIT_5_D:
	BIT_b_r		CYCLE_BIT_5_D, 5, D
dmgcpu_BIT_5_E:
	BIT_b_r		CYCLE_BIT_5_E, 5, E
dmgcpu_BIT_5_H:
	BIT_b_r		CYCLE_BIT_5_H, 5, H
dmgcpu_BIT_5_L:
	BIT_b_r		CYCLE_BIT_5_L, 5, L
dmgcpu_BIT_5_IHLI:
	BIT_b_IHLI	CYCLE_BIT_5_IHLI, 5

dmgcpu_BIT_6_A:
	BIT_b_A		CYCLE_BIT_6_A, 6
dmgcpu_BIT_6_B:
	BIT_b_r		CYCLE_BIT_6_B, 6, B
dmgcpu_BIT_6_C:
	BIT_b_r		CYCLE_BIT_6_C, 6, C
dmgcpu_BIT_6_D:
	BIT_b_r		CYCLE_BIT_6_D, 6, D
dmgcpu_BIT_6_E:
	BIT_b_r		CYCLE_BIT_6_E, 6, E
dmgcpu_BIT_6_H:
	BIT_b_r		CYCLE_BIT_6_H, 6, H
dmgcpu_BIT_6_L:
	BIT_b_r		CYCLE_BIT_6_L, 6, L
dmgcpu_BIT_6_IHLI:
	BIT_b_IHLI	CYCLE_BIT_6_IHLI, 6

dmgcpu_BIT_7_A:
	BIT_b_A		CYCLE_BIT_7_A, 7
dmgcpu_BIT_7_B:
	BIT_b_r		CYCLE_BIT_7_B, 7, B
dmgcpu_BIT_7_C:
	BIT_b_r		CYCLE_BIT_7_C, 7, C
dmgcpu_BIT_7_D:
	BIT_b_r		CYCLE_BIT_7_D, 7, D
dmgcpu_BIT_7_E:
	BIT_b_r		CYCLE_BIT_7_E, 7, E
dmgcpu_BIT_7_H:
	BIT_b_r		CYCLE_BIT_7_H, 7, H
dmgcpu_BIT_7_L:
	BIT_b_r		CYCLE_BIT_7_L, 7, L
dmgcpu_BIT_7_IHLI:
	BIT_b_IHLI	CYCLE_BIT_7_IHLI, 7

dmgcpu_SET_0_A:
	SET_b_A		CYCLE_SET_0_A, 0
dmgcpu_SET_0_B:
	SET_b_r		CYCLE_SET_0_B, 0, B
dmgcpu_SET_0_C:
	SET_b_r		CYCLE_SET_0_C, 0, C
dmgcpu_SET_0_D:
	SET_b_r		CYCLE_SET_0_D, 0, D
dmgcpu_SET_0_E:
	SET_b_r		CYCLE_SET_0_E, 0, E
dmgcpu_SET_0_H:
	SET_b_r		CYCLE_SET_0_H, 0, H
dmgcpu_SET_0_L:
	SET_b_r		CYCLE_SET_0_L, 0, L
dmgcpu_SET_0_IHLI:
	SET_b_IHLI	CYCLE_SET_0_IHLI, 0

dmgcpu_SET_1_A:
	SET_b_A		CYCLE_SET_1_A, 1
dmgcpu_SET_1_B:
	SET_b_r		CYCLE_SET_1_B, 1, B
dmgcpu_SET_1_C:
	SET_b_r		CYCLE_SET_1_C, 1, C
dmgcpu_SET_1_D:
	SET_b_r		CYCLE_SET_1_D, 1, D
dmgcpu_SET_1_E:
	SET_b_r		CYCLE_SET_1_E, 1, E
dmgcpu_SET_1_H:
	SET_b_r		CYCLE_SET_1_H, 1, H
dmgcpu_SET_1_L:
	SET_b_r		CYCLE_SET_1_L, 1, L
dmgcpu_SET_1_IHLI:
	SET_b_IHLI	CYCLE_SET_1_IHLI, 1

dmgcpu_SET_2_A:
	SET_b_A		CYCLE_SET_2_A, 2
dmgcpu_SET_2_B:
	SET_b_r		CYCLE_SET_2_B, 2, B
dmgcpu_SET_2_C:
	SET_b_r		CYCLE_SET_2_C, 2, C
dmgcpu_SET_2_D:
	SET_b_r		CYCLE_SET_2_D, 2, D
dmgcpu_SET_2_E:
	SET_b_r		CYCLE_SET_2_E, 2, E
dmgcpu_SET_2_H:
	SET_b_r		CYCLE_SET_2_H, 2, H
dmgcpu_SET_2_L:
	SET_b_r		CYCLE_SET_2_L, 2, L
dmgcpu_SET_2_IHLI:
	SET_b_IHLI	CYCLE_SET_2_IHLI, 2

dmgcpu_SET_3_A:
	SET_b_A		CYCLE_SET_3_A, 3
dmgcpu_SET_3_B:
	SET_b_r		CYCLE_SET_3_B, 3, B
dmgcpu_SET_3_C:
	SET_b_r		CYCLE_SET_3_C, 3, C
dmgcpu_SET_3_D:
	SET_b_r		CYCLE_SET_3_D, 3, D
dmgcpu_SET_3_E:
	SET_b_r		CYCLE_SET_3_E, 3, E
dmgcpu_SET_3_H:
	SET_b_r		CYCLE_SET_3_H, 3, H
dmgcpu_SET_3_L:
	SET_b_r		CYCLE_SET_3_L, 3, L
dmgcpu_SET_3_IHLI:
	SET_b_IHLI	CYCLE_SET_3_IHLI, 3

dmgcpu_SET_4_A:
	SET_b_A		CYCLE_SET_4_A, 4
dmgcpu_SET_4_B:
	SET_b_r		CYCLE_SET_4_B, 4, B
dmgcpu_SET_4_C:
	SET_b_r		CYCLE_SET_4_C, 4, C
dmgcpu_SET_4_D:
	SET_b_r		CYCLE_SET_4_D, 4, D
dmgcpu_SET_4_E:
	SET_b_r		CYCLE_SET_4_E, 4, E
dmgcpu_SET_4_H:
	SET_b_r		CYCLE_SET_4_H, 4, H
dmgcpu_SET_4_L:
	SET_b_r		CYCLE_SET_4_L, 4, L
dmgcpu_SET_4_IHLI:
	SET_b_IHLI	CYCLE_SET_4_IHLI, 4

dmgcpu_SET_5_A:
	SET_b_A		CYCLE_SET_5_A, 5
dmgcpu_SET_5_B:
	SET_b_r		CYCLE_SET_5_B, 5, B
dmgcpu_SET_5_C:
	SET_b_r		CYCLE_SET_5_C, 5, C
dmgcpu_SET_5_D:
	SET_b_r		CYCLE_SET_5_D, 5, D
dmgcpu_SET_5_E:
	SET_b_r		CYCLE_SET_5_E, 5, E
dmgcpu_SET_5_H:
	SET_b_r		CYCLE_SET_5_H, 5, H
dmgcpu_SET_5_L:
	SET_b_r		CYCLE_SET_5_L, 5, L
dmgcpu_SET_5_IHLI:
	SET_b_IHLI	CYCLE_SET_5_IHLI, 5

dmgcpu_SET_6_A:
	SET_b_A		CYCLE_SET_6_A, 6
dmgcpu_SET_6_B:
	SET_b_r		CYCLE_SET_6_B, 6, B
dmgcpu_SET_6_C:
	SET_b_r		CYCLE_SET_6_C, 6, C
dmgcpu_SET_6_D:
	SET_b_r		CYCLE_SET_6_D, 6, D
dmgcpu_SET_6_E:
	SET_b_r		CYCLE_SET_6_E, 6, E
dmgcpu_SET_6_H:
	SET_b_r		CYCLE_SET_6_H, 6, H
dmgcpu_SET_6_L:
	SET_b_r		CYCLE_SET_6_L, 6, L
dmgcpu_SET_6_IHLI:
	SET_b_IHLI	CYCLE_SET_6_IHLI, 6

dmgcpu_SET_7_A:
	SET_b_A		CYCLE_SET_7_A, 7
dmgcpu_SET_7_B:
	SET_b_r		CYCLE_SET_7_B, 7, B
dmgcpu_SET_7_C:
	SET_b_r		CYCLE_SET_7_C, 7, C
dmgcpu_SET_7_D:
	SET_b_r		CYCLE_SET_7_D, 7, D
dmgcpu_SET_7_E:
	SET_b_r		CYCLE_SET_7_E, 7, E
dmgcpu_SET_7_H:
	SET_b_r		CYCLE_SET_7_H, 7, H
dmgcpu_SET_7_L:
	SET_b_r		CYCLE_SET_7_L, 7, L
dmgcpu_SET_7_IHLI:
	SET_b_IHLI	CYCLE_SET_7_IHLI, 7

dmgcpu_RES_0_A:
	RES_b_A		CYCLE_RES_0_A, 0
dmgcpu_RES_0_B:
	RES_b_r		CYCLE_RES_0_B, 0, B
dmgcpu_RES_0_C:
	RES_b_r		CYCLE_RES_0_C, 0, C
dmgcpu_RES_0_D:
	RES_b_r		CYCLE_RES_0_D, 0, D
dmgcpu_RES_0_E:
	RES_b_r		CYCLE_RES_0_E, 0, E
dmgcpu_RES_0_H:
	RES_b_r		CYCLE_RES_0_H, 0, H
dmgcpu_RES_0_L:
	RES_b_r		CYCLE_RES_0_L, 0, L
dmgcpu_RES_0_IHLI:
	RES_b_IHLI	CYCLE_RES_0_IHLI, 0

dmgcpu_RES_1_A:
	RES_b_A		CYCLE_RES_1_A, 1
dmgcpu_RES_1_B:
	RES_b_r		CYCLE_RES_1_B, 1, B
dmgcpu_RES_1_C:
	RES_b_r		CYCLE_RES_1_C, 1, C
dmgcpu_RES_1_D:
	RES_b_r		CYCLE_RES_1_D, 1, D
dmgcpu_RES_1_E:
	RES_b_r		CYCLE_RES_1_E, 1, E
dmgcpu_RES_1_H:
	RES_b_r		CYCLE_RES_1_H, 1, H
dmgcpu_RES_1_L:
	RES_b_r		CYCLE_RES_1_L, 1, L
dmgcpu_RES_1_IHLI:
	RES_b_IHLI	CYCLE_RES_1_IHLI, 1

dmgcpu_RES_2_A:
	RES_b_A		CYCLE_RES_2_A, 2
dmgcpu_RES_2_B:
	RES_b_r		CYCLE_RES_2_B, 2, B
dmgcpu_RES_2_C:
	RES_b_r		CYCLE_RES_2_C, 2, C
dmgcpu_RES_2_D:
	RES_b_r		CYCLE_RES_2_D, 2, D
dmgcpu_RES_2_E:
	RES_b_r		CYCLE_RES_2_E, 2, E
dmgcpu_RES_2_H:
	RES_b_r		CYCLE_RES_2_H, 2, H
dmgcpu_RES_2_L:
	RES_b_r		CYCLE_RES_2_L, 2, L
dmgcpu_RES_2_IHLI:
	RES_b_IHLI	CYCLE_RES_2_IHLI, 2

dmgcpu_RES_3_A:
	RES_b_A		CYCLE_RES_3_A, 3
dmgcpu_RES_3_B:
	RES_b_r		CYCLE_RES_3_B, 3, B
dmgcpu_RES_3_C:
	RES_b_r		CYCLE_RES_3_C, 3, C
dmgcpu_RES_3_D:
	RES_b_r		CYCLE_RES_3_D, 3, D
dmgcpu_RES_3_E:
	RES_b_r		CYCLE_RES_3_E, 3, E
dmgcpu_RES_3_H:
	RES_b_r		CYCLE_RES_3_H, 3, H
dmgcpu_RES_3_L:
	RES_b_r		CYCLE_RES_3_L, 3, L
dmgcpu_RES_3_IHLI:
	RES_b_IHLI	CYCLE_RES_3_IHLI, 3

dmgcpu_RES_4_A:
	RES_b_A		CYCLE_RES_4_A, 4
dmgcpu_RES_4_B:
	RES_b_r		CYCLE_RES_4_B, 4, B
dmgcpu_RES_4_C:
	RES_b_r		CYCLE_RES_4_C, 4, C
dmgcpu_RES_4_D:
	RES_b_r		CYCLE_RES_4_D, 4, D
dmgcpu_RES_4_E:
	RES_b_r		CYCLE_RES_4_E, 4, E
dmgcpu_RES_4_H:
	RES_b_r		CYCLE_RES_4_H, 4, H
dmgcpu_RES_4_L:
	RES_b_r		CYCLE_RES_4_L, 4, L
dmgcpu_RES_4_IHLI:
	RES_b_IHLI	CYCLE_RES_4_IHLI, 4

dmgcpu_RES_5_A:
	RES_b_A		CYCLE_RES_5_A, 5
dmgcpu_RES_5_B:
	RES_b_r		CYCLE_RES_5_B, 5, B
dmgcpu_RES_5_C:
	RES_b_r		CYCLE_RES_5_C, 5, C
dmgcpu_RES_5_D:
	RES_b_r		CYCLE_RES_5_D, 5, D
dmgcpu_RES_5_E:
	RES_b_r		CYCLE_RES_5_E, 5, E
dmgcpu_RES_5_H:
	RES_b_r		CYCLE_RES_5_H, 5, H
dmgcpu_RES_5_L:
	RES_b_r		CYCLE_RES_5_L, 5, L
dmgcpu_RES_5_IHLI:
	RES_b_IHLI	CYCLE_RES_5_IHLI, 5

dmgcpu_RES_6_A:
	RES_b_A		CYCLE_RES_6_A, 6
dmgcpu_RES_6_B:
	RES_b_r		CYCLE_RES_6_B, 6, B
dmgcpu_RES_6_C:
	RES_b_r		CYCLE_RES_6_C, 6, C
dmgcpu_RES_6_D:
	RES_b_r		CYCLE_RES_6_D, 6, D
dmgcpu_RES_6_E:
	RES_b_r		CYCLE_RES_6_E, 6, E
dmgcpu_RES_6_H:
	RES_b_r		CYCLE_RES_6_H, 6, H
dmgcpu_RES_6_L:
	RES_b_r		CYCLE_RES_6_L, 6, L
dmgcpu_RES_6_IHLI:
	RES_b_IHLI	CYCLE_RES_6_IHLI, 6

dmgcpu_RES_7_A:
	RES_b_A		CYCLE_RES_7_A, 7
dmgcpu_RES_7_B:
	RES_b_r		CYCLE_RES_7_B, 7, B
dmgcpu_RES_7_C:
	RES_b_r		CYCLE_RES_7_C, 7, C
dmgcpu_RES_7_D:
	RES_b_r		CYCLE_RES_7_D, 7, D
dmgcpu_RES_7_E:
	RES_b_r		CYCLE_RES_7_E, 7, E
dmgcpu_RES_7_H:
	RES_b_r		CYCLE_RES_7_H, 7, H
dmgcpu_RES_7_L:
	RES_b_r		CYCLE_RES_7_L, 7, L
dmgcpu_RES_7_IHLI:
	RES_b_IHLI	CYCLE_RES_7_IHLI, 7

;****************************************************************************
;	Jumps
;****************************************************************************

dmgcpu_JP_c_nn:
	sub	%CYCLE, (16-12)			; CYCLE -= (16-12)
	; FALLTHRU
dmgcpu_JP_nn:
	call.d	%READ				; %data = LO(nn)
	ld.w	%addr, %PC			; %addr = PC   *delay*
	ld.w	%PC, %data			; %PC   = LO(nn)
	call.d	%READ				; %data = HI(nn)
	add	%addr, 1			; %addr = PC+1 *delay*
	xsll	%data, 8			; %data = HI(nn)<<8
	or	%PC, %data			; %PC   = HI(nn)<<8|LO(nn)
	ret.d
	sub	%CYCLE, CYCLE_JP_nn		; *delay*

dmgcpu_JP_Z_nn:
	xld.ub	%t0, [%CPU+CZ+0]		; %t0 = zzzzzzzz
	or	%t0, %t0			; test  zzzzzzzz
	xjreq	dmgcpu_JP_c_nn			; if(z == 0) { CYCLE -= (16-12); JP_nn; }
	xadd	%PC, %PC, 2			; PC += 2 (skip nn)
	ret.d
	sub	%CYCLE, CYCLE_JP_Z_nn		; *delay*

dmgcpu_JP_NZ_nn:
	xld.ub	%t0, [%CPU+CZ+0]		; %t0 = zzzzzzzz
	or	%t0, %t0			; test  zzzzzzzz
	xjrne	dmgcpu_JP_c_nn			; if(z != 0) { CYCLE -= (16-12); JP_nn; }
	xadd	%PC, %PC, 2			; PC += 2 (skip nn)
	ret.d
	sub	%CYCLE, CYCLE_JP_NZ_nn		; *delay*

dmgcpu_JP_C_nn:
	xbtst	[%CPU+CZ+1], 0			; test CF
	xjrne	dmgcpu_JP_c_nn			; if(CF == 1) { CYCLE -= (16-12); JP_nn; }
	xadd	%PC, %PC, 2			; PC += 2 (skip nn)
	ret.d
	sub	%CYCLE, CYCLE_JP_C_nn		; *delay*

dmgcpu_JP_NC_nn:
	xbtst	[%CPU+CZ+1], 0			; test CF
	xjreq	dmgcpu_JP_c_nn			; if(CF == 0) { CYCLE -= (16-12); JP_nn; }
	xadd	%PC, %PC, 2			; PC += 2 (skip nn)
	ret.d
	sub	%CYCLE, CYCLE_JP_NC_nn		; *delay*

dmgcpu_JP_IHLI:
	xld.uh	%PC, [%CPU+HL]			; %PC = HL
	ret.d
	sub	%CYCLE, CYCLE_JP_IHLI		; *delay*

dmgcpu_JR_c_e:
	sub	%CYCLE, (12-8)			; CYCLE -= (12-8)
	; FALLTHRU
dmgcpu_JR_e:
	call.d	%READ				; %data = e (   0.. 255)
	ld.w	%addr, %PC			; %addr = PC *delay*
	xadd	%PC, %PC, 1			; %PC   = PC+1
	ld.b	%data, %data			; %data = e (-128..+127)
	add	%PC, %data			; %PC   = PC+1+e
	ret.d
	sub	%CYCLE, CYCLE_JR_e		; *delay*

dmgcpu_JR_Z_e:
	xld.ub	%t0, [%CPU+CZ+0]		; %t0 = zzzzzzzz
	or	%t0, %t0			; test  zzzzzzzz
	xjreq	dmgcpu_JR_c_e			; if(z == 0) { CYCLE -= (12-8); JR_e; }
	xadd	%PC, %PC, 1			; PC += 1 (skip e)
	ret.d
	sub	%CYCLE, CYCLE_JR_Z_e		; *delay*

dmgcpu_JR_NZ_e:
	xld.ub	%t0, [%CPU+CZ+0]		; %t0 = zzzzzzzz
	or	%t0, %t0			; test  zzzzzzzz
	xjrne	dmgcpu_JR_c_e			; if(z != 0) { CYCLE -= (12-8); JR_e; }
	xadd	%PC, %PC, 1			; PC += 1 (skip e)
	ret.d
	sub	%CYCLE, CYCLE_JR_NZ_e		; *delay*

dmgcpu_JR_C_e:
	xbtst	[%CPU+CZ+1], 0			; test CF
	xjrne	dmgcpu_JR_c_e			; if(CF == 1) { CYCLE -= (12-8); JR_e; }
	xadd	%PC, %PC, 1			; PC += 1 (skip e)
	ret.d
	sub	%CYCLE, CYCLE_JR_C_e		; *delay*

dmgcpu_JR_NC_e:
	xbtst	[%CPU+CZ+1], 0			; test CF
	xjreq	dmgcpu_JR_c_e			; if(CF == 0) { CYCLE -= (12-8); JR_e; }
	xadd	%PC, %PC, 1			; PC += 1 (skip e)
	ret.d
	sub	%CYCLE, CYCLE_JR_NC_e		; *delay*

;****************************************************************************
;	Calls
;****************************************************************************

dmgcpu_CALL_c_nn:
	sub	%CYCLE, (24-12)			; CYCLE -= (24-12)
	; FALLTHRU
dmgcpu_CALL_nn:
	ld.w	%data, %PC			; %data = PC
	xcall.d	dmgcpu_push			; PUSH(PC+2)
	add	%data, 2			; %data = PC+2 *delay*
	call.d	%READ				; %data = LO(nn)
	ld.w	%addr, %PC			; %addr = PC   *delay*
	ld.w	%PC, %data			; %PC   = LO(nn)
	call.d	%READ				; %data = HI(nn)
	add	%addr, 1			; %addr = PC+1 *delay*
	xsll	%data, 8			; %data = HI(nn)<<8
	or	%PC, %data			; %PC   = HI(nn)<<8|LO(nn)
	ret.d
	sub	%CYCLE, CYCLE_CALL_nn		; *delay*

dmgcpu_CALL_Z_nn:
	xld.ub	%t0, [%CPU+CZ+0]		; %t0 = zzzzzzzz
	or	%t0, %t0			; test  zzzzzzzz
	xjreq	dmgcpu_CALL_c_nn		; if(z == 0) { CYCLE -= (24-12); CALL_nn; }
	xadd	%PC, %PC, 2			; PC += 2 (skip nn)
	ret.d
	sub	%CYCLE, CYCLE_CALL_Z_nn		; *delay*

dmgcpu_CALL_NZ_nn:
	xld.ub	%t0, [%CPU+CZ+0]		; %t0 = zzzzzzzz
	or	%t0, %t0			; test  zzzzzzzz
	xjrne	dmgcpu_CALL_c_nn		; if(z != 0) { CYCLE -= (24-12); CALL_nn; }
	xadd	%PC, %PC, 2			; PC += 2 (skip nn)
	ret.d
	sub	%CYCLE, CYCLE_CALL_NZ_nn	; *delay*

dmgcpu_CALL_C_nn:
	xbtst	[%CPU+CZ+1], 0			; test CF
	xjrne	dmgcpu_CALL_c_nn		; if(CF == 1) { CYCLE -= (24-12); CALL_nn; }
	xadd	%PC, %PC, 2			; PC += 2 (skip nn)
	ret.d
	sub	%CYCLE, CYCLE_CALL_C_nn		; *delay*

dmgcpu_CALL_NC_nn:
	xbtst	[%CPU+CZ+1], 0			; test CF
	xjreq	dmgcpu_CALL_c_nn		; if(CF == 0) { CYCLE -= (24-12); CALL_nn; }
	xadd	%PC, %PC, 2			; PC += 2 (skip nn)
	ret.d
	sub	%CYCLE, CYCLE_CALL_NC_nn	; *delay*

;****************************************************************************
;	Restarts
;****************************************************************************

#macro	RST_n		$1, $2
	xcall.d	dmgcpu_push			; PUSH(PC)
	ld.w	%data, %PC			; %data = PC *delay*
	xld.w	%PC, $2				; %PC   = n
	ret.d
	sub	%CYCLE, $1			; *delay*
#endm

;----------------------------------------------------------------------------

dmgcpu_RST_00H:
	RST_n		CYCLE_RST_00H, 0x00
dmgcpu_RST_08H:
	RST_n		CYCLE_RST_08H, 0x08
dmgcpu_RST_10H:
	RST_n		CYCLE_RST_10H, 0x10
dmgcpu_RST_18H:
	RST_n		CYCLE_RST_18H, 0x18
dmgcpu_RST_20H:
	RST_n		CYCLE_RST_20H, 0x20
dmgcpu_RST_28H:
	RST_n		CYCLE_RST_28H, 0x28
dmgcpu_RST_30H:
	RST_n		CYCLE_RST_30H, 0x30
dmgcpu_RST_38H:
	RST_n		CYCLE_RST_38H, 0x38

;****************************************************************************
;	Returns
;****************************************************************************

dmgcpu_RET_c:
	sub	%CYCLE, (20-8)			; CYCLE -= (20-8)
	; FALLTHRU
dmgcpu_RET:
	xcall	dmgcpu_pop			; %data = POP()
	ld.w	%PC, %data			; %PC   = PC
	ret.d
	sub	%CYCLE, CYCLE_RET		; *delay*

dmgcpu_RET_Z:
	xld.ub	%t0, [%CPU+CZ+0]		; %t0 = zzzzzzzz
	or	%t0, %t0			; test  zzzzzzzz
	xjreq	dmgcpu_RET_c			; if(z == 0) { CYCLE -= (20-8); RET; }
	ret.d
	sub	%CYCLE, CYCLE_RET_Z		; *delay*

dmgcpu_RET_NZ:
	xld.ub	%t0, [%CPU+CZ+0]		; %t0 = zzzzzzzz
	or	%t0, %t0			; test  zzzzzzzz
	xjrne	dmgcpu_RET_c			; if(z != 0) { CYCLE -= (20-8); RET; }
	ret.d
	sub	%CYCLE, CYCLE_RET_NZ		; *delay*

dmgcpu_RET_C:
	xbtst	[%CPU+CZ+1], 0			; test CF
	xjrne	dmgcpu_RET_c			; if(CF == 1) { CYCLE -= (20-8); RET; }
	ret.d
	sub	%CYCLE, CYCLE_RET_C		; *delay*

dmgcpu_RET_NC:
	xbtst	[%CPU+CZ+1], 0			; test CF
	xjreq	dmgcpu_RET_c			; if(CF == 0) { CYCLE -= (20-8); RET; }
	ret.d
	sub	%CYCLE, CYCLE_RET_NC		; *delay*

dmgcpu_RETI:
	xcall	dmgcpu_pop			; %data = POP()
	ld.w	%PC, %data			; %PC   = PC
	xbset	[%CPU+FLAGS], IME_BIT		; IME = 1
	xjp.d	dmgcpu_CHECK_PENDING		; ۗĂ荞݂΁As܂B
	sub	%CYCLE, CYCLE_RETI		; *delay*

;****************************************************************************
;	
;****************************************************************************

	.code
	.align	2

	.global dmgcpu_XXops
dmgcpu_XXops:
	.word	dmgcpu_NOP		;00
	.word	dmgcpu_LD_BC_nn		;01
	.word	dmgcpu_LD_IBCI_A	;02
	.word	dmgcpu_INC_BC		;03
	.word	dmgcpu_INC_B		;04
	.word	dmgcpu_DEC_B		;05
	.word	dmgcpu_LD_B_n		;06
	.word	dmgcpu_RLCA		;07
	.word	dmgcpu_LD_InnI_SP	;08
	.word	dmgcpu_ADD_HL_BC	;09
	.word	dmgcpu_LD_A_IBCI	;0A
	.word	dmgcpu_DEC_BC		;0B
	.word	dmgcpu_INC_C		;0C
	.word	dmgcpu_DEC_C		;0D
	.word	dmgcpu_LD_C_n		;0E
	.word	dmgcpu_RRCA		;0F
	.word	dmgcpu_STOP		;10
	.word	dmgcpu_LD_DE_nn		;11
	.word	dmgcpu_LD_IDEI_A	;12
	.word	dmgcpu_INC_DE		;13
	.word	dmgcpu_INC_D		;14
	.word	dmgcpu_DEC_D		;15
	.word	dmgcpu_LD_D_n		;16
	.word	dmgcpu_RLA		;17
	.word	dmgcpu_JR_e		;18
	.word	dmgcpu_ADD_HL_DE	;19
	.word	dmgcpu_LD_A_IDEI	;1A
	.word	dmgcpu_DEC_DE		;1B
	.word	dmgcpu_INC_E		;1C
	.word	dmgcpu_DEC_E		;1D
	.word	dmgcpu_LD_E_n		;1E
	.word	dmgcpu_RRA		;1F
	.word	dmgcpu_JR_NZ_e		;20
	.word	dmgcpu_LD_HL_nn		;21
	.word	dmgcpu_LDI_IHLI_A	;22
	.word	dmgcpu_INC_HL		;23
	.word	dmgcpu_INC_H		;24
	.word	dmgcpu_DEC_H		;25
	.word	dmgcpu_LD_H_n		;26
	.word	dmgcpu_DAA		;27
	.word	dmgcpu_JR_Z_e		;28
	.word	dmgcpu_ADD_HL_HL	;29
	.word	dmgcpu_LDI_A_IHLI	;2A
	.word	dmgcpu_DEC_HL		;2B
	.word	dmgcpu_INC_L		;2C
	.word	dmgcpu_DEC_L		;2D
	.word	dmgcpu_LD_L_n		;2E
	.word	dmgcpu_CPL		;2F
	.word	dmgcpu_JR_NC_e		;30
	.word	dmgcpu_LD_SP_nn		;31
	.word	dmgcpu_LDD_IHLI_A	;32
	.word	dmgcpu_INC_SP		;33
	.word	dmgcpu_INC_IHLI		;34
	.word	dmgcpu_DEC_IHLI		;35
	.word	dmgcpu_LD_IHLI_n	;36
	.word	dmgcpu_SCF		;37
	.word	dmgcpu_JR_C_e		;38
	.word	dmgcpu_ADD_HL_SP	;39
	.word	dmgcpu_LDD_A_IHLI	;3A
	.word	dmgcpu_DEC_SP		;3B
	.word	dmgcpu_INC_A		;3C
	.word	dmgcpu_DEC_A		;3D
	.word	dmgcpu_LD_A_n		;3E
	.word	dmgcpu_CCF		;3F
	.word	dmgcpu_LD_B_B		;40
	.word	dmgcpu_LD_B_C		;41
	.word	dmgcpu_LD_B_D		;42
	.word	dmgcpu_LD_B_E		;43
	.word	dmgcpu_LD_B_H		;44
	.word	dmgcpu_LD_B_L		;45
	.word	dmgcpu_LD_B_IHLI	;46
	.word	dmgcpu_LD_B_A		;47
	.word	dmgcpu_LD_C_B		;48
	.word	dmgcpu_LD_C_C		;49
	.word	dmgcpu_LD_C_D		;4A
	.word	dmgcpu_LD_C_E		;4B
	.word	dmgcpu_LD_C_H		;4C
	.word	dmgcpu_LD_C_L		;4D
	.word	dmgcpu_LD_C_IHLI	;4E
	.word	dmgcpu_LD_C_A		;4F
	.word	dmgcpu_LD_D_B		;50
	.word	dmgcpu_LD_D_C		;51
	.word	dmgcpu_LD_D_D		;52
	.word	dmgcpu_LD_D_E		;53
	.word	dmgcpu_LD_D_H		;54
	.word	dmgcpu_LD_D_L		;55
	.word	dmgcpu_LD_D_IHLI	;56
	.word	dmgcpu_LD_D_A		;57
	.word	dmgcpu_LD_E_B		;58
	.word	dmgcpu_LD_E_C		;59
	.word	dmgcpu_LD_E_D		;5A
	.word	dmgcpu_LD_E_E		;5B
	.word	dmgcpu_LD_E_H		;5C
	.word	dmgcpu_LD_E_L		;5D
	.word	dmgcpu_LD_E_IHLI	;5E
	.word	dmgcpu_LD_E_A		;5F
	.word	dmgcpu_LD_H_B		;60
	.word	dmgcpu_LD_H_C		;61
	.word	dmgcpu_LD_H_D		;62
	.word	dmgcpu_LD_H_E		;63
	.word	dmgcpu_LD_H_H		;64
	.word	dmgcpu_LD_H_L		;65
	.word	dmgcpu_LD_H_IHLI	;66
	.word	dmgcpu_LD_H_A		;67
	.word	dmgcpu_LD_L_B		;68
	.word	dmgcpu_LD_L_C		;69
	.word	dmgcpu_LD_L_D		;6A
	.word	dmgcpu_LD_L_E		;6B
	.word	dmgcpu_LD_L_H		;6C
	.word	dmgcpu_LD_L_L		;6D
	.word	dmgcpu_LD_L_IHLI	;6E
	.word	dmgcpu_LD_L_A		;6F
	.word	dmgcpu_LD_IHLI_B	;70
	.word	dmgcpu_LD_IHLI_C	;71
	.word	dmgcpu_LD_IHLI_D	;72
	.word	dmgcpu_LD_IHLI_E	;73
	.word	dmgcpu_LD_IHLI_H	;74
	.word	dmgcpu_LD_IHLI_L	;75
	.word	dmgcpu_HALT		;76
	.word	dmgcpu_LD_IHLI_A	;77
	.word	dmgcpu_LD_A_B		;78
	.word	dmgcpu_LD_A_C		;79
	.word	dmgcpu_LD_A_D		;7A
	.word	dmgcpu_LD_A_E		;7B
	.word	dmgcpu_LD_A_H		;7C
	.word	dmgcpu_LD_A_L		;7D
	.word	dmgcpu_LD_A_IHLI	;7E
	.word	dmgcpu_LD_A_A		;7F
	.word	dmgcpu_ADD_A_B		;80
	.word	dmgcpu_ADD_A_C		;81
	.word	dmgcpu_ADD_A_D		;82
	.word	dmgcpu_ADD_A_E		;83
	.word	dmgcpu_ADD_A_H		;84
	.word	dmgcpu_ADD_A_L		;85
	.word	dmgcpu_ADD_A_IHLI	;86
	.word	dmgcpu_ADD_A_A		;87
	.word	dmgcpu_ADC_A_B		;88
	.word	dmgcpu_ADC_A_C		;89
	.word	dmgcpu_ADC_A_D		;8A
	.word	dmgcpu_ADC_A_E		;8B
	.word	dmgcpu_ADC_A_H		;8C
	.word	dmgcpu_ADC_A_L		;8D
	.word	dmgcpu_ADC_A_IHLI	;8E
	.word	dmgcpu_ADC_A_A		;8F
	.word	dmgcpu_SUB_B		;90
	.word	dmgcpu_SUB_C		;91
	.word	dmgcpu_SUB_D		;92
	.word	dmgcpu_SUB_E		;93
	.word	dmgcpu_SUB_H		;94
	.word	dmgcpu_SUB_L		;95
	.word	dmgcpu_SUB_IHLI		;96
	.word	dmgcpu_SUB_A		;97
	.word	dmgcpu_SBC_A_B		;98
	.word	dmgcpu_SBC_A_C		;99
	.word	dmgcpu_SBC_A_D		;9A
	.word	dmgcpu_SBC_A_E		;9B
	.word	dmgcpu_SBC_A_H		;9C
	.word	dmgcpu_SBC_A_L		;9D
	.word	dmgcpu_SBC_A_IHLI	;9E
	.word	dmgcpu_SBC_A_A		;9F
	.word	dmgcpu_AND_B		;A0
	.word	dmgcpu_AND_C		;A1
	.word	dmgcpu_AND_D		;A2
	.word	dmgcpu_AND_E		;A3
	.word	dmgcpu_AND_H		;A4
	.word	dmgcpu_AND_L		;A5
	.word	dmgcpu_AND_IHLI		;A6
	.word	dmgcpu_AND_A		;A7
	.word	dmgcpu_XOR_B		;A8
	.word	dmgcpu_XOR_C		;A9
	.word	dmgcpu_XOR_D		;AA
	.word	dmgcpu_XOR_E		;AB
	.word	dmgcpu_XOR_H		;AC
	.word	dmgcpu_XOR_L		;AD
	.word	dmgcpu_XOR_IHLI		;AE
	.word	dmgcpu_XOR_A		;AF
	.word	dmgcpu_OR_B		;B0
	.word	dmgcpu_OR_C		;B1
	.word	dmgcpu_OR_D		;B2
	.word	dmgcpu_OR_E		;B3
	.word	dmgcpu_OR_H		;B4
	.word	dmgcpu_OR_L		;B5
	.word	dmgcpu_OR_IHLI		;B6
	.word	dmgcpu_OR_A		;B7
	.word	dmgcpu_CP_B		;B8
	.word	dmgcpu_CP_C		;B9
	.word	dmgcpu_CP_D		;BA
	.word	dmgcpu_CP_E		;BB
	.word	dmgcpu_CP_H		;BC
	.word	dmgcpu_CP_L		;BD
	.word	dmgcpu_CP_IHLI		;BE
	.word	dmgcpu_CP_A		;BF
	.word	dmgcpu_RET_NZ		;C0
	.word	dmgcpu_POP_BC		;C1
	.word	dmgcpu_JP_NZ_nn		;C2
	.word	dmgcpu_JP_nn		;C3
	.word	dmgcpu_CALL_NZ_nn	;C4
	.word	dmgcpu_PUSH_BC		;C5
	.word	dmgcpu_ADD_A_n		;C6
	.word	dmgcpu_RST_00H		;C7
	.word	dmgcpu_RET_Z		;C8
	.word	dmgcpu_RET		;C9
	.word	dmgcpu_JP_Z_nn		;CA
	.word	dmgcpu_CB		;CB
	.word	dmgcpu_CALL_Z_nn	;CC
	.word	dmgcpu_CALL_nn		;CD
	.word	dmgcpu_ADC_A_n		;CE
	.word	dmgcpu_RST_08H		;CF
	.word	dmgcpu_RET_NC		;D0
	.word	dmgcpu_POP_DE		;D1
	.word	dmgcpu_JP_NC_nn		;D2
	.word	dmgcpu_ERR		;D3
	.word	dmgcpu_CALL_NC_nn	;D4
	.word	dmgcpu_PUSH_DE		;D5
	.word	dmgcpu_SUB_n		;D6
	.word	dmgcpu_RST_10H		;D7
	.word	dmgcpu_RET_C		;D8
	.word	dmgcpu_RETI		;D9
	.word	dmgcpu_JP_C_nn		;DA
	.word	dmgcpu_ERR		;DB
	.word	dmgcpu_CALL_C_nn	;DC
	.word	dmgcpu_ERR		;DD
	.word	dmgcpu_SBC_A_n		;DE
	.word	dmgcpu_RST_18H		;DF
	.word	dmgcpu_LDH_InI_A	;E0
	.word	dmgcpu_POP_HL		;E1
	.word	dmgcpu_LD_ICI_A		;E2
	.word	dmgcpu_ERR		;E3
	.word	dmgcpu_ERR		;E4
	.word	dmgcpu_PUSH_HL		;E5
	.word	dmgcpu_AND_n		;E6
	.word	dmgcpu_RST_20H		;E7
	.word	dmgcpu_ADD_SP_e		;E8
	.word	dmgcpu_JP_IHLI		;E9
	.word	dmgcpu_LD_InnI_A	;EA
	.word	dmgcpu_ERR		;EB
	.word	dmgcpu_ERR		;EC
	.word	dmgcpu_ERR		;ED
	.word	dmgcpu_XOR_n		;EE
	.word	dmgcpu_RST_28H		;EF
	.word	dmgcpu_LDH_A_InI	;F0
	.word	dmgcpu_POP_AF		;F1
	.word	dmgcpu_LD_A_ICI		;F2
	.word	dmgcpu_DI		;F3
	.word	dmgcpu_ERR		;F4
	.word	dmgcpu_PUSH_AF		;F5
	.word	dmgcpu_OR_n		;F6
	.word	dmgcpu_RST_30H		;F7
	.word	dmgcpu_LDHL_SP_e	;F8
	.word	dmgcpu_LD_SP_HL		;F9
	.word	dmgcpu_LD_A_InnI	;FA
	.word	dmgcpu_EI		;FB
	.word	dmgcpu_ERR		;FC
	.word	dmgcpu_ERR		;FD
	.word	dmgcpu_CP_n		;FE
	.word	dmgcpu_RST_38H		;FF

	.global dmgcpu_CBops
dmgcpu_CBops:
	.word	dmgcpu_RLC_B		;00
	.word	dmgcpu_RLC_C		;01
	.word	dmgcpu_RLC_D		;02
	.word	dmgcpu_RLC_E		;03
	.word	dmgcpu_RLC_H		;04
	.word	dmgcpu_RLC_L		;05
	.word	dmgcpu_RLC_IHLI		;06
	.word	dmgcpu_RLC_A		;07
	.word	dmgcpu_RRC_B		;08
	.word	dmgcpu_RRC_C		;09
	.word	dmgcpu_RRC_D		;0A
	.word	dmgcpu_RRC_E		;0B
	.word	dmgcpu_RRC_H		;0C
	.word	dmgcpu_RRC_L		;0D
	.word	dmgcpu_RRC_IHLI		;0E
	.word	dmgcpu_RRC_A		;0F
	.word	dmgcpu_RL_B		;10
	.word	dmgcpu_RL_C		;11
	.word	dmgcpu_RL_D		;12
	.word	dmgcpu_RL_E		;13
	.word	dmgcpu_RL_H		;14
	.word	dmgcpu_RL_L		;15
	.word	dmgcpu_RL_IHLI		;16
	.word	dmgcpu_RL_A		;17
	.word	dmgcpu_RR_B		;18
	.word	dmgcpu_RR_C		;19
	.word	dmgcpu_RR_D		;1A
	.word	dmgcpu_RR_E		;1B
	.word	dmgcpu_RR_H		;1C
	.word	dmgcpu_RR_L		;1D
	.word	dmgcpu_RR_IHLI		;1E
	.word	dmgcpu_RR_A		;1F
	.word	dmgcpu_SLA_B		;20
	.word	dmgcpu_SLA_C		;21
	.word	dmgcpu_SLA_D		;22
	.word	dmgcpu_SLA_E		;23
	.word	dmgcpu_SLA_H		;24
	.word	dmgcpu_SLA_L		;25
	.word	dmgcpu_SLA_IHLI		;26
	.word	dmgcpu_SLA_A		;27
	.word	dmgcpu_SRA_B		;28
	.word	dmgcpu_SRA_C		;29
	.word	dmgcpu_SRA_D		;2A
	.word	dmgcpu_SRA_E		;2B
	.word	dmgcpu_SRA_H		;2C
	.word	dmgcpu_SRA_L		;2D
	.word	dmgcpu_SRA_IHLI		;2E
	.word	dmgcpu_SRA_A		;2F
	.word	dmgcpu_SWAP_B		;30
	.word	dmgcpu_SWAP_C		;31
	.word	dmgcpu_SWAP_D		;32
	.word	dmgcpu_SWAP_E		;33
	.word	dmgcpu_SWAP_H		;34
	.word	dmgcpu_SWAP_L		;35
	.word	dmgcpu_SWAP_IHLI	;36
	.word	dmgcpu_SWAP_A		;37
	.word	dmgcpu_SRL_B		;38
	.word	dmgcpu_SRL_C		;39
	.word	dmgcpu_SRL_D		;3A
	.word	dmgcpu_SRL_E		;3B
	.word	dmgcpu_SRL_H		;3C
	.word	dmgcpu_SRL_L		;3D
	.word	dmgcpu_SRL_IHLI		;3E
	.word	dmgcpu_SRL_A		;3F
	.word	dmgcpu_BIT_0_B		;40
	.word	dmgcpu_BIT_0_C		;41
	.word	dmgcpu_BIT_0_D		;42
	.word	dmgcpu_BIT_0_E		;43
	.word	dmgcpu_BIT_0_H		;44
	.word	dmgcpu_BIT_0_L		;45
	.word	dmgcpu_BIT_0_IHLI	;46
	.word	dmgcpu_BIT_0_A		;47
	.word	dmgcpu_BIT_1_B		;48
	.word	dmgcpu_BIT_1_C		;49
	.word	dmgcpu_BIT_1_D		;4A
	.word	dmgcpu_BIT_1_E		;4B
	.word	dmgcpu_BIT_1_H		;4C
	.word	dmgcpu_BIT_1_L		;4D
	.word	dmgcpu_BIT_1_IHLI	;4E
	.word	dmgcpu_BIT_1_A		;4F
	.word	dmgcpu_BIT_2_B		;50
	.word	dmgcpu_BIT_2_C		;51
	.word	dmgcpu_BIT_2_D		;52
	.word	dmgcpu_BIT_2_E		;53
	.word	dmgcpu_BIT_2_H		;54
	.word	dmgcpu_BIT_2_L		;55
	.word	dmgcpu_BIT_2_IHLI	;56
	.word	dmgcpu_BIT_2_A		;57
	.word	dmgcpu_BIT_3_B		;58
	.word	dmgcpu_BIT_3_C		;59
	.word	dmgcpu_BIT_3_D		;5A
	.word	dmgcpu_BIT_3_E		;5B
	.word	dmgcpu_BIT_3_H		;5C
	.word	dmgcpu_BIT_3_L		;5D
	.word	dmgcpu_BIT_3_IHLI	;5E
	.word	dmgcpu_BIT_3_A		;5F
	.word	dmgcpu_BIT_4_B		;60
	.word	dmgcpu_BIT_4_C		;61
	.word	dmgcpu_BIT_4_D		;62
	.word	dmgcpu_BIT_4_E		;63
	.word	dmgcpu_BIT_4_H		;64
	.word	dmgcpu_BIT_4_L		;65
	.word	dmgcpu_BIT_4_IHLI	;66
	.word	dmgcpu_BIT_4_A		;67
	.word	dmgcpu_BIT_5_B		;68
	.word	dmgcpu_BIT_5_C		;69
	.word	dmgcpu_BIT_5_D		;6A
	.word	dmgcpu_BIT_5_E		;6B
	.word	dmgcpu_BIT_5_H		;6C
	.word	dmgcpu_BIT_5_L		;6D
	.word	dmgcpu_BIT_5_IHLI	;6E
	.word	dmgcpu_BIT_5_A		;6F
	.word	dmgcpu_BIT_6_B		;70
	.word	dmgcpu_BIT_6_C		;71
	.word	dmgcpu_BIT_6_D		;72
	.word	dmgcpu_BIT_6_E		;73
	.word	dmgcpu_BIT_6_H		;74
	.word	dmgcpu_BIT_6_L		;75
	.word	dmgcpu_BIT_6_IHLI	;76
	.word	dmgcpu_BIT_6_A		;77
	.word	dmgcpu_BIT_7_B		;78
	.word	dmgcpu_BIT_7_C		;79
	.word	dmgcpu_BIT_7_D		;7A
	.word	dmgcpu_BIT_7_E		;7B
	.word	dmgcpu_BIT_7_H		;7C
	.word	dmgcpu_BIT_7_L		;7D
	.word	dmgcpu_BIT_7_IHLI	;7E
	.word	dmgcpu_BIT_7_A		;7F
	.word	dmgcpu_RES_0_B		;80
	.word	dmgcpu_RES_0_C		;81
	.word	dmgcpu_RES_0_D		;82
	.word	dmgcpu_RES_0_E		;83
	.word	dmgcpu_RES_0_H		;84
	.word	dmgcpu_RES_0_L		;85
	.word	dmgcpu_RES_0_IHLI	;86
	.word	dmgcpu_RES_0_A		;87
	.word	dmgcpu_RES_1_B		;88
	.word	dmgcpu_RES_1_C		;89
	.word	dmgcpu_RES_1_D		;8A
	.word	dmgcpu_RES_1_E		;8B
	.word	dmgcpu_RES_1_H		;8C
	.word	dmgcpu_RES_1_L		;8D
	.word	dmgcpu_RES_1_IHLI	;8E
	.word	dmgcpu_RES_1_A		;8F
	.word	dmgcpu_RES_2_B		;90
	.word	dmgcpu_RES_2_C		;91
	.word	dmgcpu_RES_2_D		;92
	.word	dmgcpu_RES_2_E		;93
	.word	dmgcpu_RES_2_H		;94
	.word	dmgcpu_RES_2_L		;95
	.word	dmgcpu_RES_2_IHLI	;96
	.word	dmgcpu_RES_2_A		;97
	.word	dmgcpu_RES_3_B		;98
	.word	dmgcpu_RES_3_C		;99
	.word	dmgcpu_RES_3_D		;9A
	.word	dmgcpu_RES_3_E		;9B
	.word	dmgcpu_RES_3_H		;9C
	.word	dmgcpu_RES_3_L		;9D
	.word	dmgcpu_RES_3_IHLI	;9E
	.word	dmgcpu_RES_3_A		;9F
	.word	dmgcpu_RES_4_B		;A0
	.word	dmgcpu_RES_4_C		;A1
	.word	dmgcpu_RES_4_D		;A2
	.word	dmgcpu_RES_4_E		;A3
	.word	dmgcpu_RES_4_H		;A4
	.word	dmgcpu_RES_4_L		;A5
	.word	dmgcpu_RES_4_IHLI	;A6
	.word	dmgcpu_RES_4_A		;A7
	.word	dmgcpu_RES_5_B		;A8
	.word	dmgcpu_RES_5_C		;A9
	.word	dmgcpu_RES_5_D		;AA
	.word	dmgcpu_RES_5_E		;AB
	.word	dmgcpu_RES_5_H		;AC
	.word	dmgcpu_RES_5_L		;AD
	.word	dmgcpu_RES_5_IHLI	;AE
	.word	dmgcpu_RES_5_A		;AF
	.word	dmgcpu_RES_6_B		;B0
	.word	dmgcpu_RES_6_C		;B1
	.word	dmgcpu_RES_6_D		;B2
	.word	dmgcpu_RES_6_E		;B3
	.word	dmgcpu_RES_6_H		;B4
	.word	dmgcpu_RES_6_L		;B5
	.word	dmgcpu_RES_6_IHLI	;B6
	.word	dmgcpu_RES_6_A		;B7
	.word	dmgcpu_RES_7_B		;B8
	.word	dmgcpu_RES_7_C		;B9
	.word	dmgcpu_RES_7_D		;BA
	.word	dmgcpu_RES_7_E		;BB
	.word	dmgcpu_RES_7_H		;BC
	.word	dmgcpu_RES_7_L		;BD
	.word	dmgcpu_RES_7_IHLI	;BE
	.word	dmgcpu_RES_7_A		;BF
	.word	dmgcpu_SET_0_B		;C0
	.word	dmgcpu_SET_0_C		;C1
	.word	dmgcpu_SET_0_D		;C2
	.word	dmgcpu_SET_0_E		;C3
	.word	dmgcpu_SET_0_H		;C4
	.word	dmgcpu_SET_0_L		;C5
	.word	dmgcpu_SET_0_IHLI	;C6
	.word	dmgcpu_SET_0_A		;C7
	.word	dmgcpu_SET_1_B		;C8
	.word	dmgcpu_SET_1_C		;C9
	.word	dmgcpu_SET_1_D		;CA
	.word	dmgcpu_SET_1_E		;CB
	.word	dmgcpu_SET_1_H		;CC
	.word	dmgcpu_SET_1_L		;CD
	.word	dmgcpu_SET_1_IHLI	;CE
	.word	dmgcpu_SET_1_A		;CF
	.word	dmgcpu_SET_2_B		;D0
	.word	dmgcpu_SET_2_C		;D1
	.word	dmgcpu_SET_2_D		;D2
	.word	dmgcpu_SET_2_E		;D3
	.word	dmgcpu_SET_2_H		;D4
	.word	dmgcpu_SET_2_L		;D5
	.word	dmgcpu_SET_2_IHLI	;D6
	.word	dmgcpu_SET_2_A		;D7
	.word	dmgcpu_SET_3_B		;D8
	.word	dmgcpu_SET_3_C		;D9
	.word	dmgcpu_SET_3_D		;DA
	.word	dmgcpu_SET_3_E		;DB
	.word	dmgcpu_SET_3_H		;DC
	.word	dmgcpu_SET_3_L		;DD
	.word	dmgcpu_SET_3_IHLI	;DE
	.word	dmgcpu_SET_3_A		;DF
	.word	dmgcpu_SET_4_B		;E0
	.word	dmgcpu_SET_4_C		;E1
	.word	dmgcpu_SET_4_D		;E2
	.word	dmgcpu_SET_4_E		;E3
	.word	dmgcpu_SET_4_H		;E4
	.word	dmgcpu_SET_4_L		;E5
	.word	dmgcpu_SET_4_IHLI	;E6
	.word	dmgcpu_SET_4_A		;E7
	.word	dmgcpu_SET_5_B		;E8
	.word	dmgcpu_SET_5_C		;E9
	.word	dmgcpu_SET_5_D		;EA
	.word	dmgcpu_SET_5_E		;EB
	.word	dmgcpu_SET_5_H		;EC
	.word	dmgcpu_SET_5_L		;ED
	.word	dmgcpu_SET_5_IHLI	;EE
	.word	dmgcpu_SET_5_A		;EF
	.word	dmgcpu_SET_6_B		;F0
	.word	dmgcpu_SET_6_C		;F1
	.word	dmgcpu_SET_6_D		;F2
	.word	dmgcpu_SET_6_E		;F3
	.word	dmgcpu_SET_6_H		;F4
	.word	dmgcpu_SET_6_L		;F5
	.word	dmgcpu_SET_6_IHLI	;F6
	.word	dmgcpu_SET_6_A		;F7
	.word	dmgcpu_SET_7_B		;F8
	.word	dmgcpu_SET_7_C		;F9
	.word	dmgcpu_SET_7_D		;FA
	.word	dmgcpu_SET_7_E		;FB
	.word	dmgcpu_SET_7_H		;FC
	.word	dmgcpu_SET_7_L		;FD
	.word	dmgcpu_SET_7_IHLI	;FE
	.word	dmgcpu_SET_7_A		;FF

;****************************************************************************
;	
;****************************************************************************

