/*	
 *	clipdmc.c
 *
 *	P/ECE DMG-CPU (Sharp LR35902) Emulator ()
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sun Feb 13 03:10:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

//DMGCPU dmgcpu; -> framdmca.s
unsigned char dmgmem[0x10000];

/****************************************************************************
 *
 ****************************************************************************/

void
dmgcpu_err()
{
	die("dmgcpu_error(%04x)", dmgcpu.pc);
}

/*
 * Flags affected:
 *	Z - Set if register A is zero.
 *	N - Not affected.
 *	H - Reset.
 *	C - Set or reset according to operation.
 *
 * [note]
 *	* Z80G~[ṼR[h𗬗pāAtÖʒuςłB
 */
void
dmgcpu_daa()
{
	DMGCPU* cpu = &dmgcpu;
	//
	int hi = cpu->a >> 4;      /* A[7:4] */
	int lo = cpu->a & 15;      /* A[3:0] */
	int cf = cpu->cz & (1<<8); /* CF     */
	int hf = cpu->nh & (1<<4); /* HF     */
	int nf = cpu->nh & (1<<5); /* NF     */
	//
	int n;
	int c;
	//
	if(!nf) { /* ADD/ADC/INC */
		if(!cf) {
			if(!hf) {
				if(lo <= 9) {
					if(hi <= 9) {
						n = 0x00, c = 0;	/*( 1)*/
					} else {
						n = 0x60, c = 1;	/*( 4)*/
					}
				} else {
					if(hi <= 8) {
						n = 0x06, c = 0;	/*( 2)*/
					} else {
						n = 0x66, c = 1;	/*( 5)*/
					}
				}
			} else {
				if(hi <= 9) {
					n = 0x06, c = 0;		/*( 3)*/
				} else {
					n = 0x66, c = 1;		/*( 6)*/
				}
			}
		} else {
			if(!hf) {
				if(lo <= 9) {
					n = 0x60, c = 1;		/*( 7)*/
				} else {
					n = 0x66, c = 1;		/*( 8)*/
				}
			} else {
				n = 0x66, c = 1;			/*( 9)*/
			}
		}
	} else { /* SUB/SBC/DEC/NEG */
		if(!cf) {
			if(!hf) {
				n = 0x00, c = 0;			/*(10)*/
			} else {
				n = 0xfa, c = 0;			/*(11)*/
			}
		} else {
			if(!hf) {
				n = 0xa0, c = 1;			/*(12)*/
			} else {
				n = 0x9a, c = 1;			/*(13)*/
			}
		}
	}
	//
	cpu->a  += n;               /* A     */
	cpu->nh &= (1<<5);          /* NF    */
	cpu->cz  = (c<<8) | cpu->a; /* CF,ZF */
}

/****************************************************************************
 *
 ****************************************************************************/

/* GameBoy̋[IPLvO */
static const unsigned char gb_ipl_code[] = {
	0x3E,0x00,0xE0,0x05,	/* ld a,$00; ld (TIMA),a */
	0x3E,0x00,0xE0,0x06,	/* ld a,$00; ld (TMA ),a */
	0x3E,0x00,0xE0,0x07,	/* ld a,$00; ld (TAC ),a */
	0x3E,0x80,0xE0,0x10,	/* ld a,$80; ld (NR10),a */
	0x3E,0xBF,0xE0,0x11,	/* ld a,$BF; ld (NR11),a */
	0x3E,0xF3,0xE0,0x12,	/* ld a,$F3; ld (NR12),a */
	0x3E,0xBF,0xE0,0x14,	/* ld a,$BF; ld (NR14),a */
	0x3E,0x3F,0xE0,0x16,	/* ld a,$3F; ld (NR21),a */
	0x3E,0x00,0xE0,0x17,	/* ld a,$00; ld (NR22),a */
	0x3E,0xBF,0xE0,0x19,	/* ld a,$BF; ld (NR24),a */
	0x3E,0x7F,0xE0,0x1A,	/* ld a,$7F; ld (NR30),a */
	0x3E,0xFF,0xE0,0x1B,	/* ld a,$FF; ld (NR31),a */
	0x3E,0x9F,0xE0,0x1C,	/* ld a,$9F; ld (NR32),a */
	0x3E,0xBF,0xE0,0x1E,	/* ld a,$BF; ld (NR33),a */
	0x3E,0xFF,0xE0,0x20,	/* ld a,$FF; ld (NR41),a */
	0x3E,0x00,0xE0,0x21,	/* ld a,$00; ld (NR42),a */
	0x3E,0x00,0xE0,0x22,	/* ld a,$00; ld (NR43),a */
	0x3E,0xBF,0xE0,0x23,	/* ld a,$BF; ld (NR30),a */
	0x3E,0x77,0xE0,0x24,	/* ld a,$77; ld (NR50),a */
	0x3E,0xF3,0xE0,0x25,	/* ld a,$F3; ld (NR51),a */
	0x3E,0xF1,0xE0,0x26,	/* ld a,$F1; ld (NR52),a */
	0x3E,0x91,0xE0,0x40,	/* ld a,$91; ld (LCDC),a */
	0x3E,0x00,0xE0,0x42,	/* ld a,$00; ld (SCY ),a */
	0x3E,0x00,0xE0,0x43,	/* ld a,$00; ld (SCX ),a */
	0x3E,0x00,0xE0,0x45,	/* ld a,$00; ld (LYC ),a */
	0x3E,0xFC,0xE0,0x47,	/* ld a,$FC; ld (BGP ),a */
	0x3E,0xFF,0xE0,0x48,	/* ld a,$FF; ld (OBP0),a */
	0x3E,0xFF,0xE0,0x49,	/* ld a,$FF; ld (OBP1),a */
	0x3E,0x00,0xE0,0x4A,	/* ld a,$00; ld (WY  ),a */
	0x3E,0x00,0xE0,0x4B,	/* ld a,$00; ld (WX  ),a */
	0x3E,0x00,0xE0,0xFF,	/* ld a,$00; ld (IE  ),a */
	0x31,0xFE,0xFF,		/* ld sp,$FFFE */
	0x01,0xB0,0x01,		/* ld bc,$01B0 */
	0xC5,			/* push bc     */
	0xF1,			/* pop  af     */
	0x01,0x13,0x00,		/* ld bc,$0013 */
	0x11,0xD8,0x00,		/* ld de,$00D8 */
	0x21,0x4D,0x01,		/* ld hl,$014D */
	0xC3,0x00,0x01,		/* jp    $0100 */
};
/* [IPL]AhX(ύX) */
#define GB_IPL_ADDR	0xc000	/* 8kB Internal RAM */

void
dmgcpu_reset(void* read, void* write, int gb_ipl)
{
	DMGCPU* cpu = &dmgcpu;
	unsigned char* mem = dmgmem;
	//
	DMGREG reg;

	memset(cpu, 0, sizeof(DMGCPU));
	cpu->read  = read  ? read  : dmgmem_read ;
	cpu->write = write ? write : dmgmem_write;

	memset(&reg, 0, sizeof reg);
	if(gb_ipl) { /* GameBoy[IPL */
		reg.pc = GB_IPL_ADDR;
		memcpy(&mem[reg.pc], gb_ipl_code, sizeof gb_ipl_code);
	}
	dmgreg_put(&reg);
}

void
dmgcpu_check_pending()
{
	DMGCPU* cpu = &dmgcpu;
	unsigned char* mem = dmgmem;
	//
	int IF; /* $FF0F (IF) */
	int IE; /* $FFFF (IE) */
	int factor;
	int mask;
	int old_pc;
	int new_pc;

	/* SĂ̊荞݂֎~ĂA܂B */
	if(!(cpu->flags & DMGCPU_IME)) return;

	/* 荞݋AAvĂv𒊏o܂B */
	IF = mem[0xff0f]; /* $FF0F (IF) */
	IE = mem[0xffff]; /* $FFFF (IE) */
	factor = IE & IF;

	/* Ô߁Agp̊荞ݗvrbg}XN܂B
	 * (IEAIF̖gprbgm0Ȃ΁Ȁ͕svłB)
	 */
	factor &= (DMGCPU_V_BLANK |
		   DMGCPU_LCDC_STATUS |
		   DMGCPU_TIMER_OVERFLOW |
		   DMGCPU_SERIAL_TRANSFER_COMPLETION |
		   DMGCPU_HIGH_TO_LOW_OF_P10_P13);

	/* D揇Ɋ荞ݗv𒲂ׂāA荞݂s܂B */
	mask = 1 << 0;
	new_pc = 0x40;
	while(factor >= mask) {
		if(factor & mask) {
			cpu->flags &= ~(DMGCPU_IME | DMGCPU_HALT);
			old_pc = cpu->pc;
			mem[--cpu->sp] = HIBYTE(old_pc);
			mem[--cpu->sp] = LOBYTE(old_pc);
			cpu->pc = new_pc;

			/* 󂯕tvɑΉIF́AIɃNA܂B(n[hEFAdl) */
			IF &= ~mask;
			mem[0xff0f] = IF; /* $FF0F (IF) */

			/* ǂɎ󂯕t銄荞ݗv͈łB
			 * ܎󂯕t荞ݗvDx̒Ⴂ荞ݗv́A
			 * ̊荞ݏIRETI܂EIĂ΂ꂽƂɎ󂯕t܂B
			 */
			return; /* YȂ!! */
		}
		mask <<= 1;
		new_pc += 0x08;
	}
}

void
dmgreg_put(const DMGREG* reg)
{
	DMGCPU* cpu = &dmgcpu;

	cpu->a  = reg->af >> 8;
	cpu->cz = 0;
	cpu->nh = 0;
	if(  reg->af & (1<<4) ) cpu->cz |= (1<<8); /* ---C---- */
	if(  reg->af & (1<<5) ) cpu->nh |= (1<<4); /* --H----- */
	if(  reg->af & (1<<6) ) cpu->nh |= (1<<5); /* -N------ */
	if(!(reg->af & (1<<7))) cpu->cz |= (1<<0); /* Z------- */
	cpu->bc = reg->bc;
	cpu->de = reg->de;
	cpu->hl = reg->hl;
	cpu->sp = reg->sp;
	cpu->pc = reg->pc;
}

void
dmgreg_get(DMGREG* reg)
{
	DMGCPU* cpu = &dmgcpu;

	reg->af = cpu->a << 8;
	if(  cpu->cz & (1<<8) ) reg->af |= (1<<4); /* ---C---- */
	if(  cpu->nh & (1<<4) ) reg->af |= (1<<5); /* --H----- */
	if(  cpu->nh & (1<<5) ) reg->af |= (1<<6); /* -N------ */
	if(!(cpu->cz & (0xff))) reg->af |= (1<<7); /* Z------- */
	reg->bc = cpu->bc;
	reg->de = cpu->de;
	reg->hl = cpu->hl;
	reg->sp = cpu->sp;
	reg->pc = cpu->pc;
}

