/*	
 *	clipdlst.c
 *
 *	[eBeBF_uNXg
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Tue Jan 06 21:26:41 JST 2015 Naoyuki Sawa
 *	- VK쐬B
 *	- u[eBeBF_uNXgvAclipmisc.*clipdlst.*֕܂B
 *	  gppx͍̂ŁAʂȃNh߂ƌAW[ĕՂ邽߂łB
 *	* Wed Jan 07 00:30:50 JST 2015 Naoyuki Sawa
 *	- InitializeListHead(),IsListEmpty(), RemoveHeadList(), RemoveTailList(),RemoveEntryList(),InsertHeadList(),InsertTailList()Asm܂B
 *	  C:100oCgAsm:72oCg ɂȂ܂B28oCgߖł܂B
 *	* Thu Jul 16 22:21:18 JST 2015 Naoyuki Sawa
 *	- SortList(),SortList_r()ǉ܂B
 */
#include "clip.h"

/*****************************************************************************
 *	[eBeBF_uNXg
 *****************************************************************************/

#ifndef PIECE
void InitializeListHead(LIST_ENTRY* ListHead) {
	ListHead->Flink = ListHead->Blink = ListHead;
}
int IsListEmpty(LIST_ENTRY* ListHead) {
	return ListHead->Flink == ListHead;
}
LIST_ENTRY* RemoveHeadList(LIST_ENTRY* ListHead) {
	LIST_ENTRY* Head = ListHead->Flink;
	RemoveEntryList(Head);
	return Head;
}
LIST_ENTRY* RemoveTailList(LIST_ENTRY* ListHead) {
	LIST_ENTRY* Tail = ListHead->Blink;
	RemoveEntryList(Tail);
	return Tail;
}
void RemoveEntryList(LIST_ENTRY* Entry) {
	LIST_ENTRY* Flink = Entry->Flink;
	LIST_ENTRY* Blink = Entry->Blink;
	Blink->Flink = Flink;
	Flink->Blink = Blink;
}
void InsertHeadList(LIST_ENTRY* ListHead, LIST_ENTRY* Entry) {
	LIST_ENTRY* Head = ListHead->Flink;
	Entry->Flink = Head;
	Entry->Blink = ListHead;
	ListHead->Flink = Head->Blink = Entry;
}
void InsertTailList(LIST_ENTRY* ListHead, LIST_ENTRY* Entry) {
	LIST_ENTRY* Tail = ListHead->Blink;
	Entry->Flink = ListHead;
	Entry->Blink = Tail;
	Tail->Flink = ListHead->Blink = Entry;
}
#else //PIECE
void InitializeListHead(LIST_ENTRY* ListHead);
int IsListEmpty(LIST_ENTRY* ListHead);
LIST_ENTRY* RemoveHeadList(LIST_ENTRY* ListHead);
LIST_ENTRY* RemoveTailList(LIST_ENTRY* ListHead);
void RemoveEntryList(LIST_ENTRY* Entry);
void InsertHeadList(LIST_ENTRY* ListHead, LIST_ENTRY* Entry);
void InsertTailList(LIST_ENTRY* ListHead, LIST_ENTRY* Entry);
asm("
		.code
		.align		1
		.global		InitializeListHead
		.global		IsListEmpty
		.global		RemoveHeadList
		.global		RemoveTailList
		.global		RemoveEntryList
		.global		InsertHeadList
		.global		InsertTailList
		;//-------------------------------------;//
InitializeListHead:
		xld.w		[%r12+4], %r12		;//ListHead->Blink = ListHead
		ld.w		[%r12], %r12		;//ListHead->Flink = ListHead
		ret
		;//-------------------------------------;//
IsListEmpty:
		ld.w		%r10, [%r12]		;//%r10    :=  ListHead->Flink
		cmp		%r10, %r12		;//%psr(Z) := (ListHead->Flink == ListHead)	!INTERLOCK!
		ld.w		%r10, %psr		;//%r10[1] := (ListHead->Flink == ListHead)
		ret.d					;//
		and		%r10, 2			;//return     (ListHead->Flink == ListHead)	*delay*		//Cł͔0lƂ1ԂAAsmł͔0lƂ2ԂB0lɈˑȂ悤ӂB
		;//-------------------------------------;//
RemoveHeadList:
		ld.w		%r12, [%r12]		;//%r12 := Head = ListHead->Flink
		jp		RemoveEntryList		;//return RemoveEntryList(Head)					//AsmRemoveEntryList()̉B߂lɈˑ
		;//-------------------------------------;//
RemoveTailList:
		xld.w		%r12, [%r12+4]		;//%r12 := Tail = ListHead->Blink
	;//sv	jp		RemoveEntryList		;//return RemoveEntryList(Tail)					//AsmRemoveEntryList()̉B߂lɈˑ
		;//-------------------------------------;//
RemoveEntryList:
	;//{{C^[bN
	;//	ld.w		%r10, %r12		;//%r10 := Entry
	;//	ld.w		%r11, [%r12]+		;//%r11 := Flink = Entry->Flink
	;//	ld.w		%r12, [%r12]		;//%r12 := Blink = Entry->Blink
	;//	ld.w		[%r12] %r11		;// Blink->Flink = Flink			!INTERLOCK!
	;//	xld.w		[%r11+4], %r12		;// Flink->Blink = Blink
	;//	ret					;//return  Entry						//AsmRemoveEntryList()̉B߂l %r10 := Entry
	;//C^[bN
		ld.w		%r10, %r12		;//%r10 := Entry
		ld.w		%r11, [%r12]+		;//%r11 := Flink = Entry->Flink
		ld.w		%r12, [%r12]		;//%r12 := Blink = Entry->Blink
		xld.w		[%r11+4], %r12		;// Flink->Blink = Blink
		ld.w		[%r12] %r11		;// Blink->Flink = Flink
		ret					;//return  Entry						//AsmRemoveEntryList()̉B߂l %r10 := Entry
	;//}}C^[bN
		;//-------------------------------------;//
InsertHeadList:
	;//{{C^[bN,1ߐߖ
	;//	ld.w		%r9, [%r12]		;//%r9  :=    Head = ListHead->Flink
	;//	ld.w		[%r13], %r9		;//   Entry->Flink = Head			!INTERLOCK!
	;//	xld.w		[%r13+4], %r12		;//   Entry->Blink = ListHead
	;//	xld.w		[%r9+4], %r13		;//    Head->Blink = Entry
	;//	ld.w		[%r12], %r13		;//ListHead->Flink = Entry
	;//	ret
	;//C^[bN,1ߐߖ
		ld.w		%r9, [%r12]		;//%r9  :=    Head = ListHead->Flink
		xld.w		[%r9+4], %r13		;//    Head->Blink = Entry
		ld.w		[%r12], %r13		;//ListHead->Flink = Entry
		ld.w		[%r13]+, %r9		;//   Entry->Flink = Head, %r13 := &Entry->Blink
		ld.w		[%r13], %r12		;//   Entry->Blink = ListHead
		ret
	;//}}C^[bN,1ߐߖ
		;//-------------------------------------;//
InsertTailList:
	;//{{1ߐߖ
	;//	xld.w		%r9, [%r12+4]		;//%r9  :=    Tail = ListHead->Blink
	;//	ld.w		[%r13], %r12		;//   Entry->Flink = ListHead
	;//	xld.w		[%r13+4], %r9		;//   Entry->Blink = Tail
	;//	xld.w		[%r12+4], %r13		;//ListHead->Blink = Entry
	;//	ld.w		[%r9], %r13		;//    Tail->Flink = Entry
	;//	ret
	;//1ߐߖ
		ld.w		[%r13], %r12		;//   Entry->Flink = ListHead
		add		%r12, 4			;//%r12 :=          &ListHead->Blink
		ld.w		%r9, [%r12]		;//%r9  :=    Tail = ListHead->Blink
		xld.w		[%r13+4], %r9		;//   Entry->Blink = Tail
		ld.w		[%r12], %r13		;//ListHead->Blink = Entry
		ld.w		[%r9], %r13		;//    Tail->Flink = Entry
		ret
	;//}}1ߐߖ
");
#endif//PIECE

/*****************************************************************************
 *	Ǝg
 *****************************************************************************/

void SortList(LIST_ENTRY* ListHead, int (*Compare)(LIST_ENTRY*, LIST_ENTRY*)) {
	//SortList()SortList_r()́ACompare֐̌`قȂ܂A
	//'cdeclďoK'Ȃ΁ASortList()`Compare֐ɂāA]Ȉ̂ŖL܂B
	SortList_r(ListHead, (int (*)(LIST_ENTRY*, LIST_ENTRY*, void*))Compare, NULL);
}
#if 0
//~ŃNCbN\[g̃ASYɂB
//\߃\[gꂽXgɑ΂ĎsƁAċAďo[Ȃ߂AvO~肪LB
//Œz̃NCbN\[gȂ΁AЕ̔zċAȂ@ŉo邪AXgł͓B
void SortList_r(LIST_ENTRY* ListHead, int (*Compare)(LIST_ENTRY*, LIST_ENTRY*, void*), void* Param) {
	LIST_ENTRY ListLT;	//s{bg̗vfAтێ܂܂ŁAǉčsXgB
	LIST_ENTRY ListGE;	//s{bgȏ̗vfAтێ܂܂ŁAǉčsXgB
	LIST_ENTRY *Pivot, *Entry;
	//̃XgȂ΁AȂB
	if(IsListEmpty(ListHead)) { return; }	//܂
	//̃XgB
	InitializeListHead(&ListLT);
	//ẼXgB
	InitializeListHead(&ListGE);
	//̃Xg̐擪vfOAs{bgƂB
	Pivot = RemoveHeadList(ListHead);
	//̃XgɂȂ܂Łc
	while(!IsListEmpty(ListHead)) {
		//̃Xg̐擪vfOB
		Entry = RemoveHeadList(ListHead);
		//s{bgȂ΁Aтێ܂܂ŁÃXgɒǉB
		if((*Compare)(Entry, Pivot, Param) < 0) {
			InsertTailList(&ListLT, Entry);
		//s{bgȏȂ΁Aтێ܂܂ŁAẼXgɒǉB
		} else {
			InsertTailList(&ListGE, Entry);
		}
	}
	//̃Xg\[gBs{bg̗vfA\[gʂƂȂB
	SortList_r(&ListLT, Compare, Param);
	//ẼXg\[gBs{bgȏ̗vfA\[gʂƂȂB
	SortList_r(&ListGE, Compare, Param);
	//̃XgAтێ܂܂ŁÃXgɏ߂B
	while(!IsListEmpty(&ListLT)) {
		Entry = RemoveHeadList(&ListLT);
		InsertTailList(ListHead, Entry);
	}
	//s{bgÃXgɏ߂BẼXg̐擪Ƀs{bgƓlLĂA̎菇ň\[gƂȂB
	InsertTailList(ListHead, Pivot);
	//ẼXgAтێ܂܂ŁÃXgɏ߂B
	while(!IsListEmpty(&ListGE)) {
		Entry = RemoveHeadList(&ListGE);
		InsertTailList(ListHead, Entry);
	}
}
#else
//}[W\[g̃ASYɂB
//Xg񓙕čċÂŁAňł30x̍ċAďoɗ}̂ŁANCbN\[gł̖肪oB
//A{̃}[W\[g͈\[gA֐͕̓s\[gł鎖ɒӂB
void SortList_r(LIST_ENTRY* ListHead, int (*Compare)(LIST_ENTRY*, LIST_ENTRY*, void*), void* Param) {
	LIST_ENTRY List1, List2, *Entry1, *Entry2;
	//ẼXgB
	InitializeListHead(&List1);
	InitializeListHead(&List2);
	//̃XgɂȂ܂Łc
	for(;;) {
		//̃XgȂ΁AB				//
		if(IsListEmpty(ListHead)) { break; }				//
		//̃Xg̐擪vfOÃXgɒǉB	//
		Entry1 = RemoveHeadList(ListHead);				//
		InsertTailList(&List1, Entry1);					//Œz̃}[W\[gƈčŏɑŜ̗vfȂ̂ŁA񓙕邽߂ɈvfÂU蕪鎖ɂB
		//̃XgȂ΁AB				//Œz̃}[W\[g͈\[gł邪A֐̎͂̓s߂Ɉ\[gł͂ȂɒӂB
		if(IsListEmpty(ListHead)) { break; }				//
		//̃Xg̐擪vfOAẼXgɒǉB	//
		Entry2 = RemoveHeadList(ListHead);				//
		InsertTailList(&List2, Entry2);					//
	}
	//ẼXgłȂ΁c
	// - ̃Xg̗vf0,,1ɂȂAċA~邽߂̔fłB
	//   ̔fsȂƁA0,,1vf̃Xgɑ΂ĖɍċAĂ܂B
	if(!IsListEmpty(&List2)) {
		//ẼXg\[gB
		SortList_r(&List1, Compare, Param);
		SortList_r(&List2, Compare, Param);
	}
	//ẼXgɂȂ܂Łc
	for(;;) {
		//ẼXg̐擪vfOBȂNULLƂB
		Entry1 = IsListEmpty(&List1) ? NULL : RemoveHeadList(&List1);
		Entry2 = IsListEmpty(&List2) ? NULL : RemoveHeadList(&List2);
		//̗vfL΁c
		if(Entry1) {
			//E̗vfL΁c
			if(Entry2) {
				//̗vfE̗vfȂ΁c
				if((*Compare)(Entry1, Entry2, Param) <= 0) {
					//̗vf̃Xg̖ɒǉB
					InsertTailList(ListHead, Entry1);
					//E̗vfẼXg̐擪ɏ߂B
					InsertHeadList(&List2, Entry2);
				//E̗vf̗vf΁c
				} else {
					//E̗vf̃Xg̖ɒǉB
					InsertTailList(ListHead, Entry2);
					//̗vf̃Xg̐擪ɏ߂B
					InsertHeadList(&List1, Entry1);
				}
			//E̗vf΁c
			} else {
				//̗vf̃Xg̖ɒǉB
				InsertTailList(ListHead, Entry1);
			}
		//̗vf΁c
		} else {
			//E̗vfL΁c
			if(Entry2) {
				//E̗vf̃Xg̖ɒǉB
				InsertTailList(ListHead, Entry2);
			//E̗vf΁c
			} else {
				//[v𔲂B
				break;
			}
		}
	}
}
#endif
