
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP
	
		.code
		.align		1
		.global		crc8_ccitt_r
		.global		crc16_ccitt_r
		.global		crc32_ieee_r
crc8_ccitt_r:						;//
	ext	0x2		; 		xld.w		%r14, 0xB1		;// %r14 :=                poly
	ld.w	%r14,0x31
		jp.d		crc_r_START		;// return  crc_r(data,len,poly,0)				ʂ%r10̃rbg[31: 8]͏0ɂȂB
		ld.w		%r10, 0			;// %r10 :=                     0		*delay*
		;//-------------------------------------;//
crc16_ccitt_r:						;//
	ext	0x210		; 		xld.w		%r14, 0x8408		;// %r14 :=                poly
	ld.w	%r14,0x8
	ext	0x3ff		; 		xld.w		%r10, 0xFFFF		;// %r10 :=                     0xFFFF
	ld.w	%r10,0x3f
		jp		crc_r_START		;// return  crc_r(data,len,poly,0xFFFF)				ʂ%r10̃rbg[31:16]͏0ɂȂB
		;//-------------------------------------;//
crc32_ieee_r:						;//
	ext	0x1db7		; 		xld.w		%r14, 0xEDB88320	;// %r14 :=                     poly
	ext	0x20c
	ld.w	%r14,0x20
		call.d		crc_r_START		;// %r10 := x := crc_r(data,len,poly,-1)
		ld.w		%r10, -1		;// %r10 :=                          -1		*delay*
		ret.d					;// return  x ^ -1
		xor		%r10, -1		;// %r10 := x ^ -1				*delay*
		;//-------------------------------------;//
crc_r_LOOP1:						;// do {
		ld.ub		%r9, [%r12]+		;//   %r9  :=      *data++
		xor		%r10, %r9		;//   %r10 := x ^= *data++
		ld.w		%r15, 8			;//   %r15 := i = 8
crc_r_LOOP2:						;//   do {
	ext	0x1		; 		xand		%r9, %r10, 1		;//     %r9  := x & 1
	and	%r9,%r10
		jreq.d		3			;//     if(     x & 1) {
		 srl		%r10, 1			;//     %r10 :=   x >>= 1			*delay*
		 xor		%r10, %r14		;//       %r10 := x  ^= poly }
		sub		%r15, 1			;//     %r15 := --i
		jrne		crc_r_LOOP2		;//   } while(i)
crc_r_START:						;//
		sub		%r13, 1			;//   %r13 := --len
		jrge		crc_r_LOOP1		;// } while(len >= 0)
		ret					;// return x

	
		.code
		.align		1
		.global		crc8_ccitt_l
		.global		crc16_ccitt_l
		.global		crc32_ieee_l
crc8_ccitt_l:						;//
	ext	0x11a0		; 		xld.w		%r14, 0x8D000000	;// %r14 :=                    poly<<24
	ext	0x0
	ld.w	%r14,0x0
		call.d		crc_l_START		;// %r10 := x = crc_l(data,len,poly<<24,0)				ʂ%r10̃rbg[23:0]͕K0ɂȂB
		ld.w		%r10, 0			;// %r10 :=                             0		*delay*
		ret.d					;// return  x>>24
		rl		%r10, 8			;// %r10 := x>>24					*delay*
		;//-------------------------------------;//
crc16_ccitt_l:						;//
	ext	0x204		; 		xld.w		%r14, 0x10210000	;// %r14 :=                    poly<<16
	ext	0x400
	ld.w	%r14,0x0
	ext	0x1c00		; 		xld.w		%r10, 0xFFFF0000	;// %r10 :=                             0xFFFF<<16
	ld.w	%r10,0x0
		call		crc_l_START		;// %r10 := x = crc_l(data,len,poly<<16,0xFFFF<<16)			ʂ%r10̃rbg[15:0]͕K0ɂȂB
	rr	%r10,0x8	; 		xrr		%r10, 16		;// %r10 := x>>16
	rr	%r10,0x8
		ret					;// return  x>>16
		;//-------------------------------------;//
crc32_ieee_l:						;//
	ext	0x98		; 		xld.w		%r14, 0x04C11DB7	;// %r14 :=                    poly
	ext	0x476
	ld.w	%r14,0x37
		call.d		crc_l_START		;// %r10 := x = crc_l(data,len,poly,-1)
		ld.w		%r10, -1		;// %r10 :=                         -1			*delay*
		ret.d					;// return  x ^ -1
		xor		%r10, -1		;// %r10 := x ^ -1					*delay*
		;//-------------------------------------;//
crc_l_LOOP1:						;// do {
		ld.ub		%r9, [%r12]+		;//   %r9  :=       *data++
		rr		%r9, 8			;//   %r9  :=      (*data++ << 24)
		xor		%r10, %r9		;//   %r10 := x ^= (*data++ << 24)
		ld.w		%r15, 8			;//   %r15 := i = 8
crc_l_LOOP2:						;//   do {
		add		%r10, %r10		;//     %r10 :=   x <<= 1, %psr(C) := x[32]
		jruge		2			;//     if(x[32]) {
		 xor		%r10, %r14		;//       %r10 := x  ^= poly }
		sub		%r15, 1			;//     %r15 := --i
		jrne		crc_l_LOOP2		;//   } while(i)
crc_l_START:						;//
		sub		%r13, 1			;//   %r13 := --len
		jrge		crc_l_LOOP1		;// } while(len >= 0)
		ret					;// return  x

