/*	
 *	clipcrc.c
 *
 *	CRCvZ
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Sat Feb 15 06:47:35 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

#ifndef PIECE
/* CRCvZ̋ʃ[`(rbg=E) */
static unsigned crc_r(const unsigned char* data, int len, unsigned poly, unsigned x) {
	unsigned i;
goto L_START;
	do {
		x ^= *data++;
		i = 8;
		do {
			if(x & 1) {
				x = (x>>1) ^ poly;
			} else {
				x = (x>>1);
			}
		} while(--i);
L_START: /* (len=0)ꍇ̂߂ɁA烋[vJnB */;
	} while(--len >= 0);
	return x;
}
/* CRC-8-CCITT
 *  = X^8+X^7+X^3+X^2+1
 * l     = 0x00
 * oXor    = 0x00
 * rbg = E
 */
int crc8_ccitt_r(const void* data, int len) {
	return crc_r(data, len, 0xB1, 0);
}
/* CRC-16-CCITT
 *  = X^16+X^12+X^5+1
 * l     = 0xFFFF
 * oXor    = 0x0000
 * rbg = E
 */
int crc16_ccitt_r(const void* data, int len) {
	return crc_r(data, len, 0x8408, 0xFFFF);
}
/* CRC-32-IEEE 802.3
 * =X^32+X^26+X^23+X^22+X^16+X^12+X^11+X^10+X^8+X^7+X^5+X^4+X^2+X+1
 * l     = 0xFFFFFFFF
 * oXor    = 0xFFFFFFFF
 * rbg = E
 */
int crc32_ieee_r(const void* data, int len) {
	return crc_r(data, len, 0xEDB88320, -1) ^ -1;
}
#else /*PIECE*/
int crc8_ccitt_r(const void* data, int len);
int crc16_ccitt_r(const void* data, int len);
int crc32_ieee_r(const void* data, int len);
asm("
		.code
		.align		1
		.global		crc8_ccitt_r
		.global		crc16_ccitt_r
		.global		crc32_ieee_r
crc8_ccitt_r:						;//
		xld.w		%r14, 0xB1		;// %r14 :=                poly
		jp.d		crc_r_START		;// return  crc_r(data,len,poly,0)				ʂ%r10̃rbg[31: 8]͏0ɂȂB
		ld.w		%r10, 0			;// %r10 :=                     0		*delay*
		;//-------------------------------------;//
crc16_ccitt_r:						;//
		xld.w		%r14, 0x8408		;// %r14 :=                poly
		xld.w		%r10, 0xFFFF		;// %r10 :=                     0xFFFF
		jp		crc_r_START		;// return  crc_r(data,len,poly,0xFFFF)				ʂ%r10̃rbg[31:16]͏0ɂȂB
		;//-------------------------------------;//
crc32_ieee_r:						;//
		xld.w		%r14, 0xEDB88320	;// %r14 :=                     poly
		call.d		crc_r_START		;// %r10 := x := crc_r(data,len,poly,-1)
		ld.w		%r10, -1		;// %r10 :=                          -1		*delay*
		ret.d					;// return  x ^ -1
		xor		%r10, -1		;// %r10 := x ^ -1				*delay*
		;//-------------------------------------;//
crc_r_LOOP1:						;// do {
		ld.ub		%r9, [%r12]+		;//   %r9  :=      *data++
		xor		%r10, %r9		;//   %r10 := x ^= *data++
		ld.w		%r15, 8			;//   %r15 := i = 8
crc_r_LOOP2:						;//   do {
		xand		%r9, %r10, 1		;//     %r9  := x & 1
		jreq.d		3			;//     if(     x & 1) {
		 srl		%r10, 1			;//     %r10 :=   x >>= 1			*delay*
		 xor		%r10, %r14		;//       %r10 := x  ^= poly }
		sub		%r15, 1			;//     %r15 := --i
		jrne		crc_r_LOOP2		;//   } while(i)
crc_r_START:						;//
		sub		%r13, 1			;//   %r13 := --len
		jrge		crc_r_LOOP1		;// } while(len >= 0)
		ret					;// return x
");
#endif/*PIECE*/

/****************************************************************************
 *	
 ****************************************************************************/

#ifndef PIECE
/* CRCvZ̋ʃ[`(rbg=) */
static unsigned crc_l(const unsigned char* data, int len, unsigned poly, unsigned x) {
	unsigned i;
goto L_START;
	do {
		x ^= (*data++ << 24);
		i = 8;
		do {
			if(x & (1<<31)) {
				x = (x<<1) ^ poly;
			} else {
				x = (x<<1);
			}
		} while(--i);
L_START: /* (len=0)ꍇ̂߂ɁA烋[vJnB */;
	} while(--len >= 0);
	return x;
}
/* CRC-8-CCITT
 *  = X^8+X^7+X^3+X^2+1
 * l     = 0x00
 * oXor    = 0x00
 * rbg = 
 */
int crc8_ccitt_l(const void* data, int len) {
	return crc_l(data, len, 0x8D<<24, 0) >> 24;
}
/* CRC-16-CCITT
 *  = X^16+X^12+X^5+1
 * l     = 0xFFFF
 * oXor    = 0x0000
 * rbg = 
 */
int crc16_ccitt_l(const void* data, int len) {
	return crc_l(data, len, 0x1021<<16, 0xFFFF<<16) >> 16;
}
/* CRC-32-IEEE 802.3
 * =X^32+X^26+X^23+X^22+X^16+X^12+X^11+X^10+X^8+X^7+X^5+X^4+X^2+X+1
 * l     = 0xFFFFFFFF
 * oXor    = 0xFFFFFFFF
 * rbg = 
 */
int crc32_ieee_l(const void* data, int len) {
	return crc_l(data, len, 0x04C11DB7, -1) ^ -1;
}
#else /*PIECE*/
int crc8_ccitt_l(const void* data, int len);
int crc16_ccitt_l(const void* data, int len);
int crc32_ieee_l(const void* data, int len);
asm("
		.code
		.align		1
		.global		crc8_ccitt_l
		.global		crc16_ccitt_l
		.global		crc32_ieee_l
crc8_ccitt_l:						;//
		xld.w		%r14, 0x8D000000	;// %r14 :=                    poly<<24
		call.d		crc_l_START		;// %r10 := x = crc_l(data,len,poly<<24,0)				ʂ%r10̃rbg[23:0]͕K0ɂȂB
		ld.w		%r10, 0			;// %r10 :=                             0		*delay*
		ret.d					;// return  x>>24
		rl		%r10, 8			;// %r10 := x>>24					*delay*
		;//-------------------------------------;//
crc16_ccitt_l:						;//
		xld.w		%r14, 0x10210000	;// %r14 :=                    poly<<16
		xld.w		%r10, 0xFFFF0000	;// %r10 :=                             0xFFFF<<16
		call		crc_l_START		;// %r10 := x = crc_l(data,len,poly<<16,0xFFFF<<16)			ʂ%r10̃rbg[15:0]͕K0ɂȂB
		xrr		%r10, 16		;// %r10 := x>>16
		ret					;// return  x>>16
		;//-------------------------------------;//
crc32_ieee_l:						;//
		xld.w		%r14, 0x04C11DB7	;// %r14 :=                    poly
		call.d		crc_l_START		;// %r10 := x = crc_l(data,len,poly,-1)
		ld.w		%r10, -1		;// %r10 :=                         -1			*delay*
		ret.d					;// return  x ^ -1
		xor		%r10, -1		;// %r10 := x ^ -1					*delay*
		;//-------------------------------------;//
crc_l_LOOP1:						;// do {
		ld.ub		%r9, [%r12]+		;//   %r9  :=       *data++
		rr		%r9, 8			;//   %r9  :=      (*data++ << 24)
		xor		%r10, %r9		;//   %r10 := x ^= (*data++ << 24)
		ld.w		%r15, 8			;//   %r15 := i = 8
crc_l_LOOP2:						;//   do {
		add		%r10, %r10		;//     %r10 :=   x <<= 1, %psr(C) := x[32]
		jruge		2			;//     if(x[32]) {
		 xor		%r10, %r14		;//       %r10 := x  ^= poly }
		sub		%r15, 1			;//     %r15 := --i
		jrne		crc_l_LOOP2		;//   } while(i)
crc_l_START:						;//
		sub		%r13, 1			;//   %r13 := --len
		jrge		crc_l_LOOP1		;// } while(len >= 0)
		ret					;// return  x
");
#endif/*PIECE*/

