/*	
 *	clipcp8i.c
 *
 *	P/ECE CHIP-8 Interpreter
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Mar 18 21:17:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"
#include "clipcp8i.h"	/*CHIP-8C^v^p}N*/

/****************************************************************************
 *
 ****************************************************************************/

#define ILL()	do { STAT |= CHIP8_ILL; return; } while(0)

/****************************************************************************
 *
 ****************************************************************************/

void
chip8_run(CHIP8* chip8, int cycle)
{
	unsigned short code;

	while(!(STAT & (CHIP8_EXIT | CHIP8_ILL)) && (cycle > 0)) {
#ifdef CHIP8_TRACE
		chip8_dump(chip8);
#endif /*CHIP8_TRACE*/
		FETCH();

		switch((code >> 12) & 0xf) {
		case 0x0: switch((code >> 4) & 0xff) {
			  case 0x0c: EXEC(00CN);
			  case 0x0e: switch(code & 0xf) {
				     case 0x0: EXEC(00E0);
				     case 0xe: EXEC(00EE);
				     default:  EXEC(0NNN);
				     }
			  case 0x0f: switch(code & 0xf) {
				     case 0xb: EXEC(00FB);
				     case 0xc: EXEC(00FC);
				     case 0xd: EXEC(00FD);
				     case 0xe: EXEC(00FE);
				     case 0xf: EXEC(00FF);
				     default:  EXEC(0NNN);
				     }
			  default:   EXEC(0NNN);
			  }
		case 0x1: EXEC(1NNN);
		case 0x2: EXEC(2NNN);
		case 0x3: EXEC(3XKK);
		case 0x4: EXEC(4XKK);
		case 0x5: switch(code & 0xf) {
			  case 0x0: EXEC(5XY0);
			  default:  ILL();
			  }
		case 0x6: EXEC(6XKK);
		case 0x7: EXEC(7XKK);
		case 0x8: switch(code & 0xf) {
			  case 0x0: EXEC(8XY0);
			  case 0x1: EXEC(8XY1);
			  case 0x2: EXEC(8XY2);
			  case 0x3: EXEC(8XY3);
			  case 0x4: EXEC(8XY4);
			  case 0x5: EXEC(8XY5);
			  case 0x6: EXEC(8XY6);
			  case 0x7: EXEC(8XY7);
			  case 0xe: EXEC(8XYE);
			  default:  ILL();
			  }
		case 0x9: switch(code & 0xf) {
			  case 0x0: EXEC(9XY0);
			  default:  ILL();
			  }
		case 0xa: EXEC(ANNN);
		case 0xb: EXEC(BNNN);
		case 0xc: EXEC(CXKK);
		case 0xd: switch(code & 0xf) {
			  case 0x0: EXEC(DXY0);
			  default:  EXEC(DXYN);
			  }
		case 0xe: switch(code & 0xff) {
			  case 0x9e: EXEC(EX9E);
			  case 0xa1: EXEC(EXA1);
			  default:   ILL();
			  }
		case 0xf: switch(code & 0xff) {
			  case 0x07: EXEC(FX07);
			  case 0x0a: EXEC(FX0A);
			  case 0x15: EXEC(FX15);
			  case 0x18: EXEC(FX18);
			  case 0x1e: EXEC(FX1E);
			  case 0x29: EXEC(FX29);
			  case 0x30: EXEC(FX30);
			  case 0x33: EXEC(FX33);
			  case 0x55: EXEC(FX55);
			  case 0x65: EXEC(FX65);
			  case 0x75: EXEC(FX75);
			  case 0x85: EXEC(FX85);
			  default:   ILL();
			  }
		default:  ILL();
		}
L_NEXT:
		cycle--;
	}
}

/****************************************************************************
 *
 ****************************************************************************/

/* ߃R[h̕op}NȂ */
#define N	(code & 0xf)		/* ???N */
#define KK	(code & 0xff)		/* ??KK */
#define NNN	(code & 0xfff)		/* ?NNN */
#define X	((code >> 8) & 0xf)	/* ?X?? */
#define Y	((code >> 4) & 0xf)	/* ?Y?? */
#define VX	V(X)
#define VY	V(Y)

/****************************************************************************
 *	OtBbN
 ****************************************************************************/

CHIP8FN_(00CN,"SCD Nibble") {
	int n = N;
	/* w胉CAXN[B */
	memmove(&SCRHI(0, n), &SCRHI(0, 0), CHIP8_SCRHI_W * (CHIP8_SCRHI_H - n));
	/* XN[Aʏ㕔NAB(Kv!!) */
	memset(&SCRHI(0, 0), 0, CHIP8_SCRHI_W * n);
}
CHIP8FN_(00FB,"SCR") {
	int i;
	if(STAT & CHIP8_SCHIP) {
		/* 128x64[hł́A4sNZXN[Ɖ߂܂B */
		for(i = 0; i < CHIP8_SCRHI_H; i++) {
			/* 4sNZAEXN[B */
			memmove(&SCRHI(4, i), &SCRHI(0, i), CHIP8_SCRHI_W - 4);
			/* XN[AʍNAB(Kv!!) */
			memset(&SCRHI(0, i), 0, 4);
		}
	} else {
		/* 64x32[hł́A2sNZXN[Ɖ߂܂B */
		for(i = 0; i < CHIP8_SCRLO_H; i++) {
			/* 2sNZAEXN[B */
			memmove(&SCRLO(2, i), &SCRLO(0, i), CHIP8_SCRLO_W - 2);
			/* XN[AʍNAB(Kv!!) */
			memset(&SCRLO(0, i), 0, 2);
		}
	}
}
CHIP8FN_(00FC,"SCL") {
	int i;
	if(STAT & CHIP8_SCHIP) {
		/* 128x64[hł́A4sNZXN[Ɖ߂܂B */
		for(i = 0; i < CHIP8_SCRHI_H; i++) {
			/* 4sNZAXN[B */
			memmove(&SCRHI(0, i), &SCRHI(4, i), CHIP8_SCRHI_W - 4);
			/* XN[AʉENAB(Kv!!) */
			memset(&SCRHI(CHIP8_SCRHI_W - 4, i), 0, 4);
		}
	} else {
		/* 64x32[hł́A2sNZXN[Ɖ߂܂B */
		for(i = 0; i < CHIP8_SCRHI_H; i++) {
			/* 2sNZAXN[B */
			memmove(&SCRHI(0, i), &SCRHI(2, i), CHIP8_SCRHI_W - 2);
			/* XN[AʉENAB(Kv!!) */
			memset(&SCRHI(CHIP8_SCRHI_W - 2, i), 0, 2);
		}
	}
}
CHIP8FN_(00FD,"EXIT")		{ STAT |=  CHIP8_EXIT ; }
CHIP8FN_(00FE,"LOW")		{ STAT &= ~CHIP8_SCHIP; }
CHIP8FN_(00FF,"HIGH")		{ STAT |=  CHIP8_SCHIP; }
CHIP8FN_(00E0,"CLS")		{ memset(SCR, 0, CHIP8_SCR_SIZE); }
CHIP8FN_(FX29,"LD LF,VX")	{ I = CHIP8_FONT4x5_ADDRESS  + (VX & 0xf) *  5; }
CHIP8FN_(FX30,"LD HF,VX")	{ I = CHIP8_FONT8x10_ADDRESS + (VX & 0xf) * 10; }
CHIP8FN_(DXYN,"DRW VX,VY,Nibble") {
	int x0, y0, x, y, h, i, v;
	unsigned char* p;
	x0 = VX;	/* `挴_XW */
	y0 = VY;	/* `挴_YW */
	h = N;		/* XvCg̃C */
	i = I;		/* XvCgp^[AhX */
	VF = 0;		/* ՓˌotONA */
	if(STAT & CHIP8_SCHIP) {
		/* 128x64/64x32ǂ̃[hłA8xNsNZXvCg̕`Ɖ߂܂B */
		for(y = 0; y < h; y++) {
			v = MEM(i);	/* 1C̃XvCgp^[擾 */
			for(x = 0; x < 8; x++) {
				if(v & (0x80 >> x)) {
					p = &SCRHI(x0 + x, y0 + y); /* 128x64 */
					if(*p) {
						*p = 0;
						VF = 1;	/* ՓˌotOZbg */
					} else {
						*p = 1;
					}
				}
			}
			i++;	/* XvCgp^[AhXi߂܂ */
		}
	} else {
		/* 128x64/64x32ǂ̃[hłA8xNsNZXvCg̕`Ɖ߂܂B */
		for(y = 0; y < h; y++) {
			v = MEM(i);	/* 1C̃XvCgp^[擾 */
			for(x = 0; x < 8; x++) {
				if(v & (0x80 >> x)) {
					p = &SCRLO(x0 + x, y0 + y); /* 64x32 */
					if(*p) {
						*p = 0;
						VF = 1;	/* ՓˌotOZbg */
					} else {
						*p = 1;
					}
				}
			}
			i++;	/* XvCgp^[AhXi߂܂ */
		}
	}
}
CHIP8FN_(DXY0,"DRW VX,VY,0") {
	int x0, y0, x, y, i, v;
	unsigned char* p;
	x0 = VX;	/* `挴_XW */
	y0 = VY;	/* `挴_YW */
	i = I;		/* XvCgp^[AhX */
	VF = 0;		/* ՓˌotONA */
	if(STAT & CHIP8_SCHIP) {
		/* 128x64[hł́A16x16sNZXvCg̕`Ɖ߂܂B */
		for(y = 0; y < 16; y++) {
			v = MEM(i) << 8 | MEM(i + 1);	/* 1C̃XvCgp^[擾 */
			for(x = 0; x < 16; x++) {
				if(v & (0x8000 >> x)) {
					p = &SCRHI(x0 + x, y0 + y); /* 128x64 */
					if(*p) {
						*p = 0;
						VF = 1;	/* ՓˌotOZbg */
					} else {
						*p = 1;
					}
				}
			}
			i += 2;	/* XvCgp^[AhXi߂܂ */
		}
	} else {
		/* 64x32[hł́A8x16sNZXvCg̕`Ɖ߂܂B */
		for(y = 0; y < 8; y++) {
			v = MEM(i);	/* 1C̃XvCgp^[擾 */
			for(x = 0; x < 8; x++) {
				if(v & (0x80 >> x)) {
					p = &SCRLO(x0 + x, y0 + y); /* 64x32 */
					if(*p) {
						*p = 0;
						VF = 1;	/* ՓˌotOZbg */
					} else {
						*p = 1;
					}
				}
			}
			i++;	/* XvCgp^[AhXi߂܂ */
		}
	}
}

/****************************************************************************
 *	L[{[h
 ****************************************************************************/

CHIP8FN_(EX9E,"SKP VX")		{ if( (KEY & (1 << (VX & 0xf)))) P += 2; }
CHIP8FN_(EXA1,"SKNP VX")	{ if(!(KEY & (1 << (VX & 0xf)))) P += 2; }
CHIP8FN_(FX0A,"LD VX,K") {
	int i;
	for(i = 0; i < 16; i++) {
		if(KEY & (1 << i)) {
			VX = i;
			return;
		}
	}
	P -= 2; /* L[܂ł̖߂JԂ */
}

/****************************************************************************
 *	WvER[
 ****************************************************************************/

CHIP8FN_(1NNN,"JP Addr")	{ P = NNN; }
CHIP8FN_(BNNN,"JP V0,Addr")	{ P = NNN + V0; }
CHIP8FN_(3XKK,"SE VX,Byte")	{ if(VX == KK) P += 2; }
CHIP8FN_(4XKK,"SNE VX,Byte")	{ if(VX != KK) P += 2; }
CHIP8FN_(5XY0,"SE VX,VY")	{ if(VX == VY) P += 2; }
CHIP8FN_(9XY0,"SNE VX,VY")	{ if(VX != VY) P += 2; }
CHIP8FN_(2NNN,"CALL Addr") {
	if(S > 15) ILL(); /* X^bNI[o[t[ */
	STACK(S) = P;
	S++;
	P = NNN;
}
CHIP8FN_(00EE,"RET") {
	if(!S) ILL(); /* X^bNA_[t[ */
	S--;
	P = STACK(S);
}
CHIP8FN_(0NNN,"SYS Addr")	{ ILL(); }	/*Ή(CDP-1802̃G~[VKv)*/

/****************************************************************************
 *	[hEXgA
 ****************************************************************************/

CHIP8FN_(6XKK,"LD VX,Byte")	{ VX = KK; }
CHIP8FN_(8XY0,"LD VX,VY")	{ VX = VY; }
CHIP8FN_(ANNN,"LD I,Addr")	{ I = NNN; }
CHIP8FN_(FX07,"LD VX,DT")	{ VX = DT; }
CHIP8FN_(FX15,"LD DT,VX")	{ DT = VX; }
CHIP8FN_(FX18,"LD ST,VX")	{ ST = VX; }
CHIP8FN_(FX55,"LD [I],VX")	{ int i; for(i = 0; i <= X; i++) { MEM(I + i) = V(i); } }
CHIP8FN_(FX65,"LD VX,[I]")	{ int i; for(i = 0; i <= X; i++) { V(i) = MEM(I + i); } }
CHIP8FN_(CXKK,"RND VX,Byte")	{ SEED = SEED * 5 + 0x3711; VX = (SEED >> 8) & KK; }
CHIP8FN_(FX33,"LD B,VX") {
	int v = VX;
	MEM(I + 2) = v % 10;	/*   1̈ */
	v /= 10;
	MEM(I + 1) = v % 10;	/*  10̈ */
	v /= 10;
	MEM(I + 0) = v;		/* 100̈ */
}
CHIP8FN_(FX75,"LD R,VX")	{ ILL(); }	/*SCHIP(HP48L?)*/
CHIP8FN_(FX85,"LD VX,R")	{ ILL(); }	/*SCHIP(HP48L?)*/

/****************************************************************************
 *	ZpZ
 ****************************************************************************/

CHIP8FN_(7XKK,"ADD VX,Byte")	{ VX += KK; }
CHIP8FN_(8XY4,"ADD VX,VY")	{ int tmp = VX + VY; VX = tmp; VF = ( tmp >> 8) & 1; } /* VF= carry */
CHIP8FN_(8XY5,"SUB VX,VY")	{ int tmp = VX - VY; VX = tmp; VF = (~tmp >> 8) & 1; } /* VF=!carry */
CHIP8FN_(8XY7,"SUBN VX,VY")	{ int tmp = VY - VX; VX = tmp; VF = (~tmp >> 8) & 1; } /* VF=!carry */
CHIP8FN_(8XY1,"OR VX,VY")	{ VX |= VY; }
CHIP8FN_(8XY2,"AND VX,VY")	{ VX &= VY; }
CHIP8FN_(8XY3,"XOR VX,VY")	{ VX ^= VY; }
CHIP8FN_(8XY6,"SHR VX{,VY}")	{ VF = VX & 1; VX >>= 1; }
CHIP8FN_(8XYE,"SHL VX{,VY}")	{ VF = VX >> 7; VX <<= 1; }
CHIP8FN_(FX1E,"ADD I,VX")	{ I += VX; }

