/*	
 *	clipcom.c
 *
 *	VAʐMhCo
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon May 17 22:46:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue May 18 12:30:00 JST 2004 Naoyuki Sawa
 *	- com_send()𑗐Mobt@󂫂ł܂ŃubN悤ɕύXB
 *	* Sun May 30 13:51:00 JST 2004 Naoyuki Sawa
 *	- com_rts()Acom_cts()ǉ܂B
 *	* Mon May 31 13:51:00 JST 2004 Naoyuki Sawa
 *	- MR[obN@\ǉ܂B
 *	* Tue Jun 1 20:05:00 JST 2004 Naoyuki Sawa
 *	- #RTS/#CTS̘_t̂C܂B
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

/*
 *	VAʐMhCo\
 */
typedef struct _COMDRIVER {
	int open;			/* JĂ1 */
	void (*recv_callback)();	/* MʒmR[obN */
	void (*send_callback)();	/* MR[obN */
	int rxbuf_overflow;		/* Mobt@I[o[t[1 */
	//
	int rxbuf_size;			/* Mobt@TCY */
	int rxbuf_pos;			/* Mobt@̗Lf[^擪ʒu */
	int rxbuf_len;			/* Mobt@̗Lf[^oCg */
	unsigned char* rxbuf;		/* Mobt@ */
	//
	int txbuf_size;			/* Mobt@TCY */
	int txbuf_pos;			/* Mobt@̗Lf[^擪ʒu */
	int txbuf_len;			/* Mobt@̗Lf[^oCg */
	unsigned char* txbuf;		/* Mobt@ */
} COMDRIVER;
static COMDRIVER com;

void com_isr();
static void _com_isr() __attribute__((unused));

/****************************************************************************
 *	
 ****************************************************************************/

void
com_open(int baudrate, int parity, int bytesize, int stopbits, int rxbuf_size, int txbuf_size, void (*recv_callback)(), void (*send_callback)())
{
	int RLD;	/* 8rbgvO}u^C}̃[hWX^ݒl */
	int fPCIN;	/* vXP[̓NbNg(Hz) */
	int bps;	/* ]x(rbg/b) */
	int pdr;	/* vXP[̕ */
	int sdr;	/* VAC^[tFCX(16܂8) */
	//
	int i_pdr;
	int i_sdr;
	//
	int ok_i_pdr;
	int ok_i_sdr;
	int ok_RLD;
	int ok_bps;

	/* ɊJĂꍇɔāA܂mɕ܂B */
	com_close();

	/* hCo\̂܂B */
	memset(&com, 0, sizeof com);
	com.open = 1;
	com.recv_callback = recv_callback;
	com.send_callback = send_callback;
	com.rxbuf_size = rxbuf_size ? rxbuf_size : 128;
	com.rxbuf = (unsigned char*)calloc(1, com.rxbuf_size);
	com.txbuf_size = txbuf_size ? txbuf_size : 128;
	com.txbuf = (unsigned char*)calloc(1, com.txbuf_size);

	/* vXP[̓NbNg擾܂B */
	if(bP0_P0D_P07D) {
		fPCIN = 24000000;
	} else {
		fPCIN = 48000000;
	}

	/* œKȐݒ܂B */
	ok_i_pdr = 0;	/* x} */
	ok_i_sdr = 0;	/* x} */
	ok_RLD   = 0;	/* x} */
	ok_bps   = 0;	/* ̗p̂ */

	/* 8rbgvO}u^C}3̃vXP[́A1/{1,2,4,8,16,32,64,128,256}B
	 *                                                              x      
	 */
	for(i_pdr = -1; i_pdr <= 7; i_pdr++) {
		pdr = 1 << (i_pdr + 1);

		/* VAC^[tFCX̓́A1/{16,8}B
		 *                                        ၩx
		 */
		for(i_sdr = 0; i_sdr <= 1; i_sdr++) {
			sdr = 16 >> i_sdr;

			/* 8rbgvO}u^C}̃[hWX^ݒlZo܂B
			 *
			 *	      fPCIN  pdr  sdr               fPCIN             
			 *	RLD = ------------------- - 1 = ---------------------- - 1
			 *	          2 ~ bps	        2 ~ bps ~ pdr ~ sdr    
			 */
			RLD = fPCIN / (2 * baudrate * pdr * sdr) - 1;
			if(RLD < 0 || RLD > 255) continue; /* ݒs */

			/* {̓]xZo܂B
			 *	                 fPCIN            
			 *	bps = ----------------------------
			 *	      2 ~ (RLD + 1) ~ pdr ~ sdr
			 */
			bps = fPCIN / (2 * (RLD + 1) * pdr * sdr);

			/* ȑOɌݒ덷΁A̗p܂B
			 * ok_bps=0ƂȂĂ̂ŁAK̗p͂łB
			 */
			if(abs(baudrate - bps) < abs(baudrate - ok_bps)) {
				ok_i_pdr = i_pdr;
				ok_i_sdr = i_sdr;
				ok_RLD   = RLD;
				ok_bps   = bps;
			}
		}
	}
	if(!ok_bps) DIE(); /* ݒs */

	/* VAC^tF[X~B */
	bSIF1_CTL_TXEN1 = 0;	/* Serial I/F Ch.1 transmit enable => ֎~ */
	bSIF1_CTL_RXEN1 = 0;	/* Serial I/F Ch.1 receive enable  => ֎~ */

	/* 8rbgvO}u^C}3~B */
	pT8_CTL3 = 0;			/* 8-bit timer 3 clock control register => ^C}~       */
	bCLKCTL_T8_23_P8TON3 = 0;	/* 8-bit timer 3 clock control          => vXP[~ */

	/*{{S1C33209/221/222eNjJ}jAwC^[tF[X̐ݒx(s1c33209_221_222j.pdf B-III-8-13`)Q*/

	/* o͒[q̐ݒ */
	bPF_CFEX_CFEX4 = 0;	/* P04 port extended function #DMAACK2/P04,etc      => P04,etc   */
	bP0_CFP0_CFP04 = 1;	/* P04 function selection SIN1/P04                  => SIN1      */
	bPF_CFEX_CFEX5 = 0;	/* P05 port extended function #DMAEND2/P05,etc      => P05,etc   */
	bP0_CFP0_CFP05 = 1;	/* P05 function selection SOUT1/P05                 => SOUT1     */
	/*{{2004/05/17݁An[hEFAt[䖢ΉłB[qݒ̂*/
	bPF_CFEX_CFEX0 = 0;	/* P12,P14 port extended function DST2,DCLK/P12,P14 => P12,P14   */
	bP1_CFP1_CFP12 = 0;	/* P12 function selection EXCL2,T8UF2/P12           => P12(#RTS) */
	bP1_IOC1_IOC12 = 1;	/* P12 I/O control                                  => o      */
	//bP1_P1D_P12D = ?;	/* P12 port                                         => Őݒ  */
	bP1_CFP1_CFP14 = 0;	/* P14 function selection FOSC1/P14                 => P14(#CTS) */
	bP1_IOC1_IOC14 = 0;	/* P14 I/O control                                  =>       */
	/*}}2004/05/17݁An[hEFAt[䖢ΉłB[qݒ̂*/

	/* C^tF[X[hݒ */
	bSIF1_IRDA_IRMD1 = 0;	/* Serial I/F Ch.1 interface mode selection => ʏ̃C^tF[X(IrDA) */

	/* ][hݒ */
	switch(bytesize) {
	case 7: bSIF1_CTL_SMD1 = 2; break;	/* Serial I/F Ch.1 transmit mode selection => 7bit */
	case 8: bSIF1_CTL_SMD1 = 3; break;	/* Serial I/F Ch.1 transmit mode selection => 8bit */
	default: DIE();
	}

	/* f[^tH[}bg̐ݒ */
	switch(stopbits) {
	case 1: bSIF1_CTL_STPB1 = 0; break;	/* Serial I/F Ch.1 stop bit selection => 1bit */
	case 2: bSIF1_CTL_STPB1 = 1; break;	/* Serial I/F Ch.1 stop bit selection => 2bit */
	default: DIE();
	}
	switch(parity) {
	case 0: bSIF1_CTL_EPR1 = 0; break;	/* Serial I/F Ch.1 parity enable         => peBȂ */
	case 1: bSIF1_CTL_EPR1 = 1;		/* Serial I/F Ch.1 parity enable         => peBt   */
		bSIF1_CTL_PMD1 = 1; break;	/* Serial I/F Ch.1 parity mode selection =>          */
	case 2: bSIF1_CTL_EPR1 = 1;		/* Serial I/F Ch.1 parity enable         => peBt   */
		bSIF1_CTL_PMD1 = 0; break;	/* Serial I/F Ch.1 parity mode selection =>          */
	default: DIE();
	}

	/* ̓NbN̐ݒ */
	bSIF1_CTL_SSCK1 = 0;			/* Serial I/F Ch.1 input clock selection => NbN */
	if(ok_i_pdr < 0) {
		bCLKSEL_T8_P8TPCK3 = 1;		/* 8-bit timer 3 clock selection => 1/ */
	} else {
		bCLKSEL_T8_P8TPCK3 = 0;		/* 8-bit timer 3 clock selection => NbN */
		bCLKCTL_T8_23_P8TS3 = ok_i_pdr;	/* 8-bit timer 3 clock division ratio selection  */
	}
	pT8_RLD3 = ok_RLD;			/* 8-bit timer 3 reload data register */
	bSIF1_IRDA_DIVMD1 = ok_i_sdr;		/* Serial I/F Ch.1 async. clock division ratio */

	/*}}S1C33209/221/222eNjJ}jAwC^[tF[X̐ݒx(s1c33209_221_222j.pdf B-III-8-13`)Q*/

	/* 荞݃T[rX[`CXg[܂B */
	pceVectorSetTrap(TRAP_SERR1, com_isr);	/* Serial I/F Ch.1 receive error */
	pceVectorSetTrap(TRAP_SRX1, com_isr);	/* Serial I/F Ch.1 receive buffer full */
	pceVectorSetTrap(TRAP_STX1, com_isr);	/* Serial I/F Ch.1 transmit buffer empty */

	/* 荞݃vCIeBݒ肵܂B
	 * * TEh荞ݒĂ΂R[obŃAyhCoɂĂ͎Ԃꍇ܂B
	 *   TEh荞ݒ́AIL=5őd荞݂󂯕tĂ܂B(PIECE KERNEL v1.20 )
	 *   VAMobt@I[o[G[h߂ɁATEh荞݂Dxݒ肵ĂB
	 *   2004/05/17݂̎ł́Am̂߂ɁAōvCIeB7^邱Ƃɂ܂B
	 */
	bINT_PSIO1_PAD_PSIO1 = 7;	/* Serial I/F Ch.1 interrupt priority */

	/* com_open()̏ԂŁARTSM1(f[^M\)Ƃ܂B */
	com_rts(1);

	/* ȂMG[ɂȂĂ܂Ȃ悤AJnOɊmɃG[vZbgĂ܂B */
	com_reset();

	/* 荞ݗṽZbg͕Kv܂B
	 * 荞݃[`̒ŃXe[^X𒲂ׂĂ珈ŝŁAsvȊ荞݂Ă肠܂B
	 */

ENTER_CS;
	/* 荞݂܂B */
	bINT_ESIF_ESERR1 = 1;	/* Serial I/F Ch.1 receive error         =>  */
	bINT_ESIF_ESRX1 = 1;	/* Serial I/F Ch.1 receive buffer full   =>  */
	bINT_ESIF_ESTX1 = 1;	/* Serial I/F Ch.1 transmit buffer empty =>  */

	/* 8rbgvO}u^C}3JnB */
	bCLKCTL_T8_23_P8TON3 = 1;	/* 8-bit timer 3 clock control          => vXP[Jn */
	pT8_CTL3 = 7;			/* 8-bit timer 3 clock control register => ^C}JnAvZbgANbNo(VAI/F̂߂ɕKv!!) */

	/* VAC^tF[XJnB */
	bSIF1_CTL_TXEN1 = 1;	/* Serial I/F Ch.1 transmit enable =>  */
	bSIF1_CTL_RXEN1 = 1;	/* Serial I/F Ch.1 receive enable  =>  */
LEAVE_CS;
}

void
com_close()
{
	/* JĂȂ΁A܂B */
	if(!com.open) return;

ENTER_CS;
	/* VAC^tF[X~B */
	bSIF1_CTL_TXEN1 = 0;	/* Serial I/F Ch.1 transmit enable => ֎~ */
	bSIF1_CTL_RXEN1 = 0;	/* Serial I/F Ch.1 receive enable  => ֎~ */

	/* 8rbgvO}u^C}3~B */
	pT8_CTL3 = 0;			/* 8-bit timer 3 clock control register => ^C}~       */
	bCLKCTL_T8_23_P8TON3 = 0;	/* 8-bit timer 3 clock control          => vXP[~ */

	/* 荞݂֎~܂B */
	bINT_ESIF_ESERR1 = 0;	/* Serial I/F Ch.1 receive error         => ֎~ */
	bINT_ESIF_ESRX1 = 0;	/* Serial I/F Ch.1 receive buffer full   => ֎~ */
	bINT_ESIF_ESTX1 = 0;	/* Serial I/F Ch.1 transmit buffer empty => ֎~ */
LEAVE_CS;

	/* hCo\̂NA܂B */
	free(com.rxbuf);
	free(com.txbuf);
	memset(&com, 0, sizeof com);

	/* [qݒ͂Ƃ肠̂܂܂łv? */
}

/* void com_isr() */
asm("
	.code
	.align 1
com_isr:
	pushn %r15
	ld.w %r0, %alr
	ld.w %r1, %ahr
	pushn %r1
	call _com_isr
	popn %r1
	ld.w %ahr, %r1
	ld.w %alr, %r0
	popn %r15
	reti
");

static void
_com_isr()
{
	int v;
	int i;

	/* 荞ݗvNA܂B
	 * VACh.1̎MG[AMobt@tAMobt@GveB荞ݗvSăNA܂B
	 * WX^ɑ݂VACh.0̊荞ݗvɃNAĂ܂܂A~ނ𓾂܂B
	 * P/ECE KernelRD/WR̊荞݃NAIĂ̂ŁA̗vNAł܂B
	 * upINT_FSIF = pINT_FSIF & ~0x28^Ch.1̗vȊOێ^vƂĂʂłB
	 * Read`Modify`Write̊Ԃŕω荞ݗv(Ӑ})NAĂ܂Ƃ܂B
	 * KAP/ECẼn[hEFA̓VACh.0𗘗pĂȂ̂ŁAvNAĂȂ͂łB
	 */
	pINT_FSIF = 0; /* bINT_FSIF_FSERR1 = bINT_FSIF_FSRX1 = bINT_FSIF_FSTX1 = 0 */

	/* Mobt@t? */
	if(bSIF1_STATUS_RDBF1) {
		/* MLN^ǂݏo܂B */
		v = pSIF1_RXD;
		/* hCo\̂̎Mobt@ɋ󂫂? */
		if(com.rxbuf_len < com.rxbuf_size) {
			/* hCo\̂̎Mobt@Ɋi[܂B */
			i = com.rxbuf_pos + com.rxbuf_len;
			if(i >= com.rxbuf_size) i -= com.rxbuf_size;
			com.rxbuf[i] = v;
			com.rxbuf_len++;
		} else {
			/* hCo\̂̎Mobt@I[o[t[B */
			com.rxbuf_overflow = 1;
		}
		/* 1oCgM܂͎MG[AMʒmR[obNĂяo܂B */
		if(com.recv_callback) com.recv_callback();
	}
	/* ̌ÃLN^Mꍇ́AĂъ荞ݗvZbgāA荞݃[`Iɂ܂荞݂܂B */

	/* Mobt@GveB? */
	if(bSIF1_STATUS_TDBE1) {
		/* hCo\̂̑Mobt@Ƀf[^? */
		if(com.txbuf_len) {
			/* 1LN^M܂B */
			v = com.txbuf[com.txbuf_pos];
			pSIF1_TXD = v;
			com.txbuf_pos++;
			if(com.txbuf_pos == com.txbuf_size) com.txbuf_pos = 0;
			com.txbuf_len--;
		} else {
			/* VAI/F̑Mobt@ƃhCȏMobt@ǂɂȂAMR[obNĂяo܂B
			 * 2004/05/31݂̎ł́AKM^C~Oł̂݃R[obN킯ł͂܂B
			 *   VAI/FƃhCȏMobt@ǂłCӂ̃^C~OŁAR[obN\܂B
			 *   ܂g݂͂Ȃm܂EEE
			 */
			if(com.send_callback) com.send_callback();
		}
	}
	/* ̌AMobt@ɂȂꍇ́AĂъ荞ݗvZbgāA荞݃[`Iɂ܂荞݂܂B */
}

int
com_recv(void* _buf, int maxlen)
{
	char* buf = (char*)_buf;
	int len = -1;
	int i;

	/* COM|[gJĂȂ΃G[B */
	if(!com.open) DIE();

ENTER_CS;
	if(!com.rxbuf_overflow && /* hCo\̂̎Mobt@I[o[t[ */
	   !bSIF1_STATUS_OER1  && /* Serial I/F Ch.1 overrun error flag */
	   !bSIF1_STATUS_PER1  && /* Serial I/F Ch.1 parity error flag */
	   !bSIF1_STATUS_FER1) {  /* Serial I/F Ch.1 flaming error flag */

		/* Mf[^TCYAw肳ꂽobt@TCYȉɐ؂l߂܂B */
		len = com.rxbuf_len;
		if(len > maxlen) len = maxlen;

		/* hCo\̂̎Mobt@Aw肳ꂽobt@ɃRs[܂B */
		for(i = 0; i < len; i++) {
			*buf++ = com.rxbuf[com.rxbuf_pos];
			com.rxbuf_pos++;
			if(com.rxbuf_pos == com.rxbuf_size) com.rxbuf_pos = 0;
		}
		com.rxbuf_len -= len;
	}
LEAVE_CS;

	return len;
}

#if 0
//Mobt@ςȂAubNɗvMTCYŏIo[WłB
//AvP[VőMobt@󂫑҂̐헪Ă̂ŁA_łAʓ|łB
//Mobt@󂭂܂ŃubNo[WɒûŁA͂g܂B
//int
//com_send(const void* _buf, int len)
//{
//	const char* buf = (const char*)_buf;
//	int maxlen;
//	int i;
//	int j;
//
//	/* COM|[gJĂȂ΃G[B */
//	if(!com.open) DIE();
//
//	/* Mf[^TCYɕlw肳ĂAAsciiZƌȂ܂B */
//	if(len < 0) len = strlen(buf);
//
//ENTER_CS;
//	/* Mf[^TCYAhCo\̂̑Mobt@̋󂫃TCYȉɐ؂l߂܂B */
//	maxlen = com.txbuf_size - com.txbuf_len;
//	if(len > maxlen) len = maxlen;
//
//	/* ŏ̏݃CfNX߂܂B */
//	i = com.txbuf_pos + com.txbuf_len;
//	if(i >= com.txbuf_size) i -= com.txbuf_size;
//
//	/* Mf[^AhCo\̂̑Mobt@ɒǉ܂B */
//	for(j = 0; j < len; j++) {
//		com.txbuf[i] = *buf++;
//		i++;
//		if(i == com.txbuf_size) i = 0;
//	}
//	com.txbuf_len += len;
//
//	/* M삪~ĂꍇAŏ̃LN^̑MJn邽߂ɁAځA荞݃T[rX[`Ăяo܂B
//	 * ɑM쒆ŁAMobt@GveBłȂ΁A荞݃T[rX[`͉ɏԂ̂ŁASłB
//	 */
//	_com_isr();
//LEAVE_CS;
//
//	return len;
//}
#else
int
com_send(const void* _buf, int len)
{
	const char* buf = (const char*)_buf;
	int i;
	int n;

	/* COM|[gJĂȂ΃G[B */
	if(!com.open) DIE();

	/* Mf[^TCYɕlw肳ĂAAsciiZƌȂ܂B */
	if(len < 0) len = strlen(buf);

	/* SĂ̑Mf[^hCo\̂̑Mobt@Ɋi[ł܂... */
	n = len;
	while(n) {
		/* ̃^C~OŁAMobt@GveB荞݂Ȃ̃foCX̊荞݂t\łB */
ENTER_CS;
		/* hCo\̂̑Mobt@ɋ󂫂΁Ai[܂B */
		if(com.txbuf_len < com.txbuf_size) {
			i = com.txbuf_pos + com.txbuf_len;
			if(i >= com.txbuf_size) i -= com.txbuf_size;
			com.txbuf[i] = *buf++;
			com.txbuf_len++;
			n--;
		}

		/* ȉ̓̗RɂAIɊ荞݃T[rX[`Ăяo܂B
		 *
		 * PD	M삪~ĂꍇAŏ̃LN^̑MJn邽߂ɁAځA荞݃T[rX[`Ăяo܂B
		 *	ɑM쒆ŁAMobt@GveBłȂ΁A荞݃T[rX[`͉ɏԂ̂ŁASłB
		 *
		 *	PD̗RȂ΁Áuif(com.txbuf_len < com.txbuf_size) {...}vubNsꂽꍇɂ_com_isr()
		 *	ĂԂق̂łAɏqׂQD̗RɂA_com_isr()ĂԂƂɂ܂B
		 *
		 * QD	hCo\̂̑Mobt@ɋ󂫂Acom_send()荞݋֎~ŌĂ΂ꂽꍇA荞݂ȂĂ
		 *	ŖIɊ荞݃T[rX[`ĂяoƂɂAobt@GveBăobt@ɋ󂫂ł܂B
		 *
		 *	_com_isr()Ăł̂ŁAMobt@󂫑҂ubNɃVAʐM荞݂͔ȂĂ\܂B
		 *	AubNɃVAʐM荞݈ȊO̊荞݂ԋ֎~Ă܂Ƃ邽߂ɁA
		 *	ENTER_CSLEAVE_CSsāAVAʐM荞݈ȊO̊荞݂󂯕t@݂邱Ƃɂ܂B
		 */
		_com_isr();
LEAVE_CS;
		/* ̃^C~OŁAMobt@GveB荞݂Ȃ̃foCX̊荞݂t\łB */
	}

	return len;
}
#endif

void
com_reset()
{
	/* COM|[gJĂȂ΃G[B */
	if(!com.open) DIE();

ENTER_CS;
	/* hCo\̂Zbg܂B */
	com.rxbuf_overflow = 0;
	com.rxbuf_pos = 0;
	com.rxbuf_len = 0;
	com.txbuf_pos = 0;
	com.txbuf_len = 0;

	/* G[vZbg܂B */
	bSIF1_STATUS_OER1 = 0;	/* Serial I/F Ch.1 overrun error flag */
	bSIF1_STATUS_PER1 = 0;	/* Serial I/F Ch.1 parity error flag */
	bSIF1_STATUS_FER1 = 0;	/* Serial I/F Ch.1 flaming error flag */
LEAVE_CS;
}

void
com_rts(int value)
{
	/* COM|[gJĂȂ΃G[B */
	if(!com.open) DIE();

	/* RS-232CMł́ARTS={0:-12V,1:+12V}łB(TxDRxDƂ͋tł) */
	value = !value;

	/* #RTS[q̏o͂ݒ肵܂B
	 * Read/Modify/Write̓ɂȂ̂ŁA荞݋֎~Kvł!!
	 */
ENTER_CS;
	bP1_P1D_P12D = value;
LEAVE_CS;
}

int
com_cts()
{
	int value;

	/* COM|[gJĂȂ΃G[B */
	if(!com.open) DIE();

	/* #CTS[q̓͂擾܂B
	 * ǂݍ݂Ȃ̂ŁA荞݋֎~͕svłB
	 */
	value = bP1_P1D_P14D;

	/* RS-232CMł́ACTS={0:-12V,1:+12V}łB(TxDRxDƂ͋tł) */
	value = !value;

	return value;
}
