/*	
 *	clipcode.h
 *
 *	R[h
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2009 Naoyuki Sawa
 *
 *	* Mon Feb 19 00:05:57 JST 2007 Naoyuki Sawa
 *	- 1st [XB
 *	* Sun Nov 16 12:58:50 JST 2008 Naoyuki Sawa
 *	- url_encode()Aurl_decode()ǉ܂B
 *	* Tue Jan 06 14:21:36 JST 2009 Naoyuki Sawa
 *	- md5_digest()ǉ܂B
 *	* Wed Jan 07 16:23:27 JST 2009 Naoyuki Sawa
 *	- sha1_digest()ǉ܂B
 *	* Thu Jan 15 16:13:35 JST 2009 Naoyuki Sawa
 *	- rc4_init()Arc4_encrypt_decrypt()ǉ܂B
 */
#ifndef __CLIP_CODE_H__
#define __CLIP_CODE_H__

/****************************************************************************
 *	Base64
 ****************************************************************************/

/* oCiBase64GR[hAɕϊ܂B
 * [in]
 *	dst		B(o)
 *	dst_cap		dst[]̋eʁB
 *	src		oCiB()
 *	src_len		src[]̗vfB
 * [out]
 *	߂l		̒B
 *			I[nuĺA̒Ɋ܂߂܂B
 * [note]
 *	* o͕nulI[܂B
 *	  A߂lnul܂܂ȂƂɒӂĂB
 *	  <>
 *		[in]
 *			dst[]		unsigned char dst[100]
 *			dst_len		100
 *			src[]		{ 0x12,0x34 }
 *			src_len		2
 *		[out]
 *			dst[]		"EjQ=" // { 'E','j','Q','=','\0' }
 *			߂l		4
 *		[note]
 *			߂l͕4łAo͂nulI[܂߂5oCgłB
 *			Adst_len5Ȃ΁AAT[g܂B
 *	* ߂ĺAstrlen(dst)Ɉv̂ŁAƂŎZo邱Ƃł܂B
 *	  ̒ɕKvȂ΁A߂l󂯎ȂĂ\܂B
 */
int base64_encode(char* dst, int dst_cap, const void* src, int src_len);

/* Base64fR[hAoCiɕϊ܂B
 * [in]
 *	dst		oCiB(o)
 *	dst_cap		dst[]̋eʁB
 *	src		B()
 * [out]
 *	߂l		oCi̒B
 * [note]
 *	* o̓oCinulI[܂B
 *	  o̓oCiꎩgALӂȒlu0v܂މ\邩łB
 *	  <>
 *		[in]
 *			dst[]		unsigned char dst[100]
 *			dst_len		100
 *			src[]		"EjQ=" // { 'E','j','Q','=','\0' }
 *		[out]
 *			dst[]		{ 0x12,0x34 }
 *			߂l		2
 *		[note]
 *			Adst_len2Ȃ΁AAT[g܂B
 *	* o̓oCi̒AƂŎZo邱Ƃ͂ł܂B
 *	  base64_encode()̏ꍇƈāAKA߂l󂯎ĂB
 */
int base64_decode(void* _dst, int dst_cap, const char* src);

/****************************************************************************
 *	URLGR[h
 ****************************************************************************/

/* Cӂ̕AURLGR[hꂽɕϊ܂B
 * [in]
 *	dst		o̓obt@B
 *	dst_size	o̓obt@̃oCgB
 *	src		Cӂ̕B
 * [out]
 *	߂l		o͂B
 *			['\0'͊܂߂܂B
 */
int url_encode(char* dst, int dst_size, const char* src);

/* URLGR[hꂽA̕ɕϊ܂B
 * [in]
 *	dst		o̓obt@B
 *	dst_size	o̓obt@̃oCgB
 *	src		URLGR[hꂽB
 * [out]
 *	߂l		o͂B
 *			['\0'͊܂߂܂B
 */
int url_decode(char* dst, int dst_size, const char* src);

/****************************************************************************
 *	MD5
 ****************************************************************************/

/* oCif[^́AMD5_CWFXg߂܂B
 * [in]
 *	digest		MD5_CWFXgi[obe@B(o)
 *	data		oCif[^B()
 *	len		oCif[^̃oCgB(>=0)
 * [out]
 *	digest		MD5_CWFXgi[܂B
 * [note]
 *	* ȉ̎Qlɂ܂B
 *	  uMD5 bZ[W_CWFXgASYv(The MD5 Message-Digest Algorithm)
 *	   (URL: http://www.ipa.go.jp/security/rfc/RFC1321JA.html)
 *	- {֐́AL̃TvvOȗāÂłB
 *	  ȗ_́Aȉ̓_łB
 *	  Es̃oCgI[_[AgGfBAł̂ƌߑł܂B
 *	  Ef[^Xg[ɑ΂ČJԂĂяôłȂA
 *	    ̃f[^ubNɑ΂Ĉ̌Ăяoŋ߂prɌ肵܂B
 */
void md5_digest(unsigned char digest[/*16*/], const void* data, int len);

/****************************************************************************
 *	SHA-1
 ****************************************************************************/

/* oCif[^́ASHA-1_CWFXg߂܂B
 * [in]
 *	digest		SHA-1_CWFXgi[obe@B(o)
 *	data		oCif[^B()
 *	len		oCif[^̃oCgB(>=0)
 * [out]
 *	digest		SHA-1_CWFXgi[܂B
 * [note]
 *	* ȉ̎Qlɂ܂B
 *	  uSHA-1v(US Secure Hash Algorithm 1 (SHA1))
 *	   (URL: http://www.ipa.go.jp/security/rfc/RFC3174JA.html)
 *	- {֐́AĹu6.2 @ 2vɏ]āÂłB
 *	  {֐̎́Aȉ̏ŊȗsȂ܂B
 *	  Es̃oCgI[_[AgGfBAł̂ƌߑł܂B
 *	  Ef[^Xg[ɑ΂ČJԂĂяôłȂA
 *	    ̃f[^ubNɑ΂Ĉ̌Ăяoŋ߂prɌ肵܂B
 */
void sha1_digest(unsigned char digest[/*20*/], const void* data, int len);

/****************************************************************************
 *	RC4
 ****************************************************************************/

typedef struct _RC4 {
	unsigned char s[256];
	unsigned char i;
	unsigned char j;
} RC4;

/* RC4Xg[ZbgAbv܂B
 * [in]
 *	rc4		RC4\̂ւ̃|C^B
 *	_key		RC4B
 *	keylen		RC4̃oCgB
 */
void rc4_init(RC4* rc4, const void* _key/*[keylen]*/, int keylen);

/* f[^ÍA܂́A܂B
 * [in]
 *	rc4		ς݂RC4\̂ւ̃|C^B
 *	_dst		ÍA܂́Af[^i[obt@B
 *	_src		ÍA܂́Af[^B
 *	len		f[^̃oCgB
 * [note]
 *	* _dst_srcɓAhXw肵Ă\܂B
 *	  ̏ꍇ́Ãf[^㏑āAÍA܂́Af[^i[܂B
 */
void rc4_encrypt_decrypt(RC4* rc4, void* _dst/*[len]*/, const void* _src/*[len]*/, int len);
#define rc4_encrypt rc4_encrypt_decrypt
#define rc4_decrypt rc4_encrypt_decrypt

#endif /*__CLIP_CODE_H__*/
