/*	
 *	clipc62.c
 *
 *	P/ECE HuC6280 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon Feb 23 04:28:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"
#include "clipc62i.h"	/*HuC6280G~[^p}N*/

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	IyR[h}bv
 */
const HUC6280OP huc6280_op_table[256/*opcode*/] = {
#include "huc6280/table.h" /* [huc6280.xls]Table */
};

/*
 *	j[jbNe[u
 */
#undef HUC6280FN_
#define HUC6280FN_(OP, FN)	OP "\0"
const char huc6280_op_name_table[] = {
	"\0" /* ItZbg0̓k */
#include "huc6280/list.h" /* [huc6280.xls]List */
};
#undef HUC6280FN_

/****************************************************************************
 *	֐
 ****************************************************************************/

void
huc6280_internal_mprset(HUC6280* huc6280, int addr/*0`7*/, unsigned char data)
{
	/** no job **/
}

void
huc6280_internal_vdcout(HUC6280* huc6280, int addr/*0`2*/, unsigned char data)
{
	/** no job **/
}

void
huc6280_mpr_set(HUC6280* huc6280, int addr/*0`7*/, unsigned char data)
{
	ASSERT(addr >= 0 && addr <= 7);

	/* Zbg͂߂Ă̐ݒ肩A܂͒lωAO֐Ăт܂B */
	if(!(MPR_EN & (1 << addr)) || (MPR[addr] != data)) {
		MPR_EN |= 1 << addr;	/* ݒς݃}[N */
		MPR[addr] = data;	/* ݒli[     */
		huc6280->mprset(huc6280, addr, data);
	}
}

void
huc6280_check_pending(HUC6280* huc6280)
{
	if(P & 4) return;	/* I=1:֎~ */
	if(PENDING & HUC6280_IRQ1_PENDING) {
		PENDING &= ~HUC6280_IRQ1_PENDING;
		huc6280_int(huc6280, HUC6280_IRQ1_VECTOR, 0);
		return;
	}
	if(PENDING & HUC6280_IRQ2_PENDING) {
		PENDING &= ~HUC6280_IRQ2_PENDING;
		huc6280_int(huc6280, HUC6280_IRQ2_VECTOR, 0);
		return;
	}
}

void
huc6280_int(HUC6280* huc6280, int vector, int brk)
{
	/* PPUSHOP(B)ωdlłB
	 * P(B)NMIIRQɂė\łȂ^C~Oŕω܂B
	 * IRQ2 isrIRQ2/BRK𔻕ʂɂ́AX^bNP(B)𒲂ׂKv܂B
	 */
	if(brk) {
		P |=  0x10;	/* B=1 */
	} else {
		P &= ~0x10;	/* B=0 */
	}
	PUSHW(PC);
	PUSH(P);
	P &= ~8;		/* D=0 */
	P |=  4;		/* I=1 */
	PC = READW(vector);
	HALT = 0;
}

void
huc6280_rti(HUC6280* huc6280)
{
	PULL(P);
	PULLW(PC);
	huc6280_check_pending(huc6280); /* Kv */
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
huc6280_reset(HUC6280* huc6280, HUC6280READPROC* read, HUC6280WRITEPROC* write, HUC6280MPRSETPROC* mprset, HUC6280VDCOUTPROC* vdcout)
{
	memset(huc6280, 0, sizeof(HUC6280));

	/* O֐i[܂B */
	huc6280->read   = read   ? read   : huc6280_internal_read;
	huc6280->write  = write  ? write  : huc6280_internal_write;
	huc6280->mprset = mprset ? mprset : huc6280_internal_mprset;
	huc6280->vdcout = vdcout ? vdcout : huc6280_internal_vdcout;

	/* Zbg MPR7=$00 ̂ݕۏ؂܂BMPR0`6͖ݒłB */
	huc6280_mpr_set(huc6280, 7, 0);

	/* Zbg̃WX^lɂāA
	 * [TurboGrafx-16 Hardware Notes] by Charles MacDonald (WWW: http://cgfm2.emuviews.com) pB
	 * ---------------------------------------------------------------------
	 * On power-up, A, X, Y, and S hold random values.
	 * P always has T and D cleared, I and B set, and N, Z, V, C are random.
	 * ---------------------------------------------------------------------
	 * S͕slƂȂĂ܂AfobO₷悤AŏʃAhX(=0xff)ɏĂƂɂ܂B
	 */
	P = 0x14;	/* {B,I}=1 */
	S = 0xff;
	PC = READW(HUC6280_RESET_VECTOR);	/* ȑOMPR7ĂKv!!(łĂ܂) */
}

void huc6280_nmi  (HUC6280* huc6280) { huc6280_int(huc6280, HUC6280_NMI_VECTOR,   0); }
void huc6280_timer(HUC6280* huc6280) { huc6280_int(huc6280, HUC6280_TIMER_VECTOR, 0); }

void huc6280_irq1 (HUC6280* huc6280) { PENDING |= HUC6280_IRQ1_PENDING; huc6280_check_pending(huc6280); }
void huc6280_irq2 (HUC6280* huc6280) { PENDING |= HUC6280_IRQ2_PENDING; huc6280_check_pending(huc6280); }

void
huc6280_dump(HUC6280* huc6280)
{
#define INDENT	40
	int i;
	TRACE("%*s", INDENT, "");
	TRACE("P:%c%c%c%c%c%c%c%c A:%02x X:%02x Y:%02x S:%02x PC:%04x MPR",
		P & (1 << 7) ? 'N' : '-',
		P & (1 << 6) ? 'V' : '-',
		P & (1 << 5) ? 'T' : '-',
		P & (1 << 4) ? 'B' : '-',
		P & (1 << 3) ? 'D' : '-',
		P & (1 << 2) ? 'I' : '-',
		P & (1 << 1) ? 'Z' : '-',
		P & (1 << 0) ? 'C' : '-',
		A, X, Y, S, PC);
	for(i = 0; i < 8; i++) {
		if(MPR_EN & (1 << i)) {
			TRACE(":%02x", MPR[i]);
		} else {
			TRACE(":--");
		}
	}
	TRACE("\n");
#undef INDENT
}

/****************************************************************************
 *
 ****************************************************************************/

#ifdef PIECE

asm("
	.code
	.global huc6280_run2
huc6280_run2:
	pushn %r0
	ld.w %r0, %sp		; X^bNޔ
	xld.w %r10, 0x1000	; 0x0e00`0x1000ɃX^bNؑ
	ld.w %sp, %r10
	xcall huc6280_run
	ld.w %sp, %r0		; X^bN
	popn %r0
	ret
");

#endif /*PIECE*/

/****************************************************************************
 *
 ****************************************************************************/

