/*	
 *	clipc16.c
 *
 *	P/ECE CP1610 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sun May 15 21:34:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/* CP1610_TRACEV{`ƁAg[Xo͂s܂B */
//#define CP1610_TRACE

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

#ifndef PIECE /*============================================================*/
CP1610 cp1610; /* P/ECȄꍇ͍RAMɔzu -> framc16a.s */
#endif /*PIECE==============================================================*/

#include "cp1610/decl.h"

#ifndef PIECE /*============================================================*/
/* Win32ł́AR0`R7ACP1610.r[]̃CfNXƂĒ`܂B */
#define R0	0
#define R1	1
#define R2	2
#define R3	3
#define R4	4
#define R5	5
#define R6	6
#define R7	7
#else /*PIECE===============================================================*/
/* P/ECEł́AR0`R7ACP1610.r[]̃ItZbgƂĒ`܂B */
#define R0	(0*2)
#define R1	(1*2)
#define R2	(2*2)
#define R3	(3*2)
#define R4	(4*2)
#define R5	(5*2)
#define R6	(6*2)
#define R7	(7*2)
#endif /*PIECE==============================================================*/
const CP1610OP cp1610op[0x400] = { /* ߃e[u */
#include "cp1610/op.h"
};
#undef R0
#undef R1
#undef R2
#undef R3
#undef R4
#undef R5
#undef R6
#undef R7

/* * Condition Code -> L(0)/(1)Ή\
 * - BBEXT̏ꕔʉ(cp1610_bcond())邽߂ɁA
 *   L肪0,1ƂȂĂ邱ƒӂĂB
 * -------------------------------------------------------
 * int main() {
 * 	int s,v,z,c,x;
 * 	for(s=0;s<=1;s++){
 * 	for(z=0;z<=1;z++){
 * 	for(v=0;v<=1;v++){
 * 	for(c=0;c<=1;c++){
 * 		int b    = 1;
 * 		int bc   = c;
 * 		int bov  = v;
 * 		int bpl  = !s;
 * 		int bze  = z;
 * 		int blt  = s^v;
 * 		int ble  = z|(s^v);
 * 		int busc = s^c;
 * 		x = (b   <<0)|
 * 		    (bc  <<1)|
 * 		    (bov <<2)|
 * 		    (bpl <<3)|
 * 		    (bze <<4)|
 * 		    (blt <<5)|
 * 		    (ble <<6)|
 * 		    (busc<<7);
 *		x = (x<<8)|(x^0xff);
 * 		printf("0x%04x,",x);
 * 	}}}}
 * }
 * -------------------------------------------------------
 */
const unsigned short cp1610_cond[16/*Condition Code*/] = {
	0x09f6,0x8b74,0x6d92,0xef10,0x59a6,0xdb24,0x7d82,0xff00,
	0xe11e,0x639c,0x857a,0x07f8,0xf10e,0x738c,0xd52a,0x57a8,
};

/****************************************************************************
 *	[Jϐ
 ****************************************************************************/

#define cpu (&cp1610)
#ifndef PIECE /*============================================================*/
static const CP1610OP* op;
#ifdef CP1610_TRACE
static const char* const cp1610mne[0x400] = { /* j[jbNe[u */
#include "cp1610/mne.h"
};
#endif /*CP1610_TRACE*/
#endif /*PIECE==============================================================*/

/****************************************************************************
 *	֐
 ****************************************************************************/

void
cp1610_err()
{
	die("cp1610_err(%04x)", cpu->r[7]);
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
cp1610_reset(int iab)
{
	ASSERT((iab >= 0) && (iab <= 0xffff));
	if(sizeof(CP1610) != SIZEOF_CP1610) DIE();

	memset(cpu, 0, sizeof cpu);
	cpu->r[7] = iab;
}

int
cp1610_get_status()
{
	int status;
	status  = (cpu->c  >> (16-4)) & (1<<4);
	status |= (cpu->ov >> (15-5)) & (1<<5);
	if(!(cpu->sz & 0x0000ffff)) status |= (1<<6);
	if(  cpu->sz & 0x80008000 ) status |= (1<<7);
	return status;
}

void
cp1610_set_status(int status)
{
	cpu->c   =                 (status & (1<<4)) << (16-4);
	cpu->ov  = (unsigned short)(status & (1<<5)) << (15-5);
	cpu->sz  =                 ~status & (1<<6);		/* D6:0̂ǂłOK */
	cpu->sz |=                 (status & (1<<7)) << (31-7);	/* "rr %rd,8"Ɠ */
}

void
cp1610_set_ebc(int ebc)
{
	ASSERT((ebc >= 0) && (ebc <= 15));

	cpu->ebc = ebc;
}

void
cp1610_irq(int iab)
{
	ASSERT((iab >= 0) && (iab <= 0xffff));

	cpu->iab = iab;
	cpu->flags |=  CP1610_IRQ;
	cpu->flags &= ~CP1610_HLT; /* Kv!! */
}

#ifndef PIECE /*============================================================*/

void
cp1610_run(int cycle)
{
	int opcode;

	/* cTCNi[܂B */
	cpu->cycle = cycle;

	/* HLTȂ΁AcsTCN0ɂāAɃ[v𔲂܂B */
	if(cpu->flags & CP1610_HLT) {
		cpu->cycle = 0; /* (cp1610.cycle=0Ŋ֐𔲂邱ƁBK{!!) */
	}

	/* csTCN0ȉɂȂ܂ŌJԂ܂B */
	while(cpu->cycle > 0) {

		/* OpCodetFb`܂B */
		opcode = cp1610_read(cpu->r[7]++) & 0x3ff;
#ifdef CP1610_TRACE
		{
			int status = cp1610_get_status();
			printf("%c%c%c%c%c%c 0:%04X 1:%04X 2:%04X 3:%04X 4:%04X 5:%04X 6:%04X 7:%04X %s\n",
				status&(1<<7)?'S':'-',status&(1<<6)?'Z':'-',status&(1<<5)?'V':'-',status&(1<<4)?'C':'-',
				cpu->flags&CP1610_IFF?'I':'-',cpu->flags&CP1610_DBD?'D':'-',
				cpu->r[0],cpu->r[1],cpu->r[2],cpu->r[3],cpu->r[4],cpu->r[5],cpu->r[6],cpu->r[7]-1,
				cp1610mne[opcode]);
		}
#endif /*CP1610_TRACE*/

		/* OpCodeɑΉA߃e[ũGg擾܂B */
		op = &cp1610op[opcode];

#ifdef DEBUG
		/* SDBDCs߂SDBDCĂȂA܂B */
		if(cpu->flags & CP1610_DBD) {
			if(!(op->ni & 2)) {
				DIE();
			}
		}
#endif /*DEBUG*/

		/* csTCN炵܂B(ߎsOɌ炷!!) */
		cpu->cycle -= op->cycle;

		/* ߂֐Ăт܂B */
		op->fn();

		/* 荞ݗv󂯕t܂B
		 * - CP1610́A荞ݎ󂯕tɎŊ荞݋֎~sȂ݂łB(vmF)
		 *   CP1610f[^V[g̓t[`[gɂ́A݋֎~̋LqL܂B
		 *   ۂɁAEXEC ROM̊荞݃[`Aɂ́AIȊ荞݋炸A
		 *   荞ݎ󂯕tɎŊ荞݋֎~ɂĂ܂ƁA삵Ȃ݂łB
		 */
		if(cpu->flags & CP1610_IRQ) {		/* 荞ݗv? */
			if(cpu->flags & CP1610_IFF) {	/* 荞݋? */
				if(!(op->ni & 1)) {	/* 荞݉\? */
					cpu->flags &= ~CP1610_IRQ;	/* 荞ݗvNA */
					cpu->cycle -= 9;		/* TCNAvmF */
					cp1610_write(cpu->r[6]++, cpu->r[7]);
					cpu->r[7] = cpu->iab;
				}
			}
		}
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

static int
cp1610_data()
{
	int data;
	if(cpu->flags & CP1610_DBD) {
		cpu->flags &= ~CP1610_DBD;	/* YȂ!! */
		cpu->cycle -= 2;		/* ǉTCNAvmF */
		switch(op->src) {
		case 0:
			/* Direct Address Mode SDBDCsB */
			DIE();
		case 1:
		case 2:
		case 3:
			data  = (unsigned char)cp1610_read(cpu->r[op->src]);
			data |= (unsigned char)cp1610_read(cpu->r[op->src]) << 8;
			break;
		case 4:
		case 5:
		case 7:
			data  = (unsigned char)cp1610_read(cpu->r[op->src]++);
			data |= (unsigned char)cp1610_read(cpu->r[op->src]++) << 8;
			break;
		case 6:
			data  = (unsigned char)cp1610_read(--cpu->r[op->src]);
			data |= (unsigned char)cp1610_read(--cpu->r[op->src]) << 8;
			break;
		default:
			DIE();
		}
	} else {
		switch(op->src) {
		case 0:
			data = cp1610_read(cp1610_read(cpu->r[7]++));
			break;
		case 1:
		case 2:
		case 3:
			data = cp1610_read(cpu->r[op->src]);
			break;
		case 4:
		case 5:
		case 7:
			data = cp1610_read(cpu->r[op->src]++);
			break;
		case 6:
			data = cp1610_read(--cpu->r[op->src]);
			break;
		default:
			DIE();
		}
	}
	return data;
}

static int
cp1610_add(int a, int b)
{
	int t = a + b;
	cpu->c  = t;
	cpu->ov = ~(a ^ b) & (a ^ t);
	cpu->sz = (unsigned short)t;
	return cpu->sz;
}

static int
cp1610_sub(int a, int b)
{
	int t = a - b;
	cpu->c  = ~t;
	cpu->ov = (a ^ b) & (a ^ t);
	cpu->sz = (unsigned short)t;
	return cpu->sz;
}

static void
cp1610_bcond(int a)
{
	if(a == 0) {
		int rel = cp1610_read(cpu->r[7]++);
		cpu->r[7] += (rel ^ (char)op->dst); /* O=PC+relA=PC+(rel^$FFFF) */
		cpu->cycle -= 2;
	} else {
		cpu->r[7]++;
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

/* * EVtgE[e[gAySWAP(1)̃TCtOɂ
 * - CP1610́AEVtgE[e[gAySWAP(1)߂̏ꍇ̂݁A
 *   Zʂbit15ł͂Ȃbit7TCtOɔfAƂႪ܂B
 *   CP1610̔ėpWX^16bitłAZ8bitȂ̂Ǝv܂B
 *   EVtgE[e[gAySWAP(1)ȊO̖߂́A8bitA8bit̏
 *   邽߁A8bit̍ŏʃrbg(bit15)TCtOɔf܂A
 *   EVtgE[e[gAySWAP(1)́A8bitA8bit̏ɏ邽߁A
 *   8bit̍ŏʃrbg(bit7)TCtOɔf̂Ǝv܂B
 */

void
cp1610_HLT()
{
	cpu->flags |= CP1610_HLT;
	cpu->cycle = 0;
}

void
cp1610_SDBD()
{
	cpu->flags |= CP1610_DBD;
}

void
cp1610_EIS()
{
	cpu->flags |= CP1610_IFF;
}

void
cp1610_DIS()
{
	cpu->flags &= ~CP1610_IFF;
}

void
cp1610_JSR()
{
	int hi = cp1610_read(cpu->r[7]++) & 0x3ff;	/* bbppppppii */
	int lo = cp1610_read(cpu->r[7]++) & 0x3ff;	/* pppppppppp */
	int ii =  hi &  3;				/* ii = 0..3 */
	int bb = (hi >> 8) + 4;				/* bb = 4..7 */
	int pp = (hi & ~3) << 8 | lo;			/* pp = $0000..$FFFF */

	switch(ii) {
	case 1:
		cpu->flags |=  CP1610_IFF;
		break;
	case 2:
		cpu->flags &= ~CP1610_IFF;
		break;
	}
	cpu->r[bb] = cpu->r[7];
	cpu->r[7] = pp;
}

void
cp1610_TCI()
{
	/* foCXCPUɑ΂A#INTRMɂĊ荞݂vĂꍇɁA
	 * CPUfoCXɑ΂ATCIMɂċۂA#INTRMNAA
	 * Ƃdlł傤? (vmF)
	 */
	cpu->flags &= ~CP1610_IRQ;
}

void
cp1610_CLRC()
{
	cpu->c &= ~(1<<16);
}

void
cp1610_SETC()
{
	cpu->c |= (1<<16);
}

void
cp1610_INCR()
{
	cpu->r[op->dst]++;
	cpu->sz = cpu->r[op->dst];
}

void
cp1610_DECR()
{
	cpu->r[op->dst]--;
	cpu->sz = cpu->r[op->dst];
}

void
cp1610_COMR()
{
	cpu->r[op->dst] = ~cpu->r[op->dst];
	cpu->sz = cpu->r[op->dst];
}

void
cp1610_NEGR()
{
	cpu->r[op->dst] = cp1610_sub(0, cpu->r[op->dst]);
}

void
cp1610_ADCR()
{
	int c = (cpu->c >> (16-0)) & 1;
	cpu->r[op->dst] = cp1610_add(cpu->r[op->dst], c);
}

void
cp1610_GSWD()
{
	cpu->r[op->dst] = cp1610_get_status();   /* 00000000 SZVC0000 */
	cpu->r[op->dst] |= cpu->r[op->dst] << 8; /* SZVC0000 SZVC0000 */
}

void
cp1610_NOP()
{
	/** no job **/
}

void
cp1610_SIN()
{
	/* CPUfoCXɑ΂A#PCITMɂă\tgEFA荞݂̋NʒmA
	 * ̂Ƃ͒ʏ̃foCX荞݂ƓlɁAO犄荞݃xN^擾A
	 * Ƃdl݂łB()
	 */
	DIE();
}

void
cp1610_RSWD()
{
	cp1610_set_status(cpu->r[op->src]);
}

void
cp1610_SWAP()
{
	cpu->sz = cpu->r[op->dst]; /* SwapOɔfBł!! */
	cpu->r[op->dst] = cpu->r[op->dst] << 8 | cpu->r[op->dst] >> 8;
}

void
cp1610_SWAP2()
{
	cpu->r[op->dst] = cpu->r[op->dst] << 8 | (unsigned char)(cpu->r[op->dst]);
	cpu->sz = cpu->r[op->dst]; /* SwapɔfBʂǂ */
}

void
cp1610_SLL()
{
	cpu->r[op->dst] <<= 1;
	cpu->sz = cpu->r[op->dst];
}

void
cp1610_SLL2()
{
	cpu->r[op->dst] <<= 2;
	cpu->sz = cpu->r[op->dst];
}

void
cp1610_RLC()
{
	int c = (cpu->c >> (16-0)) & 1;		/*   -------- -------C */
	int t = cpu->r[op->dst];		/*   fedcba98 76543210 */
	t <<= 1;				/* f edcba987 6543210- */
	cpu->c = t;				/* +->STATUS(C)        */
	t |= c;					/* f edcba987 6543210C */
	cpu->r[op->dst] = t;
	cpu->sz = cpu->r[op->dst];
}

void
cp1610_RLC2()
{
	int c  = (cpu->c  >> (16-0)) & 1;	/*    -------- -------C */
	int ov = (cpu->ov >> (15-0)) & 1;	/*    -------- -------V */
	int t = cpu->r[op->dst];		/*    fedcba98 76543210 */
	t <<= 1;				/*  f edcba987 6543210- */
	cpu->ov = t;				/*  | +->STATUS(OV)     */
	cpu->c  = t;				/*  +--->STATUS(C)      */
	t |= c;					/*  f edcba987 6543210C */
	t <<= 1;				/* fe dcba9876 543210C- */
	t |= ov;				/* fe dcba9876 543210CV */
	cpu->r[op->dst] = t;
	cpu->sz = cpu->r[op->dst];
}

void
cp1610_SLLC()
{
	int t = cpu->r[op->dst];		/*   fedcba98 76543210 */
	t <<= 1;				/* f edcba987 6543210- */
	cpu->c = t;				/* +->STATUS(C)        */
	cpu->r[op->dst] = t;
	cpu->sz = cpu->r[op->dst];
}

void
cp1610_SLLC2()
{
	int t = cpu->r[op->dst];		/*    fedcba98 76543210 */
	t <<= 1;				/*  f edcba987 6543210- */
	cpu->ov = t;				/*  | +->STATUS(OV)     */
	cpu->c  = t;				/*  +--->STATUS(C)      */
	t <<= 1;				/* fe dcba9876 543210-- */
	cpu->r[op->dst] = t;
	cpu->sz = cpu->r[op->dst];
}

void
cp1610_SLR()
{
	cpu->r[op->dst] >>= 1;
	cpu->sz = (unsigned short)(cpu->r[op->dst] << 8 | cpu->r[op->dst] >> 8); /* EVtgE[e[g!! */
}

void
cp1610_SLR2()
{
	cpu->r[op->dst] >>= 2;
	cpu->sz = (unsigned short)(cpu->r[op->dst] << 8 | cpu->r[op->dst] >> 8); /* EVtgE[e[g!! */
}

void
cp1610_SAR()
{
	cpu->r[op->dst] = (short)cpu->r[op->dst] >> 1;
	cpu->sz = (unsigned short)(cpu->r[op->dst] << 8 | cpu->r[op->dst] >> 8); /* EVtgE[e[g!! */
}

void
cp1610_SAR2()
{
	cpu->r[op->dst] = (short)cpu->r[op->dst] >> 2;
	cpu->sz = (unsigned short)(cpu->r[op->dst] << 8 | cpu->r[op->dst] >> 8); /* EVtgE[e[g!! */
}

void
cp1610_RRC()
{
	int c = (cpu->c >> (16-15)) & (1<<15);	/*   C------- -------- */
	int t = cpu->r[op->dst];		/* - fedcba98 76543210 */
	cpu->c = t << (16-0);			/*        STATUS(C)<-+ */
	t >>= 1;				/*   -fedcba9 87654321 */
	t |= c;					/*   Cfedcba9 87654321 */
	cpu->r[op->dst] = t;
	cpu->sz = (unsigned short)(cpu->r[op->dst] << 8 | cpu->r[op->dst] >> 8); /* EVtgE[e[g!! */
}

void
cp1610_RRC2()
{
	int c  = (cpu->c  >> (16-15)) & (1<<15);/*    C------- -------- */
	int ov = (cpu->ov           ) & (1<<15);/*    V------- -------- */
	int t = cpu->r[op->dst];		/* -- fedcba98 76543210 */
	cpu->ov = t << (15-1);			/*       STATUS(OV)<-+| */
	cpu->c  = t << (16-0);			/*       STATUS(C)<---+ */
	t >>= 1;				/*    -fedcba9 87654321 */
	t |= c;					/*    Cfedcba9 87654321 */
	t >>= 1;				/*    -Cfedcba 98765432 */
	t |= ov;				/*    VCfedcba 98765432 */
	cpu->r[op->dst] = t;
	cpu->sz = (unsigned short)(cpu->r[op->dst] << 8 | cpu->r[op->dst] >> 8); /* EVtgE[e[g!! */
}

void
cp1610_SARC()
{
	int t = (short)cpu->r[op->dst];		/* f fedcba98 76543210 */
	cpu->c = t << (16-0);			/*        STATUS(C)<-+ */
	t >>= 1;				/*   ffedcba9 87654321 */
	cpu->r[op->dst] = t;
	cpu->sz = (unsigned short)(cpu->r[op->dst] << 8 | cpu->r[op->dst] >> 8); /* EVtgE[e[g!! */
}

void
cp1610_SARC2()
{
	int t = (short)cpu->r[op->dst];		/* ff fedcba98 76543210 */
	cpu->c  = t << (16-0);			/*         STATUS(C)<-+ */
	t >>= 1;				/*  f ffedcba9 87654321 */
	cpu->ov = t << (15-0);			/*        STATUS(OV)<-+ */
	t >>= 1;				/*    fffedcba 98765432 */
	cpu->r[op->dst] = t;
	cpu->sz = (unsigned short)(cpu->r[op->dst] << 8 | cpu->r[op->dst] >> 8); /* EVtgE[e[g!! */
}

void
cp1610_MOVR()
{
	cpu->r[op->dst] = cpu->r[op->src];
	cpu->sz = cpu->r[op->dst];
}

void
cp1610_ADDR()
{
	cpu->r[op->dst] = cp1610_add(cpu->r[op->dst], cpu->r[op->src]);
}

void
cp1610_SUBR()
{
	cpu->r[op->dst] = cp1610_sub(cpu->r[op->dst], cpu->r[op->src]);
}

void
cp1610_CMPR()
{
	cp1610_sub(cpu->r[op->dst], cpu->r[op->src]);
}

void
cp1610_ANDR()
{
	cpu->r[op->dst] &= cpu->r[op->src];
	cpu->sz = cpu->r[op->dst];
}

void
cp1610_XORR()
{
	cpu->r[op->dst] ^= cpu->r[op->src];
	cpu->sz = cpu->r[op->dst];
}

void
cp1610_B()
{
	int status = cp1610_get_status();
	cp1610_bcond((cp1610_cond[status >> 4] >> op->src) & 1);
}

void
cp1610_BEXT()
{
	cp1610_bcond(cpu->ebc - op->src);
}

void
cp1610_MVO()
{
	/* SDBDC\Ȃ̂Read̂݁BWriteSDBDCsB */
	int addr;
	if(op->dst == 0) { /* R0 */
		addr = cp1610_read(cpu->r[7]++);
	} else {
		addr = cpu->r[op->dst];
		if(op->dst >= 4) { /* R4,R5,R6,R7 */
			cpu->r[op->dst]++;
		}
	}
	cp1610_write(addr, cpu->r[op->src]);
	/* Xe[^X[h͕ω܂ */
}

void
cp1610_MVI()
{
	cpu->r[op->dst] = cp1610_data();
	/* Xe[^X[h͕ω܂ */
}

void
cp1610_ADD()
{
	cpu->r[op->dst] = cp1610_add(cpu->r[op->dst], cp1610_data());
}

void
cp1610_SUB()
{
	cpu->r[op->dst] = cp1610_sub(cpu->r[op->dst], cp1610_data());
}

void
cp1610_CMP()
{
	cp1610_sub(cpu->r[op->dst], cp1610_data());
}

void
cp1610_AND()
{
	cpu->r[op->dst] &= cp1610_data();
	cpu->sz = cpu->r[op->dst];
}

void
cp1610_XOR()
{
	cpu->r[op->dst] ^= cp1610_data();
	cpu->sz = cpu->r[op->dst];
}

#endif /*PIECE==============================================================*/

/****************************************************************************
 *	
 ****************************************************************************/
