/*	
 *	clipay3.c
 *
 *	P/ECE AY-3-8910 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sat Feb 07 19:08:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sun Mar 06 19:52:00 JST 2004 Naoyuki Sawa
 *	- ʃJ[u̒s܂B
 *	  ܂ŁAamplitude_level,envelope_level0`15ŁAὠjAłA
 *	  ł̓Gx[v₩܂B
 *	  ŁAꂼ2悵 0`15^2 ̒li[邱Ƃɂ܂B
 */
#include "clip.h"

/****************************************************************************
 *	֐
 ****************************************************************************/

unsigned char
ay38910_internal_in(AY38910* ay, int port)
{
	return -1;
}

void
ay38910_internal_out(AY38910* ay, int port, unsigned char data)
{
	/** no job **/
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
ay38910_reset(AY38910* ay, int clock, AY38910INPROC* in, AY38910OUTPROC* out)
{
	int i;

	memset(ay, 0, sizeof(AY38910));

	/* NbNisDDAZbgAbvB */
	ay->clock_progress.u = clock / SPEAKER_FREQUENCY; /* ̕ω */
	ay->clock_progress.n = clock % SPEAKER_FREQUENCY; /* [̑ */
	ay->clock_progress.d =        -SPEAKER_FREQUENCY; /* [ */

	/* |[go͊O֐i[B */
	ay->in  = in  ? in  : ay38910_internal_in;
	ay->out = out ? out : ay38910_internal_out;

	/* mCYLFSRB(YƃmCYȂȂ܂!) */
	ay->noise_lfsr = 1;

	/* period!=0ۏ؂邽߁ASWX^𖾎Iɏ܂B */
	for(i = 0; i < 16; i++) {
		ay38910_address(ay, i);
		ay38910_write(ay, 0);
	}
}

void
ay38910_address(AY38910* ay, int address)
{
	/* WX^AhXi[B */
	ay->address = address & 0xf;
}

unsigned
char ay38910_read(AY38910* ay)
{
	unsigned char* reg = ay->reg;
	int address = ay->address;

	switch(address) {
	case 14: /* I/O Port A Data Store */
		reg[address] = ay->in(ay, 0);
		break;
	case 15: /* I/O Port B Data Store */
		reg[address] = ay->in(ay, 1);
		break;
	}

	return reg[address];
}

void
ay38910_write(AY38910* ay, unsigned char data)
{
	unsigned char* reg = ay->reg;
	int address = ay->address;

	//if(reg[address] == data) return; /* ωȂȂA܂ */
	//reg[address] = data; /* ωȂA܂i[ */
	//CBωȂłɏ܂B
	//Reg#13ւ݂̏́Aω̗LɊւ炸Gx[vZbǧʂ邩łB
	//Reg#13ʈ@܂ASWX^𖳏ɏ邱Ƃɂ܂B
	reg[address] = data;

	switch(address) {
	case 0: /* Channel A Tone Period (Fine Tune) */
	case 1: /* Channel A Tone Period (Coarse Tune) */
		ay->channel[0].tone_period = reg[0] | (reg[1] & 0xf) << 8;
		if(!ay->channel[0].tone_period) ay->channel[0].tone_period = 1;
		ay->channel[0].tone_period <<= 4 - 1;
		break;
	case 2: /* Channel B Tone Period (Fine Tune) */
	case 3: /* Channel B Tone Period (Coarse Tune) */
		ay->channel[1].tone_period = reg[2] | (reg[3] & 0xf) << 8;
		if(!ay->channel[1].tone_period) ay->channel[1].tone_period = 1;
		ay->channel[1].tone_period <<= 4 - 1;
		break;
	case 4: /* Channel C Tone Period (Fine Tune) */
	case 5: /* Channel C Tone Period (Coarse Tune) */
		ay->channel[2].tone_period = reg[4] | (reg[5] & 0xf) << 8;
		if(!ay->channel[2].tone_period) ay->channel[2].tone_period = 1;
		ay->channel[2].tone_period <<= 4 - 1;
		break;
	case 6: /* Noise Period */
		ay->noise_period = reg[6] & 0x1f;
		if(!ay->noise_period) ay->noise_period = 1; /* "S.T.U.N.Runner.ay"΍ */
		ay->noise_period <<= 4;
		break;
	case 7: /* #Enable */
		ay->channel[0].tone_enable  = !(reg[7] & (1 << 0));
		ay->channel[0].noise_enable = !(reg[7] & (1 << 3));
		ay->channel[1].tone_enable  = !(reg[7] & (1 << 1));
		ay->channel[1].noise_enable = !(reg[7] & (1 << 4));
		ay->channel[2].tone_enable  = !(reg[7] & (1 << 2));
		ay->channel[2].noise_enable = !(reg[7] & (1 << 5));
		ay->noise_enable = ay->channel[0].noise_enable ||
				   ay->channel[1].noise_enable ||
				   ay->channel[2].noise_enable;
		break;
	case 8: /* Channel A Amplitude */
		ay->channel[0].amplitude_mode = (reg[8] >> 4) & 1;
		ay->channel[0].amplitude_level = reg[8] & 0xf;
		ay->channel[0].amplitude_level *= ay->channel[0].amplitude_level; /* ʃJ[u̒ */
		ay->envelope_enable = ay->channel[0].amplitude_mode ||
				      ay->channel[1].amplitude_mode ||
				      ay->channel[2].amplitude_mode;
		break;
	case 9: /* Channel B Amplitude */
		ay->channel[1].amplitude_mode = (reg[9] >> 4) & 1;
		ay->channel[1].amplitude_level = reg[9] & 0xf;
		ay->channel[1].amplitude_level *= ay->channel[1].amplitude_level;  /* ʃJ[u̒ */
		ay->envelope_enable = ay->channel[0].amplitude_mode ||
				      ay->channel[1].amplitude_mode ||
				      ay->channel[2].amplitude_mode;
		break;
	case 10: /* Channel C Amplitude */
		ay->channel[2].amplitude_mode = (reg[10] >> 4) & 1;
		ay->channel[2].amplitude_level = reg[10] & 0xf;
		ay->channel[2].amplitude_level *= ay->channel[2].amplitude_level;  /* ʃJ[u̒ */
		ay->envelope_enable = ay->channel[0].amplitude_mode ||
				      ay->channel[1].amplitude_mode ||
				      ay->channel[2].amplitude_mode;
		break;
	case 11: /* Envelope Period (Fine Tune) */
	case 12: /* Envelope Period (Coarse Tune) */
		ay->envelope_period = reg[11] | reg[12] << 8;
		if(!ay->envelope_period) ay->envelope_period = 1;
		ay->envelope_period <<= 4;
		break;
	case 13: /* Envelope Shape Cycle */
		ay->envelope_shape_cycle = reg[13] & 0xf;
		/*{{Gx[vZbgBYȂ!!*/
		ay->envelope_progress = 0; /* ZbgAay38910_process()envelope_progressA_[t[... */
		ay->envelope_counter = -1; /* envelope_counter0ɂȂ܂BāAenvelope_levelݒ肪s܂B   */
		/*}}Gx[vZbgBYȂ!!*/
		break;
	case 14: /* I/O Port A Data Store */
		ay->out(ay, 0, reg[14]);
		break;
	case 15: /* I/O Port B Data Store */
		ay->out(ay, 1, reg[15]);
		break;
	}
}

