
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
	.global	apu_square_duty_table
	.code
	.align	2
apu_square_duty_table:
	.byte	2
	.byte	4
	.byte	8
	.byte	12
	.global	apu_triangle_waveform_table
	.align	2
apu_triangle_waveform_table:
	.byte	1
	.byte	3
	.byte	5
	.byte	7
	.byte	9
	.byte	11
	.byte	13
	.byte	15
	.byte	15
	.byte	13
	.byte	11
	.byte	9
	.byte	7
	.byte	5
	.byte	3
	.byte	1
	.byte	-1
	.byte	-3
	.byte	-5
	.byte	-7
	.byte	-9
	.byte	-11
	.byte	-13
	.byte	-15
	.byte	-15
	.byte	-13
	.byte	-11
	.byte	-9
	.byte	-7
	.byte	-5
	.byte	-3
	.byte	-1
	.global	apu_noise_wavelength_table
	.align	2
apu_noise_wavelength_table:
	.half	4
	.half	8
	.half	16
	.half	32
	.half	64
	.half	96
	.half	128
	.half	160
	.half	202
	.half	254
	.half	380
	.half	508
	.half	762
	.half	1016
	.half	2034
	.half	4068
	.global	apu_dmc_wavelength_table
	.align	2
apu_dmc_wavelength_table:
	.half	428
	.half	380
	.half	340
	.half	320
	.half	286
	.half	254
	.half	226
	.half	214
	.half	190
	.half	160
	.half	142
	.half	128
	.half	106
	.half	84
	.half	72
	.half	54
	.global	apu_length_count_table
	.align	2
apu_length_count_table:
	.byte	5
	.byte	127
	.byte	10
	.byte	1
	.byte	20
	.byte	2
	.byte	40
	.byte	3
	.byte	80
	.byte	4
	.byte	30
	.byte	5
	.byte	7
	.byte	6
	.byte	14
	.byte	7
	.byte	6
	.byte	8
	.byte	12
	.byte	9
	.byte	24
	.byte	10
	.byte	48
	.byte	11
	.byte	96
	.byte	12
	.byte	36
	.byte	13
	.byte	8
	.byte	14
	.byte	16
	.byte	15
	.code
	.align	1
	.global	apu_reset
apu_reset:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	apu+0x0@h	; 	xld.w	%r12,apu
	ext	apu+0x0@m
	ld.w	%r12,apu+0x0@l
	ld.w	%r13,0x0
	ext	0x2		; 	xld.w	%r14,0x00000080		; 128
	ld.w	%r14,0x0
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ext	apu+0x78@ah	; 	xld.w	[apu+120],%r0
	ext	apu+0x78@al
	ld.w	[%r8],%r0
	ext	0x100		; 	xld.w	%r12,0x00004010		; 16400
	ld.w	%r12,0x10
	ld.w	%r13,0x0
	call	apu_write	; 	xcall	apu_write
	ext	0x100		; 	xld.w	%r12,0x00004011		; 16401
	ld.w	%r12,0x11
	ld.w	%r13,0x0
	call	apu_write	; 	xcall	apu_write
	ext	0x100		; 	xld.w	%r12,0x00004012		; 16402
	ld.w	%r12,0x12
	ld.w	%r13,0x0
	call	apu_write	; 	xcall	apu_write
	ext	0x100		; 	xld.w	%r12,0x00004013		; 16403
	ld.w	%r12,0x13
	ld.w	%r13,0x0
	call	apu_write	; 	xcall	apu_write
	popn	%r0
	ret
	.align	1
	.global	apu_write
apu_write:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	apu+0x0@h	; 	xld.w	%r5,apu
	ext	apu+0x0@m
	ld.w	%r5,apu+0x0@l
	ld.w	%r6,%r5
	ext	0x48		; 	xadd	%r4,%r5,72
	add	%r4,%r5
	ext	0x54		; 	xadd	%r14,%r5,84
	add	%r14,%r5
	ext	0x64		; 	xadd	%r11,%r5,100
	add	%r11,%r5
	and	%r12,0x1f	; 	xand	%r12,%r12,0x0000001f
	ld.w	%r15,%r12
	and	%r15,0x3c	; 	xand	%r15,%r15,0xfffffffc
	ld.w	%r10,%r12
	add	%r10,%r5
	ld.b	[%r10],%r13	; 	xld.b	[%r10],%r13
	cmp	%r12,0x15	; 	xcmp	%r12,21
	ext	__L72@rm	; 	xjrugt	__L72
	jrugt	__L72@rl
	ld.w	%r10,%r12
	sll	%r10,0x2	; 	xsll	%r10,2
	ext	__L112+0x0@h	; 	xld.w	%r10,[%r10+__L112]
	ext	__L112+0x0@m
	ld.w	%r9,__L112+0x0@l
	add	%r9,%r10
	ld.w	%r10,[%r9]
	jp	%r10
	.code
	.align	2
__L112:
	.word	__L74
	.word	__L79
	.word	__L87
	.word	__L83
	.word	__L74
	.word	__L79
	.word	__L87
	.word	__L83
	.word	__L72
	.word	__L72
	.word	__L93
	.word	__L88
	.word	__L94
	.word	__L72
	.word	__L101
	.word	__L98
	.word	__L104
	.word	__L107
	.word	__L108
	.word	__L109
	.word	__L72
	.word	__L110
	.code
__L74:
	ld.w	%r11,%r12
	sra	%r11,0x2	; 	xsra	%r11,2
	ld.w	%r10,0x14	; 	xld.w	%r10,0x00000014		; 20
	mlt.w	%r11,%r10
	ext	0x0		; 	xld.w	%r4,0x00000020		; 32
	ld.w	%r4,0x20
	ld.w	%r10,%alr
	add	%r10,%r4
	ld.w	%r14,%r6
	add	%r14,%r10
	ext	0x2		; 	xadd	%r11,%r14,2
	add	%r11,%r14
	ld.w	%r7,0x0
	ld.b	[%r11],%r7	; 	xld.b	[%r11],%r7
	ld.w	%r12,%r5
	add	%r12,%r15
	ld.ub	%r13,[%r12]	; 	xld.ub	%r13,[%r12]
	ld.w	%r10,%r13
	and	%r10,0x10	; 	xand	%r10,%r10,0x00000010
	jrne	__LX75		; 	xjrne	__L75
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ld.b	[%r11],%r10	; 	xld.b	[%r11],%r10
	ld.ub	%r10,[%r12]	; 	xld.ub	%r10,[%r12]
	and	%r10,%r4
	ld.ub	%r10,%r10
	cmp	%r10,0x0
	jreq	__LX76		; 	xjreq	__L76
	ld.w	%r10,0x3	; 	xld.w	%r10,0x00000003		; 3
	ld.b	[%r11],%r10	; 	xld.b	[%r11],%r10
__LX76:				; __L76:
	ld.ub	%r10,[%r12]	; 	xld.ub	%r10,[%r12]
	ext	__LX114@rm	; 	xjp	__L114
	jp	__LX114@rl
__LX75:				; __L75:
	ld.w	%r10,%r13
	ext	__LX115@rm	; 	xjp	__L115
	jp	__LX115@rl
__L79:
	ld.w	%r11,%r12
	sra	%r11,0x2	; 	xsra	%r11,2
	ld.w	%r10,0x14	; 	xld.w	%r10,0x00000014		; 20
	mlt.w	%r11,%r10
	ld.w	%r10,%alr
	add	%r10,0x20	; 	xadd	%r10,%r10,32
	ld.w	%r14,%r6
	add	%r14,%r10
	ext	0x6		; 	xadd	%r12,%r14,6
	add	%r12,%r14
	ld.w	%r7,0x0
	ld.b	[%r12],%r7	; 	xld.b	[%r12],%r7
	ld.w	%r10,%r15
	add	%r10,%r5
	ext	0x1		; 	xadd	%r11,%r10,1
	add	%r11,%r10
	btst	[%r11],0x7	; 	xbtst	[%r11],0x7
	ext	__L72@rm	; 	xjreq	__L72
	jreq	__L72@rl
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ld.b	[%r12],%r10	; 	xld.b	[%r12],%r10
	btst	[%r11],0x3	; 	xbtst	[%r11],0x3
	jreq	__LX81		; 	xjreq	__L81
	ld.w	%r10,0x3	; 	xld.w	%r10,0x00000003		; 3
	ld.b	[%r12],%r10	; 	xld.b	[%r12],%r10
__LX81:				; __L81:
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	and	%r10,0x7	; 	xand	%r10,%r10,0x00000007
	ext	0x7		; 	xld.b	[%r14+7],%r10
	ld.b	[%r14],%r10
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	srl	%r10,0x4	; 	xsrl	%r10,4
	and	%r10,0x7	; 	xand	%r10,%r10,0x00000007
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ext	0x8		; 	xld.b	[%r14+8],%r10
	ld.b	[%r14],%r10
	ext	0x9		; 	xld.b	[%r14+9],%r10
	ld.b	[%r14],%r10
	ext	__L72@rm	; 	xjp	__L72
	jp	__L72@rl
__L83:
	ld.w	%r11,%r12
	sra	%r11,0x2	; 	xsra	%r11,2
	ld.w	%r10,0x14	; 	xld.w	%r10,0x00000014		; 20
	mlt.w	%r11,%r10
	ext	0x0		; 	xld.w	%r11,0x00000020		; 32
	ld.w	%r11,0x20
	ld.w	%r10,%alr
	add	%r10,%r11
	ld.w	%r13,%r6
	add	%r13,%r10
	ld.w	%r14,%r13
	ld.w	%r7,0x0
	ld.b	[%r13],%r7	; 	xld.b	[%r13],%r7
	ld.w	%r4,%r5
	add	%r4,%r15
	ld.ub	%r10,[%r4]	; 	xld.ub	%r10,[%r4]
	and	%r10,%r11
	ld.ub	%r10,%r10
	cmp	%r10,0x0
	jrne	__LX84		; 	xjrne	__L84
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ld.b	[%r13],%r10	; 	xld.b	[%r13],%r10
	ext	0x3		; 	xld.ub	%r10,[%r4+3]
	ld.ub	%r10,[%r4]
	srl	%r10,0x3	; 	xsrl	%r10,3
	ext	apu_length_count_table+0x0@h	; 	xld.ub	%r10,[%r10+apu_length_count_table]
	ext	apu_length_count_table+0x0@m
	ld.w	%r9,apu_length_count_table+0x0@l
	add	%r9,%r10
	ld.ub	%r10,[%r9]
	jp	__LX116		; 	xjp	__L116
__LX84:				; __L84:
	ext	0x3		; 	xld.w	%r10,0x000000ff		; 255
	ld.w	%r10,0x3f
__LX116:				; __L116:
	ext	0x1		; 	xld.b	[%r13+1],%r10
	ld.b	[%r13],%r10
	ld.w	%r10,%r5
	add	%r10,%r15
	ld.ub	%r10,[%r10]	; 	xld.ub	%r10,[%r10]
	srl	%r10,0x6	; 	xsrl	%r10,6
	ext	apu_square_duty_table+0x0@h	; 	xld.ub	%r10,[%r10+apu_square_duty_table]
	ext	apu_square_duty_table+0x0@m
	ld.w	%r9,apu_square_duty_table+0x0@l
	add	%r9,%r10
	ld.ub	%r10,[%r9]
	ext	0xc		; 	xld.b	[%r14+12],%r10
	ld.b	[%r14],%r10
	ld.w	%r7,0x0
	ext	0xd		; 	xld.b	[%r14+13],%r7
	ld.b	[%r14],%r7
	ld.w	%r7,0x0
	ext	0x10		; 	xld.w	[%r14+16],%r7
	ld.w	[%r14],%r7
__L87:
	ld.w	%r11,%r12
	sra	%r11,0x2	; 	xsra	%r11,2
	ld.w	%r10,0x14	; 	xld.w	%r10,0x00000014		; 20
	mlt.w	%r11,%r10
	ld.w	%r10,%alr
	add	%r10,0x20	; 	xadd	%r10,%r10,32
	ld.w	%r14,%r6
	add	%r14,%r10
	ld.w	%r10,%r15
	add	%r10,%r5
	ext	0x2		; 	xld.ub	%r11,[%r10+2]
	ld.ub	%r11,[%r10]
	ext	0x3		; 	xld.ub	%r10,[%r10+3]
	ld.ub	%r10,[%r10]
	and	%r10,0x7	; 	xand	%r10,%r10,0x00000007
	ld.ub	%r10,%r10
	sll	%r10,0x8	; 	xsll	%r10,8
	or	%r11,%r10
	ext	0xa		; 	xld.h	[%r14+10],%r11
	ld.h	[%r14],%r11
	ext	__L72@rm	; 	xjp	__L72
	jp	__L72@rl
__L88:
	ld.w	%r13,%r4
	ld.w	%r7,0x0
	ld.b	[%r13],%r7	; 	xld.b	[%r13],%r7
	ld.w	%r11,%r5
	add	%r11,%r15
	btst	[%r11],0x7	; 	xbtst	[%r11],0x7
	jrne	__LX89		; 	xjrne	__L89
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ld.b	[%r13],%r10	; 	xld.b	[%r13],%r10
	ext	0x3		; 	xld.ub	%r10,[%r11+3]
	ld.ub	%r10,[%r11]
	srl	%r10,0x3	; 	xsrl	%r10,3
	ext	apu_length_count_table+0x0@h	; 	xld.ub	%r10,[%r10+apu_length_count_table]
	ext	apu_length_count_table+0x0@m
	ld.w	%r9,apu_length_count_table+0x0@l
	add	%r9,%r10
	ld.ub	%r10,[%r9]
	jp	__LX117		; 	xjp	__L117
__LX89:				; __L89:
	ext	0x3		; 	xld.w	%r10,0x000000ff		; 255
	ld.w	%r10,0x3f
__LX117:				; __L117:
	ext	0x1		; 	xld.b	[%r13+1],%r10
	ld.b	[%r13],%r10
	ext	0x2		; 	xadd	%r12,%r4,2
	add	%r12,%r4
	ld.w	%r7,0x0
	ld.b	[%r12],%r7	; 	xld.b	[%r12],%r7
	ld.w	%r11,%r5
	add	%r11,%r15
	btst	[%r11],0x7	; 	xbtst	[%r11],0x7
	jrne	__LX91		; 	xjrne	__L91
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ld.b	[%r12],%r10	; 	xld.b	[%r12],%r10
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	ext	0x1		; 	xand	%r10,%r10,0x0000007f
	and	%r10,0x3f
	jp	__LX118		; 	xjp	__L118
__LX91:				; __L91:
	ext	0x3		; 	xld.w	%r10,0x000000ff		; 255
	ld.w	%r10,0x3f
__LX118:				; __L118:
	ext	0x3		; 	xld.b	[%r4+3],%r10
	ld.b	[%r4],%r10
	ld.w	%r7,0x0
	ext	0x6		; 	xld.b	[%r4+6],%r7
	ld.b	[%r4],%r7
	ld.w	%r7,0x0
	ext	0x8		; 	xld.w	[%r4+8],%r7
	ld.w	[%r4],%r7
__L93:
	ld.w	%r10,%r15
	add	%r10,%r5
	ext	0x2		; 	xld.ub	%r11,[%r10+2]
	ld.ub	%r11,[%r10]
	ext	0x3		; 	xld.ub	%r10,[%r10+3]
	ld.ub	%r10,[%r10]
	and	%r10,0x7	; 	xand	%r10,%r10,0x00000007
	ld.ub	%r10,%r10
	sll	%r10,0x8	; 	xsll	%r10,8
	or	%r11,%r10
	ext	0x4		; 	xld.h	[%r4+4],%r11
	ld.h	[%r4],%r11
	ext	__L72@rm	; 	xjp	__L72
	jp	__L72@rl
__L94:
	ext	0x2		; 	xadd	%r11,%r14,2
	add	%r11,%r14
	ld.w	%r7,0x0
	ld.b	[%r11],%r7	; 	xld.b	[%r11],%r7
	ld.w	%r13,%r5
	add	%r13,%r15
	ld.ub	%r12,[%r13]	; 	xld.ub	%r12,[%r13]
	ld.w	%r10,%r12
	and	%r10,0x10	; 	xand	%r10,%r10,0x00000010
	jrne	__LX95		; 	xjrne	__L95
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ld.b	[%r11],%r10	; 	xld.b	[%r11],%r10
	btst	[%r13],0x5	; 	xbtst	[%r13],0x5
	jreq	__LX96		; 	xjreq	__L96
	ld.w	%r10,0x3	; 	xld.w	%r10,0x00000003		; 3
	ld.b	[%r11],%r10	; 	xld.b	[%r11],%r10
__LX96:				; __L96:
	ld.ub	%r10,[%r13]	; 	xld.ub	%r10,[%r13]
__LX114:				; __L114:
	and	%r10,0xf	; 	xand	%r10,%r10,0x0000000f
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ext	0x3		; 	xld.b	[%r14+3],%r10
	ld.b	[%r14],%r10
	ext	0x4		; 	xld.b	[%r14+4],%r10
	ld.b	[%r14],%r10
	ld.w	%r10,0xf	; 	xld.w	%r10,0x0000000f		; 15
	ext	0x5		; 	xld.b	[%r14+5],%r10
	ld.b	[%r14],%r10
	ext	__L72@rm	; 	xjp	__L72
	jp	__L72@rl
__LX95:				; __L95:
	ld.w	%r10,%r12
__LX115:				; __L115:
	and	%r10,0xf	; 	xand	%r10,%r10,0x0000000f
	ext	0x5		; 	xld.b	[%r14+5],%r10
	ld.b	[%r14],%r10
	ext	__L72@rm	; 	xjp	__L72
	jp	__L72@rl
__L98:
	ld.w	%r7,0x0
	ld.b	[%r14],%r7	; 	xld.b	[%r14],%r7
	ld.w	%r11,%r5
	add	%r11,%r15
	btst	[%r11],0x5	; 	xbtst	[%r11],0x5
	jrne	__LX99		; 	xjrne	__L99
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ld.b	[%r14],%r10	; 	xld.b	[%r14],%r10
	ext	0x3		; 	xld.ub	%r10,[%r11+3]
	ld.ub	%r10,[%r11]
	srl	%r10,0x3	; 	xsrl	%r10,3
	ext	apu_length_count_table+0x0@h	; 	xld.ub	%r10,[%r10+apu_length_count_table]
	ext	apu_length_count_table+0x0@m
	ld.w	%r9,apu_length_count_table+0x0@l
	add	%r9,%r10
	ld.ub	%r10,[%r9]
	jp	__LX119		; 	xjp	__L119
__LX99:				; __L99:
	ext	0x3		; 	xld.w	%r10,0x000000ff		; 255
	ld.w	%r10,0x3f
__LX119:				; __L119:
	ext	0x1		; 	xld.b	[%r14+1],%r10
	ld.b	[%r14],%r10
	ext	0x100		; 	xld.w	%r10,0x00004000		; 16384
	ld.w	%r10,0x0
	ext	0x8		; 	xld.h	[%r14+8],%r10
	ld.h	[%r14],%r10
	ld.w	%r7,0x0
	ext	0xc		; 	xld.w	[%r14+12],%r7
	ld.w	[%r14],%r7
	jp	__L72		; 	xjp	__L72
__L101:
	ld.w	%r10,%r15
	add	%r10,%r5
	ext	0x2		; 	xadd	%r12,%r10,2
	add	%r12,%r10
	ld.ub	%r10,[%r12]	; 	xld.ub	%r10,[%r12]
	ext	0x2		; 	xand	%r10,%r10,0x00000080
	and	%r10,0x0
	ld.w	%r11,0x6	; 	xld.w	%r11,0x00000006		; 6
	jrne	__LX102		; 	xjrne	__L102
	ld.w	%r11,0x1	; 	xld.w	%r11,0x00000001		; 1
__LX102:				; __L102:
	ext	0x6		; 	xld.b	[%r14+6],%r11
	ld.b	[%r14],%r11
	ld.ub	%r10,[%r12]	; 	xld.ub	%r10,[%r12]
	and	%r10,0xf	; 	xand	%r10,%r10,0x0000000f
	sll	%r10,0x1	; 	xsll	%r10,1
	ext	apu_noise_wavelength_table+0x0@h	; 	xld.uh	%r10,[%r10+apu_noise_wavelength_table]
	ext	apu_noise_wavelength_table+0x0@m
	ld.w	%r9,apu_noise_wavelength_table+0x0@l
	add	%r9,%r10
	ld.uh	%r10,[%r9]
	ext	0xa		; 	xld.h	[%r14+10],%r10
	ld.h	[%r14],%r10
	jp	__L72		; 	xjp	__L72
__L104:
	ld.w	%r12,%r5
	add	%r12,%r15
	btst	[%r12],0x7	; 	xbtst	[%r12],0x7
	jrne	__LX105		; 	xjrne	__L105
	ext	0x7c		; 	xbclr	[%r6+124],0x7
	bclr	[%r6],0x7
__LX105:				; __L105:
	ld.w	%r7,0x0
	ld.b	[%r11],%r7	; 	xld.b	[%r11],%r7
	btst	[%r12],0x6	; 	xbtst	[%r12],0x6
	jreq	__LX106		; 	xjreq	__L106
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ld.b	[%r11],%r10	; 	xld.b	[%r11],%r10
__LX106:				; __L106:
	ld.ub	%r10,[%r12]	; 	xld.ub	%r10,[%r12]
	and	%r10,0xf	; 	xand	%r10,%r10,0x0000000f
	sll	%r10,0x1	; 	xsll	%r10,1
	ext	apu_dmc_wavelength_table+0x0@h	; 	xld.uh	%r10,[%r10+apu_dmc_wavelength_table]
	ext	apu_dmc_wavelength_table+0x0@m
	ld.w	%r9,apu_dmc_wavelength_table+0x0@l
	add	%r9,%r10
	ld.uh	%r10,[%r9]
	ext	0x6		; 	xld.h	[%r11+6],%r10
	ld.h	[%r11],%r10
	jp	__L72		; 	xjp	__L72
__L107:
	ld.w	%r10,%r15
	add	%r10,%r5
	ext	0x1		; 	xld.ub	%r10,[%r10+1]
	ld.ub	%r10,[%r10]
	ext	0x1		; 	xand	%r10,%r10,0x0000007f
	and	%r10,0x3f
	ext	0x1		; 	xsub	%r10,%r10,64
	sub	%r10,0x0
	ext	0x1		; 	xld.b	[%r11+1],%r10
	ld.b	[%r11],%r10
	jp	__L72		; 	xjp	__L72
__L108:
	ld.w	%r10,%r15
	add	%r10,%r5
	ext	0x2		; 	xld.ub	%r10,[%r10+2]
	ld.ub	%r10,[%r10]
	sll	%r10,0x6	; 	xsll	%r10,6
	ext	0x1f00		; 	xoor	%r10,%r10,0xffffc000
	or	%r10,0x0
	ext	0x2		; 	xld.h	[%r11+2],%r10
	ld.h	[%r11],%r10
	jp	__L72		; 	xjp	__L72
__L109:
	ld.w	%r10,%r15
	add	%r10,%r5
	ext	0x3		; 	xld.ub	%r10,[%r10+3]
	ld.ub	%r10,[%r10]
	sll	%r10,0x4	; 	xsll	%r10,4
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ext	0x4		; 	xld.h	[%r11+4],%r10
	ld.h	[%r11],%r10
	jp	__L72		; 	xjp	__L72
__L110:
	ext	0x15		; 	xbtst	[%r5+21],0x4
	btst	[%r5],0x4
	jreq	__L72		; 	xjreq	__L72
	bset	[%r11],0x7	; 	xbset	[%r11],0x7
	ext	0x1		; 	xld.ub	%r10,[%r11+1]
	ld.ub	%r10,[%r11]
	ext	0x8		; 	xld.b	[%r11+8],%r10
	ld.b	[%r11],%r10
	ext	0x2		; 	xld.uh	%r10,[%r11+2]
	ld.uh	%r10,[%r11]
	ext	0xa		; 	xld.h	[%r11+10],%r10
	ld.h	[%r11],%r10
	ext	0x4		; 	xld.uh	%r10,[%r11+4]
	ld.uh	%r10,[%r11]
	ext	0xc		; 	xld.h	[%r11+12],%r10
	ld.h	[%r11],%r10
	ld.w	%r7,0x0
	ext	0xe		; 	xld.h	[%r11+14],%r7
	ld.h	[%r11],%r7
	ld.w	%r7,0x0
	ext	0x10		; 	xld.w	[%r11+16],%r7
	ld.w	[%r11],%r7
__L72:
	ret
	.align	1
	.global	apu_read
apu_read:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	apu+0x7c@ah	; 	xld.ub	%r10,[apu+124]
	ext	apu+0x7c@al
	ld.ub	%r10,[%r8]
	ld.w	%r11,%r10
	and	%r11,0x1f	; 	xand	%r11,%r11,0x0000001f
	ext	apu+0x15@ah	; 	xld.ub	%r12,[apu+21]
	ext	apu+0x15@al
	ld.ub	%r12,[%r8]
	and	%r12,%r11
	ld.w	%r11,%r12
	ext	0x2		; 	xand	%r10,%r10,0x000000bf
	and	%r10,0x3f
	ext	apu+0x7c@ah	; 	xld.b	[apu+124],%r10
	ext	apu+0x7c@al
	ld.b	[%r8],%r10
	ext	apu+0x21@ah	; 	xld.ub	%r10,[apu+33]
	ext	apu+0x21@al
	ld.ub	%r10,[%r8]
	cmp	%r10,0x0
	jrne	__LX121		; 	xjrne	__L121
	and	%r11,0x3e	; 	xand	%r11,%r11,0xfffffffe
__LX121:				; __L121:
	ext	apu+0x35@ah	; 	xld.ub	%r10,[apu+53]
	ext	apu+0x35@al
	ld.ub	%r10,[%r8]
	cmp	%r10,0x0
	jrne	__LX122		; 	xjrne	__L122
	and	%r11,0x3d	; 	xand	%r11,%r11,0xfffffffd
__LX122:				; __L122:
	ext	apu+0x49@ah	; 	xld.ub	%r10,[apu+73]
	ext	apu+0x49@al
	ld.ub	%r10,[%r8]
	cmp	%r10,0x0
	jrne	__LX123		; 	xjrne	__L123
	and	%r11,0x3b	; 	xand	%r11,%r11,0xfffffffb
__LX123:				; __L123:
	ext	apu+0x55@ah	; 	xld.ub	%r10,[apu+85]
	ext	apu+0x55@al
	ld.ub	%r10,[%r8]
	cmp	%r10,0x0
	jrne	__LX124		; 	xjrne	__L124
	and	%r11,0x37	; 	xand	%r11,%r11,0xfffffff7
__LX124:				; __L124:
	ext	apu+0x64@ah	; 	xbtst	[apu+100],0x7
	ext	apu+0x64@al
	btst	[%r8],0x7
	jrne	__LX125		; 	xjrne	__L125
	and	%r11,0x2f	; 	xand	%r11,%r11,0xffffffef
__LX125:				; __L125:
	ld.w	%r10,%r11
	ret
	.align	1
	.global	apu_mix
apu_mix:
;	.frame	%sp,28,$31		# vars= 8, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x2		; 	xsub	%sp,%sp,8
	ld.w	%r1,%r12
	ext	apu+0x0@h	; 	xld.w	%r3,apu
	ext	apu+0x0@m
	ld.w	%r3,apu+0x0@l
	add	%r3,0x20	; 	xadd	%r3,%r3,32
	ld.w	%r13,0x0
	ext	0xa		; 	xld.w	%r14,0x00000280		; 640
	ld.w	%r14,0x0
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ext	apu+0x7d@ah	; 	xld.ub	%r2,[apu+125]
	ext	apu+0x7d@al
	ld.ub	%r2,[%r8]
	ext	apu+0x7e@ah	; 	xld.ub	%r0,[apu+126]
	ext	apu+0x7e@al
	ld.ub	%r0,[%r8]
	ld.w	%r15,0x5	; 	xld.w	%r15,0x00000005		; 5
	ld.w	[%sp+0x0],%r15	; 	xld.w	[%sp],%r15
__LX127:				; __L127:
	add	%r2,0x18	; 	xadd	%r2,%r2,24
	cmp	%r2,0x18	; 	xcmp	%r2,24
	jrle	__LX130		; 	xjrle	__L130
	sub	%r2,0x19	; 	xsub	%r2,%r2,25
	cmp	%r0,0x3		; 	xcmp	%r0,3
	jrgt	__LX131		; 	xjrgt	__L131
	ext	0x2		; 	xadd	%r12,%r3,2
	add	%r12,%r3
	ext	apu_do_envelope@rm	; 	xcall	apu_do_envelope
	call	apu_do_envelope@rl
	ext	0x16		; 	xadd	%r12,%r3,22
	add	%r12,%r3
	ext	apu_do_envelope@rm	; 	xcall	apu_do_envelope
	call	apu_do_envelope@rl
	ext	apu+0x54@h	; 	xld.w	%r12,apu+84
	ext	apu+0x54@m
	ld.w	%r12,apu+0x54@l
	add	%r12,0x2	; 	xadd	%r12,%r12,2
	ext	apu_do_envelope@rm	; 	xcall	apu_do_envelope
	call	apu_do_envelope@rl
	ext	apu+0x48@h	; 	xld.w	%r12,apu+72
	ext	apu+0x48@m
	ld.w	%r12,apu+0x48@l
	add	%r12,0x2	; 	xadd	%r12,%r12,2
	ext	apu_do_linear@rm	; 	xcall	apu_do_linear
	call	apu_do_linear@rl
__LX131:				; __L131:
	ld.w	%r10,%r0
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	jreq	__LX132		; 	xjreq	__L132
	ext	0x6		; 	xadd	%r12,%r3,6
	add	%r12,%r3
	ext	apu_do_sweep@rm	; 	xcall	apu_do_sweep
	call	apu_do_sweep@rl
	ext	0x1a		; 	xadd	%r12,%r3,26
	add	%r12,%r3
	ext	apu_do_sweep@rm	; 	xcall	apu_do_sweep
	call	apu_do_sweep@rl
__LX132:				; __L132:
	cmp	%r0,0x0
	jrne	__LX133		; 	xjrne	__L133
	ld.w	%r12,%r3
	ext	apu_do_length@rm	; 	xcall	apu_do_length
	call	apu_do_length@rl
	ext	0x14		; 	xadd	%r12,%r3,20
	add	%r12,%r3
	ext	apu_do_length@rm	; 	xcall	apu_do_length
	call	apu_do_length@rl
	ext	apu+0x48@h	; 	xld.w	%r12,apu+72
	ext	apu+0x48@m
	ld.w	%r12,apu+0x48@l
	ext	apu_do_length@rm	; 	xcall	apu_do_length
	call	apu_do_length@rl
	ext	apu+0x54@h	; 	xld.w	%r12,apu+84
	ext	apu+0x54@m
	ld.w	%r12,apu+0x54@l
	ext	apu_do_length@rm	; 	xcall	apu_do_length
	call	apu_do_length@rl
	ext	apu+0x17@ah	; 	xld.ub	%r12,[apu+23]
	ext	apu+0x17@al
	ld.ub	%r12,[%r8]
	ld.w	%r10,%r12
	ext	0x2		; 	xand	%r10,%r10,0x00000080
	and	%r10,0x0
	ld.ub	%r10,%r10
	cmp	%r10,0x0
	jrne	__LX134		; 	xjrne	__L134
	ld.w	%r0,0x4		; 	xld.w	%r0,0x00000004		; 4
	ext	0x1		; 	xld.w	%r11,0x00000040		; 64
	ld.w	%r11,0x0
	ld.w	%r10,%r12
	ext	0x1		; 	xand	%r10,%r10,0x00000040
	and	%r10,0x0
	jrne	__LX133		; 	xjrne	__L133
	ld.w	%r10,%r11
	ext	apu+0x7c@ah	; 	xld.ub	%r15,[apu+124]
	ext	apu+0x7c@al
	ld.ub	%r15,[%r8]
	or	%r10,%r15
	ext	apu+0x7c@ah	; 	xld.b	[apu+124],%r10
	ext	apu+0x7c@al
	ld.b	[%r8],%r10
	jp	__LX133		; 	xjp	__L133
__LX134:				; __L134:
	ld.w	%r0,0x5		; 	xld.w	%r0,0x00000005		; 5
__LX133:				; __L133:
	sub	%r0,0x1		; 	xsub	%r0,%r0,1
__LX130:				; __L130:
	ext	apu+0x15@ah	; 	xbtst	[apu+21],0x0
	ext	apu+0x15@al
	btst	[%r8],0x0
	jreq	__LX137		; 	xjreq	__L137
	ld.w	%r12,%r3
	ld.w	%r13,%r1
	ext	apu_square_mix@rm	; 	xcall	apu_square_mix
	call	apu_square_mix@rl
__LX137:				; __L137:
	ext	apu+0x15@ah	; 	xbtst	[apu+21],0x1
	ext	apu+0x15@al
	btst	[%r8],0x1
	jreq	__LX138		; 	xjreq	__L138
	ext	0x14		; 	xadd	%r12,%r3,20
	add	%r12,%r3
	ld.w	%r13,%r1
	ext	apu_square_mix@rm	; 	xcall	apu_square_mix
	call	apu_square_mix@rl
__LX138:				; __L138:
	ext	apu+0x15@ah	; 	xbtst	[apu+21],0x2
	ext	apu+0x15@al
	btst	[%r8],0x2
	jreq	__LX139		; 	xjreq	__L139
	ext	apu+0x48@h	; 	xld.w	%r12,apu+72
	ext	apu+0x48@m
	ld.w	%r12,apu+0x48@l
	ld.w	%r13,%r1
	ext	apu_triangle_mix@rm	; 	xcall	apu_triangle_mix
	call	apu_triangle_mix@rl
__LX139:				; __L139:
	ext	apu+0x15@ah	; 	xbtst	[apu+21],0x3
	ext	apu+0x15@al
	btst	[%r8],0x3
	jreq	__LX140		; 	xjreq	__L140
	ext	apu+0x54@h	; 	xld.w	%r12,apu+84
	ext	apu+0x54@m
	ld.w	%r12,apu+0x54@l
	ld.w	%r13,%r1
	ext	apu_noise_mix@rm	; 	xcall	apu_noise_mix
	call	apu_noise_mix@rl
__LX140:				; __L140:
	ext	apu+0x15@ah	; 	xbtst	[apu+21],0x4
	ext	apu+0x15@al
	btst	[%r8],0x4
	jreq	__LX141		; 	xjreq	__L141
	ext	0x2		; 	xld.w	%r10,0x00000080		; 128
	ld.w	%r10,0x0
	ext	apu+0x64@ah	; 	xld.ub	%r15,[apu+100]
	ext	apu+0x64@al
	ld.ub	%r15,[%r8]
	and	%r10,%r15
	ld.ub	%r10,%r10
	cmp	%r10,0x0
	jreq	__LX141		; 	xjreq	__L141
	ext	apu+0x64@h	; 	xld.w	%r12,apu+100
	ext	apu+0x64@m
	ld.w	%r12,apu+0x64@l
	ld.w	%r13,%r1
	ext	apu_dmc_mix@rm	; 	xcall	apu_dmc_mix
	call	apu_dmc_mix@rl
	ext	0x2		; 	xld.w	%r10,0x00000080		; 128
	ld.w	%r10,0x0
	ext	apu+0x64@ah	; 	xld.ub	%r15,[apu+100]
	ext	apu+0x64@al
	ld.ub	%r15,[%r8]
	and	%r10,%r15
	ld.ub	%r10,%r10
	cmp	%r10,0x0
	jrne	__LX141		; 	xjrne	__L141
	ext	0x2		; 	xld.w	%r10,0x00000080		; 128
	ld.w	%r10,0x0
	ext	apu+0x10@ah	; 	xld.ub	%r15,[apu+16]
	ext	apu+0x10@al
	ld.ub	%r15,[%r8]
	and	%r10,%r15
	ld.ub	%r10,%r10
	cmp	%r10,0x0
	jreq	__LX141		; 	xjreq	__L141
	ext	0x2		; 	xld.w	%r10,0x00000080		; 128
	ld.w	%r10,0x0
	ext	apu+0x7c@ah	; 	xld.ub	%r15,[apu+124]
	ext	apu+0x7c@al
	ld.ub	%r15,[%r8]
	or	%r10,%r15
	ext	apu+0x7c@ah	; 	xld.b	[apu+124],%r10
	ext	apu+0x7c@al
	ld.b	[%r8],%r10
__LX141:				; __L141:
	ext	0x2		; 	xadd	%r1,%r1,128
	add	%r1,0x0
	ld.w	%r15,[%sp+0x0]	; 	xld.w	%r15,[%sp]
	sub	%r15,0x1	; 	xsub	%r15,%r15,1
	ld.w	[%sp+0x0],%r15	; 	xld.w	[%sp],%r15
	ext	__LX127@rm	; 	xjrne	__L127
	jrne	__LX127@rl
	ext	apu+0x7d@ah	; 	xld.b	[apu+125],%r2
	ext	apu+0x7d@al
	ld.b	[%r8],%r2
	ext	apu+0x7e@ah	; 	xld.b	[apu+126],%r0
	ext	apu+0x7e@al
	ld.b	[%r8],%r0
	ext	0x280		; 	xsub	%r12,%r1,640
	sub	%r12,%r1
	ext	apu_volume_shift@rm	; 	xcall	apu_volume_shift
	call	apu_volume_shift@rl
	add	%sp,0x2		; 	xadd	%sp,%sp,8
	popn	%r3
	ret
	.align	1
	.global	apu_do_length
apu_do_length:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	btst	[%r12],0x0	; 	xbtst	[%r12],0x0
	jreq	__LX147		; 	xjreq	__L147
	ext	0x1		; 	xld.ub	%r11,[%r12+1]
	ld.ub	%r11,[%r12]
	ld.ub	%r10,%r11
	cmp	%r10,0x0
	jreq	__LX147		; 	xjreq	__L147
	ext	0x1		; 	xsub	%r10,%r11,1
	sub	%r10,%r11
	ext	0x1		; 	xld.b	[%r12+1],%r10
	ld.b	[%r12],%r10
	ld.ub	%r10,%r10
	cmp	%r10,0x0
	jrne	__LX147		; 	xjrne	__L147
	bclr	[%r12],0x0	; 	xbclr	[%r12],0x0
__LX147:				; __L147:
	ret
	.align	1
	.global	apu_do_linear
apu_do_linear:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	btst	[%r12],0x0	; 	xbtst	[%r12],0x0
	jreq	__LX151		; 	xjreq	__L151
	ext	0x1		; 	xld.ub	%r10,[%r12+1]
	ld.ub	%r10,[%r12]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ext	0x1		; 	xld.b	[%r12+1],%r10
	ld.b	[%r12],%r10
	ld.ub	%r10,%r10
	cmp	%r10,0x0
	jrne	__LX151		; 	xjrne	__L151
	bclr	[%r12],0x0	; 	xbclr	[%r12],0x0
__LX151:				; __L151:
	ret
	.align	1
	.global	apu_do_envelope
apu_do_envelope:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	btst	[%r12],0x0	; 	xbtst	[%r12],0x0
	jreq	__LX154		; 	xjreq	__L154
	ext	0x2		; 	xld.ub	%r10,[%r12+2]
	ld.ub	%r10,[%r12]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ext	0x2		; 	xld.b	[%r12+2],%r10
	ld.b	[%r12],%r10
	ld.ub	%r10,%r10
	cmp	%r10,0x0
	jrne	__LX154		; 	xjrne	__L154
	ext	0x1		; 	xld.ub	%r10,[%r12+1]
	ld.ub	%r10,[%r12]
	ext	0x2		; 	xld.b	[%r12+2],%r10
	ld.b	[%r12],%r10
	ext	0x3		; 	xld.ub	%r10,[%r12+3]
	ld.ub	%r10,[%r12]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ext	0x3		; 	xld.b	[%r12+3],%r10
	ld.b	[%r12],%r10
	ld.ub	%r10,%r10
	cmp	%r10,0x0
	jrne	__LX154		; 	xjrne	__L154
	ld.ub	%r11,[%r12]	; 	xld.ub	%r11,[%r12]
	ld.w	%r10,%r11
	and	%r10,0x2	; 	xand	%r10,%r10,0x00000002
	jreq	__LX157		; 	xjreq	__L157
	ld.w	%r10,0xf	; 	xld.w	%r10,0x0000000f		; 15
	ext	0x3		; 	xld.b	[%r12+3],%r10
	ld.b	[%r12],%r10
	jp	__LX154		; 	xjp	__L154
__LX157:				; __L157:
	ld.w	%r10,%r11
	ext	0x3		; 	xand	%r10,%r10,0x000000fe
	and	%r10,0x3e
	ld.b	[%r12],%r10	; 	xld.b	[%r12],%r10
__LX154:				; __L154:
	ret
	.align	1
	.global	apu_do_sweep
apu_do_sweep:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r13,%r12
	btst	[%r13],0x0	; 	xbtst	[%r13],0x0
	jreq	__LX160		; 	xjreq	__L160
	ext	0x3		; 	xld.ub	%r10,[%r13+3]
	ld.ub	%r10,[%r13]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ext	0x3		; 	xld.b	[%r13+3],%r10
	ld.b	[%r13],%r10
	ld.ub	%r10,%r10
	cmp	%r10,0x0
	jrne	__LX160		; 	xjrne	__L160
	ext	0x2		; 	xld.ub	%r10,[%r13+2]
	ld.ub	%r10,[%r13]
	ext	0x3		; 	xld.b	[%r13+3],%r10
	ld.b	[%r13],%r10
	btst	[%r13],0x1	; 	xbtst	[%r13],0x1
	jrne	__LX162		; 	xjrne	__L162
	ext	0x4		; 	xld.uh	%r10,[%r13+4]
	ld.uh	%r10,[%r13]
	ld.h	%r11,%r10
	ext	0x1		; 	xld.ub	%r12,[%r13+1]
	ld.ub	%r12,[%r13]
	ld.w	%r9,%r12	; 	xsra	%r11,%r12
	and	%r9,0x1f
	cmp	%r9,0x8
	jrle	4
	sra	%r11,0x8
	jp.d	-3
	sub	%r9,0x8
	sra	%r11,%r9
	add	%r10,%r11
	ext	0x4		; 	xld.h	[%r13+4],%r10
	ld.h	[%r13],%r10
	ld.h	%r10,%r10
	ext	0x1f		; 	xcmp	%r10,2046
	cmp	%r10,0x3e
	jrle	__LX160		; 	xjrle	__L160
	ext	0x1f		; 	xld.w	%r10,0x000007ff		; 2047
	ld.w	%r10,0x3f
	jp	__LX166		; 	xjp	__L166
__LX162:				; __L162:
	ext	0x4		; 	xld.uh	%r10,[%r13+4]
	ld.uh	%r10,[%r13]
	ld.h	%r11,%r10
	ext	0x1		; 	xld.ub	%r12,[%r13+1]
	ld.ub	%r12,[%r13]
	ld.w	%r9,%r12	; 	xsra	%r11,%r12
	and	%r9,0x1f
	cmp	%r9,0x8
	jrle	4
	sra	%r11,0x8
	jp.d	-3
	sub	%r9,0x8
	sra	%r11,%r9
	sub	%r10,%r11
	ext	0x4		; 	xld.h	[%r13+4],%r10
	ld.h	[%r13],%r10
	ld.h	%r10,%r10
	cmp	%r10,0x8	; 	xcmp	%r10,8
	jrgt	__LX160		; 	xjrgt	__L160
	ld.w	%r10,0x8	; 	xld.w	%r10,0x00000008		; 8
__LX166:				; __L166:
	ext	0x4		; 	xld.h	[%r13+4],%r10
	ld.h	[%r13],%r10
	bclr	[%r13],0x0	; 	xbclr	[%r13],0x0
__LX160:				; __L160:
	ret

	.comm	apu 128
