/*
 *	clip7seg.c
 *
 *	7ZOgfBXvC
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2013 Naoyuki Sawa
 *
 *	* Fri Nov 15 00:12:35 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

int Get7SegPat(int c) {
	//7ZOgfBXvČX̃ZOg̔zu
	//uhttp://ja.wikipedia.org/wiki/7ZOgfBXvCv:
	//
	//@@@@@@@@
	//@@``@@@@
	//@e@@a@@@
	//@e@@a@@@
	//@@ff@@@@
	//@d@@b@@@
	//@d@@b@@@
	//@@cc@@DP@
	//@@@@@@@@
	//
	static const unsigned char TBL_7SegPat[(10/*0-9*/)+(26/*A-Z*/)]={
	//`  |  a  |  b  |  c  |  d  |  e  |  f  |  DP
	(1<<7)|(1<<6)|(1<<5)|(1<<4)|(1<<3)|(1<<2)|(0<<1)|(0<<0),//0
	(0<<7)|(1<<6)|(1<<5)|(0<<4)|(0<<3)|(0<<2)|(0<<1)|(0<<0),//1
	(1<<7)|(1<<6)|(0<<5)|(1<<4)|(1<<3)|(0<<2)|(1<<1)|(0<<0),//2
	(1<<7)|(1<<6)|(1<<5)|(1<<4)|(0<<3)|(0<<2)|(1<<1)|(0<<0),//3
	(0<<7)|(1<<6)|(1<<5)|(0<<4)|(0<<3)|(1<<2)|(1<<1)|(0<<0),//4
	(1<<7)|(0<<6)|(1<<5)|(1<<4)|(0<<3)|(1<<2)|(1<<1)|(0<<0),//5
	(1<<7)|(0<<6)|(1<<5)|(1<<4)|(1<<3)|(1<<2)|(1<<1)|(0<<0),//6
	(1<<7)|(1<<6)|(1<<5)|(0<<4)|(0<<3)|(1<<2)|(0<<1)|(0<<0),//7
	(1<<7)|(1<<6)|(1<<5)|(1<<4)|(1<<3)|(1<<2)|(1<<1)|(0<<0),//8
	(1<<7)|(1<<6)|(1<<5)|(1<<4)|(0<<3)|(1<<2)|(1<<1)|(0<<0),//9
	(1<<7)|(1<<6)|(1<<5)|(0<<4)|(1<<3)|(1<<2)|(1<<1)|(0<<0),//A
	(0<<7)|(0<<6)|(1<<5)|(1<<4)|(1<<3)|(1<<2)|(1<<1)|(0<<0),//B
	(0<<7)|(0<<6)|(0<<5)|(1<<4)|(1<<3)|(0<<2)|(1<<1)|(0<<0),//C
	(0<<7)|(1<<6)|(1<<5)|(1<<4)|(1<<3)|(0<<2)|(1<<1)|(0<<0),//D
	(1<<7)|(0<<6)|(0<<5)|(1<<4)|(1<<3)|(1<<2)|(1<<1)|(0<<0),//E
	(1<<7)|(0<<6)|(0<<5)|(0<<4)|(1<<3)|(1<<2)|(1<<1)|(0<<0),//F
	(1<<7)|(0<<6)|(1<<5)|(1<<4)|(1<<3)|(1<<2)|(0<<1)|(0<<0),//G
	(0<<7)|(0<<6)|(1<<5)|(0<<4)|(1<<3)|(1<<2)|(1<<1)|(0<<0),//H
	(0<<7)|(0<<6)|(1<<5)|(0<<4)|(0<<3)|(0<<2)|(0<<1)|(0<<0),//I
	(0<<7)|(1<<6)|(1<<5)|(1<<4)|(1<<3)|(0<<2)|(0<<1)|(0<<0),//J
	(1<<7)|(0<<6)|(1<<5)|(0<<4)|(1<<3)|(1<<2)|(1<<1)|(0<<0),//K
	(0<<7)|(0<<6)|(0<<5)|(1<<4)|(1<<3)|(1<<2)|(0<<1)|(0<<0),//L
	(1<<7)|(1<<6)|(1<<5)|(0<<4)|(1<<3)|(1<<2)|(0<<1)|(0<<0),//M
	(0<<7)|(0<<6)|(1<<5)|(0<<4)|(1<<3)|(0<<2)|(1<<1)|(0<<0),//N
	(0<<7)|(0<<6)|(1<<5)|(1<<4)|(1<<3)|(0<<2)|(1<<1)|(0<<0),//O
	(1<<7)|(1<<6)|(0<<5)|(0<<4)|(1<<3)|(1<<2)|(1<<1)|(0<<0),//P
	(1<<7)|(1<<6)|(0<<5)|(1<<4)|(1<<3)|(1<<2)|(1<<1)|(0<<0),//Q
	(0<<7)|(0<<6)|(0<<5)|(0<<4)|(1<<3)|(0<<2)|(1<<1)|(0<<0),//R
	(0<<7)|(0<<6)|(1<<5)|(1<<4)|(0<<3)|(1<<2)|(1<<1)|(0<<0),//S
	(0<<7)|(0<<6)|(0<<5)|(1<<4)|(1<<3)|(1<<2)|(1<<1)|(0<<0),//T
	(0<<7)|(0<<6)|(1<<5)|(1<<4)|(1<<3)|(0<<2)|(0<<1)|(0<<0),//U
	(0<<7)|(1<<6)|(1<<5)|(1<<4)|(1<<3)|(1<<2)|(0<<1)|(0<<0),//V
	(0<<7)|(1<<6)|(1<<5)|(1<<4)|(1<<3)|(1<<2)|(1<<1)|(0<<0),//W
	(0<<7)|(1<<6)|(1<<5)|(0<<4)|(1<<3)|(1<<2)|(1<<1)|(0<<0),//X
	(0<<7)|(1<<6)|(1<<5)|(1<<4)|(0<<3)|(1<<2)|(1<<1)|(0<<0),//Y
	(1<<7)|(1<<6)|(0<<5)|(1<<4)|(1<<3)|(0<<2)|(0<<1)|(0<<0),//Z
	};
	if(isdigit(c)) { return TBL_7SegPat[c -  '0'      ]; }
	if(isupper(c)) { return TBL_7SegPat[c - ('A' - 10)]; }
	if(islower(c)) { return TBL_7SegPat[c - ('a' - 10)]; }
	return !isblank(c); //󔒁ˁu vAȊOSāˁu.v
}

/****************************************************************************
 *
 ****************************************************************************/

int render_7seg(RENDER* render, int x, int y, int w, int h, int pat, int color) {
	int retval   = (w + 1) | (h + 1) << 8;
	int TBL_x[2] = { x,           x+w-1 };
	int TBL_y[3] = { y, y+(h>>1), y+h-1 };
	int line = ((1<<0)|(0<<1)|(1<<2))<< 0|//G=Horz(0,1)
	           ((0<<0)|(0<<1)|(0<<2))<< 4|//F=Vert(0,0)
	           ((0<<0)|(0<<1)|(1<<2))<< 8|//E=Vert(0,1)
	           ((1<<0)|(0<<1)|(2<<2))<<12|//D=Horz(0,2)
	           ((0<<0)|(1<<1)|(1<<2))<<16|//C=Vert(1,1)
	           ((0<<0)|(1<<1)|(0<<2))<<20|//B=Vorz(1,0)
	           ((1<<0)|(0<<1)|(0<<2))<<24;//A=Hert(0,0)
	pat = (unsigned char)pat; //Ŝ
	if(pat & 1) {
		render_point(render, TBL_x[1]+2, TBL_y[2], color); //DP
		retval += 2;
	}
	while(pat >>= 1) {
		int x1, y1, x2, y2;
		int dir = line & 1;
		line >>= 1;
		x1 = TBL_x[(line & 1) +   0];
		x2 = TBL_x[(line & 1) + dir] + dir;
		line >>= 1;
		dir   ^= 1;
		y1 = TBL_y[(line & 3) +   0];
		y2 = TBL_y[(line & 3) + dir] + dir;
		line >>= 2;
		if(pat & 1) {
			render_line(render, x1,y1, x2,y2, color); //A-G
		}
	}
	return retval;
}
