;
;	clip65ca.s
;
;	P/ECE MOS6502 Emulator ()
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Fri Jan 28 03:55:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
;#include "clip65ca.h"
;
;	clip65ca.h
;
;	P/ECE MOS6502 Emulator ()
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Fri Jan 28 03:55:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;	* Sat Apr 09 16:38:00 JST 2005 Naoyuki Sawa
;	- WX^蓖ĂύX܂B
;

; clip65ca.sAfram65ca.sɃCN[hĎg܂B

;****************************************************************************
;	M6502CPU\
;****************************************************************************

				; typedef struct _M6502CPU {
;#define CA		 0	; unsigned short ca;	/* + 0,2 -------C AAAAAAAA */
;#define _NZ_		 2	; unsigned short nz;	/* + 2,2 N------- NZZZZZZZ */
;#define BDI		 4	; unsigned char bdi;	/* + 4,1          001BDI00 */
;#define V		 5	; unsigned char v;	/* + 5,1          V------- */
;#define _X_		 6	; unsigned char x;	/* + 6,1          XXXXXXXX */
;#define _Y_		 7	; unsigned char y;	/* + 7,1          YYYYYYYY */
;#define _PC_		 8	; unsigned char* pc;	/* + 8,4 &mem[PC]          */
;#define _SP_		12	; unsigned char sp;	/* +12,1          SPSPSPSP */
				; //			/* +13,3 (pfBO)      */
;#define FLAGS		16	; int flags;		/* +16,4          ------IW */
;#define _CYCLE_		20	; int cycle;		/* +20,4 cCycle         */
;#define READ		24	; void* read;		/* +24,4 ǂݏo[` */
;#define WRITE		28	; void* write;		/* +28,4 ݃[` */
;#define SIZEOF_M6502CPU	32	; } M6502CPU;		/* =32   */

;****************************************************************************
;	WX^蓖
;****************************************************************************

;#define addr	r0	; ݂̖߂̃AhX[hAhXێ܂B
			; AddressMode[`AAction[`QƂ܂B
			; Operation[`Ȃ̃Tu[`͎gpsłB
;#define data	r1	; ݂̖߂֓nf[^A߂̖߂f[^ێ܂B
			; ǂݍ݂s߂̏ꍇAAction[`AOperation[`gp܂B
			; ݂s߂̏ꍇAOperation[`AAction[`gp܂B
			; ̑̏ꍇAėp[NWX^ƂĎgp\łB
;#define ptbl	r2	; ݂̖߂ɑΉm6502tblGg̑|C^łB
			; m6502cpu_runAm6502cpu_runAction[`gp܂B
			; AddressMode[`AOperation[`Ȃ̃Tu[`͎gpsłB
;#define TBL	r3	; m6502tbl̐擪AhXێ܂B
			; m6502cpu_enter`m6502cpu_leave̊ԁAsςłB
;#define A	r4	; AWX^̒lێ܂BD31:8͏0Ƃ܂B
			; Operation[`gp܂B
			; m6502cpu_runAAction[`AAddressMode[`Ȃ̃Tu[`͎gpsłB
;#define X	r5	; XWX^̒lێ܂BD31:8͏0Ƃ܂B
			; Operation[`gp܂B
			; m6502cpu_runAAction[`AAddressMode[`Ȃ̃Tu[`͎gpsłB
;#define Y	r6	; YWX^̒lێ܂BD31:8͏0Ƃ܂B
			; Operation[`gp܂B
			; m6502cpu_runAAction[`AAddressMode[`Ȃ̃Tu[`͎gpsłB
;#define NZ	r7	; PSR(N,Z)\2oCglێ܂Bڂ́AM6502CPU\̂̃RgQƂĂB
			; Operation[`gp܂B
			; m6502cpu_runAAction[`AAddressMode[`Ȃ̃Tu[`͎gpsłB
;		r8	; 
;		r9	; 
;#define PC	r10	; &m6502mem[PC]ێ܂B
			; Cӂ̃[`AJumpACallȂǂ̏ɂāAK؂ɐݒ肵܂B
;#define SP	r11	; SPWX^̒lێ܂BD31:8͏0Ƃ܂B
			; Cӂ̃[`APushAPullACallȂǂ̏ɂāAK؂ɐݒ肵܂B
;#define t0	r12	; ėp[NWX^łB
;#define t1	r13	; ėp[NWX^łB
;#define CPU	r14	; m6502cpu̐擪AhXێ܂B
			; m6502cpu_enter`m6502cpu_leave̊ԁAsςłB
;#define CYCLE	r15	; csTCNێ܂B
			; Cӂ̃[`AK؂ɎcTCN炵܂B

;****************************************************************************
;	
;****************************************************************************

	.code
	.align 1

;****************************************************************************
;	
;****************************************************************************

; 荞݂s܂B
;
; [in]
;		%data	%addr
;		------	------
;	IRQ	0	0xfffe
;	NMI	0	0xfffa
;	BRK	1	0xfffe
;
; [note]
;	* sReLXg痘p܂B
;	  sReLXgO璼ڌĂяoƂ͂ł܂B
;
	.global	m6502cpu_interrupt
m6502cpu_interrupt:
	add	%r10, %r1			; if BRK then PC++
	;
	ext	m6502cpu_pack@rm	; 	xcall.d	m6502cpu_pack			; %t0 = PSR
	call.d	m6502cpu_pack@rl
	ld.w	%r12, %r1			; *delay*
	and	%r1,0x2f	; 	xand	%r1, %r1, -17		; if BRK then B=1 else B=0
	sll	%r12,0x4	; 	xsll	%r12, 4
	or	%r12, %r1
	;
	ext	m6502mem@ah			; %data = PC
	ext	m6502mem@al
	sub	%r1, %r10
	ext	m6502cpu_push@rm	; 	xcall.d	m6502cpu_push			; Push HI(PC)
	call.d	m6502cpu_push@rl
	rr	%r1, 8			; *delay*
	ext	m6502cpu_push@rm	; 	xcall.d	m6502cpu_push			; Push Lo(PC)
	call.d	m6502cpu_push@rl
	rl	%r1, 8			; *delay*
	ext	m6502cpu_push@rm	; 	xcall.d	m6502cpu_push			; Push PSR
	call.d	m6502cpu_push@rl
	ld.w	%r1, %r12			; *delay*
	;
	ext	m6502mem@ah			; %PC = &mem[mem[addr]]
	ext	m6502mem@al
	ld.uh	%r10, [%r0]
	ext	m6502mem@ah
	ext	m6502mem@al
	add	%r10, %r10
	;
	ext	0x4		; 	xbset	[%r14+0x4], 0x2			; IRQ}XN܂B
	bset	[%r14],0x2
	ext	0x10		; 	xbclr	[%r14+0x10], 0x0			; 荞ݔɂAWAI܂B
	bclr	[%r14],0x0
	ret

; ۗĂIRQv𒲂ׁAs\ȂΎs܂B
;
; [note]
;	* sReLXg痘p܂B
;	  sReLXgO璼ڌĂяoƂ͂ł܂B
;
	.global	m6502cpu_check_pending
m6502cpu_check_pending:
	ext	0x4		; 	xbtst	[%r14+0x4], 0x2			; IRQ}XNĂȂ?
	btst	[%r14],0x2
	jrne	m6502cpu_check_pending_EXIT	; 	xjrne	m6502cpu_check_pending_EXIT
	ext	0x10		; 	xbtst	[%r14+0x10], 0x1			; IRQvۗĂ邩?
	btst	[%r14],0x1
	jreq	m6502cpu_check_pending_EXIT	; 	xjreq	m6502cpu_check_pending_EXIT
	ext	0x10		; 	xbclr	[%r14+0x10], 0x1			; IRQvtONA܂B
	bclr	[%r14],0x1
	ext	0x3ff		; 	xld.w	%r0, 0xfffe			; IRQs܂B
	ld.w	%r0,0x3e
	call.d	m6502cpu_interrupt	; 	xcall.d	m6502cpu_interrupt
	ld.w	%r1, 0			; *delay*
m6502cpu_check_pending_EXIT:
	ret

;****************************************************************************
;	
;****************************************************************************

; IRQv܂B
;
; [note]
;	* sReLXgOĂ΂܂B
;	  sReLXgĂяoĂ͂܂B
;
	.global	m6502cpu_irq
m6502cpu_irq:
	pushn	%r3
	ext	m6502cpu_enter@rm	; 	xcall	m6502cpu_enter			; sReLXgo܂B
	call	m6502cpu_enter@rl
	ext	0x10		; 	xbset	[%r14+0x10], 0x1			; IRQvtOZbg܂B
	bset	[%r14],0x1
	call	m6502cpu_check_pending	; 	xcall	m6502cpu_check_pending		; IRQs\ׂ܂B
	ext	m6502cpu_leave@rm	; 	xcall	m6502cpu_leave			; sReLXg߂܂B
	call	m6502cpu_leave@rl
	popn	%r3
	ret

; NMIs܂B
;
; [note]
;	* sReLXgOĂ΂܂B
;	  sReLXgĂяoĂ͂܂B
;
	.global	m6502cpu_nmi
m6502cpu_nmi:
	pushn	%r3
	ext	m6502cpu_enter@rm	; 	xcall	m6502cpu_enter			; sReLXgo܂B
	call	m6502cpu_enter@rl
	ext	0x3ff		; 	xld.w	%r0, 0xfffa			; NMIs܂B
	ld.w	%r0,0x3a
	call.d	m6502cpu_interrupt	; 	xcall.d	m6502cpu_interrupt
	ld.w	%r1, 0			; *delay*
	ext	m6502cpu_leave@rm	; 	xcall	m6502cpu_leave			; sReLXg߂܂B
	call	m6502cpu_leave@rl
	popn	%r3
	ret

;****************************************************************************
;	
;****************************************************************************

	.global	m6502cpu_ERR
m6502cpu_ERR:
	ext	m6502cpu_leave@rm	; 	xcall	m6502cpu_leave		; sReLXg𔲂܂B
	call	m6502cpu_leave@rl
	ext	m6502cpu_err@rm	; 	xjp	m6502cpu_err		; Cł̃G[[`ցB
	jp	m6502cpu_err@rl

;****************************************************************************
;	
;****************************************************************************
