/*	
 *	clip65c.c
 *
 *	P/ECE MOS6502 Emulator ()
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Fri Jan 28 03:55:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Mar 16 06:54:00 JST 2005 Naoyuki Sawa
 *	- m6502cpu_sbcd()̃oOC܂B
 */
#include "clip.h"

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

//M6502CPU m6502cpu; -> fram65ca.s
unsigned char m6502mem[0x10000];

/****************************************************************************
 *	֐
 ****************************************************************************/

void
m6502cpu_err()
{
	die("m6502cpu_error(%04x)", m6502cpu.pc - m6502mem);
}

/*{{6502G~[VW[̗p*/

#define A	(reg.a)
#define X	(reg.x)
#define Y	(reg.y)
#define PC	(reg.pc)
#define SP	(reg.sp)
#define PSR	(reg.psr)

void
m6502cpu_adcd(int n)
{
	int c;
	int lo;
	int hi;
	M6502REG reg;

	m6502reg_get(&reg);

	c = PSR & 1;
	lo = (A & 0x0f) + (n & 0x0f) + c;
	hi = (A & 0xf0) + (n & 0xf0);
	if(lo > 0x09) {
		lo += 0x06;
		hi += 0x10;
	}
	PSR = (PSR & ~0xc3) |
	      (hi & 0x80) |				/* N */
	      ((~(A ^ n) & (A ^ hi) & 0x80) >> 1);	/* V */
	if(hi > 0x90) {
		hi += 0x60;
	}
	A = (lo & 0x0f) | (hi & 0xf0);
	PSR |= (!A << 1) |				/* Z */
	       ((hi >> 8) & 1);				/* C */

	m6502reg_put(&reg);
}

void
m6502cpu_sbcd(int n)
{
	int c;
	int lo;
	int hi;
	M6502REG reg;

	m6502reg_get(&reg);

	c = ~PSR & 1;
	lo = (A & 0x0f) - (n & 0x0f) - c;
	hi = (A & 0xf0) - (n & 0xf0);
	//if(lo > 0x09) {
	//2005/03/16C
	if(lo & 0x10) {
		lo -= 0x06;
		hi -= 0x10;
	}
	PSR = (PSR & ~0xc3) |
	      (hi & 0x80) |				/* N */
	      (((A ^ n) & (A ^ hi) & 0x80) >> 1);	/* V */
	//if(hi > 0x90) {
	//2005/03/16C
	if(hi & 0x100) {
		hi -= 0x60;
	}
	A = (lo & 0x0f) | (hi & 0xf0);
	PSR |= (!A << 1) |				/* Z */
	       (~(hi >> 8) & 1);			/* C */

	m6502reg_put(&reg);
}

#undef A
#undef X
#undef Y
#undef PC
#undef SP
#undef PSR

/*}}6502G~[VW[̗p*/

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
m6502cpu_reset(void* read, void* write)
{
	M6502CPU* cpu = &m6502cpu;
	M6502REG  reg;

	/* ܂NA܂B */
	memset(cpu, 0, sizeof(M6502CPU));

	/* ANZX[`i[܂B */
	cpu->read  = read  ? read  : m6502mem_read ;
	cpu->write = write ? write : m6502mem_write;

	/* WX^̏lݒ肵܂B */
	memset(&reg, 0, sizeof reg);
	reg.pc  = *(unsigned short*)&m6502mem[0xfffc];
	reg.sp  = 0xff;
	reg.psr = 0x26; /* PSR(00100IZ0) */
	m6502reg_put(&reg);
}

void
m6502reg_put(const M6502REG* reg)
{
	M6502CPU* cpu = &m6502cpu;

	cpu->ca  = reg->a;
	cpu->x   = reg->x;
	cpu->y   = reg->y;
	cpu->pc  = &m6502mem[reg->pc];
	cpu->sp  = reg->sp;
	cpu->bdi =  reg->psr & 0x3c;		/*  reg->psr[5:2] -> cpu->psr[5:2] */
	cpu->v   = (reg->psr & 0x40) << 1;	/*  reg->psr[6]   -> cpu->v  [7]   */
	cpu->ca |= (reg->psr & 0x01) << 8;	/*  reg->psr[0]   -> cpu->ca [8]   */
	cpu->nz  = ~reg->psr & 0x02;		/* !reg->psr[1]   -> cpu->nz [1]   */
	cpu->nz |= (reg->psr & 0x80) << 8;	/*  reg->psr[7]   -> cpu->nz [15]  */
}

void
m6502reg_get(M6502REG* reg)
{
	M6502CPU* cpu = &m6502cpu;

	reg->a    = cpu->ca;
	reg->x    = cpu->x;
	reg->y    = cpu->y;
	reg->pc   = cpu->pc - m6502mem;
	reg->sp   = cpu->sp;
	reg->psr  =  cpu->bdi;				/*  cpu->bdi[7:0]  -> reg->psr[7:0] */
	reg->psr |= (cpu->v  &   0x80) >> 1;		/*  cpu->v  [7]    -> reg->psr[6]   */
	reg->psr |= (cpu->ca &  0x100) >> 8;		/*  cpu->ca [8]    -> reg->psr[0]   */
	reg->psr |= (cpu->nz &   0xff) ? 0x00 : 0x02;	/* !cpu->nz [7:0]  -> reg->psr[1]   */
	reg->psr |= (cpu->nz & 0x8080) ? 0x80 : 0x00;	/*  cpu->nz [15,7] -> reg->psr[7]   */
}

