/*	
 *	bltml.h
 *
 *	BulletML
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2006 Naoyuki Sawa
 *
 *	* Mon Dec 04 18:17:17 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	  RgȂ̂ŁÂƏ\łB
 *	* Sun Dec 10 13:32:01 JST 2006 Naoyuki Sawa
 *	- NXKwύXAP܂B
 *	  <ύXO>
 *		BulletMLBase
 *		BulletMLNode
 *		BulletMLBullet
 *		BulletMLAction
 *		BulletMLValue
 *		@BulletMLNumber
 *		@BulletMLVar
 *		@BulletMLUnExpr
 *		@BulletMLBinExpr
 *	  <ύX>
 *		BulletMLNode
 *		BulletMLBullet
 *		BulletMLAction
 *		BulletMLValue
 *		BulletMLNumber
 *		BulletMLVar
 *		BulletMLUnExpr
 *		BulletMLBinExpr
 *	  ̂悤ɕύXŔAȉ̒ʂłB
 *	  EBulletMLBaseNXɂ͉zfXgN^`Ă炸A܂AhNXIuWFNgBulletMLBaseƂċʂɈʂAʂłB
 *	  EBulletMLBulletBulletMLAction͎sɕpɂɐAjJԂNXłAłAxサB
 *	  @q̕ύXɂABulletMLBulletBulletMLAction͉z֐ȂNXƂȂAeCX^XvptrsvƂȂAߖłB
 *	  @܂ABulletMLBulletBulletMLActioñRXgN^AfXgN^AsȂBulletMLBasẽRXgN^AfXgN^ĂяoԂȂB
 *	* Thu Dec 14 01:43:04 JST 2006 Naoyuki Sawa
 *	- RgǋL܂B
 *	  BulletMLUserFunc̊eR[obN֐dlɂẴRg܂Ȃ̂ŁÂƏ\łB
 *	  {Iɂ́AlibBulletML̃R[obN֐ƂقړdlłB
 *	  A(libBulletMLɂ)SimpleBullet̊TO͖Aׂ(libBulletMLɂ)ActiveBulletƂȂ܂B
 *	* Mon Feb 26 16:37:00 JST 2007 Naoyuki Sawa
 *	- _BulletMLValue_vtbl,_BulletMLNumber_vtbl,_BulletMLVar_vtbl,_BulletMLUnExpr_vtbl,_BulletMLBinExpr_vtblstaticO[oɕύX܂B
 *	  sXMLc[[ĥłȂAC\[XŒ`A[hԂߖ񂷂邽߂łB
 *	  AvP[VvOC\[Xō\̂`邽߂ɁAeVTBLQƂłKv邽߁Aq̂悤ȕύXs܂B
 *	  ڂ́Autool/bmlcnvvQƂĂB
 */
#ifndef __BLTML_H__
#define __BLTML_H__

/****************************************************************************
 *	o
 ****************************************************************************/
#if 0
/*--------------------------------------------------------------------------*/

AvP[VmKv̂\̂́ABulletMLNodeABulletMLBulletABulletMLUserFuncłB
̑̍\̂͑SēgpłAAvP[Vڗp邱Ƃ͂܂B

/*--------------------------------------------------------------------------*/

<bulletml>type=vertical/horizontaĺABulletML̂̏ɂ͈؉e^܂B
KvɉāAAvP[VBulletMLNode_getType()Ăяovertical/horizontal擾ApĂB(ʏ͕svł)

BulletMLK肵Ă邱Ƃ́A360ŕ\Ƃ݂̂ŁAǂ̕0ł邩A<accel>horizontal/verticalǂ̊pxɑ邩Ȃǂ́A؊֒m܂B
AvP[Vǂ̂悤ɌȂAłB

/*--------------------------------------------------------------------------*/

<bullet>̕<action>́ASēɋNs삵܂B
<action>̕<action>́Ȃ̃m[hƓlɁA삵܂B
ȏ́AIWiBulletML̋琄̂łAԂ񐳎ȎdlƎv܂B

1:
	<bullet>
		<action>
			@
		</action>
		<action>
			A
		</action>
	</bullet>

	@ƇAaction͓ɋNBulletMLActionAs삷B

2-1:
	<action>
		<action>
			@
		</action>
		<action>
			A
		</action>
	</action>

	@N``łĂAAN``łB

2-2:
	<action>
		<changeSpeed>
			@
		</changeSpeed>
		<action>
			A
		</action>
		<action>
			<action>
				B
			</action>
			<action>
				C
			</action>
		</action>
		<changeSpeed>
			D
		</changeSpeed>
	</action>

	@N``ŁAAN``ŁB
	̌ABƇCɋNB`ł̂҂BɊ`łĂÅ`ł҂B
	̌ADN``łB

/*--------------------------------------------------------------------------*/

createBullet()R[obN̒ŁAACT̎̂direction,speedi[BulletMLBullet_new()ĂяoƁA<bullet>directionspeedD悳܂B(@@)

: @@

	void myCreateBullet(void* userData, fixed direction, fixed speed, BulletMLNode* bulletNode, const fixed params[/*BULLETML_MAX_PARAMS*/]) {
		ACTP* actp;
		actp = createBulletAct();
		actp->direction = direction;	/* <fire>ɂw(܂̓ftHgl)ł */
		actp->speed = speed;		/* <fire>ɂw(܂̓ftHgl)ł */
		actp->bullet = BulletMLBullet_new(bulletUserFunc, actp, bulletNode, param);	/* <bullet>directionspeed̎w肪΁A̒ŃR[obN܂ */
	}

createBullet()R[obN̒ŁABulletMLBullet_new()ĂяoACT̎̂direction,speedi[ƁA<fire>directionspeedD悳܂B(@A)

: @A

	void myCreateBullet(void* userData, fixed direction, fixed speed, BulletMLNode* bulletNode, const fixed params[/*BULLETML_MAX_PARAMS*/]) {
		ACTP* actp;
		actp = createBulletAct();
		actp->bullet = BulletMLBullet_new(bulletUserFunc, actp, bulletNode, param);	/* <bullet>directionspeed̎w肪΁A̒ŃR[obN܂ */
		actp->direction = direction;	/* <fire>ɂw(܂̓ftHgl)ł */
		actp->speed = speed;		/* <fire>ɂw(܂̓ftHgl)ł */
	}


ȂȂAcreateBullet()R[obNɓndirectionspeed<fire>ɂ̂łA
<bullet>directionspeedw肳ĂABulletMLBullet_new()(Kvɉ)ɃR[obN邩łB
BulletMLBullet_new()̌ĂяoO<fire>directionspeedi[Ă΁AR[obNɂď㏑A<bullet>̐ݒ肪LƂȂ܂B
tɁABulletMLBullet_new()̌Ăяo<fire>directionspeedi[΁ABulletMLBullet_new()(KvɉĂ)R[obNɂĊi[<bullet>̐ݒ͏㏑A
<fire>̐ݒ肪LƂȂ킯łB

:
	<action>
		<fire>
			<speed>
			<direction>10</direction>		ccreateBullet()R[obNɉe
			<speed>20</speed>			ccreateBullet()R[obNɉe
			<bullet>
				<direction>30</direction>	cBulletMLBullet_new()setDirection()R[obN
				<speed>40</speed>		cBulletMLBullet_new()setSpeed()R[obN
			</bullet>
		</fire>
	</action>

IWiBulletML̋ł́A<fire><bullet>directionspeedw肳ĂꍇAO<fire>̎w肪LƂȂ悤łB
Ȃ킿AAvP[V`createBullet()R[obN֐@Â悤Ɏ΁AIWiBulletMLƓɂȂ܂B

q̎dldlȂ̂A邢͎ˑȂ̂AsłB
AvP[VɖmɂȂĂ΁Aǂ̕@IĂǂƎv܂B

/*--------------------------------------------------------------------------*/

createBullet()R[obN̒ŁAnꂽBulletMLNodeɑ΂BulletMLNode_getLabel()ĂяoAe̎ނ𔻕ʂ邱Ƃł܂B
ɂAЂƂcreateBullet()R[obNŕނ̒e̎̐ɑΉ邱Ƃł܂B
(̂悤ȏ́AK{ł͂܂Bʏ́AsvłB)

:
	void myCreateBullet(void* userData, fixed direction, fixed speed, BulletMLNode* bulletNode, const fixed params[/*BULLETML_MAX_PARAMS*/]) {
		const char* label = BulletMLNode_getLabel(bulletNode);
		ACT* actp;
		if(!strcmp(label, "missile")) {
			actp = createMissileAct();	/* ~TC\ACT쐬 */
			actp->bullet = BulletMLBullet_new(missileUserFunc, actp, bulletNode, param);
		} else if(!strcmp(label, "laser")) {
			actp = createLaserAct();	/* [U[\ACT쐬 */
			actp->bullet = BulletMLBullet_new(laserUserFunc, actp, bulletNode, param);
		} else {
			actp = createBulletAct();	/* ʏ̒e\ACT쐬 */
			actp->bullet = BulletMLBullet_new(bulletUserFunc, actp, bulletNode, param);
		}
	}

/*--------------------------------------------------------------------------*/
#endif
/****************************************************************************
 *	
 ****************************************************************************/

typedef struct _BulletMLNode BulletMLNode;
typedef struct _BulletMLBullet BulletMLBullet;
typedef struct _BulletMLAction BulletMLAction;
typedef struct _BulletMLValue BulletMLValue;
/**/typedef struct _BulletMLNumber BulletMLNumber;
/**/typedef struct _BulletMLVar BulletMLVar;
/**/typedef struct _BulletMLUnExpr BulletMLUnExpr;
/**/typedef struct _BulletMLBinExpr BulletMLBinExpr;

typedef struct _BulletMLValue_vtbl BulletMLValue_vtbl;
/**/typedef struct _BulletMLNumber_vtbl BulletMLNumber_vtbl;
/**/typedef struct _BulletMLVar_vtbl BulletMLVar_vtbl;
/**/typedef struct _BulletMLUnExpr_vtbl BulletMLUnExpr_vtbl;
/**/typedef struct _BulletMLBinExpr_vtbl BulletMLBinExpr_vtbl;

extern const BulletMLValue_vtbl _BulletMLValue_vtbl;
extern const BulletMLNumber_vtbl _BulletMLNumber_vtbl;
extern const BulletMLVar_vtbl _BulletMLVar_vtbl;
extern const BulletMLUnExpr_vtbl _BulletMLUnExpr_vtbl;
extern const BulletMLBinExpr_vtbl _BulletMLBinExpr_vtbl;

static inline BulletMLValue* BulletMLNumber_super (BulletMLNumber * This) { return (BulletMLValue*)This; }
static inline BulletMLValue* BulletMLVar_super    (BulletMLVar    * This) { return (BulletMLValue*)This; }
static inline BulletMLValue* BulletMLUnExpr_super (BulletMLUnExpr * This) { return (BulletMLValue*)This; }
static inline BulletMLValue* BulletMLBinExpr_super(BulletMLBinExpr* This) { return (BulletMLValue*)This; }

/* BulletMLNode.name */
enum {
	BULLETMLNODE_NAME_BULLETML,
	BULLETMLNODE_NAME_BULLET,
	BULLETMLNODE_NAME_ACTION,
	BULLETMLNODE_NAME_FIRE,
	BULLETMLNODE_NAME_CHANGEDIRECTION,
	BULLETMLNODE_NAME_CHANGESPEED,
	BULLETMLNODE_NAME_ACCEL,
	BULLETMLNODE_NAME_WAIT,
	BULLETMLNODE_NAME_VANISH,
	BULLETMLNODE_NAME_REPEAT,
	BULLETMLNODE_NAME_DIRECTION,
	BULLETMLNODE_NAME_SPEED,
	BULLETMLNODE_NAME_HORIZONTAL,
	BULLETMLNODE_NAME_VERTICAL,
	BULLETMLNODE_NAME_TERM,
	BULLETMLNODE_NAME_TIMES,
	BULLETMLNODE_NAME_BULLETREF,
	BULLETMLNODE_NAME_ACTIONREF,
	BULLETMLNODE_NAME_FIREREF,
	BULLETMLNODE_NAME_PARAM,
	BULLETMLNODE_NAME_COUNT,
};

/* BulletMLNode.type */
enum {
	BULLETMLNODE_TYPE_NONE,		/* bulletml */
	BULLETMLNODE_TYPE_VERTICAL,	/* bulletml */
	BULLETMLNODE_TYPE_HORIZONTAL,	/* bulletml */
	BULLETMLNODE_TYPE_AIM,		/* direction */
	BULLETMLNODE_TYPE_ABSOLUTE,	/* direction,speed,horizontal,vertical */
	BULLETMLNODE_TYPE_RELATIVE,	/* direction,speed,horizontal,vertical */
	BULLETMLNODE_TYPE_SEQUENCE,	/* direction,speed,horizontal,vertical */
	BULLETMLNODE_TYPE_COUNT,
};

#define BULLETML_MAX_PARAMS	9	/* <`Ref>t[̍ő<param> (BBulletML̎dlł͋K肳Ă܂) */

/****************************************************************************
 *	AvP[Vgp֐
 ****************************************************************************/

/* BulletML XMLt@C[hA܂́AXMLeLXgp[XAc[𐶐܂B
 * [in]
 *	filename_or_xmltext	XMLt@CA܂́AXMLeLXgB
 * [out]
 *	߂l			c[̃[g<bulletml>\BulletMLNodeB
 * [note]
 *	* svɂȂÅ֐ԂBulletMLNodeɑ΂BulletMLNode_delete()ĂяoA폜ĂB
 *	  IɘAāAc[Ŝ폜܂B
 *	  AvP[V́Ac[̓r̃m[hɑ΂āAځABulletMLNode_delete()ĂяoĂ͂܂B
 */
BulletMLNode* BulletML_load(const char* filename_or_xmltext);

/* BulletMLc[폜܂B
 * [note]
 *	- BulletML_load()̃RgQƂĂB
 */
//void BulletMLNode_delete(BulletMLNode* This);  Ő錾

/* e𐶐܂B
 * [in]
 *	userFunc	R[obN֐e[uB
 *			userFuncNULLw肷邱Ƃ͂ł܂񂪁AeGgNULLw肷邱Ƃ͂ł܂B
 *			NULLw肵GgɂẮAR[obN܂B
 *	userData	R[obNɈnAAvP[V`̔Cӂ̒lłB
 *			ʏ́Ae̎̂\(ACT*)|C^w肵ĂB
 *	bulletNode	AvP[V\Iɒe𐶐ꍇABulletML_load()Ԃꂽ<bulletml>\BulletMLNodew肵ĂB
 *			createBullet()R[obNɉĎ󓮓Iɒe𐶐ꍇAcreateBullet()ɓnꂽ<bullet>\BulletMLNodê܂܎w肵ĂB
 *	params		AvP[V\Iɒe𐶐ꍇANULLw肵ĂB
 *			createBullet()R[obNɉĎ󓮓Iɒe𐶐ꍇAcreateBullet()ɓnꂽparam̂܂܎w肵ĂB
 * [note]
 *	* svɂȂABulletMLBullet_delete()Ăяoč폜ĂB
 */
//BulletMLBullet* BulletMLBullet_new(const BulletMLUserFunc* userFunc, void* userData, BulletMLNode* bulletNode, const fixed params[/*BULLETML_MAX_PARAMS*/]/*NULL*/);  Ő錾

/* es܂B
 * [out]
 *	߂l		SĂActionAAchangeSpeedȂǂ̕ωSĊĂA0Ԃ܂B
 *			܂ĂȂ΁A0ȊO̒lԂ܂B
 * [note]
 *	* ʏ́ABulletMLBullet_run()0ԂƂɂāABulletANV̏IoABulletMLBullet_delete()ĂяoĂB
 *	  ABulletANV̏IɁAKBulletMLBullet_delete()ĂяoKv͂܂B
 *	  BulletANVIɌJԂBulletMLBullet_run()ĂяoĂA0Ԃ܂B
 */
//int BulletMLBullet_run(BulletMLBullet* This);  Ő錾

/* e폜܂B
 * [note]
 *	- BulletMLBullet_new()BulletMLBullet_run()̃RgQƂĂB
 */
//void BulletMLBullet_delete(BulletMLBullet* This);  Ő錾

/****************************************************************************
 *	BulletMLNode
 ****************************************************************************/

/* BulletMLXMLvf\NXłB
 * - ^C~O:
 *	Q[ɁABulletML_load()ĂяoɂĐ܂B
 *	BulletML_load()̖߂l<bulletml>\BulletMLNodełAqvf̃c[Ă܂B
 *	Q[ɂЂςɁABulletMLNodẽCX^X𐶐邱Ƃ͂܂B
 * - Ń^C~O:
 *	Q[N[AbvɁA<bulletml>\BulletMLNodeɑ΂BulletMLNode_delete()̌Ăяoɂďł܂B
 *	qvf̃c[ׂĘAďł܂B
 *	Q[ɂЂςɁABulletMLNodẽCX^Xł邱Ƃ͂܂B
 */
struct _BulletMLNode {
	int name;			/* vf */
	int type;			/* type  (bulletml,direction,speed,horizontal,vertical) */
	StdString* label;		/* label (bullet,bulletRef,action,actionRef,fire,fireRef) */
	BulletMLNode* ref;		/* QƐ    (bulletRef,actionRef,fireRef) */
	BulletMLValue* value;		/* l        (wait,direction,speed,horizontal,vertical,term,times,param) */
	BulletMLNode* firstChild;	/* 擪̎qm[h */
	BulletMLNode* nextSibling;	/* ̌Zm[h */
	/*BulletMLNode*/
};

BulletMLNode* BulletMLNode_new(const char* name);
void BulletMLNode_delete(BulletMLNode* This);
void _BulletMLNode_construct(BulletMLNode* This, const char* name);
void _BulletMLNode_destruct(BulletMLNode* This);
/*public:*/
int BulletMLNode_getName(BulletMLNode* This);
void BulletMLNode_setType(BulletMLNode* This, const char* type);
int BulletMLNode_getType(BulletMLNode* This);
void BulletMLNode_setLabel(BulletMLNode* This, const char* label);
const char* BulletMLNode_getLabel(BulletMLNode* This);
void BulletMLNode_setRef(BulletMLNode* This, BulletMLNode* ref);
BulletMLNode* BulletMLNode_getRef(BulletMLNode* This);
void BulletMLNode_setValue(BulletMLNode* This, const char* value);
BulletMLValue* BulletMLNode_getValue(BulletMLNode* This);
BulletMLNode* BulletMLNode_firstChild(BulletMLNode* This);
BulletMLNode* BulletMLNode_nextSibling(BulletMLNode* This);
void BulletMLNode_addChild(BulletMLNode* This, BulletMLNode* child);
BulletMLNode* BulletMLNode_getChild(BulletMLNode* This, int name);
void BulletMLNode_dump(BulletMLNode* This, int indent);

/****************************************************************************
 *	BulletMLBullet
 ****************************************************************************/

/* [U[`̃R[obN֐e[u\\̂łB
 * AvP[VɂĒ`ABulletMLBullet_new()ĂяoɎw肵ĂB
 * eR[obN֐̓ANULLw肵̂ɂẮAR[obN܂B
 * <!!>
 * - BulletMLBulletBulletMLUserFuncRs[A|C^݂̂ێ܂B
 *   AvP[V́ABulletMLBullet_new()ĂяoABulletMLUserFunc̓eێĂB
 *   ʏABulletMLUserFunc̓e𓮓IɏEύXKv͖͂Ȃ̂ŁA萔f[^̈ɒ`̂K؂łB
 */
typedef struct _BulletMLUserFunc {
	void (*createBullet)(void* userData, fixed direction, fixed speed, BulletMLNode* bulletNode, const fixed params[/*BULLETML_MAX_PARAMS*/]);
	void (*setDirection)(void* userData, fixed direction);
	void (*setSpeed)(void* userData, fixed speed);
	void (*setAccelH)(void* userData, fixed accelH);
	void (*setAccelV)(void* userData, fixed accelV);
	void (*vanish)(void* userData);
	fixed (*getRand)(void* userData);
	fixed (*getRank)(void* userData);
	fixed (*getAimDirection)(void* userData);
	fixed (*getDirection)(void* userData);
	fixed (*getSpeed)(void* userData);
	fixed (*getAccelH)(void* userData);
	fixed (*getAccelV)(void* userData);
} BulletMLUserFunc;

/* direction,speed,accel̕ωǗ邽߂ɁAgp\̂łB
 */
typedef struct _BulletMLChange {
	/* <changeDirection|changeSpeed|accel>p */
	fixed start;	/* l */
	fixed diff;	/* ω */
	int term;	/*  */
	int cnt;	/* oߎ */
	/* <direction|speed|horizontal|vertical type="sequence">p */
	fixed prev;	/* Ol */
} BulletMLChange;

/* <bulletml>܂<bullet>\BulletMLNodeɍ쐬ꂽABulletCX^XłB
 * - ^C~O:
 *	Q[sɃAvP[VA\I<bulletml>\BulletMLNodew肵BulletMLBullet_new()ĂяoĐ܂B
 *	܂́ABulletMLUserFunc.createBullet()R[obNɉāA󓮓I<bullet>\BulletMLNodew肵BulletMLBullet_new()ĂяoĐ܂B
 * - Ń^C~O:
 *	ǂ̕@ŐꍇAAvP[V̔fɂCӂ̃^C~OŁABulletMLBullet_delete()Ăяoďł܂B
 *	ʏ́ABulletMLBullet_run()0ԂƂɂāABulletANV̏IoABulletMLBullet_delete()ĂяoĂB
 *	q͕̏K{ł͂ȂABulletANVIĂȂĂAAvP[V̔fɂĂłBulletMLBullet_delete()Ăяoč\܂B
 *	Ƃ΁ABulletANVisłAeʊOɊOȂǒêłBulletMLBulletsvɂȂ܂̂ŁABulletMLBullet_delete()Ăяo܂B
 */
struct _BulletMLBullet {
	const BulletMLUserFunc* userFunc;	/* [U[`̃R[obN֐e[u */
	void* userData;				/* [U[`̃R[obNf[^ */
	fixed params[BULLETML_MAX_PARAMS];	/* ߂<`Ref>t[<param>l */
	BulletMLChange direction;		/* direction̕ωǗ */
	BulletMLChange speed;			/* speed̕ωǗ */
	BulletMLChange accelH;			/* accel horizontal̕ωǗ */
	BulletMLChange accelV;			/* accel vertical̕ωǗ */
	BulletMLAction* firstAction;		/* 擪̎qANVBBulletMLAction.nextSibling֒Hăc[\ (NOTE: <bullet>̒ɕ̎q<action>ꍇASēɋNs삵܂!!) */
	/*BulletMLBullet*/
};

BulletMLBullet* BulletMLBullet_new(const BulletMLUserFunc* userFunc, void* userData, BulletMLNode* bulletNode, const fixed params[/*BULLETML_MAX_PARAMS*/]/*NULL*/);
void BulletMLBullet_delete(BulletMLBullet* This);
void _BulletMLBullet_construct(BulletMLBullet* This, const BulletMLUserFunc* userFunc, void* userData, BulletMLNode* bulletNode, const fixed params[/*BULLETML_MAX_PARAMS*/]/*NULL*/);
void _BulletMLBullet_destruct(BulletMLBullet* This);
/*public:*/
const BulletMLUserFunc* BulletMLBullet_getUserFunc(BulletMLBullet* This);
void* BulletMLBullet_getUserData(BulletMLBullet* This);
int BulletMLBullet_run(BulletMLBullet* This);

/****************************************************************************
 *	BulletMLAction
 ****************************************************************************/

/* <action>\BulletMLNodeɍ쐬ꂽAActionCX^XłB
 * - ^C~O:
 *	Q[sɃAvP[VA\I܂͎󓮓IBulletMLBullet_new()ĂяoƂAсABulletMLBullet_run()ĂяoƂɁA̓ō쐬܂B
 *	AvP[VAActionCX^X̐^C~OӎKv͂܂B
 * - Ń^C~O:
 *	Q[sɃAvP[VBulletMLBullet_run()ĂяoƂɁA̓ActionAIɏł܂B
 *	܂́AAvP[VBulletMLBullet_delete()ĂяoƂɁAsActioncĂAs𒆒fĎIɏł܂B
 *	AvP[VAActionCX^X̏Ń^C~OӎKv͂܂B
 */
struct _BulletMLAction {
	fixed params[BULLETML_MAX_PARAMS];	/* ߂<`Ref>t[<param>l */
	BulletMLBullet* bullet;			/* <action>e<bullet>BANV̏̃^[QbgƂȂ܂ */
	BulletMLNode* pc;			/* Ɏsm[h */
	int wait;				/* <wait>p */
	int repeat;				/* <repeat><times>p */
	BulletMLAction* childAction;		/* 쒆̎qANVA܂́A쒆̎qANVNULL (NOTE: <action>̒ɕ̎q<action>ꍇÃm[hƓlɒ삵܂!!) */
	BulletMLAction* nextSibling;		/* <bullet>̎̕q<action>̃NpBBulletMLBullet.firstActionHăc[\ */
	/*BulletMLAction*/
};

BulletMLAction* BulletMLAction_new(BulletMLBullet* bullet, BulletMLNode* actionNode, const fixed params[/*BULLETML_MAX_PARAMS*/]);
void BulletMLAction_delete(BulletMLAction* This);
void _BulletMLAction_construct(BulletMLAction* This, BulletMLBullet* bullet, BulletMLNode* actionNode, const fixed params[/*BULLETML_MAX_PARAMS*/]);
void _BulletMLAction_destruct(BulletMLAction* This);
/*public:*/
int BulletMLAction_run(BulletMLAction* This);

/****************************************************************************
 *	BulletMLValue
 ****************************************************************************/

/* ␔lȂǂ̒ۊNXłB
 */
struct _BulletMLValue {
	const BulletMLValue_vtbl* vptr;
	/*BulletMLValue*/
};

struct _BulletMLValue_vtbl {
	void (*destruct)(BulletMLValue* This);
	fixed (*calc)(BulletMLValue* This, const fixed params[/*BULLETML_MAX_PARAMS*/], const BulletMLUserFunc* userFunc, void* userData); /*=0*/
	void (*dump)(BulletMLValue* This); /*=0*/
	/*BulletMLValue_vtbl*/
};

//BulletMLValue* BulletMLValue_new(); hNX̂ݐ
void BulletMLValue_delete(BulletMLValue* This);
void _BulletMLValue_construct(BulletMLValue* This);
/*virtual*/ void _BulletMLValue_destruct(BulletMLValue* This);

/****************************************************************************
 *	BulletMLNumber
 ****************************************************************************/

/* l\܂B
 */
struct _BulletMLNumber /*:BulletMLValue*/ {
	const BulletMLNumber_vtbl* vptr;
	/*BulletMLValue*/
	fixed value;
	/*BulletMLNumber*/
};

struct _BulletMLNumber_vtbl {
	void (*destruct)(BulletMLNumber* This);
	fixed (*calc)(BulletMLNumber* This, const fixed params[/*BULLETML_MAX_PARAMS*/], const BulletMLUserFunc* userFunc, void* userData);
	void (*dump)(BulletMLNumber* This);
	/*BulletMLValue_vtbl*/
	/*BulletMLNumber_vtbl*/
};

BulletMLNumber* BulletMLNumber_new(const char** pp);
void BulletMLNumber_delete(BulletMLNumber* This);
void _BulletMLNumber_construct(BulletMLNumber* This, const char** pp);
/*virtual*/ void _BulletMLNumber_destruct(BulletMLNumber* This);
/*public:*/
/*virtual*/ fixed _BulletMLNumber_calc(BulletMLNumber* This, const fixed params[/*BULLETML_MAX_PARAMS*/], const BulletMLUserFunc* userFunc, void* userData);
/*virtual*/ void _BulletMLNumber_dump(BulletMLNumber* This);

/****************************************************************************
 *	BulletMLVar
 ****************************************************************************/

/* ϐ($1`$9,$rand,$rank)\܂B
 */
struct _BulletMLVar /*:BulletMLValue*/ {
	const BulletMLVar_vtbl* vptr;
	/*BulletMLValue*/
	int id;			/* -1 = $rand, -2 = $rank, 0`8 = $1`$9 */
	/*BulletMLVar*/
};

struct _BulletMLVar_vtbl {
	void (*destruct)(BulletMLVar* This);
	fixed (*calc)(BulletMLVar* This, const fixed params[/*BULLETML_MAX_PARAMS*/], const BulletMLUserFunc* userFunc, void* userData);
	void (*dump)(BulletMLVar* This);
	/*BulletMLValue_vtbl*/
	/*BulletMLVar_vtbl*/
};

BulletMLVar* BulletMLVar_new(const char** pp);
void BulletMLVar_delete(BulletMLVar* This);
void _BulletMLVar_construct(BulletMLVar* This, const char** pp);
/*virtual*/ void _BulletMLVar_destruct(BulletMLVar* This);
/*public:*/
/*virtual*/ fixed _BulletMLVar_calc(BulletMLVar* This, const fixed params[/*BULLETML_MAX_PARAMS*/], const BulletMLUserFunc* userFunc, void* userData);
/*virtual*/ void _BulletMLVar_dump(BulletMLVar* This);

/****************************************************************************
 *	BulletMLUnExpr
 ****************************************************************************/

/* PZq(-)\܂B
 */
struct _BulletMLUnExpr /*:BulletMLValue*/ {
	const BulletMLUnExpr_vtbl* vptr;
	/*BulletMLValue*/
	int op;
	BulletMLValue* value;
	/*BulletMLUnExpr*/
};

struct _BulletMLUnExpr_vtbl {
	void (*destruct)(BulletMLUnExpr* This);
	fixed (*calc)(BulletMLUnExpr* This, const fixed params[/*BULLETML_MAX_PARAMS*/], const BulletMLUserFunc* userFunc, void* userData);
	void (*dump)(BulletMLUnExpr* This);
	/*BulletMLValue_vtbl*/
	/*BulletMLUnExpr_vtbl*/
};

BulletMLUnExpr* BulletMLUnExpr_new(int op, BulletMLValue* value);
void BulletMLUnExpr_delete(BulletMLUnExpr* This);
void _BulletMLUnExpr_construct(BulletMLUnExpr* This, int op, BulletMLValue* value);
/*virtual*/ void _BulletMLUnExpr_destruct(BulletMLUnExpr* This);
/*public:*/
/*virtual*/ fixed _BulletMLUnExpr_calc(BulletMLUnExpr* This, const fixed params[/*BULLETML_MAX_PARAMS*/], const BulletMLUserFunc* userFunc, void* userData);
/*virtual*/ void _BulletMLUnExpr_dump(BulletMLUnExpr* This);

/****************************************************************************
 *	BulletMLBinExpr
 ****************************************************************************/

/* 񍀉Zq(+,-,*,/,%)\܂B
 */
struct _BulletMLBinExpr /*:BulletMLValue*/ {
	const BulletMLBinExpr_vtbl* vptr;
	/*BulletMLValue*/
	int op;
	BulletMLValue* lhs;
	BulletMLValue* rhs;
	/*BulletMLBinExpr*/
};

struct _BulletMLBinExpr_vtbl {
	void (*destruct)(BulletMLBinExpr* This);
	fixed (*calc)(BulletMLBinExpr* This, const fixed params[/*BULLETML_MAX_PARAMS*/], const BulletMLUserFunc* userFunc, void* userData);
	void (*dump)(BulletMLBinExpr* This);
	/*BulletMLValue_vtbl*/
	/*BulletMLBinExpr_vtbl*/
};

BulletMLBinExpr* BulletMLBinExpr_new(int op, BulletMLValue* lhs, BulletMLValue* rhs);
void BulletMLBinExpr_delete(BulletMLBinExpr* This);
void _BulletMLBinExpr_construct(BulletMLBinExpr* This, int op, BulletMLValue* lhs, BulletMLValue* rhs);
/*virtual*/ void _BulletMLBinExpr_destruct(BulletMLBinExpr* This);
/*public:*/
/*virtual*/ fixed _BulletMLBinExpr_calc(BulletMLBinExpr* This, const fixed params[/*BULLETML_MAX_PARAMS*/], const BulletMLUserFunc* userFunc, void* userData);
/*virtual*/ void _BulletMLBinExpr_dump(BulletMLBinExpr* This);

#endif /*__BLTML_H__*/
