/*	
 *	frampsg.h
 *
 *	P/ECE PSG(AY-3-8910) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Nov 22 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 26 12:30:00 JST 2003 Naoyuki Sawa
 *	- Gx[vWFl[^܂AƉm܂B
 *	  KbMedia PlayerƒrׂƁAGx[v{炢x悤ȋC܂B
 *	  vZ͍ĂƎv̂łc()
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

void
psg_mix(PSG* psg, short wbuff[/*PSGBUFLEN*/])
{
	static char mixbuf[PSGBUFLEN]; /* ~LVOobt@Ars`shbłI */

	PSGINFO info;
	PSGCHANNEL* channel;
	unsigned char* preg;
	         char* pmix;
	        short* pout;
	int i, n1, n2, i_channel, volume, envelope_volume;
	int progress, dda_d, dda_f;
	div_t dda_v;

	/* ܂A~LVOobt@NA܂B */
	memset(mixbuf, 0, sizeof mixbuf);

	/* PSGWX^ǂݍ݂܂B */
	preg = psg->reg;
	/* [R0-1] */
	n1 = *preg++;
	n2 = *preg++;
	info.channel[0].tone_period = n1 | (n2 & 0x0f) << 8;
	/* [R2-3] */
	n1 = *preg++;
	n2 = *preg++;
	info.channel[1].tone_period = n1 | (n2 & 0x0f) << 8;
	/* [R4-5] */
	n1 = *preg++;
	n2 = *preg++;
	info.channel[2].tone_period = n1 | (n2 & 0x0f) << 8;
	/* [R6] */
	n1 = *preg++;
	info.noise_period = n1 & 0x1f;
	/* [R7] */
	n1 = *preg++;
	info.channel[0].tone_noise_enable = !(n1 & 0x01) | !(n1 & 0x08) << 1; /* v!![R7]̃rbg0:ON/1:OFFł */
	info.channel[1].tone_noise_enable = !(n1 & 0x02) | !(n1 & 0x10) << 1; /* v!![R7]̃rbg0:ON/1:OFFł */
	info.channel[2].tone_noise_enable = !(n1 & 0x04) | !(n1 & 0x20) << 1; /* v!![R7]̃rbg0:ON/1:OFFł */
	/* [R8] */
	n1 = *preg++;
	info.channel[0].amplitude_mode = (n1 & 0x10) >> 4;
	info.channel[0].amplitude_level = n1 & 0x0f;
	/* [R9] */
	n1 = *preg++;
	info.channel[1].amplitude_mode = (n1 & 0x10) >> 4;
	info.channel[1].amplitude_level = n1 & 0x0f;
	/* [R10] */
	n1 = *preg++;
	info.channel[2].amplitude_mode = (n1 & 0x10) >> 4;
	info.channel[2].amplitude_level = n1 & 0x0f;
	/* [R11-12] */
	n1 = *preg++;
	n2 = *preg++;
	info.envelope_period = n1 | n2 << 8;
	/* [R13] */
	n1 = *preg++;
	info.envelope_shape_cycle = n1 & 0x0f;

	/* Gx[v{[vZB
	 * PSGdlFGx[vg̓NbN256Gx[vsIhl
	 */
	/*{{DDA*/
	progress = psg->envelope_progress;
	dda_d = psg->envelope_dda_d;
	dda_f = ((info.envelope_period ? info.envelope_period : 1) * 50/*荞݃TCN*/) << 8;
	dda_v = div(psg->clock * 16/*Gx[vg`TCY*/, dda_f);
	/*}}DDA*/
	envelope_volume = progress & 15;
	if(info.envelope_shape_cycle & 1/*Hold*/) {
		if(progress >= 16) {
			progress = 16;
			envelope_volume = 15;
		}
	}
	if(info.envelope_shape_cycle & 2/*Alternate*/) {
		if(progress & 16) {
			envelope_volume ^= 15;
		}
	}
	if(!(info.envelope_shape_cycle & 4/*Attack*/)) {
		envelope_volume ^= 15;
	}
	if(!(info.envelope_shape_cycle & 8/*Continue*/)) {
		if(progress >= 16) {
			envelope_volume = 0;
		}
	}
	/*{{DDAXebv*/
	progress += dda_v.quot;
	dda_d += dda_v.rem;
	if(dda_d >= 0) {//while(dda_d >= 0) {
		dda_d -= dda_f;
		progress++;
	}
	/*}}DDAXebv*/
	/*{{DDAЕt*/
	psg->envelope_progress = progress;
	psg->envelope_dda_d = dda_d;
	/*}}DDAЕt*/

	/* g[B
	 * PSGdlFg[g̓NbN16g[sIhl
	 */
	for(i_channel = 0, channel = info.channel; i_channel < 3; i_channel++, channel++) {
		if(channel->tone_noise_enable & 1/*TONE*/) {
			volume = !channel->amplitude_mode ? channel->amplitude_level : envelope_volume;
			/*{{DDA*/
			progress = psg->tone_progress[i_channel];
			dda_d = psg->tone_dda_d[i_channel];
			dda_f = ((channel->tone_period ? channel->tone_period : 1) * SPEAKER_FREQUENCY) << 4;
			dda_v = div(psg->clock * 2/*g[g`TCY*/, dda_f);
			/*}}DDA*/
			for(i = 0, pmix = mixbuf; i < PSGBUFLEN; i++, pmix++) {
				if(progress & 1) {
					*pmix += volume;
				} else {
					*pmix -= volume;
				}
				/*{{DDAXebv*/
				progress += dda_v.quot;
				dda_d += dda_v.rem;
				if(dda_d >= 0) {//while(dda_d >= 0) {
					dda_d -= dda_f;
					progress++;
				}
				/*}}DDAXebv*/
			}
			/*{{DDAЕt*/
			psg->tone_progress[i_channel] = progress;
			psg->tone_dda_d[i_channel] = dda_d;
			/*}}DDAЕt*/
		}
	}

	/* mCYB
	 * PSGdlFmCYώg̓NbN16mCYsIhl
	 */
	volume = 0;
	for(i_channel = 0, channel = info.channel; i_channel < 3; i_channel++, channel++) {
		if(channel->tone_noise_enable & 2/*NOISE*/) {
			volume += !channel->amplitude_mode ? channel->amplitude_level : envelope_volume;
		}
	}
	if(volume) {
		/*{{DDA*/
		progress = psg->noise_progress;
		dda_d = psg->noise_dda_d;
		dda_f = ((info.noise_period ? info.noise_period : 1) * SPEAKER_FREQUENCY) << 4;
		dda_v = div(psg->clock * 256/*mCYe[uTCY*/, dda_f);
		/*}}DDA*/
		for(i = 0, pmix = mixbuf; i < PSGBUFLEN; i++, pmix++) {
			*pmix += (psg_noise_table[progress & 0xff/*mCYe[uTCY-1*/] * volume) >> 7; /* TODO: SHORT~SHORTɂč */
			/*{{DDAXebv*/
			progress += dda_v.quot;
			dda_d += dda_v.rem;
			if(dda_d >= 0) {//while(dda_d >= 0) {
				dda_d -= dda_f;
				progress++;
			}
			/*}}DDAXebv*/
		}
		/*{{DDAЕt*/
		psg->noise_progress = progress;
		psg->noise_dda_d = dda_d;
		/*}}DDAЕt*/
	}

	/* ~LVOobt@(32rbg)o̓obt@(16rbg)փRs[܂B */
	for(i = 0, pmix = mixbuf, pout = wbuff; i < PSGBUFLEN; i++, pmix++, pout++) {
		volume = *pmix << 10;	/* 32767/(15*3)=728=>1024A */
		     if(volume < -32767) volume = -32767;
		else if(volume >  32767) volume =  32767;
		*pout = volume;
	}
}
