/*	
 *	clippsg.c
 *
 *	P/ECE PSG(AY-3-8910) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Nov 22 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

/* mCYWFl[^e[u */
const char psg_noise_table[256] = {
	'\x37','\x4a','\xab','\x8e','\xfe','\x31','\x2d','\x1c','\xc7','\x1e','\xd0','\x47','\x9e','\x4e','\xbd','\xea',
	'\xcd','\x3b','\x62','\x22','\xe2','\xa3','\x6a','\x49','\xa8','\x82','\xc1','\xfd','\x2b','\x12','\x93','\x19',
	'\xb8','\xd1','\x4d','\xba','\xda','\x7a','\x9a','\x3a','\x5d','\x09','\x66','\x37','\x4d','\xba','\xdd','\x8c',
	'\xf7','\x0a','\x6c','\x56','\xe5','\xb4','\xbe','\xef','\xe5','\xb4','\xbf','\xf5','\x03','\x47','\x9c','\x43',
	'\x89','\xe8','\xbf','\xf6','\x05','\x53','\xd6','\x68','\x42','\x84','\xcc','\x37','\x4c','\xb7','\xce','\x3e',
	'\x70','\x69','\x46','\x9a','\x39','\x55','\xe2','\xa5','\x73','\x77','\x8e','\xfd','\x2a','\x0c','\x74','\x7d',
	'\xab','\x8f','\x02','\x41','\x80','\xbc','\xe3','\xa6','\x78','\x8f','\x03','\x47','\x9c','\x44','\x8e','\x00',
	'\x39','\x58','\xf1','\xed','\xdc','\x86','\xd7','\x6b','\x50','\xca','\x2c','\x15','\xa2','\x61','\x1c','\xc7',
	'\x1c','\xc5','\x14','\x9d','\x4c','\xb4','\xbf','\xf4','\xfd','\x2a','\x09','\x67','\x3b','\x61','\x1f','\xd2',
	'\x53','\xd7','\x6b','\x51','\xd0','\x47','\x9b','\x41','\x7e','\xad','\x9a','\x3d','\x69','\x46','\x95','\x21',
	'\xdd','\x8c','\xf6','\x09','\x67','\x3d','\x6b','\x52','\xd2','\x54','\xe0','\x97','\x2b','\x0e','\x7f','\xb4',
	'\xbc','\xe6','\xb6','\xc5','\x13','\x98','\x30','\x27','\xfb','\x20','\xd9','\x75','\x80','\xba','\xdd','\x8b',
	'\xef','\xe3','\xa9','\x85','\xd3','\x56','\xe8','\xc0','\xf8','\x0f','\x86','\xd7','\x6a','\x4b','\xaf','\xa6',
	'\x76','\x85','\xd0','\x49','\xa6','\x79','\x94','\x1d','\xc8','\x23','\xe7','\xbd','\xe8','\xbf','\xf6','\x05',
	'\x50','\xca','\x2b','\x11','\x8e','\xff','\x34','\x3e','\x6d','\x5a','\xfc','\x26','\xf9','\x18','\xb0','\xa8',
	'\x7f','\xb3','\xba','\xdd','\x8a','\xe9','\xc8','\x23','\xe6','\xb6','\xc5','\x14','\x9f','\x54','\xde','\x8f',
};

/****************************************************************************
 *
 ****************************************************************************/

void
psg_reset(PSG* psg, int clock)
{
	/* ܂ASăNAB */
	memset(psg, 0, sizeof(PSG));

	/* ̓NbNi[B */
	psg->clock = clock;
}

void
psg_reg(PSG* psg, unsigned char regno)
{
	/* WX^IB */
	psg->regno = regno & 0xf;
}

unsigned char
psg_read(PSG* psg)
{
	/* WX^ǂݍ݁B */
	return psg->reg[psg->regno];
}

void
psg_write(PSG* psg, unsigned char data)
{
	/* WX^݁B */
	psg->reg[psg->regno] = data;

	/* R13=>Gx[vZbgB */
	if(psg->regno == 13) psg->envelope_progress = 0;
}

