/*
 *	dsrf2rom - SRF to ROMC[W Ro[^
 *	Copyright (C) 2003 Naoyuki Sawa
 *
 *	* Sat Sep 13 22:29:00 JST 2003 Naoyuki Sawa
 *	- 1st [XB
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "srf33.h"

#define VERSION	"20030913"

/****************************************************************************
 *	
 ****************************************************************************/

char srf_path[_MAX_PATH];	/* srft@C̃pX */
char rom_path[_MAX_PATH];	/* oromt@C̃pX */

unsigned int top;	/* ROMC[WJnAhX     */
unsigned int end;	/* ROMC[WIAhX(+1) */
unsigned char* rom;	/* ROMC[W */

void usage();
void cmdline(int argc, char* argv[]);
void load_srf();
void save_rom();

/****************************************************************************
 *	main
 ****************************************************************************/

int
main(int argc, char* argv[])
{
	/* \̂̃oCgACgRpCĂ邱ƂmFB */
	if(sizeof(SRF33_CONTROL_HEADER     ) != SIZEOF_SRF33_CONTROL_HEADER     ) abort();
	if(sizeof(SRF33_SECTION_INFORMATION) != SIZEOF_SRF33_SECTION_INFORMATION) abort();

	/* R}hĆB */
	cmdline(argc, argv);

	/* srft@CǂݍށB */
	load_srf();

	/* romt@CށB */
	save_rom();

	return 0;
}

/****************************************************************************
 *	usage
 ****************************************************************************/

void
usage()
{
	fprintf(stderr, "dsrf2rom - SRF to ROMimage converter (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2003 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "    dsrf2rom <filename[.srf]>\n");
	exit(1);
}

/****************************************************************************
 *	cmdline
 ****************************************************************************/

void
cmdline(int argc, char* argv[])
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];

	if(argc != 1 + 1) usage();

	/* o̓t@C̃pX擾B */
	_splitpath(argv[1], drive, dir, fname, ext);
	if(!*ext) strcpy(ext, ".srf"); /* ̓t@C̊gqȗĂ".srf"₤ */
	_makepath(srf_path, drive, dir, fname, ext);
	_makepath(rom_path, drive, dir, fname, ".rom"); /* o̓t@C̊gq".rom"Œ */
}

/****************************************************************************
 *	load_srf
 ****************************************************************************/

void
load_srf()
{
	int retval;
	unsigned int scnptr, scntyp, off, rdptr, dsiz;
	FILE* fp;
	SRF33_CONTROL_HEADER ch;
	SRF33_SECTION_INFORMATION si;

	printf("%sǂݍ݂܂...\n", srf_path);

	/* t@CJB */
	fp = fopen(srf_path, "rb");
	if(!fp) {
		fprintf(stderr, "srft@CJ܂B\n");
		exit(1);
	}

	/* srf33wb_ǂݍށB */
	retval = fread(&ch, 1, SIZEOF_SRF33_CONTROL_HEADER, fp);
	if(retval != SIZEOF_SRF33_CONTROL_HEADER) {
		fprintf(stderr, "srf33wb_ǂݍ߂܂B\n");
		exit(1);
	}

	/* ŏ̃ZNVւ̃`FCB */
	scnptr = SRF33_WORD(ch.c_scnptr);

	/* ZNV`FC̏I[ɒB܂... */
	while(scnptr) {
		/* ZNVǂݍށB */
		retval = fseek(fp, scnptr, SEEK_SET);
		if(retval) {
			fprintf(stderr, "ZNVփV[Nł܂B\n");
			exit(1);
		}
		retval = fread(&si, 1, SIZEOF_SRF33_SECTION_INFORMATION, fp);
		if(retval != SIZEOF_SRF33_SECTION_INFORMATION) {
			fprintf(stderr, "ZNV񂪓ǂݍ߂܂B\n");
			exit(1);
		}

		/* ZNV񂩂KvȃtB[h擾B */
		scnptr = SRF33_WORD(si.s_nxptr );
		scntyp = SRF33_HALF(si.s_scntyp);
		off    = SRF33_WORD(si.s_off   );
		rdptr  = SRF33_WORD(si.s_rdptr );
		dsiz   = SRF33_WORD(si.s_dsiz  );
		if(dsiz) { /* f[^TCY0̃ZNV̓XLbv */
			/* ZNV\B */
			switch(scntyp) {
			case 1: printf("  CODE: "); break;
			case 2: printf("  DATA: "); break;
			case 3: printf("  BSS : "); break;
			case 4: printf("  а: "); break;
			default:
				fprintf(stderr, "sȃZNV^CvłB\n");
				exit(1);
			}
			printf("%07x - %07x\n", off, off + dsiz - 1);

			/* CODEDATAZNVȊO̓XLbvB */
			switch(scntyp) {
			case 1: break;
			case 2: break;
			default: continue;
			}

			/* f[^ǂ݂ނ߂̃mہB */
			if(!top) {
				top = off;
			} else {
				if(off < top) {
					fprintf(stderr, "ZNV̐擪AhXނĂ܂B\n");
					exit(1);
				}
				if(off < end) {
					fprintf(stderr, "ZNṼAhX͈͂dĂ܂B\n");
					exit(1);
				}
			}
			end = off + dsiz;
			rom = realloc(rom, end - top);
			if(rom == NULL) {
				fprintf(stderr, "ZNVǂݍނ߂̃mۂł܂B\n");
				exit(1);
			}

			/* f[^ǂݍށB */
			retval = fseek(fp, rdptr, SEEK_SET);
			if(retval) {
				fprintf(stderr, "f[^փV[Nł܂B\n");
				exit(1);
			}
			retval = fread(rom + (off - top), 1, dsiz, fp);
			if(retval != (int)dsiz) {
				fprintf(stderr, "f[^ǂݍ߂܂B\n");
				exit(1);
			}
		}
	}

	/* t@CB */
	fclose(fp);
}

/****************************************************************************
 *	save_rom
 ****************************************************************************/

void
save_rom()
{
	int retval;
	FILE* fp;

	printf("%s쐬܂...\n", rom_path);

	/* t@C쐬B */
	fp = fopen(rom_path, "wb");
	if(!fp) {
		fprintf(stderr, "romt@C쐬ł܂B\n");
		exit(1);
	}

	/* ROM\B */
	printf("  ROM : %07x - %07x\n", top, end - 1);

	/* ROMC[WށB */
	retval = fwrite(rom, 1, end - top, fp);
	if(retval != (int)(end - top)) {
		fprintf(stderr, "ROMC[W߂܂B\n");
		exit(1);
	}

	/* t@CB */
	fclose(fp);
}
