/*
 *	dlzss12 - LZSS compression tool
 *	Copyright (C) 2009 Naoyuki Sawa
 *
 *	* Wed Aug 26 12:44:29 JST 2009 Naoyuki Sawa
 *	- 1st [XB
 *	* Wed Aug 26 17:57:00 JST 2009 Naoyuki Sawa
 *	- k菇PA܂B
 *	  ܂ł́Aobt@ňksȂĈkTCY߂Akobt@ĊmۂāAĈksȂĂ܂B
 *	  ̂߁Aɓ{̈kԂĂ܂Ă܂B
 *	  ̕ύXŁA܂kƓTCYňkobt@mۂĈkAk100%߂Ńobt@sƂȂꍇ̂݁A
 *	  ۂɕKvȃTCŸkobt@ĊmۂAĈksȂ悤ύX܂B
 *	  قƂǂ̏ꍇ͈k100%ȉBł̂ŁAقƂǂ̏ꍇ͈k񕪂̎Ԃōςނ悤ɂȂ܂B
 *	* Thu Aug 27 02:34:30 JST 2009 Naoyuki Sawa
 *	- n[t[hPʂ̈kEWJɂāA̓f[^TCYꍇ̏ύX܂B
 *	- ܂ł́Akf[^ꍇA'-p'IvVw肳ꂽꍇ̂݋ApfBOǉĈkĂ܂B
 *	  WJɂ̓pfBO̗L𔻒fłȂ߁Akf[^ɃpfBOǉꂽԂœWJdlƂȂĂ܂B
 *	- AdlAkf[^TCY[U[ӎɁAn[t[hkł悤ɂ܂B
 *	  kf[^TCY̏ꍇɂAWJAkf[^Ɠe̊TCYɓWJł܂B
 *	  ̓IȏeɂẮA(unit == '2') ̏̃RgQƂĂB
 *	- ̕ύXɔA'-p'IvV͕svƂȂ̂ŁA폜܂B
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <assert.h>

#define VERSION "20090827"

/****************************************************************************
 *	
 ****************************************************************************/

int unit; /* '1' or '2' */
int mode; /* 'd' or 'e' */
char srcname[_MAX_PATH];
char dstname[_MAX_PATH];

int srclen;
void* srcbuf;
int dstlen;
void* dstbuf;
int verlen;
void* verbuf;

int LZSS_compress1(unsigned char* dst_data/*[dst_lim]*/, int dst_lim, const unsigned char* src_data/*[src_len]*/, int src_len);
int LZSS_uncompress1(unsigned char* dst_data/*[dst_lim]*/, int dst_lim, const unsigned char* src_data/*[src_len]*/, int src_len);
int LZSS_compress2(unsigned short* dst_data/*[dst_lim]*/, int dst_lim, const unsigned short* src_data/*[src_len]*/, int src_len);
int LZSS_uncompress2(unsigned short* dst_data/*[dst_lim]*/, int dst_lim, const unsigned short* src_data/*[src_len]*/, int src_len);

void
usage()
{
	printf("dlzss12 - LZSS compression tool (%s) Naoyuki Sawa\n", VERSION);
	printf("Usage: dlzss12 [-1|-2] [-d|-e] <source file name> [<destination file name>]\n");
	printf("Options:\n");
	printf("  -1 : byte     unit mode\n");
	printf("  -2 : halfword unit mode (default)\n");
	printf("  -d : decode source file\n");
	printf("  -e : encode source file (default)\n");
	exit(1);
}

/****************************************************************************
 *	
 ****************************************************************************/

int
main(int argc, char* argv[])
{
	int i;
	int c;
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	FILE* fp;

	/* R}hĆB */
	for(i = 1; i < argc; i++) {
		switch(argv[i][0]) {
		case '-':
		case '/':
			c = tolower(argv[i][1]);
			switch(c) {
			case '1':
			case '2':
				if(!unit) {
					unit = c;
					break;
				}
				usage();
				break;
			case 'd':
			case 'e':
				if(!mode) {
					mode = c;
					break;
				}
				usage();
				break;
			default:
				usage();
				break;
			}
			break;
		default:
			if(!srcname[0]) {
				strcpy(srcname, argv[i]);
				break;
			}
			if(!dstname[0]) {
				strcpy(dstname, argv[i]);
				break;
			}
			usage();
			break;
		}
	}
	/* "-1""-2"w肳ĂȂƂ̔f́AkƓWJňقȂ̂ŁAł͂܂f܂B */
	if(!unit) {
		/** no job **/
	}
	/* "-d""-e"w肳ĂȂ΁A"-e"Ƃ܂B */
	if(!mode) {
		mode = 'e';
	}
	/* ̓t@C͕K{łB */
	if(!srcname[0]) {
		usage();
	}
	if(mode == 'd') {
		/* ̓t@C̊gqȗĂꍇA
		 * - "-1"w肳ĂA".lz1"Ƃ܂B
		 * - "-2"w肳ĂA".lz2"Ƃ܂B
		 * - "-1""-2"w肳ĂȂ΁A".lz2"Ƃ܂B
		 * - <>
		 *	̓t@C D:\path\fname -> ̓t@C D:\path\fname.lz1 ("-1"w肳Ăꍇ)
		 *	̓t@C D:\path\fname -> ̓t@C D:\path\fname.lz2 ("-1"w肳Ăꍇ)
		 *	̓t@C D:\path\fname -> ̓t@C D:\path\fname.lz2 ("-1""-2"w肳ĂȂꍇ)
		 */
		_splitpath(srcname, drive, dir, fname, ext);
		if(!ext[0]) {
			if(unit == '1') {
				_makepath(srcname, drive, dir, fname, ".lz1");
			} else { /* '2' or w薳 */
				_makepath(srcname, drive, dir, fname, ".lz2");
			}
		}
		/* o̓t@CȗĂꍇA
		 * - ̓t@C̊gq".lz1"Ȃ΁A".lz1"菜̂Ƃ܂B
		 * - ̓t@C̊gq".lz2"Ȃ΁A".lz2"菜̂Ƃ܂B
		 * - ̓t@C̊gq".lz1"ł".lz2"łȂ΁AG[Ƃ܂B
		 * - <>
		 *	̓t@C D:\path\fname.ext.lz1 -> o̓t@C D:\path\fname.ext
		 *	̓t@C D:\path\fname.ext.lz2 -> o̓t@C D:\path\fname.ext
		 *	̓t@C D:\path\fname.ext     -> G[
		 */
		if(!dstname[0]) {
			_splitpath(srcname, drive, dir, fname, ext);
			if(!stricmp(ext, ".lz1") || !stricmp(ext, ".lz2")) {
				_makepath(dstname, drive, dir, fname, NULL);
			} else {
				fprintf(stderr, "Error: Destination file could not be supposed.\n");
				exit(1);
			}
		}
		/* "-1""-2"w肳ĂȂꍇA
		 * - ̓t@C̊gq".lz1"Ȃ΁AÖق"-1"w肳ꂽ̂Ƃ܂B
		 * - ̓t@C̊gq".lz2"Ȃ΁AÖق"-2"w肳ꂽ̂Ƃ܂B
		 * - ̓t@C̊gq".lz1"ł".lz2"łȂ΁AG[Ƃ܂B
		 */
		if(!unit) {
			_splitpath(srcname, NULL, NULL, NULL, ext);
			if(!stricmp(ext, ".lz1")) {
				unit = '1';
			} else if(!stricmp(ext, ".lz2")) {
				unit = '2';
			} else {
				fprintf(stderr, "Error: Unit mode could not be supposed.\n");
				exit(1);
			}
		}
	}
	if(mode == 'e') {
		/* o̓t@CȗĂꍇA
		 * - "-1"w肳ĂA̓t@C".lz1"ǉ̂Ƃ܂B
		 * - "-2"w肳ĂA̓t@C".lz2"ǉ̂Ƃ܂B
		 * - "-1""-2"w肳ĂȂ΁A̓t@C".lz2"ǉ̂Ƃ܂B
		 *   <>
		 *	̓t@C D:\path\fname.ext -> o̓t@C D:\path\fname.ext.lz1 ("-1"w肳Ăꍇ)
		 *	̓t@C D:\path\fname.ext -> o̓t@C D:\path\fname.ext.lz2 ("-1"w肳Ăꍇ)
		 *	̓t@C D:\path\fname.ext -> o̓t@C D:\path\fname.ext.lz2 ("-1""-2"w肳ĂȂꍇ)
		 */
		if(!dstname[0]) {
			if(unit == '1') {
				_makepath(dstname, NULL, NULL, srcname, ".lz1");
			} else { /* '2' or w薳 */
				_makepath(dstname, NULL, NULL, srcname, ".lz2");
			}
		}
		/* o̓t@C̊gqȗĂꍇA".tlz"Ƃ܂B
		 * - "-1"w肳ĂA".lz1"Ƃ܂B
		 * - "-2"w肳ĂA".lz2"Ƃ܂B
		 * - "-1""-2"w肳ĂȂ΁A".lz2"Ƃ܂B
		 * - <>
		 *	o̓t@C D:\path\fname -> o̓t@C D:\path\fname.lz1 ("-1"w肳Ăꍇ)
		 *	o̓t@C D:\path\fname -> o̓t@C D:\path\fname.lz2 ("-1"w肳Ăꍇ)
		 *	o̓t@C D:\path\fname -> o̓t@C D:\path\fname.lz2 ("-1""-2"w肳ĂȂꍇ)
		 */
		_splitpath(dstname, drive, dir, fname, ext);
		if(!ext[0]) {
			if(unit == '1') {
				_makepath(dstname, drive, dir, fname, ".lz1");
			} else { /* '2' or w薳 */
				_makepath(dstname, drive, dir, fname, ".lz2");
			}
		}
		/* "-1""-2"w肳ĂȂꍇA
		 * - o̓t@C̊gq".lz1"Ȃ΁AÖق"-1"w肳ꂽ̂Ƃ܂B
		 * - o̓t@C̊gq".lz2"Ȃ΁AÖق"-2"w肳ꂽ̂Ƃ܂B
		 * - o̓t@C̊gq".lz1"ł".lz2"łȂ΁AG[Ƃ܂B
		 */
		if(!unit) {
			_splitpath(dstname, NULL, NULL, NULL, ext);
			if(!stricmp(ext, ".lz1")) {
				unit = '1';
			} else if(!stricmp(ext, ".lz2")) {
				unit = '2';
			} else {
				fprintf(stderr, "Error: Unit mode could not be supposed.\n");
				exit(1);
			}
		}
	}
	/* ̓t@CƏo̓t@CłĂ͂܂B */
	if(!stricmp(srcname, dstname)) {
		fprintf(stderr, "Error: Source file should not be same as destination file.\n");
		exit(1);
	}

	/* ̓t@Cǂݍ݂܂B */
	fp = fopen(srcname, "rb");
	if(!fp) {
		fprintf(stderr, "Error: Failed to open file %s.\n", srcname);
		exit(1);
	}
	fseek(fp, 0, SEEK_END);
	srclen = ftell(fp);
	if(!srclen) {
		fprintf(stderr, "Error: Source file should not be empty.");
		exit(1);
	}
	rewind(fp);
	srcbuf = malloc(srclen);
	if(!srcbuf) {
		fprintf(stderr, "Error: Failed to allocate source buffer.\n");
		exit(1);
	}
	fread(srcbuf, 1, srclen, fp);
	fclose(fp);

	if(unit == '1') {
		if(mode == 'e') {
			/* kB */
			dstbuf = malloc(srclen); /* k100%ȉƂȂ邱Ƃ҂āAkƓTCYňkobt@mۂAkĂ݂ */
			if(!dstbuf) {
				fprintf(stderr, "Error: Failed to allocate destination buffer.\n");
				exit(1);
			}
			dstlen = LZSS_compress1(dstbuf, srclen, srcbuf, srclen);
			if(dstlen > srclen) { /* k100%߂ꍇ́Aۂ̈kTCYňkobt@ĊmۂāAĈk */
				dstbuf = realloc(dstbuf, dstlen);
				if(!dstbuf) {
					fprintf(stderr, "Error: Failed to allocate destination buffer.\n");
					exit(1);
				}
				LZSS_compress1(dstbuf, dstlen, srcbuf, srclen);
			}
			/* xt@CB */
			verbuf = malloc(srclen);
			if(!verbuf) {
				fprintf(stderr, "Error: Failed to allocate verify buffer.\n");
				exit(1);
			}
			verlen = LZSS_uncompress1(verbuf, srclen, dstbuf, dstlen);
			if((verlen != srclen) || memcmp(verbuf, srcbuf, srclen)) {
				fprintf(stderr, "Internal error: Verify failed.n");
				exit(1);
			}
		}
		if(mode == 'd') {
			/* WJB */
			dstlen = LZSS_uncompress1(NULL, 0, srcbuf, srclen);
			dstbuf = malloc(dstlen);
			if(!dstbuf) {
				fprintf(stderr, "Error: Failed to allocate destination buffer.\n");
				exit(1);
			}
			LZSS_uncompress1(dstbuf, dstlen, srcbuf, srclen);
		}
	}
	if(unit == '2') {
		/* ̓f[^TCYAn[t[hPʂɕϊB
		 * - ̓f[^TCYꍇA1oCǵAn[t[hPʂ̈kEWJɊ܂߂ȂB
		 *   kEWJɁA̓f[^̖1oCĝ܂܁Ao̓f[^̖ɒǉB
		 *   kÕf[^TCYȂ΁Ak̃f[^TCYƂȂA܂A̋t^łB
		 */
		int srclen2 = srclen / 2;
		int dstlen2 = 0;
		int verlen2 = 0;
		if(mode == 'e') {
			/* kB */
			dstbuf = malloc(srclen2 * 2 + 1/*1oCgǉp*/); /* k100%ȉƂȂ邱Ƃ҂āAkƓTCYňkobt@mۂAkĂ݂ */
			if(!dstbuf) {
				fprintf(stderr, "Error: Failed to allocate destination buffer.\n");
				exit(1);
			}
			dstlen2 = LZSS_compress2(dstbuf, srclen2, srcbuf, srclen2);
			if(dstlen2 > srclen2) { /* k100%߂ꍇ́Aۂ̈kTCYňkobt@ĊmۂāAĈk */
				dstbuf = realloc(dstbuf, dstlen2 * 2 + 1/*1oCgǉp*/);
				if(!dstbuf) {
					fprintf(stderr, "Error: Failed to allocate destination buffer.\n");
					exit(1);
				}
				LZSS_compress2(dstbuf, dstlen2, srcbuf, srclen2);
			}
			/* xt@CB */
			verbuf = malloc(srclen2 * 2);
			if(!verbuf) {
				fprintf(stderr, "Error: Failed to allocate verify buffer.\n");
				exit(1);
			}
			verlen2 = LZSS_uncompress2(verbuf, srclen2, dstbuf, dstlen2);
			if((verlen2 != srclen2) || memcmp(verbuf, srcbuf, srclen2 * 2)) {
				fprintf(stderr, "Internal error: Verify failed.n");
				exit(1);
			}
		}
		if(mode == 'd') {
			/* WJB */
			dstlen2 = LZSS_uncompress2(NULL, 0, srcbuf, srclen2);
			dstbuf = malloc(dstlen2 * 2 + 1/*1oCgǉp*/);
			if(!dstbuf) {
				fprintf(stderr, "Error: Failed to allocate destination buffer.\n");
				exit(1);
			}
			LZSS_uncompress2(dstbuf, dstlen2, srcbuf, srclen2);
		}
		/* o̓f[^TCYAoCgPʂɕϊB */
		dstlen = dstlen2 * 2;
		/* ̓f[^TCYꍇ́A̓f[^̖1oCĝ܂܁Ao̓f[^̖ɒǉB
		 * o̓f[^obt@̊mێɁA1oCgǉp̗̈\ς݂łB
		 */
		if(srclen & 1) {
			((unsigned char*)dstbuf)[dstlen++] = ((unsigned char*)srcbuf)[srclen - 1];
		}
	}

	/* o̓t@C݂܂B */
	fp = fopen(dstname, "wb");
	if(!fp) {
		fprintf(stderr, "Error: Failed to create file %s.\n", dstname);
		exit(1);
	}
	fwrite(dstbuf, 1, dstlen, fp);
	fclose(fp);

	/* |[g\B */
	printf("%s (%d) => %s (%d) : %d%%\n",
		srcname, srclen,
		dstname, dstlen,
		(int)ceil((double)dstlen * 100.0 / (double)srclen));

	return 0;
}
