#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
__declspec(noreturn) static void usage();
static void dumpKeyBody(int indent, const unsigned char* keyBody);
static void printIndent(int indent, const char* fmt, ...);
/****************************************************************************
 *	
 ****************************************************************************/
int main(int argc, char* argv[]) {
	FILE* fp;
	void* buf;
	int opt, len;
	//R}hCIvVB
	opterr = 0; //IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB
	while((opt = getopt(argc, argv, "h")) != -1) {
		switch(opt) {
		case 'h':
		default:
			usage();
		}
	}
	//WXge[ũoCif[^ǂݍށB
	if(optind != (argc - 1)) { usage(); }	//̐s
	fp = fopen(argv[optind], "rb");
	fseek(fp, 0, SEEK_END);
	len = ftell(fp);
	rewind(fp);
	buf = malloc(len);
	if(!buf) { DIE(); }	//s
	fread(buf, 1, len, fp);
	fclose(fp);
	//WXge[u_vB
	dumpKeyBody(0, buf);
	return EXIT_SUCCESS;
}
/*---------------------------------------------------------------------------*/
__declspec(noreturn) static void usage() {
	fprintf(stderr, "dRegTblD - WXge[utRpC (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2015 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "  dRegTblD [option] RegTbl.bin\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OPTIONS:\n");
	fprintf(stderr, "  -h g\܂B\n");
	exit(EXIT_FAILURE);
}
/*--------------------------------------------------------------------------*/
static void dumpKeyBody(int indent, const unsigned char* keyBody) {
	//--- L[ ---
	{
		int nKey, keyName, keyBodyDist;
		nKey      = *keyBody++;				//
		nKey    <<= 8;					//16rbg,rbOGfBA
		nKey     |= *keyBody++;				//
		while(--nKey >= 0) {
			keyName       =       *keyBody++;	//
			keyName     <<= 8;			//16rbg,rbOGfBA
			keyName      |=       *keyBody++;	//
			keyBodyDist   = (char)*keyBody++;	//
			keyBodyDist <<= 8;			//
			keyBodyDist  |=       *keyBody++;	//L24rbg,rbOGfBA
			keyBodyDist <<= 8;			//
			keyBodyDist  |=       *keyBody++;	//
			printIndent(indent, "%u", keyName);
			dumpKeyBody(indent + 1, keyBody + keyBodyDist);
			printIndent(indent, "end");
		}
	}
	//--- l ---
	{
		int nValue, valueName, valueData;
		nValue    = *keyBody++;				//
		nValue  <<= 8;					//16rbg,rbOGfBA
		nValue   |= *keyBody++;				//
		while(--nValue >= 0) {
			valueName     =       *keyBody++;	//
			valueName   <<= 8;			//16rbg,rbOGfBA
			valueName    |=       *keyBody++;	//
			valueData     =       *keyBody++;	//
			valueData   <<= 8;			//16rbg,rbOGfBA
			valueData    |=       *keyBody++;	//
			printIndent(indent, "%u\t=\t%u", valueName, valueData);
		}
	}
	//---  ---
	{
		int nString, stringName, stringDist;
		nString   = *keyBody++;				//
		nString <<= 8;					//16rbg,rbOGfBA
		nString  |= *keyBody++;				//
		while(--nString >= 0) {
			stringName    =       *keyBody++;	//
			stringName  <<= 8;			//16rbg,rbOGfBA
			stringName   |=       *keyBody++;	//
			stringDist    = (char)*keyBody++;	//
			stringDist  <<= 8;			//
			stringDist   |=       *keyBody++;	//L24rbg,rbOGfBA
			stringDist  <<= 8;			//
			stringDist   |=       *keyBody++;	//
			printIndent(indent, "%u\t=\t\"%s\"", stringName, keyBody + stringDist);
		}
	}
}
/*--------------------------------------------------------------------------*/
static void printIndent(int indent, const char* fmt, ...) {
	va_list ap;
	while(--indent >= 0) { putchar('\t'); }
	va_start(ap, fmt);
	vprintf(fmt, ap);
	va_end(ap);
	putchar('\n');
}
