/*	
 *	framapu.c
 *
 *	P/ECE APU (RICOH RP2A03) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sun Feb 06 18:39:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Mar 01 05:20:00 JST 2005 Naoyuki Sawa
 *	- RgC܂B
 *	  vO̓eɂ͕ω܂B
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

#ifndef APU_ASM

void
apu_square_mix(APUSQUARE* square, short wbuff[/*64*/])
{
	APULENGTH* length = &square->length;
	APUENVELOPE* envelope = &square->envelope;
	APUSWEEP* sweep = &square->sweep;
	//
	int i;
	int volume;
	int wavelength;
	int waveindex;
	int wavecount;
	int duty;
	int output;

	/* OXJE^0Ȃ΁A܂B */
	if(!length->count) {
		return;
	}

	/* {[0Ȃ΁A܂B */
	volume = envelope->volume;
	if(!volume) {
		return;
	}

	/* g8ȉ܂0x7ffȏȂ΁A܂B */
	wavelength = sweep->wavelength;
	if(wavelength <= 8 || wavelength >= 0x7ff) {
		return;
	}
	wavelength = (wavelength + 1) * SPEAKER_FREQUENCY;
	// min(square->wavelength) = 9 łA
	//   (wavelength + 1) * SPEAKER_FREQUENCY = 160000
	//   1.79MHz / 160000 = 11.2
	// 1Tv̍őXV񐔂12ȉłB
	// P/ECEłԂɍƎv̂ŁA~b^݂͐܂B

	duty = square->duty;

	waveindex = square->waveindex; /* o */
	wavecount = square->wavecount; /* o */

	output = (waveindex < duty) ? volume : -volume;

	i = 64;
	do {
		wavecount -= APU_CLOCK;
		if(wavecount < 0) {
			do {
				waveindex++;
			} while((wavecount += wavelength) < 0);
			waveindex &= 15;
			output = (waveindex < duty) ? volume : -volume;
		}
		*wbuff++ += output;
	} while(--i);

	square->waveindex = waveindex; /* ߂ */
	square->wavecount = wavecount; /* ߂ */
}

void
apu_triangle_mix(APUTRIANGLE* triangle, short wbuff[/*64*/])
{
	APULENGTH* length = &triangle->length;
	APULINEAR* linear = &triangle->linear;
	//
	int i;
	int wavelength;
	int waveindex;
	int wavecount;
	int output;

	/* OXJE^0Ȃ΁A܂B */
	if(!length->count) {
		return;
	}

	/* jAJE^0Ȃ΁A܂B */
	if(!linear->count) {
		return;
	}

	/* g8ȉ܂0x7ffȏȂ΁A܂B */
	wavelength = triangle->wavelength;
	if(wavelength <= 8 || wavelength >= 0x7ff) { /* dl */
		return;
	}
	wavelength = (wavelength + 1) * SPEAKER_FREQUENCY;
	// min(triangle->wavelength) = 9 łA
	//   (wavelength + 1) * SPEAKER_FREQUENCY = 160000
	//   1.79MHz / 160000 = 11.2
	// 1Tv̍őXV񐔂12ȉłB
	// P/ECEłԂɍƎv̂ŁA~b^݂͐܂B

	waveindex = triangle->waveindex; /* o */
	wavecount = triangle->wavecount; /* o */

	output = apu_triangle_waveform_table[waveindex];

	i = 64;
	do {
		wavecount -= APU_CLOCK;
		if(wavecount < 0) {
			do {
				waveindex++;
			} while((wavecount += wavelength) < 0);
			waveindex &= 31;
			output = apu_triangle_waveform_table[waveindex];
		}
		*wbuff++ += output;
	} while(--i);

	triangle->waveindex = waveindex; /* ߂ */
	triangle->wavecount = wavecount; /* ߂ */
}

void
apu_noise_mix(APUNOISE* noise, short wbuff[/*64*/])
{
	APULENGTH* length = &noise->length;
	APUENVELOPE* envelope = &noise->envelope;
	//
	int i;
	int v;
	int volume;
	int wavelength;
	int wavecount;
	int mode;
	int lfsr;
	int output;

	/* OXJE^0Ȃ΁A܂B */
	if(!length->count) {
		return;
	}

	/* {[0Ȃ΁A܂B */
	volume = envelope->volume;
	if(!volume) {
		return;
	}

	/* g0Ȃ΁A܂B($400Eݒ̏ꍇ) */
	wavelength = noise->wavelength;
	if(!wavelength) {
		return;
	}
	wavelength = wavelength * SPEAKER_FREQUENCY;
	// min(noise->wavelength) = 4 łA
	//   wavelength * SPEAKER_FREQUENCY = 64000
	//   1.79MHz / 64000 = 28.0
	// 1Tv̍őXV񐔂29ȉłB
	// ͂Ȃ茵ł...~b^KvH

	mode = noise->mode;

	lfsr      = noise->lfsr;      /* o */
	wavecount = noise->wavecount; /* o */

	output = !(lfsr & 1) ? volume : -volume;

	i = 64;
	do {
		wavecount -= APU_CLOCK;
		if(wavecount < 0) {
			do {
				v = ((lfsr>>0) ^ (lfsr>>mode)) & 1;
				lfsr = (lfsr >> 1) | (v << 14);
			} while((wavecount += wavelength) < 0);
			output = !(lfsr & 1) ? volume : -volume;
		}
		*wbuff++ += output;
	} while(--i);

	noise->lfsr      = lfsr;      /* ߂ */
	noise->wavecount = wavecount; /* ߂ */
}

void
apu_dmc_mix(APUDMC* dmc, short wbuff[/*64*/]) /* {o[}gĂ܂ */
{
	const unsigned char* memory = dmc->memory;
	//
	int i;
	int wavelength;
	int output;
	int address;
	int length;
	int sample;
	int wavecount;

	/* tONAꂽԂŌĂяo邱Ƃ͂Ȃ͂łB */
	ASSERT(dmc->flags & (1<<7));

	/* g0Ȃ΁A܂B($4010ݒ̏ꍇ) */
	wavelength = dmc->wavelength;
	if(!wavelength) {
		goto STOP;
	}
	wavelength = wavelength * SPEAKER_FREQUENCY;
	// min(dmc->wavelength) = 54 łA
	//   wavelength * SPEAKER_FREQUENCY = 864000
	//   1.79MHz / 864000 = 2.1
	// 1Tv̍őXV񐔂3ȉłB
	// P/ECEłԂɍƎv̂ŁA~b^݂͐܂B

	output    = dmc->output;    /* o */
	address   = dmc->address;   /* o */
	length    = dmc->length;    /* o */
	sample    = dmc->sample;    /* o */
	wavecount = dmc->wavecount; /* o */

	i = 64;
	do {
		wavecount -= APU_CLOCK;
		if(wavecount < 0) {
			do {
				/* VTvoCgDMA]ŎĂ鏈B */
				if(sample <= 1) { /* Tvobt@ */
					length--;
					if(!length) { /* Tvf[^ */
						if(!(dmc->flags & (1<<0))) { /* [v */
							goto STOP;
						}
						/* [vB(apu_write()̃f^PCMJnƓł) */
						//dmc->flags    |= (1<<7); /*  */ -> ɔȂ̂ŕsv
						dmc->output    = dmc->init_output;
						dmc->address   = dmc->init_address;
						dmc->length    = dmc->init_length;
						//dmc->sample    = 0; /* Tvobt@ */ -> ɋȂ̂ŕsv
						//dmc->wavecount = 0; -> is^C~O͌p̂0ɂ_
						continue/*while*/; /* [v͏l̂܂܏o(Ԃc) */
					}
					sample = memory[address++] | 0x100/*Tvobt@o邽*/;
					address = (unsigned short)address | 0x8000;
				}

				/* Tvobt@̍ŉʃrbgo͂֔f鏈B */
				if(!(sample & 1)) {
					/* Tv̍ŉʃrbg0Ȃ΁Ao-2B */
					if(output >= -64 + 2) {
						output -= 2;
					} else {
						output = -64;
					}
				} else {
					/* Tv̍ŉʃrbg1Ȃ΁Ao+2B */
					if(output <= 63 - 2) {
						output += 2;
					} else {
						output = 63;
					}
				}
				sample >>= 1; /* ŉʃrbgVtgAEg */
			} while((wavecount += wavelength) < 0);
		}
		*wbuff++ += output;
	} while(--i);

	dmc->output    = output;    /* ߂ */
	dmc->address   = address;   /* ߂ */
	dmc->length    = length;    /* ߂ */
	dmc->sample    = sample;    /* ߂ */
	dmc->wavecount = wavecount; /* ߂ */

	return;
STOP:
	dmc->flags &= ~(1<<7); /*  */
	return;
}

#endif /*APU_ASM*/

/****************************************************************************
 *
 ****************************************************************************/

/*   SQUARE1  t5bit
 * + SQUARE2  t5bit
 * + TRIANGLE t5bit
 * + NOISE    t5bit
 * + DMC      t7bit
 * =          t8bit
 */
#define APU_VOLUME_SHIFT ((16-8)+1/**/)

#ifndef APU_ASM

void
apu_volume_shift(short wbuff[/*APUBUFLEN*/])
{
	int i;
	int v;

	i = APUBUFLEN;
	do {
		v = *wbuff;
		v <<= APU_VOLUME_SHIFT;
		if(v >  32767) v =  32767;
		if(v < -32768) v = -32768;
		*wbuff++ = v;
	} while(--i);
}

#else /*APU_ASM*/

asm("
	.code
	.align 1
	.global apu_volume_shift
apu_volume_shift:
	; %r12 = wbuff
	xld.w %r13, 320			; APUBUFLEN = 320
	xld.w %r4, 32767
	not %r5, %r4			; -32768
apu_volume_shift_DO:
	ld.h %r6, [%r12]
	xsll %r6, 9			; APU_VOLUME_SHIFT = (16-8)+1 = 9
	cmp %r6, %r4
	jrle.d 3
	cmp %r6, %r5			; *delay*
	ld.w %r6, %r4			; (skip?)
	jrge.d 3
	sub %r13, 1			; *delay*
	ld.w %r6, %r5			; (skip?)
	ld.h [%r12]+, %r6
	xjrne apu_volume_shift_DO
	ret
");

#endif /*APU_ASM*/
