/*	
 *	cliptcp.c
 *
 *	TCPvgRhCo
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Tue Sep 20 04:34:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 *	* Fri Sep 23 18:31:00 JST 2005 Naoyuki Sawa
 *	- sȉmFԍ𔺂ACKMꍇ̏C܂B
 */
#include "clip.h"

/*  */
/*  eԂ̋݌vɂẮAtcp/tcp.xlsQƂĂB */
/*  */

/****************************************************************************
 *	TCPvgRhCo
 ****************************************************************************/

#define TCP_RECV_MSS	1460	/* MMSS (Ethernet̍őMSS) () */
#define TCP_SEND_MSS	 536	/* MMSS (ۏ؂ĂŏMSS) () */

#define TIMER_INTERVAL	1000	/* đ쓮p^C}C^[o[ms]() */
#define RESEND_INTERVAL	2000	/* đC^[o[ms]            () */

#define CLOSE_TIMEOUT	1000	/* ؒf҂^CAEg̊l[ms]() */

typedef struct _TCPDRIVER {
	IPCLIENT ip_client;	/* IPNCAgo^p */
	int timer_id;		/* đ쓮p^C}ID */
	LIST_ENTRY client_list;	/* NCAgXg */
} TCPDRIVER;
static TCPDRIVER tcp_driver;

static TCPCLIENT* tcp_find_client(int local_port, int remote_ip_address, int remote_port);
static int tcp_allocate_ephemeral_port();
static void tcp_send_segment(TCPCLIENT* client, int control_flag, const void* data, int data_length);
static void tcp_reply_rst(TCPHEADER* received_header, int remote_ip_address);
static void tcp_init_state(TCPCLIENT* client, int state);
static void tcp_exec_state(TCPCLIENT* client);
static void tcp_timer_callback(void* context);
static void tcp_recv_callback(IPCLIENT* ip_client, int source_ip_address, int destination_ip_address, const unsigned char* data/*[length]*/, int length);

/*--------------------------------------------------------------------------*/

/* NCAgXgAw肵[J|[gA[gIPAhXA[g|[gɑΉNCAgT܂B
 * w肵[J|[gA[gIPAhXA[g|[gɑΉNCAgA|C^Ԃ܂B
 * w肵[J|[gA[gIPAhXA[g|[gɑΉNCAgȂ΁ANULLԂ܂B
 */
/* 荞݋֎~ԂŌĂяoĂ!! */
static TCPCLIENT*
tcp_find_client(int local_port, int remote_ip_address, int remote_port)
{
	LIST_ENTRY* list_head = &tcp_driver.client_list;	/* Xg̃[gvf */
	LIST_ENTRY* list_entry = list_head->Flink;		/* 擪̗vf(orI[) */
	TCPCLIENT* client;

	while(list_entry != list_head) {
		if(!list_entry) {
			DIE(); /* A܂́ANCAgXgj */
		}
		client = CONTAINING_RECORD(list_entry, TCPCLIENT, list_entry);
		if((client->local_port        == local_port       ) &&
		   (client->remote_ip_address == remote_ip_address) &&
		   (client->remote_port       == remote_port      )) {
			return client;
		}
		list_entry = list_entry->Flink;
	}

	return NULL;
}

/* gp̃GtF|[gT܂B
 * ------------------------------------------------------------------------------------------------------------------------------------------------------------
 * ITpꎫT e-Words F GtF|[gƂ yephemeral portsz - ӖE
 * ̗pr(vgRł̎gpĂ炸AꎞIȒʐM̂߂ɎRɗpł|[gB_Ci~bN|[gƂBuephemeralv́uZȁv̈ӁB
 * ɑ΂āAHTTP80Ԃ̂悤ɁÃvgRp邱ƂLĂ|[g̓EFmE|[g(well-known port)ƌĂ΂B
 * GtF|[g͎ɃNCAgŗpBNCAgT[oɃNGXg𑗏oہA
 * T[õ|[g͖ړĨT[rXғĂ|[g(̏ꍇAEFmE|[g)łKv邪ANCAg͂ǂȃ|[ggĂ܂ȂB
 * ̂ƂANCAgłOS󂢂ĂGtF|[g̒KȂ̂IŊ蓖ĂBʐMIƂ̃|[g͉B
 * GtF|[ǵA{Iɂ1024Ԉȍ~p邪AOSɂقȂB
 * WindowsnߑOSł1024Ԃ5000ԂGtF|[gƂĊ蓖ĂĂ邪AႦ΁AFreeBSD 5.0ł49152Ԃ65535Ԃ蓖ĂĂB
 * ------------------------------------------------------------------------------------------------------------------------------------------------------------
 * {hCóAFreeBSDɕ킢A49152Ԃ65535($C000`$FFFF)GtF|[gƂĊ蓖Ă邱Ƃɂ܂B
 */
/* 荞݋֎~ԂŌĂяoĂ!! */
static int
tcp_allocate_ephemeral_port()
{
	LIST_ENTRY* list_head = &tcp_driver.client_list;	/* Xg̃[gvf */
	LIST_ENTRY* list_entry = list_head->Flink;		/* 擪̗vf(orI[) */
	TCPCLIENT* client;
	int ephemeral_port;

	for(ephemeral_port = 0xc000; ephemeral_port <= 0xffff; ephemeral_port++) {
		while(list_entry != list_head) {
			if(!list_entry) {
				DIE(); /* A܂́ANCAgXgj */
			}
			client = CONTAINING_RECORD(list_entry, TCPCLIENT, list_entry);
			if(client->local_port == ephemeral_port) {
				break; /* gpς */
			}
			list_entry = list_entry->Flink;
		}
		if(list_entry == list_head) {
			break; /* gp|[g */
		}
	}

	if(ephemeral_port > 0xffff) {
		DIE(); /* gp|[g */
	}

	return ephemeral_port;
}

/* tcp_send_segment()Atcp_reply_rst()痘p܂B
 * ML[ς̏ꍇAM͎s܂AĂvłB
 * lbg[NŃZOgXĝƓƍlAđɂăJo[ł邩łB
 */
/* 荞݋֎~ԂŌĂяoĂ!! */
static void
_tcp_send_segment(TCPHEADER* header, int remote_ip_address)
{
	int packet_length;
	unsigned char* packet = NULL; /* v */
	//
	IPCONFIG ip_config;
	ip_get_config(&ip_config);

	/* TCPZOg\zpobt@mۂ܂B */
	packet_length = 20/*TCPwb_*/ + header->data_length/*f[^*/;
	packet = malloc(packet_length);
	if(!packet) {
		DIE(); /* s */
	}

	/* TCPZOg\z܂B */
	packet_length = pack_tcp_header(
		header,			/* TCPwb_ */
		packet,			/* TCPZOg\zpobt@ */
		packet_length,		/* TCPZOg\zpobt@̋e */
		ip_config.ip_address,	/* MIPAhX */
		remote_ip_address);	/* ĐIPAhX */
	if(packet_length < 0) {
		DIE(); /* K͂ */
	}

	/* TCPZOg𑗐M܂B */
	ip_send(&tcp_driver.ip_client,	/* IPNCAg */
		remote_ip_address,	/* ĐIPAhX */
		packet,			/* pPbg */
		packet_length);		/* pPbg */

	/* TCPZOg\zpobt@܂B */
	free(packet);
}

/* TCPZOg\zAMAđf̊Zbg܂B */
/* 荞݋֎~ԂŌĂяoĂ!! */
static void
tcp_send_segment(TCPCLIENT* client, int control_flag, const void* data, int data_length)
{
	TCPHEADER header;

	if(!client->remote_ip_address || !client->remote_port) {
		DIE(); /* ڑNCAǧĂяo͕s */
	}

	/* f[^L΁APSHǉ܂B(ĂяoŎw肷ԂȂ܂) */
	if(data_length) {
		control_flag |= TCP_PSH;
	}

	/* TCPwb_ݒ肵܂B */
	memset(&header, 0, sizeof(TCPHEADER));
	header.source_port		= client->local_port;			/* M|[g */
	header.destination_port		= client->remote_port;			/* Đ|[g */
	header.sequence_number		= client->send_sequence_number;		/* V[PXԍ */
	header.acknowledgement_number	= client->recv_sequence_number;		/* mFԍ */
	header.control_flag		= control_flag;				/* Rg[tO */
	header.window			= buffer_space(client->recv_buffer);	/* EChE */
	header.data			= (void*)data;				/* f[^ */
	header.data_length		= data_length;				/* f[^ */

	/* TCPZOg\zAM܂B */
	_tcp_send_segment(&header, client->remote_ip_address);
}

/* MTCPZOgɑ΂āARSTԑ܂B */
/* 荞݋֎~ԂŌĂяoĂ!! */
static void
tcp_reply_rst(TCPHEADER* received_header, int remote_ip_address)
{
	TCPHEADER header;

	/* TCPwb_ݒ肵܂B */
	memset(&header, 0, sizeof(TCPHEADER));
	header.source_port		= received_header->destination_port;	/* M|[g */
	header.destination_port		= received_header->source_port;		/* Đ|[g */
	if(received_header->control_flag & TCP_ACK) {				/* V[PXԍ */
		header.sequence_number	= received_header->acknowledgement_number;  /* V[PXԍ */
	}
	header.control_flag		= TCP_RST;				/* Rg[tO */

	/* TCPZOg\zAM܂B */
	_tcp_send_segment(&header, remote_ip_address);
}

/* Ԃi[AMs܂B */
/* 荞݋֎~ԂŌĂяoĂ!! */
static void
tcp_init_state(TCPCLIENT* client, int state)
{
	/* Ԃi[܂B */
	client->state = state;

	/* Ms܂B */
	tcp_exec_state(client);
}

/* đf̊ZbgAMA܂́Ađs܂B */
/* 荞݋֎~ԂŌĂяoĂ!! */
static void
tcp_exec_state(TCPCLIENT* client)
{
	const void* data;
	int data_length;

	/* đf̊Zbg܂B */
	client->T0 = pceTimerGetCount();

	/* Ԃɂ... */
	switch(client->state) {

	case TCP_LISTEN:
	case TCP_CLOSED:
		/* ܂B */
		break;

	case TCP_SYN_SENT:
		/* SYN𑗐M܂B */
		tcp_send_segment(client, TCP_SYN, NULL, 0);
		break;

	case TCP_SYN_RECEIVED:
		/* SYNACK𑗐M܂B */
		tcp_send_segment(client, TCP_SYN | TCP_ACK, NULL, 0);
		break;

	case TCP_ESTABLISHED:
	case TCP_CLOSE_WAIT:
		/* ACKAf[^𑗐M܂B */
		data = peek_buffer(client->send_buffer, &data_length);
		if(data_length > client->send_window) {
			data_length = client->send_window;
		}
		tcp_send_segment(client, TCP_ACK, data, data_length);
		break;

	case TCP_FIN_WAIT_1:
	case TCP_LAST_ACK:
		/* FINACK𑗐M܂B */
		tcp_send_segment(client, TCP_FIN | TCP_ACK, NULL, 0);
		break;

	case TCP_FIN_WAIT_2:
	case TCP_CLOSING:
	case TCP_TIME_WAIT:
		/* ACK𑗐M܂B */
		tcp_send_segment(client, TCP_ACK, NULL, 0);
		break;

	default:
		DIE(); /* sȏ */
	}
}

/* đC^[o𒴂NCAǵAđs܂B */
static void
tcp_timer_callback(void* context)
{
	LIST_ENTRY* list_head = &tcp_driver.client_list;	/* Xg̃[gvf */
	LIST_ENTRY* list_entry = list_head->Flink;		/* 擪̗vf(orI[) */
	TCPCLIENT* client;
	int T1 = pceTimerGetCount();

	while(list_entry != list_head) {
		if(!list_entry) {
			DIE(); /* A܂́ANCAgXgj */
		}
		client = CONTAINING_RECORD(list_entry, TCPCLIENT, list_entry);
		if(T1 - client->T0 >= RESEND_INTERVAL) {
			tcp_exec_state(client);
		}
		list_entry = list_entry->Flink;
	}
}

static void
tcp_recv_callback(IPCLIENT* ip_client, int source_ip_address, int destination_ip_address, const unsigned char* data/*[length]*/, int length)
{
	int retval;
	TCPHEADER header;
	TCPCLIENT* client;

	/* TCPZOgWJAwb_擾܂B */
	retval = unpack_tcp_header(&header, data, length, source_ip_address, destination_ip_address);
	if(retval < 0) {
		return; /* sZOg */
	}

	/* ڑς݁A܂́AAhXƃ|[gw肵Đڑ҂̃NCAg܂B */
	client = tcp_find_client(header.destination_port, source_ip_address, header.source_port);
	if(!client) {
		/* AhXw肵Đڑ҂̃NCAg܂B */
		client = tcp_find_client(header.destination_port, source_ip_address, 0);
		if(!client) {
			/* |[gw肵Đڑ҂̃NCAg܂B */
			client = tcp_find_client(header.destination_port, 0, header.source_port);
			if(!client) {
				/* w肵ȂŐڑ҂̃NCAg܂B */
				client = tcp_find_client(header.destination_port, 0, 0);
				if(!client) {
					/* NCAg΁ARSTԑ܂B */
					tcp_reply_rst(&header, source_ip_address);
					return; /* ܂ */
				}
			}
		}
	}

	/* RSTMACLOSED֑JڂAԂ܂B
	 * ALISTENACLOSEDȂ΁AɏԂ܂B
	 */
	if(header.control_flag & TCP_RST) {
		if((client->state != TCP_LISTEN) &&
		   (client->state != TCP_CLOSED)) {
			tcp_init_state(client, TCP_CLOSED);
		}
		return; /* ɂARST̏͂܂łł */
	}

	/* mFԍ𔺂ACKMAmF҂Mf[^j܂B */
	if(header.control_flag & TCP_ACK) {
		int ack_len = header.acknowledgement_number - client->send_sequence_number;
		int snd_len = client->send_buffer->size;
		if((ack_len >= 0) && (ack_len <= snd_len)) {
			read_buffer(client->send_buffer, NULL, ack_len);
			client->send_sequence_number += ack_len;
			client->send_window = header.window; /* YȂ!! */
		/* sȉmFԍ𔺂ACKMACsAԂ܂B */
		} else {
			/* * ڑԂ̈菇ڂŁAsȉmFԍ𔺂ACKMꍇ́ARSTԑ܂B
			 *   ̌Ađs܂B
			 * - ȑOɁAƓIPAhXA|[g̑gŐڑƂɁA
			 *   ؒfs킸ɏI߁A葤TCP܂Ăƍl܂B
			 *   ́AVڑvĂ̂łA܂A葤TCPؒf̂łB
			 *   葤TCPؒfAđɂāA炽߂Đڑs܂B
			 *   (LISTEN̍đ͉Ȃ̂ŁAđӖ𐬂̂SYN-SENT̏ꍇłB)
			 * - SYN-RECEIVEDڑԂ̂ЂƂłA菇ڂʉ߂ƂȂ̂ŁARSTԑ܂B
			 *   AڑςݏԂƓƌȂAđsŁACł͂łB
			 * * ڑςݏԂŁAsȉmFԍ𔺂ACKMꍇ́Aɍđs܂B
			 * - PɁA̃pPbgXgAoɎsĂƍl܂B
			 *   XgA܂́AoɎspPbgđ邱ƂŁACł͂łB
			 */
			if((client->state == TCP_LISTEN  ) ||
			   (client->state == TCP_SYN_SENT)) {
				tcp_reply_rst(&header, source_ip_address);
			}
			tcp_exec_state(client);
			return; /* ܂ */
		}
	}

	/* LISTENASYN-SENTACLOSEDȊOȂ΁AV[PXԍ܂B
	 * V[PXԍsȂ΁AđsAԂ܂B
	 */
	if((client->state != TCP_LISTEN  ) &&
	   (client->state != TCP_SYN_SENT) &&
	   (client->state != TCP_CLOSED  )) {
		if(header.sequence_number != client->recv_sequence_number) {
			tcp_exec_state(client);
			return; /* ܂ */
		}
	}

	/* ESTABLISHEDAFIN-WAIT-1AFIN-WAIT-2Ȃ΁Af[^Ms܂B */
	if((client->state == TCP_ESTABLISHED) ||
	   (client->state == TCP_FIN_WAIT_1 ) ||
	   (client->state == TCP_FIN_WAIT_2 )) {
		/* Mf[^... */
		if(header.data_length) {
			/* Mobt@̋󂫂... */
			if(header.data_length <= buffer_space(client->recv_buffer)) {
				/* Mobt@ɒǉ܂B(K͂) */
				write_buffer(client->recv_buffer, header.data, header.data_length);
				/* MV[PXԍXV܂B */
				client->recv_sequence_number += header.data_length;
				/* mFԑ܂B */
				tcp_exec_state(client);
			}
		}
	}

	/* Ԃɂ... */
	switch(client->state) {

	case TCP_LISTEN:
		/* SYNM... */
		if(header.control_flag & TCP_SYN) {
			/* [gIPAhXA[g|[gi[܂B */
			if(client->remote_ip_address) { /* ̃[gIPAhX҂󂯂Ăꍇ */
				if(client->remote_ip_address != source_ip_address) {
					DIE(); /* L蓾Ȃ */
				}
			} else {                        /* Cӂ̃[gIPAhX҂󂯂Ăꍇ */
				client->remote_ip_address     = source_ip_address;
			}
			if(client->remote_port) {       /* ̃[g|[g҂󂯂Ăꍇ */
				if(client->remote_port       != header.source_port) {
					DIE(); /* L蓾Ȃ */
				}
			} else {                        /* Cӂ̃[g|[g҂󂯂Ăꍇ */
				client->remote_port           = header.source_port;
			}
			/* MV[PXԍAMEChEi[܂B */
			client->recv_sequence_number = header.sequence_number + 1/*SYN*/;
			client->send_window          = header.window;
			/* SYN-RECEIVED֑Jڂ܂B */
			tcp_init_state(client, TCP_SYN_RECEIVED);
		}
		break;

	case TCP_SYN_SENT:
		/* SYNACKM... */
		if((header.control_flag & TCP_SYN) && (header.control_flag & TCP_ACK)) {
			/* MV[PXԍAMEChEi[܂B */
			client->recv_sequence_number = header.sequence_number + 1/*SYN*/;
			client->send_window          = header.window;
			/* ESTABLISHED֑Jڂ܂B */
			tcp_init_state(client, TCP_ESTABLISHED);
		}
		break;

	case TCP_SYN_RECEIVED:
		/* ACKM... */
		if(header.control_flag & TCP_ACK) {
			/* ESTABLISHED֑Jڂ܂B */
			tcp_init_state(client, TCP_ESTABLISHED);
		}
		break;

	case TCP_ESTABLISHED:
		/* FINM... */
		if(header.control_flag & TCP_FIN) {
			/* MV[PXԍi[܂B */
			client->recv_sequence_number = header.sequence_number + 1/*FIN*/;
			/* CLOSE-WAIT֑Jڂ܂B */
			tcp_init_state(client, TCP_CLOSE_WAIT);
		}
		break;

	case TCP_FIN_WAIT_1:
		/* FINM... */
		if(header.control_flag & TCP_FIN) {
			/* MV[PXԍi[܂B */
			client->recv_sequence_number = header.sequence_number + 1/*FIN*/;
			/* CLOSING֑Jڂ܂B */
			tcp_init_state(client, TCP_CLOSING);
		/* FINMɁAACKM... */
		} else if(header.control_flag & TCP_ACK) {
			/* FIN-WAIT-2֑Jڂ܂B */
			tcp_init_state(client, TCP_FIN_WAIT_2);
		}
		break;

	case TCP_FIN_WAIT_2:
		/* FINM... */
		if(header.control_flag & TCP_FIN) {
			/* MV[PXԍi[܂B */
			client->recv_sequence_number = header.sequence_number + 1/*FIN*/;
			/* TIME-WAIT֑Jڂ܂B */
			tcp_init_state(client, TCP_TIME_WAIT);
		}
		break;

	case TCP_CLOSING:
		/* ACKM... */
		if(header.control_flag & TCP_ACK) {
			/* TIME-WAIT֑Jڂ܂B */
			tcp_init_state(client, TCP_TIME_WAIT);
		}
		break;

	case TCP_LAST_ACK:
		/* ACKM... */
		if(header.control_flag & TCP_ACK) {
			/* CLOSED֑Jڂ܂B */
			tcp_init_state(client, TCP_CLOSED);
		}
		break;

	case TCP_CLOSE_WAIT:
	case TCP_TIME_WAIT:
	case TCP_CLOSED:
		/* ܂B */
		break;

	default:
		DIE(); /* sȏ */
	}
}

/*--------------------------------------------------------------------------*/

void
tcp_start(int txque_capacity)
{
	/* ܂Amɒ~܂B */
	tcp_stop();

	/* hCo\̂NA܂B */
	memset(&tcp_driver, 0, sizeof tcp_driver);

	/* NCAgXg܂B */
	InitializeListHead(&tcp_driver.client_list);

	/* TCPvgRhCoJn܂B */
	tcp_driver.ip_client.protocol = 6/*TCP*/;
	tcp_driver.ip_client.recv = tcp_recv_callback;
	ip_open(&tcp_driver.ip_client);

	/* đ쓮p^C}Jn܂B */
	tcp_driver.timer_id = timer_start(TIMER_INTERVAL, tcp_timer_callback, NULL);
}

void
tcp_stop()
{
	/* JnĂȂ΁A܂B */
	if(!tcp_driver.client_list.Flink) {
		return;
	}

	/* đ쓮p^C}~܂B */
	timer_stop(tcp_driver.timer_id);

	/* TCPvgRhCo~܂B */
	ip_close(&tcp_driver.ip_client);

	/* hCo\̂NA܂B */
	memset(&tcp_driver, 0, sizeof tcp_driver);
}

void
tcp_open(TCPCLIENT* client, int active)
{
ENTER_CS;

	/* NCAgXgɒǉ܂B */
	InsertTailList(&tcp_driver.client_list, &client->list_entry);

	/* [J|[gw肳ĂȂ΁AGtF|[gmۂ܂B */
	if(!client->local_port) {
		client->local_port = tcp_allocate_ephemeral_port();
	}

	/* MV[PXԍAMV[PXԍAMEChE܂B */
	client->recv_sequence_number = 0;
	client->send_sequence_number = pceTimerGetCount();
	client->send_window = 0;

	/* Mobt@쐬܂B */
	client->recv_buffer = create_buffer(TCP_RECV_MSS);
	client->send_buffer = create_buffer(TCP_SEND_MSS);

	/* SYNɑΉ_~[̑Mf[^1oCgݒ肵Ă܂B
	 * ̑Mf[^͔ĵ݂ŁAۂɂ͑M܂B
	 */
	client->send_buffer->size = 1;

	/* state,T0́AActiveOpenA܂́APassiveOpen̏ɂĐݒ肵܂B */

	/* ActiveOpen */
	if(active) {
		if(!client->remote_ip_address || !client->remote_port) {
			DIE(); /* [gIPAhXA[g|[gwK{ */
		}
		/* SYN-SENT֑Jڂ܂B */
		tcp_init_state(client, TCP_SYN_SENT);

	/* PassiveOpen */
	} else {
		/* LISTEN֑Jڂ܂B */
		tcp_init_state(client, TCP_LISTEN);
	}

LEAVE_CS;
}

void
tcp_close(TCPCLIENT* client, int timeout)
{
	int T0 = pceTimerGetCount();

	/* ̃^CAEgw肳ꂽAlƂ܂B */
	if(timeout < 0) {
		timeout = CLOSE_TIMEOUT;
	}

	do {

ENTER_CS;

		/* Ԃɂ... */
		switch(client->state) {

		case TCP_LISTEN:
		case TCP_SYN_SENT:
			/* CLOSED֑Jڂ܂B */
			tcp_init_state(client, TCP_CLOSED);
			break;

		case TCP_SYN_RECEIVED:
			/* ܂ASYNɑΉ_~[̑Mf[^1oCgcĂ͂łB
			 * FINɑΉ_~[̑Mf[^1oCgƂāÂ܂ܗp܂B
			 */
			if(client->send_buffer->size != 1) {
				DIE(); /* L蓾Ȃ */
			}
			/* FIN-WAIT-1֑Jڂ܂B */
			tcp_init_state(client, TCP_FIN_WAIT_1);
			break;

		case TCP_ESTABLISHED:
			/* Mobt@ɂȂ̂҂... */
			if(!client->send_buffer->size) {
				/* FINɑΉ_~[̑Mf[^1oCgݒ肵Ă܂B
				 * ̑Mf[^͔ĵ݂ŁAۂɂ͑M܂B
				 */
				client->send_buffer->size = 1;
				/* FIN-WAIT-1֑Jڂ܂B */
				tcp_init_state(client, TCP_FIN_WAIT_1);
			}
			break;

		case TCP_CLOSE_WAIT:
			/* Mobt@ɂȂ̂҂... */
			if(!client->send_buffer->size) {
				/* FINɑΉ_~[̑Mf[^1oCgݒ肵Ă܂B
				 * ̑Mf[^͔ĵ݂ŁAۂɂ͑M܂B
				 */
				client->send_buffer->size = 1;
				/* LAST_ACK֑Jڂ܂B */
				tcp_init_state(client, TCP_LAST_ACK);
			}
			break;
		}

		/* CLOSEDɂȂ邩A܂́A^CAEg...
		 * * 2005/09/19݂̎ł́ATIME-WAIT̏ԑJڂs܂B
		 *   {́ATIME-WAITZԂ̃^CAEgCLOSED֑Jڂ̂łA݂̎͂ȂĂ܂B
		 *   ̏ԂƓAtcp_close()Ɏw肳ꂽ^CAEgo߂܂ŁATIME-WAITɗ܂Ă܂܂B
		 *   Ȃ킿AؒfJnꍇAK^CAEg҂ƂɂȂAvO̔x܂B
		 * - ̖ɂ́ATIME-WAITCLOSEDƓƂATIME-WAITɂȂ犮Ƃ@łB
		 *   TIME-WAITŒZԗ܂ׂŔAŌACKɓB̂҂ƂアRɂ̂łA
		 *   ɂ摊肩͖̉AmɓB邱Ƃۏ؂ł̂ł͗L܂B
		 *   ]āATIME-WAITŒZԗ܂Kv͂قƂǂ܂B
		 * - ΂炭lqāAؒf̃vO̒xꂪCɂȂ悤Ȃ΁Aq̕@ő΍􂵂ĂB
		 * {{2005/09/19 q̕@ő΍􂵂܂}}
		 */
		//if((client->state == TCP_CLOSED) || (pceTimerGetCount() - T0 >= timeout)) {
		//{{2005/09/19 q̕@ő΍􂵂܂}}
		if((client->state == TCP_CLOSED) || (client->state == TCP_TIME_WAIT) || (pceTimerGetCount() - T0 >= timeout)) {

			/* NCAgXg菜܂B */
			RemoveEntryList(&client->list_entry);

			/* Mobt@܂B */
			delete_buffer(client->recv_buffer);
			delete_buffer(client->send_buffer);

			/* ؒf҂[vI܂B */
			client = NULL;
		}

LEAVE_CS;

	} while(client);
}

int
tcp_recv(TCPCLIENT* client, void* data/*[maxlength]*/, int maxlength)
{
	int result;

ENTER_CS;

	/* Mobt@f[^ǂݏo܂B */
	result = read_buffer(client->recv_buffer, data, maxlength);

	/* Mf[^L... */
	if(result) {

		/* Mobt@f[^ǂݏoƂɂAMobt@ɂȂA
		 * MEChEƂʒm邽߂ɁAđs܂B
		 * - gMobt@ɂȂhƂ܂߂ȂƁAtcp_recv()1oCgÂvꂽꍇɁA
		 *   AMEChE̒ʒm𑗐M邱ƂɂȂAMobt@\Ȃ܂B
		 *   ̂悤Ȗh߂ɁAMobt@ɂȂ܂ŁAʒm̑Mx点邱Ƃɂ܂B
		 * - gMobt@łȂAvP[V͕ʂ̏sĂāAMf[^҂ĂȂh
		 *   ƌȂ̂ŁAfbhbNɂ͂ȂȂ͂łB
		 * - M\ԈȊOł͖̂̏ӖłAsĂ薳Ǝv܂B
		 */
		if(!client->recv_buffer->size) {
			tcp_exec_state(client);
		}

	/* Mf[^... */
	} else {
		switch(client->state) {

		/* ȉ̏Ԃ́AM\\܂B
		 * ̂ƃf[^\̂ŁAgMf[^hƂĈ܂B
		 */
		case TCP_ESTABLISHED:
		case TCP_FIN_WAIT_1:
			/* result=0ł */
			break;

		/* ȉ̏Ԃ́Aڑ҂\܂B
		 * ̂ƎM\ƂȂ\L̂ŁAgMf[^hƓƂ܂B
		 */
		case TCP_LISTEN:
		case TCP_SYN_SENT:
		case TCP_SYN_RECEIVED:
			/* result=0ł */
			break;

		/* ȊȌԂ́AMI\܂B
		 * ̂ƎM\ƂȂ\͖̂ŁAgMIhƂĈ܂B
		 */
		default:
			result = -1;
			break;
		}
	}

LEAVE_CS;

	return result;
}

int
tcp_send(TCPCLIENT* client, const void* data/*[length]*/, int length)
{
	int result;

ENTER_CS;

	switch(client->state) {

	/* ȉ̏Ԃ́AM\\܂B
	 * Mobt@Ƀf[^ǉAǉłAACKAf[^𑗐M܂B
	 */
	case TCP_ESTABLISHED:
	case TCP_CLOSE_WAIT:
		result = write_buffer(client->send_buffer, data, length);
		if(result > 0) {
			tcp_exec_state(client);
		}
		break;

	/* ȉ̏Ԃ́Aڑ҂\܂B
	 * ̂ƑM\ƂȂ\L̂ŁAgMobt@󂫖hƓƂ܂B
	 */
	case TCP_LISTEN:
	case TCP_SYN_SENT:
	case TCP_SYN_RECEIVED:
		result = 0;
		break;

	/* ȊȌԂ́AMI\܂B
	 * ̂ƑM\ƂȂ\͖̂ŁAgMIhƂĈ܂B
	 */
	default:
		result = -1;
		break;
	}

LEAVE_CS;

	return result;
}

/****************************************************************************
 *	TCP\Pbg
 ****************************************************************************/

TCPSOCKET*
tcp_socket_open(int local_port, int remote_ip_address, int remote_port, int active)
{
	TCPSOCKET* tcp_socket;

	/* TCP\Pbg\̂̃mۂ܂B */
	tcp_socket = malloc(sizeof(TCPSOCKET));
	if(!tcp_socket) {
		DIE(); /* s */
	}
	memset(tcp_socket, 0, sizeof(TCPSOCKET));

	/* TCPNCAgo^܂B */
	tcp_socket->tcp_client.local_port        = local_port;
	tcp_socket->tcp_client.remote_ip_address = remote_ip_address;
	tcp_socket->tcp_client.remote_port       = remote_port;
	tcp_open(&tcp_socket->tcp_client, active);

	return tcp_socket;
}

void
tcp_socket_close(TCPSOCKET* tcp_socket, int timeout)
{
	/* TCPNCAgo^܂B */
	tcp_close(&tcp_socket->tcp_client, timeout);

	/* TCP\Pbg\̂̃܂B */
	free(tcp_socket);
}

int
tcp_socket_recv(TCPSOCKET* tcp_socket, void* data/*[maxlength]*/, int maxlength)
{
	return tcp_recv(&tcp_socket->tcp_client, data, maxlength);
}

int
tcp_socket_send(TCPSOCKET* tcp_socket, const void* data/*[length]*/, int length)
{
	return tcp_send(&tcp_socket->tcp_client, data, length);
}
