/*	
 *	clipstr.c
 *
 *	[eBeBF񑀍
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Sat Oct 11 12:29:17 JST 2014 Naoyuki Sawa
 *	- 쐬JnB
 *	- strtrim(),strescape(),strcompress()Aclipmisc.h,cclipstr.h,cֈړ܂B
 *	- strfreev(),strv_length(),strdup_printf(),strdup_vprintf(),strjoin(),strjoinv(),strsplit(),strsplit_set()ǉ܂B
 *	* Mon Oct 13 02:54:55 JST 2014 Naoyuki Sawa
 *	- str_has_prefix(),str_has_suffix()ǉ܂B
 *	* Sat Oct 18 18:55:59 JST 2014 Naoyuki Sawa
 *	- string_match()ǉ܂B
 *	* Thu Nov 06 00:58:25 JST 2014 Naoyuki Sawa
 *	- strreverse()ǉ܂B
 *	* Sat Nov 08 16:50:24 JST 2014 Naoyuki Sawa
 *	- strdupv()ǉ܂B
 *	* Tue Nov 11 23:26:40 JST 2014 Naoyuki Sawa
 *	- strconcat()ǉ܂B
 *	* Sat Nov 15 20:39:46 JST 2014 Naoyuki Sawa
 *	- str_has_prefix_suffix̃oOC܂B
 *	  str_has_prefix_suffix̒%r3gpĂ̂ɁA%r0`%r2ޔĂȂoOłB
 *	  ̂߂ɁAstr_has_prefix_suffixĂяoW[AsȓNĂ܂B
 *	  ̓Iɂ́Acliptcl.cTcl_GetIndex()AAhXG[ŕsIĂ܂Ă܂B
 *	* Sat Mar 07 16:39:40 JST 2015 Naoyuki Sawa
 *	- strstrip(),strchug(),strchomp()ǉ܂B
 *	* Sat Mar 07 23:27:25 JST 2015 Naoyuki Sawa
 *	- textwrap()ǉ܂B
 *	* Sun Mar 08 10:55:52 JST 2015 Naoyuki Sawa
 *	- strsplit_set()ƃrbg}bvGC𕹗pAx傫ȃt@C𕪊悤ƂƁArbg}bvGCG[~鎖L܂B
 *	  ̖ɂĒʂAclipstr.cstrsplit_set()֐̏ɒǋL܂B
 *	* Mon Mar 09 23:08:36 JST 2015 Naoyuki Sawa
 *	- textwrap()AZu܂B
 *	* Sun Jul 19 12:59:05 JST 2015 Naoyuki Sawa
 *	- quark_from_string(),quark_to_string(),intern_string()ǉ܂B
 *	* Thu Jul 23 21:03:39 JST 2015 Naoyuki Sawa
 *	- strreplace()ǉ܂B
 *	* Wed Aug 12 21:46:27 JST 2015 Naoyuki Sawa
 *	- memdup()ǉ܂B
 */
#include "clip.h"

/*****************************************************************************
 *	g
 *****************************************************************************/

static const char strtrim_reject[]="\t\n\v\f\r ";//isspace()Ɠ	//asmubNQƂ'萔'́A__attribute__((unused))錾ȂĂxoȂ悤łBAasmubNQƂ'ϐ''֐'́A__attribute__((unused))錾ȂΌxo܂B
#ifndef PIECE
char* strtrim(const char* s, int mode, const char* reject) {
	int c;
	char *t, *u;
	if(!reject) { reject = strtrim_reject; }
	switch(mode) {
	case 0://[ɂw蕶
		t = strtrim(s, 1, reject);					//[ɂw蕶āAr̕쐬B
		u = strtrim(t, 2, reject);					//E[ɂw蕶āAʂ̕쐬B
		free(t);							//[ɂw蕶Ar̕폜B
		break;
	case 1://[ɂw蕶
		while((c = *s++) && strchr(reject, c)) { /** no job **/ }	//I[łȂAw蕶ȊO܂ŁA̕֐i߂B
		if(!(u = strdup(s - 1))) { DIE(); }				//ʂ̕쐬Bs1֐i݉߂Ă邱ƂɒӂB
		break;
	case 2://E[ɂw蕶
		t = strchr(s, '\0');						//I[nul̈ʒu֐i߂B
		do { t--; } while((t >= s) && strchr(reject, *t));		//O֖̕߂B擪𒴂,,w蕶ȊO甲B
		if(!(u = strndup(s, t - s + 1))) { DIE(); }			//ʂ̕쐬Bt1O֖߂߂Ă邱ƂɒӂB
		break;
	case 3://ɂSĂ̎w蕶
		if(!(t = u = strdup(s))) { DIE(); }				//𕡐B
		while((c = *t++ = *s++)) { if(strchr(reject, c)) { t--; } }	//w蕶ȊOOl߂ŃRs[Bcasê݁Aʂ̕傫ȃ̂܂܂ɂȂ邪AgppxႢƎv̂ŋe邱ƂɂB
		break;
	default:
		DIE();
	}
	return u;
}
#else //PIECE
//AZuړÍAR[hTCY̒ጸłB
//R[hTCYA(C=276oCg)(Asm=192oCg)ɏȂ܂B
//x́Amۂ̏ɗv鎞Ԃ傫̂ŁAX҂ł܂B
char* strtrim(const char* s, int mode, const char* reject);
asm("
		.code
		.align		1
		.global		strtrim
strtrim:
		pushn		%r3
		;//%r12 := s
		;//%r13 := mode
		;//%r14 := reject
		cmp		%r14, 0				;//if(!reject) { reject = strtrim_reject }
		jrne.d		5				;//
		 cmp		%r13, 3				;//%psr := ((unsigned)mode <=> (unsigned)3)			*delay*
		 ext		      strtrim_reject@h		;//							@
		 ext		      strtrim_reject@m		;//							@
		 ld.w		%r14, strtrim_reject@l		;//							@
		jrugt		strtrim_DIE			;//if((unsigned)mode >  (unsigned)3) { goto DIE() }	
		ld.w		%r0, %r12			;//%r0  := s
		jreq.d		strtrim_case_3			;//if((unsigned)mode == (unsigned)3) { goto case_3 }
		ld.w		%r1, %r14			;//%r1  := reject						*delay*
		cmp		%r13, 1				;//%psr := ((unsigned)mode <=> (unsigned)1)
		jrugt		strtrim_case_2			;//if((unsigned)mode >  (unsigned)1) { goto case_2 }
		jreq		strtrim_case_1			;//if((unsigned)mode == (unsigned)1) { goto case_1 }
		;//---------------------------------------------;//
;//strtrim_case_0:
		;//%r0  := s			gȂ
		;//%r1  := reject
		;//%r12 := s
		;//%r14 := reject
		call.d		strtrim				;//%r10 := t = strtrim(s, 1, reject)
		ld.w		%r13, 1				;//%r13 :=                1					*delay*
		ld.w		%r2, %r10			;//%r2  := t
		ld.w		%r12, %r2			;//%r12 :=             t
		ld.w		%r13, 2				;//%r13 :=                2
		call.d		strtrim				;//%r10 := u = strtrim(t, 2, reject)
		ld.w		%r14, %r1			;//%r14 :=                   reject				*delay*
		ld.w		%r3, %r10			;//%r3  := u
		xcall.d		free				;//   free(t)
		ld.w		%r12, %r2			;//%r12 := t							*delay*
		jp		strtrim_return_u		;//return  u
		;//---------------------------------------------;//
strtrim_case_1:	
		;//%r0  := s
		;//%r1  := reject
		;//%r12 := s			gȂ
		;//%r14 := reject		gȂ
strtrim_case_1_L10:						;//do {
		ld.b		%r13, [%r0]+			;//%r13 := c = *s++
		cmp		%r13, 0				;//if(!c) { break }
		jreq		strtrim_case_1_L20		;//
		xcall.d		strchr				;//%r10 := strchr(reject, c)
		ld.w		%r12, %r1			;//%r12 :=        reject					*delay*
		cmp		%r10, 0				;//} while(strchr(reject, c))
		jrne		strtrim_case_1_L10		;//
strtrim_case_1_L20:
		sub		%r0, 1				;//%r0  := s--
		jp.d		strtrim_case_2_L30		;//goto case_2_L30
		ld.w		%r13, -1			;//%r13 := n = SIZE_MAX						*delay*
		;//---------------------------------------------;//
strtrim_case_2:
		;//%r0  := s
		;//%r1  := reject
		;//%r12 := s
		;//%r14 := reject		gȂ
		xcall.d		strchr				;//%r10 := t = strchr(s, '0')
		ld.w		%r13, 0				;//%r13 :=               '0'					*delay*
		ld.w		%r2, %r10			;//%r2  := t
strtrim_case_2_L10:						;//do {
		cmp		%r2, %r0			;//     if(t-- <= s) { break }
		jrule.d		strtrim_case_2_L20		;//
		sub		%r2, 1				;//%r2  := t--							*delay*
		ld.b		%r13, [%r2]			;//
		xcall.d		strchr				;//%r10 := strchr(reject, *t)
		ld.w		%r12, %r1			;//%r12 :=        reject					*delay*
		cmp		%r10, 0				;//} while(strchr(reject, *t))
		jrne		strtrim_case_2_L10		;//
strtrim_case_2_L20:						;//
		ld.w		%r13, %r2			;//%r13 :=     t
		sub		%r13, %r0			;//%r13 :=     t - s
		add		%r13, 1				;//%r13 := n = t - s + 1
strtrim_case_2_L30:						;//
		xcall.d		strndup				;//%r10 := u = strndup(s, n)
		ld.w		%r12, %r0			;//%r12 :=             s					*delay*
		cmp		%r10, 0				;//    if(!u) { DIE() }
		jreq		strtrim_DIE			;//
		jp.d		strtrim_return_u		;//return  u
		ld.w		%r3, %r10			;//%r3  := u							*delay*
		;//---------------------------------------------;//
strtrim_case_3:
		;//%r0  := s
		;//%r1  := reject
		;//%r12 := s
		;//%r14 := reject		gȂ
		xcall		strdup				;//%r10 := u = strdup(s, n)
		cmp		%r10, 0				;//    if(!u) { DIE() }
		jreq		strtrim_DIE			;//
		ld.w		%r2, %r10			;//%r2  := t
		ld.w		%r3, %r10			;//%r2  := u
strtrim_case_3_L10:						;//for(;;) {
		ld.b		%r13, [%r0]+			;//%r13 := c = *s++
		ld.b		[%r2]+, %r13			;//*t++  = c
		cmp		%r13, 0				;//    if(!c) { return  u }
		jreq		strtrim_return_u		;//
		xcall.d		strchr				;//%r10 := p = strchr(reject, c)
		ld.w		%r12, %r1			;//%r12 :=            reject					*delay*
		cmp		%r8, %r10			;//%psr(C) :=   !!p								
		jp.d		strtrim_case_3_L10		;//										uif(strchr(reject, c)) { t--; }v򖳂ŎHv
		sbc		%r2, %r8			;//%r2  := t -= !!p						*delay*		
		;//---------------------------------------------;//
strtrim_return_u:
		;//%r3  := u
		ld.w		%r10, %r3			;//%r10 := u
		popn		%r3				;//
		ret						;//return  u
");
static void __attribute__((noreturn,unused))/*asmubNQ*/ strtrim_DIE() { DIE(); }
#endif//PIECE

#ifndef PIECE
static char* strstrip_strchug_strchomp(char* s, int mode) {
	char* t = strtrim(s, mode, NULL);	//󔒕ꎞIȕ쐬B
	strcpy(s, t);	//ꎞIȕ̕ɃRs[B
	free(t);	//ꎞIȕJB
	return s;	//̕ԂB
}
char* strstrip(char* s) { return strstrip_strchug_strchomp(s, 0); }
char* strchug( char* s) { return strstrip_strchug_strchomp(s, 1); }
char* strchomp(char* s) { return strstrip_strchug_strchomp(s, 2); }
#else //PIECE
char* strstrip(char* s);
char* strchug( char* s);
char* strchomp(char* s);
asm("
		.code
		.align		1
		.global		strstrip
		.global		strchug
		.global		strchomp
strstrip:
		jp.d		strstrip_strchug_strchomp
		ld.w		%r13, 0				;//%r13 :=                mode = 0	*delay*
strchug:
		jp.d		strstrip_strchug_strchomp
		ld.w		%r13, 1				;//%r13 :=                mode = 1	*delay*
strchomp:
		ld.w		%r13, 2				;//%r13 :=                mode = 2
strstrip_strchug_strchomp:
		pushn		%r1
		ld.w		%r0, %r12			;//%r0  := s
		xcall.d		strtrim				;//%r10 := t = strtrim(s, mode, NULL)
		ld.w		%r14, 0				;//%r14 :=                      NULL	*delay*
		ld.w		%r1, %r10			;//%r0  := t
		ld.w		%r12, %r0			;//%r12 :=        s
		xcall.d		strcpy				;//%r10 := strcpy(s, t)
		ld.w		%r13, %r1			;//%r13 :=           t			*delay*
		xcall.d		free				;//        free(t)
		ld.w		%r12, %r1			;//%r12 :=      t			*delay*
		ld.w		%r10, %r0			;//%r10 := s
		popn		%r1				;//
		ret						;//return  2
");
#endif//PIECE

/*****************************************************************************
 *	GXP[v
 *****************************************************************************/

//AZuړÍAR[hTCY̒ጸłB
//R[hTCYA(C=528oCg)(Asm=456oCg)ɏȂ܂B(TBL_strescape[],strescape(),strcompress()̍vTCY)
//x́Amۂ̏ɗv鎞Ԃ傫̂ŁAX҂ł܂B
#ifdef  __GNUC__
//GCĆu\ev(W̃GXP[vV[PX)ɑΉĂB
#define SIZE_strescape 13//
static const char TBL_strescape[]={//                        		//asmubNQƂ'萔'́A__attribute__((unused))錾ȂĂxoȂ悤łBAasmubNQƂ'ϐ''֐'́A__attribute__((unused))錾ȂΌxo܂B
//1    2    3    4    5    6    7    8    9   10   11   12   13
'\a','\b','\e','\f','\n','\r','\t','\v','\?','\'','\"','\\','\0',	//'\0'strescape()  ōsstrchr()̏I[płBGXP[vΏەł͂܂B
 'a', 'b', 'e', 'f', 'n', 'r', 't', 'v','\?','\'','\"','\\','\0'};	//'\0'strcompress()ōsstrchr()̏I[płBGXP[vΏەł͂܂B
#else //__GNUC__
//VC++6.0́u\ev(W̃GXP[vV[PX)ɑΉĂȂB
#define SIZE_strescape 12//
static const char TBL_strescape[]={//                        
//1    2         3    4    5    6    7    8    9   10   11   12
'\a','\b',     '\f','\n','\r','\t','\v','\?','\'','\"','\\','\0',	//'\0'strescape()  ōsstrchr()̏I[płBGXP[vΏەł͂܂B
 'a', 'b',      'f', 'n', 'r', 't', 'v','\?','\'','\"','\\','\0'};	//'\0'strcompress()ōsstrchr()̏I[płBGXP[vΏەł͂܂B
#endif//__GNUC__
#ifndef PIECE
char* strescape(const char* s, const char* need_escape) {
	char* r = NULL;
	for(;;) {//1ڂŕ𐔂A2ڂŕi[
		const char *t = s, *p;
		      char *u = r;
		int c;
		while((c = *t++)) {
			/* C̃GXP[vV[PX */
			if((p = strchr(TBL_strescape, c))) {		//e[ȗO猟
				if(r/*2*/) {
					u[0] = '\\';
					u[1] = *(p + SIZE_strescape);	//e[ǔ㔼փVtg
				}
				u += 2;
			/* AvP[V`̃GXP[vKvȕ */
			} else if(need_escape && strchr(need_escape, c)) {
				if(r/*2*/) {
					u[0] = '\\';
					u[1] = c;
				}
				u += 2;
			/* 󎚉\łȂ */
			} else if(!isprint(c)) {
				if(r/*2*/) {
					u[0] = '\\';
					u[1] = '0' + ((c >> 6) & 3);	//
					u[2] = '0' + ((c >> 3) & 7);	//̌'0'`'7'ꍇ̂߂ɏɍő3o͂ĂB
					u[3] = '0' + ((c >> 0) & 7);	//
				}
				u += 4;
			/* ȊO */
			} else {
				if(r/*2*/) {
					u[0] = c;
				}
				u += 1;
			}
		}
		if(r/*2*/) {
			u[0] = '\0';
			return r;
		}
		if(!(r = malloc((int)u + 1/*nul*/))) { DIE(); }
	}
}
#else //PIECE
char* strescape(const char* s, const char* need_escape);
asm("
		.code
		.align		1
		.global		strescape
strescape:
		pushn		%r3
		xsub		%sp, %sp, 8
		xld.w		[%sp+4], %r12			;//[%sp+4] := s
		xld.w		[%sp+0], %r13			;//[%sp+0] := need_escape
		ld.w		%r0, 0				;//%r0  := r = NULL
		;//---------------------------------------------;//
strescape_L10:							;//for(;;) {
		xld.w		%r1, [%sp+4]			;//  %r1  := t = s
		ld.w		%r2, %r0			;//  %r2  := u = r
		;//---------------------------------------------;//
strescape_L20:							;//
		ld.b		%r3, [%r1]+			;//  %r3  := c = *t++
		cmp		%r3, 0				;//  if(!c) {
		jrne		strescape_L30
		cmp		%r0, 0				;//    if(!r) {
		jrne		strescape_L25
		add		%r2, 1				;//      %r2  :=            u + 1
		xcall.d		malloc				;//      %r10 := r = malloc(u + 1)
		ld.w		%r12, %r2			;//      %r12 :=            u + 1				*delay*
		cmp		%r10, 0				;//      if(!r) { DIE() }
		jreq		strescape_DIE
		jp.d		strescape_L10
		ld.w		%r0, %r10			;//      %r0  := r						*delay*
strescape_L25:							;//    } else {
		ld.b		[%r2], %r8			;//      *u    = '0'
		ld.w		%r10, %r0			;//      return  r
		xadd		%sp, %sp, 8
		popn		%r3
		ret						;//    }
		;//---------------------------------------------;//  } else {
strescape_L30:
		xld.w		%r12, TBL_strescape		;//    %r12 :=            TBL_strescape
		xcall.d		strchr				;//    %r10 := p = strchr(TBL_strescape, c))
		ld.w		%r13, %r3			;//    %r13 :=                           c			*delay*
		cmp		%r10, 0				;//    if(    (p = strchr(TBL_strescape, c)) {
		jreq		strescape_L40
		cmp		%r0, 0				;//      if(!r) { u += 2
		jreq		strescape_ADD_2			;//      } else {
		xld.w		%r9, 92				;//        %r9  := ''
		ld.b		[%r2]+, %r9			;//        *u++  = ''
		add		%r10, 13			;//        %r10 :=   p + SIZE_strescape
		ld.b		%r9, [%r10]			;//        %r9  := *(p + SIZE_strescape)
		ld.b		[%r2]+, %r9			;//        *u++  = *(p + SIZE_strescape)
		jp		strescape_L20			;//      }
		;//---------------------------------------------;//    } else
strescape_L40:
		xld.w		%r12, [%sp+0]			;//    %r12 := need_escape
		cmp		%r12, 0				;//    if((    need_escape) &&
		jreq		strescape_L50
		xcall.d		strchr				;//    strchr( need_escape, c)) {
		ld.w		%r13, %r3			;//    %r13 :=              c					*delay*
		cmp		%r10, 0
		jreq		strescape_L50
		cmp		%r0, 0				;//      if(!r) { u += 2
		jreq		strescape_ADD_2			;//      } else {
		xld.w		%r9, 92				;//        %r9  := ''
		ld.b		[%r2]+, %r9			;//        *u++  = ''
		ld.b		[%r2]+, %r3			;//        *u++  = c
		jp		strescape_L20			;//      }
		;//---------------------------------------------;//    } else
strescape_L50:
		xcall.d		isprint				;//    if(isprint(c)) {
		ld.w		%r12, %r3			;//    %r12 :=    c						*delay*
		cmp		%r10, 0
		jrne		strescape_L60
		cmp		%r0, 0				;//      if(!r) { u += 4
		jreq		strescape_ADD_4			;//      } else {
		xld.w		%r9, 92				;//        %r9  := ''
		ld.b		[%r2]+, %r9			;//        *u++  = ''
		xand		%r5, %r3, 7			;//        %r5  :=        (c >> 0) & 7
		add		%r5, 48				;//        %r5  := '0' + ((c >> 0) & 7)
		sra		%r3, 3				;//        %r3  :=         c >> 3
		xand		%r4, %r3, 7			;//        %r5  :=        (c >> 3) & 7
		add		%r4, 48				;//        %r5  := '0' + ((c >> 3) & 7
		sra		%r3, 3				;//        %r3  :=         c >> 6
		xand		%r3, %r3, 3			;//        %r3  :=        (c >> 6) & 3
		add		%r3, 48				;//        %r3  := '0' + ((c >> 6) & 3
		ld.b		[%r2]+, %r3			;//        *u++  = '0' + ((c >> 6) & 3
		ld.b		[%r2]+, %r4			;//        *u++  = '0' + ((c >> 3) & 7
		ld.b		[%r2]+, %r5			;//        *u++  = '0' + ((c >> 0) & 7
		jp		strescape_L20			;//      }
		;//---------------------------------------------;//    } else {
strescape_L60:
		cmp		%r0, 0				;//      if(!r) { u += 1
		jreq		strescape_ADD_1			;//      } else {
		ld.b		[%r2]+, %r3			;//        *u++  = c
		jp		strescape_L20			;//      }
		;//---------------------------------------------;//} } }
strescape_ADD_4:
		add		%r2, 2				;//%r2  := u += 2 + 1 + 1
strescape_ADD_2:
		add		%r2, 1				;//%r2  := u +=     1 + 1
strescape_ADD_1:
		jp.d		strescape_L20
		add		%r2, 1				;//%r2  := u +=         1					*delay*
");
static void __attribute__((noreturn,unused))/*asmubNQ*/ strescape_DIE() { DIE(); }
#endif//PIECE

#ifndef PIECE
char* strcompress(const char* s, char** endptr, const char* delim) {
	char* r = NULL;
	for(;;) {//1ڂŕ𐔂A2ڂŕi[
		const char *t = s, *p;
		      char *u = r;
		int c;
		while((c = *t++) && !(delim && strchr(delim, c))) {
			if(c != '\\') { goto L_COPY; }
			/* '\'nulꍇA'\'jď2.sIB('\'nul̂'GXP[vꂽ'ƂĕsȀI[𒴂Ȃ悤ɍŒ̑΍sƂɂ)
			 * ustrchr(`,'\0')v͕KNULĽʂɂȂ̂ŁAstrchr()p锻ɍsȂ΂ȂȂƂɒӂB */
			if(!(c = *t++)) { break; }
			/* '\'ɑC̃GXP[vV[PXA1ɕϊďo͂B */
			if((p = strchr(TBL_strescape + SIZE_strescape, c))) {	//e[ǔ㔼猟
				if(r/*2*/) { *u = *(p - SIZE_strescape); }	//e[ȗOփVtg
				u++;
			/* '\'ɑ8i\L(1`3)A1ɕϊďo͂B */
			} else if((c >= '0') && (c <= '7')) {
				int x = (c - '0');
				if(((c = *t) >= '0') && (c <= '7')) {
					x = (x << 3) | (c - '0'), t++;
					if(((c = *t) >= '0') && (c <= '7')) {
						x = (x << 3) | (c - '0'), t++;
					}
				}
				if(r/*2*/) { *u = x; }
				u++;
			/* '\'ɑ16i\L(1`)A1ɕϊďo͂B */
			} else if((c == 'x') || (c == 'X')) {
				int x = strtoul(t, (char**)&t, 16);
				if(r/*2*/) { *u = x; }
				u++;
			/* šp */
			} else if(c == '\n') {
				/** no job **/
			/* '\'ɑȊO̕A'\'폜ĕ݂̂ɕϊďo͂B('AvP[V`̃GXP[vKvȕ'܂) */
			} else {
L_COPY:				if(r/*2*/) { *u = c; }
				u++;
			}
		}
		if(r/*2*/) {
			if(endptr) { *endptr = (char*)(t - 1); }
			*u = '\0';
			return r;
		}
		if(!(r = malloc((int)u + 1/*nul*/))) { DIE(); }
	}
}
#else //PIECE
char* strcompress(const char* s, char** endptr, const char* delim);
asm("
		.code
		.align		1
		.global		strcompress
strcompress:
		pushn		%r3
		xsub		%sp, %sp, 16
		xld.w		[%sp+4], %r12			;//[%sp+4]  := s
		xld.w		[%sp+8], %r13			;//[%sp+8]  := endptr
		xld.w		[%sp+12], %r14			;//[%sp+12] := delim
		ld.w		%r0, 0				;//%r0  := r = NULL
		;//---------------------------------------------;//
strcompress_L10:						;//for(;;) {
		xld.w		%r1, [%sp+4]			;//  %r1  := t = s
		ld.w		%r2, %r0			;//  %r2  := u = r
		;//---------------------------------------------;//
strcompress_L20:						;//
		ld.b		%r3, [%r1]+			;//  %r3  := c = *t++
		cmp		%r3, 0				;//  if(!c || (delim && strchr(delim, c))) {
		jreq		strcompress_BREAK
		xld.w		%r12, [%sp+12]			;//  %r12 :=                   delim
		cmp		%r12, 0
		jreq		strcompress_L30
		xcall.d		strchr				;//  %r10 :=            strchr(delim, c)
		ld.w		%r13, %r3			;//  %r13 :=                          c				*delay*
		cmp		%r10, 0
		jreq		strcompress_L30
strcompress_BREAK:
		cmp		%r0, 0				;//    if(!r) {
		jrne		strcompress_L25
		add		%r2, 1				;//      %r2  :=            u + 1
		xcall.d		malloc				;//      %r10 := r = malloc(u + 1)
		ld.w		%r12, %r2			;//      %r12 :=            u + 1				*delay*
		cmp		%r10, 0				;//      if(!r) { DIE() }
		jreq		strcompress_DIE
		jp.d		strcompress_L10
		ld.w		%r0, %r10			;//      %r0  := r						*delay*
strcompress_L25:						;//    } else {
		xld.w		%r9, [%sp+8]			;//      %r9  := endptr
		cmp		%r9, 0				;//      if(endptr) {
		jreq		3
		 sub		%r1, 1				;//        *endptr = t - 1
		 ld.w		[%r9], %r1			;//      }
		ld.b		[%r2], %r8			;//      *u    = '0'
		ld.w		%r10, %r0			;//      return  r
		xadd		%sp, %sp, 16
		popn		%r3
		ret						;//    }
		;//---------------------------------------------;//  } else {
strcompress_L30:
		xcmp		%r3, 92				;//    if(c != '') { goto COPY }
		jrne		strcompress_COPY
		ld.b		%r3, [%r1]+			;//    %r3  := c = *t++
		cmp		%r3, 0				;//    if(!c) { goto BREAK }
		jreq		strcompress_BREAK
		xld.w		%r12, TBL_strescape+13		;//    %r12 :=            TBL_strescape + SIZE_strescape
		xcall.d		strchr				;//    %r10 := p = strchr(TBL_strescape + SIZE_strescape, c))
		ld.w		%r13, %r3			;//    %r13 :=                                            c	*delay*
		cmp		%r10, 0				;//    if(    (p = strchr(TBL_strescape + SIZE_strescape, c)) {
		jreq		strcompress_L40
		cmp		%r0, 0				;//      if(!r) { u += 1
		jreq		strcompress_ADD_1		;//      } else {
		sub		%r10, 13			;//        %r10 :=   p - SIZE_strescape
		ld.b		%r9, [%r10]			;//        %r9  := *(p - SIZE_strescape)
		ld.b		[%r2]+, %r9			;//        *u++  = *(p - SIZE_strescape)
		jp		strcompress_L20			;//      }
		;//---------------------------------------------;//    } else
strcompress_L40:
		ld.w		%r4, %r3			;//    %r4  := x = c
		sub		%r4, 48				;//    %r4  := x -= '0'
		cmp		%r4, 7				;//    if((unsigned)x <= (unsigned)7) {
		jrugt		strcompress_L50
		ld.b		%r9, [%r1]			;//      %r9  := y = *t
		sub		%r9, 48				;//      %r9  := y -= '0'
		cmp		%r9, 7				;//      if((unsigned)y <= (unsigned)7) {
		jrugt		strcompress_L45
		 sla		%r4, 3				;//        %r4  := x <<= 3
		 or		%r4, %r9			;//        %r4  := x  |= y
		 add		%r1, 1				;//        %r1  := t++
		 ld.b		%r9, [%r1]			;//        %r9  := y = *t
		 sub		%r9, 48				;//        %r9  := y -= '0'
		 cmp		%r9, 7				;//        if((unsigned)y <= (unsigned)7) {
		 jrugt		strcompress_L45
		  sla		%r4, 3				;//          %r4  := x <<= 3
		  or		%r4, %r9			;//          %r4  := x  |= y
		  add		%r1, 1				;//          %r1  := t++
strcompress_L45:						;//      } }
		cmp		%r0, 0				;//      if(!r) { u += 1
		jreq		strcompress_ADD_1		;//      } else {
		ld.b		[%r2]+, %r4			;//        *u++  = x
		jp		strcompress_L20			;//      }
		;//---------------------------------------------;//    } else
strcompress_L50:
		xand		%r9, %r3, -33			;//    if((c == 'x') || (c == 'X')) {
		xcmp		%r9, 88
		jrne		strcompress_L60
		cmp		%r0, 0				;//      if(!r) { u += 1
		jreq		strcompress_ADD_1		;//      } else {
		ld.w		%r12, %r1			;//        %r12 :=             t
		ld.w		%r13, %sp			;//        %r13 :=                &t
		xld.w		[%sp+0], %r1
		xcall.d		strtoul				;//        %r10 := x = strtoul(t, &t, 16)
		ld.w		%r14, 16			;//        %r14 :=                    16			*delay*
		xld.w		%r1, [%sp+0]			;//        %r1  :=                 t
		ld.b		[%r2]+, %r10			;//        *u++  = x
		jp		strcompress_L20			;//      }
		;//---------------------------------------------;//    } else
strcompress_L60:
		cmp		%r3, 10				;//    if(c == 'n') {
		jreq		strcompress_L20			;//      /** no job **/
		;//---------------------------------------------;//    } else {
strcompress_COPY:
		cmp		%r0, 0				;//      if(!r) { u += 1
		jreq		strcompress_ADD_1		;//      } else {
		ld.b		[%r2]+, %r3			;//        *u++  = c
		jp		strcompress_L20			;//      }
		;//---------------------------------------------;//} } }
strcompress_ADD_1:
		jp.d		strcompress_L20
		add		%r2, 1				;//%r2  := u +=         1					*delay*
");
static void __attribute__((noreturn,unused))/*asmubNQ*/ strcompress_DIE() { DIE(); }
#endif//PIECE

/*****************************************************************************
 *	|C^z
 *****************************************************************************/

#ifndef PIECE
void strfreev(char** str_array) {
	/* str_arraŷNULL|C^łȂ΁c */
	if(str_array) {
		char **p = str_array, *str;
		/* NULL|C^vfɓB܂ŁAJB */
		while((str = *p++)) { free(str); }
		/* str_arraŷJB */
		free(str_array);
	}
}
#else /*PIECE*/
void strfreev(char** str_array);
//fȃo[W(16)ƁA4ߐߖo[W(12)쐬܂BTCYD悵Č҂gp邱Ƃɂ܂B
//strfreev()gp悤ȏ́Ax܂dvłȂƂAłǂƎvłB
#if 0
//قCǂfɎo[WłB
asm("
		.code
		.align		1
		.global		strfreev
strfreev:
		cmp		%r12, 0			;//if(!str_array) { goto L30 }
		jreq		strfreev_L30
		pushn		%r1
		ld.w		%r0, %r12		;//%r0  :=     str_array
		ld.w		%r1, %r12		;//%r1  := p = str_array
strfreev_L10:
		ld.w		%r12, [%r1]+		;//while((str = *p++)) {
		cmp		%r12, 0
		jreq		strfreev_L20
		xcall		free			;// free(str)
		jp		strfreev_L10		;//}
strfreev_L20:
		ld.w		%r12, %r0		;//%r12 := str_array
		xcall		free			;//   free(str_array)
		popn		%r1
strfreev_L30:
		ret
");
#else
//4ߐߖ񂵂o[WBᑬłB
asm("
		.code
		.align		1
		.global		strfreev
strfreev:
		cmp		%r12, 0			;//if(!str_array) { goto L30 }
		jreq		strfreev_L30
		pushn		%r12
		ld.w		%r0, %r12		;//%r0  := p = str_array
strfreev_L10:
		ld.w		%r12, [%r0]+		;//while((str = *p++)) {
		cmp		%r12, 0
		jreq		strfreev_L20
		call		strfreev_L30		;// free(str)		uxcall freevƏA̕ext1ߖłB
		jp		strfreev_L10		;//}
strfreev_L20:
		popn		%r12
strfreev_L30:
		xjp		free			;//free(str_array)	(!str_array)̏ꍇs邪Afree(NULL)͈SłB
");
#endif
#endif/*PIECE*/

#ifndef PIECE
size_t strv_length(char** str_array) {
	/* NULL|C^vfɑ΂(+1)𑊎E邽߁Al(-1)ƂĂB */
	int n = -1;
	/* NULL|C^vf܂߂āAvf(+1)BNULL|C^vfɑ΂(+1)́Al(-1)ƑEB */
	do { n++; } while(*str_array++);
	/* vfԂB */
	return n;
}
#else /*PIECE*/
size_t strv_length(char** str_array);
asm("
		.code
		.align		1
		.global		strv_length
strv_length:
		ld.w		%r10, -1		;//%r10 := n = -1
		ld.w		%r9, [%r12]+		;//%r9  := str = *str_array++
		 cmp		%r9, 0			;//    if(!str) { break }
		jrne.d		-2
		add		%r10, 1			;//%r10 := n++			*delay*
		ret
");
#endif/*PIECE*/

#ifndef PIECE
char** strdupv(char** str_array) {
	char **p, **q, *r;
	/* |C^z(vf+1(I[NULL))́AmۂB
	 * calloc()gpĊmۂ̂ŁAI[NULL͊ɐݒ肳ĂB */
	p = q = calloc(strv_length(str_array) + 1/*I[NULL*/, sizeof(char*));
	if(!p) { DIE(); }
	goto L_START;
	do {
		/* 𕡐B */
		r = strdup(r);
		if(!r) { DIE(); }
		/* i[B */
		*q++ = r;
		/* 擾BI[Ȃ΁AB */
L_START:	r = *str_array++;
	} while(r);
	/* |C^zԂB */
	return p;
}
#else //PIECE
asm("
		.code
		.align		1
		.global		strdupv
strdupv:
		pushn		%r2
		xcall.d		strv_length		;//%r10 := n = strv_length(str_array)
		ld.w		%r0, %r12		;//%r0  := str_array			*delay*
		add		%r10, 1			;//%r12 := n++
		ld.w		%r12, %r10		;//%r12 :=            n
		xcall.d		calloc			;//%r10 := p = calloc(n, sizeof(char*))
		ld.w		%r13, 4			;//%r13 :=               sizeof(char*)	*delay*
		cmp		%r10, 0			;//if(!p) { DIE() }
		jreq		strdupv_DIE		;//
		ld.w		%r1, %r10		;//%r1  := p
		jp.d		strdupv_START		;//goto START
		ld.w		%r2, %r10		;//%r2  := q = p			*delay*
strdupv_LOOP:						;//do {
		xcall		strdup			;//  %r10 := r = strdup(r)
		cmp		%r10, 0			;//  if(!r) { DIE() }
		jreq		strdupv_DIE		;//  
		ld.w		[%r2]+, %r10		;//  *q++  = r
strdupv_START:						;//  
		ld.w		%r12, [%r0]+		;//  %r12 := r = *str_array++
		cmp		%r12, 0			;//  
		jrne		strdupv_LOOP		;//} while(r)
		ld.w		%r10, %r1		;//%r10 := p
		popn		%r2
		ret
");
static void __attribute__((noreturn,unused))/*asmubNQ*/ strdupv_DIE() { DIE(); }
#endif//PIECE

/****************************************************************************
 *	
 ****************************************************************************/

#ifndef PIECE
char* strdup_printf(const char* fmt, ...) {
	char* str;
	va_list ap;
	va_start(ap, fmt);
	str = strdup_vprintf(fmt, ap);
	va_end(ap);
	return str;
}
char* strdup_vprintf(const char* fmt, va_list ap) {
	char* str;
	if(vasprintf(&str, fmt, ap) == -1) { DIE(); }
	return str;
}
#else /*PIECE*/
asm("
		.code
		.align		1
		.global		strdup_printf
		.global		strdup_vprintf
		;//[%sp+0] := retp
		;//[%sp+4] := fmt
		;//[%sp+8] := ...
strdup_printf:
		xld.w		%r12, [%sp+4]		;//%r12 := fmt
		xadd		%r13, %sp, 8		;//%r13 := ap
strdup_vprintf:
		xsub		%sp, %sp, 4
		ld.w		%r14, %r13		;//%r14 :=                               ap
		ld.w		%r13, %r12		;//%r13 :=                          fmt
		ld.w		%r12, %sp		;//%r12 :=                    &str
		xcall		vasprintf		;//%r10 := retval = vasprintf(&str, fmt, ap)
		cmp		%r10, -1		;//if(retval == -1) { DIE() }
		jreq		strdup_vprintf_DIE
		xld.w		%r10, [%sp+0]		;//%r10 := str
		xadd		%sp, %sp, 4
		ret					;//return  str
");
static void __attribute__((noreturn,unused))/*asmubNQ*/ strdup_vprintf_DIE() { DIE(); }
#endif//PIECE

/*****************************************************************************
 *	A
 *****************************************************************************/

#ifndef PIECE
char* strconcat(const char* s, ...) {
	va_list ap;
	char *newStr, *oldStr;
	/* ̏lA""ƂB */
	if(!(newStr = strdup(""))) { DIE(); }
	/* s,y,ψANULL|C^vfɓB܂Łc */
	va_start(ap, s);
	while(s) {	//sNULLꍇ́A[vɓ炸ɔB
		/* ÂƁAvf̕AAVƂB */
		newStr = strjoin(NULL, (oldStr = newStr), s, NULL);
		/* ÂJB */
		free(oldStr);
		/* ̉ψ擾B */
		s = va_arg(ap, char*);
	}
	va_end(ap);
	/* AԂB */
	return newStr;
}
char* strjoin(const char* separator, ...) {
	va_list ap;
	char *newStr, *oldStr, *str;
	/* vfڂɐsZp[^""ŒƂB */
	const char* sep = "";
	/* ̏lA""ƂB */
	if(!(newStr = strdup(""))) { DIE(); }
	/* ψANULL|C^vfɓB܂Łc */
	va_start(ap, separator);
	while((str = va_arg(ap, char*))) {
		/* ÂƁAZp[^ƁAvf̕AAVƂB */
		newStr = strdup_printf("%s%s%s", (oldStr = newStr), sep, str);
		/* ÂJB */
		free(oldStr);
		/* Zp[^w肳ĂAvfڈȍ~ɐsZp[^ƂB */
		if(separator) { sep = separator; }
	}
	va_end(ap);
	/* AԂB */
	return newStr;
}
char* strjoinv(const char* separator, char** str_array) {
	char *newStr, *oldStr, *str;
	/* vfڂɐsZp[^""ŒƂB */
	const char* sep = "";
	/* ̏lA""ƂB */
	if(!(newStr = strdup(""))) { DIE(); }
	/* |C^z񂪁ANULL|C^vfɓB܂Łc */
	while((str = *str_array++)) {
		/* ÂƁAZp[^ƁAvf̕AAVƂB */
		newStr = strdup_printf("%s%s%s", (oldStr = newStr), sep, str);
		/* ÂJB */
		free(oldStr);
		/* Zp[^w肳ĂAvfڈȍ~ɐsZp[^ƂB */
		if(separator) { sep = separator; }
	}
	/* AԂB */
	return newStr;
}
#else /*PIECE*/
char* strconcat(const char* s, ...);
char* strjoin(const char* separator, ...);
char* strjoinv(const char* separator, char** str_array);
asm("
		.code
		.align		1
		.global		strconcat
		.global		strjoin
		.global		strjoinv
strconcat:
		;//[%sp+ 0] := retp
		;//[%sp+ 4] := s
		;//[%sp+ 8] := ...
		xadd		%r13, %sp, 4			;//%r13 := str_array = &{s,...}		//sstr_array̐擪vfƂ邱ƂɒӂB
		jp.d		strjoinv
		ld.w		%r12, 0				;//%r12 := separator = NULL		*delay*
strjoin:
		;//[%sp+ 0] := retp
		;//[%sp+ 4] := separator
		;//[%sp+ 8] := ...
		xld.w		%r12, [%sp+4]			;//%r12 := separator
		xadd		%r13, %sp, 8			;//%r13 := str_array = &...
strjoinv:
		pushn		%r1
		xsub		%sp, %sp, 16
		ld.w		%r0, %r12			;//%r0      := separator
		ld.w		%r1, %r13			;//%r1      := str_array
		xld.w		%r12, strjoinv_FMT		;//%r12     := g%s%s%sh	yӁzp̓dpgasmubN̕I[ƌȂ̂ŎgpsB
		xld.w		[%sp+ 0], %r12			;//[%sp+ 0] := g%s%s%sh
		add		%r12, 6				;//%r12     :=       gh
		xld.w		[%sp+ 8], %r12			;//[%sp+ 8] := sep = gh
		xcall		strdup				;//%r10     := newStr = strdup(gh)
		cmp		%r10, 0				;//if(!newStr) { DIE() }
		jreq		strjoinv_DIE
		xld.w		[%sp+ 4], %r10			;//[%sp+ 4] := oldStr = newStr			ŏ̃[voldStr
strjoinv_L10:	;//---------------------------------------------;//for(;;) {
		;//%r0      := separator
		;//%r1      := str_array
		;//%r10     := newStr
		;//[%sp+ 0] := g%s%s%sh	strdup_printfւ̈
		;//[%sp+ 4] := oldStr		strdup_printfւ̈
		;//[%sp+ 8] := sep		strdup_printfւ̈
		;//[%sp+12] := str		strdup_printfւ̈
		ld.w		%r9, [%r1]+			;//  %r9      := str = *str_array++
		cmp		%r9, 0
		jreq		strjoinv_L20
		xld.w		[%sp+12], %r9			;//  [%sp+12] := str
		xcall		strdup_printf			;//  %r10     := newStr = strdup_printf(g%s%s%sh, oldStr, sep, str)
		xld.w		%r12, [%sp+ 4]			;//  %r12     := oldStr		
		xld.w		[%sp+ 4], %r10			;//  [%sp+ 4] := oldStr = newStr		̃[voldStr
		xcall		free				;//         free(oldStr)	
		cmp		%r0, 0				;//  if(separator) { sep = separator }
		jreq		strjoinv_L10
		xld.w		[%sp+ 8], %r0
		jp		strjoinv_L10
strjoinv_L20:	;//---------------------------------------------;//}
		xld.w		%r10, [%sp+ 4]			;//%r10     := newStr
		xadd		%sp, %sp, 16
		popn		%r1
		ret
");
static void __attribute__((noreturn,unused))/*asmubNQ*/ strjoinv_DIE() { DIE(); }
static const char strjoinv_FMT[] = "%s%s%s";
#endif/*PIECE*/

/****************************************************************************
 *	
 ****************************************************************************/

//
//* Sun Mar 08 10:55:52 JST 2015 Naoyuki Sawa
//- strsplit_set()ƃrbg}bvGC𕹗pAx傫ȃt@C𕪊悤ƂƁArbg}bvGCG[~鎖L܂B
//  ̖ɂĒʂ́Aȉ̒ʂłB
//Č@
////\ߢisd.exe =w \Home\Share\Piece\clip\getline.cƂP/ECEɉ÷Ă]Ăx傫̧قŤsCR+LFƖ肪ČՂ
//FILE* fp = fopen("getline.c","r");
//char* s = NULL;
//int len = 0;
//getdelim(&s,&len,0,fp);
////ޯϯGCN顂ƑNĂĂʡƯĂ͊֌W
//BitmapGC_Init(3);
////CR,,LF𕪊ƂĽدĂƤclipbmgc.cnew_pceHeapAlloc()Ŵװ~
//strsplit_set(s,"\r\n",0);
//
//޸ނł͂Ȃstrsplit_set()؊m݂ƤޯϯGC̓̂߂ɤ׸ð݂Ĥ傫ȋۯmۂłȂȂĂ܂L̂ł
//̓Iɂͤstrsplit_set()Ăяostrsplit_sub()̒Łc
//@߲zg顣Ť1vfargvmۂ顁ۯ蓖
//Aargv[0]ɤŏ'\r'܂ł̕𕡐Ċi[顁ۯ蓖
//B߲zg顣Ť2vfargvɊg顂̎@̌ɇA蓖čς݂Ȃ̂ł̏reallocłfree+mallocɂȂޯϯGCfreeۗmalloĉݍsۯ蓖
//Cargv[1]ɤ'\r''\n'̊Ԃ̕,,󕶎𕡐Ċi[顁ۯ蓖
//Desɂć@`C̏JԂ
//EĈ߂Ɏۂ̍s̓{ׂ̍ȕsĤȂ葁؂Ȃ顂ƤޯϯGCN
//FAƇCŕ͊JłȂ@ƇBŊmۂargv̂ŌɊmۂ̈ȊOJ
//GɂĊJ؂ͤ_argv[argc]Ȃ悤fۯȂ̂ŤVargv[argc]mۂɂ͏߂
//HʂƂĤclipbmgc.cnew_pceHeapAlloc()2nd trysĤװ~
//l@
//̖ɂͤargv܂Ƃ߂ĊgƂXޯϯGCNđ߂ɕsvargv؂JĤ̽߰ɕ񂪕悤ɂƂ΍@͂Ȃ΍͍sȂɂ
//Oq̂Ƃstrsplit_set()؊m݂ƤޯϯGC̓ɂ''ł޸ނł͂Ȃł
//̗prɍ킹đ΍sƤstrsplit_set()ޯϯGC̒PɂȂ褂̕Q傫Ǝvł
//ײؑł̑΍͍s܂ع݂L̎b΍sĉĂ
//b΍
//傫÷(ɤƋ󕶎񂪂񐶂悤ȕ)̕ɂͤstrsplit_set()gpstrtok()strsep()gpĂ
//

#ifndef PIECE
static char** strsplit_sub(const char* s, const char* delimiter,  int max_tokens, int delimiter_len);
       char** strsplit(    const char* s, const char* delimiter,  int max_tokens) { return strsplit_sub(s, delimiter,  max_tokens, 0); }
       char** strsplit_set(const char* s, const char* delimiters, int max_tokens) { return strsplit_sub(s, delimiters, max_tokens, 1); }
static char** strsplit_sub(const char* s, const char* delimiter,  int max_tokens, int delimiter_len) {
	int    argc = 0;
	char **argv = NULL, *p;
	if(*s) {
		char* (*fn)(const char*, const char*) = strpbrk; /* f~^֐ */
		/* strsplit()    ĂяoꂽA(delimiter_len=0)łBŃf~^̎ۂ̕𐔂B(delimiter=""͕s)
		 * strsplit_set()ĂяoꂽA(delimiter_len=1)łBX̃f~^͈ꕶƌȂ̂ł̂܂܁B(delimiter=""\) */
		if(!delimiter_len) {
			if(!(delimiter_len = strlen(delimiter))) { DIE(); } /* ustrsplit(s,"",max_tokens)v͕sBustrsplit_set(s,"",max_tokens)v͉\B */
			fn = strstr; /* f~^֐ */
		}
		/* 󕶎񂪎w肳ꂽꍇ̌ʂ́AI[NULL|C^݂̂琬̕|C^zƂB
		 * - As a special case, the result of splitting the empty string "" is an empty vector, not a vector containing a single string.
		 *   The reason for this special case is that being able to represent a empty vector is typically more useful than consistent handling of empty elements.
		 *   If you do need to represent empty elements, you'll need to check for the empty string before calling g_strsplit(). */
		for(;;) {
			/* |C^zgB */
			if(!(argv = realloc(argv, sizeof(char*) * (argc + 1)))) { DIE(); }
			/* ̍ŏIȂ΁Af~^Ȃ̂ƓƂB
			 * - The maximum number of pieces to split string into. If this is less than 1, the string is split completely. */
			if((max_tokens >= 1) && (--max_tokens == 0)) { break; }
			/* f~^Ȃ΁AB */
			if(!(p = (*fn)(s, delimiter))) { break; }
			/* ݈ʒuf~^̒O܂ł̕Aĕ|C^zɊi[B
			 * - ̐擪Ƀf~^LꍇAŏɊi[vf͋󕶎ƂȂB */
			if(!(argv[argc++] = strndup(s, p - s))) { DIE(); }
			/* ݈ʒuAf~^̒֐i߂B */
			s = p + delimiter_len;
		}
		/* ݈ʒu當̏I[܂ł̕Aĕ|C^zɊi[B
		 * - ̖Ƀf~^LꍇAŌɊi[vf͋󕶎ƂȂB */
		if(!(argv[argc++] = strdup(s))) { DIE(); }
	}
	/* |C^z̏I[ƂāANULL|C^i[B */
	if(!(argv = realloc(argv, sizeof(char*) * (argc + 1)))) { DIE(); }
	argv[argc] = NULL;
	return argv;
}
#else /*PIECE*/
asm("
		.code
		.align		1
		.global		strsplit
		.global		strsplit_set
strsplit:
		jp.d		strsplit_sub
		ld.w		%r15, 0			;//%r15    := delimiter_len = 0					*delay*
strsplit_set:
		ld.w		%r15, 1			;//%r15    := delimiter_len = 1
strsplit_sub:
		pushn		%r3
		xsub		%sp, %sp, 12
		ld.w		%r0, 0			;//%r0     := argv = NULL
		ld.w		%r1, 0			;//%r1     := size = 0
		ld.b		%r9, [%r12]		;//%r9     := *s
		cmp		%r9, 0			;//if(!(*s)) { goto strsplit_sub_L40 }
		jreq		strsplit_sub_L40
		ld.w		%r2, %r12		;//%r2     := s
		ld.w		%r3, %r14		;//%r3     := max_tokens
		xld.w		[%sp+0], %r13		;//[%sp+0] := delimiter
		xld.w		%r9, strpbrk		;//%r9     := fn = strpbrk
		cmp		%r15, 0			;//if(!delimiter_len) {
		jrne		strsplit_sub_L10
		ld.w		%r12, %r13		;//  %r12  :=                        delimiter
		xcall		strlen			;//  %r10  := delimiter_len = strlen(delimiter)
		cmp		%r10, 0			;//  if(!delimiter_len) { DIE() }
		jreq		strsplit_sub_DIE
		ld.w		%r15, %r10		;//  %r15  := delimiter_len
		xld.w		%r9, strstr		;//  %r9   := fn = strstr
strsplit_sub_L10:					;//}
		xld.w		[%sp+4], %r15		;//[%sp+4] := delimiter_len
		xld.w		[%sp+8], %r9		;//[%sp+8] := fn
strsplit_sub_L20:					;//for(;;) {
		ld.w		%r12, %r0		;//  %r12    :=                argv
		ld.w		%r13, %r1		;//  %r13    :=                      size
		xcall.d		realloc			;//  %r10    := argv = realloc(argv, size + sizeof(char*))
		add		%r13, 4			;//  %r13    :=                      size + sizeof(char*)	*delay*
		cmp		%r10, 0			;//  if(!argv) { DIE() }
		jreq		strsplit_sub_DIE
		ld.w		%r0, %r10		;//  %r0     := argv
		cmp		%r3, 1			;//  if((max_tokens >= 1) &&
		jrlt		3
		 sub		%r3, 1			;//   (--max_tokens == 0)) { break }
		 jreq		strsplit_sub_L30
		xld.w		%r9, [%sp+8]		;//  %r9    :=       fn
		xld.w		%r13, [%sp+0]		;//  %r13   :=              delimiter
		call.d		%r9			;//  %r10   := p = (*fn)(s, delimiter)
		ld.w		%r12, %r2		;//  %r12   :=           s					*delay*
		cmp		%r10, 0			;//  if(!p) { break }
		jreq		strsplit_sub_L30
		ld.w		%r12, %r2		;//  %r12   :=             s
		ld.w		%r13, %r10		;//  %r13   :=                p
		sub		%r13, %r2		;//  %r13   :=                p - s
		xld.w		%r2, [%sp+4]		;//  %r2    :=         delimiter_len
		xcall.d		strndup			;//  %r10   := t = strndup(s, p - s)
		add		%r2, %r10		;//  %r2    := s = p + delimiter_len				*delay*
		cmp		%r10, 0			;//  if(!t) { DIE() }
		jreq		strsplit_sub_DIE
		ld.w		%r9, %r0		;//  %r9    := argv
		add		%r9, %r1		;//  %r9    := argv[argc]
		ld.w		[%r9], %r10		;//  argv[argc] = t
		jp.d		strsplit_sub_L20	;//}
		add		%r1, 4			;//  %r1    := size += sizeof(char*)				*delay*
strsplit_sub_L30:
		xcall.d		strdup			;//%r10     := strdup(s)
		ld.w		%r12, %r2		;//%r12     :=        s						*delay*
		ld.w		%r9, %r0		;//%r9      := argv
		add		%r9, %r1		;//%r9      := argv[argc]
		ld.w		[%r9], %r10		;//argv[argc] = t
		add		%r1, 4			;//%r1      := size += sizeof(char*)
strsplit_sub_L40:
		ld.w		%r12, %r0		;//%r12      :=                argv
		ld.w		%r13, %r1		;//%r13      :=                      size
		xcall.d		realloc			;//%r10      := argv = realloc(argv, size + sizeof(char*))
		add		%r13, 4			;//%r13      :=                      size + sizeof(char*)	*delay*
		cmp		%r10, 0			;//if(!argv) { DIE() }
		jreq		strsplit_sub_DIE
		ld.w		%r9, %r10		;//%r9      := argv
		add		%r9, %r1		;//%r9      := argv[argc]
		ld.w		[%r9], %r8		;//argv[argc] = NULL
		xadd		%sp, %sp, 12
		popn		%r3
		ret
");
static void __attribute__((noreturn,unused))/*asmubNQ*/ strsplit_sub_DIE() { DIE(); }
#endif/*PIECE*/

#ifndef PIECE
char** textwrap(const char* s, int w) {
	char** argv = NULL;
	int    argc = 0, n = 0;
	/* 񂪎cĂԌJԂB */
	while(*s) {
		/* ݂̕I[Ŗ΁c */
		if(s[n + 0]) {
			/* ݂̔̕p(c=1)/Sp(c=2)𔻒肷B */
			int c = 1;
			if(ismbblead(s[n + 0]) && ismbbtrail(s[n + 1])) {
				c = 2;
			}
			/* ݂̕܂߂݂̒̕߂B */
			n += c;
			/* ݂݂̕̕1ڂ,,sȉȂΌpB
			 * O҂̏(w1)w肳Ă[vɊׂȂ΍łB */
			if((n == c) || (n <= w)) { continue; }
			/* s𒴂猻݂̕܂߂ȂŌ݂̕؂oB */
			n -= c;
		}
		/* |C^zg𕡐Ċi[B
		 * ǂ炩s烁sȂ̂ŃG[~B */
		if(!(argv = realloc(argv, sizeof(char*) * (argc + 1))) ||
		   !(argv[argc++] = strndup(s, n))) { DIE(); }
		/* ؂o΂̒ZbgB */
		s += n, n = 0;
	}
	/* |C^z̏I[ƂNULL|C^i[B */
	if(!(argv = realloc(argv, sizeof(char*) * (argc + 1)))) { DIE(); }
	argv[argc] = NULL;
	return argv;
}
#else //PIECE
//AZuړÍAR[hTCY̒ጸłB
//R[hTCYA(C=200oCg)(Asm=156oCg)ɏȂ܂B
//񕪊svO͑xdvłȂƎv̂ŁAdĂ܂B
asm("
		.code
		.align		1
		.global		textwrap
textwrap:
		pushn		%r3
		xsub		%sp, %sp, 4
		xld.w		[%sp+0], %r13		;//[%sp+0] := w
		ld.w		%r0, 0			;//%r0     :=  argv = NULL
		ld.w		%r1, 0			;//%r1     := (argc*4) = 0
		jp.d		textwrap_START		;//goto START
		ld.w		%r2, %r12		;//%r2     := s					*delay*
textwrap_LOOP:	;//-------------------------------------;//do {
		;//%r0     :=  argv
		;//%r1     := (argc*4)
		;//%r2     :=  s
		;//%r3     :=  n
		;//[%sp+0] :=  w
		ld.w		%r12, %r2		;//  %r12 :=             s
		add		%r12, %r3		;//  %r12 :=            &s[n+0]
		ld.b		%r12, [%r12]		;//  %r12 :=             s[n+0]
		cmp		%r12, 0			;//  if(                 s[n+0]) {		!INTERLOCK!
		jreq		textwrap_NUL		;//    
		xcall		ismbblead		;//    %r10 := ismbblead(s[n+0])
		cmp		%r10, 0			;//    if(    !ismbblead(s[n+0]) {
		jreq		textwrap_ANK		;//    goto ANK } else {
		ld.w		%r12, %r2		;//      %r12 :=            s
		add		%r12, %r3		;//      %r12 :=           &s[n+0]
		xld.b		%r12, [%r12+1]		;//      %r12 :=            s[n+1]
		xcall		ismbbtrail		;//      %r10 := ismbbtrail(s[n+1])
		cmp		%r10, 0			;//      if(     ismbbtrail(s[n+1]) {
		jrne.d		textwrap_KNJ		;//        
		ld.w		%r4, 2			;//        %r4  := c = 2			*delay*
textwrap_ANK:						;//      } else {
		ld.w		%r4, 1			;//        %r4  := c = 1
textwrap_KNJ:						;//    } }
		add		%r3, %r4		;//    %r3  := n += c
		cmp		%r3, %r4		;//    if(n == c) { goto LOOP }					s͕ωĂȂ̂(*s)͕̌svłLOOP֖߂ėǂBCłcontinueĝwhile(*s)ɖ߂Ă܂ۂ̂Ƃ(*s)͖̌ʂłB
		jreq		textwrap_LOOP		;//    
		xld.w		%r5, [%sp+0]		;//    %r5  := w
		cmp		%r3, %r5		;//    if(n <= w) { goto LOOP }			!INTERLOCK!	s͕ωĂȂ̂(*s)͕̌svłLOOP֖߂ėǂBCłcontinueĝwhile(*s)ɖ߂Ă܂ۂ̂Ƃ(*s)͖̌ʂłB
		jrle		textwrap_LOOP		;//    
		sub		%r3, %r4		;//    %r3  := n -= c
textwrap_NUL:						;//  }
		ld.w		%r12, %r0		;//  %r12 :=                argv
		ld.w		%r13, %r1		;//  %r13 :=                      (argc*4)
		xcall.d		realloc			;//  %r10 := argv = realloc(argv, (argc*4)+4)
		add		%r13, 4			;//  %r13 :=                      (argc*4)+4	*delay*
		cmp		%r10, 0			;//  if(!argv) { DIE() }
		jreq		textwrap_DIE		;//  
		ld.w		%r0, %r10		;//  %r0  := argv
		ld.w		%r12, %r2		;//  %r12 :=             s
		xcall.d		strndup			;//  %r10 := t = strndup(s, n)
		ld.w		%r13, %r3		;//  %r13 :=                n			*delay*
		add		%r1, %r0		;//  %r1  := argv[argc  ]
		ld.w		[%r1]+, %r10		;//          argv[argc++] = t
		sub		%r1, %r0		;//  %r1  :=     (argc*4)
		add		%r2, %r3		;//  %r2  :=  s += n
textwrap_START:
		ld.b		%r4, [%r2]		;//  %r4  := *s
		cmp		%r4, 0			;//  						!INTERLOCK!
		jrne.d		textwrap_LOOP		;;//} while( *s)
		ld.w		%r3, 0			;//  %r3  :=       n = 0			*delay*		'n=0'ƕ؂o'n=0'˂B
		;//-------------------------------------;//
		ld.w		%r12, %r0		;//  %r12 :=                argv
		ld.w		%r13, %r1		;//  %r13 :=                      (argc*4)
		xcall.d		realloc			;//  %r10 := argv = realloc(argv, (argc*4)+4)
		add		%r13, 4			;//  %r13 :=                      (argc*4)+4	*delay*
		cmp		%r10, 0			;//  if(!argv) { DIE() }
		jreq		textwrap_DIE		;//  
		add		%r1, %r10		;//  %r1  := argv[argc]
		ld.w		[%r1], %r8		;//          argv[argc] = NULL
		xadd		%sp, %sp, 4
		popn		%r3
		ret
");
static void __attribute__((noreturn,unused))/*asmubNQ*/ textwrap_DIE() { DIE(); }
#endif//PIECE

/*****************************************************************************
 *	r
 *****************************************************************************/

#ifndef PIECE
#if 0
//fɎo[WB
int str_has_prefix(const char* s1, const char* s2) {
	unsigned n1 = strlen(s1);
	unsigned n2 = strlen(s2);
	if(n1 < n2) { return 0; }
	return !strncmp(s1, s2, n2);
}
int str_has_suffix(const char* s1, const char* s2) {
	unsigned n1 = strlen(s1);
	unsigned n2 = strlen(s2);
	if(n1 < n2) { return 0; }
	return !strcmp(s1 + n1 - n2, s2);
}
#else
//ʏ܂Ƃ߂ėeʐߖ񂵂o[WB
static int str_has_prefix_suffix(const char* s1, const char* s2, int mask);
       int str_has_prefix(const char* s1, const char* s2) { return str_has_prefix_suffix(s1, s2,  0); }
       int str_has_suffix(const char* s1, const char* s2) { return str_has_prefix_suffix(s1, s2, -1); }
static int str_has_prefix_suffix(const char* s1, const char* s2, int mask) {
	unsigned n1 = strlen(s1);
	unsigned n2 = strlen(s2);
	if(n1 < n2) { return 0; }
	return !strncmp(s1 + ((n1-n2)&mask)/*0,or,(n1-n2)*/, s2, (n2|mask)/*n2,or,-1*/);
}
#endif
#else /*PIECE*/
//ʏ܂Ƃ߂ėeʐߖ񂵂o[WɁAAZu܂B
int str_has_prefix(const char* s1, const char* s2);
int str_has_suffix(const char* s1, const char* s2);
asm("
		.code
		.align		1
		.global		str_has_prefix
		.global		str_has_suffix
str_has_prefix:
		jp.d		str_has_prefix_suffix
		ld.w		%r14,  0			;//%r14 := mask =  0									*delay*
str_has_suffix:
		ld.w		%r14, -1			;//%r14 := mask = -1
str_has_prefix_suffix:
		pushn		%r3
		ld.w		%r0, %r12			;//%r0  := s1
		ld.w		%r1, %r13			;//%r1  := s2
		xcall.d		strlen				;//%r10 := n1 = strlen(s1)
		ld.w		%r2, %r14			;//%r2  := mask										*delay*
		ld.w		%r3, %r10			;//%r3  := n1
		xcall.d		strlen				;//%r10 := n2 = strlen(s2)
		ld.w		%r12, %r1			;//%r12 :=             s2								*delay*
		sub		%r3, %r10			;//%r3  :=      n1 -         n2		%psr(C) := ((unsigned)n1<(unsigned)n2) ? 1 : 0
		jrult		str_has_prefix_suffix_L10	;//if((unsigned)n1<(unsigned)n2) { return 0 }					
		and		%r3, %r2			;//%r3  :=                        (n1-n2)&mask					
		or		%r10, %r2			;//%r10 :=                                            n2|mask			
		ld.w		%r12, %r0			;//%r12 :=                  s1							
		add		%r12, %r3			;//%r12 :=                  s1 + ((n1-n2)&mask)					
		ld.w		%r13, %r1			;//%r13 :=                                       s2				
		xcall.d		strncmp				;//%r10 := retval = strncmp(s1 + ((n1-n2)&mask), s2, (n2|mask))			
		ld.w		%r14, %r10			;//%r14 :=                                            n2|mask				*delay*
		cmp		%r8, %r10			;//%psr(C) := retval  ?  1 : 0							
str_has_prefix_suffix_L10:					;//			@							
		ld.w		%r10, 1				;//%r10    := 1							
		popn		%r3				;//										
		ret.d						;//										
		sbc		%r10, %r8			;//%r10    := %psr(C) ?  0 : 1		*delay*
");
#endif/*PIECE*/

#ifndef PIECE
int string_match(const char* pat, const char* str) {
	int p, q, s;
	for(;;) {
		//p^[ꕶ擾Äʒu֐i߂B
		p = *pat++;
		//񂩂ꕶ擾Äʒu֐i߂B
		s = *str++;
		//p^[I[Ȃ΁c
		if(!p) {
			//񂪏I[Ȃ΁A}b`ƌ肷B
			//񂪏I[łȂȂ΁A}b`Ȃƌ肷B
			return !s;
		}
		//񂪏I[Ȃ΁c
		if(!s) {
			//p^[̕'*'ȊOȂ΁A}b`Ȃƌ肷B
			if(p != '*') { return 0; }
			//p^[̕'*'Ȃ΁Aȉ̃ubNɂďsB
		}								//
		//p^[̕'*'Ȃ΁c				//
		if(p == '*') {							//
			//p^[I[Ȃ΁A}b`ƌ肷B		//
			if(!*pat) { return 1; }					//
			//̈ʒuAs̈ʒu֖߂Bs'\0'ł邱ƂL蓾B
			str--;
			for(;;) {
				//݈ʒuȍ~̕ƃp^[}b`A}b`ƌ肷B
				if(string_match(pat, str)) { return 1; }
				//'*'ł镶cĂȂ΁A}b`Ȃƌ肷B
				if(!*str++) { return 0; }
				//'*'ꕶƌȂāArpB
			}
		}
		//p^[̕'?'Ȃ΁AꕶvƌȂāA̔̕rֈڍsB
		if(p == '?') { continue; }
		//p^[̕'['Ȃ΁c
		if(p == '[') {
			int match = 0;
			for(;;) {
				//p^[ꕶ擾Äʒu֐i߂B
				p = q = *pat++;
				//p^[I[Ȃ΁AĂȂNXłAsȃp^[łB
				if(!p) { DIE(); }
				//p^[̕']'Ȃ΁A[v𔲂B
				//Tcl6.7string matchƁAʓIȐK\̑_ƂāAȉɒӂ:
				//ʓIȐK\ł́A'['̒']'͕NXANẌꕶƌȂ邪ATcl6.7string matchɂ͂̓ᏈB
				//ʓIȐK\ł́ANX̒ł'\'ɂꕶ̃GXP[vGXP[vV[PXg邪ATcl6.7string matchł͎gȂB
				if(p == ']') { break; }
				//p^[̕'-'Ȃ΁c
				if(*pat == '-') {
					//p^[̈ʒuA'-'̎̈ʒu֐i߂B
					pat++;
					//p^[ꕶ擾Äʒu֐i߂B
					q = *pat++;
					//p^[I[Ȃ΁AĂȂNXłAsȃp^[łB
					if(!q) { DIE(); }
				}
				//NX͈͓̔Ȃ΁ANXɈvƂ}[NB
				//NX̎cǂݎ̂Ă邽߂ɁA[vpB
				if((s >= p) && (s <= q)) { match = 1; }
				if((s >= q) && (s <= p)) { match = 1; }	//t͈͂͐K\̎dlOATcl6.7̎ł͋eĂB
			}
			//NXɈvĂȂ΁A}b`Ȃƌ肷B
			if(!match) { return 0; }
			//ꕶvƌȂāA̔̕rֈڍsB
			continue;
		}
		//p^[̕'\'Ȃ΁c
		if(p == '\\') {
			//p^[ꕶ擾Äʒu֐i߂B
			p = *pat++;
			//p^[I[Ȃ΁AsȃGXP[vłAsȃp^[łB
			if(!p) { DIE(); }
		}
		//p^[̕ƕ̕vȂ΁A}b`Ȃƌ肷B
		if(p != s) { return 0; }
	}
}
#else //PIECE
//AZuړÍAR[hTCY̒ጸłB
//R[hTCYA(C=224oCg)(Asm=172oCg)ɏȂ܂B
//rsvO͑xdvłȂƎv̂ŁAdĂ܂B
int string_match(const char* pat, const char* str);
asm("
		.code
		.align		1
		.global		string_match
string_match:						;//for(;;) {
		ld.b		%r4, [%r12]+			;//  %r4  := p = *pat++
		ld.b		%r5, [%r13]+			;//  %r5  := s = *str++
		cmp		%r4, 0				;//  if(!p) {
		jrne.d		4
		 cmp		%r5, 0				;//  %psr(Z) := !s				*delay*
		 jreq		string_match_RET_1		;//    return !s			
		 jp		string_match_RET_0		;//  }					@
		jrne.d		3				;//  if(!s) {				
		 sub		%r4, 42				;//  %psr(Z) := (p == '*')			*delay*		ucmp %r4,42v́ucmp %rd,sign6v͈̔͊OȂ̂ŕsB
		 jrne		string_match_RET_0		;//    if(p != '*') { return 0 } }				@͈͊Ołɂ炸AZuG[oȂ̂ŒӂB
		jrne.d		string_match_L20		;//  if(p == '*') {						@uxcmp %r4,42vɂ2ɏKv邪Ausub %r4,42vŔfāuadd %r4,42vŖ߂1ōςށB
		add		%r4, 42				;//  						*delay*		ł́usub %r4,42v`uadd %r4,42v̊Ԃ%r4̒lωĂ薳Ƃ𗘗pHvłB
		ld.b		%r4, [%r12]			;//    %r4  := p = *pat
		cmp		%r4, 0				;//    if(!p) { return 1 }
		jreq		string_match_RET_1
		sub		%r13, 1				;//    %r13 := str--
string_match_L10:						;//    for(;;) {
	;//{{ǂ炩IĂB
	;//X^bNʂȂo[W
	;//	xsub		%sp, %sp, 8
	;//	xld.w		[%sp+0], %r12			;//      [%sp+0] := pat
	;//	xld.w		[%sp+4], %r13			;//      [%sp+4] := str
	;//	call		string_match			;//      %r10 := retval = string_match(pat,str)
	;//	xld.w		%r12, [%sp+0]			;//      %r12 := pat
	;//	xld.w		%r13, [%sp+4]			;//      %r13 := str
	;//	xadd		%sp, %sp, 8
	;//	cmp		%r10, 0				;//      if(retval) { return 1 }
	;//||ǂ炩IĂB
	;//X^bNʂ4ߐߖ񂵂o[W
		pushn		%r13
		call		string_match			;//      %r10 := retval = string_match(pat,str)
		cmp		%r10, 0				;//      if(retval) { return 1 }
		popn		%r13
	;//}}ǂ炩IĂB
		jrne		string_match_RET_1
		ld.b		%r10, [%r13]+			;//      %r10 := s = *str++
		cmp		%r10, 0				;//      if(!s) { return 0 }
		jrne		string_match_L10
		jp		string_match_RET_0		;//    }
string_match_L20:						;//  }
		xcmp		%r4, 63
		jreq		string_match
		xcmp		%r4, 91				;//  if(p == '[') {
		jrne		string_match_L40
		ld.w		%r6, 0				;//    %r6  := match = 0
string_match_L30:						;//    for(;;) {
		ld.b		%r4, [%r12]+			;//      %r4  := p = *pat++
		cmp		%r4, 0				;//      if(!p) { DIE() }
		jreq		string_match_DIE
		xcmp		%r4, 93				;//      if(p == ']') { break }
		jreq		string_match_L35
		ld.b		%r7, [%r12]			;//      %r7  := q = *pat
		xcmp		%r7, 45				;//      if(q == '-') {
		jrne.d		6
		 cmp		%r7, %r4			;//      %r7  := q = p				*delay*
		 add		%r12, 1				;//        %r12 := pat++
		 ld.b		%r7, [%r12]+			;//        %r7  := q = *pat++
		 cmp		%r7, 0				;//        if(!q) { DIE() }
		 jreq		string_match_DIE		;//      }
		cmp		%r4, %r7			;//      if(p > q) {
		jrle		4
		 xor		%r4, %r7			;//        %r4  := p ^= q	
		 xor		%r7, %r4			;//        %r7  := q ^= p	pq
		 xor		%r4, %r7			;//        %r4  := p ^= q }	
		sub		%r5, %r4			;//      %r5  :=       s-p
		sub		%r7, %r4			;//      %r7  :=                          q-p
		cmp		%r5, %r7			;//      if((unsigned)(s-p) <= (unsigned)(q-p)) { match = 1 }
		jrugt		string_match_L30
		jp.d		string_match_L30
		ld.w		%r6, 1				;//						*delay*
string_match_L35:						;//    }
		cmp		%r6, 0				;//    if(!match) { return 0 }
		jrne		string_match			;//    continue
		jp		string_match_RET_0
string_match_L40:						;//  }
		xcmp		%r4, 92				;//  if(p == '') {
		jrne		4
		 ld.b		%r4, [%r12]+			;//    %r4  := p = *pat++
		 cmp		%r4, 0				;//    if(!p) { DIE() }
		 jreq		string_match_DIE		;//  }
		cmp		%r4, %r5			;//  if(p != s) { return 0 }
		jreq		string_match			;//}
string_match_RET_0:
		ret.d						;//return 0
		ld.w		%r10, 0				;//						*delay*
string_match_RET_1:
		ret.d						;//return 1
		ld.w		%r10, 1				;//						*delay*
");
static void __attribute__((noreturn,unused))/*asmubNQ*/ string_match_DIE() { DIE(); }
#endif//PIECE

/*****************************************************************************
 *	]
 *****************************************************************************/

/* 𔽓]B
 * [in]
 *	s		]镶B
 * [out]
 *	߂l		ŝ܂ܕԂB
 * [note]
 *	- GLibg_strreverse()Ɍ݊łB
 */
#ifndef PIECE
char* strreverse(char* s) {
	char* p1 = s;
	char* p2 = strchr(s, '\0');
	goto L_START;
	do {
		int c = *p1;
		        *p1 = *p2;
		              *p2 = c;
		p1++;
L_START:	p2--;
	} while(p1 < p2);
	return s;
}
#else /*PIECE*/
char* strreverse(char* s);
asm("
		.code
		.align		1
		.global		strreverse
strreverse:
		pushn		%r0
		ld.w		%r0, %r12		;//%r0  := s
		xcall.d		strchr			;//%r10 := p2 = strchr(s, 'O')
		ld.w		%r13, 0			;//%r13 :=                'O'	*delay*
		jp.d		strreverse_START	;//goto START
		ld.w		%r4, %r0		;//%r4 := p1 = s			*delay*
strreverse_LOOP:					;//do {
		ld.b		%r5, [%r4]		;//  %r5  := c1 = *p1
		ld.b		%r6, [%r10]		;//  %r6  := c2 = *p2
		ld.b		[%r10], %r5		;//  *p2   = c1
		ld.b		[%r4]+, %r6		;//  *p1++ = c2
strreverse_START:					;//  
		sub		%r10, 1			;//  %r10 := p2--
		cmp		%r4, %r10		;//} while(p1 < p2)
		jrult		strreverse_LOOP		;//
		ld.w		%r10, %r0		;//%r10 := s
		popn		%r0
		ret
");
#endif/*PIECE*/

/*****************************************************************************
 *	Pꉻ
 *****************************************************************************/

int quark_from_string(const char* s) {
	return (int)intern_string(s);
}
const char* quark_to_string(int q) {
	return (const char*)q;
}
const char* intern_string(const char* s) {
	//dȂo^nbVe[uB
	// - L[ƒlɓ񂪊i[Ă胁̖ʂA݂͏̒PD悵Ă̂܂܂ƂĂB
	//   Pɂ́AVKo^ɃnbVe[u𑖍ăGg̃L[̃AhX擾A
	//   f[^|C^L[̃AhXw悤ght_replace()ŏΉ\ł͂B(ȂxȂ邪)
	//   ꍇ́AL[̕Ƀk܂߂KvL̂ŁAL[̒(+1)悤ɒӂB
	static ght_hash_table_t* ht;
	//nbVe[u쐬Ȃ΁c
	if(!ht) {
		//nbVe[u쐬B
		ht = ght_create(0);	//TCY𖳎wƂB
		ght_set_rehash(ht, 1);	//TCYLɂB
	}
	//|C^NULL̏ꍇ́Â܂NULLԂBłȂ΁c
	if(s) {
		//̒擾BL[̖Ƀk͕svȂ̂ŁA(+1)͕svłB
		int n = strlen(s);
		//nbVe[u猟B
		char* t = ght_get(ht, n, s);
		//o^ĂÃf[^ԂBo^ĂȂ΁c
		if(!t) {
			//𕡐B
			t = strdup(s);
			//A񎩐gL[Ƃēo^B
			ght_insert(ht, t, n, t);
		}
		//nbVe[uɕێ̃f[^߂lƂB
		s = t;
	}
	return s;
}

/*****************************************************************************
 *	u
 *****************************************************************************/

#ifndef PIECE
char* strreplace(const char* s, const char* oldstr, const char* newstr) {
	//̕A镶ŕB
	char** argv = strsplit(s, oldstr, 0);
	//Au镶ŘAB
	char* t = strjoinv(newstr, argv);
	//JB
	strfreev(argv);
	//AԂB
	return t;
}
#else //PIECE
char* strreplace(const char* s, const char* oldstr, const char* newstr);
asm("
		.code
		.align		1
		.global		strreplace
strreplace:
		pushn		%r0			;//
		ld.w		%r0, %r14		;//%r0  := newstr
		xcall.d		strsplit		;//%r10 := argv = strsplit(s, oldstr, 0)
		ld.w		%r14, 0			;//%r14 :=                            0		*delay*
		ld.w		%r12, %r0		;//%r12 :=              newstr
		ld.w		%r0, %r10		;//%r0  := argv
		xcall.d		strjoinv		;//%r10 := t = strjoinv(newstr, argv)
		ld.w		%r13, %r0		;//%r13 :=                      argv		*delay*
		ld.w		%r12, %r0		;//%r12 :=          argv
		xcall.d		strfreev		;//        strfreev(argv)
		ld.w		%r0, %r10		;//%r0  := t					*delay*
		ld.w		%r10, %r0		;//%r10 := t
		popn		%r0			;//
		ret					;//return  t
");
#endif//PIECE

/*****************************************************************************
 *	
 *****************************************************************************/

#ifndef PIECE
void* memdup(const void* src, size_t n) {
	void* dest = malloc(n);
	if(dest) { dest = memcpy(dest, src, n); }
	return dest;
}
#else //PIECE
void* memdup(const void* src, size_t n);
asm("
		.code
		.align		1
		.global		memdup
memdup:
		;//%r12 := src
		;//%r13 := n
		pushn		%r1			;//
		ld.w		%r0, %r12		;//%r0  := src
		ld.w		%r1, %r13		;//%r1  := n
		xcall.d		malloc			;//%r10 := dest = malloc(n)
		ld.w		%r12, %r13		;//%r12 :=               n			*delay*
		cmp		%r10, 0			;//if(dest) {
		jreq		memdup_RET		;//  
		ld.w		%r13, %r0		;//  %r13 :=                     src
		ld.w		%r14, %r1		;//  %r14 :=                          n
		xcall.d		memcpy			;//  %r10 := dest = memcpy(dest, src, n)
		ld.w		%r12, %r10		;//  %r12 :=               dest			*delay*
memdup_RET:						;//}
		popn		%r1			;//
		ret					;//return dest
");
#endif//PIECE
