/*	
 *	clipssm.c
 *
 *	P/ECE S-SMP (SPC700) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Jan 04 21:33:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"
#include "clipssmi.h"	/*SSMPG~[^p}N*/

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	IyR[h}bv
 */
const SSMPOP ssmp_op_table[256/*opcode*/] = {
#include "ssmp/table.h" /* [ssmp.xls]Table */
};

/*
 *	j[jbNe[u
 */
#undef SSMPFN_
#define SSMPFN_(OP, FN)	OP "\0"
const char ssmp_op_name_table[] = {
	"\0" /* ItZbg0̓k */
#include "ssmp/list.h" /* [ssmp.xls]Table */
};
#undef SSMPFN_

/****************************************************************************
 *
 ****************************************************************************/

void
ssmp_reset(SSMP* ssmp, SSMPREADPROC* read, SSMPWRITEPROC* write)
{
	memset(ssmp, 0, sizeof(SSMP));
	ssmp->read  = read  ? read  : ssmp_internal_read;
	ssmp->write = write ? write : ssmp_internal_write;

	PC = READW(0xfffe);
}

void
ssmp_dump(SSMP* ssmp)
{
#define INDENT	40
	TRACE("%*s", INDENT, "");
	TRACE("PC:%04x A:%02x X:%02x Y:%02x SP:%02x PSW:%c%c%c%c%c%c%c%c\n",
		PC, A, X, Y, SP,
		PSW & (1 << 7) ? 'N' : '-',
		PSW & (1 << 6) ? 'V' : '-',
		PSW & (1 << 5) ? 'P' : '-',
		PSW & (1 << 4) ? 'I' : '-', /* S-SMPł͖gpB6502Ƃ͋t_!! (65020:/1:֎~ASPC7000:֎~/1:) */
		PSW & (1 << 3) ? 'H' : '-',
		PSW & (1 << 2) ? 'B' : '-', /* S-SMPł͖gp */
		PSW & (1 << 1) ? 'Z' : '-',
		PSW & (1 << 0) ? 'C' : '-');
#undef INDENT
}

/****************************************************************************
 *
 ****************************************************************************/

#ifdef PIECE

asm("
	.code
	.global ssmp_run2
ssmp_run2:
	pushn %r0
	ld.w %r0, %sp		; X^bNޔ
	xld.w %r10, 0x1000	; 0x0e00`0x1000ɃX^bNؑ
	ld.w %sp, %r10
	xcall ssmp_run
	ld.w %sp, %r0		; X^bN
	popn %r0
	ret
");

#endif /*PIECE*/

/****************************************************************************
 *
 ****************************************************************************/

