
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
	.global	quatf_0
	.code
	.align	2
quatf_0:
	.word	0x00000000		; 0 (float)
	.word	0x00000000		; 0 (float)
	.word	0x00000000		; 0 (float)
	.word	0x00000000		; 0 (float)
	.global	quatf_1
	.align	2
quatf_1:
	.word	0x00000000		; 0 (float)
	.word	0x00000000		; 0 (float)
	.word	0x00000000		; 0 (float)
	.word	0x3f800000		; 1 (float)
; APP
	
		.code
		.align		1
		.global		quatf_inv
		.global		quatf_normal
		.global		quatf_norm
		.global		quatf_norm2
		.global		quatf_dot
quatf_inv:	;//-------------------------------------;
		pushn		%r0
	call.d	quatf_conj	; 		xcall.d		quatf_conj		;// %r10 := quatf_conj(q)
		ld.w		%r0, %r12		;// %r0  :=            q
		call.d		quatf_norm2		;// %r10 :=               quatf_norm2(q)
		ld.w		%r12, %r0		;// %r12 :=                           q		*delay*
		ld.w		%r12, %r0		;// %r12 :=            q
		popn		%r0
	jp.d	quatf_divf	; 		xjp.d		quatf_divf		;// %r10 := quatf_divf(q, quatf_norm2(q))
		ld.w		%r13, %r10		;// %r13 :=               quatf_norm2(q)	*delay*
quatf_normal:	;//-------------------------------------;
		pushn		%r0
		call.d		quatf_norm		;// %r10 :=               quatf_norm(q)
		ld.w		%r0, %r12		;// %r0  :=            q			*delay*
		ld.w		%r12, %r0		;// %r12 :=            q
		popn		%r0
	jp.d	quatf_divf	; 		xjp.d		quatf_divf		;// %r10 := quatf_divf(q, quatf_norm(q))
		ld.w		%r13, %r10		;// %r13 :=               quatf_norm(q)		*delay*
quatf_norm:	;//-------------------------------------;
		call		quatf_norm2		;// %r10 :=       quatf_norm2(q)
	ext	sqrtf@rm	; 		xjp.d		sqrtf			;// %r10 := sqrtf(quatf_norm2(q))
	jp.d	sqrtf@rl
		ld.w		%r12, %r10		;// %r12 :=       quatf_norm2(q)		*delay*
quatf_norm2:	;//-------------------------------------;
		ld.w		%r13, %r12		;// %r13 := q1 = q2 = q
quatf_dot:	;//-------------------------------------;
		ld.w		%r4, %r12		;// %r4  := q1
		ld.w		%r5, %r13		;// %r5  := q2
	ext	__mulsf3+0x0@h	; 		xld.w		%r6, __mulsf3		;// %r6  := __mulsf3
	ext	__mulsf3+0x0@m
	ld.w	%r6,__mulsf3+0x0@l
		;//
		ld.w		%r12, [%r4]+		;// %r12 :=        q1->x
		ld.w		%r13, [%r5]+		;// %r13 :=                q2->x
		call		%r6			;// %r10 := dot  = q1->x * q2->x
;//		ld.w		%r7, %r10		;// %r7  := dot ------------------------+
		;//					;//					|
		ld.w		%r12, [%r4]+		;// %r12 :=        q1->y		|
		ld.w		%r13, [%r5]+		;// %r13 :=                q2->y	|
		call.d		%r6			;// %r10 :=        q1->y * q2->y	|
		ld.w		%r7, %r10		;// <-----------------------------------+	*delay*
		ld.w		%r12, %r7		;// %r12 := dot
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := dot += q1->y * q2->y
	call.d	__addsf3@rl
		ld.w		%r13, %r10		;// %r13 :=        q1->y * q2->y		*delay*
;//		ld.w		%r7, %r10		;// %r7  := dot ------------------------+
		;//					;//					|
		ld.w		%r12, [%r4]+		;// %r12 :=        q1->z		|
		ld.w		%r13, [%r5]+		;// %r13 :=                q2->z	|
		call.d		%r6			;// %r10 :=        q1->z * q2->z	|
		ld.w		%r7, %r10		;// <-----------------------------------+	*delay*
		ld.w		%r12, %r7		;// %r12 := dot
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := dot += q1->z * q2->z
	call.d	__addsf3@rl
		ld.w		%r13, %r10		;// %r13 :=        q1->z * q2->z		*delay*
;//		ld.w		%r7, %r10		;// %r7  := dot ------------------------+
		;//					;//					|
		ld.w		%r12, [%r4]		;// %r12 :=        q1->w		|
		ld.w		%r13, [%r5]		;// %r13 :=                q2->w	|
		call.d		%r6			;// %r10 :=        q1->w * q2->w	|
		ld.w		%r7, %r10		;// <-----------------------------------+	*delay*
		ld.w		%r12, %r7		;// %r12 := dot
	ext	__addsf3@rm	; 		xjp.d		__addsf3		;// %r10 := dot += q1->w * q2->w
	jp.d	__addsf3@rl
		ld.w		%r13, %r10		;// %r13 :=        q1->w * q2->w		*delay*

	
		.code
		.align		1
		.global		quatf_add
		.global		quatf_neg
		.global		quatf_conj
quatf_add:	;//-------------------------------------;
	ext	__addsf3+0x0@h	; 		xld.w		%r4, __addsf3		;// %r4  := op = __addsf3
	ext	__addsf3+0x0@m
	ld.w	%r4,__addsf3+0x0@l
		jp.d		quatf_add_neg_conj
quatf_neg:	;//-------------------------------------;
		ld.w		%r5, 4			;// %r5  := cnt = 4			*delay*
		jp.d		quatf_neg_conj
quatf_conj:	;//-------------------------------------;
		ld.w		%r13, %r12		;// %r13 := q2 = q1 (_~[ǂݍ݌)	*delay*
		ld.w		%r5, 3			;// %r5  := cnt = 3
quatf_neg_conj:	;//-------------------------------------;
	ext	__negsf2+0x0@h	; 		xld.w		%r4, __negsf2		;// %r4  := op = __negsf2
	ext	__negsf2+0x0@m
	ld.w	%r4,__negsf2+0x0@l
quatf_add_neg_conj:;//----------------------------------;
		ld.w		%r6, %r12		;// %r6  := q1
		ld.w		%r7, %r13		;// %r7  := q2
quatf_add_neg_conj_LOOP:				;// do {
		ld.w		%r12, [%r6]		;//   %r12 := q1->i
		ld.w		%r13, [%r7]+		;//   %r13 :=          q2->i
		call		%r4			;//   %r10 := q1->i op q2->i
		ld.w		[%r6]+, %r10		;//   q1->i = q1->i op q2->i
		sub		%r5, 1			;//   %r5  := cnt--
		jrne		quatf_add_neg_conj_LOOP	;// } while(cnt)
		ret

	
		.code
		.align		1
		.global		quatf_mulf
		.global		quatf_divf
quatf_mulf:	;//-------------------------------------;
	ext	__mulsf3+0x0@h	; 		xld.w		%r4, __mulsf3		;// %r4  := op = __mulsf3
	ext	__mulsf3+0x0@m
	ld.w	%r4,__mulsf3+0x0@l
		jp.d		quatf_mulf_divf
quatf_divf:	;//-------------------------------------;
		ld.w		%r5, 4			;// %r5  := cnt = 4		*delay*
	ext	__divsf3+0x0@h	; 		xld.w		%r4, __divsf3		;// %r4  := op = __divsf3
	ext	__divsf3+0x0@m
	ld.w	%r4,__divsf3+0x0@l
quatf_mulf_divf:;//-------------------------------------;
		ld.w		%r6, %r12		;// %r6  := q
		ld.w		%r7, %r13		;// %r7  := f
quatf_mulf_divf_LOOP:					;// do {
		ld.w		%r12, [%r6]		;//   %r12 := q->i
		call.d		%r4			;//   %r10 := q->i op f
		ld.w		%r13, %r7		;//   %r13 :=         f		*delay*
		ld.w		[%r6]+, %r10		;//   q->i := q->i op f
		sub		%r5, 1			;//   %r5  := cnt--
		jrne		quatf_mulf_divf_LOOP	;// } while(cnt)
		ret

; NO_APP
	.code
	.align	1
	.global	quatf_slerp
quatf_slerp:
;	.frame	%sp,44,$31		# vars= 24, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x6		; 	xsub	%sp,%sp,24
	ld.w	[%sp+0x4],%r12	; 	xld.w	[%sp+16],%r12
	ld.w	%r1,%r13
	ld.w	%r0,%r14
	ld.w	[%sp+0x5],%r15	; 	xld.w	[%sp+20],%r15
	ld.w	%r12,%r1
	ld.w	%r13,%r0
	call	quatf_dot	; 	xcall	quatf_dot
	ld.w	%r12,%r10
	ext	acosf@rm	; 	xcall	acosf
	call	acosf@rl
	ld.w	%r2,%r10
	ld.w	%r12,%r2
	ext	sinf@rm		; 	xcall	sinf
	call	sinf@rl
	ld.w	%r3,%r10
	ld.w	%r12,%sp
	ld.w	%r13,%r0
	ld.w	%r14,0x10	; 	xld.w	%r14,0x00000010		; 16
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ld.w	%r12,[%sp+0x4]	; 	xld.w	%r12,[%sp+16]
	ld.w	%r13,%r1
	ld.w	%r14,0x10	; 	xld.w	%r14,0x00000010		; 16
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ld.w	%r0,0x0		; 	xld.w	%r0,0x00000000		; 0.00000000000000000000e0
	ld.w	%r12,%r3
	ld.w	%r13,%r0
	ext	__fcmps@rm	; 	xcall	__fcmps
	call	__fcmps@rl
	jreq	__LX71		; 	xjreq	__L71
	ld.w	%r12,%r2
	ld.w	%r13,[%sp+0x5]	; 	xld.w	%r13,[%sp+20]
	ext	__mulsf3@rm	; 	xcall	__mulsf3
	call	__mulsf3@rl
	ld.w	%r12,%r10
	ext	sinf@rm		; 	xcall	sinf
	call	sinf@rl
	ld.w	%r12,%sp
	ld.w	%r13,%r10
	call	quatf_mulf	; 	xcall	quatf_mulf
	ext	0x7f0		; 	xld.w	%r12,0x3f800000		; 1.00000000000000000000e0
	ext	0x0
	ld.w	%r12,0x0
	ld.w	%r13,[%sp+0x5]	; 	xld.w	%r13,[%sp+20]
	ext	__subsf3@rm	; 	xcall	__subsf3
	call	__subsf3@rl
	ld.w	%r12,%r2
	ld.w	%r13,%r10
	ext	__mulsf3@rm	; 	xcall	__mulsf3
	call	__mulsf3@rl
	ld.w	%r12,%r10
	ext	sinf@rm		; 	xcall	sinf
	call	sinf@rl
	ld.w	%r12,[%sp+0x4]	; 	xld.w	%r12,[%sp+16]
	ld.w	%r13,%r10
	call	quatf_mulf	; 	xcall	quatf_mulf
	ld.w	%r12,[%sp+0x4]	; 	xld.w	%r12,[%sp+16]
	ld.w	%r13,%sp
	call	quatf_add	; 	xcall	quatf_add
	ld.w	%r12,[%sp+0x4]	; 	xld.w	%r12,[%sp+16]
	ld.w	%r13,%r3
	call	quatf_divf	; 	xcall	quatf_divf
__LX71:				; __L71:
	add	%sp,0x6		; 	xadd	%sp,%sp,24
	popn	%r3
	ret
	.align	1
	.global	vec3f_rotq
vec3f_rotq:
;	.frame	%sp,68,$31		# vars= 48, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0xc		; 	xsub	%sp,%sp,48
	ld.w	%r3,%r12
	ld.w	%r1,%r13
	ld.w	%r12,%sp
	ld.w	%r13,%r3
	ld.w	%r14,0x10	; 	xld.w	%r14,0x00000010		; 16
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ld.w	%r10,[%r1]	; 	xld.w	%r10,[%r1]
	ld.w	[%sp+0x8],%r10	; 	xld.w	[%sp+32],%r10
	ext	0x4		; 	xld.w	%r10,[%r1+4]
	ld.w	%r10,[%r1]
	ld.w	[%sp+0x9],%r10	; 	xld.w	[%sp+36],%r10
	ext	0x8		; 	xld.w	%r10,[%r1+8]
	ld.w	%r10,[%r1]
	ld.w	[%sp+0xa],%r10	; 	xld.w	[%sp+40],%r10
	ld.w	%r11,0x0	; 	xld.w	%r11,0x00000000		; 0.00000000000000000000e0
	ld.w	[%sp+0xb],%r11	; 	xld.w	[%sp+44],%r11
	ld.w	%r2,%sp		; 	xadd	%r2,%sp,16
	add	%r2,0x10
	ld.w	%r0,%sp		; 	xadd	%r0,%sp,32
	add	%r0,0x20
	ld.w	%r12,%r2
	ld.w	%r13,%r0
	ld.w	%r14,0x10	; 	xld.w	%r14,0x00000010		; 16
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ld.w	%r12,%r0
	ld.w	%r13,%r3
	ld.w	%r14,0x10	; 	xld.w	%r14,0x00000010		; 16
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ld.w	%r12,%r0
	ext	quatf_conj@rm	; 	xcall	quatf_conj
	call	quatf_conj@rl
	ld.w	%r12,%sp
	ld.w	%r13,%r2
	call	quatf_mul	; 	xcall	quatf_mul
	ld.w	%r12,%sp
	ld.w	%r13,%r0
	call	quatf_mul	; 	xcall	quatf_mul
	ld.w	%r10,[%sp+0x0]	; 	xld.w	%r10,[%sp]
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ld.w	%r10,[%sp+0x1]	; 	xld.w	%r10,[%sp+4]
	ext	0x4		; 	xld.w	[%r1+4],%r10
	ld.w	[%r1],%r10
	ld.w	%r10,[%sp+0x2]	; 	xld.w	%r10,[%sp+8]
	ext	0x8		; 	xld.w	[%r1+8],%r10
	ld.w	[%r1],%r10
	add	%sp,0xc		; 	xadd	%sp,%sp,48
	popn	%r3
	ret
; APP
	
		.code
		.align		1
		.global		quatf_mul
quatf_mul:
		pushn		%r3
		ld.w		%r0, %r12		;// %r0  := q1
		ld.w		%r1, %r13		;// %r1  := q2
	ext	__mulsf3+0x0@h	; 		xld.w		%r2, __mulsf3		;// %r2  := __mulsf3
	ext	__mulsf3+0x0@m
	ld.w	%r2,__mulsf3+0x0@l
		;//-------------------------------------;
		ld.w		%r3, [%r1]+		;// %r3  :=                    x2
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=               x1
		call.d		%r2			;// %r10 :=         xx := x1 * x2
		ld.w		%r13, %r3		;// %r13 :=                    x2			*delay*
		ld.w		%r7, %r10		;// %r7  := w  := + xx
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=               y1
		call.d		%r2			;// %r10 :=         yx := y1 * x2
		ld.w		%r13, %r3		;// %r13 :=                    x2			*delay*
		ld.w		%r6, %r10		;// %r6  := z  := + yx
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=               z1
		call.d		%r2			;// %r10 :=         zx := z1 * x2
		ld.w		%r13, %r3		;// %r13 :=                    x2			*delay*
		ld.w		%r5, %r10		;// %r5  := y  := + zx
		;//
		ld.w		%r12, [%r0]		;// %r12 :=               w1
		call.d		%r2			;// %r10 :=         wx := w1 * x2
		ld.w		%r13, %r3		;// %r13 :=                    x2			*delay*
		ld.w		%r4, %r10		;// %r4  := x  := + wx
		;//
		sub		%r0, 12			;// %r0  := q1
		;//-------------------------------------;
		ld.w		%r3, [%r1]+		;// %r3  :=                         y2
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=                    x1
		call.d		%r2			;// %r10 :=              xy := x1 * y2
		ld.w		%r13, %r3		;// %r13 :=                         y2			*delay*
		ld.w		%r12, %r10		;// %r12 :=              xy
	ext	__subsf3@rm	; 		xcall.d		__subsf3		;// %r10 := z  := - yx + xy
	call.d	__subsf3@rl
		ld.w		%r13, %r6		;// %r13 :=       + yx					*delay*
		ld.w		%r6, %r10		;// %r6  := z
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=                    y1
		call.d		%r2			;// %r10 :=              yy := y1 * y2
		ld.w		%r13, %r3		;// %r13 :=                         y2			*delay*
		ld.w		%r13, %r10		;// %r13 :=              yy
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := w  := + xx + yy
	call.d	__addsf3@rl
		ld.w		%r12, %r7		;// %r12 :=       + xx					*delay*
		ld.w		%r7, %r10		;// %r7  := w
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=                    z1
		call.d		%r2			;// %r10 :=              zy := z1 * y2
		ld.w		%r13, %r3		;// %r13 :=                         y2			*delay*
		ld.w		%r13, %r10		;// %r13 :=              zy
	ext	__subsf3@rm	; 		xcall.d		__subsf3		;// %r10 := x  := + wx - zy
	call.d	__subsf3@rl
		ld.w		%r12, %r4		;// %r12 :=       + wx					*delay*
		ld.w		%r4, %r10		;// %r4  := x
		;//
		ld.w		%r12, [%r0]		;// %r12 :=                    w1
		call.d		%r2			;// %r10 :=              wy := w1 * y2
		ld.w		%r13, %r3		;// %r13 :=                         y2			*delay*
		ld.w		%r13, %r10		;// %r13 :=              wy
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := y  := + zx + wy
	call.d	__addsf3@rl
		ld.w		%r12, %r5		;// %r12 :=       + zx					*delay*
		ld.w		%r5, %r10		;// %r5  := y
		;//
		sub		%r0, 12			;// %r0  := q1
		;//-------------------------------------;
		ld.w		%r3, [%r1]+		;// %r3  :=                              z2
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=                         x1
		call.d		%r2			;// %r10 :=                   xz := x1 * z2
		ld.w		%r13, %r3		;// %r13 :=                              z2		*delay*
		ld.w		%r13, %r10		;// %r13 :=                   xz
	ext	__subsf3@rm	; 		xcall.d		__subsf3		;// %r10 := y  := + zx + wy - xz
	call.d	__subsf3@rl
		ld.w		%r12, %r5		;// %r12 :=       + zx + wy				*delay*
		ld.w		%r5, %r10		;// %r5  := y
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=                         y1
		call.d		%r2			;// %r10 :=                   yz := y1 * z2
		ld.w		%r13, %r3		;// %r13 :=                              z2		*delay*
		ld.w		%r13, %r10		;// %r13 :=                   yz
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := x  := + wx - zy + yz
	call.d	__addsf3@rl
		ld.w		%r12, %r4		;// %r12 :=       + wx - zy				*delay*
		ld.w		%r4, %r10		;// %r4  := x
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=                         z1
		call.d		%r2			;// %r10 :=                   zz := z1 * z2
		ld.w		%r13, %r3		;// %r13 :=                              z2		*delay*
		ld.w		%r13, %r10		;// %r13 :=                   zz
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := w  := + xx + yy + zz
	call.d	__addsf3@rl
		ld.w		%r12, %r7		;// %r12 :=       + xx + yy				*delay*
		ld.w		%r7, %r10		;// %r7  := w
		;//
		ld.w		%r12, [%r0]		;// %r12 :=                         w1
		call.d		%r2			;// %r10 :=                   wz := w1 * z2
		ld.w		%r13, %r3		;// %r13 :=                              z2		*delay*
		ld.w		%r13, %r10		;// %r13 :=                   wz
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := z  := - yx + xy + wz
	call.d	__addsf3@rl
		ld.w		%r12, %r6		;// %r12 :=       - yx + xy				*delay*
		ld.w		%r6, %r10		;// %r6  := z
		;//
		sub		%r0, 12			;// %r0  := q1
		;//-------------------------------------;
		ld.w		%r3, [%r1]		;// %r3  :=                                   w2
		;//
		ld.w		%r12, [%r0]		;// %r12 :=                              x1
		call.d		%r2			;// %r10 :=                        xw := x1 * w2
		ld.w		%r13, %r3		;// %r13 :=                                   w2	*delay*
		ld.w		%r13, %r10		;// %r13 :=                        xw
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := x  := + wx - zy + yz + xw
	call.d	__addsf3@rl
		ld.w		%r12, %r4		;// %r12 :=       + wx - zy + yz			*delay*
		ld.w		[%r0]+, %r10		;// q1->x = x
		;//
		ld.w		%r12, [%r0]		;// %r12 :=                              y1
		call.d		%r2			;// %r10 :=                        yw := y1 * w2
		ld.w		%r13, %r3		;// %r13 :=                                   w2	*delay*
		ld.w		%r13, %r10		;// %r13 :=                        yw
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := y  := + zx + wy - xz + yw
	call.d	__addsf3@rl
		ld.w		%r12, %r5		;// %r12 :=       + zx + wy - xz			*delay*
		ld.w		[%r0]+, %r10		;// q1->y = y
		;//
		ld.w		%r12, [%r0]		;// %r12 :=                              z1
		call.d		%r2			;// %r10 :=                        zw := z1 * w2
		ld.w		%r13, %r3		;// %r13 :=                                   w2	*delay*
		ld.w		%r13, %r10		;// %r13 :=                        zw
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := z  := - yx + xy + wz + zw
	call.d	__addsf3@rl
		ld.w		%r12, %r6		;// %r12 :=       - yx + xy + wz			*delay*
		ld.w		[%r0]+, %r10		;// q1->z = z
		;//
		ld.w		%r12, [%r0]		;// %r12 :=                              w1
		call.d		%r2			;// %r10 :=                        ww := w1 * w2
		ld.w		%r13, %r3		;// %r13 :=                                   w2	*delay*
		ld.w		%r12, %r10		;// %r12 :=                        ww
	ext	__subsf3@rm	; 		xcall.d		__subsf3		;// %r10 := w  := - xx - yy - zz + ww
	call.d	__subsf3@rl
		ld.w		%r13, %r7		;// %r13 :=       + xx + yy + zz			*delay*
		ld.w		[%r0], %r10		;// q1->w = w
		;//-------------------------------------;
		popn		%r3
		ret

	
		.code
		.align		1
		.global		mat3f_rotq
mat3f_rotq:
		pushn		%r3
	sub	%sp,0xc		; 		xsub		%sp, %sp, 48
		ld.w		%r0, %r12		;// %r0  := m
		ld.w		%r1, [%r13]+		;// %r1  := x = q->x
		ld.w		%r2, [%r13]+		;// %r2  := y = q->y
		ld.w		%r3, [%r13]+		;// %r3  := z = q->z
		ld.w		%r4, [%r13]		;// %r4  := w = q->w
	ext	0x10		; 		xld.w		%r5, 0x00800000		;// %r5  := exp = 1
	ext	0x0
	ld.w	%r5,0x0
		;// %r0  := m
		;// %r1  := x
		;// %r2  := y
		;// %r3  := z
		;// %r4  := w
		;// %r5  := exp
		;// %sp  := tmp
		;//-------------------------------------;
		ld.w		%r12, %r1		;// %r12 :=      x
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3		;// %r10 := xy = x * y
	call.d	__mulsf3@rl
		ld.w		%r13, %r2		;// %r13 :=          y				*delay*
		ld.w		%r6, %r10		;// %r6  := xy
		;//
		ld.w		%r12, %r3		;// %r12 :=      z
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3		;// %r10 := zw = z * w
	call.d	__mulsf3@rl
		ld.w		%r13, %r4		;// %r13 :=          w				*delay*
		ld.w		%r7, %r10		;// %r7  := zw
		;//
		ld.w		%r12, %r6		;// %r6  := xy
	ext	__subsf3@rm	; 		xcall.d		__subsf3		;// %r10 := xy - zw
	call.d	__subsf3@rl
		ld.w		%r13, %r7		;// %r7  :=      zw				*delay*
		cmp		%r10, 0			;// if(xy - zw)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (xy - zw) * 2			*delay*
		 sub		%r10, %r5
	ld.w	[%sp+0x1],%r10	; 		xld.w		[%sp+4], %r10		;// [%sp+4]  := tmp->a01 = (xy - zw) * 2
		;//
		ld.w		%r12, %r6		;// %r6  := xy
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := xy + zw
	call.d	__addsf3@rl
		ld.w		%r13, %r7		;// %r7  :=      zw				*delay*
		cmp		%r10, 0			;// if(xy + zw)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (xy + zw) * 2			*delay*
		 sub		%r10, %r5
	ld.w	[%sp+0x4],%r10	; 		xld.w		[%sp+16], %r10		;// [%sp+16] := tmp->a10 = (xy + zw) * 2
		;//-------------------------------------;
		ld.w		%r12, %r2		;// %r12 :=      y
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3		;// %r10 := yz = y * z
	call.d	__mulsf3@rl
		ld.w		%r13, %r3		;// %r13 :=          z				*delay*
		ld.w		%r6, %r10		;// %r6  := yz
		;//
		ld.w		%r12, %r1		;// %r12 :=      x
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3		;// %r10 := xw = x * w
	call.d	__mulsf3@rl
		ld.w		%r13, %r4		;// %r13 :=          w				*delay*
		ld.w		%r7, %r10		;// %r7  := xw
		;//
		ld.w		%r12, %r6		;// %r6  := yz
	ext	__subsf3@rm	; 		xcall.d		__subsf3		;// %r10 := yz - xw
	call.d	__subsf3@rl
		ld.w		%r13, %r7		;// %r7  :=      xw				*delay*
		cmp		%r10, 0			;// if(yz - xw)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (yz - xw) * 2			*delay*
		 sub		%r10, %r5
	ld.w	[%sp+0x6],%r10	; 		xld.w		[%sp+24], %r10		;// [%sp+24] := tmp->a12 = (yz - xw) * 2
		;//
		ld.w		%r12, %r6		;// %r6  := yz
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := yz + xw
	call.d	__addsf3@rl
		ld.w		%r13, %r7		;// %r7  :=      xw				*delay*
		cmp		%r10, 0			;// if(yz + xw)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (yz + xw) * 2			*delay*
		 sub		%r10, %r5
	ld.w	[%sp+0x9],%r10	; 		xld.w		[%sp+36], %r10		;// [%sp+36] := tmp->a21 = (yz + xw) * 2
		;//-------------------------------------;
		ld.w		%r12, %r3		;// %r12 :=      z
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3		;// %r10 := zx = z * x
	call.d	__mulsf3@rl
		ld.w		%r13, %r1		;// %r13 :=          x				*delay*
		ld.w		%r6, %r10		;// %r6  := zx
		;//
		ld.w		%r12, %r2		;// %r12 :=      y
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3		;// %r10 := yw = y * w
	call.d	__mulsf3@rl
		ld.w		%r13, %r4		;// %r13 :=          w				*delay*
		ld.w		%r7, %r10		;// %r7  := yw
		;//
		ld.w		%r12, %r6		;// %r6  := zx
	ext	__subsf3@rm	; 		xcall.d		__subsf3		;// %r10 := zx - yw
	call.d	__subsf3@rl
		ld.w		%r13, %r7		;// %r7  :=      yw				*delay*
		cmp		%r10, 0			;// if(zx - yw)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (zx - yw) * 2			*delay*
		 sub		%r10, %r5
	ld.w	[%sp+0x8],%r10	; 		xld.w		[%sp+32], %r10		;// [%sp+32] := tmp->a20 = (zx - yw) * 2
		;//
		ld.w		%r12, %r6		;// %r6  := zx
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := zx + yw
	call.d	__addsf3@rl
		ld.w		%r13, %r7		;// %r7  :=      yw				*delay*
		cmp		%r10, 0			;// if(zx + yw)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (zx + yw) * 2			*delay*
		 sub		%r10, %r5
	ld.w	[%sp+0x2],%r10	; 		xld.w		[%sp+8], %r10		;// [%sp+8]  := tmp->a02 = (zx + yw) * 2
		;//-------------------------------------;
		ld.w		%r12, %r1		;// %r12 :=      x
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3		;// %r10 := xx = x * x
	call.d	__mulsf3@rl
		ld.w		%r13, %r1		;// %r13 :=          x				*delay*
		ld.w		%r1, %r10		;// %r1  := xx
		;//
		ld.w		%r12, %r2		;// %r12 :=      y
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3		;// %r10 := yy = y * y
	call.d	__mulsf3@rl
		ld.w		%r13, %r2		;// %r13 :=          y				*delay*
		ld.w		%r2, %r10		;// %r1  := yy
		;//
		ld.w		%r12, %r3		;// %r12 :=      z
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3		;// %r10 := zz = z * z
	call.d	__mulsf3@rl
		ld.w		%r13, %r3		;// %r13 :=          z				*delay*
		ld.w		%r3, %r10		;// %r1  := zz
		;//
	ext	0x7f0		; 		xld.w		%r4, 0x3f800000		;// %r4  := 1.0
	ext	0x0
	ld.w	%r4,0x0
		;// %r0  := m
		;// %r1  := xx
		;// %r2  := yy
		;// %r3  := zz
		;// %r4  := 1.0
		;// %r5  := exp
		;// %sp  := tmp
		;//-------------------------------------;
		ld.w		%r12, %r2		;// %r12 := yy
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := yy + zz
	call.d	__addsf3@rl
		ld.w		%r13, %r3		;// %r13 :=      zz				*delay*
		cmp		%r10, 0			;// if(yy + zz)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (yy + zz) * 2			*delay*
		 sub		%r10, %r5
		ld.w		%r12, %r4		;// %r12 := 1.0
	ext	__subsf3@rm	; 		xcall.d		__subsf3		;// %r10 := 1.0 - (yy + zz) * 2
	call.d	__subsf3@rl
		ld.w		%r13, %r10		;// %r13 :=       (yy + zz) * 2			*delay*
	ld.w	[%sp+0x0],%r10	; 		xld.w		[%sp+0], %r10		;// [%sp+0]  := tmp->a00 = 1.0 - (yy + zz) * 2
		;//-------------------------------------;
		ld.w		%r12, %r3		;// %r12 := zz
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := zz + xx
	call.d	__addsf3@rl
		ld.w		%r13, %r1		;// %r13 :=      xx				*delay*
		cmp		%r10, 0			;// if(zz + xx)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (zz + xx) * 2			*delay*
		 sub		%r10, %r5
		ld.w		%r12, %r4		;// %r12 := 1.0
	ext	__subsf3@rm	; 		xcall.d		__subsf3		;// %r10 := 1.0 - (zz + xx) * 2
	call.d	__subsf3@rl
		ld.w		%r13, %r10		;// %r13 :=       (zz + xx) * 2			*delay*
	ld.w	[%sp+0x5],%r10	; 		xld.w		[%sp+20], %r10		;// [%sp+20] := tmp->a11 = 1.0 - (zz + xx) * 2
		;//-------------------------------------;
		ld.w		%r12, %r1		;// %r12 := xx
	ext	__addsf3@rm	; 		xcall.d		__addsf3		;// %r10 := xx + yy
	call.d	__addsf3@rl
		ld.w		%r13, %r2		;// %r13 :=      yy				*delay*
		cmp		%r10, 0			;// if(xx + yy)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (xx + yy) * 2			*delay*
		 sub		%r10, %r5
		ld.w		%r12, %r4		;// %r12 := 1.0
	ext	__subsf3@rm	; 		xcall.d		__subsf3		;// %r10 := 1.0 - (xx + yy) * 2
	call.d	__subsf3@rl
		ld.w		%r13, %r10		;// %r13 :=       (xx + yy) * 2			*delay*
	ld.w	[%sp+0xa],%r10	; 		xld.w		[%sp+40], %r10		;// [%sp+40] := tmp->a22 = 1.0 - (xx + yy) * 2
		;//-------------------------------------;
	ld.w	[%sp+0x3],%r8	; 		xld.w		[%sp+12], %r8		;// [%sp+12] := tmp->a03 = 0.0
	ld.w	[%sp+0x7],%r8	; 		xld.w		[%sp+28], %r8		;// [%sp+28] := tmp->a13 = 0.0
	ld.w	[%sp+0xb],%r8	; 		xld.w		[%sp+44], %r8		;// [%sp+44] := tmp->a23 = 0.0
		ld.w		%r13, %sp		;// %r13 :=        tmp
	ext	mat3f_xform@rm	; 		xcall.d		mat3f_xform		;// mat3f_xform(m, tmp)
	call.d	mat3f_xform@rl
		ld.w		%r12, %r0		;// %r12 :=     m				*delay*
	add	%sp,0xc		; 		xadd		%sp, %sp, 48
		popn		%r3
		ret

; NO_APP
	.align	1
	.global	quatf_rot
quatf_rot:
;	.frame	%sp,24,$31		# vars= 4, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	[%sp+0x0],%r12	; 	xld.w	[%sp],%r12
	ld.w	%r2,%r13
	ld.w	%r0,%r14
	ld.w	%r12,%r2
	ext	vec3f_mag@rm	; 	xcall	vec3f_mag
	call	vec3f_mag@rl
	ld.w	%r3,%r10
	ld.w	%r12,%r0
	ext	0x800		; 	xld.w	%r13,0x40000000		; 2.00000000000000000000e0
	ext	0x0
	ld.w	%r13,0x0
	ext	__divsf3@rm	; 	xcall	__divsf3
	call	__divsf3@rl
	ld.w	%r1,%r10
	ld.w	%r12,%r1
	ext	sinf@rm		; 	xcall	sinf
	call	sinf@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r3
	ext	__divsf3@rm	; 	xcall	__divsf3
	call	__divsf3@rl
	ld.w	%r0,%r10
	ld.w	%r12,%r1
	ext	cosf@rm		; 	xcall	cosf
	call	cosf@rl
	ld.w	%r1,%r10
	ld.w	%r12,[%r2]	; 	xld.w	%r12,[%r2]
	ld.w	%r13,%r0
	ext	__mulsf3@rm	; 	xcall	__mulsf3
	call	__mulsf3@rl
	ld.w	%r11,[%sp+0x0]	; 	xld.w	%r11,[%sp]
	ld.w	[%r11],%r10	; 	xld.w	[%r11],%r10
	ext	0x4		; 	xld.w	%r12,[%r2+4]
	ld.w	%r12,[%r2]
	ld.w	%r13,%r0
	ext	__mulsf3@rm	; 	xcall	__mulsf3
	call	__mulsf3@rl
	ld.w	%r11,[%sp+0x0]	; 	xld.w	%r11,[%sp]
	ext	0x4		; 	xld.w	[%r11+4],%r10
	ld.w	[%r11],%r10
	ext	0x8		; 	xld.w	%r12,[%r2+8]
	ld.w	%r12,[%r2]
	ld.w	%r13,%r0
	ext	__mulsf3@rm	; 	xcall	__mulsf3
	call	__mulsf3@rl
	ld.w	%r11,[%sp+0x0]	; 	xld.w	%r11,[%sp]
	ext	0x8		; 	xld.w	[%r11+8],%r10
	ld.w	[%r11],%r10
	ext	0xc		; 	xld.w	[%r11+12],%r1
	ld.w	[%r11],%r1
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	popn	%r3
	ret
