/*	
 *	clipprnt.c
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Tue May 20 06:00:00 JST 2003 Naoyuki Sawa
 *	- http://minix.technoir.org/src/lib/stdio/doprnt.cɉ܂B
 *	* Thu Jul 13 06:12:00 JST 2006 Naoyuki Sawa
 *	- snprintf(),vsnprintf()ǉ܂B
 *	- snprintf(),vsnprintf()Ή̂߂ɁAdoprnt()܂B
 *	  doprnt()sprintf(),vsprintf()pĂTu[`ŁAp܂B
 *	  sprintf(),vsprintf()ɉeoȂ悤CłA΂炭̊Ԃ͗vӂłB
 *	* Wed Nov 16 02:21:10 JST 2011 Naoyuki Sawa
 *	- ^tB[h'g'(y'G')ɊȈՑΉ܂B
 *	* Tue Jan 31 23:45:07 JST 2012 Naoyuki Sawa
 *	- f_print()́AΒl2147483648.0(=INT_MAX+1)ȏ̎\ƕoOC܂B
 *	  Βl4294967296.0(=UINT_MAX+1)ȏ̎\ƕoO(H)́A܂CłB
 *	* Thu Oct 02 01:02:39 JST 2014 Naoyuki Sawa
 *	- snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
 *	  scprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B
 *	* Sun Oct 12 15:49:27 JST 2014 Naoyuki Sawa
 *	- doprnt()֐ɁAȉ̕ύXs܂B
 *	- W[VC++6.0ŃrhꍇAOUT̒`Windowswb_t@Curpcdce.hvƏՓ˂邽߁AOUT\ߒ`܂B
 *	  W[VC++6.0Ńrhꍇ̑΍􂪕KvɂȂŔAȉ̂ƂłB
 *	- ܂ł́AVC++6.0Ɋ܂܂Ăprintfŏ[̂ŁAW[VC++6.0Ńrh邱Ƃ͍lĂȂ̂łA
 *	  snprintf(),vsnprintf()̖߂l̋ύXAscprintf(),vscprintf(),asprintf(),vasprintf()̒ǉɔ (2014/10/02RgQ)
 *	  VC++6.0p̃vWFNgɂW[܂߂ărhAP/ECEpvOƓʉƎv܂B
 *	  ̂߂ɁAW[VC++6.0ŃrhꍇxoȂ悤A΍􂵂܂B
 *	* Thu Jan 22 21:10:35 JST 2015 Naoyuki Sawa
 *	- Cq'll'Ή܂B
 *	  Cq'll'w肳ꂽꍇAψ̒l̎擾ƁAϊwq'n'ւ̒l̊i[A64rbgōs悤ɂłB
 *	  32rbĝ܂܂łA32rbg͈̔͂𒴂64rbglw肷ƁA32rbĝ݂߂ĕ\܂B
 *	- 32rbĝ܂܂ɂŔAHȃP[XɑΉ邽߂ɐ\ቺ邱Ƃ邽߂łB
 *	  long long^gpvOłAقƂǂ̏ꍇAl32rbg͈̔͂Ɏ܂Ǝv܂B
 *	  ܂ȂĂA\Ȃ邾ŁA(炭)肠܂B
 *	* Sun Aug 02 16:45:48 JST 2015 Naoyuki Sawa
 *	- fprintf(),printf(),vfprintf(),vprintf()Aclipio.cclipprnt.cֈړ܂B
 *	  Win32vWFNgłAdoprnt()𗘗pprintf()𗘗płB
 *	  clipio.cP/ECEɈˑĂ̂Win32vWFNgɊ܂߂܂񂪁Aclipprnt.cȂWin32vWFNgɊ܂߂܂B
 *	- ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B
 *	  '%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B
 *	  ̓Perlsprintf֐Ɍ݊łB
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

					// Ӗ		၁
#define FL_LJUST	(1 <<  0)	// l		%-5d
#define FL_ZEROFILL	(1 <<  1)	// 0l		%05d
#define FL_SIGN		(1 <<  2)	// +/-\		%+5d
#define FL_SPACE	(1 <<  3)	// /-\		% 5d
#define FL_ALT		(1 <<  4)	// 0/0x/0X\		%#x
#define FL_SHORT	(1 <<  5)	// n[t[h	%hd
#define FL_LONG_LONG	(1 <<  6)	// 64rbg		%lld				//{{2015/01/22ύX:Cq'll'Ή܂B}}
#define FL_PRECSPEC	(1 <<  7)	// xw肠		%9.5f
#define FL_SIGNEDCONV	(1 <<  8)	// 		%d
#define FL_NOMORE	(1 << 31)	// igpj

/* widthprecision擾܂B */
static const char*
gnum(const char* fmt, int* ip, va_list* app)
{
	int i, c;

	if(*fmt == '*') {
		*ip = va_arg(*app, int);
		fmt++;
	} else {
		i = 0;
		for(;;) {
			c = *fmt;
			if(c < '0' || '9' < c) break;
			i = i * 10 + (c - '0');
			fmt++;
		}
		*ip = i;
	}

	return fmt;
}

/* l\܂B */
static char*
i_compute(unsigned val, int base, char* s, int precision)
{
	int c;

	c = val % base;
	val /= base;
	if(val || precision > 1) s = i_compute(val, base, s, precision - 1);
	*s++ = c < 10 ? '0' + c : 'a' + (c - 10);

	return s;
}

/* \܂B */
static char*
o_print(char* s, int flags, int nrdigits, int c, va_list* app)
{
	unsigned val;
	int base;
	char *old_s = s;

	/* l擾B */
	       if(flags & FL_LONG_LONG) {
#ifdef  _MSC_VER
		                            val = va_arg(*app, unsigned __int64  );		//{{2015/01/22ύX:Cq'll'Ή܂B}}
#else //_MSC_VER
		                            val = va_arg(*app, unsigned long long);		//{{2015/01/22ύX:Cq'll'Ή܂B}}
#endif//_MSC_VER
	} else if(flags & FL_SHORT    ) {
		if(flags & FL_SIGNEDCONV) { val = va_arg(*app,          short    ); }
		else                      { val = va_arg(*app, unsigned short    ); }
	} else {
		                            val = va_arg(*app, unsigned          );
	}

	/* \B */
	if(flags & FL_SIGNEDCONV) {
		if((int)val < 0) {
			*s++ = '-';
			val = -(int)val;
		} else if(flags & FL_SIGN) {
			*s++ = '+';
		} else if(flags & FL_SPACE) {
			*s++ = ' ';
		}
	}

	/* \B */
	if(flags & FL_ALT) {
		switch(c) {
	    //{{2015/08/02ǉ:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
		case 'b':
		case 'B': *s++ = '0'; *s++ = 'b'; break;
	    //}}2015/08/02ǉ:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
		case 'o': *s++ = '0';             break;
		case 'p':
		case 'x':
		case 'X': *s++ = '0'; *s++ = 'x'; break;
		}
	}

	/* l\B */
	switch(c) {
	case 'b':
	case 'B': base =  2; break;
	case 'o': base =  8; break;
	case 'd':
	case 'i':
	case 'u': base = 10; break;
	case 'p':
	case 'x':
	case 'X': base = 16; break;
	default : base = -1; DIE();
	}
	s = i_compute(val, base, s, nrdigits);
    //{{2015/08/02ύX:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
    //	if(c == 'X') {
    //2015/08/02ύX:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
	if(isupper(c)) {
    //}}2015/08/02ύX:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
		while(old_s != s) {
			*old_s = toupper(*old_s);
			old_s++;
		}
	}

	return s;
}

/* \܂B */
static char*
f_print(char* s, int flags, int precision, va_list* app)
{
	double val;
	int c;

	/* l擾B */
	val = va_arg(*app, double);

	/* \B */
	if(val < 0) {
		*s++ = '-';
		val = -val;
	} else if(flags & FL_SIGN) {
		*s++ = '+';
	} else if(flags & FL_SPACE) {
		*s++ = ' ';
	}

	/* ľܓp+0.5or0.05or0.005... */
	val += pow(10, -precision) / 2;

	/* \B */
	c = (int)val;
//{{2012/01/31:Βl2147483648.0(=INT_MAX+1)ȏ̎\ƕoOC
//	val -= c;
//2012/01/31:Βl2147483648.0(=INT_MAX+1)ȏ̎\ƕoOC
	val -= (unsigned)c;
//}}2012/01/31:Βl2147483648.0(=INT_MAX+1)ȏ̎\ƕoOC
	s = i_compute(c, 10, s, 1);

	/* \B */
	if(precision) {
		*s++ = '.';
		do {
			val *= 10;
			c = (int)val;
			val -= c;
			*s++ = '0' + c;
		} while(--precision);
	}

	return s;
}

static int
//doprnt(char* out, const char* fmt, va_list ap)
//~2006/07/13 snprintf(),vsnprintf()Ή
//~
//~- snprintf(),vsnprintf()ΉɂāAdoprnt()̈Ƀobt@TCY(cnt)ǉ̂łȂAobt@̃|C^(end)ǉ悤݌vŔA
//~  Avsprintf()̗pɁAobt@\̂eՂłB(obt@̖̃|C^́A((char*)-1)ƕ\܂B)
//~  ܂Adoprnt()̎ɂĂAcobt@TCYǗȀo͈ʒu(out)obt@(end)𒴂ĂȂȒPłB
//~
//~- snprintf()ȉ̂悤ɌĂяoꍇA
//~
//~	char buf[10];
//~	snprintf(buf, 10, fmt, ...);
//~
//~  doprnt()ւ̈out,end́A}̂悤ȈʒuwĂ܂B
//~
//~	buf[0][1][2][3][4][5][6][7][8][9]
//~	    |                          |
//~	   out                        end
//~
//~  end(obt@̖)łA(obt@̖+1)ł͂ȂƂɒӂĂB
//~  I[nul܂܂ȂALȕi[ł̂́A(out`end-1)͈̔͂ƂȂ܂B
//~
//~- I[nul܂܂ȂLȕ(out`end-1)͈̔͂Ɏ܂ꍇAnuli[Anul܂܂ȂԂ܂B
//~  I[nul܂܂ȂLȕ(end-1)𒴂ꍇA(end-1)ȍ~؂̂Ă(end)nuli[A(-1)Ԃ܂B
//~
//~- Asnprintf()obt@TCY0ŌĂяoꍇA
//~
//~	snprintf(buf, 0, fmt, ...);
//~
//~  doprnt()ւ̈out,end́AendoutOwĂ܂B
//~
//~	buf[-1][0]
//~	    |   |
//~	   end out
//~
//~  ̏ꍇAI[nuli[ɁA(-1)Ԃ܂B
//~
//* Thu Oct 02 01:02:39 JST 2014 Naoyuki Sawa
//- snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
//
//  ɔAdoprnt()̈end̎dlA(obt@̖)(obt@̖+1)ɕύX܂B
//  usnprintf(NULL,0,fmt,...)vĂяoꂽꍇɁA(out=0x00000000,end=0xFFFFFFFF)ɂȂ邽߂łB
//
//  OUT(C)}NAobt@I[nuli[ʒu܂ŁAi[Ă܂ƂɂȂ܂AŌnulŏ㏑̂Ŗ肠܂B
//  uif(out<end)v̏uif(out<(end-1))vɕύXĂǂ̂łAR[hTCŶŁAs܂łB
//  Oq̂ƂAuif(out<end)v̂܂܂łAʂ͓ɂȂ̂Ŗ肠܂B
//
//  ́Aoutend̎wʒúAȉ̂悤ɂȂ܂B
//
//- snprintf()ȉ̂悤ɌĂяoꍇA
//
//	char buf[10];
//	snprintf(buf, 10, fmt, ...);
//
//  doprnt()ւ̈out,end́A}̂悤ȈʒuwĂ܂B
//
//	buf[0][1][2][3][4][5][6][7][8][9](10)
//	    |                             |
//	   out                           end
//
//- Asnprintf()obt@TCY0ŌĂяoꍇA
//
//	snprintf(buf, 0, fmt, ...);
//
//  doprnt()ւ̈out,end́AǂʒuwĂ܂B
//
//	buf[0]
//	    |
//	 out,end 
//
doprnt(char* out, char* end, const char* fmt, va_list ap)
{
//{{2014/10/12ǉ:W[VC++6.0ŃrhꍇAOUT̒`Windowswb_t@Curpcdce.hvƏՓ˂邽߁AOUT\ߒ`܂B
#ifdef  WIN32
#undef  OUT
#endif//WIN32
//}}2014/10/12ǉ:W[VC++6.0ŃrhꍇAOUT̒`Windowswb_t@Curpcdce.hvƏՓ˂邽߁AOUT\ߒ`܂B
/*{{2006/07/13 snprintf(),vsnprintf()Ή*/
#define OUT(C)				\
	do {				\
		char __c__ = (C);	\
		if(out < end) {		\
			*out = __c__;	\
		}			\
		out++;			\
	} while(0)
/*}}2006/07/13 snprintf(),vsnprintf()Ή*/

	int c, pad, len, flags, width, precision, zfill;
	char buf[256];	/* l̏o͕␸x̃TCY𒴂ƈُ퓮삵܂B */
	char *s, *old_s;
	char *old_out = out;

	/* 𑖍āc */
	while((c = *fmt++) != '\0') {
		/* w%[flags][width][.precision][h|l]typexłȂ΂̂܂ܕ\B */
		if(c != '%') {
			//*out++ = c;
			//2006/07/13 snprintf(),vsnprintf()Ή
			OUT(c);
			continue;
		}

		/* [flags]擾B */
		flags = 0;
		do {
			switch(*fmt) {
			case '-': flags |= FL_LJUST;    break;	/* l */
			case '0': flags |= FL_ZEROFILL; break;	/* 0l */
			case '+': flags |= FL_SIGN;     break;	/* +/-\ */
			case ' ': flags |= FL_SPACE;    break;	/* /-\ */
			case '#': flags |= FL_ALT;      break;	/* 0/0x/0X\ */
			default : flags |= FL_NOMORE;   continue;
			}
			fmt++;
		} while(!(flags & FL_NOMORE));
		if((flags & FL_LJUST) && (flags & FL_ZEROFILL)) DIE();
		if((flags & FL_SIGN ) && (flags & FL_SPACE   )) DIE();

		/* [width]擾B */
		fmt = gnum(fmt, &width, &ap);
		if(*fmt == '.') {
			fmt++;
			fmt = gnum(fmt, &precision, &ap);
			flags |= FL_PRECSPEC;
		}

		/* [h|l]擾B */
		switch(*fmt) {
		case 'h': flags |= FL_SHORT; fmt++; break;
		case 'l': fmt++; if(*fmt == 'l') { flags |= FL_LONG_LONG; fmt++; } break;	//{{2015/01/22ύX:Cq'll'Ή܂B}}
		case 'L': DIE(); /* long double ͖Ή */
		}

		s = old_s = buf;
		switch(c = *fmt++) {
		default:
			//*out++ = c;
			//2006/07/13 snprintf(),vsnprintf()Ή
			OUT(c);
			continue;
		case 'n':
			       if(flags & FL_LONG_LONG) {
#ifdef  _MSC_VER
				*va_arg(ap, __int64  *) = (__int64  )(out - old_out);		//{{2015/01/22ύX:Cq'll'Ή܂B}}
#else //_MSC_VER
				*va_arg(ap, long long*) = (long long)(out - old_out);		//{{2015/01/22ύX:Cq'll'Ή܂B}}
#endif//_MSC_VER
			} else if(flags & FL_SHORT    ) {
				*va_arg(ap, short    *) = (short    )(out - old_out);
			} else {
				*va_arg(ap, int      *) = (int      )(out - old_out);
			}
			continue;
		case 'c':
			*s++ = va_arg(ap, int);
			break;
		case 's':
			old_s = va_arg(ap, char*);
			if(old_s == NULL) old_s = "(null)";
			s = old_s;
			while(*s != '\0') {
				if(flags & FL_PRECSPEC) {
					if(!precision) break;
					precision--;
				}
				s++;
			}
			break;
		case 'b':
		case 'B':
		case 'o':
		case 'u':
		case 'p':
		case 'x':
		case 'X':
			if(!(flags & FL_PRECSPEC)) precision = 1;
			s = o_print(s, flags, precision, c, &ap);
			break;
		case 'd':
		case 'i':
			flags |= FL_SIGNEDCONV;
			if(!(flags & FL_PRECSPEC)) precision = 1;
			s = o_print(s, flags, precision, c, &ap);
			break;
		case 'f':
		case 'e': /* 1.2e3`͖ΉB'f'ƓƂ܂B */
		case 'E': /* 1.2e3`͖ΉB'f'ƓƂ܂B */
		case 'g': /* 1.2e3`͖ΉB'f'ƓƂ܂B */
		case 'G': /* 1.2e3`͖ΉB'f'ƓƂ܂B */
			flags |= FL_SIGNEDCONV;
			if(!(flags & FL_PRECSPEC)) precision = 6;
			s = f_print(s, flags, precision, &ap);
/*{{2011/11/16ǉ 'g'(y'G')ȈՑΉ*/
			/* * Wed Nov 16 02:21:10 JST 2011 Naoyuki Sawa
			 * - ^tB[h'g'(y'G')ɊȈՑΉ܂B
			 * - {́A'g'(y'G')̓́Aȉ̂ƂłB
			 *   @ lɂāA'f''e'('E')̏AIB
			 *   A x́Ǎł͂ȂA+̌łB
			 *   B ̖ɂ'0'(S'0'Ȃ'.')A\ȂB
			 * - 'g'(y'G')p闝ŔAB̖ړIł悤łB
			 *   ṓA@A͑ΉAB݂̂ȈՑΉ܂B
			 * - 'g'(y'G')̎gpƂẮALUAꂪ'g'gpĂ܂B
			 *   LUA͑SĂ̐lłA'g'gpĐl\Ă邽߁A̖ĺAł邩̂悤ɕ\̂łB
			 */
			if((c == 'g') || (c == 'G')) {
				/* x0łȂ΁Af_print()̏ŁA'.'ƏȂƂꌅ̏AsɊi[Ă͂B */
				if(precision) {
					/* sɊi[ꂽ񂩂A'0'ƁAS'0'Ȃ'.'菜B */
					for(;;) {
						/* ꕶO'.'Ȃ΁A'.'菜āAB */
						       if(*(s - 1) == '.') {
							s--;
							break;
						/* ꕶO'0'Ȃ΁A'0'菜āApB */
						} else if(*(s - 1) == '0') {
							s--;
						/* ꕶO'1'`'9'Ȃ΁A菜ɁAB */
						} else {
							break;
						}
					}
				}
			}
/*}}2011/11/16ǉ 'g'(y'G')ȈՑΉ*/
			break;
		}

		zfill = (flags & FL_ZEROFILL) ? '0' : ' ';
		len = s - old_s;
		pad = width - len;
		if(pad > 0) {
			if(!(flags & FL_LJUST)) {
				/* (+/-/)Ɗ(0/0x/0X)0l߂ɐs܂B */
				if(flags & FL_ZEROFILL) {
					if(flags & FL_SIGNEDCONV) {
						switch(*old_s) {
						case '+':
						case '-':
						case ' ':
							//*out++ = *old_s++;
							//2006/07/13 snprintf(),vsnprintf()Ή
							OUT(*old_s++);
							len--;
							break;
						}
					}
					if(flags & FL_ALT) {
						//switch(c) {
						//case 'o':
						//	*out++ = *old_s++;
						//	len--;
						//	break;
						//case 'p':
						//case 'x':
						//case 'X':
						//	*out++ = *old_s++;
						//	*out++ = *old_s++;
						//	len -= 2;
						//	break;
						//}
						//2006/07/13 snprintf(),vsnprintf()Ή
						switch(c) {
					    //{{2015/08/02ǉ:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
						case 'b':
						case 'B':
					    //}}2015/08/02ǉ:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
						case 'p':
						case 'x':
						case 'X':
							OUT(*old_s++);
							len--;
							/* FALLTHRU */
						case 'o':
							OUT(*old_s++);
							len--;
							break;
						}
					}
				}
				/* 󔒂܂0l߁B */
				while(pad > 0) {
					//*out++ = zfill;
					//2006/07/13 snprintf(),vsnprintf()Ή
					OUT(zfill);
					pad--;
				}
			}
		}
		while(len > 0) {
			//*out++ = *old_s++;
			//2006/07/13 snprintf(),vsnprintf()Ή
			OUT(*old_s++);
			len--;
		}
		while(pad > 0) {
			//*out++ = zfill;
			//2006/07/13 snprintf(),vsnprintf()Ή
			OUT(zfill);
			pad--;
		}
	}

//{{2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
//	//*out = '\0'; /* I[NULYꂸ! */
//	//return out - old_out;
//	//2006/07/13 snprintf(),vsnprintf()Ή
//	if(out <= end) {
//		*out = '\0';
//		return out - old_out;
//	} else {
//		if(end >= old_out) {
//			*end = '\0';
//		} else {
//			/* obt@TCY0ȉ̏ꍇ́Anuli[ȂB */
//		}
//		return -1;
//	}
//2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
	if(out < end) {
		*out = '\0';
	} else {
		if(end > old_out) {
			*(end - 1) = '\0';
		} else {
			/* obt@TCY0ȉ̏ꍇ́Anuli[ȂB */
		}
	}
	return out - old_out;	//obt@s(-1)łȂu\ȃXy[XΏ܂ꂽł낤̌vԂ܂B
//}}2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B

/*{{2006/07/13 snprintf(),vsnprintf()Ή*/
#undef OUT
/*}}2006/07/13 snprintf(),vsnprintf()Ή*/
}

/****************************************************************************
 *
 ****************************************************************************/

/* u#include <piece.h>v̑OɁu#define NOPCESPRINTFvYꂸɁI */

/* P/ECEJ[l܂EPSONCů֐u܂B */
int
vsprintf(char* out, const char* fmt, va_list ap)
{
	//return doprnt(out, fmt, ap);
	//2006/07/13 snprintf(),vsnprintf()Ή
	return doprnt(out, (char*)-1/*obt@̖*/, fmt, ap);	//{{2014/10/02l:ɂ͍L̎wł͖obt@[0xFFFFFFFF]܂܂܂B{[0xFFFFFFFF]܂ގ͍lȂ̂Ŏ肠܂B}}
}

/* P/ECEJ[l܂EPSONCů֐u܂B */
int
sprintf(char* out, const char* fmt, ...)
{
	int n;
	va_list ap;
	va_start(ap, fmt);
	n = vsprintf(out, fmt, ap);
	va_end(ap);
	return n;
}

/*{{2006/07/13 snprintf(),vsnprintf()Ή*/

/* * Thu Jul 13 06:12:00 JST 2006 Naoyuki Sawa
 * - vsnprintf()ǉ܂B
 *   P/ECEJ̃Cuɂ́Avsnprintf()܂܂Ă܂B
 * - vsnprintf()́AC99ɂĐɒǉꂽ֐łB
 *   C99ɏĂȂRpCł́Avsnprintf()T|[gĂȂAĂꍇ܂B
 *   ƂVC++6.0_vsnprintf()́Ao͕(n-1)𒴂ꍇ̋Ă܂B
 *   o͕(n-1)𒴂ꍇAC99̎dlł́A(n-1)܂ŕo͂A(n)ڂnuli[܂B
 *   ɑ΂VC++6.0̎dlł́A(n)܂ŕo͂Anuli[܂B(strncpy()ɎłB)
 *   C99̎dl̕Ao͕񂪊mnulI[̂ŁAgՂƎv܂B
 *   ̎́AC99̎dlɏ]܂B
 * - C99VC++6.0̋̈ႢTvR[hAȉɎ܂B
 *   ȉ̃TvR[hsnprintf()̗łAvsnprintf()lłB
 *
 *	main() {
 *	    char buf[] = "0123456789";
 *	    snprintf(buf, 5, "ABCDEFG");     // C99̋c
 *	    printf("<%s>\n", buf);           //   ʁuABCDv
 *	    _snprintf(buf, 5, "ABCDEFG");    // VC++6.0̋c
 *	    printf("<%s>\n", buf);           //   ʁuABCDE56789v
 *	}
 *
 * - QluvO~O C ̐V@\ (http://seclan.dll.jp/c99d/c99d08.htm#dt19991115)v
 *	
 *	O	int vsnprintf(char * restrict s, size_t n, const char * restrict format, va_list arg);		
 *	
 *	wb_stdio.h												
 *	
 *		s      : o͐obt@										
 *		n      : o͐obt@̕									
 *		format : 												
 *		arg    : va_start ŏl									
 *	
 *	߂lo͂BI[̃k͊܂܂ȂBG[͕̒lB							{{2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂Bobt@s(-1)łȂu\ȃXy[XΏ܂ꂽł낤̌vԂ܂BG[邱Ƃ͖̂Ŏ(-1)Ԃ邱Ƃ͗L܂Bڍׂ́uThu Oct 02 01:02:39 JST 2014ṽRgQƂĂB}}
 *	
 *		vsprintf  o͕ΉŁBformat ɏ] s ɍő n - 1 o͂B		
 *		n - 1 ȏo͂ꂽꍇ͔jBs ̏I[ɂ̓ktB				
 *		Ql : wchar_t 󂯕t֐ vswprintf A̓obt@włdlɂȂĂB	
 *	
 */
int
vsnprintf(char* out, int cnt, const char* fmt, va_list ap)
{
//{{2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
//	return doprnt(out, out + cnt - 1/*obt@̖*/, fmt, ap);
//2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
	return doprnt(out, (out + cnt)/*obt@̖+1*/, fmt, ap);
//}}2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
}

/* * Thu Jul 13 06:12:00 JST 2006 Naoyuki Sawa
 * - snprintf()ǉ܂B
 *   P/ECEJ̃Cuɂ́Asnprintf()܂܂Ă܂B
 * - VC++6.0_snprintf()Ƃ̋̈ႢɂẮAvsnprintf()ƓlłB
 *   vsnprintf()̃RgQƂĂB
 *
 * - QluvO~O C ̐V@\ (http://seclan.dll.jp/c99d/c99d08.htm#dt19991115)v
 *	
 *	O	int snprintf(char * restrict s, size_t n, const char * restrict format, ...);				
 *	
 *	wb_stdio.h												
 *	
 *		s      : o͐obt@										
 *		n      : o͐obt@̕									
 *		format : 												
 *		...    : Ŏw肵l										
 *	
 *	߂lo͂BI[̃k͊܂܂ȂBG[͕̒lB							{{2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂Bobt@s(-1)łȂu\ȃXy[XΏ܂ꂽł낤̌vԂ܂BG[邱Ƃ͖̂Ŏ(-1)Ԃ邱Ƃ͗L܂Bڍׂ́uThu Oct 02 01:02:39 JST 2014ṽRgQƂĂB}}
 *	
 *		sprintf ̏o͕wŁBformat ɏ] s ɍő n - 1 o͂B		
 *		n - 1 ȏo͂ꂽꍇ͔jBs ̏I[ɂ̓ktB				
 *		Ql : wchar_t 󂯕t֐ swprintf A̓obt@włdlɂȂĂB	
 *	
 */
int
snprintf(char* out, int cnt, const char* fmt, ...)
{
	int n;
	va_list ap;
	va_start(ap, fmt);
	n = vsnprintf(out, cnt, fmt, ap);
	va_end(ap);
	return n;
}
/*}}2006/07/13 snprintf(),vsnprintf()Ή*/

/****************************************************************************
 *
 ****************************************************************************/

//{{2014/10/02ǉ:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂Bscprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B

//	* Thu Oct 02 01:02:39 JST 2014 Naoyuki Sawa
//	- snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
//	  scprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B
//	  ڍׂ́Aȉ̍ڂQƂĂB
//	- ܂ŁAI[nul̋ɂĂC99ɂĂ̂łAsnprintf̃obt@s̖߂l̋VC++6.0̋ɂȂĂ܂Ă܂B
//	  C99(yGCC)́u\ȃXy[XΏ܂ꂽł낤̌vԂ܂BVC++6.0́u̒l(ۂɂ-1)vԂ܂BcQl@
//	  snprintf̃obt@s̖߂l̋AC99֗̕ł邽߁AC99ɕύX邱Ƃɂ܂B
//	- ̕ύXÃvOɉe\邽߁AӂĂB
//	  Cuł́Acliptime.cstrftime()ɉeL߁Astrftime()C܂B
//	  ́Asnprintf̖߂lobt@s𔻒fɂ́Auretval<0vł͂Ȃu(unsigned)retval>=(unsigned)cntvƂĂB
//	- VC++łA_vscprintfgp邱ƂŁAC99̋V~[g邱Ƃł܂BcQlA
//	  AVC++6.0ɂ_vscprintf͗L܂B(Visual Studio 2005ȍ~Œǉꂽ悤łB)
//	  _vscprintf́APƂł֗Ȃ̂ŁAP/ECEVC++6.0łgpł悤ACuŎ邱Ƃɂ܂B
//	- _vscprintfƃmۂ𕹗pƁAtH[}bgWJobt@̊mۂs܂BcQlB
//	  GCCɂ́AL܂Ƃ߂čs֐ƂāAasprintfL܂BcQlC
//	  ֗Ȃ̂ŁAP/ECEVC++6.0łgpł悤ACuŎ邱Ƃɂ܂B
//	  ȂAG[strp̋́AFreeBSD̎Ɍ݊ƂAG[̍ۂɂstrpNULLɃZbg邱Ƃɂ܂B
//	- asprintfgƁA̕AāAVubN쐬邱Ƃł܂B
//	  strdup()strcat()𓯎ɍs悤ȊłBcQlD
//	
//	Ql@uStack Overflowv(http://stackoverflow.com/)́Awsnprintf and Visual Studio 2010x(http://stackoverflow.com/questions/2915672/snprintf-and-visual-studio-2010)̃y[Wp:
//	Microsoft says its customers aren't pressuring enough for C99 support. But with snprintf part of C++11, you're likely to see it implemented by 2014.
//	Until then, you can simulate (v)snprintf like this:
//	#ifdef  _MSC_VER
//	#define snprintf c99_snprintf
//	inline int c99_snprintf(char* str, size_t size, const char* format, ...) {
//	  int count;
//	  va_list ap;
//	  va_start(ap, format);
//	  count = c99_vsnprintf(str, size, format, ap);
//	  va_end(ap);
//	  return count;
//	}
//	inline int c99_vsnprintf(char* str, size_t size, const char* format, va_list ap) {
//	    int count = -1;
//	    if(size != 0)
//	      count = _vsnprintf_s(str, size, _TRUNCATE, format, ap);
//	    if(count == -1)
//	      count = _vscprintf(format, ap);
//	    return count;
//	}
//	#endif//_MSC_VER
//	As mentioned in the standard:
//	Eat most size bytes get written (including terminating '\0')
//	Eif output was truncated, the return value is the number of characters (excluding terminating '\0') that would have been written
//	
//	This will not always terminate the string with a 0 which is required on a overflow.
//	The second if in c99_vsnprintf must be: if (count == -1) { if (size > 0) str[size - 1] = 0; count = _vscprintf(format, ap); }
//	
//	QlAuMicrosoft Developer Networkv(http://msdn.microsoft.com/)́Aw_vscprintfA_vscprintf_lA_vscwprintfA_vscwprintf_lx(http://msdn.microsoft.com/ja-jp/library/w05tbk72.aspx)̃y[Wp:
//	Xgւ̃|C^[gpďw肳ꂽ̕Ԃ܂B
//	              int _vscprintf(const char* format, va_list argptr);
//	              int _vscprintf_l(const char* format, locale_t locale, va_list argptr);
//	              int _vscwprintf(const wchar_t* format, va_list argptr);
//	              int _vscwprintf_l(const wchar_t* format, locale_t locale, va_list argptr);
//	p[^[  format w蕶B
//	              argptr Xgւ̃|C^[B
//	              locale gp郍P[B
//	߂l        _vscprintf֐́AXgw񂪁Aw̏R[hgpďo͂邩A܂̓t@Cobt@[ɑMꂽꍇɐ镶Ԃ܂B
//	              Ԃlɂ́AI[NULL͊܂܂܂BCh̏ꍇ́A_vscwprintf@\s܂B
//	              _lTtBbNXtĂ邱̊֐̊eo[ẂÃ݂XbhP[̑ɓnꂽP[p[^[gp_ēłB
//	              formatnull|C^[̏ꍇ́Aup[^[̌؁vɐĂ悤ɁAȃp[^[nh[Ăяo܂B
//	              špꂽꍇA֐-1ԂAerrnoEINVALɐݒ肵܂B
//	          eargumentformat̑Ή鏑wɏ](݂ꍇ)ɕϊ܂Bformat͒ʏ̕ō\Ǎ`Ƌ@\printf֐formatƓłB
//			
//	QlBujianji-productionv(http://jianji.noor.jp/)́AwtH[}bgWJobt@̊mہx(http://jianji.noor.jp/wiki/index.cgi?page=%A5%D5%A5%A9%A1%BC%A5%DE%A5%C3%A5%C8%CA%B8%BB%FA%CE%F3%A4%F2%C5%B8%B3%AB%A4%B9%A4%EB%A5%D0%A5%C3%A5%D5%A5%A1%A4%CE%B3%CE%CA%DD)̃y[Wp:
//	RpCɂĕ悤B
//	GNUg̏ꍇ
//	vasprintfŃobt@̊mۂƃRs[𓯎ɍsB
//	void MyPrintf(const char* format, ...) {
//	  va_list argptr;
//	  va_start(argptr, format);
//	  char* buf_ = NULL;
//	  vasprintf(&buf_, format, argptr);
//	  MyPrintString(buf_);
//	  free(buf_);
//	  va_end(argptr);
//	}
//	VCg̏ꍇ
//	_vscprintfœWJ̕񒷂擾A+1̃obt@pӂB
//	void MyPrintf(const char* format, ...) {
//	  va_list argptr;
//	  va_start(argptr, format);
//	  int length = _vscprintf(format, argptr);
//	  char* buf_ = new char [length + 1];
//	  vsprintf(buf_, format, argptr);
//	  MyPrintString(buf_);
//	  delete[] buf_;
//	  va_end(argptr);
//	}
//	VCg̓mۂOł̂ŁA_ȈہB
//	
//	QlCuJM Projectv(http://linuxjm.sourceforge.jp/)́AwMan page of ASPRINTFx(http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/asprintf.3.html)̃y[Wp:
//	O          asprintf, vasprintf - 蓖ĂĂɏo͂
//	          #define _GNU_SOURCE /* feature_test_macros(7) Q */
//	              #include <stdio.h>
//	              int asprintf(char** strp, const char* fmt, ...);
//	              int vasprintf(char** strp, const char* fmt, va_list ap);
//	          asprintf()֐vasprintf()֐Ƃ́Aꂼsprintf(3)֐vsprintf(3)֐ƂɎĂ邪A
//	              o͕(I[̃koCg('\0')܂߂)ێ̂ɏ\ȑ傫̃mۂAŏ̈ɂ̕ւ̃|C^ԂB
//	              ̃|C^́AsvɂȂfree(3)ɓnA蓖ĂꂽLׂ̈łB
//	Ԃl        ƁÅ֐͏o͂ꂽoCg(sprintf(3)̂悤)ԂB
//	              ̊蓖ĂłȂȂG[ƁÅ֐-1ԂAstrp̓e͖`ƂȂB
//	          ̊֐GNŮgłACPOSIX̂̂ł͂ȂB*BSDłpłB
//	              FreeBSD̎ł́AG[̍ۂɂstrpNULLɃZbgB
//	
//	QlDuStack Overflowv(http://stackoverflow.com/)́AwIs there a neat way to do strdup() followed by strcat()?x(http://stackoverflow.com/questions/12591074/is-there-a-neat-way-to-do-strdup-followed-by-strcat)̃y[Wp:
//	Say I wanted to duplicate a string then concatenate a value to it.
//	Using stl std::string, it's:
//	string s = "hello";
//	string s2 = s + " there"; //effectively dup/cat
//	in C:
//	char* s = "hello";
//	char* s2 = strdup(s);
//	strcat(s2, " there"); //s2 is too short for this operation
//	The only way I know to do this in C is:
//	char* s = "hello";
//	char* s2 = (char*)malloc(strlen(s) + strlen(" there") + 1); //allocate enough space
//	strcpy(s2, s);
//	strcat(s2, " there");
//	Is there a more elegant way to do this in C?
//	
//	A GNU extension is asprintf() that allocates the required buffer:
//	char* s2;
//	if(-1 != asprintf(&s2, "%s%s", "hello", " there") {
//	  free(s2);
//	}

int scprintf(const char* fmt, ...) {
	int n;
	va_list ap;
	va_start(ap, fmt);
	n = vscprintf(fmt, ap);
	va_end(ap);
	return n;
}
int vscprintf(const char* fmt, va_list ap) {
	return doprnt(NULL, NULL, fmt, ap);
}

int asprintf(char** strp, const char* fmt, ...) {
	int n;
	va_list ap;
	va_start(ap, fmt);
	n = vasprintf(strp, fmt, ap);
	va_end(ap);
	return n;
}
int vasprintf(char** strp, const char* fmt, va_list ap) {
	if(!(*strp = malloc(vscprintf(fmt, ap) + 1/*nul*/))) { return -1; }
	return vsprintf(*strp, fmt, ap);
}

//}}2014/10/02ǉ:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂Bscprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B

/****************************************************************************
 *
 ****************************************************************************/

//{{2015/08/02ǉ:fprintf(),printf(),vfprintf(),vprintf()Aclipio.cclipprnt.cֈړ܂BWin32vWFNgłAdoprnt()𗘗pprintf()𗘗płBclipio.cP/ECEɈˑĂ̂Win32vWFNgɊ܂߂܂񂪁Aclipprnt.cȂWin32vWFNgɊ܂߂܂B

/* * Sun Aug 02 16:45:48 JST 2015 Naoyuki Sawa
 * - fprintf(),printf(),vfprintf(),vprintf()Aclipio.cclipprnt.cֈړ܂B
 *   Win32vWFNgłAdoprnt()𗘗pprintf()𗘗płB
 *   clipio.cP/ECEɈˑĂ̂Win32vWFNgɊ܂߂܂񂪁Aclipprnt.cȂWin32vWFNgɊ܂߂܂B
 */
int fprintf(FILE* stream, const char* format, ...) {
	int retval;
	va_list argptr;
	va_start(argptr, format);
	retval = vfprintf(stream, format, argptr);
	va_end(argptr);
	return retval;
}
int printf(const char* format, ...) {
	int retval;
	va_list argptr;
	va_start(argptr, format);
	retval = vprintf(format, argptr);
	va_end(argptr);
	return retval;
}
int vfprintf(FILE* stream, const char* format, va_list argptr) {
   //{{2015/05/01ύX:vfprintf()_def_vbuff[]𗘗p̂߂āAvasprintf()𗘗p悤ɕύX܂B
   //	//WJobt@Ƃ_def_vbuff[]𗘗pĂ܂B
   //	return fwrite(_def_vbuff, 1, vsprintf(_def_vbuff, format, argptr), stream);
   //2015/05/01ύX:vfprintf()_def_vbuff[]𗘗p̂߂āAvasprintf()𗘗p悤ɕύX܂B
	char* s;
	int n = vasprintf(&s, format, argptr);
	if(n < 0) { DIE(); }
	n = fwrite(s, 1, n, stream);
	free(s);
	return n;
   //}}2015/05/01ύX:vfprintf()_def_vbuff[]𗘗p̂߂āAvasprintf()𗘗p悤ɕύX܂B
}
int vprintf(const char* format, va_list argptr) {
	return vfprintf(stdout, format, argptr);
}

//}}2015/08/02ǉ:fprintf(),printf(),vfprintf(),vprintf()Aclipio.cclipprnt.cֈړ܂BWin32vWFNgłAdoprnt()𗘗pprintf()𗘗płBclipio.cP/ECEɈˑĂ̂Win32vWFNgɊ܂߂܂񂪁Aclipprnt.cȂWin32vWFNgɊ܂߂܂B
