/*	
 *	clipm68i.h
 *
 *	P/ECE M6800 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Feb 01 06:23:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_M68I_H__
#define __CLIP_M68I_H__

/*
 *	M6800RAp̃}N`܂B
 *	}NPāȂ̃}NƏՓ˂鋰ꂪ̂ŁA
 *	M6800RA\[Xt@Ĉ݃CN[hĂB
 */

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	M6800\̃oANZX̊ȗ\L
 */
/*===== WX^ =====*/
#define CC		(m6800->cc)
#define D		(m6800->d)
#define X		(m6800->x)
#define S		(m6800->s)
#define PC		(m6800->pc)
/*=====  =====*/
#define PENDING		(m6800->pending)
#define WAIT		(m6800->wait)
#define CYCLE		(m6800->cycle)
/*===== O֐ =====*/
#define READ(a)		    ((m6800->read )(m6800, (unsigned short)(a)))
#define WRITE(a, n)	do { (m6800->write)(m6800, (unsigned short)(a), (unsigned char)(n)); } while(0)

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	16rbgWX^̏/8rbgANZX
 *
 *	* G~[VzXg(S1C33,Pentium,etc)̏Ȃ̂ŁALittleEndianłB
 */
#define LO(rr)		(*(((unsigned char*)&(rr)) + 0))				/* LittleEndian */
#define HI(rr)		(*(((unsigned char*)&(rr)) + 1))				/* LittleEndian */
#define A		HI(D)
#define B		LO(D)

/*
 *	16rbgANZX
 *
 *	* G~[V^[Qbg(M6800)̏Ȃ̂ŁABigEndianłB
 */
#define READW(a)	(READ(a) << 8 | READ((a) + 1))					/* BigEndian */
#define WRITEW(a, nn)	do { WRITE(a, HI(nn)); WRITE((a) + 1, LO(nn)); } while(0)	/* BigEndian */

/*
 *	PUSH/PULL
 *
 *	* G~[V^[Qbg(M6800)̏Ȃ̂ŁABigEndianłB
 */
#define PUSH(r)		do { WRITE(S, (r)); S--; } while(0)
#define PULL(r)		do { S++; (r) = READ(S); } while(0)
#define PUSHW(rr)	do { PUSH(LO(rr)); PUSH(HI(rr)); } while(0)			/* BigEndian */
#define PULLW(rr)	do { PULL(HI(rr)); PULL(LO(rr)); } while(0)			/* BigEndian */

/*
 *	CXgNVtFb`/s
 */
#define FETCH(n)	do {		\
	(n) = READ(PC++);		\
	M6800TRACE("%02x ", (n));	\
} while(0)
#define FETCHW(nn)	do {		\
	int hi, lo;			\
	FETCH(hi);			\
	FETCH(lo);			\
	(nn) = hi << 8 | lo;		\
} while(0)
#define EXEC()		do {					\
	M6800TRACE("[%s]", &m6800_op_name_table[op->name]);	\
	op->proc(m6800, code, arg);				\
	CYCLE -= op->cycle;					\
} while(0)

/****************************************************************************
 *
 ****************************************************************************/

/* N,ZZbgorZbgAVNAAȊO͕ێ܂B!!V͏ɃNA܂!! */
#define TEST(n)		do { CC = (CC & ~0xe) | ((( n) >>  4) & 8) | (!( n) << 2); } while(0)
#define TESTW(nn)	do { CC = (CC & ~0xe) | (((nn) >> 12) & 8) | (!(nn) << 2); } while(0)

#define ADD(a, b)	m6800_ADD(m6800, a, b)
int m6800_ADD(M6800* m6800, int a, int b);
#define ADC(a, b)	m6800_ADC(m6800, a, b)
int m6800_ADC(M6800* m6800, int a, int b);
#define SUB(a, b)	m6800_SUB(m6800, a, b)
int m6800_SUB(M6800* m6800, int a, int b);
#define SBC(a, b)	m6800_SBC(m6800, a, b)
int m6800_SBC(M6800* m6800, int a, int b);

#define ADDW(a, b)	m6800_ADDW(m6800, a, b)
int m6800_ADDW(M6800* m6800, int a, int b);
#define SUBW(a, b)	m6800_SUBW(m6800, a, b)
int m6800_SUBW(M6800* m6800, int a, int b);

#define AND(a, b)	m6800_AND(m6800, a, b)
int m6800_AND(M6800* m6800, int a, int b);
#define ORA(a, b)	m6800_ORA(m6800, a, b)
int m6800_ORA(M6800* m6800, int a, int b);
#define EOR(a, b)	m6800_EOR(m6800, a, b)
int m6800_EOR(M6800* m6800, int a, int b);

#define INC(a)		m6800_INC(m6800, a)
int m6800_INC(M6800* m6800, int a);
#define DEC(a)		m6800_DEC(m6800, a)
int m6800_DEC(M6800* m6800, int a);

#define COM(a)		m6800_COM(m6800, a)
int m6800_COM(M6800* m6800, int a);
#define NEG(a)		m6800_NEG(m6800, a)
int m6800_NEG(M6800* m6800, int a);
#define TST(a)		m6800_TST(m6800, a)
void m6800_TST(M6800* m6800, int a);

#define ROL(a)		m6800_ROL(m6800, a)
int m6800_ROL(M6800* m6800, int a);
#define ROR(a)		m6800_ROR(m6800, a)
int m6800_ROR(M6800* m6800, int a);
#define ASL(a)		m6800_ASL(m6800, a)
int m6800_ASL(M6800* m6800, int a);
#define ASR(a)		m6800_ASR(m6800, a)
int m6800_ASR(M6800* m6800, int a);
#define LSR(a)		m6800_LSR(m6800, a)
int m6800_LSR(M6800* m6800, int a);

#define ASLW(a)		m6800_ASLW(m6800, a)
int m6800_ASLW(M6800* m6800, int a);
#define LSRW(a)		m6800_LSRW(m6800, a)
int m6800_LSRW(M6800* m6800, int a);

#endif /*__CLIP_M68I_H__*/
