/*	
 *	cliplogb.c
 *
 *	Oobt@
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Mon Dec 16 17:34:52 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 *	* Wed Sep 17 00:00:00 JST 2014 Naoyuki Sawa
 *	- `֐Aďo񋟂悤ɂ܂B
 *	  ܂łrender_reduced_string()gĂ܂Aǂ݈Ղ̂߂render_string()ŃtHg2gƂłB
 *	  {ꃍO\ꍇ́A܂łǂrender_reduced_string()gl̂ŁAςɂ̂ǂƎv܂B
 *	  ȏ̗RɂA`֐ďo񋟂悤ɂ܂B
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

//{{2014/09/17ύX:`֐Aďo񋟂悤ɂ܂B
//ST_LogBuf* LogBuf_Init(int LineNum) {
//2014/09/17ύX:`֐Aďo񋟂悤ɂ܂B
ST_LogBuf* LogBuf_Init(int LineNum, int (*fnDraw)(int x, int y, const char* Str)) {
//}}2014/09/17ύX:`֐Aďo񋟂悤ɂ܂B
	ST_LogBuf* Me;
	/* s1sȏłȂĂ͂Ȃ܂B */
	if(LineNum < 1) { DIE(); }
	/* ST_LogBuf\̂ƍsobt@܂Ƃ߂Ċmۂ܂B */
	Me = calloc(sizeof(ST_LogBuf) + (sizeof(char*) * LineNum), 1);
	if(!Me) { DIE(); }
//{{2014/09/17ǉ:`֐Aďo񋟂悤ɂ܂B
	/* `֐i[܂B */
	Me->fnDraw = fnDraw;
//}}2014/09/17ǉ:`֐Aďo񋟂悤ɂ܂B
	/* ős(=s-1)i[܂B */
	Me->LineMax = LineNum - 1;
	/* ST_LogBuf\̂Ԃ܂B */
	return Me;
}

/****************************************************************************
 *	
 ****************************************************************************/

void LogBuf_Free(ST_LogBuf* Me) {
	/* sobt@Ɋi[J܂B */
	LogBuf_Clear(Me);
	/* ST_LogBuf\̂ƍsobt@܂Ƃ߂ĊJ܂B */
	free(Me);
}

/****************************************************************************
 *	
 ****************************************************************************/

void LogBuf_Clear(ST_LogBuf* Me) {
	int i;
	/* sʒuZbg܂B */
	Me->LinePos = 0;
	/* sobt@Ɋi[J܂B */
	for(i = 0; i <= Me->LineMax; i++) {
		free(Me->LineMem[i]); /* (free(NULL)) */
		     Me->LineMem[i] = NULL;
	}
}
/****************************************************************************
 *	
 ****************************************************************************/

void LogBuf_Print(ST_LogBuf* Me, const char* Str) {
	int Len;
	char* Mem;
	do {
		/* I[͉s̒O܂ł̒̕߂܂B */
		Len = strcspn(Str, "\n");
		/* ʂ𑝂₷߁As͔΂Ƃɂ܂B */
		if(!Len) { continue; }
		/* I[͉s̒O܂ł̕Rs[܂B */
		Mem = calloc(Len + 1, 1);
		if(!Mem) { DIE(); }
		memcpy(Mem, Str, Len);
		/* |C^I[͉s̈ʒu֐i߂܂B */
		Str += Len;
		/* ̍s̕J܂B(free(NULL)) */
		free(Me->LineMem[Me->LinePos]);
		/* Vs̕i[܂B */
		Me->LineMem[Me->LinePos] = Mem;
		/* sʒui߁Aősz擪ɖ߂܂B */
		if(++Me->LinePos > Me->LineMax) { Me->LinePos = 0; }
		/* I[ȂΏIAsȂΏp܂B */
	} while(*Str++);
}

/****************************************************************************
 *	
 ****************************************************************************/

/* WJobt@Ƃ_def_vbuff[]𗘗pĂ܂B */
void LogBuf_Printf(ST_LogBuf* Me, const char* Fmt, ...) {
	va_list ap;
	va_start(ap, Fmt);
	vsprintf(_def_vbuff, Fmt, ap);
	va_end(ap);
	LogBuf_Print(Me, _def_vbuff);
}

/****************************************************************************
 *	
 ****************************************************************************/

//{{2014/09/17ύX:`֐Aďo񋟂悤ɂ܂B
//void LogBuf_Draw(ST_LogBuf* Me, RENDER* r, int x, int y, int c) {
//2014/09/17ύX:`֐Aďo񋟂悤ɂ܂B
void LogBuf_Draw(ST_LogBuf* Me, int x, int y) {
//}}2014/09/17ύX:`֐Aďo񋟂悤ɂ܂B
	char* Str;
	/* ŌɊi[sʒu̎̍sc */
	int i = Me->LinePos;
	for(;;) {
		/* i[łȂ΁A`悵܂B */
		Str = Me->LineMem[i++];
		if(Str) {
//{{2014/09/17ύX:`֐Aďo񋟂悤ɂ܂B
//			render_reduced_string(r, x, y, Str, c);
//			y += 10; /* `悵ꍇ̂ݕ`ʒui߂Bŏ̈ʂl߂ŕ`悷邽߂ɁAi[ȂΕ`ʒui߂ȂB */
//2014/09/17ύX:`֐Aďo񋟂悤ɂ܂B
			y += (*Me->fnDraw)(x, y, Str); /* `悵ꍇ̂ݕ`ʒui߂Bŏ̈ʂl߂ŕ`悷邽߂ɁAi[ȂΕ`ʒui߂ȂB */
//}}2014/09/17ύX:`֐Aďo񋟂悤ɂ܂B
		}
		/* bvAEhB */
		if(i >  Me->LineMax) { i = 0; }
		/* ʕ`抮B */
		if(i == Me->LinePos) { break; }
	}
}

