/*	
 *	clipdmc.h
 *
 *	P/ECE DMG-CPU (Sharp LR35902) Emulator ()
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sun Feb 13 03:10:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_DMC_H__
#define __CLIP_DMC_H__

/****************************************************************************
 *
 ****************************************************************************/

/* spDMG-CPU\̂łB */
typedef struct _DMGCPU {
	unsigned short cz;		/* + 0,2: -------C zzzzzzzz (C=F(C),z=!F(Z)) */
	unsigned char  nh;		/* + 2,1:          --NH---- (N=F(N),H= F(H)) */
	unsigned char   a;		/* + 3,1: A  */
	unsigned short bc;		/* + 4,2: BC */
	unsigned short de;		/* + 6,2: DE */
	unsigned short hl;		/* + 8,2: HL */
	unsigned short sp;		/* +10,2: SP */
	unsigned short pc;		/* +12,2: PC */
	unsigned char flags;		/* +14,1: -----SHI (S=STOP,H=HALT,I=IME) */
	//				/* +15,1: (pfBO) */
	int cycle;			/* +16,4: csTCN */
	void* read;			/* +20,4: ǂݏo[` */
	void* write;			/* +24,4: ݃[` */
} DMGCPU;				/* =28 */

/* DMGCPU.flags */
#define DMGCPU_IME				(1<<0)
#define DMGCPU_HALT				(1<<1)
#define DMGCPU_STOP				(1<<2)

/* $FF0F(IF)A$FFFF(IE) */
#define DMGCPU_V_BLANK				(1<<0)	/* RST $40 */
#define DMGCPU_LCDC_STATUS			(1<<1)	/* RST $48 */
#define DMGCPU_TIMER_OVERFLOW			(1<<2)	/* RST $50 */
#define DMGCPU_SERIAL_TRANSFER_COMPLETION	(1<<3)	/* RST $58 */
#define DMGCPU_HIGH_TO_LOW_OF_P10_P13		(1<<4)	/* RST $60 */

/* WX^ݒEQƗp̍\̂łB */
typedef struct _DMGREG {
	unsigned short af;		/* + 0,2 */
	unsigned short bc;		/* + 2,2 */
	unsigned short de;		/* + 4,2 */
	unsigned short hl;		/* + 6,2 */
	unsigned short sp;		/* + 8,2 */
	unsigned short pc;		/* +10,2 */
} DMGREG;				/* =12 */

extern DMGCPU dmgcpu;			/* RAMɔzu */
extern unsigned char dmgmem[0x10000];	/*    SRAMɔzu */

/****************************************************************************
 *	֐
 ****************************************************************************/

int/*%data*/ dmgmem_read(/*%addr*/);	/* Pȃǂݏo[` */
void  dmgmem_write(/*%addr,%data*/);	/* Pȃ݃[` */

/****************************************************************************
 *
 ****************************************************************************/

/* CPUZbg܂B
 * [in]
 *	read		Read O֐ (NULL)
 *	write		WriteO֐ (NULL)
 *	gb_ipl		0ȊOw肷ƁAGameBoy̋^IPLvOs܂B
 *			GameBoy̋^IPLsꍇAJnAhX$0100ƂȂ܂B
 *			0w肵ꍇ́AGameBoy̋^IPLs킸A$0000Jn܂B
 * [note]
 *	* ReadO֐NULLw肷ƁAdmgmem_read()ݒ肳܂B
 *	  dmgmem_read()́APdmgmem[]ǂݏõRead֐łB
 *	* WriteO֐NULLw肷ƁAdmgmem_write()ݒ肳܂B
 *	  dmgmem_write()́APdmgmem[]֏ނ̃Write֐łB
 *	* O`̃Read/Write֐̍́A̕QƂĂB
 */
void dmgcpu_reset(void* read, void* write, int gb_ipl);

/* CPUs܂B
 * [in]
 *	cycle		sTCNB
 */
void dmgcpu_run(int cycle);

/* ۗĂ銄荞ݗv𒲂ׁAs\ȂΎs܂B
 * [note]
 *	- AvP[VvOIɊ荞݂v@́A
 *	  $FF0F(IE)̓K؂ȃrbgSetƁÅ֐ĂяoĂB
 *	  <>
 *		dmgmem[0xff0f] |= DMGCPU_V_BLANK;
 *		dmgcpu_check_pending();
 *
 *	- $FF0F(IF)A$FFFF(IE)̕ύXɁÅ֐Ăяo悤A
 *	  O`Write֐ĂB
 *	  <>
 *		void my_write(int addr, int data) {
 *			switch(addr) {
 *			case 0xff0f: // (IF)
 *			case 0xffff: // (IE)
 *				if(dmgmem[addr] != data) {	//̍s͖Ă\܂
 *					dmgmem[addr] = data;
 *					dmgcpu_check_pending();
 *				}				//̍s͖Ă\܂
 *				return;
 *			}
 *			dmgmem_write(addr, data);
 *		}
 */
void dmgcpu_check_pending();

/* DMG-CPŨWX^Zbg\ɂāAeWX^̒lݒ肵܂B
 * [in]
 *	reg		ݒ肷郌WX^l̍\́B
 */
void dmgreg_put(const DMGREG* reg);

/* DMG-CPŨWX^Zbg\ɂāAeWX^̒l擾܂B
 * [in]
 *	reg		WX^l擾\́B
 */
void dmgreg_get(DMGREG* reg);

/****************************************************************************
 *	O`̃Read/Write֐̍ɂ
 ****************************************************************************/
#if 0

O`̃Read/Write֐̍́AMOS6502G~[V()Ɗ{IɓłB
clip65c.h́uO`̃Read/Write֐̍ɂāvQƂĂB
ȉAĂяoKƁA܂B

/*--------------------------------------------------------------------------*/

O`̃Read֐̌ĂяoḰA̒ʂłB

	[in]
		%r0		ǂݏoAhX ($0000..$FFFF)
	[out]
		%r1		ǂݏof[^ ($00-$FF)
				dv
				$00-$FFȊO̒lԂĂ͂܂!!
				Ƃ΁A%r1=$FF Ԃ $r1=-1($FFFFFFFF)ԂƁA듮̌ɂȂ܂B
				̂߂ɁAWrite֐Ԃꂽl𕄍1byteɃ}XNÂ܂܎gĂ邩łB
	[use]
		%r0		js	nꂽAhXl̂܂܈ێĂB
		%r1		߂l		߂li[܂ł́A[NWX^ƂĎgp\łB
		%r2		js
		%r3		js
		%r4		js
		%r5		js
		%r6		js
		%r7		js
		%r8		js	S1C33K̃x[XWX^łB
		%r9		j		[NWX^ƂĎgp\łBext33̃XNb`WX^ł邱ƂɒӂĂB
		%r10		js
		%r11		js
		%r12		j		[NWX^ƂĎgp\łB
		%r13		j		[NWX^ƂĎgp\łB
		%r14		j		[NWX^ƂĎgp\łB
		%r15		j		[NWX^ƂĎgp\łB

/*--------------------------------------------------------------------------*/

O`̃Write֐̌ĂяoḰA̒ʂłB

	[in]
		%r0		ރAhX ($0000..$FFFF)
		%r1		ރf[^   ($00-$FF)
	[use]
		%r0		js	nꂽAhXl̂܂܈ێĂB
		%r1		js	nꂽf[^l̂܂܈ێĂB
		%r2		js
		%r3		js
		%r4		js
		%r5		js
		%r6		js
		%r7		js
		%r8		js	S1C33K̃x[XWX^łB
		%r9		j		[NWX^ƂĎgp\łBext33̃XNb`WX^ł邱ƂɒӂĂB
		%r10		js
		%r11		js
		%r12		j		[NWX^ƂĎgp\łB
		%r13		j		[NWX^ƂĎgp\łB
		%r14		j		[NWX^ƂĎgp\łB
		%r15		j		[NWX^ƂĎgp\łB

/*--------------------------------------------------------------------------*/

asm("
	.code
	.align	1
	.global	my_read
my_read:
	xcmp	%r0, 0xff00		; if(addr < 0xff00)
	xjrlt	dmgmem_read		;   read RAM
	;-----------------------------------------------------------------------܂ł́A%r1,9,12,13,14,15ȊOjs
	xcall	dmgcpu_leave		; sReLXg𔲂܂B
	xcall.d	my_read_io		; read I/O
	ld.w	%r12, %r0		; %r12(C̑1) <- %addr *delay*
	xjp.d	dmgcpu_enter		; sReLXg֓܂B
	ld.w	%r1, %r10		; %r10(C̖߂l ) -> %data *delay*
");

int
my_read_io(int addr)
{
	int data;
	if(addr >= 0xff10 && addr <= 0xff26) {
		data = sound_read(addr);
	} else if(addr >= 0xff40 && addr <= 0xff4b) {
		data = video_read(addr);
	} else {
		/* I/Oڑ̈Ȃ̂ŁA$FFԂƂɂ܂B
		 * "data = -1" ƂĂ͂܂!! ߂l͕K$00..$FFłKv܂B
		 * (߂lꎟi[邽߂dataϐAunsigned charɂĂ̂ł)
		 */
		data = 0xff;
	}
	return data;
}

/*--------------------------------------------------------------------------*/

asm("
	.code
	.align	1
	.global	my_write
my_write:
	xcmp	%r0, 0xff00		; if(addr < 0xff00)
	xjrlt	dmgmem_write		;   write RAM
	;-----------------------------------------------------------------------܂ł́A%r9,12,13,14,15ȊOjs
	xcall.d	dmgcpu_leave		; sReLXg𔲂܂B
	ld.w	%r12, %r0		; %r12(C̑1) <- %addr *delay*
	xcall.d	famicom_write_io	; write I/O
	ld.w	%r13, %r1		; %r13(C̑2) <- %data *delay*
	xjp	dmgcpu_enter		; sReLXg֓܂B
");

void
my_write_io(int addr, int data)
{
	if(addr >= 0xff10 && addr <= 0xff26) {
		sound_write();
	} else if(addr >= 0xff40 && addr <= 0xff4b) {
		video_write();
	} else {
		/** no job **/
	}
}

/*--------------------------------------------------------------------------*/

ȏ̂悤ɒ`Read/Write֐ACPUZbgɎw肵ĂB

	dmgcpu_reset(my_read, my_write, 0or1);

#endif
/****************************************************************************
 *	
 ****************************************************************************/

#endif /*__CLIP_DMC_H__*/
