/*	
 *	clipbuf.c
 *
 *	[eBeBFOobt@
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Tue Jan 06 21:26:41 JST 2015 Naoyuki Sawa
 *	- VK쐬B
 *	- u[eBeBFOobt@vAclipmisc.*clipbuf.*֕܂B
 *	  gppxႢ̂ŁAʂɃNėeʂ鎖h߂łB
 */
#include "clip.h"

/*****************************************************************************
 *	[eBeBFOobt@
 *****************************************************************************/

BUFFER*
create_buffer(int capacity)
{
	BUFFER* buffer;

	if(capacity < 0) {
		DIE();
	}

	/* wb_ƃXg[W̃mۂ܂B */
	buffer = malloc(sizeof(BUFFER) + capacity);
	if(!buffer) {
		DIE(); /* s */
	}

	/* wb_܂B */
	buffer->capacity = capacity;
	buffer->size = 0;

	return buffer;
}

void
delete_buffer(BUFFER* buffer)
{
	/* wb_ƃXg[W̃J܂B */
	free(buffer);
}

void
clear_buffer(BUFFER* buffer)
{
	buffer->size = 0;
}

int
write_buffer(BUFFER* buffer, const void* data/*[length]*/, int length)
{
	unsigned char* storage = (unsigned char*)(buffer + 1);

	if(length < 0) {
		DIE();
	}

	/* ރf[^AXg[W̋󂫗eʂ֐؂l߂܂B */
	if(length > (buffer->capacity - buffer->size)) {
		length = (buffer->capacity - buffer->size);
	}

	/* Xg[WցAf[^݂܂B */
	memcpy(storage + buffer->size, data, length);
	buffer->size += length;

	/* ۂɏ񂾃f[^Ԃ܂B */
	return length;
}

int
read_buffer(BUFFER* buffer, void* data/*[maxlength]*/, int maxlength)
{
	unsigned char* storage = (unsigned char*)(buffer + 1);
	int length;

	if(maxlength < 0) {
		DIE();
	}

	/* ǂݏof[^Aw肳ꂽ̈TCY֐؂l߂܂B */
	length = maxlength < buffer->size
	       ? maxlength : buffer->size;

	/* Xg[W擪̃f[^Aw肳ꂽ̈ɃRs[܂B
	 * Adata=NULLȂ΁Aǂݏof[^j܂B
	 */
	if(data) {
		memcpy(data, storage, length);
	}

	/* Xg[W擪̃f[^폜A̕AXg[Wl߂܂B */
	buffer->size -= length;
	memmove(storage, storage + length, buffer->size);

	/* ۂɓǂݏof[^Ԃ܂B */
	return length;
}

const void*
peek_buffer(BUFFER* buffer, int* length)
{
	/* f[^i[܂B */
	if(length) {
		*length = buffer->size;
	}

	/* Xg[W̐擪AhXԂ܂B */
	return buffer + 1;
}

int
buffer_space(BUFFER* buffer)
{
	/* ݉\ȍőf[^́AXg[W̋󂫗eʂłB */
	return buffer->capacity - buffer->size;
}
