/*
 *	game.c
 *
 *	ςÂǂ
 *
 *	* Wed Jan 18 21:03:09 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
#define FIELD_COLS		6			//
#define FIELD_ROWS		(8+1)			//ős		(+1)̍s͈ň񖄂܂ԂŃ^CAEgŒuꂽꍇ̂ݕKvɂȂB
/*--------------------------------------------------------------------------*/
#define LOW_WARN_PUT_CNT	5			//񋛂uƈx邩?		1ȏŒ
#define LOW_TIDE_PUT_CNT	(LOW_WARN_PUT_CNT+2)	//񋛂uƈ邩?		(LOW_WARN_PUT_CNT+1)ȏŒ
/*--------------------------------------------------------------------------*/
#define CELL_TYPE_FISH1		1			//1
#define CELL_TYPE_FISH2		2			//2
#define CELL_TYPE_FISH3		3			//3
#define CELL_TYPE_FISH4		4			//4
#define CELL_TYPE_FISH5		5			//5
#define CELL_TYPE_FISH6		6			//6
#define CELL_TYPE_BUBBLE	7			//A
/*--------------------------------------------------------------------------*/
#define BOAT_STAT_READY		0			//JnO		󖳂c@ł͊JnOL肾A̕R낤B
#define BOAT_STAT_NORMAL	1			//ʏ풆		L	ړ,,u
#define BOAT_STAT_CHANGE	3			//		L	ړ,([VLZ),u([VLZ)
#define BOAT_STAT_PUT		4			//u		󖳂c@ł͒uL肾A̕R낤Bނ蒆lłB
#define BOAT_STAT_GET		5			//ނ蒆		󖳂
#define BOAT_STAT_NEXT		6			//̋		L	ړ,([VLZ),u([VLZ)
#define BOAT_STAT_WIN		7			//		󖳂
#define BOAT_STAT_LOSE		8			//sk		󖳂
/*--------------------------------------------------------------------------*/
#define FISHOBJ_STAT_FLASH 	0			//tbV
#define FISHOBJ_STAT_VERT	1			//㏸
#define FISHOBJ_STAT_HORZ	2			//ړ
#define FISHOBJ_STAT_WAIT	3			//ʉҋ@
#define FISHOBJ_STAT_JUMP	4			//Wv
/*--------------------------------------------------------------------------*/
//#define MAX_FISHOBJ		(FIELD_COLS*FIELD_ROWS)	//_͂c
//#define MAX_BUBBLEOBJ		(FIELD_COLS*FIELD_ROWS)	//
#define MAX_FISHOBJ		32			//ꂮ炢ŏ[낤BoȂ̂Œ߂琶ȂĂ͖薳B
#define MAX_BUBBLEOBJ		16			//
#define MAX_SCOREOBJ		3			//1łvƎvAꉞ]T3ɂB
/*--------------------------------------------------------------------------*/
#define CHANGE_TIME		5			//		
#define PUT_TIME		5			//u		
#define NEXT_TIME		CHANGE_TIME		//̋̏o	BKCHANGE_TIMEƓłȂĂ\܂B
#define HURRY_TIME		SEC(5.0)		//}Jn		
#define FORCE_TIME		(HURRY_TIME+SEC(3.0))	//u
/*--------------------------------------------------------------------------*/
#define FISHOBJ_FLASH_TIME	SEC(0.3)		//ނグIuWFNgtbV		
#define FISHOBJ_MOVE_TIME	2			//ނグIuWFNgړ		
#define FISHOBJ_JUMP_TIME	SEC(1.0)		//ނグIuWFNgWv		
#define FISHOBJ_JUMP_TIME_CUT	SEC(0.75)		//ނグIuWFNgWv؂グ	
#define FISHOBJ_JUMP_HEIGHT	32			//ނグIuWFNgWv
/*--------------------------------------------------------------------------*/
#define INFO_STAT_SEAL		1			//AUVov
#define INFO_STAT_SHARK		2			//Tov
/*--------------------------------------------------------------------------*/
#define SEAL_STAT_HIDE		0			//\
#define SEAL_STAT_APPEAR	1			//o
#define SEAL_STAT_SHOW		2			//\
#define SEAL_STAT_DISAPPEAR	3			//
/*--------------------------------------------------------------------------*/
#define SEAL_APPEAR_TIME	SEC(1.0)		//AUVo		
#define SEAL_DISAPPEAR_TIME	SEC(1.0)		//AUVޏꎞ		
/*--------------------------------------------------------------------------*/
#define SHARK_STAT_HIDE		0			//\
#define SHARK_STAT_APPEAR	1			//o
#define SHARK_STAT_SHOW		2			//\
#define SHARK_STAT_DISAPPEAR	3			//
/*--------------------------------------------------------------------------*/
#define SHARK_APPEAR_TIME	SEC(1.0)		//AUVo		
#define SHARK_DISAPPEAR_TIME	SEC(1.0)		//AUVޏꎞ		
#define SCOREOBJ_TIME		SEC(1.0)		//XRAIuWFNg\	
/****************************************************************************
 *	
 ****************************************************************************/
typedef struct _ST_Cell {
	uint8_t			type;			//0,,CELL_TYPE_*
} ST_Cell;
/*--------------------------------------------------------------------------*/
typedef struct _ST_FishObj {
	uint8_t			type;			//0,,CELL_TYPE_FISH*
	uint8_t			stat;			//FISHOBJ_STAT_*
	uint8_t			col, row;
	uint8_t			anm;
} ST_FishObj;
/*--------------------------------------------------------------------------*/
typedef struct _ST_BubbleObj {
	uint8_t			type;			//0,,CELL_TYPE_BUBBLE
//sv	uint8_t			stat;			//BUBBLEOBJ_STAT_*
	uint8_t			col, row;
	uint8_t			anm;
} ST_BubbleObj;
/*--------------------------------------------------------------------------*/
typedef struct _ST_ScoreObj {
	uint16_t		score;			//0ȊOȂ΃ANeBu
	uint8_t			col;			//\	XRAZuԂŔL̗̕ZbgB
	uint8_t			anm;
} ST_ScoreObj;
/*--------------------------------------------------------------------------*/
typedef struct _ST_Game {
	uint32_t		score;			//XRA
	uint8_t			stage;			//Xe[W
	//
	uint8_t			lowCnt;			//[s]		Xe[WJn0B((FIELD_ROWS-1)-lowCnt)̍sɋ,,A݂ĂAQ[I[o[ɂȂB
	uint8_t			lowOfs;			//ItZbg[sNZ]	ʏ펞0BAlowOfs1(H__CELL+H__CELL__GAP-1)ɕωčsAlowOfs0ɖ߂ƓlowCnt+1B
	uint8_t			putCnt;			//u[]		0ɖ߂B
	uint8_t			hurryCnt;		//}JE^			u0ɖ߂B
	//
	uint8_t			boatStat;		//{[g̏			BOAT_STAT_*
	uint8_t			boatCol;		//{[g̈ʒu			0`FIELD_COLS-1		lĂʒuŎB]āȀꍇ0`FIELD_COLS-2͈̔́CȄꍇ1`FIELD_COLS-1͈̔͂łB
	uint8_t			boatDir;		//{[ǧ			0=,1=E
	uint8_t			boatOfs;		//{[g̈ړItZbg	{[gړ鎞́AboatColωāAboatOfs(H__CELL+H__CELL__GAP-1)0ɕωčsBlowCnt,lowOfsƂ͕ωႤɒӂB	ςuԂ́AboatColboatDirωāAboatOfs=0ɂBړAj[V͍sȂB
	uint8_t			boatAnm;		//ėpAj[VJE^	u,,̋,̃Aj[VJE^ƂĎgpB
	uint8_t			TBL_Next[2];		//[0]=Ă鋛,[1]=̋	CELL_TYPE_FISH*
	//
	uint8_t			infoStat;		//\̏		INFO_STAT_*		AUVƃT̑IsBAUVƃT͂čsBꎞIɓɏo鎖L蓾B({ł)
	//
	uint8_t			sealStat;		//AUV̏		SEAL_STAT_*
	uint8_t			sealAnm;		//ėpAj[VJE^
	//
	uint8_t			sharkStat;		//T̏			SHARK_STAT_*
	uint8_t			sharkAnm;		//ėpAj[VJE^
	//
	uint8_t			cellAnm;		//ėpAj[VJE^	̃Aj[VJE^ƂĎgpB
	ST_Cell			TBL_Cell[FIELD_ROWS][FIELD_COLS];	//Zz
	//
	ST_FishObj		TBL_FishObj[MAX_FISHOBJ];	//ނグIuWFNg
	ST_BubbleObj		TBL_BubbleObj[MAX_BUBBLEOBJ];	//AŃIuWFNg
	ST_ScoreObj		TBL_ScoreObj[MAX_SCOREOBJ];	//XRAIuWFNg
} ST_Game;
ST_Game stGame;		//B̃CX^X
/****************************************************************************
 *	
 ****************************************************************************/
//̗ɒuĂAZ̐߂B
int get_height(int col) {
	int row;
	for(row = 0; row < FIELD_ROWS; row++) {
		ST_Cell* pCell = &stGame.TBL_Cell[row][col];
		if(!pCell->type) { break; }
	}
	return row;
}
/*--------------------------------------------------------------------------*/
//̗ɑ΂āAt̔sB				A{^ꂽ̒uJnɗp܂B
int is_full_col(int col) {
	return get_height(col) >= ((FIELD_ROWS - 1) - stGame.lowCnt);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//tB[hŜɑ΂āAtɂȂĂ񂪗L邩̔sB	x\(T)̕\Jnɗp܂B
int is_full() {
	int col;
	for(col = 0; col < FIELD_COLS; col++) {
		if(is_full_col(col)) { return 1; }
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
//Q[I[o[
int is_gameover() {
	int col;
	for(col = 0; col < FIELD_COLS; col++) {
		if(get_height(col) >= (FIELD_ROWS - stGame.lowCnt)) { return 1; }
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
//NA
int is_clear() {
	int col;
	for(col = 0; col < FIELD_COLS; col++) {
		if(get_height(col)) { return 0; }
	}
	return 1;
}
/****************************************************************************
 *	
 ****************************************************************************/
//̋𒊑IB
int get_next() {
	int col, row, i, sum, val, cnt[6/*0=CELL_TYPE_FISH1`5=CELL_TYPE_FISH6*/];
	//tB[hɗLe̐𐔂B
	memset(cnt, 0, sizeof cnt);
	sum = 0;
	for(row = 0; row < FIELD_ROWS; row++) {
		for(col = 0; col < FIELD_COLS; col++) {
			ST_Cell* pCell = &stGame.TBL_Cell[row][col];
			if(pCell->type) {
				switch(pCell->type) {
				default:DIE();
				case CELL_TYPE_FISH1:
				case CELL_TYPE_FISH2:
				case CELL_TYPE_FISH3:
				case CELL_TYPE_FISH4:
				case CELL_TYPE_FISH5:
				case CELL_TYPE_FISH6:
					i = pCell->type - CELL_TYPE_FISH1;
					if((unsigned)i >= ARRAY_SIZE(cnt)) { DIE(); }
				    #if 0
					//̐ɉďd݂tꍇ	ۂɎĂ݂ł͊ȒP߂̂Łc
					cnt[i]++;
					sum++;
				    #else
					//݂鋛͋ϓɒIꍇ	̕ǂƎv܂B
					if(!cnt[i]) {
						cnt[i]++;
						sum++;
					}
				    #endif
					break;
				case CELL_TYPE_BUBBLE:
					/** no job **/
					break;
				}
			}
		}
	}
	if(!sum) { DIE(); }	//tB[hɋCȂԂŁA֐ĂяoĂ͂ȂB
	//̋𒊑IB
	val = RND32_RANGE(seed, 0, sum);
	for(i = 0; i < ARRAY_SIZE(cnt); i++) {
		val -= cnt[i];
		if(val < 0) { return CELL_TYPE_FISH1 + i; }
	}
	DIE();	//oO
}
/****************************************************************************
 *	
 ****************************************************************************/
//ނグIuWFNg𐶐B
void gen_fish_obj(int col, int row, int type) {
	int i;
	for(i = 0; i < MAX_FISHOBJ; i++) {
		ST_FishObj* pFishObj = &stGame.TBL_FishObj[i];
		if(!pFishObj->type) {
			memset(pFishObj, 0, sizeof(ST_FishObj));
			pFishObj->type = type;
			pFishObj->col = col;
			pFishObj->row = row;
			return;	//܂
		}
	}
}
/*--------------------------------------------------------------------------*/
//AŃIuWFNg𐶐B
void gen_bubble_obj(int col, int row) {
	int i;
	for(i = 0; i < MAX_BUBBLEOBJ; i++) {
		ST_BubbleObj* pBubbleObj = &stGame.TBL_BubbleObj[i];
		if(!pBubbleObj->type) {
			memset(pBubbleObj, 0, sizeof(ST_BubbleObj));
			pBubbleObj->type = CELL_TYPE_BUBBLE;
			pBubbleObj->col = col;
			pBubbleObj->row = row;
			return;	//܂
		}
	}
}
/*--------------------------------------------------------------------------*/
//XRAIuWFNg𐶐B
void gen_score_obj(int col, int score) {
	int i;
	for(i = 0; i < MAX_SCOREOBJ; i++) {
		ST_ScoreObj* pScoreObj = &stGame.TBL_ScoreObj[i];
		if(!pScoreObj->score) {
			memset(pScoreObj, 0, sizeof(ST_ScoreObj));
			pScoreObj->score = score;
			pScoreObj->col = col;
			return;	//܂
		}
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
//ނグIuWFNgcĂ邩𒲂ׂB
int is_fish_obj_exists() {
	int i;
	for(i = 0; i < MAX_FISHOBJ; i++) {
		ST_FishObj* pFishObj = &stGame.TBL_FishObj[i];
	   #if 0
		if(pFishObj->type) { return 1; }
	   #else
		if(pFishObj->type && !((pFishObj->stat == FISHOBJ_STAT_JUMP) && pFishObj->anm >= (FISHOBJ_JUMP_TIME / 2/**/))) { return 1; }	//e|ǂ邽߂ɁAWvz玟̏̃Aj[VƐisis悤ɂB
	   #endif
	}
	return 0;
}
/****************************************************************************
 *	
 ****************************************************************************/
static int do_erase_fish_subr(int col, int row, int type, unsigned char mark[FIELD_ROWS][FIELD_COLS]) {	//X^bNʂ͖32ȉBőɍċAĂ(6*9)*322KBȉōςނ͂B
	int cnt = 0;
	//tB[hŁÄʒuς݂łȂ΁c
	if(((unsigned)col < FIELD_COLS) && ((unsigned)row < FIELD_ROWS) && !mark[row][col]) {
		ST_Cell* pCell = &stGame.TBL_Cell[row][col];
		//ނȂ΁c
		if(pCell->type == type) {
			//𑝂₷B
			cnt++;
			//̈ʒuς݂ł鎖}[NB
			mark[row][col] = 1;
			//ׂ̃ZɍċAB
			cnt += do_erase_fish_subr(col - 1, row, type, mark);
			cnt += do_erase_fish_subr(col + 1, row, type, mark);
			cnt += do_erase_fish_subr(col, row - 1, type, mark);
			cnt += do_erase_fish_subr(col, row + 1, type, mark);
		}
	}
	return cnt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int do_erase_fish() {
	int i, col, nFish = 0;
	//ŏi̊eZɂāc	ނグIuWFNg{[gɋ߂񂩂琶悤ɁA{[gɋ߂񂩂珇ɏB
	static_assert(FIELD_COLS == 6, "FIELD_COLSzlƈقȂ܂B");
	static const char TBL_ColOfs[] = {0,-1,1,-2,2,-3,3,-4,4,-5,5};
	for(i = 0; i < ARRAY_SIZE(TBL_ColOfs); i++) {
		col = stGame.boatCol + TBL_ColOfs[i];
		if((unsigned)col < FIELD_COLS) {
			ST_Cell* pCell = &stGame.TBL_Cell[0/*row*/][col];
			//Ȃ΁c
			if((pCell->type >= CELL_TYPE_FISH1) &&
			   (pCell->type <= CELL_TYPE_FISH6)) {
				//אڐ3ȏȂ΁c
				unsigned char mark[FIELD_ROWS][FIELD_COLS];
				memset(mark, 0, sizeof mark);
				if(do_erase_fish_subr(col, 0/*row*/, pCell->type, mark) >= 3) {
					int col2, row2;
					//}[Nꂽeʒuɂāc
					for(row2 = 0; row2 < FIELD_ROWS; row2++) {
						for(col2 = 0; col2 < FIELD_COLS; col2++) {
							if(mark[row2][col2]) {
								ST_Cell* pCell2 = &stGame.TBL_Cell[row2][col2];
								//ނグIuWFNg𐶐B
								gen_fish_obj(col2, row2, pCell2->type);
								//ZɂB
								memset(pCell2, 0, sizeof(ST_Cell));
								//ނグZB
								nFish++;
							}
						}
					}
				}
			}
		}
	}
	//ނグԂB
	return nFish;
}
/*--------------------------------------------------------------------------*/
int do_erase_bubble() {
	int col, nBubble = 0;
	//ŏi̊eZɂāc
	for(col = 0; col < FIELD_COLS; col++) {
		ST_Cell* pCell = &stGame.TBL_Cell[0/*row*/][col];
		//AȂ΁c
		if(pCell->type == CELL_TYPE_BUBBLE) {
			//AŃIuWFNg𐶐B
			gen_bubble_obj(col, 0/*row*/);
			//ZɂB
			memset(pCell, 0, sizeof(ST_Cell));
			//AŐZB
			nBubble++;
		}
	}
	//AŐԂB
	return nBubble;
}
/****************************************************************************
 *	
 ****************************************************************************/
int do_raise(int testOnly) {
	int col, row, bRaise = 0;
	for(row = 1/*iڂ*/; row < FIELD_ROWS; row++) {
		for(col = 0; col < FIELD_COLS; col++) {
			ST_Cell* pCell1 = &stGame.TBL_Cell[row][col];
			//̃ZłȂ΁c
			if(pCell1->type) {
				ST_Cell* pCell2 = &stGame.TBL_Cell[row - 1][col];
				//̃ZȂ΁c
				if(!pCell2->type) {
					//eXĝ݂Ȃ΂܂ŁB
					if(testOnly) { return 1; }
					//̃Z֕シB
					*pCell2 = *pCell1;
					memset(pCell1, 0, sizeof(ST_Cell));
					//オ}[NB
					bRaise = 1;
				}
			}
		}
	}
	//オ1CオȂ0ԂB
	return bRaise;
}
/****************************************************************************
 *	
 ****************************************************************************/
//̏ԂQƂāÃ݂tB[hItZbg߂B
int field_offset() {
	return (H__CELL + H__CELL__GAP) * stGame.lowCnt + stGame.lowOfs;
}
/****************************************************************************
 *	
 ****************************************************************************/
void field_exec() {
	int i;
	//ނグIuWFNg
	for(i = 0; i < MAX_FISHOBJ; i++) {
		ST_FishObj* pFishObj = &stGame.TBL_FishObj[i];
		if(pFishObj->type) {
			switch(pFishObj->stat) {
			default:DIE();
			case FISHOBJ_STAT_FLASH:	//tbV
				if(++pFishObj->anm >= FISHOBJ_FLASH_TIME) {
					pFishObj->stat = FISHOBJ_STAT_VERT;
					pFishObj->anm = 0;
				}
				break;
			case FISHOBJ_STAT_VERT:		//㏸
				if(pFishObj->row) {
					pFishObj->anm += 4/**/;
					if(pFishObj->anm >= (H__CELL + H__CELL__GAP)) {
						pFishObj->anm = 0;
						if(!--pFishObj->row) {
							pFishObj->stat = FISHOBJ_STAT_HORZ;
							pFishObj->anm = 0;
						}
					}
					break;	//܂
				} else {
					pFishObj->stat = FISHOBJ_STAT_HORZ;
					pFishObj->anm = 0;
				}
				/* FALLTHRU */
			case FISHOBJ_STAT_HORZ:		//ړ
				if(pFishObj->col != stGame.boatCol) {
					pFishObj->anm += 4/**/;
					if(pFishObj->anm >= (W__CELL + W__CELL__GAP)) {
						pFishObj->anm = 0;
						if(pFishObj->col < stGame.boatCol) {
							pFishObj->col++;
						} else {
							pFishObj->col--;
						}
						if(pFishObj->col == stGame.boatCol) {
							pFishObj->stat = FISHOBJ_STAT_WAIT;
							pFishObj->anm = 0;
						}
					}
					break;	//܂
				} else {
					pFishObj->stat = FISHOBJ_STAT_WAIT;
					pFishObj->anm = 0;
				}
				/* FALLTHRU */
			case FISHOBJ_STAT_WAIT:		//ʉҋ@
				if(i) {
					ST_FishObj* pFishObj2 = &stGame.TBL_FishObj[i - 1];
					if(!pFishObj2->type ||
					  ((pFishObj2->stat == FISHOBJ_STAT_JUMP) && (pFishObj2->anm >= 2/**/))) {
						pFishObj->stat = FISHOBJ_STAT_JUMP;
						pFishObj->anm = 0;
					}
					break;	//܂
				} else {
					pFishObj->stat = FISHOBJ_STAT_JUMP;
					pFishObj->anm = 0;
				}
				/* FALLTHRU */
			case FISHOBJ_STAT_JUMP:		//Wv
				if(!i && !pFishObj->anm) {	//'C''WvJn鎞'Ɍʉ炷B
					sound_play(0, sound_table[SND_SE_WAV3], 1);
				}
				if(++pFishObj->anm >= FISHOBJ_JUMP_TIME_CUT) {
					memset(pFishObj, 0, sizeof(ST_FishObj));
				}
				break;
			}
		}
	}
	//AŃIuWFNg
	for(i = 0; i < MAX_BUBBLEOBJ; i++) {
		ST_BubbleObj* pBubbleObj = &stGame.TBL_BubbleObj[i];
		if(pBubbleObj->type) {
			if(++pBubbleObj->anm >= (3 * 2/**/)) {
				memset(pBubbleObj, 0, sizeof(ST_BubbleObj));
			}
		}
	}
	//XRAIuWFNg
	for(i = 0; i < MAX_SCOREOBJ; i++) {
		ST_ScoreObj* pScoreObj = &stGame.TBL_ScoreObj[i];
		if(pScoreObj->score) {
			if(++pScoreObj->anm >= SCOREOBJ_TIME) {
				memset(pScoreObj, 0, sizeof(ST_ScoreObj));
			}
		}
	}
	//AUV
	{
		switch(stGame.sealStat) {
		default:DIE();
		case SEAL_STAT_HIDE:		//\
			if(stGame.infoStat == INFO_STAT_SEAL) {
				stGame.sealStat = SEAL_STAT_APPEAR;
				stGame.sealAnm = 0;
				sound_play(2, sound_table[SND_SE_WARN], 1);
			}
			break;
		case SEAL_STAT_APPEAR:		//o
			if(++stGame.sealAnm >= SEAL_APPEAR_TIME) {
				stGame.sealStat = SEAL_STAT_SHOW;
				stGame.sealAnm = 0;
			}
			break;
		case SEAL_STAT_SHOW:		//\
			if(stGame.infoStat != INFO_STAT_SEAL) {
				stGame.sealStat = SEAL_STAT_DISAPPEAR;
				stGame.sealAnm = 0;
			}
			break;
		case SEAL_STAT_DISAPPEAR:	//
			if(++stGame.sealAnm >= SEAL_DISAPPEAR_TIME) {
				stGame.sealStat = SEAL_STAT_HIDE;
				stGame.sealAnm = 0;
			}
			break;
		}
	}
	//T
	{
		switch(stGame.sharkStat) {
		default:DIE();
		case SHARK_STAT_HIDE:		//\
			if(stGame.infoStat == INFO_STAT_SHARK) {
				stGame.sharkStat = SHARK_STAT_APPEAR;
				stGame.sharkAnm = 0;
				sound_play(2, sound_table[SND_SE_ELEC], 1);
			}
			break;
		case SHARK_STAT_APPEAR:		//o
			if(++stGame.sharkAnm >= SHARK_APPEAR_TIME) {
				stGame.sharkStat = SHARK_STAT_SHOW;
				stGame.sharkAnm = 0;
			}
			break;
		case SHARK_STAT_SHOW:		//\
			if(stGame.infoStat != INFO_STAT_SHARK) {
				stGame.sharkStat = SHARK_STAT_DISAPPEAR;
				stGame.sharkAnm = 0;
			}
			break;
		case SHARK_STAT_DISAPPEAR:	//
			if(++stGame.sharkAnm >= SHARK_DISAPPEAR_TIME) {
				stGame.sharkStat = SHARK_STAT_HIDE;
				stGame.sharkAnm = 0;
			}
			break;
		}
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
//tB[h`B
void field_draw() {
	int iPri, x, y, w, h, iSprNo, iParam;
	//wi
	{
		iPri	= PRI__BG;
		//wi
		x	= 0;
		y	= 0;				//
		w	= DISP_X;			//@NbsO͈͂́Aʏ[ACwȉ[܂ŁB
		h	= Y__BG__SEA + field_offset();	//
		iSprNo	= SPR_SKY;
		iParam	= DRW_NOMAL;
		CbkQue_render_set_draw_area(pCbkQue, iPri, &render, x, y, x + w, y + h);
		CbkQue_sprite_draw(pCbkQue, iPri, 0, 0, iSprNo, iParam);	//`͉ʑŜɑ΂čsB
		//Cwi
		x	= 0;
		y	= Y__BG__SEA + field_offset();	//
		w	= DISP_X;			//@NbsO͈͂́ACwȉ[Aʉ[܂ŁB
		h	= DISP_Y - y;			//
		iSprNo	= SPR_SEA;
		iParam	= DRW_NOMAL;
		CbkQue_render_set_draw_area(pCbkQue, iPri, &render, x, y, x + w, y + h);
		CbkQue_sprite_draw(pCbkQue, iPri, 0, 0, iSprNo, iParam);	//`͉ʑŜɑ΂čsB
		//NbsOB
		CbkQue_render_set_draw_area_full(pCbkQue, iPri, &render);	//YȂ!!
	}
	//g
	{
		iPri	= PRI__WAVE;
		x	= ((now / 4/**/) % W__WAVE) - W__WAVE;
		y	= Y__WAVE + field_offset();
		{
			int ofs = ((now / 8/**/) % 4) - 1;	//
			if(ofs == 2) { ofs = 0; }			//g͑Ŝcɗh炷ɂBgXvCg͏㉺1sNZ炵Ăwi̐؂ڂ͌܂B𗘗pĔg̏㉺Aj[Vs܂B
			y += ofs;					//
		}
		iSprNo	= SPR_WAVE;
		iParam	= DRW_NOMAL;
		do {
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
			x += W__WAVE;
		} while(x < DISP_X);
	}
	//Z
	{
		int col, row;
		for(row = 0; row < FIELD_ROWS; row++) {
			for(col = 0; col < FIELD_COLS; col++) {
				ST_Cell* pCell = &stGame.TBL_Cell[row][col];
				if(pCell->type) {
					iPri	= PRI__CELL;	//̉̏ŗDx𒲐\L̂ŁA񂱂Ŋ{DxĂB
					x	= X__CELL + ((W__CELL + W__CELL__GAP) * col);
					y	= Y__CELL + ((H__CELL + H__CELL__GAP) * row) + field_offset();
					if(pCell->type == CELL_TYPE_BUBBLE) {
						iSprNo	= SPR_BUBBLE1 + ((((now / 2/**/) + col) / 2/**/) % 3);
						//                                            ~~~~~~~~~~~~~~~~~~~~~	//A͗񂲂ƂɏÂAj[V炷ɂBK{ł͂ȂB
					} else {
						iSprNo	= SPR_FISH1 + (pCell->type - CELL_TYPE_FISH1);
					}
					iParam	= DRW_NOMAL;
					//u̗Ȃ΁c
					if((stGame.boatStat == BOAT_STAT_PUT) && (col == stGame.boatCol)) {
						int ofs = (((Y__CELL - Y__NEXT1) * stGame.boatAnm) / PUT_TIME) - ((Y__CELL - Y__NEXT1) - (H__CELL + H__CELL__GAP));	//ʂ[Zɂ߂荞񂾗
						//        uʄ   [Z̍ 	//
						if(ofs > 0) { y += ofs; }
					//skȂ΁c
					} else if(stGame.boatStat == BOAT_STAT_LOSE) {
						if(pCell->type == CELL_TYPE_BUBBLE) {
							int i = stGame.boatAnm / 2/**/;
							if(i > 2) { continue; }	//`斳
							iSprNo = SPR_BURST1 + i;
							iPri++;	//čsڗȂ̂ŎOɕ`悷鎖ɂB
						} else {
							double speed;	//鑬x
							switch(pCell->type) {
							default:DIE();
							case CELL_TYPE_FISH1: speed = 2.5; break;	//^C
							case CELL_TYPE_FISH2: speed = 1.3; break;	//tO
							case CELL_TYPE_FISH3: speed = 1.0; break;	//^R
							case CELL_TYPE_FISH4: speed = 2.2; break;	//CJ
							case CELL_TYPE_FISH5: speed = 1.9; break;	//n[
							case CELL_TYPE_FISH6: speed = 1.6; break;	//q
							}
							if(col <= ((FIELD_COLS - 1) / 2)) {	//
								x -= speed * stGame.boatAnm;
							} else {				//E
								iParam	= DRW_REVX;
								x += (W__CELL - 1);
								x += speed * stGame.boatAnm;
							}
						}
					//㒆Ȃ΁c
					} else if(row && !stGame.TBL_Cell[row - 1][col].type && !is_fish_obj_exists()) {
						y -= stGame.cellAnm;
					//ȊOȂ΁c
					} else {
						int ofs = ((((now / 4/**/) + col) / 2/**/) % 4) - 1;	//
						if(ofs == 2) { ofs = 0; }						//A񂲂Ƃɏcʒu炷ɂBK{ł͂ȂBA̋̕`ɂ͉eȂB(̋́AZƂĂ̕`ł͂ȂAIuWFNgƂĕ`悷邩)
						y += ofs;								//
					}
					CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
				}
			}
		}
	}
	//dC
	if(stGame.boatStat != BOAT_STAT_WIN) {	//NA͓dC͕\ȂB
		iPri	= PRI__ELEC;
		//NbsOݒ肷B
		x	= X__FIELD;
		y	= Y__FIELD;
		w	= W__FIELD;
		h	= H__FIELD;
		CbkQue_render_set_draw_area(pCbkQue, iPri, &render, x, y, x + w, y + h);
		//dC`B
		x	= ((now * 1/**/) % W__ELEC) + (X__FIELD - W__ELEC);
		y	= Y__ELEC;	//'Y__ELEC+field_offset()'ł͂ȂɒӂB
		iSprNo	= SPR_ELEC;
		iParam	= DRW_NOMAL;
		do {
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
			x += W__ELEC;
		} while(x < (X__FIELD + W__FIELD));
		//NbsOB
		CbkQue_render_set_draw_area_full(pCbkQue, iPri, &render);	//YȂ!!
	}
	//tB[hg
	{
		int c = 3;	//x͍Ax͓_ŁB
		if(!is_clear() && !is_gameover() && is_full()) { c = UPDOWN_MOTION(now,4); }
		iPri	= PRI__FIELD;
		x	= X__FIELD;
		y	= Y__FIELD;
		w	= W__FIELD;
		h	= H__FIELD;
		CbkQue_render_rectangle_fill(pCbkQue, iPri, &render, x,     y, -W__FIELD__BORDER, h, c);	//
		CbkQue_render_rectangle_fill(pCbkQue, iPri, &render, x + w, y,  W__FIELD__BORDER, h, c);	//E
	}
	//ނグIuWFNg
	{
		int i;
		for(i = 0; i < MAX_FISHOBJ; i++) {
			ST_FishObj* pFishObj = &stGame.TBL_FishObj[i];
			if(pFishObj->type) {
				iPri	= PRI__FISHOBJ;
				x	= X__CELL + ((W__CELL + W__CELL__GAP) * pFishObj->col);
				y	= Y__CELL + ((H__CELL + H__CELL__GAP) * pFishObj->row) + field_offset();
				iSprNo	= SPR_FISH1 + (pFishObj->type - CELL_TYPE_FISH1);
				iParam	= DRW_NOMAL;
				switch(pFishObj->stat) {
				default:DIE();
				case FISHOBJ_STAT_FLASH:	//tbV
					if(!(pFishObj->anm & 1)) {
						iSprNo += (SPR_FLASH1 - SPR_FISH1);
					}
					break;
				case FISHOBJ_STAT_VERT:		//㏸
					y -= pFishObj->anm;
					break;
				case FISHOBJ_STAT_HORZ:		//ړ
					if(pFishObj->col < stGame.boatCol) {
						iParam	= DRW_REVX;
						x += (W__CELL - 1);
						x += pFishObj->anm;
					} else {
						x -= pFishObj->anm;
					}
					break;
				case FISHOBJ_STAT_WAIT:		//ʉҋ@
					if(stGame.boatDir == 0) {
						iParam	= DRW_REVX;
						x += (W__CELL - 1);
					}
					break;
				case FISHOBJ_STAT_JUMP:		//Wv
					{
						int tx, dx;
						if(stGame.boatDir == 0) {
							tx = X__BOAT + ((W__CELL + W__CELL__GAP) * (stGame.boatCol + 1));
						} else {
							tx = X__BOAT + ((W__CELL + W__CELL__GAP) * (stGame.boatCol - 1));
						}
						dx = tx - x;
						x += (    (  dx * pFishObj->anm) / FISHOBJ_JUMP_TIME_CUT                       );
						y -= (sin((M_PI * pFishObj->anm) / FISHOBJ_JUMP_TIME    ) * FISHOBJ_JUMP_HEIGHT);
						if(stGame.boatDir == 0) {
							iParam	= DRW_REVX;
							x += (W__CELL - 1);
						}
						if(pFishObj->anm >= (FISHOBJ_JUMP_TIME / 2)) {
							iPri = PRI__BOAT - 1;	//z{[ǧ̗DxɂB
						}
					}
					break;
				}
				CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
			}
		}
	}
	//AŃIuWFNg
	{
		int i;
		for(i = 0; i < MAX_BUBBLEOBJ; i++) {
			ST_BubbleObj* pBubbleObj = &stGame.TBL_BubbleObj[i];
			if(pBubbleObj->type) {
				iPri	= PRI__BUBBLEOBJ;
				x	= X__CELL + ((W__CELL + W__CELL__GAP) * pBubbleObj->col);
				y	= Y__CELL + ((H__CELL + H__CELL__GAP) * pBubbleObj->row) + field_offset();
				{
					int j = pBubbleObj->anm / 2/**/;
					if(j > 2) { j = 2; }
					iSprNo	= iSprNo = SPR_BURST1 + j;
				}
				iParam	= DRW_NOMAL;
				CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
			}
		}
	}
	//XRAIuWFNg
	{
		int i;
		for(i = 0; i < MAX_SCOREOBJ; i++) {
			ST_ScoreObj* pScoreObj = &stGame.TBL_ScoreObj[i];
			if(pScoreObj->score) {
				iPri	= PRI__SCOREOBJ;
				x	= X__CELL + ((W__CELL + W__CELL__GAP) * pScoreObj->col) + ((W__CELL + W__CELL__GAP) / 2);
				y	= Y__NEXT2 + field_offset() - min((int)pScoreObj->anm, (int)7/**/);
				{
					int xy = render_printf_framed(
						&null_render,
						0,
						0,
						3,
						0,
						"%d",
						pScoreObj->score);
					w = LOHALF(xy);
					h = HIHALF(xy);
					x -= w / 2;
					CbkQue_render_printf_framed(pCbkQue,
						PRI__SCOREOBJ,
						&render,
						x,
						y,
						3,
						0x330,
						"%d",
						pScoreObj->score);
				}
			}
		}
	}
	//AUV
	{
		switch(stGame.sealStat) {
		default:DIE();
		case SEAL_STAT_HIDE:		//\
			/** no job **/
			break;
		case SEAL_STAT_APPEAR:		//o
		case SEAL_STAT_SHOW:		//\
		case SEAL_STAT_DISAPPEAR:	//
			iPri	= PRI__INFO;
			x	= X__INFO__LEFT;
			y	= Y__INFO__LEFT;
			switch(stGame.sealStat) {
			case SEAL_STAT_APPEAR:		//o
				{
					double t = (double)stGame.sealAnm * (double)(M_PI_2 / SEAL_APPEAR_TIME);	//0/2
					y = (y + 70/**/) - (sin(t) * 70/**/);
				}
				break;
			case SEAL_STAT_SHOW:		//\
				{
					int ofs = ((now / 4/**/) % 4) - 1;
					if(ofs == 2) { ofs = 0; }					//A񂲂Ƃɏcʒu炷ɂBK{ł͂ȂBA̕`ɂ͉eȂB
					y += ofs;							//
				}
				break;
			case SEAL_STAT_DISAPPEAR:	//
				{
					double t = (double)(SEAL_DISAPPEAR_TIME - stGame.sealAnm) * (double)(M_PI_2 / SEAL_DISAPPEAR_TIME);	///20
					y = (y + 70/**/) - (sin(t) * 70/**/);
				}
				break;
			}
			iSprNo	= SPR_SEAL1 + ((now / 2/**/) % 4);
			iParam	= DRW_NOMAL;
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
			x	= X__INFO__RIGHT;
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
			break;
		}
	}
	//T
	{
		switch(stGame.sharkStat) {
		default:DIE();
		case SHARK_STAT_HIDE:		//\
			/** no job **/
			break;
		case SHARK_STAT_APPEAR:		//o
		case SHARK_STAT_SHOW:		//\
		case SHARK_STAT_DISAPPEAR:	//
			iPri	= PRI__INFO;
			x	= X__INFO__LEFT;
			y	= Y__INFO__LEFT;
			switch(stGame.sharkStat) {
			case SHARK_STAT_APPEAR:		//o
				{
					double t = (double)stGame.sharkAnm * (double)(M_PI_2 / SHARK_APPEAR_TIME);	//0/2
					y = (y - 70/**/) + (sin(t) * 70/**/);
				}
				break;
			case SHARK_STAT_SHOW:		//\
				{
					int ofs = ((now / 4/**/) % 4) - 1;
					if(ofs == 2) { ofs = 0; }					//A񂲂Ƃɏcʒu炷ɂBK{ł͂ȂBA̕`ɂ͉eȂB
					y += ofs;							//
				}
				break;
			case SHARK_STAT_DISAPPEAR:	//
				{
					double t = (double)(SHARK_DISAPPEAR_TIME - stGame.sharkAnm) * (double)(M_PI_2 / SHARK_DISAPPEAR_TIME);	///20
						y = (y - 70/**/) + (sin(t) * 70/**/);
				}
				break;
			}
			iSprNo	= SPR_SHARK1;
			iParam	= DRW_NOMAL;
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
			x	= X__INFO__RIGHT;
			iSprNo	= SPR_SHARK2;
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
			break;
		}
	}
	//XRA
	{
		CbkQue_render_printf_framed(pCbkQue,
			SHRT_MAX,
			&render,
			0,
			0,
			3,
			0x330,
			"1P\n%06d",
			stGame.score);
		CbkQue_render_printf_framed(pCbkQue,
			SHRT_MAX,
			&render,
			0,
			DISP_Y-11,
			3,
			0x330,
			"HI\n%06d",
			hiscore);
	}
}
/****************************************************************************
 *	boat_exec()
 ****************************************************************************/
void boat_exec() {
	//JnO
	{
		//JnȌ
		if(stGame.boatStat == BOAT_STAT_READY) {
			/** no job **/
		}
	}
	//ړ
	{
	    //{{NA\̃z[|WVֈړ
		if((stGame.boatStat == BOAT_STAT_WIN) && !stGame.boatOfs) {
			if(stGame.boatCol < 2) { goto L_WIN_RI; }
			if(stGame.boatCol > 3) { goto L_WIN_LF; }
			if((stGame.boatCol == 2) && (stGame.boatDir == 1)) { goto L_WIN_RI; }
			if((stGame.boatCol == 3) && (stGame.boatDir == 0)) { goto L_WIN_LF; }
		}
	    //}}NA\̃z[|WVֈړ
		switch(stGame.boatStat) {
		default:DIE();
		case BOAT_STAT_READY:	//JnO
		case BOAT_STAT_PUT:	//u
		case BOAT_STAT_GET:	//ނ蒆
		case BOAT_STAT_WIN:	//
		case BOAT_STAT_LOSE:	//sk
			/** no job **/
			break;
		case BOAT_STAT_NORMAL:	//ʏ풆
		case BOAT_STAT_CHANGE:	//
		case BOAT_STAT_NEXT:	//̋
			//ړJn
			if(joy & TRG_LF) {
				if(stGame.boatCol > 0) {
					sound_play(0, sound_table[SND_SE_MOVE], 1);
L_WIN_LF://{{NA\̃z[|WVֈړ}}
					stGame.boatCol--;
					if(stGame.boatDir == 0) {
						stGame.boatOfs = H__CELL + H__CELL__GAP;	//̌̈ړ̏łɌB
					} else {
						stGame.boatDir = 0;
						stGame.boatOfs = 0;
					}
				}
			}
			//EړJn
			if(joy & TRG_RI) {
				if(stGame.boatCol < FIELD_COLS - 1) {
					sound_play(0, sound_table[SND_SE_MOVE], 1);
L_WIN_RI://{{NA\̃z[|WVֈړ}}
					stGame.boatCol++;
					if(stGame.boatDir == 1) {
						stGame.boatOfs = H__CELL + H__CELL__GAP;	//̌̈ړ̏łɌB
					} else {
						stGame.boatDir = 1;
						stGame.boatOfs = 0;
					}
				}
			}
			break;
		}
		//ړ̏
		if(stGame.boatOfs) {
			stGame.boatOfs -= 2/**/;
		}
	}
	//
	{
		switch(stGame.boatStat) {
		default:DIE();
		case BOAT_STAT_READY:	//JnO
		case BOAT_STAT_PUT:	//u
		case BOAT_STAT_GET:	//ނ蒆
		case BOAT_STAT_WIN:	//
		case BOAT_STAT_LOSE:	//sk
			/** no job **/
			break;
		case BOAT_STAT_NORMAL:	//ʏ풆
		case BOAT_STAT_CHANGE:	//
		case BOAT_STAT_NEXT:	//̋
			if(joy & TRG_B) {
				stGame.boatStat = BOAT_STAT_CHANGE;
				stGame.boatAnm = 0;	//̌̌̏łɑB
				XCHG(stGame.TBL_Next[0], stGame.TBL_Next[1]);
			}
			break;
		}
		//̏
		if(stGame.boatStat == BOAT_STAT_CHANGE) {
			if(!stGame.boatAnm) {
				sound_play(0, sound_table[SND_SE_CHANGE], 1);
			}
			if(++stGame.boatAnm >= CHANGE_TIME) {
				stGame.boatStat = BOAT_STAT_NORMAL;
				stGame.boatAnm = 0;
			}
		}
	}
	//u
	{
		switch(stGame.boatStat) {
		default:DIE();
		case BOAT_STAT_READY:	//JnO
		case BOAT_STAT_PUT:	//u
		case BOAT_STAT_GET:	//ނ蒆
		case BOAT_STAT_WIN:	//
		case BOAT_STAT_LOSE:	//sk
			/** no job **/
			break;
		case BOAT_STAT_NORMAL:	//ʏ풆
		case BOAT_STAT_CHANGE:	//
		case BOAT_STAT_NEXT:	//̋
			//u
			if(++stGame.hurryCnt >= FORCE_TIME) {	//uuJnɔ肷鎖ɒӂBtɂƈt̗A{^Ał鎖hurryCnt̃JEgAbvĉoĂ܂B
				stGame.boatStat = BOAT_STAT_PUT;
				stGame.boatAnm = 0;	//̌̌̏łɑB
				stGame.hurryCnt = 0;
			//uJn
			} else if(joy & TRG_A) {
				//̗񂪈tłȂ΁c
				if(!is_full_col(stGame.boatCol)) {
					stGame.boatStat = BOAT_STAT_PUT;
					stGame.boatAnm = 0;	//̌̌̏łɑB
					stGame.hurryCnt = 0;
				} else {
					sound_play(0, sound_table[SND_SE_ERR], 1);
				}
			}
			break;
		}
		//ȕ
		if(stGame.boatStat == BOAT_STAT_PUT) {
			if(stGame.boatAnm < PUT_TIME) {
				stGame.boatAnm++;
				if(stGame.boatAnm == (PUT_TIME / 2)) {
					sound_play(0, sound_table[SND_SE_WAV1], 1);
				}
			}
		}
	}
	//ނ
	{
		//ނ蒆̏
		if(stGame.boatStat == BOAT_STAT_GET) {
			/** no job **/
		}
	}
	//̋
	{
		//̋̏
		if(stGame.boatStat == BOAT_STAT_NEXT) {
			if(++stGame.boatAnm >= NEXT_TIME) {
				//TODO:
				stGame.boatStat = BOAT_STAT_NORMAL;
				stGame.boatAnm = 0;
			}
		}
	}
	//
	{
		//sk̏
		if(stGame.boatStat == BOAT_STAT_LOSE) {
			stGame.boatAnm++;	//Aj[V̂߂ɕKv
		}
	}

}
/****************************************************************************
 *	
 ****************************************************************************/
//{[g`B
void boat_draw() {
	int iPri, x, y, iSprNo, iParam;
	//{[g
	{
		iPri	= PRI__BOAT;
		x	= X__BOAT + ((W__CELL + W__CELL__GAP) * stGame.boatCol);
		y	= Y__BOAT + field_offset();
		if(stGame.boatDir == 0) {	//
			x += stGame.boatOfs;
			iParam	= DRW_NOMAL;
		} else {			//E
			x += W__BOAT - 1;		//DRW_REVXɂXvCgW̒𑊎E邽
			x -= W__CELL + W__CELL__GAP;	//
			x -= stGame.boatOfs;
			iParam	= DRW_REVX;
		}
		switch(stGame.boatStat) {
		default:DIE();
		case BOAT_STAT_READY:	//JnO
		case BOAT_STAT_NORMAL:	//ʏ풆
		case BOAT_STAT_CHANGE:	//
		case BOAT_STAT_PUT:	//u
		case BOAT_STAT_GET:	//ނ蒆
		case BOAT_STAT_NEXT:	//̋
			iSprNo	= SPR_BOAT;
			break;
		case BOAT_STAT_WIN:	//
			iSprNo	= SPR_BOAT_WIN1 + ((now / 4) % 4);
			break;
		case BOAT_STAT_LOSE:	//sk
			iSprNo	= SPR_BOAT_LOSE1 + ((now / 4) % 2);
			break;
		}
		CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
	}
	//
	{
		switch(stGame.boatStat) {
		default:DIE();
		case BOAT_STAT_READY:	//JnO
		case BOAT_STAT_PUT:	//u
		case BOAT_STAT_GET:	//ނ蒆
		case BOAT_STAT_WIN:	//
		case BOAT_STAT_LOSE:	//sk
			/** no job **/
			break;
		case BOAT_STAT_NORMAL:	//ʏ풆
		case BOAT_STAT_CHANGE:	//
		case BOAT_STAT_NEXT:	//̋
			{
				iPri	= PRI__ARROW;
				x	= X__ARROW + ((W__CELL + W__CELL__GAP) * stGame.boatCol);
				y	= Y__ARROW + field_offset();
				if(stGame.boatDir == 0) {	//
					x += stGame.boatOfs;
				} else {			//E
					x -= stGame.boatOfs;
				}
				iSprNo	= SPR_ARROW1 + ((now / 4) % 3);
				iParam	= DRW_NOMAL;
				CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
			}
			break;
		}
	}
	{
		int x1, x2, y1, y2, x3, y3, iSprNo1, iSprNo2;
		x1	= X__NEXT1 + ((W__CELL + W__CELL__GAP) * stGame.boatCol);	//Ă鋛̊{ʒu
		y1	= Y__NEXT1 + field_offset();					//
		x2	= X__NEXT2 + ((W__CELL + W__CELL__GAP) * stGame.boatCol);	//̋̊{ʒu
		y2	= Y__NEXT2 + field_offset();					//
		x3	= X__CELL + ((W__CELL + W__CELL__GAP) * stGame.boatCol);	//{[g̒̃Z̈ʒu
		y3	= Y__CELL + field_offset();					//
		if(stGame.boatDir == 0) {	//
			x1 += stGame.boatOfs;
			x2 += stGame.boatOfs;
			x2 += (W__CELL + W__CELL__GAP);
			x3 += stGame.boatOfs;
		} else {			//E
			x1 -= stGame.boatOfs;
			x2 -= stGame.boatOfs;
			x2 -= (W__CELL + W__CELL__GAP);
			x3 -= stGame.boatOfs;
		}
		iSprNo1	= SPR_FISH1 + (stGame.TBL_Next[0] - CELL_TYPE_FISH1);		//Ă鋛̃XvCg
		iSprNo2	= SPR_FISH1 + (stGame.TBL_Next[1] - CELL_TYPE_FISH1);		//̋̃XvCg
		//Ă鋛
		{
			iPri	= PRI__NEXT1;
			switch(stGame.boatStat) {
			default:DIE();
			case BOAT_STAT_GET:	//ނ蒆
			case BOAT_STAT_WIN:	//
			case BOAT_STAT_LOSE:	//sk
				/** no job **/
				break;
			case BOAT_STAT_READY:	//JnO
			case BOAT_STAT_NORMAL:	//ʏ풆
				x	= x1;
				y	= y1;
				if(stGame.hurryCnt >= HURRY_TIME) {	//}ȂΎĂ鋛㉺ɗh炷B
					int ofs = ((now / 2/**/) % 4) - 1;
					if(ofs == 2) { ofs = 0; }
					y += ofs;
				}
				iSprNo	= iSprNo1;
				iParam	= DRW_NOMAL;
				CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
				break;
			case BOAT_STAT_PUT:	//u
				x	= ((x3 * stGame.boatAnm) + (x1 * (PUT_TIME - stGame.boatAnm))) / PUT_TIME;	//Ă鋛̊{ʒuA{[g̒̃Z̈ʒu
				y	= ((y3 * stGame.boatAnm) + (y1 * (PUT_TIME - stGame.boatAnm))) / PUT_TIME;	//
				iSprNo	= iSprNo1;
				iParam	= DRW_NOMAL;
				CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
				break;
			case BOAT_STAT_CHANGE:	//
				x	= ((x1 * stGame.boatAnm) + (x2 * (CHANGE_TIME - stGame.boatAnm))) / CHANGE_TIME;	//̋̊{ʒuAĂ鋛̊{ʒu
				y	= ((y1 * stGame.boatAnm) + (y2 * (CHANGE_TIME - stGame.boatAnm))) / CHANGE_TIME;	//
				iSprNo	= iSprNo1;
				iParam	= DRW_NOMAL;
				CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
				break;
			case BOAT_STAT_NEXT:	//̋
				x	= ((x1 * stGame.boatAnm) + (x2 * (NEXT_TIME - stGame.boatAnm))) / NEXT_TIME;	//̋̊{ʒuAĂ鋛̊{ʒu
				y	= ((y1 * stGame.boatAnm) + (y2 * (NEXT_TIME - stGame.boatAnm))) / NEXT_TIME;	//
				iSprNo	= iSprNo1;
				iParam	= DRW_NOMAL;
				CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
				break;
			}
		}
		//̋
		{
			iPri	= PRI__NEXT1;
			switch(stGame.boatStat) {
			default:DIE();
			case BOAT_STAT_WIN:	//
			case BOAT_STAT_LOSE:	//sk
				/** no job **/
				break;
			case BOAT_STAT_READY:	//JnO
			case BOAT_STAT_NORMAL:	//ʏ풆
			case BOAT_STAT_PUT:	//u
			case BOAT_STAT_NEXT:	//̋
			case BOAT_STAT_GET:	//ނ蒆
				x	= x2;
				y	= y2;
				iSprNo	= iSprNo2;
				iParam	= DRW_NOMAL;
				CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
				break;
			case BOAT_STAT_CHANGE:	//
				x	= ((x2 * stGame.boatAnm) + (x1 * (CHANGE_TIME - stGame.boatAnm))) / CHANGE_TIME;	//Ă鋛̊{ʒuA̋̊{ʒu
				y	= ((y2 * stGame.boatAnm) + (y1 * (CHANGE_TIME - stGame.boatAnm))) / CHANGE_TIME;	//
				iSprNo	= iSprNo1;
				iParam	= DRW_NOMAL;
				CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
				break;
			}
		}
	}
	//}
	if(stGame.hurryCnt >= HURRY_TIME) {	//}ȂΎĂ鋛㉺ɗh炷B
		iPri	= PRI__HURRY;
		x	= X__HURRY + ((W__CELL + W__CELL__GAP) * stGame.boatCol);
		y	= Y__HURRY + field_offset();
		if(stGame.boatDir == 0) {	//
			x += stGame.boatOfs;
		} else {			//E
			x -= stGame.boatOfs;
			x += 19/*ڂŒ*/;
		}
		iParam	= DRW_NOMAL;
		if(stGame.hurryCnt >= (FORCE_TIME - SEC(1.0))) {
			if(stGame.hurryCnt == (FORCE_TIME - SEC(1.0))) {
				sound_play(1, sound_table[SND_SE_HURRY], 1);
			}
			iSprNo	= SPR_HURRY1;
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
		} else if(stGame.hurryCnt >= (FORCE_TIME - SEC(2.0))) {
			if(stGame.hurryCnt == (FORCE_TIME - SEC(2.0))) {
				sound_play(1, sound_table[SND_SE_HURRY], 1);
			}
			iSprNo	= SPR_HURRY2;
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
		} else if(stGame.hurryCnt >= (FORCE_TIME - SEC(3.0))) {
			if(stGame.hurryCnt == (FORCE_TIME - SEC(3.0))) {
				sound_play(1, sound_table[SND_SE_HURRY], 1);
			}
			iSprNo	= SPR_HURRY3;
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
		} else {
			/** no job **/
		}
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
//1Xe[W̏
int stage_run() {
	int col, row;
	//
	{
		//zu
		{
			const int level = stGame.stage/*1`*/ - 1;
			int initLow, initHeight, fishLimit;
			initLow = level / 5/**/;
			if(initLow > FIELD_ROWS - 4) { initLow = FIELD_ROWS - 4; }
			initHeight = 3 + (level / 3/**/);
			if(initHeight > (FIELD_ROWS - initLow) - 2) { initHeight = (FIELD_ROWS - initLow) - 2; }
			fishLimit  = CELL_TYPE_FISH4 + (level / 2/**/);
			if(fishLimit > CELL_TYPE_FISH6) { fishLimit = CELL_TYPE_FISH6; }
			stGame.lowCnt = initLow;
			for(;;) {
				int bPut = 0;
				for(row = 0; row < initHeight; row++) {
					for(col = 0; col < FIELD_COLS; col++) {
						ST_Cell* pCell = &stGame.TBL_Cell[row][col];
						if(!pCell->type) {
							if(!row) {
								pCell->type = RND32_RANGE(seed, CELL_TYPE_FISH1, fishLimit + 1);
							} else {
								pCell->type = RND32_RANGE(seed, CELL_TYPE_FISH1, fishLimit + 2);
								if(pCell->type > fishLimit) { pCell->type = CELL_TYPE_BUBBLE; }
							}
							bPut = 1;
						}
					}
				}
				if(!bPut) { break; }
				for(;;) {
					if(!do_erase_fish()) { break; }
					for(;;) {
						while(do_raise(0/*testOnly*/)) { /** no job **/ }
						if(!do_erase_bubble()) { break; }
					}
				}
				memset(stGame.TBL_FishObj, 0, sizeof stGame.TBL_FishObj);
				memset(stGame.TBL_BubbleObj, 0, sizeof stGame.TBL_BubbleObj);
			}
		}
		//ʒu
		stGame.boatStat = BOAT_STAT_READY;
		stGame.boatCol = (FIELD_COLS - 1) / 2;
		stGame.TBL_Next[0] = get_next();
		stGame.TBL_Next[1] = get_next();
	}
	//TC
	sound_play(0, sound_table[SND_SE_SILEN], 1);
	//Xe[WX^[g
	{
		int i;
		for(i = 0; i < SEC(1.9); i++) {
			schedule();
			if(joy & TRG_SELECT) { goto L_EXIT; }
			field_draw();
			boat_draw();
			field_exec();
			boat_exec();
			{
				int x, y, w, h;
				x = render_printf_framed(
					&null_render,
					0,
					0,
					1,
					0,
					(i < SEC(1.0)) ? "STAGE %d" : "START!",
					stGame.stage);
				w = LOHALF(x);
				h = HIHALF(x);
				x = (DISP_X / 2) - (w / 2);
				y = (DISP_Y / 2) - h;
				CbkQue_render_printf_framed(pCbkQue,
					SHRT_MAX,
					&render,
					x,
					y,
					1,
					0x230,
					(i < SEC(1.0)) ? "STAGE %d" : "START!",
					stGame.stage);
			}
		}
		{
			stGame.boatStat = BOAT_STAT_NORMAL;
			stGame.boatAnm = 0;
		}
	}
	{
		//CBGMJn
		extern /*const*/ unsigned char MAIN_BGM[];
		PlayMusic(MAIN_BGM);
	}
	//Q[[v
	for(;;) {
		//AUVEToB
		if(stGame.putCnt >= LOW_WARN_PUT_CNT) {	//AUV̕DxłB
			stGame.infoStat = INFO_STAT_SEAL;
		} else if(is_full()) {
			stGame.infoStat = INFO_STAT_SHARK;
		} else {
			stGame.infoStat = 0;
		}
		//u܂ł̃[v
		for(;;) {
			schedule();
			if(joy & TRG_SELECT) { goto L_EXIT; }
			field_draw();
			boat_draw();
			field_exec();
			boat_exec();
			if((stGame.boatStat == BOAT_STAT_PUT) && (stGame.boatAnm >= PUT_TIME)) { break; }
		}
		//u
		{
			//̗iփVtgB
			col = stGame.boatCol;
			for(row = FIELD_ROWS - 1; row > 0; row--) {
				stGame.TBL_Cell[row][col] = stGame.TBL_Cell[row - 1][col];
			}
			//uB
			stGame.TBL_Cell[row][col].type = stGame.TBL_Next[0];
			//Q[I[o	ܒuŎOCƂĂAłOɃQ[I[o[ɂȂdlłB
			if(is_gameover()) { goto L_GAMEOVER; }
		    #if 0 //{{sv:uɂĊ댯Ƒオɔ鎞͌x͖ՂB
			//AUVEToB
			if(stGame.putCnt >= LOW_WARN_PUT_CNT) {	//AUV̕DxłB
				stGame.infoStat = INFO_STAT_SEAL;
			} else if(is_full()) {
				stGame.infoStat = INFO_STAT_SHARK;
			} else {
				stGame.infoStat = 0;
			}
		    #endif//}}sv:uɂĊ댯Ƒオɔ鎞͌x͖ՂB
		}
		//uAނ̔LɊ֌WAނԂɂĂɂB
		//ȂƁA{[g̕`ɂuƁAtB[h̒udɕ`悳Ă܂B
		//i͈uȂ̂ŋCtȂA͎Ԃ̂ŁAO(hȂ)ƌ(h)dȂČ鎖ɋCtĂ܂B
		{
			stGame.boatStat = BOAT_STAT_GET;
			stGame.boatAnm = 0;
		}
		{
			int nChain = 0;	//A
			for(;;) {
				//ނグ
				int nFish = do_erase_fish();
				if(!nFish) { break; }	//ނグȂΔB
				//ʉ
				sound_play(0, sound_table[SND_SE_ERASE], 1);
				//ނグIuWFNg̃Aj[V܂ł̃[v
				for(;;) {
					schedule();
					if(joy & TRG_SELECT) { goto L_EXIT; }
					field_draw();
					boat_draw();
					field_exec();
					boat_exec();
					if(!is_fish_obj_exists()) { break; }	//ނグIuWFNgȂȂ甲BAAŃIuWFNg͎cĂĂ\ȂB
				}
				//XRA
				{
					//XRA肷B
					int add = (nFish - 3) * 20;	//3C=0,4C=20,5C=40,...
					switch(nChain) {
					case 0:  add +=  1000; break;
					case 1:  add +=  2000; break;
					case 2:  add +=  5000; break;
					case 3:  add +=  7000; break;
					case 4:  add += 10000; break;
					case 5:  add += 15000; break;
					default: add += 30000 + (20000 * nChain - 6); break;
					}
					//XRAZB
					stGame.score += add;
					sound_play(3, sound_table[SND_SE_SCORE], 1);
					if(stGame.score > hiscore) { hiscore = stGame.score; }
					//XRAIuWFNg𐶐B
					gen_score_obj(
						(stGame.boatDir == 0) ? (stGame.boatCol + 1) : (stGame.boatCol - 1),	//L̗
						add);
					//̂߂ɘA𑝂₷B
					nChain++;
				}
				//Z㏈
				for(;;) {
					//Z̃Aj[V܂ł̃[v
					if(do_raise(1/*testOnly*/)) {
						for(;;) {
							//Aj[V
							for(stGame.cellAnm = 0; stGame.cellAnm < (H__CELL + H__CELL__GAP); stGame.cellAnm += 4/**/) {	//(H__CELL+H__CELL__GAP)=8Ȃ̂ŁA4sNZ~2t[ŕシB
								schedule();
								if(joy & TRG_SELECT) { goto L_EXIT; }
								field_draw();
								field_exec();
								boat_exec();
								boat_draw();
							}
							//㏈
							if(!do_raise(0/*testOnly*/)) { break; }	//シZȂ甲B
							//AUVEToB
							if(stGame.putCnt >= LOW_WARN_PUT_CNT) {	//AUV̕DxłB
								stGame.infoStat = INFO_STAT_SEAL;
							} else if(is_full()) {
								stGame.infoStat = INFO_STAT_SHARK;
							} else {
								stGame.infoStat = 0;
							}
						}
						stGame.cellAnm = 0;	//YȂ!!cellAnm0ɖ߂ĂȂƁAdo_erase_fish()ŃZɂuԂɁÃZ̕\ʒuςĂ܂B
					}
					//Aŏ
					if(!do_erase_bubble()) { break; }	//AŖȂΔB
					//Z֖߂ČJԂBAŃIuWFNg̃Aj[V͑̉oƕsĐisôŁAcĂč\ȂB
				}
			}
		}
		//NA
		if(is_clear()) { goto L_CLEAR; }
		//
		{
			//ɊłȂ΁c
			if(stGame.lowCnt < FIELD_ROWS) {
				//u񐔂𑝂₷B
				stGame.putCnt++;
				//
				if(stGame.putCnt >= LOW_TIDE_PUT_CNT) {
					stGame.putCnt = 0;
					//ʉ
					sound_play(1, sound_table[SND_SE_WAV2], 1);
					//Aj[V
					for(stGame.lowOfs = 0; stGame.lowOfs < (H__CELL + H__CELL__GAP); stGame.lowOfs += 2/**/) {
						schedule();
						if(joy & TRG_SELECT) { goto L_EXIT; }
						field_draw();
						field_exec();
						boat_exec();
						boat_draw();
					}
					stGame.lowOfs = 0;
					stGame.lowCnt++;
					//Q[I[o[
					if(is_gameover()) { goto L_GAMEOVER; }
					//AUVEToB
					if(stGame.putCnt >= LOW_WARN_PUT_CNT) {	//AUV̕DxłB
						stGame.infoStat = INFO_STAT_SEAL;
					} else if(is_full()) {
						stGame.infoStat = INFO_STAT_SHARK;
					} else {
						stGame.infoStat = 0;
					}
				}
			}
		}
		//̋
		{
			stGame.boatStat = BOAT_STAT_NEXT;
			stGame.boatAnm = 0;
			stGame.TBL_Next[0] = stGame.TBL_Next[1];
			stGame.TBL_Next[1] = get_next();
		}
	}
L_CLEAR:
	{
		//Xe[WNAWOĐ
		extern /*const*/ unsigned char CLER_JGL[];
		PlayMusic(CLER_JGL);
	}
	{
		int i, bonus = 0;
		//
		{
			stGame.boatStat = BOAT_STAT_WIN;
			stGame.boatAnm = 0;
			stGame.infoStat = 0;	//́AAUVTޏꂳB
		}
		for(i = 0; i < SEC(0.5); i++) {
			schedule();
			if(joy & TRG_SELECT) { goto L_EXIT; }
			field_draw();
			boat_draw();
			field_exec();
			boat_exec();
		}
		for(i = 0; i < SEC(1.0); i++) {
			schedule();
			if(joy & TRG_SELECT) { goto L_EXIT; }
			field_draw();
			boat_draw();
			field_exec();
			boat_exec();
			{
				int x, y, w, h;
				x = render_printf_framed(
					&null_render,
					0,
					0,
					1,
					0,
					"STAGE\nCLEAR");
				w = LOHALF(x);
				h = HIHALF(x);
				x = (DISP_X / 2) - (w / 2);
				y = (DISP_Y / 2) - (h / 2);
				CbkQue_render_printf_framed(pCbkQue,
					SHRT_MAX,
					&render,
					x,
					y,
					1,
					0x230,
					"STAGE\nCLEAR");
			}
		}
		for(;;) {
			for(i = 0; i < SEC(0.25); i++) {
				schedule();
				if(joy & TRG_SELECT) { goto L_EXIT; }
				field_draw();
				boat_draw();
				field_exec();
				boat_exec();
				{
					int x, y, w, h;
					x = render_printf_framed(
						&null_render,
						0,
						0,
						1,
						0,
						"BONUS\n%5d",
						bonus);
					w = LOHALF(x);
					h = HIHALF(x);
					x = (DISP_X / 2) - (w / 2);
					y = (DISP_Y / 2) - (h / 2);
					CbkQue_render_printf_framed(pCbkQue,
						SHRT_MAX,
						&render,
						x,
						y,
						1,
						0x230,
						"BONUS\n%5d",
						bonus);
				}
			}
			if(stGame.lowCnt >= FIELD_ROWS - 1) { break; }
			//ʉ
			sound_play(1, sound_table[SND_SE_WAV2], 1);
			//Aj[V
			for(stGame.lowOfs = 0; stGame.lowOfs < (H__CELL + H__CELL__GAP); stGame.lowOfs += 2/**/) {
				schedule();
				if(joy & TRG_SELECT) { goto L_EXIT; }
				field_draw();
				field_exec();
				boat_exec();
				boat_draw();
				{
					int x, y, w, h;
					x = render_printf_framed(
						&null_render,
						0,
						0,
						1,
						0,
						"BONUS\n%5d",
						bonus);
					w = LOHALF(x);
					h = HIHALF(x);
					x = (DISP_X / 2) - (w / 2);
					y = (DISP_Y / 2) - (h / 2);
					CbkQue_render_printf_framed(pCbkQue,
						SHRT_MAX,
						&render,
						x,
						y,
						1,
						0x230,
						"BONUS\n%5d",
						bonus);
				}
			}
			stGame.lowOfs = 0;
			stGame.lowCnt++;
			//{[iXZ
			bonus += ((bonus < 2000) ? 500 : 1000);		//0500100015002000300040005000c	{300050008000A܂ǂ낤B
		}
		//XRAZ
		while(bonus) {
			schedule();
			if(joy & TRG_SELECT) { goto L_EXIT; }
			field_draw();
			field_exec();
			boat_exec();
			boat_draw();
			{
				int x, y, w, h;
				x = render_printf_framed(
					&null_render,
					0,
					0,
					1,
					0,
					"BONUS\n%5d",
					bonus);
				w = LOHALF(x);
				h = HIHALF(x);
				x = (DISP_X / 2) - (w / 2);
				y = (DISP_Y / 2) - (h / 2);
				CbkQue_render_printf_framed(pCbkQue,
					SHRT_MAX,
					&render,
					x,
					y,
					1,
					0x230,
					"BONUS\n%5d",
					bonus);
			}
			{
				int add = min(bonus, 300);
				stGame.score += add;
				bonus        -= add;
				sound_play(3, sound_table[SND_SE_SCORE], 1);
				if(stGame.score > hiscore) { hiscore = stGame.score; }
			}
		}
		//҂
		for(i = 0; (i < SEC(2.0)) || !MusicCheck(); i++) {
			schedule();	//   ~~~~~~~~~~~~~2bo߂ĂA܂Xe[WNAWOĂ҂B
			if(joy & TRG_SELECT) { goto L_EXIT; }
			field_draw();
			boat_draw();
			field_exec();
			boat_exec();
			{
				int x, y, w, h;
				x = render_printf_framed(
					&null_render,
					0,
					0,
					1,
					0,
					"BONUS\n%5d",
					bonus);
				w = LOHALF(x);
				h = HIHALF(x);
				x = (DISP_X / 2) - (w / 2);
				y = (DISP_Y / 2) - (h / 2);
				CbkQue_render_printf_framed(pCbkQue,
					SHRT_MAX,
					&render,
					x,
					y,
					1,
					0x230,
					"BONUS\n%5d",
					bonus);
			}
			if(joy & TRG_AB) { break; }	//LZ
		}
		return 1;
	}
L_GAMEOVER:
	{
		//Q[I[o[WOĐ
		extern /*const*/ unsigned char OVER_JGL[];
		PlayMusic(OVER_JGL);
	}
	{
		int i;
		//sk
		{
			stGame.boatStat = BOAT_STAT_LOSE;
			stGame.boatAnm = 0;
			stGame.infoStat = 0;	//́AAUVTޏꂳB
		}
		for(i = 0; (i < SEC(5.0)) || !MusicCheck(); i++) {
			schedule();	//   ~~~~~~~~~~~~~5bo߂ĂA܂Q[I[o[WOĂ҂B
			if(joy & TRG_SELECT) { goto L_EXIT; }
			field_draw();
			boat_draw();
			field_exec();
			boat_exec();
			if(i > SEC(1.0)) {
				int x, y, w, h;
				x = render_printf_framed(
					&null_render,
					0,
					0,
					1,
					0,
					"GAME OVER");
				w = LOHALF(x);
				h = HIHALF(x);
				x = (DISP_X / 2) - (w / 2);
				y = (DISP_Y / 2) - h;
				CbkQue_render_printf_framed(pCbkQue,
					SHRT_MAX,
					&render,
					x,
					y,
					1,
					0x230,
					"GAME OVER");
			}
			if((i >= SEC(2.0)) && (joy & TRG_AB)) { break; }	//2bォLZ
		}
		return 0;
	}
L_EXIT:
	return 0;
}
/****************************************************************************
 *	
 ****************************************************************************/
//1Q[̏
void game_run() {
	memset(&stGame, 0, sizeof stGame);
	stGame.stage = stage_sel;
	while(stage_run()) {
		int score = stGame.score;	//ޔ
		int stage = stGame.stage;	//ޔ
		memset(&stGame, 0, sizeof stGame);
		stGame.score = score;		//A
		stGame.stage = stage + 1;	//A
		StopMusic();
#ifdef  USE_TRUESPEECH
		TrueSpeech_StopAll();
#endif//USE_TRUESPEECH
	}
	StopMusic();
#ifdef  USE_TRUESPEECH
	TrueSpeech_StopAll();
#endif//USE_TRUESPEECH
}
/****************************************************************************
 *	
 ****************************************************************************/
//^Cg̏
void demo_run() {
	int iPri, x, y, w, h, iSprNo, iParam, start = 0;
	for(;;) {
		schedule();
		if(joy & TRG_SELECT) { exit(EXIT_SUCCESS); }
		//wi
		iPri	= 0;
		x	= 0;
		y	= 0;
		iSprNo	= SPR_SKY;
		iParam	= DRW_NOMAL;
		CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
		//^Cg
		{
			iPri	= 0;
			x	= DISP_X / 2;
			y	= (DISP_Y / 2) - 8;
			iSprNo	= SPR_TITLE;
			iParam	= DRW_NOMAL;
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
			//
			x	+= 31;
			y	+= 10;
			CbkQue_render_printf_framed(pCbkQue,
				iPri,
				&render,
				x,
				y,
				3,
				0x130,
				"޷");
		}
		//XRA
		{
			CbkQue_render_printf_framed(pCbkQue,
				SHRT_MAX,
				&render,
				0,
				0,
				3,
				0x330,
				"1P\n%06d",
				stGame.score);
		}
		{
			x = render_printf_framed(
				&null_render,
				0,
				0,
				3,
				0,
				"HI\n%06d",
				hiscore);
			w = LOHALF(x);
			h = HIHALF(x);
			x = (DISP_X / 2) - (w / 2);
			y = 0;
			CbkQue_render_printf_framed(pCbkQue,
				SHRT_MAX,
				&render,
				x,
				y,
				3,
				0x330,
				"HI\n%06d",
				hiscore);
		}
		//Xe[WZNg
		{
			if((stage_sel >  1) && (joy & TRG_LF)) {
				stage_sel--;
				sound_play(0, sound_table[SND_SE_BTN], 1);
			}
			if((stage_sel < 99) && (joy & TRG_RI)) {
				stage_sel++;
				sound_play(0, sound_table[SND_SE_BTN], 1);
			}
			x = render_printf_framed(
				&null_render,
				0,
				0,
				3,
				0,
				"%c STAGE SELECT %02d %c",
				(stage_sel >  1) ? '<' : ' ',
				stage_sel,
				(stage_sel < 99) ? '>' : ' ');
			w = LOHALF(x);
			h = HIHALF(x);
			x = (DISP_X / 2) - (w / 2);
			y = (DISP_Y / 2) + 18;
			CbkQue_render_printf_framed(pCbkQue,
				SHRT_MAX,
				&render,
				x,
				y,
				3,
				0x330,
				"%c STAGE SELECT %02d %c",
				(stage_sel >  1) ? '<' : ' ',
				stage_sel,
				(stage_sel < 99) ? '>' : ' ');
		}
		//vvg
		{
			if((!start && ((now % SEC(1.0)) < SEC(0.5))) ||	//O
			   (start & 1)) {				//
				x = render_printf_framed(
					&null_render,
					0,
					0,
					3,
					0,
					"PRESS A BUTTON TO START");
				w = LOHALF(x);
				h = HIHALF(x);
				x = (DISP_X / 2) - (w / 2);
				y = (DISP_Y / 2) + 31;
				CbkQue_render_printf_framed(pCbkQue,
					SHRT_MAX,
					&render,
					x,
					y,
					3,
					0x330,
					"PRESS A BUTTON TO START");
			}
			if(!start) {
				if(joy & TRG_AB) {
					start = 1;
					sound_play(0, sound_table[SND_SE_ERASE], 1);
				}
			} else {
				if(++start >= SEC(1.0)) {
					break;
				}
			}
		}
	}
}
/****************************************************************************
 *	app_main
 ****************************************************************************/
int app_main(int argc, char* argv[]) {
//{{BR}hBBȂNƓdr\BfobOɓdr\₷悤ɂ邽߂łB
	delay(1);
	if(joy & PAD_B) {
		pceWaveSetMasterAtt(0);
		pcePowerSetReport(PWR_RPTOFF);
	}
//}}BR}hBBȂNƓdr\BfobOɓdr\₷悤ɂ邽߂łB
	stage_sel = 1;
	for(;;) {
		demo_run();
		game_run();
	}
	return 0;
}



//	Ȃ񂾂!?
//	http://www.collectorvision.com/old/game-puzzli.htm

