// 
//  SS5Platform.cpp
//
#include "SS5PlayerPlatform.h"

/**
* evbgtH[ɍ킹ď쐬Ă
* DXCupɍ쐬Ă܂B
*/
#include "DxLib.h"

extern int draw_count;

namespace ss
{
	/**
	* t@Cǂݍ
	*/
	unsigned char* SSFileOpen(const char* pszFileName, const char* pszMode, unsigned long * pSize)
	{
		unsigned char * pBuffer = NULL;
		SS_ASSERT2(pszFileName != NULL && pSize != NULL && pszMode != NULL, "Invalid parameters.");
		*pSize = 0;
		do
		{
		    // read the file from hardware
			FILE *fp = fopen(pszFileName, pszMode);
		    SS_BREAK_IF(!fp);
		    
		    fseek(fp,0,SEEK_END);
		    *pSize = ftell(fp);
		    fseek(fp,0,SEEK_SET);
		    pBuffer = new unsigned char[*pSize];
		    *pSize = fread(pBuffer,sizeof(unsigned char), *pSize,fp);
		    fclose(fp);
		} while (0);
		if (! pBuffer)
		{

			std::string msg = "Get data from file(";
		    msg.append(pszFileName).append(") failed!");
		    
		    SSLOG("%s", msg.c_str());

		}
		return pBuffer;
	}

	/**
	* eNX`̓ǂݍ
	*/
	long SSTextureLoad(const char* pszFileName, SsTexWrapMode::_enum  wrapmode, SsTexFilterMode::_enum filtermode)
	{
		/**
		* eNX`Ǘp̃j[NȒlԂĂB
		* eNX`̊Ǘ̓Q[ōs`ɂȂ܂B
		* eNX`ɃANZXnhAeNX`蓖Ăobt@ԍɂȂ܂B
		*
		* vC[͂ŕԂlƃp[c̃Xe[^Xɕ`s܂B
		*/
		long rc = 0;

		rc = (long)LoadGraph(pszFileName);
		//SpriteStudioŐݒ肳ꂽeNX`ݒ𔽉f邽߂̕łB
		switch (wrapmode)
		{
		case SsTexWrapMode::clamp:	//Nv
			break;
		case SsTexWrapMode::repeat:	//s[g
			break;
		case SsTexWrapMode::mirror:	//~[
			break;
		}
		switch (filtermode)
		{
		case SsTexFilterMode::nearlest:	//jAXglCo[
			break;
		case SsTexFilterMode::linear:	//jAAoCjA
			break;
		}

		return rc;
	}
	
	/**
	* eNX`̉
	*/
	bool SSTextureRelese(long handle)
	{
		/// ԍŉxĂ΂̂ŁAOoȂ悤ɍ쐬ĂB
		bool rc = true;

		if ( DeleteGraph((int)handle) == -1 )
		{
			rc = false;
		}

		return rc ;
	}

	/**
	* eNX`̃TCY擾
	* eNX`UVݒ肷̂Ɏgp܂B
	*/
	bool SSGetTextureSize(long handle, int &w, int &h)
	{
		if (GetGraphSize(handle, &w, &h) == -1)
		{
			return false;
		}
		return true;
	}

	//DXCup_obt@쐬֐
	VERTEX_3D vertex3Dfrom(const ss::SSV3F_C4B_T2F &vct)
	{
		VERTEX_3D v = {
			{ vct.vertices.x, vct.vertices.y, vct.vertices.z },
			vct.colors.b, vct.colors.g, vct.colors.r, vct.colors.a,
			vct.texCoords.u, vct.texCoords.v
		};
		return v;
	}
	/**
	* XvCg̕\
	*/
	void SSDrawSprite(State state)
	{
		draw_count++;
		//Ή@\
		//Xe[^X擾AevbgtH[ɍ킹ċ@\ĂB
		//X]AY]A㉺]AJ[uhiꕔ̂݁j
		//_ό`AXTCYAYTCY
		float x = state.mat[12];	/// \W̓}gNX擾܂B
		float y = state.mat[13];	/// \W̓}gNX擾܂B
		float rotationZ = state.rotationZ;		/// ]l
		float scaleX = state.scaleX;							/// g嗦
		float scaleY = state.scaleY;							/// g嗦

		//`t@NV
		//
		switch (state.blendfunc)
		{
			case BLEND_MIX:		///< 0 uhi~bNXj
				if (state.opacity == 255)
				{
					SetDrawBlendMode(DX_BLENDMODE_NOBLEND, state.opacity);
				}
				else
				{
					SetDrawBlendMode(DX_BLENDMODE_ALPHA, state.opacity);
				}
				break;
			case BLEND_MUL:		///< 1 Z
				SetDrawBlendMode(DX_BLENDMODE_MULA, state.opacity);
				break;
			case BLEND_ADD:		///< 2 Z
				SetDrawBlendMode(DX_BLENDMODE_ADD, state.opacity);
				break;
			case BLEND_SUB:		///< 3 Z
				SetDrawBlendMode(DX_BLENDMODE_SUB, state.opacity);
				break;

		}

		if (state.flags & PART_FLAG_COLOR_BLEND)
		{
			//RGB̃J[uhݒ
			//ɍČɂ͐p̃VF[_[gAeNX`ɃJ[lKv
			//쐬ꍇssShader_frag.hACustomSpritẽRgƂȂĂVF[_[QlɂĂB
			if (state.colorBlendType == VERTEX_FLAG_ONE)
			{
				//PFJ[uh
			}
			else
			{
				//_J[uh
				//Ή
			}
			switch (state.colorBlendFunc)
			{
			case BLEND_MIX:
				break;
			case BLEND_MUL:		///< 1 Z
				// uh@͏ZȊOΉ
				// Ƃ肠̐F𔽉f
				SetDrawBright(state.quad.tl.colors.r, state.quad.tl.colors.g, state.quad.tl.colors.b);
				break;
			case BLEND_ADD:		///< 2 Z
				break;
			case BLEND_SUB:		///< 3 Z
				break;
			}
//			DrawModiGraph

		}

#ifdef UP_MINUS
		/**
		* DXCũXvCg\@\łXYgȂ̂ŁAƂ肠XXP[gp
		* Y]łȂ̂ŖΉ
		* DrawRectRotaGraphxySɂȂ悤ɁAeNX`̋`\܂B
		* DXCũXvCg\@\͏}CiXɂȂ܂B
		*/
		SetDrawBright(state.quad.bl.colors.r, state.quad.bl.colors.g, state.quad.bl.colors.b);
		DrawRectRotaGraph(
			(int)x, (int)y,	//̍W摜̒SɂȂ܂B
			(int)state.rect.origin.x, (int)state.rect.origin.y, (int)state.rect.size.width, (int)state.rect.size.height,
			scaleX, SSRadianToDegree(rotationZ),
			state.texture.handle, TRUE, state.flipX
			);
		SetDrawBright(255, 255, 255);
#else
		/**
		* DXCu3D@\gpăXvCg\܂B
		* DXCu3D@\͏vXɂȂ܂B
		* 3Dgpꍇ_gpčČƒ_ό`UVñAgr[g𔽉f鎖ł܂B
		*/
		//`p_쐬
		SSV3F_C4B_T2F_Quad quad;
		quad = state.quad;
		quad.tl.vertices.x *= scaleX;
		quad.tl.vertices.y *= scaleY;
		quad.tr.vertices.x *= scaleX;
		quad.tr.vertices.y *= scaleY;
		quad.bl.vertices.x *= scaleX;
		quad.bl.vertices.y *= scaleY;
		quad.br.vertices.x *= scaleX;
		quad.br.vertices.y *= scaleY;

		//_̉]A3D`YtȂ̂Ŋpx}CiXŌvZ
		get_uv_rotation(&quad.tl.vertices.x, &quad.tl.vertices.y, 0, 0, rotationZ);
		get_uv_rotation(&quad.tr.vertices.x, &quad.tr.vertices.y, 0, 0, rotationZ);
		get_uv_rotation(&quad.bl.vertices.x, &quad.bl.vertices.y, 0, 0, rotationZ);
		get_uv_rotation(&quad.br.vertices.x, &quad.br.vertices.y, 0, 0, rotationZ);

		quad.tl.vertices.x += x;
		quad.tl.vertices.y += y;
		quad.tr.vertices.x += x;
		quad.tr.vertices.y += y;
		quad.bl.vertices.x += x;
		quad.bl.vertices.y += y;
		quad.br.vertices.x += x;
		quad.br.vertices.y += y;

		//_J[ɃAt@ݒ
		quad.tl.colors.a = quad.bl.colors.a * state.opacity / 255;
		quad.tr.colors.a = quad.bl.colors.a * state.opacity / 255;
		quad.bl.colors.a = quad.bl.colors.a * state.opacity / 255;
		quad.br.colors.a = quad.bl.colors.a * state.opacity / 255;

		//DXCup̒_obt@쐬
		VERTEX_3D vertex[4] = {
			vertex3Dfrom(quad.tl),
			vertex3Dfrom(quad.bl),
			vertex3Dfrom(quad.tr),
			vertex3Dfrom(quad.br)
		};
		//3Dv~eBu̕\
		DrawPolygon3DBase(vertex, 4, DX_PRIMTYPE_TRIANGLESTRIP, state.texture.handle, true);
#endif

		SetDrawBlendMode(DX_BLENDMODE_NOBLEND, 0);	//uhXe[gʏ֖߂
	}

	/**
	* [U[f[^̎擾
	*/
	void SSonUserData(Player *player, UserData *userData)
	{
		//Q[փ[U[f[^ݒ肷֐ĂяoĂB
	}

	/**
	* [U[f[^̎擾
	*/
	void SSPlayEnd(Player *player)
	{
		//Q[փAjĐIݒ肷֐ĂяoĂB
	}


	/**
	* R[hϊ
	*/ 
	std::string utf8Togbk(const char *src)
	{
		int len = MultiByteToWideChar(CP_UTF8, 0, src, -1, NULL, 0);
		unsigned short * wszGBK = new unsigned short[len + 1];
		memset(wszGBK, 0, len * 2 + 2);
		MultiByteToWideChar(CP_UTF8, 0, (LPCSTR)src, -1, (LPWSTR)wszGBK, len);

		len = WideCharToMultiByte(CP_ACP, 0, (LPCWSTR)wszGBK, -1, NULL, 0, NULL, NULL);
		char *szGBK = new char[len + 1];
		memset(szGBK, 0, len + 1);
		WideCharToMultiByte(CP_ACP, 0, (LPCWSTR)wszGBK, -1, szGBK, len, NULL, NULL);
		std::string strTemp(szGBK);
		if (strTemp.find('?') != std::string::npos)
		{
			strTemp.assign(src);
		}
		delete[]szGBK;
		delete[]wszGBK;
		return strTemp;
	}

	/**
	* windowsppX`FbN
	*/ 
	bool isAbsolutePath(const std::string& strPath)
	{
		std::string strPathAscii = utf8Togbk(strPath.c_str());
		if (strPathAscii.length() > 2
			&& ((strPathAscii[0] >= 'a' && strPathAscii[0] <= 'z') || (strPathAscii[0] >= 'A' && strPathAscii[0] <= 'Z'))
			&& strPathAscii[1] == ':')
		{
			return true;
		}
		return false;
	}

};
