/*
 *	syslog.c
 *
 *	VXeO̐
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Mon Jan 18 21:37:57 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	* Thu Mar 03 21:33:11 JST 2016 Naoyuki Sawa
 *	- vONsetlogmask()syslog()̏ŌĂяoƁAÖقopenlog()sꂸAstSysLogȂoOL܂B
 *	  stSysLog.identNULL̂܂܂syslog()̏sAsyslog()strconcat()stSysLog.ident(=NULL)I[ƌȂꂻȍ~̗vfOĂ܂Ă܂B
 *	  AvONsetlogmask()syslog()̏ŌĂяoꍇAÖقopenlog()s悤ɏC܂B
 */
#include "clip.h"
/*****************************************************************************
 *	
 *****************************************************************************/
typedef struct _ST_SysLog {
	int			mask;						//O̗Dx}XNB0Ȃ΂܂openlog()Ă΂ĂȂB
	FILE*			fp;						//OL^pt@CBŏ̃bZ[WL^鎞ɊJB
	const char*		ident;						//ebZ[W̑Oɕt^镶B						Ή
	int			option;						//openlog()̓Ƃ̌syslog()̌Ăяo𐧌䂷tOB			ꕔΉ
	int			facility;					//bZ[WɋL^vÕ^CvB					Ή
} ST_SysLog;
static ST_SysLog stSysLog;
/*****************************************************************************
 *	
 *****************************************************************************/
//uLinux Programmer's Manual - SYSLOGv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/openlog.3.html)p:
//openlog()̓Oo͂悤ƂĂvO烍OL^pvO(systemlogger)ւ̐ڑJnB
//identŎw肵͊ebZ[W̑Oɕt^B
//ʏidentɂ̓vOݒ肳B
//identNULL̏ꍇAvOidentƂĎgp(POSIX.1-2008łidentNULL̏ꍇ̓͋K肳ĂȂ)B
//optiońAopenlog()̓Ƃ̌syslog()̌Ăяo𐧌䂷tOw肷B
//facilitýAsyslog()Ăяoۂfacilityw肳ȂꍇɎgpftHgl肷B						Ή
//openlog()͕K{ł͂ȂAKvɉsyslog()ĂяoB
//syslog()ĂяoꍇAident̃ftHglNULLɂȂB
void openlog(const char* ident, int option, int facility) {
	closelog();
	if(!ident) { ident = program_invocation_short_name; }			//identNULL̏ꍇAvOidentƂĎgp(POSIX.1-2008łidentNULL̏ꍇ̓͋K肳ĂȂ)B
	stSysLog.ident		= ident;					//openlog()Ăяoident́Al̂܂ܕێĂ邱ƂOɂĂB䂦AidentŎw肳ꂽ񂪕ύXƁAsyslog()͕ύXꂽ̒ǉ邾낤Aw肳ꂽ񂪑݂ȂȂꍇAʂ͖`łB
	stSysLog.option		= option;
	stSysLog.facility	= facility;
	stSysLog.mask		= -1;						//}XN̏ĺAׂĂ̗Dxɑ΂ăOWLɂȂ悤ȒlłB
	if(stSysLog.option & LOG_NDELAY) {					//optionLOG_NDELAYw肳ĂAOL^pt@C𑦍ɊJ(ʏ́Aŏ̃bZ[WL^鎞ɊJ)B
		stSysLog.fp = fopen("syslog.out", "a");
	 //sv	if(!stSysLog.fp) { DIE(); }	ˊJȂꍇ̓LOG_CONSɈˑB
	}
}
/*---------------------------------------------------------------------------*/
//uLinux Programmer's Manual - SYSLOGv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/openlog.3.html)p:
//syslog()̓ObZ[Wo͂Asyslogd̃bZ[WL^B
//priorityfacilitylevelƂ̑gŎw肷B
//cformatprintfƎX^C̏Ƃ̏ɗ^lłB
//format2%m͂̎_łerrnoɊ֘AG[bZ[W(strerror)ɂĒuB							Ή
//Kvȏꍇ͖ɉsB
void syslog(int priority, const char* format, ...) {
	va_list ap;
	va_start(ap, format);
	vsyslog(priority, format, ap);
	va_end(ap);
}
/*---------------------------------------------------------------------------*/
//uLinux Programmer's Manual - SYSLOGv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/openlog.3.html)p:
//vsyslog()֐syslog()Ɠ@\AψXgw肷邱Ƃł_قȂB
//w肳ꂽ́AstdargψXg}NpĎ擾B
void vsyslog(int priority, const char* format, va_list ap) {
	if(!stSysLog.mask) { openlog(NULL, LOG_ODELAY, LOG_USER); }		//openlog()IɌĂ΂ĂȂ΁AÖقɌĂяoB
	if(stSysLog.mask & LOG_MASK(priority)) {				//mask̊erbg͗DxɑΉĂAΉrbg1ɃZbgĂDxɑ΂ăOW(logging)LɂȂB
		//uOǗ`syslogƂ̎Ӂ`yҁzsyslogɂāv(http://www.infoscience.co.jp/technical/press/intro02.html)p:
		//<PRI>͎̕ɃOU蕪邽߂ɗp̂ŁAt@CɏoƂɂ͒ʏ͋Lq܂B
		//FreeBSDsyslogdł́A-vIvVt邱ƂŁAfacilitypriority̏OɏoƂł܂B
		//[syslogd -v ̂Ƃ]
		//Nov 11 13:33:56 <16.7> kei test[13079]: test message
		//[syslogd -v -v ̂Ƃ]
		//Nov 11 13:34:30 <local0.debug> kei test[13080]: test message
		//ł́Afacility͏oȂApriority͏oɂ܂B
		static const char* const TBL_Priority[]={
			"emerg",	//0 LOG_EMERG
			"alert",	//1 LOG_ALERT
			"crit",		//2 LOG_CRIT
			"err",		//3 LOG_ERR
			"warning",	//4 LOG_WARNING
			"notice",	//5 LOG_NOTICE
			"info",		//6 LOG_INFO
			"debug",	//7 LOG_DEBUG
		};
		/*  000000000011111P  */
		/*  012345678901234T  */
		/* "Jan 18 21:37:57\0" */
		char buf[16], *s1, *s2;
		time_t t;
		struct tm* tm;
		time(&t);
		tm = localtime(&t);
		strftime(buf, sizeof buf, "%b %d %H:%M:%S", tm);
		s1 = strdup_vprintf(format, ap);
		s2 = strconcat(
			buf,							//^CX^v
			" <",
			TBL_Priority[priority],					//Dx
			"> ",
			stSysLog.ident,						//ebZ[W̑Oɕt^镶
			": ",
			s1,							//bZ[W
			str_has_suffix(s1, "\n") ? NULL/*I[*/ : "\n",		//Kvȏꍇ͖ɉsB
			NULL/*I[(ŏI[ꍇ̓_~[)*/);
		if(!stSysLog.fp) {						//ŏ̃bZ[WL^鎞ɁAOL^pt@CJB
			stSysLog.fp = fopen("syslog.out", "a");
		 //sv	if(!stSysLog.fp) { DIE(); }	ˊJȂꍇ̓LOG_CONSɈˑB
		}
		if(stSysLog.fp) {
			fputs(s2, stSysLog.fp);					//syslogdփbZ[W𑗂B(ł̓OL^pt@C֏ށB)
#ifndef PIECE
			fflush(stSysLog.fp);					//OL^pt@C̓obt@OȂBAP/ECEł̓tbV߂Ȃ悤ɁAOL^pt@Cobt@O鎖ɂB
#endif//PIECE
		} else {
			if(stSysLog.option & LOG_CONS) { fputs(s2, stdout); }	//syslogdփbZ[W𑗂ȂꍇAoptionLOG_CONSw肳ĂAR\[ɏo͂B
		}
		if(stSysLog.option & LOG_PERROR) { fputs(s2, stderr); }		//optionLOG_PERRORw肳ĂAstderrɂo͂B(POSIX.1-2001POSIX.1-2008ł͒`ĂȂ)
		free(s1);
		free(s2);
	}
}
/*---------------------------------------------------------------------------*/
//uLinux Programmer's Manual - SYSLOGv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/openlog.3.html)p:
//closelog()̓VXẽOL^pvO(VXeK[syslogd)w̐ڑIB
//closelog()͕K{ł͂ȂB
void closelog() {
	if(stSysLog.fp) { fclose(stSysLog.fp); }
	memset(&stSysLog, 0, sizeof stSysLog);
}
/*---------------------------------------------------------------------------*/
//uLinux Programmer's Manual - SETLOGMASKv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/setlogmask.3.html)p:
//vZXɂ̓ODx}XN(logprioritymask)pӂĂāApsyslogĂяoꂽꍇɃOL^sǂ肷B
//ׂ̂Ă̊֐Ăяoꂽꍇ̓OL^sȂB
//mask̊erbg͗DxɑΉĂAΉrbg1ɃZbgĂDxɑ΂ăOW(logging)LɂȂB
//}XN̏ĺAׂĂ̗Dxɑ΂ăOWLɂȂ悤ȒlłB
//setlogmask()֐́AĂяõvZXɑ΂郍O}XNݒ肵AύXÕ}XNԂB
//mask0Ȃ΁Ã݂O}XN͕ύXȂB
int setlogmask(int mask) {
    //{{2016/03/03C:vONsetlogmask()syslog()̏ŌĂяoƁAÖقopenlog()sꂸAstSysLogȂoOL܂BstSysLog.identNULL̂܂܂syslog()̏sAsyslog()strconcat()stSysLog.ident(=NULL)I[ƌȂꂻȍ~̗vfOĂ܂Ă܂BAvONsetlogmask()syslog()̏ŌĂяoꍇAÖقopenlog()s悤ɏC܂B
    //	int old_mask = stSysLog.mask;
    //2016/03/03C:vONsetlogmask()syslog()̏ŌĂяoƁAÖقopenlog()sꂸAstSysLogȂoOL܂BstSysLog.identNULL̂܂܂syslog()̏sAsyslog()strconcat()stSysLog.ident(=NULL)I[ƌȂꂻȍ~̗vfOĂ܂Ă܂BAvONsetlogmask()syslog()̏ŌĂяoꍇAÖقopenlog()s悤ɏC܂B
	int old_mask;
	if(!stSysLog.mask) { openlog(NULL, LOG_ODELAY, LOG_USER); }		//openlog()IɌĂ΂ĂȂ΁AÖقɌĂяoB
	old_mask = stSysLog.mask;
    //}}2016/03/03C:vONsetlogmask()syslog()̏ŌĂяoƁAÖقopenlog()sꂸAstSysLogȂoOL܂BstSysLog.identNULL̂܂܂syslog()̏sAsyslog()strconcat()stSysLog.ident(=NULL)I[ƌȂꂻȍ~̗vfOĂ܂Ă܂BAvONsetlogmask()syslog()̏ŌĂяoꍇAÖقopenlog()s悤ɏC܂B
	if(mask) { stSysLog.mask = mask; }					//mask0Ȃ΁Ã݂O}XN͕ύXȂB
	return old_mask;
}
