/*	
 *	nuklear_piece.c
 *
 *	NuklearP/ECEp_OobNGh
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Sat Nov 12 09:40:37 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	  ܂IWiłNuklear̕ωāAW[pɂɕύXƎv̂ŁA܂W[̓CuɊ܂߂Ȃɂ܂B		{{2016/11/15RgǋL:W[CuɊ܂߂܂B}}
 *	  AIWiłNuklear肵ɁAW[CuɊ܂߂\łB
 *	  ܂ł̊Ԃ́ANuklear𗘗pAvP[ṼtH_ɓt@CRs[āAځAAvP[VƈꏏɃrhĉB
 *	* Sun Nov 13 21:39:44 JST 2016 Naoyuki Sawa
 *	- nk_piece_new()̒ŃJ[\[h鏈ǉ̂ŁAJ[\\悤ɂȂ܂B
 *	- ftHgX^CAP/ECẺ𑜓xɍ킹Ē܂B
 *	* Tue Nov 15 09:07:00 JST 2016 Naoyuki Sawa
 *	- P/ECEJgcc33.exeŌxô}邽߂ɁA'/clip/nuklear/nuklear.h'Vɓ񂩏ڏC܂B(ړꂩ{ړꂩł)
 *	  Cӏ́A'/clip/nuklear/nuklear.h'́u{{2016/11/15ړ:`ṽRg(񂩏)QƂĉB
 *	  C̓eŁApb`('/clip/nuklear/nuklear.h.patch')XV܂B
 *	  pb`̓Kp@ɂẮA'/clip/nuklear/nuklear_dxlib.cpp'́A'Fri Oct 21 22:24:40 JST 2016 Naoyuki Sawa'̃RgQƂĉB
 *	  ̏ĆAP/ECEJgcc33.exê߂ɍsCłAWindowsVC++ŃRpCꍇɂQ͗L܂B
 *	  A'/clip/nuklear/nuklear.h'́AP/ECEpWindowspŋʂƂĂ܂B
 *	- W[CuɊ܂߂܂B
 *	  ACu{(clip1.lib,clip2.lib,fram.lib)ɒڊ܂߂̂ł͂ȂAliblua/liblua.libƓlɁAƗCu(nuklear/nuklear_piece.lib)Ƃărh܂B
 *	  ŔANuklear̃R[h͂܂SɗoĂȂ̂ŁACLiPCuɒڊ܂߂Ă܂ƁAǗ؂ȂȂ鋰ꂪLƎvłB
 *	  ܂ANuklear̕ωɂāAP/ECEł͎gpoȂȂꍇɁACuOՂ悤ɂĂ߂ɂAƗCuƂ܂B
 *	* Thu Nov 17 21:56:29 JST 2016 Naoyuki Sawa
 *	- nk_piece_new()ɁA|bvAbv̘g\ȂbIɉ鏈ǉ܂B
 *	  2016/11/17_Nuklear(rW8e60328)ł́Ank_style_from_table()ɂāAwin->popup_border_colorwin->popup_bordeȑĂ肪L܂B
 *	  2016/11/16ɃvNGXg(https://github.com/vurtun/nuklear/pull/286)o܂A܂̗pĂȂ̂ŁA܂łŖIɏĂɂ܂B
 *	  vNGXg̗pꂽȀ͕svɂȂ̂ŁA폜ĉB	{{2016/11/21RgǋL:IWiłNuklearł|bvAbv̘g\Ȃ肪Cꂽ̂ŁAW[ōsĂbIɉ鏈͂svɂȂ̂ō폜܂B}}
 */
#include "clip.h"
/****************************************************************************
 *	
 ****************************************************************************/
#include "nuklear_piece.h"	//錾p
//{{gĂȂ֐Łuwarning: `...' defined but not usedvƂxô}܂B{̓ߖ̂߂Ɏ̂폜ׂȂ̂łAIWiłnuklear.hɑ΂đ̕ύXsȂ̂ŁAx}őË鎖ɂ܂B
static float nk_sqrt(float x) __attribute__((unused));
static float nk_sin(float x) __attribute__((unused));
static float nk_cos(float x) __attribute__((unused));
static int nk_to_upper(int c) __attribute__((unused));
static void* nk_memcopy(void* dst0, const void* src0, nk_size length) __attribute__((unused));
static void nk_memset(void* ptr, int c0, nk_size size) __attribute__((unused));
static int nk_ifloorf(float x) __attribute__((unused));
static int nk_vsnprintf(char* buf, int buf_size, const char* fmt, va_list args) __attribute__((unused));
static char* nk_file_load(const char* path, nk_size* siz, struct nk_allocator* alloc) __attribute__((unused));
//}}gĂȂ֐Łuwarning: `...' defined but not usedvƂxô}܂B{̓ߖ̂߂Ɏ̂폜ׂȂ̂łAIWiłnuklear.hɑ΂đ̕ύXsȂ̂ŁAx}őË鎖ɂ܂B
#undef  __NUKLEAR_PIECE_H__
#define NK_IMPLEMENTATION
#include "nuklear_piece.h"	//p
#undef  NK_IMPLEMENTATION
/****************************************************************************
 *	[J֐錾
 ****************************************************************************/
static void nk_piece_init_style1(struct nk_context* ctx);
static void nk_piece_init_style2(struct nk_context* ctx);
static void nk_piece_load_cursor(struct nk_context* ctx);
static void nk_piece_scissor(RENDER* render, int x, int y, int w, int h);
static void nk_piece_draw_line(RENDER* render, int x1, int y1, int x2, int y2, int line_thickness, struct nk_color col);
static void nk_piece_draw_curve(RENDER* render, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int line_thickness, struct nk_color col);
static void nk_piece_draw_rect(RENDER* render, int x, int y, int w, int h, int rounding, int line_thickness, struct nk_color col);
static void nk_piece_draw_rect_filled(RENDER* render, int x, int y, int w, int h, int rounding, struct nk_color col);
static void nk_piece_draw_rect_multi_color(RENDER* render, int x, int y, int w, int h, struct nk_color col1, struct nk_color col2, struct nk_color col3, struct nk_color col4);
static void nk_piece_draw_circle(RENDER* render, int x, int y, int w, int h, int line_thickness, struct nk_color col);
static void nk_piece_draw_circle_filled(RENDER* render, int x, int y, int w, int h, struct nk_color col);
static void nk_piece_draw_arc(RENDER* render, int cx, int cy, int r, float a1, float a2, int line_thickness, struct nk_color col);
static void nk_piece_draw_arc_filled(RENDER* render, int cx, int cy, int r, float a1, float a2, struct nk_color col);
static void nk_piece_draw_triangle(RENDER* render, int x1, int y1, int x2, int y2, int x3, int y3, int line_thickness, struct nk_color col);
static void nk_piece_draw_triangle_filled(RENDER* render, int x1, int y1, int x2, int y2, int x3, int y3, struct nk_color col);
static void nk_piece_draw_polygon(RENDER* render, const struct nk_vec2i* points, int point_count, int line_thickness, struct nk_color col);
static void nk_piece_draw_polygon_filled(RENDER* render, const struct nk_vec2i* points, int point_count, struct nk_color col);
static void nk_piece_draw_polyline(RENDER* render, const struct nk_vec2i* points, int point_count, int line_thickness, struct nk_color col);
static void nk_piece_draw_text(RENDER* render, int x, int y, int w, int h, const char* string, int len, const struct nk_user_font* font, struct nk_color bg, struct nk_color fg);
static void nk_piece_draw_image(RENDER* render, int x, int y, int w, int h, const struct nk_image* img, struct nk_color col);
static float nk_piecefont_get_text_width(nk_handle handle, float height, const char* text, int len);
/****************************************************************************
 *	\
 ****************************************************************************/
struct nk_piece {
	struct nk_context	ctx;		//ReLXg
	int			t0;		//Onk_piece_render()Ăяoꂽ
	int			scrkbd;
	int			mouse_button;
	double			mouse_pos_x;
	double			mouse_pos_y;
	double			mouse_speed;
};
/****************************************************************************
 *	O[o萔
 ****************************************************************************/
const struct nk_user_font nk_piece_font[4] = {
	{ { .id = 0 }, 10, nk_piecefont_get_text_width },	//[0]=p5x10/Sp10x10
	{ { .id = 1 }, 16, nk_piecefont_get_text_width },	//[1]=p8x16
	{ { .id = 2 },  6, nk_piecefont_get_text_width },	//[2]=p4x6
	{ { .id = 3 },  5, nk_piecefont_get_text_width },	//[3]=p4x5
};
/****************************************************************************
 *	O[o֐
 ****************************************************************************/
//CuB
NK_API struct nk_context* nk_piece_new() {
	//\̂̃mۂB
	struct nk_piece* piece = (struct nk_piece*)calloc(1, sizeof(struct nk_piece));
	if(!piece) { DIE(); }
	//ReLXgB
	nk_init_default(&piece->ctx, &nk_piece_font[3]/*p4x5*/);
	//ftHgX^Cݒ肷B
	nk_piece_init_style1(&piece->ctx);	//F̐ݒ
	nk_piece_init_style2(&piece->ctx);	//TCY̐ݒ
	//J[\[hB
	nk_piece_load_cursor(&piece->ctx);
	//Onk_piece_render()Ăяoꂽ̏lAݎƂB
	piece->t0 = pceTimerGetCount();
	//J[\̏ʒuʒƂB
	piece->mouse_pos_x = DISP_X / 2;
	piece->mouse_pos_y = DISP_Y / 2;
	nk_input_motion(&piece->ctx, piece->mouse_pos_x, piece->mouse_pos_y);
//{{2016/11/21폜:IWiłNuklearł|bvAbv̘g\Ȃ肪Cꂽ̂ŁAW[ōsĂbIɉ鏈͂svɂȂ̂ō폜܂B
////{{2016/11/17ǉ:nk_piece_new()ɁA|bvAbv̘g\ȂbIɉ鏈ǉ܂B
//	// * Thu Nov 17 21:56:29 JST 2016 Naoyuki Sawa
//	// - nk_piece_new()ɁA|bvAbv̘g\ȂbIɉ鏈ǉ܂B
//	//   2016/11/17_Nuklear(rW8e60328)ł́Ank_style_from_table()ɂāAwin->popup_border_colorwin->popup_bordeȑĂ肪L܂B
//	//   2016/11/16ɃvNGXg(https://github.com/vurtun/nuklear/pull/286)o܂A܂̗pĂȂ̂ŁA܂łŖIɏĂɂ܂B
//	//   vNGXg̗pꂽȀ͕svɂȂ̂ŁA폜ĉB
//	piece->ctx.style.window.popup_border_color = piece->ctx.style.window.border_color;
//	piece->ctx.style.window.popup_border       = piece->ctx.style.window.border;
////}}2016/11/17ǉ:nk_piece_new()ɁA|bvAbv̘g\ȂbIɉ鏈ǉ܂B
//}}2016/11/21폜:IWiłNuklearł|bvAbv̘g\Ȃ肪Cꂽ̂ŁAW[ōsĂbIɉ鏈͂svɂȂ̂ō폜܂B
	return &piece->ctx;
}
/*--------------------------------------------------------------------------*/
//CuIB
NK_API void nk_piece_free(struct nk_context* ctx) {
	struct nk_piece* piece = CONTAINING_RECORD(ctx, struct nk_piece, ctx);
	//ReLXgIB
	nk_free(&piece->ctx);
	//\̂̃B
	free(piece);
}
/*--------------------------------------------------------------------------*/
//CxgB
NK_API void nk_piece_handle_event(struct nk_context* ctx, int joy) {
	struct nk_piece* piece = CONTAINING_RECORD(ctx, struct nk_piece, ctx);
	//XN[L[{[h̕\؂ւB
	if(joy & TRG_B) {
		piece->scrkbd = !piece->scrkbd;
		//XN[L[{[h\ɂȂc
		if(piece->scrkbd) {
			//XN[L[{[hB
			// - XN[L[{[h\\ɐ؂ւxɁAXN[L[{[h鎖ɂ܂B
			//   AvP[Vʂ̗prŃXN[L[{[hgpĂmȂ̂ŁANuklearpƂĎgpJn钼Oɖ񏉊SƎvłB
			ScrKbd_Init();
		}
	}
	//XN[L[{[h\Ȃ΁c
	if(piece->scrkbd) {
		int x = 0, y = 0, KeySym, state, ctrl;
		if(piece->mouse_pos_x < (DISP_X / 2)) { x = DISP_X - 43/*ScrKbd_W*/; }
		if(piece->mouse_pos_y < (DISP_Y / 2)) { y = DISP_Y - 19/*ScrKbd_H*/; }
		ScrKbd_SetPos(x, y);
		KeySym = ScrKbd_Exec(joy, &state);
		ctrl = !!(state & (1<<1)/*Control*/);
		if((KeySym >= 0x20) && (KeySym <= 0x7F)) {
			nk_input_char(&piece->ctx, KeySym);
		} else {
			static const int TBL_KeyMap[][3/*vk,(ctrl==0),(ctrl==1)*/]={
			{XK_Shift_L	,NK_KEY_SHIFT		,NK_KEY_SHIFT		},
			{XK_Shift_R	,NK_KEY_SHIFT		,NK_KEY_SHIFT		},
			{XK_Control_L	,NK_KEY_CTRL		,NK_KEY_CTRL		},
			{XK_Control_R	,NK_KEY_CTRL		,NK_KEY_CTRL		},
			{XK_Delete	,NK_KEY_DEL		,NK_KEY_DEL		},
			{XK_Return	,NK_KEY_ENTER		,NK_KEY_ENTER		},
			{XK_Tab		,NK_KEY_TAB		,NK_KEY_TAB		},
			{XK_BackSpace	,NK_KEY_BACKSPACE	,NK_KEY_BACKSPACE	},
			{XK_Up		,NK_KEY_UP		,NK_KEY_UP		},
			{XK_Down	,NK_KEY_DOWN		,NK_KEY_DOWN		},
			{XK_Left	,NK_KEY_LEFT		,NK_KEY_TEXT_WORD_LEFT	},
			{XK_Right	,NK_KEY_RIGHT		,NK_KEY_TEXT_WORD_RIGHT	},
			{XK_Home	,NK_KEY_SCROLL_START	,NK_KEY_SCROLL_START	},	//ǉ:NK_KEY_TEXT_START
			{XK_End		,NK_KEY_SCROLL_END	,NK_KEY_SCROLL_END	},	//ǉ:NK_KEY_TEXT_END
			{XK_Next	,NK_KEY_SCROLL_DOWN	,NK_KEY_SCROLL_DOWN	},
			{XK_Prior	,NK_KEY_SCROLL_UP	,NK_KEY_SCROLL_UP	}};
			int i;
			for(i = 0; i < ARRAY_SIZE(TBL_KeyMap); i++) {
				if(TBL_KeyMap[i][0/*vk*/] == KeySym) {
					int key = TBL_KeyMap[i][1 + ctrl];
					//XN[L[{[hł̓L[Abv̏uԂooȂ̂ŁAL[_E̒Ɂc
					if(key != -1) { nk_input_key(&piece->ctx, (enum nk_keys)key, 1/*down*/); }
					if(KeySym == XK_Home) { nk_input_key(&piece->ctx, NK_KEY_TEXT_START, 1/*down*/); }	//ǉ
					if(KeySym == XK_End)  { nk_input_key(&piece->ctx, NK_KEY_TEXT_END,   1/*down*/); }	//ǉ
					//cL[Abvꂽ̂Ƃď鎖ɂ܂B
					if(key != -1) { nk_input_key(&piece->ctx, (enum nk_keys)key, 0/*up*/); }
					if(KeySym == XK_Home) { nk_input_key(&piece->ctx, NK_KEY_TEXT_START, 0/*up*/); }	//ǉ
					if(KeySym == XK_End)  { nk_input_key(&piece->ctx, NK_KEY_TEXT_END,   0/*up*/); }	//ǉ
				}
			}
		}
	//XN[L[{[h\łȂ΁c
	} else {
		int trg = piece->mouse_button ^ joy;
		          piece->mouse_button = joy;
		if(trg & PAD_A) {
			nk_input_button(&piece->ctx, NK_BUTTON_LEFT, piece->mouse_pos_x, piece->mouse_pos_y, !!(joy & PAD_A));
		}
		if(joy & PAD_LRUD) {
			piece->mouse_speed += piece->ctx.delta_time_seconds * 2.0/**/;	//
			piece->mouse_speed = clamp(piece->mouse_speed, 1.0, 3.0/**/);
			if(joy & PAD_LF) { piece->mouse_pos_x -= piece->mouse_speed; }
			if(joy & PAD_RI) { piece->mouse_pos_x += piece->mouse_speed; }
			if(joy & PAD_UP) { piece->mouse_pos_y -= piece->mouse_speed; }
			if(joy & PAD_DN) { piece->mouse_pos_y += piece->mouse_speed; }
			piece->mouse_pos_x = clamp(piece->mouse_pos_x, 0.0, DISP_X - 1.0);
			piece->mouse_pos_y = clamp(piece->mouse_pos_y, 0.0, DISP_Y - 1.0);
			nk_input_motion(&piece->ctx, piece->mouse_pos_x, piece->mouse_pos_y);
		} else {
			piece->mouse_speed = 0.0;	//xZbgB
		}
	}
}
/*--------------------------------------------------------------------------*/
//݂̃ReLXg`悷B
NK_API void nk_piece_render(struct nk_context* ctx, struct _RENDER* render) {
	struct nk_piece* piece = CONTAINING_RECORD(ctx, struct nk_piece, ctx);
	//Onk_piece_render()Ăяoꂽ́AoߎԂi[B
	{
		int t1 = pceTimerGetCount();
		piece->ctx.delta_time_seconds = (t1 - piece->t0) / 1000.0f;
		piece->t0 = t1;
	}
	{
		const struct nk_command* cmd;
		//NbsÖޔB
		int save_left   = render->left;
		int save_top    = render->top;
		int save_right  = render->right;
		int save_bottom = render->bottom;
		//݂̃ReLXǵAeR}h`悷B
		nk_foreach(cmd, &piece->ctx) {
			switch(cmd->type) {
			default:
				{
					syslog(LOG_NOTICE, "nk_piece_render: unknown nk_command_type(%d)", cmd->type);
				}
				break;
			case NK_COMMAND_NOP:
				{
					/** no job **/
				}
				break;
			case NK_COMMAND_SCISSOR:
				{
					const struct nk_command_scissor* p = (const struct nk_command_scissor*)cmd;
					nk_piece_scissor(render,
						p->x,
						p->y,
						p->w,
						p->h);
				}
				break;
			case NK_COMMAND_LINE:
				{
					const struct nk_command_line* p = (const struct nk_command_line*)cmd;
					nk_piece_draw_line(render,
						p->begin.x,
						p->begin.y,
						p->end.x,
						p->end.y,
						p->line_thickness,
						p->color);
				}
				break;
			case NK_COMMAND_CURVE:
				{
					const struct nk_command_curve* p = (const struct nk_command_curve*)cmd;
					nk_piece_draw_curve(render,
						p->begin.x,
						p->begin.y,
						p->ctrl[0].x,
						p->ctrl[0].y,
						p->ctrl[1].x,
						p->ctrl[1].y,
						p->end.x,
						p->end.y,
						p->line_thickness,
						p->color);
				}
				break;
			case NK_COMMAND_RECT:
				{
					const struct nk_command_rect* p = (const struct nk_command_rect*)cmd;
					nk_piece_draw_rect(render,
						p->x,
						p->y,
						p->w,
						p->h,
						p->rounding,
						p->line_thickness,
						p->color);
				}
				break;
			case NK_COMMAND_RECT_FILLED:
				{
					const struct nk_command_rect_filled* p = (const struct nk_command_rect_filled*)cmd;
					nk_piece_draw_rect_filled(render,
						p->x,
						p->y,
						p->w,
						p->h,
						p->rounding,
						p->color);
				}
				break;
			case NK_COMMAND_RECT_MULTI_COLOR:
				{
					const struct nk_command_rect_multi_color* p = (const struct nk_command_rect_multi_color*)cmd;
					nk_piece_draw_rect_multi_color(render,
						p->x,
						p->y,
						p->w,
						p->h,
						p->left,
						p->top,
						p->bottom,
						p->right);
				}
				break;
			case NK_COMMAND_CIRCLE:
				{
					const struct nk_command_circle* p = (const struct nk_command_circle*)cmd;
					nk_piece_draw_circle(render,
						p->x,
						p->y,
						p->w,
						p->h,
						p->line_thickness,
						p->color);
				}
				break;
			case NK_COMMAND_CIRCLE_FILLED:
				{
					const struct nk_command_circle_filled* p = (const struct nk_command_circle_filled*)cmd;
					nk_piece_draw_circle_filled(render,
						p->x,
						p->y,
						p->w,
						p->h,
						p->color);
				}
				break;
			case NK_COMMAND_ARC:
				{
					const struct nk_command_arc* p = (const struct nk_command_arc*)cmd;
					nk_piece_draw_arc(render,
						p->cx,
						p->cy,
						p->r,
						p->a[0],
						p->a[1],
						p->line_thickness,
						p->color);
				}
				break;
			case NK_COMMAND_ARC_FILLED:
				{
					const struct nk_command_arc_filled* p = (const struct nk_command_arc_filled*)cmd;
					nk_piece_draw_arc_filled(render,
						p->cx,
						p->cy,
						p->r,
						p->a[0],
						p->a[1],
						p->color);
				}
				break;
			case NK_COMMAND_TRIANGLE:
				{
					const struct nk_command_triangle* p = (const struct nk_command_triangle*)cmd;
					nk_piece_draw_triangle(render,
						p->a.x,
						p->a.y,
						p->b.x,
						p->b.y,
						p->c.x,
						p->c.y,
						p->line_thickness,
						p->color);
				}
				break;
			case NK_COMMAND_TRIANGLE_FILLED:
				{
					const struct nk_command_triangle_filled* p = (const struct nk_command_triangle_filled*)cmd;
					nk_piece_draw_triangle_filled(render,
						p->a.x,
						p->a.y,
						p->b.x,
						p->b.y,
						p->c.x,
						p->c.y,
						p->color);
				}
				break;
			case NK_COMMAND_POLYGON:
				{
					const struct nk_command_polygon* p = (const struct nk_command_polygon*)cmd;
					nk_piece_draw_polygon(render,
						p->points,
						p->point_count,
						p->line_thickness,
						p->color);
				}
				break;
			case NK_COMMAND_POLYGON_FILLED:
				{
					const struct nk_command_polygon_filled* p = (const struct nk_command_polygon_filled*)cmd;
					nk_piece_draw_polygon_filled(render,
						p->points,
						p->point_count,
						p->color);
				}
				break;
			case NK_COMMAND_POLYLINE:
				{
					const struct nk_command_polyline* p = (const struct nk_command_polyline*)cmd;
					nk_piece_draw_polyline(render,
						p->points,
						p->point_count,
						p->line_thickness,
						p->color);
				}
				break;
			case NK_COMMAND_TEXT:
				{
					const struct nk_command_text* p = (const struct nk_command_text*)cmd;
					nk_piece_draw_text(render,
						p->x,
						p->y,
						p->w,
						p->h,
						p->string,
						p->length,
						p->font,
						p->background,
						p->foreground);
				}
				break;
			case NK_COMMAND_IMAGE:
				{
					const struct nk_command_image* p = (const struct nk_command_image*)cmd;
					nk_piece_draw_image(render,
						p->x,
						p->y,
						p->w,
						p->h,
						&p->img,
						p->col);
				}
				break;
			}
		}
		//NbsÖ𕜋AB
		render->left   = save_left;
		render->top    = save_top;
		render->right  = save_right;
		render->bottom = save_bottom;
	}
	//݂̃ReLXǵAR}hNAB
	nk_clear(&piece->ctx);
	//XN[L[{[h\Ȃ΁c
	if(piece->scrkbd) {
		//XN[L[{[h`悷B
		ScrKbd_Draw(render);
	}
}
/****************************************************************************
 *	[J֐
 ****************************************************************************/
//ftHgX^Cݒ肷B(F̐ݒ)
static void nk_piece_init_style1(struct nk_context* ctx) {
	static const unsigned char TBL_ColTbl[NK_COLOR_COUNT]={
		3,	//NK_COLOR_TEXT				//̐F								SẴEChEEBWbgɋʂłB
		0,	//NK_COLOR_WINDOW			//EChE̔wiF
		1,	//NK_COLOR_HEADER			//^Cgo[̐F
		2,	//NK_COLOR_BORDER			//{[_[̐F								SẴEChEEBWbgɋʂłB
		1,	//NK_COLOR_BUTTON			//{^̔wiF		}EXJ[\ɖ
		0,	//NK_COLOR_BUTTON_HOVER			//{^̔wiF		}EXJ[\ɗL鎞
		2,	//NK_COLOR_BUTTON_ACTIVE		//{^̔wiF		}EX{^Ă
		1,	//NK_COLOR_TOGGLE			//lp̐̕F		}EXJ[\ɖ		x̔̕wiFɂ͊֌WL܂B
		1,	//NK_COLOR_TOGGLE_HOVER			//lp̐̕F		}EXJ[\ɗL鎞		x̔̕wiFɂ͊֌WL܂B
		2,	//NK_COLOR_TOGGLE_CURSOR		//lp̐̕F		Iɂ̎lp̒S̐F
		1,	//NK_COLOR_SELECT			//I{^̔wiF
		2,	//NK_COLOR_SELECT_ACTIVE		//I{^̔wiF
		1,	//NK_COLOR_SLIDER			//܂݂Ẽo[̐F						vOXo[̐FꎮXC_̐FꎮQƂB
		2,	//NK_COLOR_SLIDER_CURSOR		//܂݂̐F			}EXJ[\ɖ		܂݂̃o[̐F̐FłB
		2,	//NK_COLOR_SLIDER_CURSOR_HOVER		//܂݂̐F			}EXJ[\ɗL鎞
		2,	//NK_COLOR_SLIDER_CURSOR_ACTIVE		//܂݂̐F			}EX{^Ă		Ǝv̂ۂɂNK_COLOR_SLIDER_CURSOR_HOVER̐F̂܂܂ɂȂ(?)
		1,	//NK_COLOR_PROPERTY			//vpeB̔wiF
		1,	//NK_COLOR_EDIT				//GfBbg̔wiF
		2,	//NK_COLOR_EDIT_CURSOR			//									QƂĂȂ(?)J[\̐FNK_COLOR_TEXTg悤łB
		1,	//NK_COLOR_COMBO			//̔wiF							J̔wiFNK_COLOR_WINDOWg悤łB
		0,	//NK_COLOR_CHART			//`[g̔wiF
		2,	//NK_COLOR_CHART_COLOR			//_Ot܂Ot̐F	}EXJ[\ɖ
		2,	//NK_COLOR_CHART_COLOR_HIGHLIGHT	//_Ot܂Ot̐F	}EXJ[\ɗL鎞
		1,	//NK_COLOR_SCROLLBAR			//o[̔wiF
		2,	//NK_COLOR_SCROLLBAR_CURSOR		//܂݂̐F			}EXJ[\ɖ
		2,	//NK_COLOR_SCROLLBAR_CURSOR_HOVER	//܂݂̐F			}EXJ[\ɗL鎞
		2,	//NK_COLOR_SCROLLBAR_CURSOR_ACTIVE	//܂݂̐F			}EX{^Ă
		1,	//NK_COLOR_TAB_HEADER			//c[̃^u̐F
	};
	struct nk_color table[NK_COLOR_COUNT];
	int i;
	for(i = 0; i < NK_COLOR_COUNT; i++) {
		table[i] = nk_rgb(TBL_ColTbl[i],
		                  TBL_ColTbl[i],
		                  TBL_ColTbl[i]);
	}
	nk_style_from_table(ctx, table);
}
/*--------------------------------------------------------------------------*/
//ftHgX^Cݒ肷B(TCY̐ݒ)
static void nk_piece_init_style2(struct nk_context* ctx) {
	static const struct nk_vec2 v0 = { 0, 0 };
	static const struct nk_vec2 v1 = { 1, 1 };
	static const struct nk_vec2 v5 = { 5, 5 };
	struct nk_style* style = &ctx->style;
	//default text
	style->text.padding					= v0;					//x͐FXȏŎgp̂łꎩ̂ɃpfBO͐ݒ肵ȂB
	//default button
	style->button.border					= 1;					//1ɂׂ(?)
	style->button.rounding					= 0;
	style->button.padding					= v1;					//{^̃x̓Z^ÔŃpfBO͊֌WAꉞpfBOݒ肵ĂɂB
	style->button.image_padding				= v0;
	style->button.touch_padding				= v0;
	//contextual button
	style->contextual_button.border				= 1;
	style->contextual_button.rounding			= 0;
	style->contextual_button.padding			= v1;
	style->contextual_button.image_padding			= v0;
	style->contextual_button.touch_padding			= v0;
	//menu button
	style->menu_button.border				= 0;					//Nuklear̃j[̓tbgfUCȂ̂ŁA{[_[pfBO0ɂ̂B
	style->menu_button.rounding				= 0;
	style->menu_button.padding				= v0;
	style->menu_button.image_padding			= v0;
	style->menu_button.touch_padding			= v0;
	//option toggle
	style->option.padding					= v1;					//O̎lp̎lpւ̃pfBO
	style->option.touch_padding				= v0;
	style->option.spacing					= 1;					//O̎lpƉẼx̊Ԃ̃Xy[VO
	style->option.border					= 0;					//0ɂׂ(?)
	//checkbox toggle
	style->checkbox.padding					= v1;					//O̊ۂ̊ۂւ̃pfBO
	style->checkbox.touch_padding				= v0;
	style->checkbox.spacing					= 1;					//O̊ۂƉẼx̊Ԃ̃Xy[VO
	style->checkbox.border					= 0;					//0ɂׂ(?)
	//selectable
	style->selectable.rounding				= 0;
	style->selectable.padding				= v1;					//O̎lpƓ̃x̊Ԃ̃pfBOBI{^͍Ȃ̂ŃpfBOKvB
	style->selectable.touch_padding				= v0;
	style->selectable.image_padding				= v0;
	//slider
	style->slider.border					= 0;					//QƂĂȂ(?)
	style->slider.rounding					= 0;
	style->slider.bar_height				= 0;					//QƂĂȂ(?)
	style->slider.padding					= v0;					//0ɂׂ(?)Bo[͏㉺Z^O邩svApfBO傫ƃo[̃TCYcȂďĂ܂L邩B
	style->slider.spacing					= v0;
	style->slider.cursor_size				= nk_vec2(5,5);
	style->slider.show_buttons				= nk_false;
	//progressbar
	style->progress.rounding				= 0;
	style->progress.border					= 0;					//0ɂׂ(?)
	style->progress.cursor_border				= 0;
	style->progress.cursor_rounding				= 0;
	style->progress.padding					= v1;					//O̎lp̎lpւ̃pfBO
	//property
	style->property.border					= 0;					//0ɂׂ(?)
	style->property.rounding				= 0;
	style->property.padding					= v1;					//̃{^烉x,y,Ẽ{^GfBbg̊Ԃ̃pfBO
	//property edit
	style->property.edit.border				= 0;					//0ɂׂ(?)
	style->property.edit.rounding				= 0;
	style->property.edit.cursor_size			= 2;					//ʂǂȂ(?)
	style->property.edit.scrollbar_size			= v5;					//ʂǂȂ(?)
	style->property.edit.padding				= v0;
	style->property.edit.row_padding			= 0;
	//property buttons
	style->property.inc_button.border			= 0;					//0ɂׂ(?)
	style->property.inc_button.rounding			= 0;
	style->property.inc_button.padding			= v0;
	style->property.inc_button.image_padding		= v0;
	style->property.inc_button.touch_padding		= v0;
	style->property.dec_button				= style->property.inc_button;		//Rs[
	//edit
	style->edit.border					= 0;					//0ɂׂ(?)
	style->edit.rounding					= 0;
	style->edit.cursor_size					= 2;					//ʂǂȂ(?)
	style->edit.scrollbar_size				= v5;
	style->edit.padding					= v1;					//GfBbg̈̊ÕeLXgւ̃pfBOBKvłB
	style->edit.row_padding					= 0;
	//edit scrollbar
	style->edit.scrollbar.border				= 0;					//0ɂׂ(?)
	style->edit.scrollbar.rounding				= 0;
	style->edit.scrollbar.border_cursor			= 0;
	style->edit.scrollbar.rounding_cursor			= 0;
	style->edit.scrollbar.padding				= v1;					//O̎lp̎lpւ̃pfBO
	style->edit.scrollbar.show_buttons			= nk_false;				//㉺̃{^͖ĂȂ̂ŕ\ȂɂB
	//chart
	style->chart.border					= 1;					//1ɂׂ(?)
	style->chart.rounding					= 0;
	style->chart.padding					= v0;					//_OťX̖_̊Ԃ̃pfBOBP/ECE͉𑜓xႢ̂(0,0)ɂ̂ǂB(0,0)ɂĂ1sNZ炢Ԋu󂭂݂BƂ̃tB[h͖_̓̃pfBOĂāA_Ɩ_̊Ԃ͏1sNZ󂭂̂ȂB
	//scrollbars
	style->scrollh.border					= 0;					//0ɂׂ(?)
	style->scrollh.rounding					= 0;
	style->scrollh.border_cursor				= 0;
	style->scrollh.rounding_cursor				= 0;
	style->scrollh.padding					= v0;					//O̎lp̎lpւ̃pfBOB0ɂׂ(?)BXN[o[́A̍sŎw肷pfBO0ɂĂ̂Öق̃pfBO1sNZ悤ŁAIȃpfBOw肷ƃo[̃TCYcȂďĂ܂B(̂XN[o[̖肪)
	style->scrollh.show_buttons				= nk_false;				//㉺̃{^͖ĂȂ̂ŕ\ȂɂB
	style->scrollv						= style->scrollh;			//Rs[
	//tab
	style->tab.border					= 1;					//1ɂׂ(?)
	style->tab.rounding					= 0;
	style->tab.indent					= 2;
	style->tab.padding					= v1;
	style->tab.spacing					= v0;
	//tab button
	style->tab.tab_minimize_button.border			= 0;					//0ɂׂ(?)
	style->tab.tab_minimize_button.rounding			= 0;
	style->tab.tab_minimize_button.padding			= v1;					//[̎Op{^̃pfBOB(0,0)ɂƎOp傫Čĥ(1,1)ǂB
	style->tab.tab_minimize_button.image_padding		= v0;
	style->tab.tab_minimize_button.touch_padding		= v0;
	style->tab.tab_maximize_button				= style->tab.tab_minimize_button;	//Rs[
	//node button
	style->tab.node_minimize_button.border			= 0;					//0ɂׂ(?)
	style->tab.node_minimize_button.rounding		= 0;
	style->tab.node_minimize_button.padding			= v1;					//[̎Op{^̃pfBOB(0,0)ɂƎOp傫Čĥ(1,1)ǂB
	style->tab.node_minimize_button.image_padding		= v0;
	style->tab.node_minimize_button.touch_padding		= v0;
	style->tab.node_maximize_button				= style->tab.node_minimize_button;	//Rs[
	//combo
	style->combo.border					= 1;					//1ɂׂ(?)
	style->combo.rounding					= 0;
	style->combo.content_padding				= v1;					//sڂ̃x̃pfBOBsڂ̃x͍Ȃ̂ŃpfBOKvB
	style->combo.button_padding				= v1;					//sڂ̉E[̎Op{^̃pfBOB(0,0)ɂƎOp傫Čĥ(1,1)ǂB	style->combo.button_paddingstyle->combo.button.padding𗼕ݒ肵ȂƏ肭\Ȃ݂(?)
	style->combo.spacing					= v0;
	//combo button
	style->combo.button.border				= 0;
	style->combo.button.rounding				= 0;
	style->combo.button.padding				= v1;					//sڂ̉E[̎Op{^̃pfBOB(0,0)ɂƎOp傫Čĥ(1,1)ǂB	style->combo.button_paddingstyle->combo.button.padding𗼕ݒ肵ȂƏ肭\Ȃ݂(?)
	style->combo.button.image_padding			= v0;
	style->combo.button.touch_padding			= v0;
	//window
	style->window.border					= 1;
	style->window.combo_border				= 1;
	style->window.contextual_border				= 1;
	style->window.menu_border				= 1;
	style->window.group_border				= 1;
	style->window.tooltip_border				= 1;
	style->window.popup_border				= 1;
	style->window.rounding					= 0;
	style->window.spacing					= v1;
	style->window.scrollbar_size				= v5;					//
	style->window.min_size					= nk_vec2(16,16);			//
	style->window.padding					= v1;
	style->window.group_padding				= v1;
	style->window.popup_padding				= v1;
	style->window.combo_padding				= v1;
	style->window.contextual_padding			= v1;
	style->window.menu_padding				= v1;
	style->window.tooltip_padding				= v1;
	//window header
	style->window.header.padding				= v1;
	style->window.header.label_padding			= v1;
	style->window.header.spacing				= v0;
	//window header close button
	style->window.header.close_button.border		= 0;					//ŏ{^̓eLXgŕ\̂Ń{[_[pfBO͂܂֌WȂB
	style->window.header.close_button.rounding		= 0;
	style->window.header.close_button.padding		= v0;
	style->window.header.close_button.image_padding		= v0;
	style->window.header.close_button.touch_padding		= v0;
	//window header minimize button
	style->window.header.minimize_button.border		= 0;					//ŏ{^̓eLXgŕ\̂Ń{[_[pfBO͂܂֌WȂB
	style->window.header.minimize_button.rounding		= 0;
	style->window.header.minimize_button.padding		= v0;
	style->window.header.minimize_button.image_padding	= v0;
	style->window.header.minimize_button.touch_padding	= v0;
}
/*--------------------------------------------------------------------------*/
//J[\[hB
static void nk_piece_load_cursor(struct nk_context* ctx) {
	//'/clip/nuklear/keep/makefile'g'/clip/nuklear/keep/nk_custom_cursor_data-2m.bmp'ϊĐ܂B
	static const unsigned char NK_CUSTOM_CURSOR_DATA[] = {
	0x50,0x4d,0x42,0x50,0x4f,0x01,0x00,0x00,0x02,0x01,0x38,0x00,0x0f,0x00,0x00,0x00,0x3b,0x01,0x00,0x00,
	/*buf*/
	0x00,0x03,0xff,0x03,0x00,0x00,0x30,0x00,0x3f,0xf0,0x00,0x03,0xff,0x00,
	0x00,0x03,0x03,0x0c,0xc0,0x00,0xcc,0x00,0x30,0x30,0x00,0x03,0x03,0x00,
	0xc0,0x03,0xcf,0x30,0x30,0x03,0x03,0x00,0x30,0xc0,0x00,0x00,0xc3,0x00,
	0xf0,0x00,0xcc,0x3c,0xf0,0x03,0xcf,0x00,0x33,0x30,0x00,0x03,0x33,0x00,
	0xcc,0x00,0xcc,0x0c,0xc0,0x3c,0xcc,0xf0,0x3c,0xcc,0xf3,0xcc,0xcf,0x00,
	0xc3,0x00,0xcc,0x0c,0xc0,0xcf,0xcf,0xcc,0x00,0x33,0x33,0x33,0x00,0x00,
	0xc0,0xc3,0xcf,0x0c,0xc3,0x00,0x00,0x03,0x00,0x0c,0x33,0x0c,0x00,0x00,
	0xc0,0x33,0x03,0x0c,0xc0,0xcf,0xcf,0xcc,0x00,0x30,0x33,0x03,0x00,0x00,
	0xc0,0xf3,0xff,0x0c,0xc0,0x3c,0xcc,0xf0,0x00,0x3f,0xf3,0xff,0x00,0x00,
	0xcc,0xc0,0x00,0x3c,0xf0,0x03,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xf3,0x30,0x00,0x30,0x30,0x03,0x03,0x00,0x03,0xc0,0x0f,0x00,0x00,0x00,
	0x03,0x30,0x00,0x0c,0xc0,0x00,0xcc,0x00,0x0c,0xff,0xfc,0xc0,0x00,0x00,
	0x00,0xc0,0x00,0x03,0x00,0x00,0x30,0x00,0x30,0x00,0x00,0x30,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0xff,0xfc,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xc0,0x0f,0x00,0x00,0x00,
	/*mask*/
	0x81,0xf1,0x00,0x40,0x7c,0x01,0xf0,
	0x01,0xf3,0x80,0xe0,0x7c,0x01,0xf0,
	0x81,0xf7,0xc1,0xf0,0x78,0x00,0xf0,
	0xc0,0xe7,0xc1,0xf0,0x7c,0x01,0xf0,
	0xe0,0xe3,0x86,0xec,0x6e,0xdb,0xb0,
	0xf0,0xe3,0x8f,0xfe,0x07,0xdf,0x00,
	0xf9,0xf3,0x9f,0xff,0x03,0xde,0x00,
	0xfd,0xf3,0x8f,0xfe,0x07,0xdf,0x00,
	0xfd,0xf3,0x86,0xec,0x07,0xdf,0x00,
	0xf8,0x07,0xc1,0xf0,0x00,0x00,0x00,
	0xdc,0x07,0xc1,0xf0,0x18,0x30,0x00,
	0x1c,0x03,0x80,0xe0,0x3f,0xf8,0x00,
	0x08,0x01,0x00,0x40,0x7f,0xfc,0x00,
	0x00,0x00,0x00,0x00,0x3f,0xf8,0x00,
	0x00,0x00,0x00,0x00,0x18,0x30,0x00,
	};
	//nuklear.hnk_font_atlas_bake()ɂč쐬܂B
	static const unsigned char nk_cursor_data[/*NK_CURSOR_COUNT*/][3/*Pos,Size,Offset*/][2/*x,y*/]={
	{{ 0, 2},{ 6,11},{ 0, 0}},	//NK_CURSOR_ARROW
	{{ 7, 0},{ 5, 9},{ 2, 4}},	//NK_CURSOR_TEXT
	{{19, 0},{13,13},{ 6, 6}},	//NK_CURSOR_MOVE
	{{13, 0},{ 5,13},{ 2, 6}},	//NK_CURSOR_RESIZE_VERTICAL
	{{33,10},{13, 5},{ 6, 2}},	//NK_CURSOR_RESIZE_HORIZONTAL
	{{43, 0},{ 9, 9},{ 4, 4}},	//NK_CURSOR_RESIZE_TOP_LEFT_DOWN_RIGHT
	{{33, 0},{ 9, 9},{ 4, 4}}};	//NK_CURSOR_RESIZE_TOP_RIGHT_DOWN_LEFT
	static_assert(((sizeof nk_cursor_data)/(sizeof nk_cursor_data[0])) == NK_CURSOR_COUNT, "nk_cursor_data[]̗vfsłB");
	static struct nk_cursor cursors[NK_CURSOR_COUNT]; /* J[\`̔zArs`shbłI */	//Nuklear̃ReLXg̓J[\`̔zRs[Ƀ|C^ŎQƂ̂ŁAstaticƂKvLBCX^X쐬ꍇASẴCX^Xŋpo܂B
	static TEXTURE texture; /* eNX``Ars`shbłI */
	texture_init(&texture, NK_CUSTOM_CURSOR_DATA);	//YȂ!!
	//J[\`̔zB
	// - ֐Ăяoꂽꍇ(CX^Xɑ΂ăJ[\[hꍇȂ)AJ[\`̔z͋p̂ŁAJ[\`̔z鏈͍ŏ̈񂾂ł\Ȃ̂łAȒPɂ邽߂ɖ񏉊鎖ɂ܂B
	//   xĂʂ͓ɂȂ܂A\[X[NȂA܂A֐͕pɂɌĂяôł͂Ȃ̂ŁAʂȏsĂ\̒ቺƂȂȂłB
	{
		int i;
		for(i = 0; i < NK_CURSOR_COUNT; ++i) {
			int PosX		= nk_cursor_data[i][0][0];
			int PosY		= nk_cursor_data[i][0][1];
			int SizeX		= nk_cursor_data[i][1][0];
			int SizeY		= nk_cursor_data[i][1][1];
			int OffsetX		= nk_cursor_data[i][2][0];
			int OffsetY		= nk_cursor_data[i][2][1];
			cursors[i].img		= nk_subimage_ptr(&texture, SizeX, SizeY, nk_rect(PosX, PosY, SizeX, SizeY));
			cursors[i].size		= nk_vec2(SizeX, SizeY);
			cursors[i].offset	= nk_vec2(OffsetX, OffsetY);
		}
		nk_style_load_all_cursors(ctx, cursors);	//nk_style_load_all_cursors()Ank_style_show_cursor()̌ʂ܂ł܂B
	}
}
/*--------------------------------------------------------------------------*/
static void nk_piece_scissor(RENDER* render, int x, int y, int w, int h) {
	SURFACE* surface = render->surface;
	render->left   = clamp(x,     0, (int)surface->w);
	render->top    = clamp(y,     0, (int)surface->h);
	render->right  = clamp(x + w, 0, (int)surface->w);
	render->bottom = clamp(y + h, 0, (int)surface->h);
}
/*--------------------------------------------------------------------------*/
//݂̎ł́Aline_thickness𖳎Ă܂B
static void nk_piece_draw_line(RENDER* render, int x1, int y1, int x2, int y2, int line_thickness, struct nk_color col) {
	render_line(render,
		x1,
		y1,
		x2,
		y2,
		col.r);
}
/*--------------------------------------------------------------------------*/
//{̓xWFȐ`KvL̂łA݂̎ł́An_(x1,y1),_(x2,y2),_(x3,y3),I_(x4,y4)𒼐Ōł܂B
static void nk_piece_draw_curve(RENDER* render, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int line_thickness, struct nk_color col) {
	render_line(render,
		x1,
		y1,
		x2,
		y2,
		col.r);
	render_line(render,
		x2,
		y2,
		x3,
		y3,
		col.r);
	render_line(render,
		x3,
		y3,
		x4,
		y4,
		col.r);
}
/*--------------------------------------------------------------------------*/
//݂̎ł́Aroundingline_thickness𖳎Ă܂B
static void nk_piece_draw_rect(RENDER* render, int x, int y, int w, int h, int rounding, int line_thickness, struct nk_color col) {
	render_rectangle(render,
		x,
		y,
		w,
		h,
		col.r);
}
/*--------------------------------------------------------------------------*/
//݂̎ł́Arounding𖳎Ă܂B
static void nk_piece_draw_rect_filled(RENDER* render, int x, int y, int w, int h, int rounding, struct nk_color col) {
	render_rectangle_fill(render,
		x,
		y,
		w,
		h,
		col.r);
}
/*--------------------------------------------------------------------------*/
//{̓Of[Vœhׂ``KvL̂łA݂̎ł́APFœhׂ``Ă܂B
static void nk_piece_draw_rect_multi_color(RENDER* render, int x, int y, int w, int h, struct nk_color col1, struct nk_color col2, struct nk_color col3, struct nk_color col4) {
	nk_piece_draw_rect_filled(render,
		x,
		y,
		w,
		h,
		0,
		col1);
}
/*--------------------------------------------------------------------------*/
//݂̎ł́Aline_thickness𖳎Ă܂B
static void nk_piece_draw_circle(RENDER* render, int x, int y, int w, int h, int line_thickness, struct nk_color col) {
	render_ellipse(render,
		x,
		y,
		w,
		h,
		col.r);
}
/*--------------------------------------------------------------------------*/
static void nk_piece_draw_circle_filled(RENDER* render, int x, int y, int w, int h, struct nk_color col) {
	render_ellipse_fill(render,
		x,
		y,
		w,
		h,
		col.r);
}
/*--------------------------------------------------------------------------*/
//{͉~ʂ`KvL̂łA݂̎ł́AS~`Ă܂B
static void nk_piece_draw_arc(RENDER* render, int cx, int cy, int r, float a1, float a2, int line_thickness, struct nk_color col) {
	nk_piece_draw_circle(render,
		cx - r,
		cy - r,
		r << 1,
		r << 1,
		line_thickness,
		col);
}
/*--------------------------------------------------------------------------*/
//{͉~ʂ`KvL̂łA݂̎ł́AS~`Ă܂B
static void nk_piece_draw_arc_filled(RENDER* render, int cx, int cy, int r, float a1, float a2, struct nk_color col) {
	nk_piece_draw_circle_filled(render,
		cx - r,
		cy - r,
		r << 1,
		r << 1,
		col);
}
/*--------------------------------------------------------------------------*/
static void nk_piece_draw_triangle(RENDER* render, int x1, int y1, int x2, int y2, int x3, int y3, int line_thickness, struct nk_color col) {
	struct nk_vec2i points[3] = {
		{ x1, y1 },
		{ x2, y2 },
		{ x3, y3 }
	};
	nk_piece_draw_polygon(render,
		points,
		3,
		line_thickness,
		col);
}
/*--------------------------------------------------------------------------*/
static void nk_piece_draw_triangle_filled(RENDER* render, int x1, int y1, int x2, int y2, int x3, int y3, struct nk_color col) {
	struct nk_vec2i points[3] = {
		{ x1, y1 },
		{ x2, y2 },
		{ x3, y3 }
	};
	nk_piece_draw_polygon_filled(render,
		points,
		3,
		col);
}
/*--------------------------------------------------------------------------*/
//݂̎ł́Aline_thickness𖳎Ă܂B
static void nk_piece_draw_polygon(RENDER* render, const struct nk_vec2i* points, int point_count, int line_thickness, struct nk_color col) {
	vec2i v[16/**/];
	int i;
	if((unsigned)point_count > (unsigned)ARRAY_SIZE(v)) { DIE(); }
	for(i = 0; i < point_count; i++) {
		v[i].x = points[i].x;
		v[i].y = points[i].y;
	}
	render_vec2i_render_polygon(render,
		v,
		point_count,
		col.r);
}
/*--------------------------------------------------------------------------*/
static void nk_piece_draw_polygon_filled(RENDER* render, const struct nk_vec2i* points, int point_count, struct nk_color col) {
	vec2i v[16/**/];
	int i;
	if((unsigned)point_count > (unsigned)ARRAY_SIZE(v)) { DIE(); }
	for(i = 0; i < point_count; i++) {
		v[i].x = points[i].x;
		v[i].y = points[i].y;
	}
	render_vec2i_render_polygon_fill(render,
		v,
		point_count,
		col.r);
}
/*--------------------------------------------------------------------------*/
//݂̎ł́Aline_thickness𖳎Ă܂B
static void nk_piece_draw_polyline(RENDER* render, const struct nk_vec2i* points, int point_count, int line_thickness, struct nk_color col) {
	int i;
	for(i = 0; i < (point_count - 1); i++) {
		render_line(render,
			points[i + 0].x,
			points[i + 0].y,
			points[i + 1].x,
			points[i + 1].y,
			col.r);
	}
}
/*--------------------------------------------------------------------------*/
static void nk_piece_draw_text(RENDER* render, int x, int y, int w, int h, const char* string, int len, const struct nk_user_font* font, struct nk_color bg, struct nk_color fg) {
	int type = font->userdata.id;
#if 0
	//'nuklear-master/demo/`'̊e_OobNGh̃\[X琄ɁANuklear̎dl͏ɕ̔wiĥׂ悤Ȃ̂A
	//wiF̏ꍇɔwiFhׂƁAEChE̔wiƕ̔wiŔFdɓhĂ܂AڂɕsRȕ`挋ʂɂȂB
	//ۂ̏A̔wiF͏ɃEChE̔wiFƓł悤A̔wihׂKv͖ƎvB
	//̏A֐̈w,h́A̍Ȃ菬TCYw肳悤ŁAhׂ͈͂ƍĂȂB
	//ȏ̗RɂAw,h,y,bg͖āAhׂ͍sȂɂB
	render_rectangle_fill(render,
		x,
		y,
		w,
		h,
		bg.r);
#endif
	render_printf(render,
		x,
		y,
		type,
		fg.r,
		"%.*s", len, string);
}
/*--------------------------------------------------------------------------*/
//{͕`悷C[W̃TCYw,hŎw肳ꂽTCYقȂꍇ͊gkĕ`KvL̂łA݂̎łw,h𖳎Ċgkŕ`Ă܂B
static void nk_piece_draw_image(RENDER* render, int x, int y, int w, int h, const struct nk_image* img, struct nk_color col) {
	int sx, sy, sw, sh;
	TEXTURE* texture = img->handle.ptr;
	TEXTURE* texture_save = render->context->texture;
	render->context->texture = texture;
	//TuC[WłȂ΁c
	if(!nk_image_is_subimage(img)) {
		sx = 0;
		sy = 0;
		sw = texture->header.w;
		sh = texture->header.h;
	//TuC[WȂ΁c
	} else {
		sx = img->region[0/*x*/];
		sy = img->region[1/*y*/];
		sw = img->region[2/*w*/];
		sh = img->region[3/*h*/];
	}
	render_object(render, x, y, sx, sy, sw, sh, DRW_NOMAL);
	render->context->texture = texture_save;
}
/*--------------------------------------------------------------------------*/
static float nk_piecefont_get_text_width(nk_handle handle, float height, const char* text, int len) {
	int type = handle.id;
	return (short)render_printf(&null_render, 0, 0, type, 0, "%.*s", len, text);
}
