/*
 *	ucontext.h
 *
 *	[U[ReLXg(System V݊)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015-2016 Naoyuki Sawa
 *
 *	* Sun May 17 15:20:04 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Tue Nov 29 23:01:43 JST 2016 Naoyuki Sawa
 *	- P/ECEp̎ɉāAWin32pWin64p̎ǉ܂B
 *	  P/ECEp̎́AύXĂ܂B
 *	- Win32p̎ɂẮAL̃y[WɎႪL܂A͐삵܂B
 *	  uCodeProject - Unix ucontext_t Operations on Windows Platformsv(https://www.codeproject.com/tips/4225/unix-ucontext-t-operations-on-windows-platforms)
 *	  L̎́AGetThreadContext(),SetThreadContext() API𗘗pĂ܂AAPI͎s̃Xbhgɑ΂ĐlԂȂdlłB
 *	  (肭悤ɌĂA͂܂܏肭悤ɌĂ邾łB)
 *	  ]č́AGetThreadContext(),SetThreadContext() APIgpɁAAZuŎ鎖ɂ܂B
 *	  AZuŎɂAWin32Win64ꂼŁAsetjmp()/longjmp()̐R[hāA炪sĂ鏈QlɂĎ܂B
 *	- Win64̃AZû͍񂪏߂ĂŁAĂяoKɂĂ̋LQlɂĒ܂B
 *	  QlɂĒLAucontext.c̒́uWin64p̎ɎQlɂvɈpĂ܂B
 *	- Win64pgetcontext(),setcontext(),makecontext()́A/clip/libclip.x64/ucontext_x64.asmɂĎ܂B
 *	  ڍׂ́Aucontext.c̒́uWin64v̎ӏ̃RgQƂĉB
 */
#ifndef __UCONTEXT_H__
#define __UCONTEXT_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/****************************************************************************
 *	
 ****************************************************************************/
//stack_t͖{signal.hŒ`ׂAP/ECEɂsignal.ĥŁAucontext.hɊ܂߂Ē`鎖ɂB
typedef struct {					// P/ECE Win32 Win64
	void*			ss_sp;			//+ 0, 4+ 0, 4+ 0, 8X^bÑx[XAhX
     //	int			ss_flags;		//                  tO
	size_t			ss_size;		//+ 4, 4+ 4, 4+ 8, 8X^bÑoCg
} stack_t;						//= 8   = 8   =16   
/*--------------------------------------------------------------------------*/
#ifdef  PIECE
//P/ECE
typedef struct mcontext {
	void*			r0;			//+ 0, 4%r0
	void*			r1;			//+ 4, 4%r1
	void*			r2;			//+ 8, 4%r2
	void*			r3;			//+12, 4%r3
	void*			sp;			//+16, 4%sp
	void*			pc;			//+20, 4%pc
} mcontext_t;						//=24
#endif//PIECE
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#if     (defined(_WIN32) && !defined(_WIN64))
//Win32
typedef struct mcontext {
	void*			ebx;			//+ 0, 4ebx
	void*			esi;			//+ 4, 4esi
	void*			edi;			//+ 8, 4edi
	void*			ebp;			//+12, 4ebp
	void*			esp;			//+16, 4esp
	void*			eip;			//+20, 4eip
} mcontext_t;						//=24
#endif//(defined(_WIN32) && !defined(_WIN64))
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#if     (defined(_WIN32) &&  defined(_WIN64))
//Win64
typedef struct mcontext {
	void*			rbx;			//+  0, 8rbx
	void*			rsi;			//+  8, 8rsi
	void*			rdi;			//+ 16, 8rdi
	void*			rbp;			//+ 24, 8rbp
	void*			rsp;			//+ 32, 8rsp
	void*			rip;			//+ 40, 8rip
	void*			r12;			//+ 48, 8r12
	void*			r13;			//+ 56, 8r13
	void*			r14;			//+ 64, 8r14
	void*			r15;			//+ 72, 8r15
	void*			xmm6[2];		//+ 80,16xmm6
	void*			xmm7[2];		//+ 96,16xmm7
	void*			xmm8[2];		//+112,16xmm8
	void*			xmm9[2];		//+128,16xmm9
	void*			xmm10[2];		//+144,16xmm10
	void*			xmm11[2];		//+160,16xmm11
	void*			xmm12[2];		//+176,16xmm12
	void*			xmm13[2];		//+192,16xmm13
	void*			xmm14[2];		//+208,16xmm14
	void*			xmm15[2];		//+224,16xmm15
} mcontext_t;						//=240
#endif//(defined(_WIN32) &&  defined(_WIN64))
/*--------------------------------------------------------------------------*/
typedef struct ucontext {				// P/ECE Win32   Win64
	struct ucontext*	uc_link;		//+ 0, 4+ 0, 4+  0,  8݂̃ReLXgIƂAĐ؂ւReLXgւ̃|C^(݂̃ReLXgmakecontext()Őꂽ̂̏ꍇ)
     //	sigset_t		uc_sigmask;		//                    ̃ReLXgŃubNĂVOiQ
	stack_t			uc_stack;		//+ 4, 8+ 4, 8+  8, 16̃ReLXgpĂX^bN
	mcontext_t		uc_mcontext;		//+12,24+12,24+ 24,240ۑĂReLXg̃}VL̕\`
} ucontext_t;						//=36   =36   =264    
/****************************************************************************
 *	
 ****************************************************************************/
int getcontext(ucontext_t* ucp);
int setcontext(const ucontext_t* ucp);
void makecontext(ucontext_t* ucp, void (*func)(), int argc, ...);
int swapcontext(ucontext_t* oucp, const ucontext_t* ucp);
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__UCONTEXT_H__
