/*
 *	stdint.h
 *
 *	C99ŒǉꂽA̕^ƃ}N̒`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2011 Naoyuki Sawa
 *
 *	* Wed May 11 02:15:44 JST 2011 Naoyuki Sawa
 *	- 1st [XB
 *	- ȉ̃y[WQlɂĒ܂B
 *	  http://www.opensource.apple.com/source/xnu/xnu-1456.1.26/EXTERNAL_HEADERS/stdint.h
 *	* Mon Aug 29 10:49:22 JST 2011 Naoyuki Sawa
 *	- Borland C++ł́A64rbg^ԈĂ̂C܂B(Visual C++ƓokB)
 *	- Visual C++Borland C++ł́A64rbg萔TtBbNXԈĂ̂C܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef _STDINT_H_
#define _STDINT_H_

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/* from ISO/IEC 988:1999 spec */

/* 7.18.1.1 Exact-width integer types */
typedef char			int8_t;
typedef short			int16_t;
typedef int			int32_t;
#ifdef  PIECE
typedef long long		int64_t;	//GCC (P/ECEJ)
#else /*PIECE*/
typedef __int64			int64_t;	//Visual C++, Borland C++
#endif/*PIECE*/
typedef unsigned char		uint8_t;
typedef unsigned short		uint16_t;
typedef unsigned int		uint32_t;
#ifdef  PIECE
typedef unsigned long long	uint64_t;	//GCC (P/ECEJ)
#else /*PIECE*/
typedef unsigned __int64	uint64_t;	//Visual C++, Borland C++
#endif/*PIECE*/

/* 7.18.1.2 Minumun-width integer types */
typedef int8_t			int_least8_t;
typedef int16_t			int_least16_t;
typedef int32_t			int_least32_t;
typedef int64_t			int_least64_t;
typedef uint8_t			uint_least8_t;
typedef uint16_t		uint_least16_t;
typedef uint32_t		uint_least32_t;
typedef uint64_t		uint_least64_t;

/* 7.18.1.3 Fastest-width integer types */
typedef int8_t			int_fast8_t;	//int32_tł
typedef int16_t			int_fast16_t;	//int32_tł
typedef int32_t			int_fast32_t;
typedef int64_t			int_fast64_t;
typedef uint8_t			uint_fast8_t;	//uint32_tł
typedef uint16_t		uint_fast16_t;	//uint32_tł
typedef uint32_t		uint_fast32_t;
typedef uint64_t		uint_fast64_t;

/* 7.18.1.4 Integer types capable of hgolding object pointers */
typedef int32_t			intptr_t;
typedef uint32_t		uintptr_t;

/* 7.18.1.5 Greatest-width integer types */
typedef int64_t			intmax_t;
typedef uint64_t		uintmax_t;

/* 7.18.2.1 Limits of exact-width integer types */
#define INT8_MIN		(-127-1)
#define INT16_MIN		(-32767-1)
#define INT32_MIN		(-2147483647-1)
#define INT64_MIN		(-INT64_C(9223372036854775807)-INT64_C(1))

#define INT8_MAX		127
#define INT16_MAX		32767
#define INT32_MAX		2147483647
#define INT64_MAX		INT64_C(9223372036854775807)

#define UINT8_MAX		255
#define UINT16_MAX		65535
#define UINT32_MAX		4294967295U
#define UINT64_MAX		UINT64_C(18446744073709551615)

/* 7.18.2.2 Limits of minimum-width integer types */
#define INT_LEAST8_MIN		INT8_MIN
#define INT_LEAST16_MIN		INT16_MIN
#define INT_LEAST32_MIN		INT32_MIN
#define INT_LEAST64_MIN		INT64_MIN

#define INT_LEAST8_MAX		INT8_MAX
#define INT_LEAST16_MAX		INT16_MAX
#define INT_LEAST32_MAX		INT32_MAX
#define INT_LEAST64_MAX		INT64_MAX

#define UINT_LEAST8_MAX		UINT8_MAX
#define UINT_LEAST16_MAX	UINT16_MAX
#define UINT_LEAST32_MAX	UINT32_MAX
#define UINT_LEAST64_MAX	UINT64_MAX

/* 7.18.2.3 Limits of fastest minimum-width integer types */
#define INT_FAST8_MIN		INT8_MIN
#define INT_FAST16_MIN		INT16_MIN
#define INT_FAST32_MIN		INT32_MIN
#define INT_FAST64_MIN		INT64_MIN

#define INT_FAST8_MAX		INT8_MAX
#define INT_FAST16_MAX		INT16_MAX
#define INT_FAST32_MAX		INT32_MAX
#define INT_FAST64_MAX		INT64_MAX

#define UINT_FAST8_MAX		UINT8_MAX
#define UINT_FAST16_MAX		UINT16_MAX
#define UINT_FAST32_MAX		UINT32_MAX
#define UINT_FAST64_MAX		UINT64_MAX

/* 7.18.2.4 Limits of integer types capable of holding object pointers */
#define INTPTR_MIN		INT32_MIN
#define INTPTR_MAX		INT32_MAX
#define UINTPTR_MAX		UINT32_MAX

/* 7.18.2.5 Limits of greatest-width integer types */
#define INTMAX_MIN		INT64_MIN
#define INTMAX_MAX		INT64_MAX
#define UINTMAX_MAX		UINT64_MAX

/* 7.18.3 "Other" */
#define PTRDIFF_MIN		INT32_MIN
#define PTRDIFF_MAX		INT32_MAX

#define SIZE_MAX		UINT32_MAX
#define WCHAR_MAX		UINT16_MAX

/* 7.18.4 Macros for integer constants */
#define INT8_C(v)		((int8_t)v)
#define INT16_C(v)		((int16_t)v)
#define INT32_C(v)		(v##L)
#ifdef  PIECE
#define INT64_C(v)		(v##LL)		//GCC (P/ECEJ)
#else /*PIECE*/
#define INT64_C(v)		(v##I64)	//Visual C++, Borland C++
#endif/*PIECE*/

#define UINT8_C(v)		((uint8_t)v)
#define UINT16_C(v)		((uint16_t)v)
#define UINT32_C(v)		(v##UL)
#ifdef  PIECE
#define UINT64_C(v)		(v##ULL)	//GCC (P/ECEJ)
#else /*PIECE*/
#define UINT64_C(v)		(v##UI64)	//Visual C++, Borland C++
#endif/*PIECE*/

#define INTMAX_C		INT64_C
#define UINTMAX_C		UINT64_C

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif/*_STDINT_H_*/
