/*
 *	gtree.h
 *
 *	Balanced Binary Trees - a sorted collection of key/value pairs optimized for searching and traversing in order
 *
 *	* Mon Jul 04 21:02:51 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- GLibBalanced Binary Trees(https://developer.gnome.org/glib/stable/glib-Balanced-Binary-Trees.html)Qlɂ܂B
 *	  ֐dlGLibłƓłÁAGLibł̃\[Xł͂ȂAL̃TCg̃\[XQlɂč쐬܂B
 *	  Ql
 *	  uOK ̃z[y[Wv(http://www.moon.sannet.ne.jp/okahisa/)́AuAVL Tree by Java -- ŕAVL؁v(http://www.moon.sannet.ne.jp/okahisa/avl-tree/avl-tree.html)̋L
 *	  /clip/keep/AVL؎Ql.7zɕۑĂ܂B
 *	  GLib̃\[Xł͂ȂAL̃TCg̃\[XQlɂŔAGLib̃\[XAL̃TCg̃\[X̕RpNgŔ₷łB
 *	  AL̃TCgɂ́Aʂ̎ƂāuJava ɂċAgȂAVL؂̎v(http://www.moon.sannet.ne.jp/okahisa/avl-tree/iavl-tree.html)ڂĂ̂łÁAʂɍċAgłQlɂĒ܂B
 *	  ċAgȂł́AAVL؂̃m[ȟ^ɐem[hւ̃NǉKvLAX̃m[h̃TCYāAŜƂăq[vgpʂȂ肪L邩łB
 *	  ́AxAȃD悷鎖ɂ܂B(AʂɍċAgł̕AċAĂяo̕AX^bNt[̃ʂ͑łB)
 *	- ̎́AقځAL̃TCg̃\[XƓłA_AӐ}Iɍ폜_L܂B
 *	  ́A⏕̌^́AchangetOp~_łB
 *	  L̃TCg̃\[Xł́AoX񕜂鏈ǂ܂őkČp邩𔻒f邽߂ɁA⏕̌^changetOgpĂ܂B
 *	  A͒Pɍ̂߂łÁA[gm[h܂őkăoX񕜂鏈sĂAʂ͓ɂȂ܂B
 *	  ̗]ȏsƂĂAg_tree_node_balanceL(),,g_tree_node_balanceR()̐擪ŃoCAX𔻒肵_ŁA]svł鎖͔̂ŁAۂɉ]͍s܂B
 *	  ܂AchangetOp~ꍇ̃I[o[wbh́A]g_tree_node_bias()AKwɂ񔭐邾̈ႢłB
 *	  g_tree_node_bias()͏\Ȃ̂ŁAقǑ傫ȃI[o[wbhł͂܂B
 *	  ܂AKw̐͂悻 log2(m[h) łA100m[hLƂĂ\KwxłB
 *	  ܂Ƃ߂܂ƁAchangetOp~ɂI[o[wbh́Am[h̒ǉ폜sxɁAg_tree_node_bias()(Ă)\sx̃I[o[wbhɉ߂A\eł܂B
 *	  ނAchangetOK؂ɃZbgENA鏈̕AIɔh_L܂̂ŁAchangetOp~̂͗ɓKĂƎv܂B
 *	  ȏ̗RɂAł́A⏕̌^́AchangetOp~܂B
 *	  AAvP[V̊ϓ_́A̓_ɂċCɂKv͗L܂B
 *	- ۂ̏AgtreéAght_hash_tableɑ΂āAɃbg͗L܂B
 *	  L̃vOőxvAgtreeght_hash_tableɑ΂Ė4{xłB
 *	  changetOp~ɂċɒ[ɒxȂĂł͂Ȃ̂ŁAXAAVL؂ƃnbVe[uɂ́Aꂮ炢̑xL̂Ǝv܂B
 *	  //xrvO
 *	  void test1();  //OQ
 *	  void test2();  //OQ
 *	  int compar(const void* _x, const void* _y);  //OQ
 *	  int app_main(int argc, char* argv[]) {
 *	    test1();  // 344[ms]
 *	    test2();  //1422[ms]
 *	    return 0;
 *	  }
 *	  void test1() {  //ght_hash_table
 *	    ght_hash_table_t* ht = ght_create(0);
 *	    int t, i, r;
 *	    ght_set_rehash(ht, 1);
 *	    seed = 0;
 *	    t = GetTickCount();
 *	    for(i = 0; i < 1000000; i++) {
 *	      r = RND16(seed) + 1;
 *	      ght_insert(ht, (void*)r, sizeof r, &r);
 *	      r = RND16(seed) + 1;
 *	      ght_remove(ht, sizeof r, &r);
 *	      r = RND16(seed) + 1;
 *	      ght_get(ht, sizeof r, &r);
 *	    }
 *	    t = GetTickCount() - t;
 *	    ght_finalize(ht);
 *	    printf("ght_hash_table: %d\n", t);
 *	  }
 *	  void test2() {  //GTree
 *	    GTree* tree = g_tree_new(compar);
 *	    int t, i, r;
 *	    seed = 0;
 *	    t = GetTickCount();
 *	    for(i = 0; i < 1000000; i++) {
 *	      r = RND16(seed) + 1;
 *	      g_tree_insert(tree, (void*)r, (void*)r);
 *	      r = RND16(seed) + 1;
 *	      g_tree_remove(tree, (void*)r);
 *	      r = RND16(seed) + 1;
 *	      g_tree_lookup(tree, (void*)r);
 *	    }
 *	    t = GetTickCount() - t;
 *	    g_tree_unref(tree);
 *	    printf("GTree: %d\n", t);
 *	  }
 *	  int compar(const void* _x, const void* _y) {
 *	    int x = (int)_x;
 *	    int y = (int)_y;
 *	    if(x < y) { return -1; }
 *	    if(x > y) { return  1; }
 *	    return 0;
 *	  }
 *	  ʂɂĂ͌Ɍ؂Ă܂񂪁AقƂǍ͖̂ł͂ȂƎv܂B
 *	  ]āAPɎƂĎgp邾Ȃ΁AgtreegӖ͖Aght_hash_tablegǂłB
 *	  ght_hash_tablegtreeDĂ_ƂẮAL̓_܂B
 *	  ׂϓIłBght_hash_table͕i͍nbVɏuԓIɑ傫ȕׂBgtree͒ᑬuԓIɋɒ[ɑ傫ȕׂ鎖͖B
 *	  IɃ\[gBght_hash_table̓\[gKvȏꍇCe[V̑OɖIɃ\[gKvLBgtree͒PɃCe[V邾ŏɃ\[gĂB
 *	* Tue Jul 05 22:24:53 JST 2016 Naoyuki Sawa
 *	- g_tree_first_np(),g_tree_next_np()ǉ܂B
 *	  ̊֐́AIWiGLibłɂ͖AƎgłB
 *	  ֐TtBbNX'np'́A'not portable'̗łB
 *	  PthreadsAڐA̖֐ɃTtBbNX'np't^Ă闬Vɕ킢܂B
 *	  ̊֐ǉŔAȉ̒ʂłB
 *	- IWiGLibłł̃Ce[V֐́Ag_tree_foreach()łB
 *	  g_tree_foreach()́AR[obN^̃Ce[V֐łB
 *	  R[obN^̃Ce[V֐́Aۂ̃AvP[Vł͎ghAfirst/next^̃Ce[V֐~Ǝv܂B
 *	  ŁAƎgƂāAfirst/next^̃Ce[V֐g_tree_first_np(),g_tree_next_np()ǉ鎖ɂ܂B
 *	- g_tree_first_np(),g_tree_next_np()̎ǵAght_first(),ght_next()ƂقړłB
 *	  Aght_first(),ght_next()'l'߂lł̂ɑ΂Ag_tree_first_np(),g_tree_next_np()̖߂l̓tOł鎖ɒӂĉB
 *	  ŔAght_hash_tablełNULL'l'Ƃĕsł̂ɑ΂AgtreełNULL̒lL蓾邽߁A'l'߂lƂNULLƏI[ʏoȂȂ邩łB
 */
#ifndef __GTREE_H__
#define __GTREE_H__
#ifdef __cplusplus
extern "C" {
#endif//__cplusplus
/*****************************************************************************
 *	GTree
 *****************************************************************************/
typedef struct _GTree GTree;	//The GTree struct is an opaque data structure representing a balanced binary tree. It should be accessed only by using the following functions.
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
GTree* g_tree_new(int (*key_compare_func)(const void* a, const void* b));
GTree* g_tree_ref(GTree* tree);
void g_tree_unref(GTree* tree);
GTree* g_tree_new_with_data(int (*key_compare_func)(const void* a, const void* b, void* user_data), void* key_compare_data);
GTree* g_tree_new_full(int (*key_compare_func)(const void* a, const void* b, void* user_data), void* key_compare_data, void (*key_destroy_func/*NULL*/)(void* data), void (*value_destroy_func/*NULL*/)(void* data));
void g_tree_insert(GTree* tree, void* key, void* value);
void g_tree_replace(GTree* tree, void* key, void* value);
int g_tree_nnodes(GTree* tree);
int g_tree_height(GTree* tree);
void* g_tree_lookup(GTree* tree, const void* key);
int g_tree_lookup_extended(GTree* tree, const void* lookup_key, void** orig_key/*NULL*/, void** value/*NULL*/);
void g_tree_foreach(GTree* tree, int (*func)(void* key, void* value, void* data), void* user_data);
void* g_tree_search(GTree* tree, int (*search_func)(const void* a, const void* b), const void* user_data);
int g_tree_remove(GTree* tree, const void* key);
int g_tree_steal(GTree* tree, const void* key);
void g_tree_destroy(GTree* tree);
/*****************************************************************************
 *	Ǝg
 *****************************************************************************/
typedef struct _GTreeIteratorNP {
	int			depth;			//X^bN̐[	stack[0`(depth-1)]ɗLȃm[hi[ĂB
	struct _GTreeNode*	stack[31/**/];	//X^bN		m[hHoHi[B				X^bNTCY͌31ŏ\Ǝv܂BʓIAVL؂͊Ss؂1.5{x̍Ɏ܂̂ŁA2^(31/1.5)=100vf܂őΉo邩łB
} GTreeIteratorNP;
/*--------------------------------------------------------------------------*/
int g_tree_first_np(GTree* tree, GTreeIteratorNP* iter, void** _key/*NULL*/, void** _value/*NULL*/);
int g_tree_next_np(GTree* tree, GTreeIteratorNP* iter, void** _key/*NULL*/, void** _value/*NULL*/);
#ifdef __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__GTREE_H__
