/*	
 *	clipym.h
 *
 *	P/ECE YM (ST-Sound) Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon Apr 19 19:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_YM_H__
#define __CLIP_YM_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	YMt@Cdl
 ****************************************************************************/

/* * etB[h̃oCgI[_[BigEndianłB
 *   Ƃ낪AYM3BHEADER.number_to_loop_the_songȂLittleEndianłB
 *   YM3b`̃t@C30ʂȂAȂ߂Ɋm؂Ă܂B
 *   AYM3b`łɂĂBigEndian̏ꍇ邩m܂B
 *
 * * YMt@C̋LqɂĂ悭oĂ"VBL"ƂṔAVBLANK̈ӖłB
 */

/* YM2苌`̃f[^͂قƂǑ݂܂B */

/*
 *	YM3t@Cwb_
 */
typedef struct _YM3HEADER {
	unsigned char id_of_ym3_format			[4];	/* +0, 4: "YM3!" */
//	unsigned char all_ym2149_registers		[...];	/* interleaved only: {R0~VBL},{R1~VBL},...,{R13~VBL} */
} YM3HEADER;

/*
 *	YM3bt@Cwb_
 */
typedef struct _YM3BHEADER {
	unsigned char id_of_ym3b_format			[4];	/* +0, 4: "YM3b" */
//	unsigned char all_ym2149_registers		[...];	/* interleaved only: {R0~VBL},{R1~VBL},...,{R13~VBL} */
//	unsigned char vbl_number_to_loop_the_song	[4];	/* Ȃ̃tB[hLittleEndianŊi[Ă!? */
} YM3BHEADER;

/*
 *	YM4t@Cwb_ (̌`̃f[^͂قƂǑ݂܂)
 */
typedef struct _YM4HEADER {
	unsigned char id_of_ym4_format			[4];	/* + 0,4: "YM4!" */
	unsigned char check_string			[8];	/* + 4,8: "LeOnArD!" */
	unsigned char nb_of_valid_vbl_of_the_file	[4];	/* +12,4: */
	unsigned char song_attributes			[4];	/* +16,4: */
	unsigned char nb_of_digidrum_sample		[4];	/* +20,4: */
	unsigned char vbl_number_to_loop_the_song	[4];	/* +24,4: */
//	for each digidrum sample {
//		unsigned char sample_size		[4];
//		unsigned char sample_data		[sample_size];
//	}
//	unsigned char name_of_the_song			[null-terminated];
//	unsigned char name_of_the_author		[null-terminated];
//	unsigned char comments				[null-terminated];
//	unsigned char all_ym2149_registers		[...];	/* interleaved: {R0~VBL},{R1~VBL},...,{R13~VBL} */
//								/* or non-interleaved: {R0,R1,...,R15}~VBL        */
//	unsigned char end_file_check			[4];	/* "End!" */
} YM4HEADER;

/*
 *	YM5t@Cwb_
 */
typedef struct _YM5HEADER {
	unsigned char id_of_ym5_format			[4];	/* + 0,4: "YM5!" */
	unsigned char check_string			[8];	/* + 4,8: "LeOnArD!" */
	unsigned char nb_of_valid_vbl_of_the_file	[4];	/* +12,4: */
	unsigned char song_attributes			[4];	/* +16,4: */
	unsigned char nb_of_digidrum_sample		[2];	/* +20,2: */
	unsigned char ym2149_external_frequency_in_hz	[4];	/* +22,4: */
	unsigned char player_frequency_in_hz		[2];	/* +26,2: */
	unsigned char vbl_number_to_loop_the_song	[4];	/* +28,4: */
	unsigned char size_of_future_additional_data	[2];	/* +32,2: */
//	for each digidrum sample {
//		unsigned char sample_size		[4];
//		unsigned char sample_data		[sample_size];
//	}
//	unsigned char name_of_the_song			[null-terminated];
//	unsigned char name_of_the_author		[null-terminated];
//	unsigned char comments				[null-terminated];
//	unsigned char all_ym2149_registers		[...];	/* interleaved: {R0~VBL},{R1~VBL},...,{R13~VBL} */
//								/* or non-interleaved: {R0,R1,...,R15}~VBL        */
//	unsigned char end_file_check			[4];	/* "End!" */
} YM5HEADER;

/* YM6̃t@Cwb_`́AYM5ƓłB */

/* YM{4,5}HEADER.song_attributes */
#define YM_INTERLEAVED_DATA_BLOCK			(1 << 0)
//#define YM_DIGIDRUM_SAMPLES_ARE_SIGNED_DATA		(1 << 1)	/* Ή */
//#define YM_DIGIDRUM_IS_ALREADY_IN_ST_4_BITS_FORMAT	(1 << 2)	/* Ή */

/****************************************************************************
 *	YMhCo
 ****************************************************************************/

#define YMBUFLEN 320 /* =16000/50 c 1[tick](=1/50[sec])̃Tv */

typedef struct _YMINFO {
	int nb_of_valid_vbl_of_the_file;		/* SVBL */
	int vbl_number_to_loop_the_song;		/* [vJnVBLԍ */
	int nb_of_registers_in_each_vbl;		/* i[Ă郌WX^ (YM3!,YM3b:14 / YM4!,YM5!,YM6!:16) */
	int vbl_stride;					/* all_ym2149_registerŁAVBL̎̃WX^ւ̃ItZbg */
	int register_stride;				/* all_ym2149_registerŁAWX^̎VBLւ̃ItZbg */

	int ym2149_external_frequency_in_hz;		/* YM2149̓NbN (ATARI-ST:2000000 / AMSTRAD CPC:1000000) */
	int player_frequency_in_hz;			/* VBL^C~O (ʏ50BVBL=100̃t@C킸ɂ܂) */

	char id_of_format[4 + 1];			/* YM3! / YM3b / YM4! / YM5! / YM6! */
	const char* name_of_the_song;			/* Ȗ */
	const char* name_of_the_author;			/* ȎҖ */
	const char* comments;				/* Rg(YMt@C쐬҂Ȃ) */

	const unsigned char* all_ym2149_registers;	/* WX^f[^擪AhX */
} YMINFO;

/*
 *	YMhCo
 */
typedef struct _YMDRIVER {
	YMINFO info;		/* YMt@C */
	//
	AY38910 ay38910;	/* AY-3-8910 (or YM2149) Chip */
	//
	DDA vbl_interval;	/* VBLԊuTvpDDA */
	int vbl_progress;	/* VBL܂ł̎cTv */
	int vbl_position;	/* VBLʒu */
} YMDRIVER;

/*
 *	YMhCo֐
 */
int ym_init(YMDRIVER* ym, const void* data, int len);
int ym_mix(YMDRIVER* ym, short wbuff[/*YMBUFLEN*/]);
int ym_stream_callback(short* wbuff, int param);
//
int ym_get_info_ym3(YMINFO* info, const YM3HEADER* header, int len);
int ym_get_info_ym3b(YMINFO* info, const YM3BHEADER* header, int len);
int ym_get_info_ym4(YMINFO* info, const YM4HEADER* header, int len);
int ym_get_info_ym5(YMINFO* info, const YM5HEADER* header, int len);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* YMt@C擾܂B
 * [in]
 *	info		YMt@C󂯎ϐւ̃|C^B
 *	data		YMt@Cf[^B(LZHWJς)
 *	len		YMt@Cf[^TCYB
 * [out]
 *	߂l		擾łA0Ԃ܂B
 *			擾łȂ΁A-1Ԃ܂B
 *	*info		YMt@Ci[܂B
 * [note]
 *	* ̊֐͉tɂ͊֌W܂B
 *	  t̋ȖȎҖʕ\邽߂ɗpĂB
 *	* YMhCoLZHWJs܂B
 *	  ĂяoɂYMt@Cf[^LZHWJAWJf[^AhXym_get_info()֐ɓnĂB
 */
int ym_get_info(YMINFO* info, const void* data, int len);

/* YMt@C̍ĐJn܂B
 * [in]
 *	data		YMt@Cf[^B(LZHWJς)
 *	len		YMt@Cf[^TCYB
 * [out]
 *	߂l		ĐJnɐA0Ԃ܂B
 *			ĐJnłȂ΁A-1Ԃ܂B
 * [note]
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKym_stop()ĂŁAxN^𕜌ĂB
 *	* YMhCoLZHWJs܂B
 *	  ĂяoɂYMt@Cf[^LZHWJAWJf[^AhXym_play()֐ɓnĂB
 */
int ym_play(const void* data, int len);

/* YMt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void ym_stop();

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_YM_H__*/
