/*	
 *	clipvqtc.c
 *
 *	VQkeNX`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Mon Dec 19 21:58:37 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	  ܂͌؂̂߂ɁAWindowsGDI+gẮAkWJ[`쐬܂B
 *	  dpbmpcnv.exeւ̑gݍ݂AP/ECEp̕`惋[`́Âƍ쐬\łB	{{2016/12/22RgǋL:dpbmpcnv.exeւ̑gݍ,y,P/ECEp̕`惋[`(framvqtd.c)쐬܂B}}
 *	* Tue Dec 20 21:28:56 JST 2016 Naoyuki Sawa
 *	- k-means@(,,k-means++@)̌JԂ́Ał؂ύX܂B
 *	  ڍׂ́AVqTc_EncodeImage()̃RgQƂĉB
 *	* Wed Dec 21 21:39:53 JST 2016 Naoyuki Sawa
 *	- VQTC_DATAHEADER\̂̒`ǉ܂B
 *	  dpbmpcnv.exe,y,P/ECEp̕`惋[`ŎQƂ܂B
 *	* Fri Dec 23 23:24:50 JST 2016 Naoyuki Sawa
 *	- R[hubN5oCg̈kf[^́A1oCgڂ̃rbgl߂̏tɂ܂B
 *	  ύXÓuaabbccddvłAύX́uddccbbaavɂȂ܂B
 *	  VqTc_DecodeCell()֐4x4sNZ܂Ƃ߂ăfR[h鎞́AύXÓuaabbccddv̕т̕Vtgƃrbg𓯎ɍsČǂ̂łA
 *	  framvqtd.cPDW_Draw_VQTC()֐1C4sNZPƂŃfR[h鎞́AɃAZuł̎ɂāuddccbbaav̕т̕ǂɋCtłB
 *	  VqTc_DecodeCell()֐̓c[eXgłgȂ̂őx͏dvł͂ȂA`ŎgPDW_Draw_VQTC()֐dvȂ̂ŁAPDW_Draw_VQTC()֐̍D悵āuddccbbaavɂ܂B
 *	* Sat Dec 24 21:19:40 JST 2016 Naoyuki Sawa
 *	- R[hubNɊi[F̒lu0=`3=,4=vˁu0=,1=`4=vɕύX܂B
 *	  ύX֐́Aclipvqtc.cVqTc_EncodeCell()VqTc_DecodeCell()AyсAframvqtd.cPDW_Draw_VQTC()łB
 *	  ύXŔAȉ̒ʂłB
 *	- framvqtd.cPDW_Draw_VQTC()̏Z[vɂāAc̃sNZS0Ȃ΃[vł؂悤ɂĂAF̒l0łsNZقǕ`悪Ȃ܂B
 *	  ʓIɁAQ[̉摜̃sNZƂẮA̕Ǝv̂ŁA0Ƃ鎖ɂ܂B
 *	  摜̏ꍇ́A̕ύX͋tʂłApĒxȂĂ܂̂łAʓIɂ͑Ȃ鎖̕Ǝv܂B
 *	- ̌ʂ؂Ă݂܂B
 *	  ɒ[ȗƂāASɓȉ摜ŁAʑS(128x88)ɕ`悵ƂAύXOύX̕23%ɂȂ܂B
 *	  ]āȂɔႵāA23%Ƃč̌ʂLƎv܂B
 *	* Sun Dec 25 23:57:41 JST 2016 Naoyuki Sawa
 *	- ̐̏A25665536ɕύX܂B
 *	  kl256xK؂Ȃ̂łAꍇɂĂ256߂̕gLłB
 */
#include "clip.h"
/****************************************************************************
 *	
 ****************************************************************************/
#undef  VQTC_PRINT_PROGRESS
#define VQTC_PRINT_PROGRESS	//̃V{`ƁAVqTc_EncodeImage()WG[o͂ɐi\s܂BVqTc_EncodeImage()̏Ԃ̂ŁA҂ĂĕsɂȂȂ悤ɂ邽߂łBi\svȂ΁A̍sRgAEgĉB
/****************************************************************************
 *	
 ****************************************************************************/
//̐A̃rbg߂B
//[in]
//  //{{2016/12/25ύX:̐̏A25665536ɕύX܂B
//  //	k		̐			1`256
//  2016/12/25ύX:̐̏A25665536ɕύX܂B
//	k		̐			1`65536
//  //}}2016/12/25ύX:̐̏A25665536ɕύX܂B
//[out]
//	߂l		̃rbg	1`8
#ifndef PIECE
int VqTc_CalculateCodeBits(int k) {
	int bits;
//{{2016/12/25ύX:̐̏A25665536ɕύX܂B
//	if((k < 1) || (k > 256)) { DIE(); }	//̐1`256͈̔͂łȂĂ͂ȂȂBkASŶ256𒴂镄̐ɂΉ\łAfR[_邽߂ɕ8rbgȉɐłB
//	bits = 8 - xscan1(swap(k - 1));		//bits=8(129k256),7(65k128),6(33k64),5(17k32),4(9k16),3(5k8),2(3k4),1(k2),-24(k1)
//	if(bits < 0) { bits = 0; }		//bits=8(129k256),7(65k128),6(33k64),5(17k32),4(9k16),3(5k8),2(3k4),1(k2),  0(k1)
//2016/12/25ύX:̐̏A25665536ɕύX܂B
	if((k < 1) || (k > 65536)) { DIE(); }	//̐1`65536͈̔͂łȂĂ͂ȂȂB
	bits = 16 - xscan1((k - 1) << 16);	//bits=16(32769k65536),15(16385k32768),14(8193k16384),13(4097k8192),12(2049k4096),11(1025k2048),10(513k1024),9(257k512),8(129k256),7(65k128),6(33k64),5(17k32),4(9k16),3(5k8),2(3k4),1(k2),-16(k1)
	if(bits < 0) { bits = 0; }		//bits=16(32769k65536),15(16385k32768),14(8193k16384),13(4097k8192),12(2049k4096),11(1025k2048),10(513k1024),9(257k512),8(129k256),7(65k128),6(33k64),5(17k32),4(9k16),3(5k8),2(3k4),1(k2),  0(k1)
//}}2016/12/25ύX:̐̏A25665536ɕύX܂B
	return bits;
}
#else //PIECE
int VqTc_CalculateCodeBits(int k);
asm("
		.code
		.align		1
		.global		VqTc_CalculateCodeBits
VqTc_CalculateCodeBits:
		;//%r12 := k
;//{{2016/12/25ύX:̐̏A25665536ɕύX܂B
;//		sub		%r12, 1			;//%r12        :=                        k - 1
;//		swap		%r10, %r12		;//%r10[31:24] :=                        k - 1
;//		scan1		%r10, %r10		;//%r10        :=            xscan1(swap(k - 1))
;//		not		%r10, %r10		;//%r10        :=           ~xscan1(swap(k - 1))
;//		ret.d					;//return         bits
;//		add		%r10, 9			;//%r10        := bits = 8 - xscan1(swap(k - 1))	*delay*
;//2016/12/25ύX:̐̏A25665536ɕύX܂B
		sub		%r12, 1			;//%r12   :=                     k - 1
		xsla		%r12, 16		;//%r12   :=                    (k - 1) << 16
		scan1		%r10, %r12		;//
		sll		%r12, %r10		;//%r10 :=             xscan1((k - 1) << 16)
		scan1		%r9, %r12		;//
		add		%r10, %r9		;//
		not		%r10, %r10		;//%r10   :=            ~xscan1((k - 1) << 16)
		ret.d					;//return    bits
		add		%r10, 17		;//%r10   := bits = 16 - xscan1((k - 1) << 16)		*delay*
;//}}2016/12/25ύX:̐̏A25665536ɕύX܂B
");
#endif//PIECE
/*--------------------------------------------------------------------------*/
//摜̕ƍ,y,̐Az̃oCg߂B
//[in]
//	w		摜̕			1`
//	h		摜̍			1`
//  //{{2016/12/25ύX:̐̏A25665536ɕύX܂B
//  //	k		̐			1`256
//  //2016/12/25ύX:̐̏A25665536ɕύX܂B
//	k		̐			1`65536
//  //}}2016/12/25ύX:̐̏A25665536ɕύX܂B
//[out]
//	߂l		z̃oCg		4`
//[note]
//	- zbitarrayƂđ삷邽߁A֐z̃oCg4̔{ɐ؂グ܂B
//	- bitarrayƂđ삷邽߂̃TCY̗v͓֐ɂĒSۂ܂A̗v̓AvP[VɂĒSۂĉB
//	  ̓Iɂ́Az4̔{̃AhXɔzuĉB
int VqTc_CalculateCodeBytes(int w, int h, int k) {
	int cols, rows, bits, bytes;
	if((w < 1) || (h < 1)) { DIE(); }	//̉摜w肵Ă͂ȂB
	cols = (w + 3) / 4;
	rows = (h + 3) / 4;
	bits = VqTc_CalculateCodeBits(k);
	bits = (cols * rows) * bits;
	bytes = (bits + 7) / 8;
	bytes = (bytes + 3) & ~3;		//bitarray padding
	return bytes;
}
/****************************************************************************
 *	
 ****************************************************************************/
//񈳏k16sNZA5oCg̈kf[^ɕϊB
//[in]
//	src		16sNZ̓̓f[^				0=,1=,2=,3=,4`255=
//	dst		5oCg̈kf[^i[obt@
//[note]
//	- 16sNZ̕я4~4sNZz肵Ă邪A֐̓쎩̂ɂ̓sNZ̕я͊֌WB
//	- k`̏ڍׂɂ:
//	  AR[hubN(Z)kŊi[ƁA1sNZF2rbg{1rbg=3rbgȂ̂ŁA4x4sNZ6oCgv܂B
//	  A߃sNZɑ΂Frbg͖ʂł鎖lāA߃sNZFԍ4ƂĊi[΁A4sNZlog2(5^4)=10rbgA4x4sNZ5oCgōς݂܂B
//	  4sNZPʂňkŔA1Z(=4x4sNZ)A1CÂʂɎ擾Ղ\ɂĂAfR[_ՂłB
//  //{{2016/12/23ύX:R[hubN5oCg̈kf[^́A1oCgڂ̃rbgl߂̏tɂ܂B
//  //	- 5oCg~4C̊i[`ɂ:
//  //	  
//  //	  1Cڂ̏2rbg2Cڂ̏2rbg3Cڂ̏2rbg4Cڂ̏2rbg
//  //	  
//  //	  @@@@@@@@@@@@@@@@@@1Cڂ̉8rbg@@@@@@@@@@@@@@@@@@
//  //	  
//  //	  @@@@@@@@@@@@@@@@@@2Cڂ̉8rbg@@@@@@@@@@@@@@@@@@
//  //	  
//  //	  @@@@@@@@@@@@@@@@@@3Cڂ̉8rbg@@@@@@@@@@@@@@@@@@
//  //	  
//  //	  @@@@@@@@@@@@@@@@@@4Cڂ̉8rbg@@@@@@@@@@@@@@@@@@
//  //	  
//  //2016/12/23ύX:R[hubN5oCg̈kf[^́A1oCgڂ̃rbgl߂̏tɂ܂B
//	- 5oCg~4C̊i[`ɂ:
//	  
//	  4Cڂ̏2rbg3Cڂ̏2rbg2Cڂ̏2rbg1Cڂ̏2rbg
//	  
//	  @@@@@@@@@@@@@@@@@@1Cڂ̉8rbg@@@@@@@@@@@@@@@@@@
//	  
//	  @@@@@@@@@@@@@@@@@@2Cڂ̉8rbg@@@@@@@@@@@@@@@@@@
//	  
//	  @@@@@@@@@@@@@@@@@@3Cڂ̉8rbg@@@@@@@@@@@@@@@@@@
//	  
//	  @@@@@@@@@@@@@@@@@@4Cڂ̉8rbg@@@@@@@@@@@@@@@@@@
//	  
//  //}}2016/12/23ύX:R[hubN5oCg̈kf[^́A1oCgڂ̃rbgl߂̏tɂ܂B
void VqTc_EncodeCell(const unsigned char src[16], unsigned char dst[5]) {
	int c, i, j, x[4];
	for(i = 0; i < 4; i++) {
		x[i] = 0;
		for(j = 3; j >= 0; j--) {
			c = src[j];
//{{2016/12/24ύX:R[hubNɊi[F̒lu0=`3=,4=vˁu0=,1=`4=vɕύX܂B
//			if(c > 4) { c = 4; }	//5`2554()ƓƌȂB
//2016/12/24ύX:R[hubNɊi[F̒lu0=`3=,4=vˁu0=,1=`4=vɕύX܂B
			if(++c > 4) { c = 0; }	//u0=,1=,2=,3=,4`255=߁vˁu0=,1=,2=,3=,4=vɕϊB
//}}2016/12/24ύX:R[hubNɊi[F̒lu0=`3=,4=vˁu0=,1=`4=vɕύX܂B
			x[i] = (x[i] * 5) + c;
		}
		if((unsigned)x[i] > 0x270/*=(5^4)-1*/) { DIE(); }	//oO
		src += 4;
	}
//{{2016/12/23ύX:R[hubN5oCg̈kf[^́A1oCgڂ̃rbgl߂̏tɂ܂B
//	*dst++ = ((x[0] & 0x300) >> 2) |
//	         ((x[1] & 0x300) >> 4) |
//	         ((x[2] & 0x300) >> 6) |
//	         ((x[3] & 0x300) >> 8);
//2016/12/23ύX:R[hubN5oCg̈kf[^́A1oCgڂ̃rbgl߂̏tɂ܂B
	*dst++ = ((x[0] & 0x300) >> 8) |
	         ((x[1] & 0x300) >> 6) |
	         ((x[2] & 0x300) >> 4) |
	         ((x[3] & 0x300) >> 2);
//}}2016/12/23ύX:R[hubN5oCg̈kf[^́A1oCgڂ̃rbgl߂̏tɂ܂B
	*dst++ =   x[0];
	*dst++ =   x[1];
	*dst++ =   x[2];
	*dst++ =   x[3];
}
/*--------------------------------------------------------------------------*/
//5oCg̈kf[^A񈳏k16sNZɕϊB
//[in]
//	src		5oCg̈kf[^
//	dst		16sNZ̏o̓f[^i[obt@	0=,1=,2=,3=,4=
//[note]
//	- 16sNZ̕я4~4sNZz肵Ă邪A֐̓쎩̂ɂ̓sNZ̕я͊֌WB
//	- k`̏ڍׁCyсC5oCg~4C̊i[`ɂẮAVqTc_EncodeCell()[note]QƂB
//{{2016/12/23ύX:R[hubN5oCg̈kf[^́A1oCgڂ̃rbgl߂̏tɂ܂B
//void VqTc_DecodeCell(const unsigned char src[5], unsigned char dst[16]) {
//	int a, c, i, j, x;
//	a = *src++;			//a = 00000000 00000000 00000000 aabbccdd
//	for(i = 0; i < 4; i++) {
//		a <<= 2;		//a = 00000000 00000000 000000aa bbccdd00
//		x = a & 0x300;		//x = 00000000 00000000 000000aa 00000000
//		x |= *src++;		//x = 00000000 00000000 000000aa AAAAAAAA
//		if((unsigned)x > 0x270/*=(5^4)-1*/) { DIE(); }
//		for(j = 0; j < 4; j++) {
//			c = x % 5;
//			x = x / 5;
//			*dst++ = c;
//		}
//	}
//}
//2016/12/23ύX:R[hubN5oCg̈kf[^́A1oCgڂ̃rbgl߂̏tɂ܂B
void VqTc_DecodeCell(const unsigned char src[5], unsigned char dst[16]) {
	int a, c, i, j, x;
	a = *src++;			//a = 00000000 00000000 00000000 ddccbbaa
	for(i = 0; i < 4; i++) {
		x = a & 3;		//x = 00000000 00000000 00000000 000000aa
		x <<= 8;		//x = 00000000 00000000 000000aa 00000000
		x |= *src++;		//x = 00000000 00000000 000000aa AAAAAAAA
		if((unsigned)x > 0x270/*=(5^4)-1*/) { DIE(); }
		for(j = 0; j < 4; j++) {
			c = x % 5;
			x = x / 5;
//{{2016/12/24ǉ:R[hubNɊi[F̒lu0=`3=,4=vˁu0=,1=`4=vɕύX܂B
			if(--c < 0) { c = 4; }	//u0=,1=,2=,3=,4=vˁu0=,1=,2=,3=,4=߁vɕϊB
//}}2016/12/24ǉ:R[hubNɊi[F̒lu0=`3=,4=vˁu0=,1=`4=vɕύX܂B
			*dst++ = c;
		}
		a >>= 2;		//a = 00000000 00000000 00000000 00ddccbb
	}
}
//}}2016/12/23ύX:R[hubN5oCg̈kf[^́A1oCgڂ̃rbgl߂̏tɂ܂B
/****************************************************************************
 *	
 ****************************************************************************/
static double VqTc_EncodeImage_distance(const void* vector, const void* center) {
	const unsigned char* v = (const unsigned char*)vector;
	const unsigned char* c = (const unsigned char*)center;
	double d = 0.0;
	int i;
	for(i = 0; i < 16; i++) {
		int a = *v++;
		int b = *c++;
		if(a > 4) { a = 4; }	//5`2554()ƓƌȂB
		if(b > 4) { b = 4; }	//
		//Fc
		if(a != b) {
			//ЕŁAЕłȂ΁c
			if((a == 4) || (b == 4)) {
				d += ((3 * 3) * 16) + 1;	//ő̐FႢ(3)2(3*3)SsNZŔꍇ((3*3)*16)A1sNZ̓߈Ⴂ̕dƂB()
			//ǂłȂAFc
			} else {
				d += (a - b) * (a - b);		//(1*1) or (2*2) or (3*3)
			}
		}
	}
	return d;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//摜kB
//[in]
//	image		摜					(in)		0=,1=,2=,3=,4`255=
//	w		摜̕				(in)		1`
//	h		摜̍				(in)		1`
//	stride		摜1C̃oCg		(in)		w`
//	codebook	R[hubNi[obt@		(out)		֐̍Ɨ̈Ƃ(k*5)oCgKvłBo̓f[^̎TCY(߂l*5)oCgłB
//  //{{2016/12/25ύX:̐̏A25665536ɕύX܂B
//  //	k		̖̐ڕWl			(in)		1`256Bۂ̐̕(=֐̖߂l)́Aȉ̐ɂȂ܂B
//  //2016/12/25ύX:̐̏A25665536ɕύX܂B
//	k		̖̐ڕWl			(in)		1`65536Bۂ̐̕(=֐̖߂l)́Aȉ̐ɂȂ܂B
//  //}}2016/12/25ύX:̐̏A25665536ɕύX܂B
//	code		zi[obt@		(out)		֐̍Ɨ̈Ƃ(VqTc_CalculateCodeBytes(w,h,k))oCgKvłBo̓f[^̎TCY(VqTc_CalculateCodeBytes(w,h,߂l))oCgłB
//[out]
//	߂l		ۂ̐̕						1`k
int VqTc_EncodeImage(const void* image/*[stride*h]*/, int w, int h, int stride, void* codebook/*[k*5]*/, int k, void* code/*[VqTc_CalculateCodeBytes(w,h,k)]*/) {
	int c, i, j, l, n, x1, y1, x2, y2, col, row, cols, rows, bits1, bits2, relabel, sum[16], cnt[16];
	unsigned char *vector/*[n][16]*/, *center/*[k][16]*/;
	int* label/*[n]*/;
	if((w < 1) || (h < 1)) { DIE(); }	//̉摜w肵Ă͂ȂB
//{{2016/12/25ύX:̐̏A25665536ɕύX܂B
//	if((k < 1) || (k > 256)) { DIE(); }	//̐1`256͈̔͂łȂĂ͂ȂȂBkASŶ256𒴂镄̐ɂΉ\łAfR[_邽߂ɕ8rbgȉɐłB
//2016/12/25ύX:̐̏A25665536ɕύX܂B
	if((k < 1) || (k > 65536)) { DIE(); }	//̐1`65536͈̔͂łȂĂ͂ȂȂB
//}}2016/12/25ύX:̐̏A25665536ɕύX܂B
	//摜4x4sNZ̃ZɕāAk̃xNgƂB
	{
		cols = (w + 3) / 4;	//Z
		rows = (h + 3) / 4;	//Zs
		n = cols * rows;	//SZ
		vector = malloc(n * 16);		//xNg̔z̃mۂB
		if(!vector) { DIE(); }
		for(row = 0; row < rows; row++) {
			for(col = 0; col < cols; col++) {
				i = (cols * row) + col;
				for(y1 = 0; y1 < 4; y1++) {
					y2 = (row * 4) + y1;
					for(x1 = 0; x1 < 4; x1++) {
						x2 = (col * 4) + x1;
						if((x2 < w) && (y2 < h)) {
							c = ((const unsigned char*)image)[(stride * y2) + x2];
							if(c > 4) { c = 4; }	//5`2554()ƓƌȂB
						} else {
							c = 4;			//pfBO4()ƌȂB
						}
						vector[(i * 16) + ((y1 * 4) + x1)] = c;
					}
				}
			}
		}
	}
	//VQksB
	{
#ifdef  VQTC_PRINT_PROGRESS
		int newMsgLen, oldMsgLen = 0;
#endif//VQTC_PRINT_PROGRESS
//{{2016/12/20ύX:k-means@(,,k-means++@)̌JԂ́Ał؂ύX܂B
//		int iTry;
//2016/12/20ύX:k-means@(,,k-means++@)̌JԂ́Ał؂ύX܂B
		unsigned char sha1[20/*SHA-1*/];	//label[]SHA-1߂obt@
		ght_hash_table_t* ht_sha1;		//oSHA-1L^nbVe[u
		ght_set_rehash((ht_sha1 = ght_create(0)), 1);	//nbVe[u쐬B
//}}2016/12/20ύX:k-means@(,,k-means++@)̌JԂ́Ał؂ύX܂B
		center = malloc(k * 16);		//NX^S̃mۂB
		if(!center) { DIE(); }
		label = malloc(n * sizeof(int));	//x̃mۂB
		if(!label) { DIE(); }
		//k-means++@̏sB
#ifdef  VQTC_PRINT_PROGRESS
		newMsgLen = fprintf(stderr, "\rVqTc_EncodeImage: calling k_means_clustering_init");
		if(oldMsgLen > newMsgLen) { fprintf(stderr, "%*s", oldMsgLen - newMsgLen, ""); } oldMsgLen = newMsgLen;
#endif//VQTC_PRINT_PROGRESS
		k_means_clustering_init(vector, n, center/*_~[*/, k, label, 16, VqTc_EncodeImage_distance);
		//k-means@(,,k-means++@)̌JԂsB
		// - ɒ[ɎďIȂP[X̋~ς̂߂ɁA'x̉'őł؂鎖ɂB
		//   'x̉'̓K؂Ȓl߂@͖AƂ肠L̓Ă݂B
		//   ~1. xNgAJԂ񐔂̏ƂB
		//   x̕tւP[Xz肵ꍇAxNgJԂ񐔂̏ƂĂlB
		//   ɂ́Axtւxēxtւ\L̂ŁAxNg񐔂Ď\LB
		//   ۂɎĂ݂A傫ȉ摜(xNg)ŁAڕWNX^ꍇA܂łtւȂB
		//   ̏ꍇAJԂ񐔂̏(xNg)傫̂ŁAʂɒԂĂ܂B
		//   ]āÄĂ͗ǂȂB
		//   Z2. ڕWNX^AJԂ񐔂̏ƂB
		//   ɍ͖̂A̕@̕ǂƎvB
		//   Oq̒ʂAۂɂ͖ڕWNX^xXL̂ŁÄĂ͂̋tɂȂĂ܂Ă̂A
		//   肭ꍇ͏\xŎ鎖̂ŁA𒴂đł؂ƂĂł؂肪߂ƌ͖낤B
		//   ۂ̏AɎԂ|̂k_means_clustering_init()łAk_means_clustering_step()񓖂̎Ԃ͂قǒȂB
		//   ڕWNX^̏́AX256ł邩AIȎԓɏI邾낤B	{{2016/12/25RgǋL:̐̏A25665536ɕύX܂B}}
		//   (k_means_clustering_init()͒Ԋ|̂ŁAŜ̎Ԃ͂͂蒷̂c)
		// * Tue Dec 20 21:28:56 JST 2016 Naoyuki Sawa
		// - k-means@(,,k-means++@)̌JԂ́Ał؂ύX܂B
		//   L̈1,2́AۂɎgĂ݂AǂAʂɒpĂ܂āAςǂȂƎv܂B
		//   Ax蓖Ăo(=Ԃ[v)ł؂̂K؂ƎvAύX鎖ɂ܂B
		// - x蓖Ă̏ԂL^@ƂẮASHA-1gp܂B
		//   ɂ́Alabel[]̂܂ܓo^ׂȂ̂łAߖ̂߂ɁASHA-1gɂ܂B
		//   SHA-1łA܂AՓ˂鎖͖Ǝv܂B
//{{2016/12/20ύX:k-means@(,,k-means++@)̌JԂ́Ał؂ύX܂B
//	    //{{ǂ炩IB
//	    //	for(iTry = 0; iTry < n; iTry++) {	//~1
//		for(iTry = 0; iTry < k; iTry++) {	//Z2
//	    //}}ǂ炩IB
//2016/12/20ύX:k-means@(,,k-means++@)̌JԂ́Ał؂ύX܂B
		for(;;) {
//}}2016/12/20ύX:k-means@(,,k-means++@)̌JԂ́Ał؂ύX܂B
			//NX^S߂B
			for(j = 0; j < k; j++) {				//eNX^ɂāc
				memset(sum, 0, sizeof sum);
				memset(cnt, 0, sizeof cnt);
				for(i = 0; i < n; i++) {			//exNgɂāc
					if(label[i] == j) {			//̃xNgÃNX^ɑȂ΁c
						for(l = 0; l < 16; l++) {	//esNZɂāc
							c = vector[(i * 16) + l];	//̃xNǵAsNZ擾B
							if(c != 4) {		//łȂ΁c
								sum[l] += c;	//̈ʒúAFZB
								cnt[l]++;	//̈ʒúAłȂsNZ̐𑝂₷B
							}
						}
					}
				}
				for(l = 0; l < 16; l++) {			//esNZɂāc
					if(cnt[l]) {				//̈ʒúAłȂsNZL΁c
						center[(j * 16) + l] = lround((double)sum[l] / (double)cnt[l]);	//F̕ς߂B
					} else {				//̈ʒúAłȂsNZ΁c
						center[(j * 16) + l] = 4;	//ƂB
					}
				}
			}
			//k-means@(,,k-means++@)̌JԂ1XebvsB
			//ł߂NX^̕tւȂ(͏Ȃ)AIB
#ifdef  VQTC_PRINT_PROGRESS
			newMsgLen = fprintf(stderr, "\rVqTc_EncodeImage: calling k_means_clustering_step");
			if(oldMsgLen > newMsgLen) { fprintf(stderr, "%*s", oldMsgLen - newMsgLen, ""); } oldMsgLen = newMsgLen;
#endif//VQTC_PRINT_PROGRESS
			relabel = k_means_clustering_step(vector, n, center, k, label, 16, VqTc_EncodeImage_distance);
#ifdef  VQTC_PRINT_PROGRESS
			newMsgLen = fprintf(stderr, "\rVqTc_EncodeImage: k_means_clustering_step returns %d", relabel);
			if(oldMsgLen > newMsgLen) { fprintf(stderr, "%*s", oldMsgLen - newMsgLen, ""); } oldMsgLen = newMsgLen;
#endif//VQTC_PRINT_PROGRESS
			if(relabel <= 0/**/) { break; }
//{{2016/12/20ǉ:k-means@(,,k-means++@)̌JԂ́Ał؂ύX܂B
			sha1_digest(sha1, label, n * sizeof(int));				//label[]SHA-1߂B{label[]̂܂ܓo^ׂȂ̂Aߖ̂߂SHA-1gɂB܂Փ˂鎖͖낤B
			if(ght_insert(ht_sha1, sha1/*_~[*/, 20/*SHA-1*/, sha1)) { break; }	//label[]SHA-1o^Bɓo^Ă(Ԃ2ڂɏo)Aght_insert()sĔ0̒lԂ̂ŁA[v𔲂B
//}}2016/12/20ǉ:k-means@(,,k-means++@)̌JԂ́Ał؂ύX܂B
		}
#ifdef  VQTC_PRINT_PROGRESS
		newMsgLen = fprintf(stderr, "\rVqTc_EncodeImage: k_means_clustering_step done");
		if(oldMsgLen > newMsgLen) { fprintf(stderr, "%*s", oldMsgLen - newMsgLen, ""); } putc('\n', stderr); oldMsgLen = 0;
#endif//VQTC_PRINT_PROGRESS
//{{2016/12/20ǉ:k-means@(,,k-means++@)̌JԂ́Ał؂ύX܂B
		ght_finalize(ht_sha1);	//nbVe[u폜B
//}}2016/12/20ǉ:k-means@(,,k-means++@)̌JԂ́Ał؂ύX܂B
	}
	//ۂɎgpĂNX^ɕU蒼AɁÃNX^̃R[hubN(Z)kĊi[B
	{
		bits1 = VqTc_CalculateCodeBits(k);				//̕rbg߂B
		k = 0;								//0U蒼B
		for(i = 0; i < n; i++) {					//exNgɂāc
			l = label[i];						//̃xNgNX^ԍ擾B
			if(label[i] != -1) {					//̃xNgɏĂȂ΁c
				for(j = i; j < n; j++) {			//̃xNggAŌ̃xNg܂Łc
					if(label[j] == l) {			//̃xNgANX^ԍɑĂc
						label[j] = -1;			//̃xNgɏꂽ}[NB
						bitarray_lsb1st_set(code, j * bits1, bits1, k);	//U蒼i[B	ł͉̕rbgPʂŊi[ĂA̐܂ŁArbgɍ킹ċlߒB
					}
				}
				VqTc_EncodeCell(&center[l * 16], &((unsigned char*)codebook)[k * 5]);	//̃xNg̔񈳏k16sNZA5oCg̈kf[^ɕϊĊi[B
				k++;						//̒l𑝂₷B
			}
		}
		bits2 = VqTc_CalculateCodeBits(k);				//rbg߂B
		for(i = 0; i < n; i++) {					//
			j = bitarray_lsb1st_get(code, i * bits1, bits1);	//̃rbgɍ킹āAlߒB
			    bitarray_lsb1st_set(code, i * bits2, bits2, j);	//
		}								//
	}
	//B
	{
		free(vector);	//xNg̔z̃B
		free(center);	//NX^S̔z̃B
		free(label);	//x̔z̃B
	}
	//̐ԂB
	return k;
}
/*--------------------------------------------------------------------------*/
//摜WJB
//[in]
//	image		摜i[obt@			(out)		0=,1=,2=,3=,4=
//	w		摜̕				(in)		1`BkƓlw肵ĉB
//	h		摜̍				(in)		1`BkƓlw肵ĉB
//	stride		摜1C̃oCg		(in)		w`BkƈقȂlł\܂B
//	codebook	R[hubN				(in)		VqTc_EncodeImage()o͂R[hubÑf[^w肵ĉB
//	k		̐				(in)		VqTc_EncodeImage()̖߂lw肵ĉB
//	code		z				(in)		VqTc_EncodeImage()o͂z̃f[^w肵ĉB
void VqTc_DecodeImage(void* image/*[stride*h]*/, int w, int h, int stride, const void* codebook/*[k*5]*/, int k, const void* code/*[VqTc_CalculateCodeBytes(w,h,k)]*/) {
	int c, i, x, y, col, row, cols, rows, bits;
	unsigned char cell[16];
	if((w < 1) || (h < 1)) { DIE(); }	//̉摜w肵Ă͂ȂB
//{{2016/12/25ύX:̐̏A25665536ɕύX܂B
//	if((k < 1) || (k > 256)) { DIE(); }	//̐1`256͈̔͂łȂĂ͂ȂȂBkASŶ256𒴂镄̐ɂΉ\łAfR[_邽߂ɕ8rbgȉɐłB
//2016/12/25ύX:̐̏A25665536ɕύX܂B
	if((k < 1) || (k > 65536)) { DIE(); }	//̐1`65536͈̔͂łȂĂ͂ȂȂB
//}}2016/12/25ύX:̐̏A25665536ɕύX܂B
	cols = (w + 3) / 4;
	rows = (h + 3) / 4;
	bits = VqTc_CalculateCodeBits(k);
	for(col = 0; col < cols; col++) {
		for(row = 0; row < rows; row++) {
			i = bitarray_lsb1st_get(code, ((cols * row) + col) * bits, bits);
			if((unsigned)i >= (unsigned)k) { DIE(); }	//oO,,f[^j
			VqTc_DecodeCell(&((unsigned char*)codebook)[i * 5], cell);
			for(x = 0; x < 4; x++) {
				for(y = 0; y < 4; y++) {
					c = cell[(y * 4) + x];
					((unsigned char*)image)[(((row * 4) + y) * stride) + ((col * 4) + x)] = c;
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
#if 0
//gp:/clip/test.win/app.cppWndProc()ȉ̂悤ɒuĎsĉB(vGDI+)
#ifdef  __cplusplus
#ifdef  USE_GDIPLUS
static LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	static Bitmap *srcBmp, *dstBmp;
	static BitmapData data;
	switch(uMsg) {
	case WM_CREATE:
		{static const int MaxSize = 4096, K = 256/*1`65536͈̔͂ŒB2^NłȂĂǂB*/;
		static unsigned char image[MaxSize][MaxSize];
		//k
		srcBmp = new Bitmap(L"C:/usr/PIECE/docs/TUTORIAL/AYAKA/A.BMP"/*ύX*/); if(srcBmp->GetLastStatus()) { DIE(); }
		if(srcBmp->LockBits(NULL, ImageLockModeWrite, PixelFormat8bppIndexed, &data)) { DIE(); }
		void* codebook = malloc(K * 5); if(!codebook) { DIE(); }
		void* code = malloc(VqTc_CalculateCodeBytes((int)data.Width, (int)data.Height, K)); if(!code) { DIE(); }
		int k = VqTc_EncodeImage(data.Scan0, data.Width, data.Height, data.Stride, codebook, K, code);
		if(srcBmp->UnlockBits(&data)) { DIE(); }
		//WJeXg
		VqTc_DecodeImage(&image[0][0], data.Width, data.Height, MaxSize, codebook, k, code);
		free(codebook);
		free(code);
		dstBmp = new Bitmap(data.Width, data.Height); if(dstBmp->GetLastStatus()) { DIE(); }
		for(int x = 0; x < (int)data.Width; x++) {
			for(int y = 0; y < (int)data.Height; y++) {
				Color c; switch(image[y][x]) {
				case 3:  c = Color(255,255,255); break; //A.BMP~tȂ̂łtɂĂ܂B
				case 2:  c = Color(170,170,170); break; //{(:03:)łB
				case 1:  c = Color( 85, 85, 85); break; //
				case 0:  c = Color(  0,  0,  0); break; //
				default: c = Color(  0,255,  0); break;
				} if(dstBmp->SetPixel(x, y, c)) { DIE(); }
			}
		}}return 0;
	case WM_PAINT:
		{PAINTSTRUCT ps; HDC hDC = BeginPaint(hWnd, &ps);
		Graphics* graphics = new Graphics(hDC); if(graphics->GetLastStatus()) { DIE(); }
		if(graphics->Clear(Color.Red)) { DIE(); }
		graphics->DrawImage(srcBmp, 0, 0, data.Width, data.Height); //摜
		graphics->DrawImage(dstBmp, data.Width + 5, 0, data.Width, data.Height); //kēWJ摜
		delete graphics; EndPaint(hWnd, &ps);
		}return 0;
	case WM_DESTROY:
		delete srcBmp; delete dstBmp;
		PostQuitMessage(0);
		return 0;
	}
	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}
#endif//USE_GDIPLUS
#endif//__cplusplus
#endif
