/*
 *	clipttf.c
 *
 *	TrueType font
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Sun Nov 27 23:52:51 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- W[ɂ́AˑȂƂāATrueType_GetFontNameList()܂߂܂B
 *	  WindowsɈˑ鏈́ADxlibHelper.cppTrueType_AddFontFile(),TrueType_AddMemoryFont()ǉ܂B
 */
#include "clip.h"
/****************************************************************************
 *	
 ****************************************************************************/
//Ql:uMicrosoft Typography - The OpenType Font Filev(https://www.microsoft.com/typography/otspec/otff.htm)
struct TTCHeader {
	uint32_t		TTCTag;				//TrueType Collection ID string: 'ttcf'
	uint32_t		Version;			//Version of the TTC Header (1.0), 0x00010000 or (2.0), 0x00020000
	uint32_t		numFonts;			//Number of fonts in TTC
//	uint32_t		OffsetTable[numFonts];		//Array of offsets to the OffsetTable for each font from the beginning of the file
//	uint32_t		ulDsigTag;			//Tag indicating that a DSIG table exists, 0x44534947 ('DSIG') (null if no signature)			
//	uint32_t		ulDsigLength;			//The length (in bytes) of the DSIG table (null if no signature)					̃tB[h(Version=2.0)̏ꍇ݂܂B
//	uint32_t		ulDsigOffset;			//The offset (in bytes) of the DSIG table from the beginning of the TTC file (null if no signature)	
};
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
struct OffsetTable {
	uint32_t		sfntVersion;			//0x00010000 or 'OTTO' - see below.
	uint16_t		numTables;			//Number of tables.
	uint16_t		searchRange;			//(Maximum power of 2 <= numTables) x 16.
	uint16_t		entrySelector;			//Log2(maximum power of 2 <= numTables).
	uint16_t		rangeShift;			//NumTables x 16-searchRange.
};
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
struct TableRecord {
	uint32_t		tag;				//4-byte identifier.
	uint32_t		checkSum;			//CheckSum for this table.
	uint32_t		offset;				//Offset from beginning of TrueType font file.
	uint32_t		length;				//Length of this table.
};
/*--------------------------------------------------------------------------*/
//Ql:uMicrosoft Typography - name - Naming Tablev(https://www.microsoft.com/typography/otspec/name.htm)
struct NamingTable {
	uint16_t		format;				//Format selector (=0 or 1).
	uint16_t		count;				//Number of name records.
	uint16_t		stringOffset;			//Offset to start of string storage (from start of table).
//	NameRecord		nameRecord[count];		//The name records where count is the number of records.
//	uint16_t		langTagCount;			//Number of language-tag records.									̃tB[h(format=1)̏ꍇ݂܂B
//	LangTagRecord		langTagRecord[langTagCount];	//The language-tag records where langTagCount is the number of records.					
//	(Variable)						//Storage for the actual string data.
};
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
struct LangTagRecord {
	uint16_t		length;				//Language-tag string length (in bytes)
	uint16_t		offset;				//Language-tag string offset from start of storage area (in bytes).
};
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
struct NameRecord {
	uint16_t		platformID;			//Platform ID.
	uint16_t		encodingID;			//Platform-specific encoding ID.
	uint16_t		languageID;			//Language ID.
	uint16_t		nameID;				//Name ID.
	uint16_t		length;				//String length (in bytes).
	uint16_t		offset;				//String offset from start of storage area (in bytes).
};
/*--------------------------------------------------------------------------*/
static char* TrueType_GetFontNameList_subr(const unsigned char* data, int ttcOffset, char* out, char* const end) {
	struct OffsetTable offsetTable;
	memcpy(&offsetTable, &data[ttcOffset + 0], sizeof(struct OffsetTable));
	//                         ~~~~~~~~~~~Kv
	offsetTable.sfntVersion		= ntohl(offsetTable.sfntVersion);
	offsetTable.numTables		= ntohs(offsetTable.numTables);
	offsetTable.searchRange		= ntohs(offsetTable.searchRange);
	offsetTable.entrySelector	= ntohs(offsetTable.entrySelector);
	offsetTable.rangeShift		= ntohs(offsetTable.rangeShift);
	{
		int i;
		for(i = 0; i < offsetTable.numTables; i++) {
			struct TableRecord tableRecord;
			memcpy(&tableRecord, &data[ttcOffset + sizeof(struct OffsetTable) + (sizeof(struct TableRecord) * i)], sizeof(struct TableRecord));
			//                         ~~~~~~~~~~~Kv
		//sv	tableRecord.tag			= ntohl(tableRecord.tag);
			tableRecord.checkSum		= ntohl(tableRecord.checkSum);
			tableRecord.offset		= ntohl(tableRecord.offset);
			tableRecord.length		= ntohl(tableRecord.length);
			if(tableRecord.tag == MAKEFOURCC('n','a','m','e')) {
				struct NamingTable namingTable;
				memcpy(&namingTable, &data[/*ttcOffset +*/ tableRecord.offset], sizeof(struct NamingTable));
				//                         ~~~~~~~~~~~~~~~svB.ttct@C̏ꍇłATableRecord.offset́AetHg̐擪ʒũItZbgł͂ȂAt@C擪̃ItZbgĂ܂B
				namingTable.format		= ntohs(namingTable.format);
				namingTable.count		= ntohs(namingTable.count);
				namingTable.stringOffset	= ntohs(namingTable.stringOffset);
				{
					int i;
					for(i = 0; i < namingTable.count; i++) {
						struct NameRecord nameRecord;
						memcpy(&nameRecord, &data[/*ttcOffset +*/ (tableRecord.offset + sizeof(struct NamingTable)) + (sizeof(struct NameRecord) * i)], sizeof(struct NameRecord));
						//                        ~~~~~~~~~~~~~~~svB.ttct@C̏ꍇłATableRecord.offset́AetHg̐擪ʒũItZbgł͂ȂAt@C擪̃ItZbgĂ܂B
						nameRecord.platformID		= ntohs(nameRecord.platformID);
						nameRecord.encodingID		= ntohs(nameRecord.encodingID);
						nameRecord.languageID		= ntohs(nameRecord.languageID);
						nameRecord.nameID		= ntohs(nameRecord.nameID);
						nameRecord.length		= ntohs(nameRecord.length);
						nameRecord.offset		= ntohs(nameRecord.offset);
						//Name IDs
						//Code	Meaning
						//0		Copyright notice.
						//1		Font Family name. Up to four fonts can share the Font Family name, forming a font style linking group (regular, italic, bold, bold italic - as defined by OS/2.fsSelection bit settings).
						//2		Font Subfamily name. The Font Subfamily name distiguishes the font in a group with the same Font Family name (name ID 1). This is assumed to address style (italic, oblique) and weight (light, bold, black, etc.). A font with no particular differences in weight or style (e.g. medium weight, not italic and fsSelection bit 6 set) should have the string gRegularh stored in this position.
						//3		Unique font identifier.
						//4		Full font name; a combination of strings 1 and 2, or a similar human-readable variant. If string 2 is "Regular", it is sometimes omitted from name ID 4.
						//5		Version string. Should begin with the syntax 'Version <number>.<number>' (upper case, lower case, or mixed, with a space between gVersionh and the number). The string must contain a version number of the following form: one or more digits (0-9) of value less than 65,535, followed by a period, followed by one or more digits of value less than 65,535. Any character other than a digit will terminate the minor number. A character such as g;h is helpful to separate different pieces of version information. The first such match in the string can be used by installation software to compare font versions. Note that some installers may require the string to start with "Version", followed by a version number as above.
						//6		Postscript name for the font; Name ID 6 specifies a string which is used to invoke a PostScript language font that corresponds to this OpenType font. When translated to ASCII, the name string must be no longer than 63 characters and restricted to the printable ASCII subset, codes 33 - 126, except for the 10 characters '[', ']', '(', ')', '{', '}', '<', '>', '/', '%'. In a CFF OpenType font, there is no requirement that this name be the same as the font name in the CFFfs Name INDEX. Thus, the same CFF may be shared among multiple font components in a Font Collection. See the 'name' table section of Recommendations for OpenType fonts "" for additional information.
						//7		Trademark; this is used to save any trademark notice/information for this font. Such information should be based on legal advice. This is distinctly separate from the copyright.
						//8		Manufacturer Name.
						//9		Designer; name of the designer of the typeface.
						//10		Description; description of the typeface. Can contain revision information, usage recommendations, history, features, etc.
						//11		URL Vendor; URL of font vendor (with protocol, e.g., http://, ftp://). If a unique serial number is embedded in the URL, it can be used to register the font.
						//12		URL Designer; URL of typeface designer (with protocol, e.g., http://, ftp://).
						//13		License Description; description of how the font may be legally used, or different example scenarios for licensed use. This field should be written in plain language, not legalese.
						//14		License Info URL; URL where additional licensing information can be found.
						//15		Reserved.
						//16		Typographic Family name: The typographic family grouping doesn't impose any constraints on the number of faces within it, in contrast with the 4-style family grouping (ID 1), which is present both for historical reasons and to express style linking groups. If name ID 16 is absent, then name ID 1 is considered to be the typographic family name. (In earlier versions of the specification, name ID 16 was known as "Preferred Family".)
						//17		Typographic Subfamily name: This allows font designers to specify a subfamily name within the typographic family grouping. This string must be unique within a particular typographic family. If it is absent, then name ID 2 is considered to be the typographic subfamily name. (In earlier versions of the specification, name ID 17 was known as "Preferred Subfamily".)
						//18		Compatible Full (Macintosh only); On the Macintosh, the menu name is constructed using the FOND resource. This usually matches the Full Name. If you want the name of the font to appear differently than the Full Name, you can insert the Compatible Full Name in ID 18.
						//19		Sample text; This can be the font name, or any other text that the designer thinks is the best sample to display the font in.
						//20		PostScript CID findfont name; Its presence in a font means that the nameID 6 holds a PostScript font name that is meant to be used with the gcomposefonth invocation in order to invoke the font in a PostScript interpreter. See the definition of name ID 6. The value held in the name ID 20 string is interpreted as a PostScript font name that is meant to be used with the gfindfonth invocation, in order to invoke the font in a PostScript interpreter. When translated to ASCII, this name string must be restricted to the printable ASCII subset, codes 33 through 126, except for the 10 characters: '[', ']', '(', ')', '{', '}', '<', '>', '/', '%'. See "Recommendations for OTF fonts" for additional information.
						//21		WWS Family Name. Used to provide a WWS-conformant family name in case the entries for IDs 16 and 17 do not conform to the WWS model. (That is, in case the entry for ID 17 includes qualifiers for some attribute other than weight, width or slope.) If bit 8 of the fsSelection field is set, a WWS Family Name entry should not be needed and should not be included. Conversely, if an entry for this ID is include, bit 8 should not be set. (See OS/2 'fsSelection' field for details.) Examples of name ID 21: gMinion Pro Captionh and gMinion Pro Displayh. (Name ID 16 would be gMinion Proh for these examples.)
						//22		WWS Subfamily Name. Used in conjunction with ID 21, this ID provides a WWS-conformant subfamily name (reflecting only weight, width and slope attributes) in case the entries for IDs 16 and 17 do not conform to the WWS model. As in the case of ID 21, use of this ID should correlate inversely with bit 8 of the fsSelection field being set. Examples of name ID 22: gSemibold Italich, gBold Condensedh. (Name ID 17 could be gSemibold Italic Captionh, or gBold Condensed Displayh, for example.)
						//23		Light Backgound Palette. This ID, if used in the CPAL tablefs Palette Labels Array, specifies that the corresponding color palette in the CPAL table is appropriate to use with the font when displaying it on a light background such as white. Name table strings for this ID specify the user interface strings associated with this palette.
						//24		Dark Backgound Palette. This ID, if used in the CPAL tablefs Palette Labels Array, specifies that the corresponding color palette in the CPAL table is appropriate to use with the font when displaying it on a dark background such as black. Name table strings for this ID specify the user interface strings associated with this palette.
						//25		Variations PostScript Name Prefix. If present in a variable font, it may be used as the family prefix in the PostScript Name Generation for Variation Fonts algorithm. The character set is restricted to ASCII-range uppercase Latin letters, lowercase Latin letters, and digits. All name strings for name ID 25 within a font, when converted to ASCII, must be identical. See Adobe Technical Note #5902: gPostScript Name Generation for Variation Fontsh for reasons to include name ID 25 in a font, and for examples. For general information on OpenType Font Variations, see the chapter, OpenType Font Variations Overview.
						if(nameRecord.nameID == 1/*Font Family name*/) {
							//Platform IDs, Platform-specific encoding IDs and Language IDs
							//Platform ID	Platform name		Platform-specific encoding IDs	Language IDs
							//0		Unicode			Various				Various
							//1		Macintosh		Script manager code		Various
							//2		ISO [deprecated]	ISO encoding [deprecated]	None
							//3		Windows			Windows encoding		Various
							//4		Custom			Custom				None
							if(nameRecord.platformID == 3/*Windows*/) {
								const char* p = &data[/*ttcOffset +*/ (tableRecord.offset + namingTable.stringOffset) + nameRecord.offset];	//UTF-16BE	UnicodeUTF-16LEł͂ȂUTF-16BEŊi[Ă܂Bv!!
								//                    ~~~~~~~~~~~~~~~svB.ttct@C̏ꍇłATableRecord.offset́AetHg̐擪ʒũItZbgł͂ȂAt@C擪̃ItZbgĂ܂B
								//Windows platform-specific encoding IDs (platform ID= 3) 
								//Platform ID	Encoding ID	Description
								//3		0		Symbol
								//3		1		Unicode BMP (UCS-2)
								//3		2		ShiftJIS
								//3		3		PRC
								//3		4		Big5
								//3		5		Wansung
								//3		6		Johab
								//3		7		Reserved
								//3		8		Reserved
								//3		9		Reserved
								//3		10		Unicode UCS-4
								//--------------------------------------------------------------------------------------------------------------------------------------------------------------
								// * Sun Nov 27 23:52:51 JST 2016 Naoyuki Sawa
								// - {́Ae{platformID,encodingID}̑gݍ킹ɂďׂȂ̂łÁA{Windows,Unicode BMP (UCS-2)}̑gݍ킹鎖ɂ܂B
								//   {Windows,Unicode BMP (UCS-2)}ȊȎgݍ킹̏ꍇɁAǂ̂悤Ȍ`ŃtHg̕񂪊i[Ă邩Adl܂悭łĂȂłB
								//   ̃tHgt@CŎƂÃt@C{Windows,Unicode BMP (UCS-2)}ł͊i[Ă悤Ȃ̂ŁAꂾł[Ǝv܂B
								//   ̑ɂA{Macintosh,English}(ASCII`?)A{Windows,Unicode UCS-4}(UTF-32BE`)łi[Ă鎖L悤łÁA鎖ɂ܂B
								// - ƎvĂ̂łAɎAV{̃tHg̏ꍇA{Windows,Symbol}i[ĂȂL̂ŁASymbol鎖ɂ܂B
								//   {{Windows,ShiftJIS}ɂΉ̂łA{Windows,ShiftJIS}i[Ăt@C܂t炸A؏oȂ̂ŁAΉ̂܂܂ɂĂ܂B
								//   AuWindows platform-specific encoding IDs (platform ID= 3)v(https://www.microsoft.com/typography/otspec/name.htm#enc3)ɂƁA
								//   When building a Unicode font for Windows, the platform ID should be 3 and the encoding ID should be 1.	
								//   When building a symbol font for Windows, the platform ID should be 3 and the encoding ID should be 0.	
								//   When building a font that will be used on the Macintosh, the platform ID should be 1 and the encoding ID should be 0.
								//   ƏĂ̂ŁAƁA{Windows,Unicode BMP (UCS-2)}{Windows,Symbol}ŏ[Ȃ̂m܂B
								//--------------------------------------------------------------------------------------------------------------------------------------------------------------
								switch(nameRecord.encodingID) {
								case 0:	//Symbol
								case 1:	//Unicode BMP (UCS-2)
									{
										int i;
										for(i = 0; i < nameRecord.length; i += sizeof(wchar_t)) {
											int c = BEHALF(p);		//UTF-16BEUTF-16LE
											c = UnicodeToShiftJisChr(c);	//UTF-16LEShiftJIS
											if(c > UCHAR_MAX) { if(out < end) { *out = c >> 8; } out++; }
											                    if(out < end) { *out = c;      } out++;
											p += sizeof(wchar_t);
										}
										if(out < end) { *out = '\0'; } out++;	//̏I[
									}
									break;
								}
							}
						}
					}
				}
			}
		}
	}
	return out;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int TrueType_GetFontNameList(const void* _data, char* buf/*[cap]*/, int cap) {	//(buf=NULL,cap=0)
	const unsigned char* const data = _data;
	char*       out = buf;
	char* const end = buf + cap;
	{
		//.ttct@CƉ肵āAwb_ǂݍł݂B
		struct TTCHeader ttcHeader;
		memcpy(&ttcHeader, &data[0], sizeof(struct TTCHeader));
	//sv	ttcHeader.TTCTag		= ntohl(ttcHeader.TTCTag);
		ttcHeader.Version		= ntohl(ttcHeader.Version);
		ttcHeader.numFonts		= ntohl(ttcHeader.numFonts);
		//.ttct@Cꍇc
		if(ttcHeader.TTCTag == MAKEFOURCC('t','t','c','f')) {
			const uint32_t* OffsetTable = (const uint32_t*)&data[sizeof(struct TTCHeader)];
			int i;
			for(i = 0; i < (int)ttcHeader.numFonts; i++) {
				int ttcOffset = ntohl(OffsetTable[i]);
				out = TrueType_GetFontNameList_subr(data, ttcOffset, out, end);
			}
		//.ttft@Cꍇc
		} else {
			out = TrueType_GetFontNameList_subr(data, 0/*ttcOffset*/, out, end);
		}
	}
	if(out == buf) { DIE(); }	//tHg擾oĂȂ΁AG[I鎖ɂBtHgȂƂL鎖ۏ؂AAvP[V̎ȒPɂȂƎvłB
	if(out <= end) { *out = '\0'; } out++;	//Xg̏I[
	return out - buf;
}
