/*	
 *	cliprnd.c
 *
 *	
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Tue Jan 06 21:26:41 JST 2015 Naoyuki Sawa
 *	- VK쐬B
 *	- ֘A̐錾ƎAclipmisc.*cliprnd.*֕܂B
 *	  gppx͍̂ŁAʂȃNh߂ƌAW[ĕՂ邽߂łB
 */
#include "clip.h"

/*****************************************************************************
 *	
 *****************************************************************************/

#ifndef PIECE
//int
//rnd8(int* seed)
//{
//	/* 8rbg(wZ80}V`̏x) */
//	*seed = *seed * 5 + 0x3711;
//	return (*seed >> 8) & 0xff;
//}
//* Thu Jul 06 11:48:53 JST 2006 Naoyuki Sawa
//- Xorshift@ɂ32bit[֐(rnd32())V݂ƂɔA8bit[`@Xorshift@ɕύX܂B
//  `@ɖ肪L킯ł͂܂񂪁AŜ̓̂߂ƁAXorshift@̕ǂ[(?)ƎvłB
int
rnd8(int* seed)
{
	/* 32bit[l̒8bitA8bit[lƂĕԂ܂B
	 * - 傫ȃrbg̋[lAȃrbg̋[loꍇA
	 *   ŏʂŉʂoAoǂƂĂ܂B
	 *
	 *	++++-++++-++++-++++-++++-++++-++++-++++-< rnd32()
	 *	|||| |||| |||| |||| |||| |||| |||| ||||
	 *	1111 1111 1111 1111 0000 0000 0000 0000
	 *	fedc ba98 7654 3210 fedc ba98 7654 3210
	 *	               |||| ||||
	 *	               ++++-++++----------------> rnd8()
	 */
	return (unsigned char)(rnd32(seed) >> ((32 - 8) / 2));
}
//int
//rnd16(int* seed)
//{
//	/* 16rbg(VisualC++ 6.0 \VC98\CRT\SRC\RAND.C Qlɂ܂) */
//	*seed = *seed * 214013 + 2531011;
//	return (*seed >> 16) & 0xffff;
//}
//* Thu Jul 06 11:48:53 JST 2006 Naoyuki Sawa
//- Xorshift@ɂ32bit[֐(rnd32())V݂ƂɔA16bit[`@Xorshift@ɕύX܂B
//  `@ɖ肪L킯ł͂܂񂪁AŜ̓̂߂ƁAXorshift@̕ǂ[(?)ƎvłB
int
rnd16(int* seed)
{
	/* 32bit[l̒16bitA16bit[lƂĕԂ܂B
	 * - 傫ȃrbg̋[lAȃrbg̋[loꍇA
	 *   ŏʂŉʂoAoǂƂĂ܂B
	 *
	 *	++++-++++-++++-++++-++++-++++-++++-++++-< rnd32()
	 *	|||| |||| |||| |||| |||| |||| |||| ||||
	 *	1111 1111 1111 1111 0000 0000 0000 0000
	 *	fedc ba98 7654 3210 fedc ba98 7654 3210
	 *	          |||| |||| |||| ||||
	 *	          ++++-++++-++++-++++-----------> rnd16()
	 */
	return (unsigned short)(rnd32(seed) >> ((32 - 16) / 2));
}
/* * Thu Jul 06 11:48:53 JST 2006 Naoyuki Sawa
 * - 32bit[֐(rnd32())ǉ܂B
 *   32bit^ASYƂāAuXorshift RNGsv̗p܂B(ȉAXorshift@ƌĂԂƂɂ܂)
 *   Xorshift@̎Auclip\keep\Xorshift RNGs.zipvɕۑ܂B
 * - rnd16()֐ŗpĂ`@̂܂܎gA16bitEVtgɂ̂܂32bit[ƂĕԂ@\łA
 *   ̕@ł́A/݂ɐĂ܂ƓAǂȂ[łƔf̂ŁAXorshift@gƂɂ܂B
 */
int
rnd32(int* seed)
{
#define MAGIC_NUMBER 2463534242u /* 0ȊOȂΉł */

	/* O̗lo܂B
	 * - ȉ̃VtgŹAZpVtgłȂ_VtgōsKv̂ŁAlƂĎo܂B
	 *   ֐C^[tFCX(seed)́Ap̎gՂlāAtlւ̃|C^ƂĂ܂B
	 */
	unsigned y = *seed;

	/* O̗l0Ȃ΁A0ȊO̓KȒlɒu܂B
	 * - Xorshift@̗́AMn񗐐ɐiĂāA0𐶐ł܂B
	 *   32rbg𐶐ꍇÁu2^32vłȂu(2^32)-1vłB
	 *   Ȃ킿A0x00000000`0xFFFFFFFF͈̗̔͂𐶐̂ł͂ȂA0x00000001`0xFFFFFFFF͈̗̔͂𐶐܂B
	 *   0܂߂ɂ́A̓KȈʒuɁAI0ޕKv܂B
	 * - MAGIC_NUMBER̒lɈӖ͖A0ȊO̒lȂΉł\܂B
	 *   Xorshift@̌T̃TvR[hA܂܏V[hlƂāu2463534242vgĂ̂ŁAɂȂ񂾂łB
	 *   V[hlA0ȊOȂΉłǂAXorshift@̌T̃TvR[hɂĂAu2463534242vɈӖ͂܂B
	 * - {֐́AXorshift@̌T̃TvR[hɎāA0ɂΉĂ̂ŁAV[hlƂ0w肷邱Ƃ\łB
	 *   MAGIC_NUMBERɂ́A0w肷邱Ƃ͕słB
	 */
	if(y == 0) y = MAGIC_NUMBER;

	/* Xorshift@gāAO̗lA̗l𐶐܂B
	 * - Vtg[13,17,5]̑gݍ킹́AXorshift@̌T̃TvR[hQlɂ܂B
	 *   Xorshift@̌Tɂ́AȊOɂAlXȃVtg̑gݍ킹ڂĂ܂B
	 */
	y ^= (y << 13);
	y ^= (y >> 17);
	y ^= (y <<  5);

	/* ̗l̒lɂȂȂOɁAI0݂܂B
	 * - Xorshift@0𐶐łȂ̂ŁA̓KȈʒuɁAI0ޕKv܂B
	 *   q̃RgQƂĂB
	 */
	if(y == MAGIC_NUMBER) y = 0;

	/* ̗lA̗V[hƂĊi[܂B
	 * - ֐̖߂lł闐lƊi[闐V[h͓lȂ̂ŁAseed𖳂Ƃ\łA
	 *   Ƃ΁Aȉ̂悤ȌĂяołƕ֗Ȃ̂ŁAseed݂Ă܂B
	 *
	 *	retval = rnd32(&seed) % 100; // 0`99̗l𐶐
	 *
	 *   ܂AA^ɗpASYύXA߂lƗV[hłȂȂꍇɂΉł܂B
	 *   ۂɍA^ASYA`@Xorshift@ɕύX킯łA֐C^[tFCXɕῶ܂B
	 * - rnd32()̖߂l(int)Ȃ̂ŁA0x00000000`0xFFFFFFFFł͂ȂA-0x80000000`0x7FFFFFFFƂȂ܂B
	 *   rnd8()̖߂l0x00`0xFFł邱ƂArnd16()̖߂l0x0000`0xFFFFł邱ƂɊrׂƁAѐɌ܂B
	 *   łĂ̎dlƂŔArnd8()rnd16()߂l(int)łArnd32()߂ľ^ς̂łB
	 *   0x00000000`0xFFFFFFFF̗lKvȂ΁AĂяoɂĖ߂l(unsigned)ɃLXgĂB
	 *   I(unsigned)ւ̃LXgvAڂŔȂ(unsigned)lɗ^e̓`dASƍl܂B
	 */
	return (*seed = y);

#undef MAGIC_NUMBER
}
int
rnd8_range(int* seed, int a, int b)
{
	return rnd8(seed) % (b - a) + a;
}
int
rnd16_range(int* seed, int a, int b)
{
	return rnd16(seed) % (b - a) + a;
}
int
rnd32_range(int* seed, int a, int b)
{
	return (unsigned)rnd32(seed) % (unsigned)(b - a) + a;
	//     ~~~~~~~~~~Kv!!~~~~~~~~~~
}
#else /*PIECE*/
asm("
		.code
		.align		1
		.global		rnd8
		.global		rnd16
		.global		rnd32
		.global		rnd8_range
		.global		rnd16_range
		.global		rnd32_range
		;//-------------------------------------;//
rnd8:
		call		rnd16			;// %r10 := y = rnd32(seed) >> 12
		sra		%r10, 4			;//           = rnd16(seed) >> 4
		ret.d
		ld.ub		%r10, %r10		;// return (unsigned char)y		*delay*
		;//-------------------------------------;//
rnd16:
		call		rnd32			;// %r10 := y = rnd32(seed) >> 8
		sra		%r10, 8
		ret.d
		ld.uh		%r10, %r10		;// return (unsigned short)y		*delay*
		;//-------------------------------------;//
rnd32:
		ld.w		%r10, [%r12]		;// %r10 := y = *seed
		xld.w		%r11, 2463534242	;// %r11 := MAGIC_NUMBER		*anti-interlock*
		cmp		%r10, 0			;// if(y == 0) {
		jrne		2			;//    y  = MAGIC_NUMBER
		 ld.w		%r10, %r11		;// }
		;//
		ld.w		%r9, %r10		;// %r9  :=       y
		xsll		%r9, 13			;// %r9  :=      (y << 13)
		xor		%r10, %r9		;// %r10 := y ^= (y << 13)
		;//
		ld.w		%r9, %r10		;// %r9  :=       y
		xsrl		%r9, 17			;// %r9  :=      (y >> 17)
		xor		%r10, %r9		;// %r10 := y ^= (y >> 17)
		;//
		ld.w		%r9, %r10		;// %r9  :=       y
		xsll		%r9, 5			;// %r9  :=      (y <<  5)
		xor		%r10, %r9		;// %r10 := y ^= (y <<  5)
		;//
		cmp		%r10, %r11		;// if(y == MAGIC_NUMBER) {
		jrne		2			;//    y  = 0
		 ld.w		%r10, 0			;// }
		;//
		ld.w		[%r12], %r10		;// *seed = y
		ret					;// return  y
		;//-------------------------------------;//
rnd8_range:
		ld.w		%r15, %r13		;// %r15 :=                                             a
		ld.w		%r13, %r14		;// %r13 :=                                    b
		call.d		rnd8			;// %r10 :=            rnd8(seed)				AZuł rnd8 %r9,%r10,%r11,%psr ȊOj󂵂܂B
		sub		%r13, %r15		;// %r13 :=                                   (b - a)		*delay*
		;//
		xcall.d		__modsi3		;// %r10 :=            rnd8(seed) %           (b - a)		CLiPł__modsi3 %r9,%r10,%alr,%ahr,%psr ȊOj󂵂܂B(clipidiv.s Q)
		ld.w		%r12, %r10		;// %r12 :=            rnd8(seed)				*delay*
		;//
		ret.d
		add		%r10, %r15		;// %r10 :=            rnd8(seed) %           (b - a) + a	*delay*
		;//-------------------------------------;//
rnd16_range:
		ld.w		%r15, %r13		;// %r15 :=                                             a
		ld.w		%r13, %r14		;// %r13 :=                                    b
		call.d		rnd16			;// %r10 :=           rnd16(seed)				AZułrnd16 %r9,%r10,%r11,%psr ȊOj󂵂܂B
		sub		%r13, %r15		;// %r13 :=                                   (b - a)		*delay*
		;//
		xcall.d		__modsi3		;// %r10 :=           rnd16(seed) %           (b - a)		CLiPł__modsi3 %r9,%r10,%alr,%ahr,%psr ȊOj󂵂܂B(clipidiv.s Q)
		ld.w		%r12, %r10		;// %r12 :=           rnd16(seed)				*delay*
		;//
		ret.d
		add		%r10, %r15		;// %r10 :=           rnd16(seed) %           (b - a) + a	*delay*
		;//-------------------------------------;//
rnd32_range:
		ld.w		%r15, %r13		;// %r15 :=                                             a
		ld.w		%r13, %r14		;// %r13 :=                                    b
		call.d		rnd32			;// %r10 :=           rnd32(seed)				AZułrnd32 %r9,%r10,%r11,%psr ȊOj󂵂܂B
		sub		%r13, %r15		;// %r13 :=                                   (b - a)		*delay*
		;//
		xcall.d		__umodsi3		;// %r10 := (unsigned)rnd32(seed) % (unsigned)(b - a)		CLiPł__modsi3 %r9,%r10,%alr,%ahr,%psr ȊOj󂵂܂B(clipidiv.s Q)
		ld.w		%r12, %r10		;// %r12 :=           rnd32(seed)				*delay*
		;//
		ret.d
		add		%r10, %r15		;// %r10 := (unsigned)rnd32(seed) % (unsigned)(b - a) + a	*delay*
");
#endif/*PIECE*/

//{{2010/10/21:Eȃɔ폜
//void
//shuffle(void* base, int num, int width, int* seed)
//{
//	int i;
//	int c;
//	int i_dst;
//	int i_src;
//	unsigned char* p_dst;
//	unsigned char* p_src;
//
//	///* 0vf̔z͕słB܂A
//	// * ݂̎16bit𗘗pĂ邽߁A65536vf߂̔zɂ͖ΉłB
//	// */
//	//if((num < 0) || (num > (1<<16))) {
//	//	DIE();
//	//}
//	//2006/07/06 num͈̔͌폜܂B
//	// * Thu Jul 06 11:48:53 JST 2006 Naoyuki Sawa
//	// - rnd32()̐V݂ɔA16bit32bit𗘗p悤ύX܂B
//	//   ̕ύXɂA65536vfȏ̔zVbtłȂȂ܂B
//	//   (num < 0)͈݂̐܂AȂ̂ŁAȗ邱Ƃɂ܂B
//
//	/* 擪vfŏIvf܂ŏԂ... */
//	p_dst = base;
//	for(i_dst = 0; i_dst < num; i_dst++) {
//
//		/* ̗vf肵܂B */
//		//i_src = RND16_RANGE(*seed, i_dst, num);
//		//* Thu Jul 06 11:48:53 JST 2006 Naoyuki Sawa
//		//- rnd32()̐V݂ɔA16bit32bit𗘗p悤ύX܂B
//		//  ̕ύXɂA65536vfȏ̔zVbtłȂȂ܂B
//		i_src = RND32_RANGE(*seed, i_dst, num);
//		p_src = (unsigned char*)base + width * i_src;
//
//		/* 1oCgÂ܂B */
//		for(i = 0; i < width; i++) {
//			c = *p_dst;
//			    *p_dst = *p_src;
//			             *p_src = c;
//			p_dst++;
//			p_src++;
//		}
//	}
//}
//}}2010/10/21:Eȃɔ폜
// * Thu Oct 21 03:01:12 JST 2010 Naoyuki Sawa
// - shuffle()֐AEȃ܂B
//   ̌ʂ́Avf32768int^zVtꍇA10%̍łB
//   ȃ̌ʂ́A4oCgȂłB
void
shuffle(void* base, int num, int width, int* seed)
{
	int i;
	int c;
	unsigned char* p_dst;
	unsigned char* p_src;

	/* vf́Az̐擪vfAz(ŏIvf-1)܂ŁB */
	p_dst = base;
	while(num > 1) {
		/* vf́AvfAz̍ŏIvf܂ŁB */
		p_src = &p_dst[((unsigned)rnd32(seed) % num) * width];
		//              ~~~~~~~~~~Kv!
		/* vfƁAvfAꕶÂ܂B */
		for(i = 0; i < width; i++) {
			c = *p_dst;
			    *p_dst = *p_src;
			             *p_src = c;
			p_dst++;
			p_src++;
		}
		num--;
	}
}

/*****************************************************************************
 *	[eBeBF͈͗
 *****************************************************************************/

#ifndef PIECE
unsigned minimum_mask_greater_than_or_equal_to(unsigned x) {
	unsigned y = 0;
	while(y < x) {
		y = (y << 1) | 1;
	}
	return y;
}
unsigned random_value_less_than_or_equal_to(unsigned x, unsigned (*generator)(void* param), void* param) {
	unsigned mask = minimum_mask_greater_than_or_equal_to(x);
	unsigned y;
	do {
		y = (*generator)(param) & mask;
	} while(y > x);
	return  y;
}
#else /*PIECE*/
asm("
		.align		1
		.global		minimum_mask_greater_than_or_equal_to
		.global		random_value_less_than_or_equal_to
		;//-----------------------------------------------------;//
minimum_mask_greater_than_or_equal_to:
		;//							;// %r12  := x     
		ld.w		%r10, 0					;// %r10  := y = 0             
		;//							;// do {                                       
		cmp		%r10, %r12				;//     %psr[C] := c = (y < x) ? 1 : 0             
		jrult.d		-1					;//                                
		adc		%r10, %r10				;//     %psr[C] := y[31], %r10 := (y[30:0]<<1) | c 		*delay*
		;//							;// } while(c == 1)  
		adc		%r10, %r8				;// %r10 := (y[30:0]<<1) | y[31] 
		ret.d							;// return   y[31:0]
		rr		%r10, 1					;// %r10 :=  y[31:0]						*delay*
		;//-----------------------------------------------------;//
random_value_less_than_or_equal_to:
		pushn		%r3
		ld.w		%r0, %r12				;// %r0  := x
		ld.w		%r1, %r13				;// %r1  := generator
		call.d		minimum_mask_greater_than_or_equal_to	;// %r10 := mask = minimum_mask_greater_than_or_equal_to(x)
		ld.w		%r2, %r14				;// %r2  := param						*delay*
		ld.w		%r3, %r10				;// %r3  := mask
		;//							;// do {
		call.d		%r1					;//   %r10 := y = (*generator)(param)
		 ld.w		%r12, %r2				;//   %r12 :=                  param				*delay*
		 and		%r10, %r3				;//   %r10 := y &= mask
		 cmp		%r10, %r0				;// } while(y > x)
		jrugt		-4
		popn		%r3
		ret
		;//-----------------------------------------------------;//
");
#endif/*PIECE*/
